// services/viz/public/mojom/compositing/surface_range.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_RANGE_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_RANGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/surface_range.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"







namespace viz::mojom {
class SurfaceRangeDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::SurfaceRangeDataView> {
  using Data = ::viz::mojom::internal::SurfaceRange_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class SurfaceRangeDataView {
 public:
  SurfaceRangeDataView() = default;

  SurfaceRangeDataView(
      internal::SurfaceRange_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStartDataView(
      ::viz::mojom::SurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::SurfaceIdDataView, UserType>(),
    "Attempting to read the optional `start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStart` instead "
    "of `ReadStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->start.Get();
    return mojo::internal::Deserialize<::viz::mojom::SurfaceIdDataView>(
        pointer, output, message_);
  }
  inline void GetEndDataView(
      ::viz::mojom::SurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnd(UserType* output) {
    
    auto* pointer = data_->end.Get();
    return mojo::internal::Deserialize<::viz::mojom::SurfaceIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::SurfaceRange_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SurfaceRangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SurfaceRangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SurfaceRange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::start(input)) in_start = Traits::start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start)::BaseType> start_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView>(
        in_start, start_fragment);
    fragment->start.Set(
        start_fragment.is_null() ? nullptr : start_fragment.data());
    decltype(Traits::end(input)) in_end = Traits::end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->end)::BaseType> end_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView>(
        in_end, end_fragment);
    fragment->end.Set(
        end_fragment.is_null() ? nullptr : end_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null end in SurfaceRange struct");
  }

  static bool Deserialize(::viz::mojom::internal::SurfaceRange_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SurfaceRangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void SurfaceRangeDataView::GetStartDataView(
    ::viz::mojom::SurfaceIdDataView* output) {
  auto pointer = data_->start.Get();
  *output = ::viz::mojom::SurfaceIdDataView(pointer, message_);
}
inline void SurfaceRangeDataView::GetEndDataView(
    ::viz::mojom::SurfaceIdDataView* output) {
  auto pointer = data_->end.Get();
  *output = ::viz::mojom::SurfaceIdDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_RANGE_MOJOM_SHARED_H_