// services/viz/public/mojom/hit_test/input_target_client.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/hit_test/input_target_client.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/hit_test/input_target_client.mojom-params-data.h"
#include "services/viz/public/mojom/hit_test/input_target_client.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/hit_test/input_target_client.mojom-import-headers.h"
#include "services/viz/public/mojom/hit_test/input_target_client.mojom-test-utils.h"


namespace viz::mojom {
const char InputTargetClient::Name_[] = "viz.mojom.InputTargetClient";

InputTargetClient::IPCStableHashFunction InputTargetClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::InputTargetClient>(message.name())) {
    case messages::InputTargetClient::kFrameSinkIdAt: {
      return &InputTargetClient::FrameSinkIdAt_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* InputTargetClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::InputTargetClient>(message.name())) {
      case messages::InputTargetClient::kFrameSinkIdAt:
            return "Receive viz::mojom::InputTargetClient::FrameSinkIdAt";
    }
  } else {
    switch (static_cast<messages::InputTargetClient>(message.name())) {
      case messages::InputTargetClient::kFrameSinkIdAt:
            return "Receive reply viz::mojom::InputTargetClient::FrameSinkIdAt";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t InputTargetClient::FrameSinkIdAt_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::InputTargetClient::FrameSinkIdAt");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class InputTargetClient_FrameSinkIdAt_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputTargetClient_FrameSinkIdAt_ForwardToCallback(
      InputTargetClient::FrameSinkIdAtCallback callback
      ) : callback_(std::move(callback)) {
  }

  InputTargetClient_FrameSinkIdAt_ForwardToCallback(const InputTargetClient_FrameSinkIdAt_ForwardToCallback&) = delete;
  InputTargetClient_FrameSinkIdAt_ForwardToCallback& operator=(const InputTargetClient_FrameSinkIdAt_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InputTargetClient::FrameSinkIdAtCallback callback_;
};

InputTargetClientProxy::InputTargetClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InputTargetClientProxy::FrameSinkIdAt(
    const ::gfx::PointF& in_point, uint64_t in_trace_id, FrameSinkIdAtCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::InputTargetClient::FrameSinkIdAt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputTargetClient::kFrameSinkIdAt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::InputTargetClient_FrameSinkIdAt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_point, point_fragment);
  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point in InputTargetClient.FrameSinkIdAt request");
  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputTargetClient::Name_);
  message.set_method_name("FrameSinkIdAt");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputTargetClient_FrameSinkIdAt_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class InputTargetClient_FrameSinkIdAt_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InputTargetClient::FrameSinkIdAtCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InputTargetClient_FrameSinkIdAt_ProxyToResponder> proxy(
        new InputTargetClient_FrameSinkIdAt_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InputTargetClient_FrameSinkIdAt_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputTargetClient_FrameSinkIdAt_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InputTargetClient_FrameSinkIdAt_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputTargetClient::FrameSinkIdAtCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::viz::FrameSinkId& in_id, const ::gfx::PointF& in_local_point);
};

bool InputTargetClient_FrameSinkIdAt_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InputTargetClient_FrameSinkIdAt_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputTargetClient_FrameSinkIdAt_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for InputTargetClient.0
  bool success = true;
  ::viz::FrameSinkId p_id{};
  ::gfx::PointF p_local_point{};
  InputTargetClient_FrameSinkIdAt_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadId(&p_id))
    success = false;
  if (success && !input_data_view.ReadLocalPoint(&p_local_point))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputTargetClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_id), 
std::move(p_local_point));
  return true;
}

void InputTargetClient_FrameSinkIdAt_ProxyToResponder::Run(
    const ::viz::FrameSinkId& in_id, const ::gfx::PointF& in_local_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::InputTargetClient::FrameSinkIdAt", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_point"), in_local_point,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputTargetClient::kFrameSinkIdAt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::InputTargetClient_FrameSinkIdAt_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ");
  mojo::internal::MessageFragment<
      typename decltype(params->local_point)::BaseType> local_point_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_local_point, local_point_fragment);
  params->local_point.Set(
      local_point_fragment.is_null() ? nullptr : local_point_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_point in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputTargetClient::Name_);
  message.set_method_name("FrameSinkIdAt");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool InputTargetClientStubDispatch::Accept(
    InputTargetClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::InputTargetClient>(message->header()->name)) {
    case messages::InputTargetClient::kFrameSinkIdAt: {
      break;
    }
  }
  return false;
}

// static
bool InputTargetClientStubDispatch::AcceptWithResponder(
    InputTargetClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::InputTargetClient>(message->header()->name)) {
    case messages::InputTargetClient::kFrameSinkIdAt: {
      internal::InputTargetClient_FrameSinkIdAt_Params_Data* params =
          reinterpret_cast<
              internal::InputTargetClient_FrameSinkIdAt_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for InputTargetClient.0
      bool success = true;
      ::gfx::PointF p_point{};
      uint64_t p_trace_id{};
      InputTargetClient_FrameSinkIdAt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputTargetClient::Name_, 0, false);
        return false;
      }
      InputTargetClient::FrameSinkIdAtCallback callback =
          InputTargetClient_FrameSinkIdAt_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FrameSinkIdAt(        
        std::move(p_point), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kInputTargetClientValidationInfo[] = {
    {base::to_underlying(messages::InputTargetClient::kFrameSinkIdAt),
     { &internal::InputTargetClient_FrameSinkIdAt_Params_Data::Validate,
      &internal::InputTargetClient_FrameSinkIdAt_ResponseParams_Data::Validate}},
};

bool InputTargetClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::InputTargetClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kInputTargetClientValidationInfo);
}

bool InputTargetClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::InputTargetClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kInputTargetClientValidationInfo);

}


}  // viz::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void InputTargetClientInterceptorForTesting::FrameSinkIdAt(const ::gfx::PointF& point, uint64_t trace_id, FrameSinkIdAtCallback callback) {
  GetForwardingInterface()->FrameSinkIdAt(
    std::move(point)
    , 
    std::move(trace_id)
    , std::move(callback));
}
InputTargetClientAsyncWaiter::InputTargetClientAsyncWaiter(
    InputTargetClient* proxy) : proxy_(proxy) {}

InputTargetClientAsyncWaiter::~InputTargetClientAsyncWaiter() = default;

void InputTargetClientAsyncWaiter::FrameSinkIdAt(
    const ::gfx::PointF& point, uint64_t trace_id, ::viz::FrameSinkId* out_id, ::gfx::PointF* out_local_point) {
  base::RunLoop loop;
  proxy_->FrameSinkIdAt(
      std::move(point),
      std::move(trace_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::viz::FrameSinkId* out_id
,
             ::gfx::PointF* out_local_point
,
             const ::viz::FrameSinkId& id,
             const ::gfx::PointF& local_point) {*out_id = std::move(id);*out_local_point = std::move(local_point);
            loop->Quit();
          },
          &loop,
          out_id,
          out_local_point));
  loop.Run();
}








}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif