// third_party/blink/public/mojom/shared_storage/shared_storage.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-params-data.h"
#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "third_party/blink/common/permissions_policy/permissions_policy_mojom_traits.h"


namespace blink::mojom::blink {
SharedStorageUrlWithMetadata::SharedStorageUrlWithMetadata()
    : url(),
      reporting_metadata() {}

SharedStorageUrlWithMetadata::SharedStorageUrlWithMetadata(
    const ::blink::KURL& url_in,
    const WTF::HashMap<WTF::String, ::blink::KURL>& reporting_metadata_in)
    : url(std::move(url_in)),
      reporting_metadata(std::move(reporting_metadata_in)) {}

SharedStorageUrlWithMetadata::~SharedStorageUrlWithMetadata() = default;

void SharedStorageUrlWithMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_metadata"), this->reporting_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::HashMap<WTF::String, ::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedStorageUrlWithMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrivateAggregationConfig::PrivateAggregationConfig()
    : aggregation_coordinator_origin(),
      context_id(),
      filtering_id_max_bytes(),
      max_contributions() {}

PrivateAggregationConfig::PrivateAggregationConfig(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& aggregation_coordinator_origin_in,
    const WTF::String& context_id_in,
    uint32_t filtering_id_max_bytes_in,
    std::optional<uint16_t> max_contributions_in)
    : aggregation_coordinator_origin(std::move(aggregation_coordinator_origin_in)),
      context_id(std::move(context_id_in)),
      filtering_id_max_bytes(std::move(filtering_id_max_bytes_in)),
      max_contributions(std::move(max_contributions_in)) {}

PrivateAggregationConfig::~PrivateAggregationConfig() = default;

void PrivateAggregationConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregation_coordinator_origin"), this->aggregation_coordinator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_id"), this->context_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filtering_id_max_bytes"), this->filtering_id_max_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_contributions"), this->max_contributions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint16_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrivateAggregationConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SharedStorageWorkletHost::Name_[] = "blink.mojom.SharedStorageWorkletHost";

SharedStorageWorkletHost::IPCStableHashFunction SharedStorageWorkletHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SharedStorageWorkletHost>(message.name())) {
    case messages::SharedStorageWorkletHost::kSelectURL: {
      return &SharedStorageWorkletHost::SelectURL_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletHost::kRun: {
      return &SharedStorageWorkletHost::Run_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SharedStorageWorkletHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SharedStorageWorkletHost>(message.name())) {
      case messages::SharedStorageWorkletHost::kSelectURL:
            return "Receive blink::mojom::SharedStorageWorkletHost::SelectURL";
      case messages::SharedStorageWorkletHost::kRun:
            return "Receive blink::mojom::SharedStorageWorkletHost::Run";
    }
  } else {
    switch (static_cast<messages::SharedStorageWorkletHost>(message.name())) {
      case messages::SharedStorageWorkletHost::kSelectURL:
            return "Receive reply blink::mojom::SharedStorageWorkletHost::SelectURL";
      case messages::SharedStorageWorkletHost::kRun:
            return "Receive reply blink::mojom::SharedStorageWorkletHost::Run";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SharedStorageWorkletHost::SelectURL_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::SharedStorageWorkletHost::SelectURL");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletHost::Run_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::SharedStorageWorkletHost::Run");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SharedStorageWorkletHost_SelectURL_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageWorkletHost_SelectURL_ForwardToCallback(
      SharedStorageWorkletHost::SelectURLCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageWorkletHost_SelectURL_ForwardToCallback(const SharedStorageWorkletHost_SelectURL_ForwardToCallback&) = delete;
  SharedStorageWorkletHost_SelectURL_ForwardToCallback& operator=(const SharedStorageWorkletHost_SelectURL_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageWorkletHost::SelectURLCallback callback_;
};

class SharedStorageWorkletHost_Run_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageWorkletHost_Run_ForwardToCallback(
      SharedStorageWorkletHost::RunCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageWorkletHost_Run_ForwardToCallback(const SharedStorageWorkletHost_Run_ForwardToCallback&) = delete;
  SharedStorageWorkletHost_Run_ForwardToCallback& operator=(const SharedStorageWorkletHost_Run_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageWorkletHost::RunCallback callback_;
};

SharedStorageWorkletHostProxy::SharedStorageWorkletHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedStorageWorkletHostProxy::SelectURL(
    const WTF::String& in_name, WTF::Vector<SharedStorageUrlWithMetadataPtr> in_urls_with_metadata, ::blink::BlinkCloneableMessage in_serialized_data, bool in_keep_alive_after_operation, PrivateAggregationConfigPtr in_private_aggregation_config, const ::WTF::String& in_saved_query_name, SelectURLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletHost::SelectURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls_with_metadata"), in_urls_with_metadata,
                        "<value of type WTF::Vector<SharedStorageUrlWithMetadataPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serialized_data"), in_serialized_data,
                        "<value of type ::blink::BlinkCloneableMessage>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keep_alive_after_operation"), in_keep_alive_after_operation,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("private_aggregation_config"), in_private_aggregation_config,
                        "<value of type PrivateAggregationConfigPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("saved_query_name"), in_saved_query_name,
                        "<value of type const ::WTF::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletHost::kSelectURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletHost_SelectURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in SharedStorageWorkletHost.SelectURL request");
  mojo::internal::MessageFragment<
      typename decltype(params->urls_with_metadata)::BaseType>
      urls_with_metadata_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_with_metadata_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SharedStorageUrlWithMetadataDataView>>(
      in_urls_with_metadata, urls_with_metadata_fragment, &urls_with_metadata_validate_params);
  params->urls_with_metadata.Set(
      urls_with_metadata_fragment.is_null() ? nullptr : urls_with_metadata_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->urls_with_metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null urls_with_metadata in SharedStorageWorkletHost.SelectURL request");
  mojo::internal::MessageFragment<
      typename decltype(params->serialized_data)::BaseType> serialized_data_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CloneableMessageDataView>(
      in_serialized_data, serialized_data_fragment);
  params->serialized_data.Set(
      serialized_data_fragment.is_null() ? nullptr : serialized_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->serialized_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null serialized_data in SharedStorageWorkletHost.SelectURL request");
  params->keep_alive_after_operation = in_keep_alive_after_operation;
  mojo::internal::MessageFragment<
      typename decltype(params->private_aggregation_config)::BaseType> private_aggregation_config_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PrivateAggregationConfigDataView>(
      in_private_aggregation_config, private_aggregation_config_fragment);
  params->private_aggregation_config.Set(
      private_aggregation_config_fragment.is_null() ? nullptr : private_aggregation_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->private_aggregation_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null private_aggregation_config in SharedStorageWorkletHost.SelectURL request");
  mojo::internal::MessageFragment<
      typename decltype(params->saved_query_name)::BaseType> saved_query_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_saved_query_name, saved_query_name_fragment);
  params->saved_query_name.Set(
      saved_query_name_fragment.is_null() ? nullptr : saved_query_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->saved_query_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null saved_query_name in SharedStorageWorkletHost.SelectURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletHost::Name_);
  message.set_method_name("SelectURL");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageWorkletHost_SelectURL_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageWorkletHostProxy::Run(
    const WTF::String& in_name, ::blink::BlinkCloneableMessage in_serialized_data, bool in_keep_alive_after_operation, PrivateAggregationConfigPtr in_private_aggregation_config, RunCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletHost::Run", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serialized_data"), in_serialized_data,
                        "<value of type ::blink::BlinkCloneableMessage>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keep_alive_after_operation"), in_keep_alive_after_operation,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("private_aggregation_config"), in_private_aggregation_config,
                        "<value of type PrivateAggregationConfigPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletHost::kRun), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletHost_Run_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in SharedStorageWorkletHost.Run request");
  mojo::internal::MessageFragment<
      typename decltype(params->serialized_data)::BaseType> serialized_data_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CloneableMessageDataView>(
      in_serialized_data, serialized_data_fragment);
  params->serialized_data.Set(
      serialized_data_fragment.is_null() ? nullptr : serialized_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->serialized_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null serialized_data in SharedStorageWorkletHost.Run request");
  params->keep_alive_after_operation = in_keep_alive_after_operation;
  mojo::internal::MessageFragment<
      typename decltype(params->private_aggregation_config)::BaseType> private_aggregation_config_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PrivateAggregationConfigDataView>(
      in_private_aggregation_config, private_aggregation_config_fragment);
  params->private_aggregation_config.Set(
      private_aggregation_config_fragment.is_null() ? nullptr : private_aggregation_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->private_aggregation_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null private_aggregation_config in SharedStorageWorkletHost.Run request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletHost::Name_);
  message.set_method_name("Run");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageWorkletHost_Run_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SharedStorageWorkletHost_SelectURL_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageWorkletHost::SelectURLCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageWorkletHost_SelectURL_ProxyToResponder> proxy(
        new SharedStorageWorkletHost_SelectURL_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageWorkletHost_SelectURL_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageWorkletHost_SelectURL_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageWorkletHost_SelectURL_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SharedStorageWorkletHost::SelectURLCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const WTF::String& in_error_message, const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>& in_config);
};

bool SharedStorageWorkletHost_SelectURL_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageWorkletHost_SelectURL_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageWorkletHost_SelectURL_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SharedStorageWorkletHost.0
  bool success = true;
  bool p_success{};
  WTF::String p_error_message{};
  std::optional<::blink::FencedFrame::RedactedFencedFrameConfig> p_config{};
  SharedStorageWorkletHost_SelectURL_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageWorkletHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_error_message), 
std::move(p_config));
  return true;
}

void SharedStorageWorkletHost_SelectURL_ProxyToResponder::Run(
    bool in_success, const WTF::String& in_error_message, const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>& in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageWorkletHost::SelectURL", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletHost::kSelectURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletHost_SelectURL_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in ");
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FencedFrameConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletHost::Name_);
  message.set_method_name("SelectURL");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SharedStorageWorkletHost_Run_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageWorkletHost::RunCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageWorkletHost_Run_ProxyToResponder> proxy(
        new SharedStorageWorkletHost_Run_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageWorkletHost_Run_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageWorkletHost_Run_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageWorkletHost_Run_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SharedStorageWorkletHost::RunCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const WTF::String& in_error_message);
};

bool SharedStorageWorkletHost_Run_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageWorkletHost_Run_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageWorkletHost_Run_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SharedStorageWorkletHost.1
  bool success = true;
  bool p_success{};
  WTF::String p_error_message{};
  SharedStorageWorkletHost_Run_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageWorkletHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_error_message));
  return true;
}

void SharedStorageWorkletHost_Run_ProxyToResponder::Run(
    bool in_success, const WTF::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageWorkletHost::Run", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const WTF::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletHost::kRun), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletHost_Run_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletHost::Name_);
  message.set_method_name("Run");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SharedStorageWorkletHostStubDispatch::Accept(
    SharedStorageWorkletHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SharedStorageWorkletHost>(message->header()->name)) {
    case messages::SharedStorageWorkletHost::kSelectURL: {
      break;
    }
    case messages::SharedStorageWorkletHost::kRun: {
      break;
    }
  }
  return false;
}

// static
bool SharedStorageWorkletHostStubDispatch::AcceptWithResponder(
    SharedStorageWorkletHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SharedStorageWorkletHost>(message->header()->name)) {
    case messages::SharedStorageWorkletHost::kSelectURL: {
      internal::SharedStorageWorkletHost_SelectURL_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageWorkletHost_SelectURL_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SharedStorageWorkletHost.0
      bool success = true;
      WTF::String p_name{};
      WTF::Vector<SharedStorageUrlWithMetadataPtr> p_urls_with_metadata{};
      ::blink::BlinkCloneableMessage p_serialized_data{};
      bool p_keep_alive_after_operation{};
      PrivateAggregationConfigPtr p_private_aggregation_config{};
      ::WTF::String p_saved_query_name{};
      SharedStorageWorkletHost_SelectURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadUrlsWithMetadata(&p_urls_with_metadata))
        success = false;
      if (success && !input_data_view.ReadSerializedData(&p_serialized_data))
        success = false;
      if (success)
        p_keep_alive_after_operation = input_data_view.keep_alive_after_operation();
      if (success && !input_data_view.ReadPrivateAggregationConfig(&p_private_aggregation_config))
        success = false;
      if (success && !input_data_view.ReadSavedQueryName(&p_saved_query_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletHost::Name_, 0, false);
        return false;
      }
      SharedStorageWorkletHost::SelectURLCallback callback =
          SharedStorageWorkletHost_SelectURL_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectURL(        
        std::move(p_name), 
        std::move(p_urls_with_metadata), 
        std::move(p_serialized_data), 
        std::move(p_keep_alive_after_operation), 
        std::move(p_private_aggregation_config), 
        std::move(p_saved_query_name), std::move(callback));
      return true;
    }
    case messages::SharedStorageWorkletHost::kRun: {
      internal::SharedStorageWorkletHost_Run_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageWorkletHost_Run_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SharedStorageWorkletHost.1
      bool success = true;
      WTF::String p_name{};
      ::blink::BlinkCloneableMessage p_serialized_data{};
      bool p_keep_alive_after_operation{};
      PrivateAggregationConfigPtr p_private_aggregation_config{};
      SharedStorageWorkletHost_Run_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadSerializedData(&p_serialized_data))
        success = false;
      if (success)
        p_keep_alive_after_operation = input_data_view.keep_alive_after_operation();
      if (success && !input_data_view.ReadPrivateAggregationConfig(&p_private_aggregation_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletHost::Name_, 1, false);
        return false;
      }
      SharedStorageWorkletHost::RunCallback callback =
          SharedStorageWorkletHost_Run_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Run(        
        std::move(p_name), 
        std::move(p_serialized_data), 
        std::move(p_keep_alive_after_operation), 
        std::move(p_private_aggregation_config), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSharedStorageWorkletHostValidationInfo[] = {
    {base::to_underlying(messages::SharedStorageWorkletHost::kSelectURL),
     { &internal::SharedStorageWorkletHost_SelectURL_Params_Data::Validate,
      &internal::SharedStorageWorkletHost_SelectURL_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SharedStorageWorkletHost::kRun),
     { &internal::SharedStorageWorkletHost_Run_Params_Data::Validate,
      &internal::SharedStorageWorkletHost_Run_ResponseParams_Data::Validate}},
};

bool SharedStorageWorkletHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::SharedStorageWorkletHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSharedStorageWorkletHostValidationInfo);
}

bool SharedStorageWorkletHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::SharedStorageWorkletHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSharedStorageWorkletHostValidationInfo);

}
const char SharedStorageDocumentService::Name_[] = "blink.mojom.SharedStorageDocumentService";

SharedStorageDocumentService::IPCStableHashFunction SharedStorageDocumentService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SharedStorageDocumentService>(message.name())) {
    case messages::SharedStorageDocumentService::kCreateWorklet: {
      return &SharedStorageDocumentService::CreateWorklet_Sym::IPCStableHash;
    }
    case messages::SharedStorageDocumentService::kSharedStorageGet: {
      return &SharedStorageDocumentService::SharedStorageGet_Sym::IPCStableHash;
    }
    case messages::SharedStorageDocumentService::kSharedStorageUpdate: {
      return &SharedStorageDocumentService::SharedStorageUpdate_Sym::IPCStableHash;
    }
    case messages::SharedStorageDocumentService::kSharedStorageBatchUpdate: {
      return &SharedStorageDocumentService::SharedStorageBatchUpdate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SharedStorageDocumentService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SharedStorageDocumentService>(message.name())) {
      case messages::SharedStorageDocumentService::kCreateWorklet:
            return "Receive blink::mojom::SharedStorageDocumentService::CreateWorklet";
      case messages::SharedStorageDocumentService::kSharedStorageGet:
            return "Receive blink::mojom::SharedStorageDocumentService::SharedStorageGet";
      case messages::SharedStorageDocumentService::kSharedStorageUpdate:
            return "Receive blink::mojom::SharedStorageDocumentService::SharedStorageUpdate";
      case messages::SharedStorageDocumentService::kSharedStorageBatchUpdate:
            return "Receive blink::mojom::SharedStorageDocumentService::SharedStorageBatchUpdate";
    }
  } else {
    switch (static_cast<messages::SharedStorageDocumentService>(message.name())) {
      case messages::SharedStorageDocumentService::kCreateWorklet:
            return "Receive reply blink::mojom::SharedStorageDocumentService::CreateWorklet";
      case messages::SharedStorageDocumentService::kSharedStorageGet:
            return "Receive reply blink::mojom::SharedStorageDocumentService::SharedStorageGet";
      case messages::SharedStorageDocumentService::kSharedStorageUpdate:
            return "Receive reply blink::mojom::SharedStorageDocumentService::SharedStorageUpdate";
      case messages::SharedStorageDocumentService::kSharedStorageBatchUpdate:
            return "Receive reply blink::mojom::SharedStorageDocumentService::SharedStorageBatchUpdate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SharedStorageDocumentService::CreateWorklet_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::SharedStorageDocumentService::CreateWorklet");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageDocumentService::SharedStorageGet_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::SharedStorageDocumentService::SharedStorageGet");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageDocumentService::SharedStorageUpdate_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::SharedStorageDocumentService::SharedStorageUpdate");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageDocumentService::SharedStorageBatchUpdate_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::SharedStorageDocumentService::SharedStorageBatchUpdate");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SharedStorageDocumentService_CreateWorklet_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageDocumentService_CreateWorklet_ForwardToCallback(
      SharedStorageDocumentService::CreateWorkletCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageDocumentService_CreateWorklet_ForwardToCallback(const SharedStorageDocumentService_CreateWorklet_ForwardToCallback&) = delete;
  SharedStorageDocumentService_CreateWorklet_ForwardToCallback& operator=(const SharedStorageDocumentService_CreateWorklet_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageDocumentService::CreateWorkletCallback callback_;
};

class SharedStorageDocumentService_SharedStorageGet_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageDocumentService_SharedStorageGet_ForwardToCallback(
      SharedStorageDocumentService::SharedStorageGetCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageDocumentService_SharedStorageGet_ForwardToCallback(const SharedStorageDocumentService_SharedStorageGet_ForwardToCallback&) = delete;
  SharedStorageDocumentService_SharedStorageGet_ForwardToCallback& operator=(const SharedStorageDocumentService_SharedStorageGet_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageDocumentService::SharedStorageGetCallback callback_;
};

class SharedStorageDocumentService_SharedStorageUpdate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageDocumentService_SharedStorageUpdate_ForwardToCallback(
      SharedStorageDocumentService::SharedStorageUpdateCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageDocumentService_SharedStorageUpdate_ForwardToCallback(const SharedStorageDocumentService_SharedStorageUpdate_ForwardToCallback&) = delete;
  SharedStorageDocumentService_SharedStorageUpdate_ForwardToCallback& operator=(const SharedStorageDocumentService_SharedStorageUpdate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageDocumentService::SharedStorageUpdateCallback callback_;
};

class SharedStorageDocumentService_SharedStorageBatchUpdate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageDocumentService_SharedStorageBatchUpdate_ForwardToCallback(
      SharedStorageDocumentService::SharedStorageBatchUpdateCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageDocumentService_SharedStorageBatchUpdate_ForwardToCallback(const SharedStorageDocumentService_SharedStorageBatchUpdate_ForwardToCallback&) = delete;
  SharedStorageDocumentService_SharedStorageBatchUpdate_ForwardToCallback& operator=(const SharedStorageDocumentService_SharedStorageBatchUpdate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageDocumentService::SharedStorageBatchUpdateCallback callback_;
};

SharedStorageDocumentServiceProxy::SharedStorageDocumentServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedStorageDocumentServiceProxy::CreateWorklet(
    const ::blink::KURL& in_script_source_url, const ::scoped_refptr<const ::blink::SecurityOrigin>& in_data_origin, ::network::mojom::blink::CredentialsMode in_credentials_mode, SharedStorageWorkletCreationMethod in_creation_method, const WTF::Vector<::blink::mojom::blink::OriginTrialFeature>& in_origin_trial_features, ::mojo::PendingAssociatedReceiver<SharedStorageWorkletHost> in_worklet_host, CreateWorkletCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageDocumentService::CreateWorklet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_source_url"), in_script_source_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_origin"), in_data_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credentials_mode"), in_credentials_mode,
                        "<value of type ::network::mojom::blink::CredentialsMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("creation_method"), in_creation_method,
                        "<value of type SharedStorageWorkletCreationMethod>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_trial_features"), in_origin_trial_features,
                        "<value of type const WTF::Vector<::blink::mojom::blink::OriginTrialFeature>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worklet_host"), in_worklet_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<SharedStorageWorkletHost>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageDocumentService::kCreateWorklet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageDocumentService_CreateWorklet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->script_source_url)::BaseType> script_source_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_script_source_url, script_source_url_fragment);
  params->script_source_url.Set(
      script_source_url_fragment.is_null() ? nullptr : script_source_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_source_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_source_url in SharedStorageDocumentService.CreateWorklet request");
  mojo::internal::MessageFragment<
      typename decltype(params->data_origin)::BaseType> data_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_data_origin, data_origin_fragment);
  params->data_origin.Set(
      data_origin_fragment.is_null() ? nullptr : data_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_origin in SharedStorageDocumentService.CreateWorklet request");
  mojo::internal::Serialize<::network::mojom::CredentialsMode>(
      in_credentials_mode, &params->credentials_mode);
  mojo::internal::Serialize<::blink::mojom::SharedStorageWorkletCreationMethod>(
      in_creation_method, &params->creation_method);
  mojo::internal::MessageFragment<
      typename decltype(params->origin_trial_features)::BaseType>
      origin_trial_features_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& origin_trial_features_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::OriginTrialFeature_Data::Validate>();
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::OriginTrialFeature>>(
      in_origin_trial_features, origin_trial_features_fragment, &origin_trial_features_validate_params);
  params->origin_trial_features.Set(
      origin_trial_features_fragment.is_null() ? nullptr : origin_trial_features_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin_trial_features.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin_trial_features in SharedStorageDocumentService.CreateWorklet request");
  mojo::internal::Serialize<::blink::mojom::SharedStorageWorkletHostAssociatedRequestDataView>(
      in_worklet_host, &params->worklet_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->worklet_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid worklet_host in SharedStorageDocumentService.CreateWorklet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageDocumentService::Name_);
  message.set_method_name("CreateWorklet");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageDocumentService_CreateWorklet_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageDocumentServiceProxy::SharedStorageGet(
    const ::WTF::String& in_key, SharedStorageGetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageDocumentService::SharedStorageGet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::WTF::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageDocumentService::kSharedStorageGet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageDocumentService_SharedStorageGet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SharedStorageKeyArgumentDataView>(
      in_key, key_fragment);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in SharedStorageDocumentService.SharedStorageGet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageDocumentService::Name_);
  message.set_method_name("SharedStorageGet");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageDocumentService_SharedStorageGet_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageDocumentServiceProxy::SharedStorageUpdate(
    ::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr in_method_with_options, SharedStorageUpdateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageDocumentService::SharedStorageUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_with_options"), in_method_with_options,
                        "<value of type ::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageDocumentService::kSharedStorageUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageDocumentService_SharedStorageUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->method_with_options)::BaseType> method_with_options_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SharedStorageModifierMethodWithOptionsDataView>(
      in_method_with_options, method_with_options_fragment);
  params->method_with_options.Set(
      method_with_options_fragment.is_null() ? nullptr : method_with_options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_with_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_with_options in SharedStorageDocumentService.SharedStorageUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageDocumentService::Name_);
  message.set_method_name("SharedStorageUpdate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageDocumentService_SharedStorageUpdate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageDocumentServiceProxy::SharedStorageBatchUpdate(
    WTF::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> in_methods_with_options, const std::optional<::WTF::String>& in_with_lock, SharedStorageBatchUpdateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageDocumentService::SharedStorageBatchUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("methods_with_options"), in_methods_with_options,
                        "<value of type WTF::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("with_lock"), in_with_lock,
                        "<value of type const std::optional<::WTF::String>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageDocumentService::kSharedStorageBatchUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageDocumentService_SharedStorageBatchUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->methods_with_options)::BaseType>
      methods_with_options_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& methods_with_options_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SharedStorageModifierMethodWithOptionsDataView>>(
      in_methods_with_options, methods_with_options_fragment, &methods_with_options_validate_params);
  params->methods_with_options.Set(
      methods_with_options_fragment.is_null() ? nullptr : methods_with_options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->methods_with_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null methods_with_options in SharedStorageDocumentService.SharedStorageBatchUpdate request");
  mojo::internal::MessageFragment<
      typename decltype(params->with_lock)::BaseType> with_lock_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::LockNameDataView>(
      in_with_lock, with_lock_fragment);
  params->with_lock.Set(
      with_lock_fragment.is_null() ? nullptr : with_lock_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageDocumentService::Name_);
  message.set_method_name("SharedStorageBatchUpdate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageDocumentService_SharedStorageBatchUpdate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SharedStorageDocumentService_CreateWorklet_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageDocumentService::CreateWorkletCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageDocumentService_CreateWorklet_ProxyToResponder> proxy(
        new SharedStorageDocumentService_CreateWorklet_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageDocumentService_CreateWorklet_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageDocumentService_CreateWorklet_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageDocumentService_CreateWorklet_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SharedStorageDocumentService::CreateWorkletCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const WTF::String& in_error_message);
};

bool SharedStorageDocumentService_CreateWorklet_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageDocumentService_CreateWorklet_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageDocumentService_CreateWorklet_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SharedStorageDocumentService.0
  bool success = true;
  bool p_success{};
  WTF::String p_error_message{};
  SharedStorageDocumentService_CreateWorklet_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageDocumentService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_error_message));
  return true;
}

void SharedStorageDocumentService_CreateWorklet_ProxyToResponder::Run(
    bool in_success, const WTF::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageDocumentService::CreateWorklet", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const WTF::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageDocumentService::kCreateWorklet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageDocumentService_CreateWorklet_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageDocumentService::Name_);
  message.set_method_name("CreateWorklet");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SharedStorageDocumentService_SharedStorageGet_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageDocumentService::SharedStorageGetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageDocumentService_SharedStorageGet_ProxyToResponder> proxy(
        new SharedStorageDocumentService_SharedStorageGet_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageDocumentService_SharedStorageGet_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageDocumentService_SharedStorageGet_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageDocumentService_SharedStorageGet_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SharedStorageDocumentService::SharedStorageGetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SharedStorageGetStatus in_status, const WTF::String& in_error_message, const ::WTF::String& in_value);
};

bool SharedStorageDocumentService_SharedStorageGet_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageDocumentService_SharedStorageGet_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageDocumentService_SharedStorageGet_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SharedStorageDocumentService.1
  bool success = true;
  SharedStorageGetStatus p_status{};
  WTF::String p_error_message{};
  ::WTF::String p_value{};
  SharedStorageDocumentService_SharedStorageGet_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageDocumentService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_error_message), 
std::move(p_value));
  return true;
}

void SharedStorageDocumentService_SharedStorageGet_ProxyToResponder::Run(
    SharedStorageGetStatus in_status, const WTF::String& in_error_message, const ::WTF::String& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageDocumentService::SharedStorageGet", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type SharedStorageGetStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const ::WTF::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageDocumentService::kSharedStorageGet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageDocumentService_SharedStorageGet_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::SharedStorageGetStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in ");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_value, value_fragment);
  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageDocumentService::Name_);
  message.set_method_name("SharedStorageGet");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SharedStorageDocumentService_SharedStorageUpdate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageDocumentService::SharedStorageUpdateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageDocumentService_SharedStorageUpdate_ProxyToResponder> proxy(
        new SharedStorageDocumentService_SharedStorageUpdate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageDocumentService_SharedStorageUpdate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageDocumentService_SharedStorageUpdate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageDocumentService_SharedStorageUpdate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SharedStorageDocumentService::SharedStorageUpdateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::String& in_error_message);
};

bool SharedStorageDocumentService_SharedStorageUpdate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageDocumentService_SharedStorageUpdate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageDocumentService_SharedStorageUpdate_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SharedStorageDocumentService.2
  bool success = true;
  WTF::String p_error_message{};
  SharedStorageDocumentService_SharedStorageUpdate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageDocumentService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error_message));
  return true;
}

void SharedStorageDocumentService_SharedStorageUpdate_ProxyToResponder::Run(
    const WTF::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageDocumentService::SharedStorageUpdate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const WTF::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageDocumentService::kSharedStorageUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageDocumentService_SharedStorageUpdate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageDocumentService::Name_);
  message.set_method_name("SharedStorageUpdate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SharedStorageDocumentService_SharedStorageBatchUpdate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageDocumentService::SharedStorageBatchUpdateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageDocumentService_SharedStorageBatchUpdate_ProxyToResponder> proxy(
        new SharedStorageDocumentService_SharedStorageBatchUpdate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageDocumentService_SharedStorageBatchUpdate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageDocumentService_SharedStorageBatchUpdate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageDocumentService_SharedStorageBatchUpdate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SharedStorageDocumentService::SharedStorageBatchUpdateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::String& in_error_message);
};

bool SharedStorageDocumentService_SharedStorageBatchUpdate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SharedStorageDocumentService.3
  bool success = true;
  WTF::String p_error_message{};
  SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageDocumentService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error_message));
  return true;
}

void SharedStorageDocumentService_SharedStorageBatchUpdate_ProxyToResponder::Run(
    const WTF::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageDocumentService::SharedStorageBatchUpdate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const WTF::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageDocumentService::kSharedStorageBatchUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageDocumentService::Name_);
  message.set_method_name("SharedStorageBatchUpdate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SharedStorageDocumentServiceStubDispatch::Accept(
    SharedStorageDocumentService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SharedStorageDocumentService>(message->header()->name)) {
    case messages::SharedStorageDocumentService::kCreateWorklet: {
      break;
    }
    case messages::SharedStorageDocumentService::kSharedStorageGet: {
      break;
    }
    case messages::SharedStorageDocumentService::kSharedStorageUpdate: {
      break;
    }
    case messages::SharedStorageDocumentService::kSharedStorageBatchUpdate: {
      break;
    }
  }
  return false;
}

// static
bool SharedStorageDocumentServiceStubDispatch::AcceptWithResponder(
    SharedStorageDocumentService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SharedStorageDocumentService>(message->header()->name)) {
    case messages::SharedStorageDocumentService::kCreateWorklet: {
      internal::SharedStorageDocumentService_CreateWorklet_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageDocumentService_CreateWorklet_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SharedStorageDocumentService.0
      bool success = true;
      ::blink::KURL p_script_source_url{};
      ::scoped_refptr<const ::blink::SecurityOrigin> p_data_origin{};
      ::network::mojom::blink::CredentialsMode p_credentials_mode{};
      SharedStorageWorkletCreationMethod p_creation_method{};
      WTF::Vector<::blink::mojom::blink::OriginTrialFeature> p_origin_trial_features{};
      ::mojo::PendingAssociatedReceiver<SharedStorageWorkletHost> p_worklet_host{};
      SharedStorageDocumentService_CreateWorklet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScriptSourceUrl(&p_script_source_url))
        success = false;
      if (success && !input_data_view.ReadDataOrigin(&p_data_origin))
        success = false;
      if (success && !input_data_view.ReadCredentialsMode(&p_credentials_mode))
        success = false;
      if (success && !input_data_view.ReadCreationMethod(&p_creation_method))
        success = false;
      if (success && !input_data_view.ReadOriginTrialFeatures(&p_origin_trial_features))
        success = false;
      if (success) {
        p_worklet_host =
            input_data_view.TakeWorkletHost<decltype(p_worklet_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageDocumentService::Name_, 0, false);
        return false;
      }
      SharedStorageDocumentService::CreateWorkletCallback callback =
          SharedStorageDocumentService_CreateWorklet_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWorklet(        
        std::move(p_script_source_url), 
        std::move(p_data_origin), 
        std::move(p_credentials_mode), 
        std::move(p_creation_method), 
        std::move(p_origin_trial_features), 
        std::move(p_worklet_host), std::move(callback));
      return true;
    }
    case messages::SharedStorageDocumentService::kSharedStorageGet: {
      internal::SharedStorageDocumentService_SharedStorageGet_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageDocumentService_SharedStorageGet_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SharedStorageDocumentService.1
      bool success = true;
      ::WTF::String p_key{};
      SharedStorageDocumentService_SharedStorageGet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageDocumentService::Name_, 1, false);
        return false;
      }
      SharedStorageDocumentService::SharedStorageGetCallback callback =
          SharedStorageDocumentService_SharedStorageGet_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageGet(        
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::SharedStorageDocumentService::kSharedStorageUpdate: {
      internal::SharedStorageDocumentService_SharedStorageUpdate_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageDocumentService_SharedStorageUpdate_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SharedStorageDocumentService.2
      bool success = true;
      ::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr p_method_with_options{};
      SharedStorageDocumentService_SharedStorageUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMethodWithOptions(&p_method_with_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageDocumentService::Name_, 2, false);
        return false;
      }
      SharedStorageDocumentService::SharedStorageUpdateCallback callback =
          SharedStorageDocumentService_SharedStorageUpdate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageUpdate(        
        std::move(p_method_with_options), std::move(callback));
      return true;
    }
    case messages::SharedStorageDocumentService::kSharedStorageBatchUpdate: {
      internal::SharedStorageDocumentService_SharedStorageBatchUpdate_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageDocumentService_SharedStorageBatchUpdate_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SharedStorageDocumentService.3
      bool success = true;
      WTF::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> p_methods_with_options{};
      std::optional<::WTF::String> p_with_lock{};
      SharedStorageDocumentService_SharedStorageBatchUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMethodsWithOptions(&p_methods_with_options))
        success = false;
      if (success && !input_data_view.ReadWithLock(&p_with_lock))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageDocumentService::Name_, 3, false);
        return false;
      }
      SharedStorageDocumentService::SharedStorageBatchUpdateCallback callback =
          SharedStorageDocumentService_SharedStorageBatchUpdate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageBatchUpdate(        
        std::move(p_methods_with_options), 
        std::move(p_with_lock), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSharedStorageDocumentServiceValidationInfo[] = {
    {base::to_underlying(messages::SharedStorageDocumentService::kCreateWorklet),
     { &internal::SharedStorageDocumentService_CreateWorklet_Params_Data::Validate,
      &internal::SharedStorageDocumentService_CreateWorklet_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SharedStorageDocumentService::kSharedStorageGet),
     { &internal::SharedStorageDocumentService_SharedStorageGet_Params_Data::Validate,
      &internal::SharedStorageDocumentService_SharedStorageGet_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SharedStorageDocumentService::kSharedStorageUpdate),
     { &internal::SharedStorageDocumentService_SharedStorageUpdate_Params_Data::Validate,
      &internal::SharedStorageDocumentService_SharedStorageUpdate_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SharedStorageDocumentService::kSharedStorageBatchUpdate),
     { &internal::SharedStorageDocumentService_SharedStorageBatchUpdate_Params_Data::Validate,
      &internal::SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams_Data::Validate}},
};

bool SharedStorageDocumentServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::SharedStorageDocumentService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSharedStorageDocumentServiceValidationInfo);
}

bool SharedStorageDocumentServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::SharedStorageDocumentService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSharedStorageDocumentServiceValidationInfo);

}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SharedStorageUrlWithMetadata::DataView, ::blink::mojom::blink::SharedStorageUrlWithMetadataPtr>::Read(
    ::blink::mojom::blink::SharedStorageUrlWithMetadata::DataView input,
    ::blink::mojom::blink::SharedStorageUrlWithMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SharedStorageUrlWithMetadataPtr result(::blink::mojom::blink::SharedStorageUrlWithMetadata::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadReportingMetadata(&result->reporting_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PrivateAggregationConfig::DataView, ::blink::mojom::blink::PrivateAggregationConfigPtr>::Read(
    ::blink::mojom::blink::PrivateAggregationConfig::DataView input,
    ::blink::mojom::blink::PrivateAggregationConfigPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PrivateAggregationConfigPtr result(::blink::mojom::blink::PrivateAggregationConfig::New());
  
      if (success && !input.ReadAggregationCoordinatorOrigin(&result->aggregation_coordinator_origin))
        success = false;
      if (success && !input.ReadContextId(&result->context_id))
        success = false;
      if (success)
        result->filtering_id_max_bytes = input.filtering_id_max_bytes();
      if (success) {
        result->max_contributions = input.max_contributions();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void SharedStorageWorkletHostInterceptorForTesting::SelectURL(const WTF::String& name, WTF::Vector<SharedStorageUrlWithMetadataPtr> urls_with_metadata, ::blink::BlinkCloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, const ::WTF::String& saved_query_name, SelectURLCallback callback) {
  GetForwardingInterface()->SelectURL(
    std::move(name)
    , 
    std::move(urls_with_metadata)
    , 
    std::move(serialized_data)
    , 
    std::move(keep_alive_after_operation)
    , 
    std::move(private_aggregation_config)
    , 
    std::move(saved_query_name)
    , std::move(callback));
}
void SharedStorageWorkletHostInterceptorForTesting::Run(const WTF::String& name, ::blink::BlinkCloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, RunCallback callback) {
  GetForwardingInterface()->Run(
    std::move(name)
    , 
    std::move(serialized_data)
    , 
    std::move(keep_alive_after_operation)
    , 
    std::move(private_aggregation_config)
    , std::move(callback));
}
SharedStorageWorkletHostAsyncWaiter::SharedStorageWorkletHostAsyncWaiter(
    SharedStorageWorkletHost* proxy) : proxy_(proxy) {}

SharedStorageWorkletHostAsyncWaiter::~SharedStorageWorkletHostAsyncWaiter() = default;

void SharedStorageWorkletHostAsyncWaiter::SelectURL(
    const WTF::String& name, WTF::Vector<SharedStorageUrlWithMetadataPtr> urls_with_metadata, ::blink::BlinkCloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, const ::WTF::String& saved_query_name, bool* out_success, WTF::String* out_error_message, std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>* out_config) {
  base::RunLoop loop;
  proxy_->SelectURL(
      std::move(name),
      std::move(urls_with_metadata),
      std::move(serialized_data),
      std::move(keep_alive_after_operation),
      std::move(private_aggregation_config),
      std::move(saved_query_name),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             WTF::String* out_error_message
,
             std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>* out_config
,
             bool success,
             const WTF::String& error_message,
             const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>& config) {*out_success = std::move(success);*out_error_message = std::move(error_message);*out_config = std::move(config);
            loop->Quit();
          },
          &loop,
          out_success,
          out_error_message,
          out_config));
  loop.Run();
}



void SharedStorageWorkletHostAsyncWaiter::Run(
    const WTF::String& name, ::blink::BlinkCloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, bool* out_success, WTF::String* out_error_message) {
  base::RunLoop loop;
  proxy_->Run(
      std::move(name),
      std::move(serialized_data),
      std::move(keep_alive_after_operation),
      std::move(private_aggregation_config),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             WTF::String* out_error_message
,
             bool success,
             const WTF::String& error_message) {*out_success = std::move(success);*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_success,
          out_error_message));
  loop.Run();
}






void SharedStorageDocumentServiceInterceptorForTesting::CreateWorklet(const ::blink::KURL& script_source_url, const ::scoped_refptr<const ::blink::SecurityOrigin>& data_origin, ::network::mojom::blink::CredentialsMode credentials_mode, SharedStorageWorkletCreationMethod creation_method, const WTF::Vector<::blink::mojom::blink::OriginTrialFeature>& origin_trial_features, ::mojo::PendingAssociatedReceiver<SharedStorageWorkletHost> worklet_host, CreateWorkletCallback callback) {
  GetForwardingInterface()->CreateWorklet(
    std::move(script_source_url)
    , 
    std::move(data_origin)
    , 
    std::move(credentials_mode)
    , 
    std::move(creation_method)
    , 
    std::move(origin_trial_features)
    , 
    std::move(worklet_host)
    , std::move(callback));
}
void SharedStorageDocumentServiceInterceptorForTesting::SharedStorageGet(const ::WTF::String& key, SharedStorageGetCallback callback) {
  GetForwardingInterface()->SharedStorageGet(
    std::move(key)
    , std::move(callback));
}
void SharedStorageDocumentServiceInterceptorForTesting::SharedStorageUpdate(::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr method_with_options, SharedStorageUpdateCallback callback) {
  GetForwardingInterface()->SharedStorageUpdate(
    std::move(method_with_options)
    , std::move(callback));
}
void SharedStorageDocumentServiceInterceptorForTesting::SharedStorageBatchUpdate(WTF::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::WTF::String>& with_lock, SharedStorageBatchUpdateCallback callback) {
  GetForwardingInterface()->SharedStorageBatchUpdate(
    std::move(methods_with_options)
    , 
    std::move(with_lock)
    , std::move(callback));
}
SharedStorageDocumentServiceAsyncWaiter::SharedStorageDocumentServiceAsyncWaiter(
    SharedStorageDocumentService* proxy) : proxy_(proxy) {}

SharedStorageDocumentServiceAsyncWaiter::~SharedStorageDocumentServiceAsyncWaiter() = default;

void SharedStorageDocumentServiceAsyncWaiter::CreateWorklet(
    const ::blink::KURL& script_source_url, const ::scoped_refptr<const ::blink::SecurityOrigin>& data_origin, ::network::mojom::blink::CredentialsMode credentials_mode, SharedStorageWorkletCreationMethod creation_method, const WTF::Vector<::blink::mojom::blink::OriginTrialFeature>& origin_trial_features, ::mojo::PendingAssociatedReceiver<SharedStorageWorkletHost> worklet_host, bool* out_success, WTF::String* out_error_message) {
  base::RunLoop loop;
  proxy_->CreateWorklet(
      std::move(script_source_url),
      std::move(data_origin),
      std::move(credentials_mode),
      std::move(creation_method),
      std::move(origin_trial_features),
      std::move(worklet_host),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             WTF::String* out_error_message
,
             bool success,
             const WTF::String& error_message) {*out_success = std::move(success);*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_success,
          out_error_message));
  loop.Run();
}



void SharedStorageDocumentServiceAsyncWaiter::SharedStorageGet(
    const ::WTF::String& key, SharedStorageGetStatus* out_status, WTF::String* out_error_message, ::WTF::String* out_value) {
  base::RunLoop loop;
  proxy_->SharedStorageGet(
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             SharedStorageGetStatus* out_status
,
             WTF::String* out_error_message
,
             ::WTF::String* out_value
,
             SharedStorageGetStatus status,
             const WTF::String& error_message,
             const ::WTF::String& value) {*out_status = std::move(status);*out_error_message = std::move(error_message);*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_status,
          out_error_message,
          out_value));
  loop.Run();
}



void SharedStorageDocumentServiceAsyncWaiter::SharedStorageUpdate(
    ::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr method_with_options, WTF::String* out_error_message) {
  base::RunLoop loop;
  proxy_->SharedStorageUpdate(
      std::move(method_with_options),
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::String* out_error_message
,
             const WTF::String& error_message) {*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_error_message));
  loop.Run();
}

WTF::String SharedStorageDocumentServiceAsyncWaiter::SharedStorageUpdate(
    ::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr method_with_options) {
  WTF::String async_wait_result;
  SharedStorageUpdate(std::move(method_with_options),&async_wait_result);
  return async_wait_result;
}

void SharedStorageDocumentServiceAsyncWaiter::SharedStorageBatchUpdate(
    WTF::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::WTF::String>& with_lock, WTF::String* out_error_message) {
  base::RunLoop loop;
  proxy_->SharedStorageBatchUpdate(
      std::move(methods_with_options),
      std::move(with_lock),
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::String* out_error_message
,
             const WTF::String& error_message) {*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_error_message));
  loop.Run();
}

WTF::String SharedStorageDocumentServiceAsyncWaiter::SharedStorageBatchUpdate(
    WTF::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::WTF::String>& with_lock) {
  WTF::String async_wait_result;
  SharedStorageBatchUpdate(std::move(methods_with_options),std::move(with_lock),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif