// ui/base/ime/mojom/ime_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_IME_MOJOM_IME_TYPES_MOJOM_SHARED_H_
#define UI_BASE_IME_MOJOM_IME_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/base/ime/mojom/ime_types.mojom-shared-internal.h"







namespace ui::mojom {
class ImeTextSpanDataView;



}  // ui::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::mojom::ImeTextSpanDataView> {
  using Data = ::ui::mojom::internal::ImeTextSpan_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ui::mojom {


enum class TextInputMode : int32_t {
  
  kDefault = 0,
  
  kNone = 1,
  
  kText = 2,
  
  kTel = 3,
  
  kUrl = 4,
  
  kEmail = 5,
  
  kNumeric = 6,
  
  kDecimal = 7,
  
  kSearch = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

 std::ostream& operator<<(std::ostream& os, TextInputMode value);
inline bool IsKnownEnumValue(TextInputMode value) {
  return internal::TextInputMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextInputAction : int32_t {
  
  kDefault = 0,
  
  kEnter = 1,
  
  kDone = 2,
  
  kGo = 3,
  
  kNext = 4,
  
  kPrevious = 5,
  
  kSearch = 6,
  
  kSend = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, TextInputAction value);
inline bool IsKnownEnumValue(TextInputAction value) {
  return internal::TextInputAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextInputType : int32_t {
  
  NONE = 0,
  
  TEXT = 1,
  
  PASSWORD = 2,
  
  SEARCH = 3,
  
  EMAIL = 4,
  
  NUMBER = 5,
  
  TELEPHONE = 6,
  
  URL = 7,
  
  DATE = 8,
  
  DATE_TIME = 9,
  
  DATE_TIME_LOCAL = 10,
  
  MONTH = 11,
  
  TIME = 12,
  
  WEEK = 13,
  
  TEXT_AREA = 14,
  
  CONTENT_EDITABLE = 15,
  
  DATE_TIME_FIELD = 16,
  
  TYPE_NULL = 17,
  
  MAX = 17,
  kMinValue = 0,
  kMaxValue = 17,
};

 std::ostream& operator<<(std::ostream& os, TextInputType value);
inline bool IsKnownEnumValue(TextInputType value) {
  return internal::TextInputType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ImeTextSpanType : int32_t {
  
  kComposition = 0,
  
  kSuggestion = 1,
  
  kMisspellingSuggestion = 2,
  
  kAutocorrect = 3,
  
  kGrammarSuggestion = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ImeTextSpanType value);
inline bool IsKnownEnumValue(ImeTextSpanType value) {
  return internal::ImeTextSpanType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ImeTextSpanThickness : int32_t {
  
  kNone = 0,
  
  kThin = 1,
  
  kThick = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ImeTextSpanThickness value);
inline bool IsKnownEnumValue(ImeTextSpanThickness value) {
  return internal::ImeTextSpanThickness_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ImeTextSpanUnderlineStyle : int32_t {
  
  kNone = 0,
  
  kSolid = 1,
  
  kDot = 2,
  
  kDash = 3,
  
  kSquiggle = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ImeTextSpanUnderlineStyle value);
inline bool IsKnownEnumValue(ImeTextSpanUnderlineStyle value) {
  return internal::ImeTextSpanUnderlineStyle_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ImeTextSpanDataView {
 public:
  ImeTextSpanDataView() = default;

  ImeTextSpanDataView(
      internal::ImeTextSpan_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::ui::mojom::ImeTextSpanType>(
        data_value, output);
  }
  ImeTextSpanType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::ImeTextSpanType>(data_->type));
  }
  uint32_t start_offset() const {
    return data_->start_offset;
  }
  uint32_t end_offset() const {
    return data_->end_offset;
  }
  uint32_t underline_color() const {
    return data_->underline_color;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadThickness(UserType* output) const {
    auto data_value = data_->thickness;
    return mojo::internal::Deserialize<::ui::mojom::ImeTextSpanThickness>(
        data_value, output);
  }
  ImeTextSpanThickness thickness() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::ImeTextSpanThickness>(data_->thickness));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUnderlineStyle(UserType* output) const {
    auto data_value = data_->underline_style;
    return mojo::internal::Deserialize<::ui::mojom::ImeTextSpanUnderlineStyle>(
        data_value, output);
  }
  ImeTextSpanUnderlineStyle underline_style() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::ImeTextSpanUnderlineStyle>(data_->underline_style));
  }
  uint32_t text_color() const {
    return data_->text_color;
  }
  uint32_t background_color() const {
    return data_->background_color;
  }
  uint32_t suggestion_highlight_color() const {
    return data_->suggestion_highlight_color;
  }
  bool remove_on_finish_composing() const {
    return data_->remove_on_finish_composing;
  }
  bool interim_char_selection() const {
    return data_->interim_char_selection;
  }
  inline void GetSuggestionsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestions(UserType* output) {
    
    auto* pointer = data_->suggestions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ImeTextSpan_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ui::mojom

namespace std {

template <>
struct hash<::ui::mojom::TextInputMode>
    : public mojo::internal::EnumHashImpl<::ui::mojom::TextInputMode> {};

template <>
struct hash<::ui::mojom::TextInputAction>
    : public mojo::internal::EnumHashImpl<::ui::mojom::TextInputAction> {};

template <>
struct hash<::ui::mojom::TextInputType>
    : public mojo::internal::EnumHashImpl<::ui::mojom::TextInputType> {};

template <>
struct hash<::ui::mojom::ImeTextSpanType>
    : public mojo::internal::EnumHashImpl<::ui::mojom::ImeTextSpanType> {};

template <>
struct hash<::ui::mojom::ImeTextSpanThickness>
    : public mojo::internal::EnumHashImpl<::ui::mojom::ImeTextSpanThickness> {};

template <>
struct hash<::ui::mojom::ImeTextSpanUnderlineStyle>
    : public mojo::internal::EnumHashImpl<::ui::mojom::ImeTextSpanUnderlineStyle> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::TextInputMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ui::mojom::TextInputMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ui::mojom::TextInputMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::TextInputAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ui::mojom::TextInputAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ui::mojom::TextInputAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::TextInputType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ui::mojom::TextInputType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ui::mojom::TextInputType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::ImeTextSpanType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ui::mojom::ImeTextSpanType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ui::mojom::ImeTextSpanType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::ImeTextSpanThickness, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ui::mojom::ImeTextSpanThickness, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ui::mojom::ImeTextSpanThickness>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::ImeTextSpanUnderlineStyle, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ui::mojom::ImeTextSpanUnderlineStyle, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ui::mojom::ImeTextSpanUnderlineStyle>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::ImeTextSpanDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::ImeTextSpanDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::ImeTextSpan_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::ui::mojom::ImeTextSpanType>(
        Traits::type(input), &fragment->type);
    fragment->start_offset = Traits::start_offset(input);
    fragment->end_offset = Traits::end_offset(input);
    fragment->underline_color = Traits::underline_color(input);
    mojo::internal::Serialize<::ui::mojom::ImeTextSpanThickness>(
        Traits::thickness(input), &fragment->thickness);
    mojo::internal::Serialize<::ui::mojom::ImeTextSpanUnderlineStyle>(
        Traits::underline_style(input), &fragment->underline_style);
    fragment->text_color = Traits::text_color(input);
    fragment->background_color = Traits::background_color(input);
    fragment->suggestion_highlight_color = Traits::suggestion_highlight_color(input);
    fragment->remove_on_finish_composing = Traits::remove_on_finish_composing(input);
    fragment->interim_char_selection = Traits::interim_char_selection(input);
    decltype(Traits::suggestions(input)) in_suggestions = Traits::suggestions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggestions)::BaseType>
        suggestions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_suggestions, suggestions_fragment, &suggestions_validate_params);
    fragment->suggestions.Set(
        suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->suggestions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null suggestions in ImeTextSpan struct");
  }

  static bool Deserialize(::ui::mojom::internal::ImeTextSpan_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::ImeTextSpanDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ui::mojom {

inline void ImeTextSpanDataView::GetSuggestionsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->suggestions.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // ui::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::ui::mojom::TextInputMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ui::mojom::TextInputMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::ui::mojom::TextInputAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ui::mojom::TextInputAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::ui::mojom::TextInputType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ui::mojom::TextInputType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::ui::mojom::ImeTextSpanType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ui::mojom::ImeTextSpanType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::ui::mojom::ImeTextSpanThickness> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ui::mojom::ImeTextSpanThickness value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::ui::mojom::ImeTextSpanUnderlineStyle> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ui::mojom::ImeTextSpanUnderlineStyle value);
};

} // namespace perfetto

#endif  // UI_BASE_IME_MOJOM_IME_TYPES_MOJOM_SHARED_H_