// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INFO_H_
#define CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INFO_H_

#include <stdint.h>

#include <optional>

#include "base/time/time.h"
#include "components/attribution_reporting/suitable_origin.h"
#include "content/common/content_export.h"

namespace content {

// Contains information associated with a trigger.
struct CONTENT_EXPORT AttributionInfo {
  AttributionInfo(base::Time time,
                  std::optional<uint64_t> debug_key,
                  attribution_reporting::SuitableOrigin context_origin);
  ~AttributionInfo();

  AttributionInfo(const AttributionInfo&);
  AttributionInfo(AttributionInfo&&);

  AttributionInfo& operator=(const AttributionInfo&);
  AttributionInfo& operator=(AttributionInfo&&);

  // The time the trigger occurred.
  base::Time time;

  std::optional<uint64_t> debug_key;

  // The secondary owner of the reports generated by the trigger. For real
  // reports, this is the destination origin. For fake reports, it is the source
  // origin.
  attribution_reporting::SuitableOrigin context_origin;

  friend bool operator==(const AttributionInfo&,
                         const AttributionInfo&) = default;
};

}  // namespace content

#endif  // CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INFO_H_
