/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/source3/librpc/gen_ndr/ndr_open_files.h"

#include "librpc/gen_ndr/ndr_server_id.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_file_id.h"
#include "librpc/gen_ndr/ndr_smb2_lease_struct.h"
#include "librpc/gen_ndr/ndr_misc.h"
_PUBLIC_ enum ndr_err_code ndr_push_share_entry_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_share_entry_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_share_entry_flags(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_ENTRY_FLAG_POSIX_OPEN", SHARE_ENTRY_FLAG_POSIX_OPEN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_ENTRY_FLAG_STREAM_BASEOPEN", SHARE_ENTRY_FLAG_STREAM_BASEOPEN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_ENTRY_FLAG_DENY_DOS", SHARE_ENTRY_FLAG_DENY_DOS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_ENTRY_FLAG_DENY_FCB", SHARE_ENTRY_FLAG_DENY_FCB, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_share_mode_entry_op_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum share_mode_entry_op_type r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_share_mode_entry_op_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum share_mode_entry_op_type *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_share_mode_entry_op_type(struct ndr_print *ndr, const char *name, enum share_mode_entry_op_type r)
{
	const char *val = NULL;

	switch (r) {
		case SHARE_MODE_ENTRY_OP_TYPE_NONE: val = "SHARE_MODE_ENTRY_OP_TYPE_NONE"; break;
		case SHARE_MODE_ENTRY_OP_TYPE_EXCLUSIVE: val = "SHARE_MODE_ENTRY_OP_TYPE_EXCLUSIVE"; break;
		case SHARE_MODE_ENTRY_OP_TYPE_BATCH_WITHOUT_EXCLUSIVE: val = "SHARE_MODE_ENTRY_OP_TYPE_BATCH_WITHOUT_EXCLUSIVE"; break;
		case SHARE_MODE_ENTRY_OP_TYPE_BATCH: val = "SHARE_MODE_ENTRY_OP_TYPE_BATCH"; break;
		case SHARE_MODE_ENTRY_OP_TYPE_LEVEL_II: val = "SHARE_MODE_ENTRY_OP_TYPE_LEVEL_II"; break;
		case SHARE_MODE_ENTRY_OP_TYPE_LEASE: val = "SHARE_MODE_ENTRY_OP_TYPE_LEASE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_share_mode_entry(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct share_mode_entry *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->pid));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->op_mid));
		NDR_CHECK(ndr_push_share_mode_entry_op_type(ndr, NDR_SCALARS, r->op_type));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_push_smb2_lease_key(ndr, NDR_SCALARS, &r->lease_key));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->access_mask));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->share_access));
		NDR_CHECK(ndr_push_timeval(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, r->share_file_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->uid));
		NDR_CHECK(ndr_push_share_entry_flags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->name_hash));
		/* [skip] 'r->stale' */
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_timeval(ndr, NDR_BUFFERS, &r->time));
		/* [skip] 'r->stale' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_share_mode_entry(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct share_mode_entry *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->pid));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->op_mid));
		NDR_CHECK(ndr_pull_share_mode_entry_op_type(ndr, NDR_SCALARS, &r->op_type));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_pull_smb2_lease_key(ndr, NDR_SCALARS, &r->lease_key));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->access_mask));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->share_access));
		NDR_CHECK(ndr_pull_timeval(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, &r->share_file_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->uid));
		NDR_CHECK(ndr_pull_share_entry_flags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->name_hash));
		/* [skip] 'r->stale' */
		NDR_ZERO_STRUCT(r->stale);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_timeval(ndr, NDR_BUFFERS, &r->time));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_share_mode_entry(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct share_mode_entry *r)
{
	ndr_print_share_mode_entry(ndr, name, r);
}

_PUBLIC_ void ndr_print_share_mode_entry(struct ndr_print *ndr, const char *name, const struct share_mode_entry *r)
{
	ndr_print_struct(ndr, name, "share_mode_entry");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_server_id(ndr, "pid", &r->pid);
	ndr_print_hyper(ndr, "op_mid", r->op_mid);
	ndr_print_share_mode_entry_op_type(ndr, "op_type", r->op_type);
	ndr_print_GUID(ndr, "client_guid", &r->client_guid);
	ndr_print_smb2_lease_key(ndr, "lease_key", &r->lease_key);
	ndr_print_uint32(ndr, "access_mask", r->access_mask);
	ndr_print_uint32(ndr, "share_access", r->share_access);
	ndr_print_timeval(ndr, "time", &r->time);
	ndr_print_udlong(ndr, "share_file_id", r->share_file_id);
	ndr_print_uint32(ndr, "uid", r->uid);
	ndr_print_share_entry_flags(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "name_hash", r->name_hash);
	ndr_print_uint8(ndr, "stale", r->stale);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_delete_token(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct delete_token *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->name_hash));
		NDR_CHECK(ndr_push_smb2_lease_key(ndr, NDR_SCALARS, &r->parent_lease_key));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->delete_nt_token));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->delete_token));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->delete_nt_token) {
			NDR_CHECK(ndr_push_security_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->delete_nt_token));
		}
		if (r->delete_token) {
			NDR_CHECK(ndr_push_security_unix_token(ndr, NDR_SCALARS, r->delete_token));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_delete_token(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct delete_token *r)
{
	uint32_t _ptr_delete_nt_token;
	TALLOC_CTX *_mem_save_delete_nt_token_0 = NULL;
	uint32_t _ptr_delete_token;
	TALLOC_CTX *_mem_save_delete_token_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->name_hash));
		NDR_CHECK(ndr_pull_smb2_lease_key(ndr, NDR_SCALARS, &r->parent_lease_key));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_delete_nt_token));
		if (_ptr_delete_nt_token) {
			NDR_PULL_ALLOC(ndr, r->delete_nt_token);
		} else {
			r->delete_nt_token = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_delete_token));
		if (_ptr_delete_token) {
			NDR_PULL_ALLOC(ndr, r->delete_token);
		} else {
			r->delete_token = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->delete_nt_token) {
			_mem_save_delete_nt_token_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->delete_nt_token, 0);
			NDR_CHECK(ndr_pull_security_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->delete_nt_token));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delete_nt_token_0, 0);
		}
		if (r->delete_token) {
			_mem_save_delete_token_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->delete_token, 0);
			NDR_CHECK(ndr_pull_security_unix_token(ndr, NDR_SCALARS, r->delete_token));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delete_token_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_delete_token(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct delete_token *r)
{
	ndr_print_delete_token(ndr, name, r);
}

_PUBLIC_ void ndr_print_delete_token(struct ndr_print *ndr, const char *name, const struct delete_token *r)
{
	ndr_print_struct(ndr, name, "delete_token");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "name_hash", r->name_hash);
	ndr_print_smb2_lease_key(ndr, "parent_lease_key", &r->parent_lease_key);
	ndr_print_ptr(ndr, "delete_nt_token", r->delete_nt_token);
	ndr->depth++;
	if (r->delete_nt_token) {
		ndr_print_security_token(ndr, "delete_nt_token", r->delete_nt_token);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "delete_token", r->delete_token);
	ndr->depth++;
	if (r->delete_token) {
		ndr_print_security_unix_token(ndr, "delete_token", r->delete_token);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_share_mode_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_share_mode_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_share_mode_flags(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_MODE_SHARE_DELETE", SHARE_MODE_SHARE_DELETE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_MODE_SHARE_WRITE", SHARE_MODE_SHARE_WRITE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_MODE_SHARE_READ", SHARE_MODE_SHARE_READ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_MODE_ACCESS_DELETE", SHARE_MODE_ACCESS_DELETE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_MODE_ACCESS_WRITE", SHARE_MODE_ACCESS_WRITE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_MODE_ACCESS_READ", SHARE_MODE_ACCESS_READ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_MODE_LEASE_HANDLE", SHARE_MODE_LEASE_HANDLE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_MODE_LEASE_WRITE", SHARE_MODE_LEASE_WRITE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "SHARE_MODE_LEASE_READ", SHARE_MODE_LEASE_READ, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_share_mode_data(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct share_mode_data *r)
{
	uint32_t cntr_delete_tokens_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->unique_content_epoch));
		NDR_CHECK(ndr_push_share_mode_flags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->servicepath));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->base_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->stream_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_delete_tokens));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_delete_tokens));
		for (cntr_delete_tokens_0 = 0; cntr_delete_tokens_0 < (r->num_delete_tokens); cntr_delete_tokens_0++) {
			NDR_CHECK(ndr_push_delete_token(ndr, NDR_SCALARS, &r->delete_tokens[cntr_delete_tokens_0]));
		}
		/* [skip] 'r->not_stored' */
		/* [skip] 'r->modified' */
		NDR_CHECK(ndr_push_file_id(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->servicepath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->servicepath, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->servicepath, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->servicepath, ndr_charset_length(r->servicepath, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->base_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->base_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->base_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->base_name, ndr_charset_length(r->base_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->stream_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->stream_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->stream_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->stream_name, ndr_charset_length(r->stream_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		for (cntr_delete_tokens_0 = 0; cntr_delete_tokens_0 < (r->num_delete_tokens); cntr_delete_tokens_0++) {
			NDR_CHECK(ndr_push_delete_token(ndr, NDR_BUFFERS, &r->delete_tokens[cntr_delete_tokens_0]));
		}
		/* [skip] 'r->not_stored' */
		/* [skip] 'r->modified' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_share_mode_data(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct share_mode_data *r)
{
	uint32_t _ptr_servicepath;
	uint32_t size_servicepath_1 = 0;
	uint32_t length_servicepath_1 = 0;
	TALLOC_CTX *_mem_save_servicepath_0 = NULL;
	uint32_t _ptr_base_name;
	uint32_t size_base_name_1 = 0;
	uint32_t length_base_name_1 = 0;
	TALLOC_CTX *_mem_save_base_name_0 = NULL;
	uint32_t _ptr_stream_name;
	uint32_t size_stream_name_1 = 0;
	uint32_t length_stream_name_1 = 0;
	TALLOC_CTX *_mem_save_stream_name_0 = NULL;
	uint32_t size_delete_tokens_0 = 0;
	uint32_t cntr_delete_tokens_0;
	TALLOC_CTX *_mem_save_delete_tokens_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->unique_content_epoch));
		NDR_CHECK(ndr_pull_share_mode_flags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servicepath));
		if (_ptr_servicepath) {
			NDR_PULL_ALLOC(ndr, r->servicepath);
		} else {
			r->servicepath = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_base_name));
		if (_ptr_base_name) {
			NDR_PULL_ALLOC(ndr, r->base_name);
		} else {
			r->base_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_stream_name));
		if (_ptr_stream_name) {
			NDR_PULL_ALLOC(ndr, r->stream_name);
		} else {
			r->stream_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_delete_tokens));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->delete_tokens));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->delete_tokens, &size_delete_tokens_0));
		NDR_PULL_ALLOC_N(ndr, r->delete_tokens, size_delete_tokens_0);
		_mem_save_delete_tokens_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->delete_tokens, 0);
		for (cntr_delete_tokens_0 = 0; cntr_delete_tokens_0 < (size_delete_tokens_0); cntr_delete_tokens_0++) {
			NDR_CHECK(ndr_pull_delete_token(ndr, NDR_SCALARS, &r->delete_tokens[cntr_delete_tokens_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delete_tokens_0, 0);
		/* [skip] 'r->not_stored' */
		NDR_ZERO_STRUCT(r->not_stored);
		/* [skip] 'r->modified' */
		NDR_ZERO_STRUCT(r->modified);
		NDR_CHECK(ndr_pull_file_id(ndr, NDR_SCALARS, &r->id));
		if (r->delete_tokens) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->delete_tokens, r->num_delete_tokens));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->servicepath) {
			_mem_save_servicepath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->servicepath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->servicepath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->servicepath));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->servicepath, &size_servicepath_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->servicepath, &length_servicepath_1));
			if (length_servicepath_1 > size_servicepath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_servicepath_1, length_servicepath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_servicepath_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->servicepath, length_servicepath_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servicepath_0, 0);
		}
		if (r->base_name) {
			_mem_save_base_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->base_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->base_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->base_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->base_name, &size_base_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->base_name, &length_base_name_1));
			if (length_base_name_1 > size_base_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_base_name_1, length_base_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_base_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->base_name, length_base_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_base_name_0, 0);
		}
		if (r->stream_name) {
			_mem_save_stream_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->stream_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->stream_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->stream_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->stream_name, &size_stream_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->stream_name, &length_stream_name_1));
			if (length_stream_name_1 > size_stream_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_stream_name_1, length_stream_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_stream_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->stream_name, length_stream_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stream_name_0, 0);
		}
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->delete_tokens, &size_delete_tokens_0));
		_mem_save_delete_tokens_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->delete_tokens, 0);
		for (cntr_delete_tokens_0 = 0; cntr_delete_tokens_0 < (size_delete_tokens_0); cntr_delete_tokens_0++) {
			NDR_CHECK(ndr_pull_delete_token(ndr, NDR_BUFFERS, &r->delete_tokens[cntr_delete_tokens_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delete_tokens_0, 0);
		for (cntr_delete_tokens_0 = 0; cntr_delete_tokens_0 < (size_delete_tokens_0); cntr_delete_tokens_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_share_mode_data(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct share_mode_data *r)
{
	ndr_print_share_mode_data(ndr, name, r);
}

_PUBLIC_ void ndr_print_share_mode_data(struct ndr_print *ndr, const char *name, const struct share_mode_data *r)
{
	uint32_t cntr_delete_tokens_0;
	ndr_print_struct(ndr, name, "share_mode_data");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "unique_content_epoch", r->unique_content_epoch);
	ndr_print_share_mode_flags(ndr, "flags", r->flags);
	ndr_print_ptr(ndr, "servicepath", r->servicepath);
	ndr->depth++;
	if (r->servicepath) {
		ndr_print_string(ndr, "servicepath", r->servicepath);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "base_name", r->base_name);
	ndr->depth++;
	if (r->base_name) {
		ndr_print_string(ndr, "base_name", r->base_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "stream_name", r->stream_name);
	ndr->depth++;
	if (r->stream_name) {
		ndr_print_string(ndr, "stream_name", r->stream_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "num_delete_tokens", r->num_delete_tokens);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "delete_tokens", (uint32_t)(r->num_delete_tokens));
	ndr->depth++;
	for (cntr_delete_tokens_0 = 0; cntr_delete_tokens_0 < (r->num_delete_tokens); cntr_delete_tokens_0++) {
		ndr_print_delete_token(ndr, "delete_tokens", &r->delete_tokens[cntr_delete_tokens_0]);
	}
	ndr->depth--;
	ndr_print_uint8(ndr, "not_stored", r->not_stored);
	ndr_print_uint8(ndr, "modified", r->modified);
	ndr_print_file_id(ndr, "id", &r->id);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_vfs_default_durable_stat(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct vfs_default_durable_stat *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->st_ex_dev));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->st_ex_ino));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->st_ex_mode));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->st_ex_nlink));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->st_ex_uid));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->st_ex_gid));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->st_ex_rdev));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->st_ex_size));
		NDR_CHECK(ndr_push_timespec(ndr, NDR_SCALARS, &r->st_ex_atime));
		NDR_CHECK(ndr_push_timespec(ndr, NDR_SCALARS, &r->st_ex_mtime));
		NDR_CHECK(ndr_push_timespec(ndr, NDR_SCALARS, &r->st_ex_ctime));
		NDR_CHECK(ndr_push_timespec(ndr, NDR_SCALARS, &r->st_ex_btime));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->st_ex_blksize));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->st_ex_blocks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->st_ex_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->st_ex_iflags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_timespec(ndr, NDR_BUFFERS, &r->st_ex_atime));
		NDR_CHECK(ndr_push_timespec(ndr, NDR_BUFFERS, &r->st_ex_mtime));
		NDR_CHECK(ndr_push_timespec(ndr, NDR_BUFFERS, &r->st_ex_ctime));
		NDR_CHECK(ndr_push_timespec(ndr, NDR_BUFFERS, &r->st_ex_btime));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_vfs_default_durable_stat(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct vfs_default_durable_stat *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->st_ex_dev));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->st_ex_ino));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->st_ex_mode));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->st_ex_nlink));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->st_ex_uid));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->st_ex_gid));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->st_ex_rdev));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->st_ex_size));
		NDR_CHECK(ndr_pull_timespec(ndr, NDR_SCALARS, &r->st_ex_atime));
		NDR_CHECK(ndr_pull_timespec(ndr, NDR_SCALARS, &r->st_ex_mtime));
		NDR_CHECK(ndr_pull_timespec(ndr, NDR_SCALARS, &r->st_ex_ctime));
		NDR_CHECK(ndr_pull_timespec(ndr, NDR_SCALARS, &r->st_ex_btime));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->st_ex_blksize));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->st_ex_blocks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->st_ex_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->st_ex_iflags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_timespec(ndr, NDR_BUFFERS, &r->st_ex_atime));
		NDR_CHECK(ndr_pull_timespec(ndr, NDR_BUFFERS, &r->st_ex_mtime));
		NDR_CHECK(ndr_pull_timespec(ndr, NDR_BUFFERS, &r->st_ex_ctime));
		NDR_CHECK(ndr_pull_timespec(ndr, NDR_BUFFERS, &r->st_ex_btime));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_vfs_default_durable_stat(struct ndr_print *ndr, const char *name, const struct vfs_default_durable_stat *r)
{
	ndr_print_struct(ndr, name, "vfs_default_durable_stat");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "st_ex_dev", r->st_ex_dev);
	ndr_print_hyper(ndr, "st_ex_ino", r->st_ex_ino);
	ndr_print_hyper(ndr, "st_ex_mode", r->st_ex_mode);
	ndr_print_hyper(ndr, "st_ex_nlink", r->st_ex_nlink);
	ndr_print_hyper(ndr, "st_ex_uid", r->st_ex_uid);
	ndr_print_hyper(ndr, "st_ex_gid", r->st_ex_gid);
	ndr_print_hyper(ndr, "st_ex_rdev", r->st_ex_rdev);
	ndr_print_hyper(ndr, "st_ex_size", r->st_ex_size);
	ndr_print_timespec(ndr, "st_ex_atime", &r->st_ex_atime);
	ndr_print_timespec(ndr, "st_ex_mtime", &r->st_ex_mtime);
	ndr_print_timespec(ndr, "st_ex_ctime", &r->st_ex_ctime);
	ndr_print_timespec(ndr, "st_ex_btime", &r->st_ex_btime);
	ndr_print_hyper(ndr, "st_ex_blksize", r->st_ex_blksize);
	ndr_print_hyper(ndr, "st_ex_blocks", r->st_ex_blocks);
	ndr_print_uint32(ndr, "st_ex_flags", r->st_ex_flags);
	ndr_print_uint32(ndr, "st_ex_iflags", r->st_ex_iflags);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_vfs_default_durable_cookie(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct vfs_default_durable_cookie *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, VFS_DEFAULT_DURABLE_COOKIE_MAGIC, 0x30, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, VFS_DEFAULT_DURABLE_COOKIE_VERSION));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->allow_reconnect));
		NDR_CHECK(ndr_push_file_id(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->servicepath));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->base_name));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->initial_allocation_size));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->position_information));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->write_time_forced));
		NDR_CHECK(ndr_push_vfs_default_durable_stat(ndr, NDR_SCALARS, &r->stat_info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->servicepath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->servicepath, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->servicepath, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->servicepath, ndr_charset_length(r->servicepath, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->base_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->base_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->base_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->base_name, ndr_charset_length(r->base_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_vfs_default_durable_stat(ndr, NDR_BUFFERS, &r->stat_info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_vfs_default_durable_cookie(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct vfs_default_durable_cookie *r)
{
	uint32_t size_magic_0 = 0;
	uint32_t _ptr_servicepath;
	uint32_t size_servicepath_1 = 0;
	uint32_t length_servicepath_1 = 0;
	TALLOC_CTX *_mem_save_servicepath_0 = NULL;
	uint32_t _ptr_base_name;
	uint32_t size_base_name_1 = 0;
	uint32_t length_base_name_1 = 0;
	TALLOC_CTX *_mem_save_base_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		size_magic_0 = 0x30;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->magic, size_magic_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->allow_reconnect));
		NDR_CHECK(ndr_pull_file_id(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servicepath));
		if (_ptr_servicepath) {
			NDR_PULL_ALLOC(ndr, r->servicepath);
		} else {
			r->servicepath = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_base_name));
		if (_ptr_base_name) {
			NDR_PULL_ALLOC(ndr, r->base_name);
		} else {
			r->base_name = NULL;
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->initial_allocation_size));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->position_information));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->write_time_forced));
		NDR_CHECK(ndr_pull_vfs_default_durable_stat(ndr, NDR_SCALARS, &r->stat_info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->servicepath) {
			_mem_save_servicepath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->servicepath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->servicepath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->servicepath));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->servicepath, &size_servicepath_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->servicepath, &length_servicepath_1));
			if (length_servicepath_1 > size_servicepath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_servicepath_1, length_servicepath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_servicepath_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->servicepath, length_servicepath_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servicepath_0, 0);
		}
		if (r->base_name) {
			_mem_save_base_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->base_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->base_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->base_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->base_name, &size_base_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->base_name, &length_base_name_1));
			if (length_base_name_1 > size_base_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_base_name_1, length_base_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_base_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->base_name, length_base_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_base_name_0, 0);
		}
		NDR_CHECK(ndr_pull_vfs_default_durable_stat(ndr, NDR_BUFFERS, &r->stat_info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_vfs_default_durable_cookie(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct vfs_default_durable_cookie *r)
{
	ndr_print_vfs_default_durable_cookie(ndr, name, r);
}

_PUBLIC_ void ndr_print_vfs_default_durable_cookie(struct ndr_print *ndr, const char *name, const struct vfs_default_durable_cookie *r)
{
	ndr_print_struct(ndr, name, "vfs_default_durable_cookie");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?VFS_DEFAULT_DURABLE_COOKIE_MAGIC:r->magic);
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?VFS_DEFAULT_DURABLE_COOKIE_VERSION:r->version);
	ndr_print_uint8(ndr, "allow_reconnect", r->allow_reconnect);
	ndr_print_file_id(ndr, "id", &r->id);
	ndr_print_ptr(ndr, "servicepath", r->servicepath);
	ndr->depth++;
	if (r->servicepath) {
		ndr_print_string(ndr, "servicepath", r->servicepath);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "base_name", r->base_name);
	ndr->depth++;
	if (r->base_name) {
		ndr_print_string(ndr, "base_name", r->base_name);
	}
	ndr->depth--;
	ndr_print_hyper(ndr, "initial_allocation_size", r->initial_allocation_size);
	ndr_print_hyper(ndr, "position_information", r->position_information);
	ndr_print_uint8(ndr, "write_time_forced", r->write_time_forced);
	ndr_print_vfs_default_durable_stat(ndr, "stat_info", &r->stat_info);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_oplock_break_message(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct oplock_break_message *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_file_id(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, r->share_file_id));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->break_to));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_oplock_break_message(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct oplock_break_message *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_file_id(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, &r->share_file_id));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->break_to));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_oplock_break_message(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct oplock_break_message *r)
{
	ndr_print_oplock_break_message(ndr, name, r);
}

_PUBLIC_ void ndr_print_oplock_break_message(struct ndr_print *ndr, const char *name, const struct oplock_break_message *r)
{
	ndr_print_struct(ndr, name, "oplock_break_message");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_file_id(ndr, "id", &r->id);
	ndr_print_udlong(ndr, "share_file_id", r->share_file_id);
	ndr_print_uint8(ndr, "break_to", r->break_to);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_file_rename_message(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct file_rename_message *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_file_id(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, r->share_file_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->servicepath));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->base_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->stream_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->servicepath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->servicepath, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->servicepath, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->servicepath, ndr_charset_length(r->servicepath, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->base_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->base_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->base_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->base_name, ndr_charset_length(r->base_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->stream_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->stream_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->stream_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->stream_name, ndr_charset_length(r->stream_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_file_rename_message(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct file_rename_message *r)
{
	uint32_t _ptr_servicepath;
	uint32_t size_servicepath_1 = 0;
	uint32_t length_servicepath_1 = 0;
	TALLOC_CTX *_mem_save_servicepath_0 = NULL;
	uint32_t _ptr_base_name;
	uint32_t size_base_name_1 = 0;
	uint32_t length_base_name_1 = 0;
	TALLOC_CTX *_mem_save_base_name_0 = NULL;
	uint32_t _ptr_stream_name;
	uint32_t size_stream_name_1 = 0;
	uint32_t length_stream_name_1 = 0;
	TALLOC_CTX *_mem_save_stream_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_file_id(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, &r->share_file_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servicepath));
		if (_ptr_servicepath) {
			NDR_PULL_ALLOC(ndr, r->servicepath);
		} else {
			r->servicepath = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_base_name));
		if (_ptr_base_name) {
			NDR_PULL_ALLOC(ndr, r->base_name);
		} else {
			r->base_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_stream_name));
		if (_ptr_stream_name) {
			NDR_PULL_ALLOC(ndr, r->stream_name);
		} else {
			r->stream_name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->servicepath) {
			_mem_save_servicepath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->servicepath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->servicepath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->servicepath));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->servicepath, &size_servicepath_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->servicepath, &length_servicepath_1));
			if (length_servicepath_1 > size_servicepath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_servicepath_1, length_servicepath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_servicepath_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->servicepath, length_servicepath_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servicepath_0, 0);
		}
		if (r->base_name) {
			_mem_save_base_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->base_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->base_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->base_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->base_name, &size_base_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->base_name, &length_base_name_1));
			if (length_base_name_1 > size_base_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_base_name_1, length_base_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_base_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->base_name, length_base_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_base_name_0, 0);
		}
		if (r->stream_name) {
			_mem_save_stream_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->stream_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->stream_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->stream_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->stream_name, &size_stream_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->stream_name, &length_stream_name_1));
			if (length_stream_name_1 > size_stream_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_stream_name_1, length_stream_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_stream_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->stream_name, length_stream_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stream_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_file_rename_message(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct file_rename_message *r)
{
	ndr_print_file_rename_message(ndr, name, r);
}

_PUBLIC_ void ndr_print_file_rename_message(struct ndr_print *ndr, const char *name, const struct file_rename_message *r)
{
	ndr_print_struct(ndr, name, "file_rename_message");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_file_id(ndr, "id", &r->id);
	ndr_print_udlong(ndr, "share_file_id", r->share_file_id);
	ndr_print_ptr(ndr, "servicepath", r->servicepath);
	ndr->depth++;
	if (r->servicepath) {
		ndr_print_string(ndr, "servicepath", r->servicepath);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "base_name", r->base_name);
	ndr->depth++;
	if (r->base_name) {
		ndr_print_string(ndr, "base_name", r->base_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "stream_name", r->stream_name);
	ndr->depth++;
	if (r->stream_name) {
		ndr_print_string(ndr, "stream_name", r->stream_name);
	}
	ndr->depth--;
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_open_files
static const struct ndr_interface_public_struct open_files_public_structs[] = {
	{
		.name = "share_mode_entry",
		.struct_size = sizeof(struct share_mode_entry ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_share_mode_entry,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_share_mode_entry,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_share_mode_entry,
	},
	{
		.name = "delete_token",
		.struct_size = sizeof(struct delete_token ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_delete_token,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_delete_token,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_delete_token,
	},
	{
		.name = "share_mode_data",
		.struct_size = sizeof(struct share_mode_data ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_share_mode_data,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_share_mode_data,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_share_mode_data,
	},
	{
		.name = "vfs_default_durable_cookie",
		.struct_size = sizeof(struct vfs_default_durable_cookie ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_vfs_default_durable_cookie,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_vfs_default_durable_cookie,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_vfs_default_durable_cookie,
	},
	{
		.name = "oplock_break_message",
		.struct_size = sizeof(struct oplock_break_message ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_oplock_break_message,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_oplock_break_message,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_oplock_break_message,
	},
	{
		.name = "file_rename_message",
		.struct_size = sizeof(struct file_rename_message ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_file_rename_message,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_file_rename_message,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_file_rename_message,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call open_files_calls[] = {
	{ .name = NULL }
};

static const char * const open_files_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\open_files]", 
};

static const struct ndr_interface_string_array open_files_endpoints = {
	.count	= 1,
	.names	= open_files_endpoint_strings
};

static const char * const open_files_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array open_files_authservices = {
	.count	= 1,
	.names	= open_files_authservice_strings
};


const struct ndr_interface_table ndr_table_open_files = {
	.name		= "open_files",
	.num_calls	= 0,
	.calls		= open_files_calls,
	.num_public_structs	= 6,
	.public_structs		= open_files_public_structs,
	.endpoints	= &open_files_endpoints,
	.authservices	= &open_files_authservices
};

#endif /* SKIP_NDR_TABLE_open_files */
