/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkIsolatedConnectedImageFilter.h"
#include "itkIsolatedConnectedImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
IsolatedConnectedImageFilter::IsolatedConnectedImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
IsolatedConnectedImageFilter::~IsolatedConnectedImageFilter() = default;



//
// ToString
//
std::string IsolatedConnectedImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::IsolatedConnectedImageFilter\n";
  out << "  Seed1: ";
  this->ToStringHelper(out, this->m_Seed1);
  out << std::endl;
  out << "  Seed2: ";
  this->ToStringHelper(out, this->m_Seed2);
  out << std::endl;
  out << "  Lower: ";
  this->ToStringHelper(out, this->m_Lower);
  out << std::endl;
  out << "  Upper: ";
  this->ToStringHelper(out, this->m_Upper);
  out << std::endl;
  out << "  ReplaceValue: ";
  this->ToStringHelper(out, this->m_ReplaceValue);
  out << std::endl;
  out << "  IsolatedValueTolerance: ";
  this->ToStringHelper(out, this->m_IsolatedValueTolerance);
  out << std::endl;
  out << "  FindUpperThreshold: ";
  this->ToStringHelper(out, this->m_FindUpperThreshold);
  out << std::endl;
  out << "  ThresholdingFailed: " << this->m_ThresholdingFailed << std::endl;
  out << "  IsolatedValue: " << this->m_IsolatedValue << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image IsolatedConnectedImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image IsolatedConnectedImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  // Define output image type
  using OutputImageType = itk::Image< uint8_t, InputImageType::ImageDimension >;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::IsolatedConnectedImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  typename FilterType::IndexType itkVecSeed1 = sitkSTLVectorToITK<typename FilterType::IndexType>( this->GetSeed1() );
  filter->SetSeed1( itkVecSeed1 );
  typename FilterType::IndexType itkVecSeed2 = sitkSTLVectorToITK<typename FilterType::IndexType>( this->GetSeed2() );
  filter->SetSeed2( itkVecSeed2 );
  filter->SetLower ( static_cast< typename InputImageType::PixelType> ( this->m_Lower ) );
  filter->SetUpper ( static_cast< typename InputImageType::PixelType> ( this->m_Upper ) );
  filter->SetReplaceValue ( static_cast< typename OutputImageType::PixelType> ( this->m_ReplaceValue ) );
  filter->SetIsolatedValueTolerance ( static_cast< typename InputImageType::PixelType> ( this->m_IsolatedValueTolerance ) );
  filter->SetFindUpperThreshold ( this->m_FindUpperThreshold );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();

  this->m_ThresholdingFailed = filter->GetThresholdingFailed();
  this->m_IsolatedValue = filter->GetIsolatedValue();


  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image IsolatedConnected ( const Image& image1, std::vector<unsigned int> seed1, std::vector<unsigned int> seed2, double lower, double upper, uint8_t replaceValue, double isolatedValueTolerance, bool findUpperThreshold )
{
  IsolatedConnectedImageFilter filter;
  filter.SetSeed1( seed1 );  filter.SetSeed2( seed2 );  filter.SetLower( lower );  filter.SetUpper( upper );  filter.SetReplaceValue( replaceValue );  filter.SetIsolatedValueTolerance( isolatedValueTolerance );  filter.SetFindUpperThreshold( findUpperThreshold );
  return filter.Execute ( image1 );
}


}
