/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkRecursiveGaussianImageFilter.h"
#include "itkRecursiveGaussianImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
RecursiveGaussianImageFilter::RecursiveGaussianImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
RecursiveGaussianImageFilter::~RecursiveGaussianImageFilter() = default;



//
// ToString
//
std::string RecursiveGaussianImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::RecursiveGaussianImageFilter\n";
  out << "  Sigma: ";
  this->ToStringHelper(out, this->m_Sigma);
  out << std::endl;
  out << "  NormalizeAcrossScale: ";
  this->ToStringHelper(out, this->m_NormalizeAcrossScale);
  out << std::endl;
  out << "  Order: ";
  this->ToStringHelper(out, this->m_Order);
  out << std::endl;
  out << "  Direction: ";
  this->ToStringHelper(out, this->m_Direction);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image RecursiveGaussianImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}
Image RecursiveGaussianImageFilter::Execute ( Image&& image1 )
{
  Image &temp = image1;
  auto autoResetInPlace = make_scope_exit([this, &temp]{this->m_InPlace=false; Image moved(std::move(temp));});
  if (temp.IsUnique())
    {
    m_InPlace = true;
    }
  return this->Execute( image1 );
}


//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image RecursiveGaussianImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  //Define output image type
  using OutputImageType = typename InputImageType::template RebindImageType<float>;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::RecursiveGaussianImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  filter->SetSigma ( this->m_Sigma );
  filter->SetNormalizeAcrossScale ( this->m_NormalizeAcrossScale );
  filter->SetOrder ( typename itk::GaussianOrderEnum ( int( this->m_Order ) ) );
  filter->SetDirection ( this->m_Direction );
  filter->SetInPlace( m_InPlace );
         



  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image RecursiveGaussian ( const Image& image1, double sigma, bool normalizeAcrossScale, RecursiveGaussianImageFilter::OrderType order, unsigned int direction )
{
  RecursiveGaussianImageFilter filter;
  filter.SetSigma( sigma );  filter.SetNormalizeAcrossScale( normalizeAcrossScale );  filter.SetOrder( order );  filter.SetDirection( direction );
  return filter.Execute ( image1 );
}
//
// Function to run the Execute method of this filter
//
Image RecursiveGaussian ( Image&& image1, double sigma, bool normalizeAcrossScale, RecursiveGaussianImageFilter::OrderType order, unsigned int direction )
{
  RecursiveGaussianImageFilter filter;
  filter.SetSigma( sigma );  filter.SetNormalizeAcrossScale( normalizeAcrossScale );  filter.SetOrder( order );  filter.SetDirection( direction );
  return filter.Execute ( std::move(image1) );
}

}
