/* THIS FILE IS AUTOGENERATED FROM UDPSocket.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_UDPSOCKETBINDING_H_
#define DOM_UDPSOCKETBINDING_H_

#include "SocketCommonBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "js/Value.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Blob;
struct NativePropertyHooks;
class OwningStringOrBlobOrArrayBufferOrArrayBufferView;
class ProtoAndIfaceCache;
struct UDPOptionsAtoms;
class UDPSocket;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningStringOrBlobOrArrayBufferOrArrayBufferView& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningStringOrBlobOrArrayBufferOrArrayBufferView& aUnion);


class StringOrBlobOrArrayBufferOrArrayBufferView : public AllUnionBase,
                                                   public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<StringOrBlobOrArrayBufferOrArrayBufferView, true, ArrayBuffer, ArrayBufferView>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eBlob,
    eArrayBuffer,
    eArrayBufferView
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eBlob = TypeOrUninit::eBlob,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eArrayBufferView = TypeOrUninit::eArrayBufferView
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<NonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrBlobOrArrayBufferOrArrayBufferView(const StringOrBlobOrArrayBufferOrArrayBufferView&) = delete;
  StringOrBlobOrArrayBufferOrArrayBufferView& operator=(const StringOrBlobOrArrayBufferOrArrayBufferView&) = delete;
public:
  explicit inline StringOrBlobOrArrayBufferOrArrayBufferView()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrBlobOrArrayBufferOrArrayBufferView()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Blob>&
  RawSetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Blob>&
  SetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    Uninit();
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline NonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline mozilla::dom::Blob&
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eBlob: {
        DestroyBlob();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    mValue.mBlob.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrBlobOrArrayBufferOrArrayBufferView : public AllOwningUnionBase,
                                                         public UnionWithTypedArraysBase
{
  friend void ImplCycleCollectionUnlink(OwningStringOrBlobOrArrayBufferOrArrayBufferView& aUnion);
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningStringOrBlobOrArrayBufferOrArrayBufferView, true, ArrayBuffer, ArrayBufferView>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eBlob,
    eArrayBuffer,
    eArrayBufferView
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eBlob = TypeOrUninit::eBlob,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eArrayBufferView = TypeOrUninit::eArrayBufferView
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<OwningNonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<ArrayBuffer > mArrayBuffer;
    UnionMember<ArrayBufferView > mArrayBufferView;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrBlobOrArrayBufferOrArrayBufferView(const OwningStringOrBlobOrArrayBufferOrArrayBufferView&) = delete;
  OwningStringOrBlobOrArrayBufferOrArrayBufferView& operator=(const OwningStringOrBlobOrArrayBufferOrArrayBufferView&) = delete;
public:
  explicit inline OwningStringOrBlobOrArrayBufferOrArrayBufferView()
    : mType(eUninitialized)
  {
  }

  OwningStringOrBlobOrArrayBufferOrArrayBufferView(OwningStringOrBlobOrArrayBufferOrArrayBufferView&& aOther);

  inline ~OwningStringOrBlobOrArrayBufferOrArrayBufferView()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Blob>&
  RawSetAsBlob();

  [[nodiscard]] OwningNonNull<mozilla::dom::Blob>&
  SetAsBlob();

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline OwningNonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline OwningNonNull<mozilla::dom::Blob> const &
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  [[nodiscard]] ArrayBufferView&
  RawSetAsArrayBufferView();

  [[nodiscard]] ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrBlobOrArrayBufferOrArrayBufferView&
  operator=(OwningStringOrBlobOrArrayBufferOrArrayBufferView&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBlob();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();

  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();
};


struct UDPOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mAddressReuse;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mLocalAddress;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint16_t> mLocalPort;
  MOZ_INIT_OUTSIDE_CTOR bool mLoopback;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mRemoteAddress;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint16_t> mRemotePort;

  UDPOptions();

  explicit inline UDPOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  UDPOptions(UDPOptions&& aOther) = default;

  explicit inline UDPOptions(const UDPOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  UDPOptions&
  operator=(const UDPOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, UDPOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastUDPOptions : public UDPOptions
{
  inline FastUDPOptions()
    : UDPOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace UDPSocket_Binding {

  typedef mozilla::dom::UDPSocket NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::UDPSocket* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::UDPSocket,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace UDPSocket_Binding



} // namespace mozilla::dom

#endif // DOM_UDPSOCKETBINDING_H_
