//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/comm/mailnews/base/public/msgIOAuth2Module.idl
//


/// `interface msgIOAuth2ModuleListener : nsISupports`
///

/// ```text
/// /**
///  * A listener callback for OAuth2 SASL authentication. This would be represented
///  * as a promise, but this needs to be consumed by C++ code.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct msgIOAuth2ModuleListener {
    vtable: &'static msgIOAuth2ModuleListenerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for msgIOAuth2ModuleListener.
unsafe impl XpCom for msgIOAuth2ModuleListener {
    const IID: nsIID = nsID(0x9a088b49, 0xbc13, 0x4f99,
        [0x94, 0x78, 0x05, 0x3a, 0x6a, 0x43, 0xe3, 0x70]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for msgIOAuth2ModuleListener {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from msgIOAuth2ModuleListener.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait msgIOAuth2ModuleListenerCoerce {
    /// Cheaply cast a value of this type from a `msgIOAuth2ModuleListener`.
    fn coerce_from(v: &msgIOAuth2ModuleListener) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl msgIOAuth2ModuleListenerCoerce for msgIOAuth2ModuleListener {
    #[inline]
    fn coerce_from(v: &msgIOAuth2ModuleListener) -> &Self {
        v
    }
}

impl msgIOAuth2ModuleListener {
    /// Cast this `msgIOAuth2ModuleListener` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: msgIOAuth2ModuleListenerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for msgIOAuth2ModuleListener {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> msgIOAuth2ModuleListenerCoerce for T {
    #[inline]
    fn coerce_from(v: &msgIOAuth2ModuleListener) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every msgIOAuth2ModuleListener
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct msgIOAuth2ModuleListenerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onSuccess (in ACString aBearerToken); */
    pub OnSuccess: unsafe extern "system" fn (this: *const msgIOAuth2ModuleListener, aBearerToken: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void onFailure (in nsresult aError); */
    pub OnFailure: unsafe extern "system" fn (this: *const msgIOAuth2ModuleListener, aError: nserror::nsresult) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl msgIOAuth2ModuleListener {

    /// ```text
    /// /**
    ///    * Called on successful OAuth2 authentication.
    ///    */
    /// ```
    ///

    /// `void onSuccess (in ACString aBearerToken);`
    #[inline]
    pub unsafe fn OnSuccess(&self, aBearerToken: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).OnSuccess)(self, aBearerToken)
    }



    /// `void onFailure (in nsresult aError);`
    #[inline]
    pub unsafe fn OnFailure(&self, aError: nserror::nsresult) -> ::nserror::nsresult {
        ((*self.vtable).OnFailure)(self, aError)
    }


}


/// `interface msgIOAuth2Module : nsISupports`
///

/// ```text
/// /**
///  * An interface for managing the responsibilities of using OAuth2 to produce a
///  * bearer token, for use in SASL steps.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct msgIOAuth2Module {
    vtable: &'static msgIOAuth2ModuleVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for msgIOAuth2Module.
unsafe impl XpCom for msgIOAuth2Module {
    const IID: nsIID = nsID(0x68c275f8, 0xcfa7, 0x4622,
        [0xb2, 0x79, 0xaf, 0x29, 0x06, 0x16, 0xca, 0xe6]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for msgIOAuth2Module {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from msgIOAuth2Module.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait msgIOAuth2ModuleCoerce {
    /// Cheaply cast a value of this type from a `msgIOAuth2Module`.
    fn coerce_from(v: &msgIOAuth2Module) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl msgIOAuth2ModuleCoerce for msgIOAuth2Module {
    #[inline]
    fn coerce_from(v: &msgIOAuth2Module) -> &Self {
        v
    }
}

impl msgIOAuth2Module {
    /// Cast this `msgIOAuth2Module` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: msgIOAuth2ModuleCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for msgIOAuth2Module {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> msgIOAuth2ModuleCoerce for T {
    #[inline]
    fn coerce_from(v: &msgIOAuth2Module) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every msgIOAuth2Module
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct msgIOAuth2ModuleVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* boolean initFromOutgoing (in nsIMsgOutgoingServer aServer); */
    pub InitFromOutgoing: unsafe extern "system" fn (this: *const msgIOAuth2Module, aServer: *const nsIMsgOutgoingServer, _retval: *mut bool) -> ::nserror::nsresult,

    /* boolean initFromMail (in nsIMsgIncomingServer aServer); */
    pub InitFromMail: unsafe extern "system" fn (this: *const msgIOAuth2Module, aServer: *const nsIMsgIncomingServer, _retval: *mut bool) -> ::nserror::nsresult,

    /* boolean initFromMailWithOptionalOverrides (in nsIMsgIncomingServer aServer, in boolean allowOverrides, in AUTF8String overrideIssuer, in AUTF8String overrideScopes, in Array<AUTF8String> overrideProviderDetails); */
    pub InitFromMailWithOptionalOverrides: unsafe extern "system" fn (this: *const msgIOAuth2Module, aServer: *const nsIMsgIncomingServer, allowOverrides: bool, overrideIssuer: *const ::nsstring::nsACString, overrideScopes: *const ::nsstring::nsACString, overrideProviderDetails: *const thin_vec::ThinVec<::nsstring::nsCString>, _retval: *mut bool) -> ::nserror::nsresult,

    /* boolean initFromHostnameWithOptionalOverrides (in AUTF8String aHostname, in AUTF8String aUsername, in AUTF8String aType, in boolean allowOverrides, in AUTF8String overrideIssuer, in AUTF8String overrideScopes, in Array<AUTF8String> overrideProviderDetails); */
    pub InitFromHostnameWithOptionalOverrides: unsafe extern "system" fn (this: *const msgIOAuth2Module, aHostname: *const ::nsstring::nsACString, aUsername: *const ::nsstring::nsACString, aType: *const ::nsstring::nsACString, allowOverrides: bool, overrideIssuer: *const ::nsstring::nsACString, overrideScopes: *const ::nsstring::nsACString, overrideProviderDetails: *const thin_vec::ThinVec<::nsstring::nsCString>, _retval: *mut bool) -> ::nserror::nsresult,

    /* boolean initFromHostname (in AUTF8String aHostname, in AUTF8String aUsername, in AUTF8String aType); */
    pub InitFromHostname: unsafe extern "system" fn (this: *const msgIOAuth2Module, aHostname: *const ::nsstring::nsACString, aUsername: *const ::nsstring::nsACString, aType: *const ::nsstring::nsACString, _retval: *mut bool) -> ::nserror::nsresult,

    /* void connect (in boolean aWithUI, in msgIOAuth2ModuleListener aCallback); */
    pub Connect: unsafe extern "system" fn (this: *const msgIOAuth2Module, aWithUI: bool, aCallback: *const msgIOAuth2ModuleListener) -> ::nserror::nsresult,

    /* void getAccessToken (in msgIOAuth2ModuleListener listener); */
    pub GetAccessToken: unsafe extern "system" fn (this: *const msgIOAuth2Module, listener: *const msgIOAuth2ModuleListener) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl msgIOAuth2Module {

    /// ```text
    /// /**
    ///    * Initialize the OAuth2 parameters from an outgoing server, and return
    ///    * whether or not we can authenticate with OAuth2.
    ///    *
    ///    * If the prefs for the server don't include an OAuth2 config, but one could
    ///    * be found among the known OAuth2 providers using the server's hostname,
    ///    * this config is used instead and stored in the server's prefs.
    ///    */
    /// ```
    ///

    /// `boolean initFromOutgoing (in nsIMsgOutgoingServer aServer);`
    #[inline]
    pub unsafe fn InitFromOutgoing(&self, aServer: *const nsIMsgOutgoingServer, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).InitFromOutgoing)(self, aServer, _retval)
    }


    /// ```text
    /// /**
    ///    * Initialize the OAuth2 parameters from an incoming server, and return
    ///    * whether or not we can authenticate with OAuth2.
    ///    *
    ///    * If the prefs for the server don't include an OAuth2 config, but one could
    ///    * be found among the known OAuth2 providers using the server's hostname,
    ///    * this config is used instead and stored in the server's prefs.
    ///    */
    /// ```
    ///

    /// `boolean initFromMail (in nsIMsgIncomingServer aServer);`
    #[inline]
    pub unsafe fn InitFromMail(&self, aServer: *const nsIMsgIncomingServer, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).InitFromMail)(self, aServer, _retval)
    }


    /// ```text
    /// /**
    ///    * Initialize the OAuth2 parameters from an incoming server, and return
    ///    * whether or not we can authenticate with OAuth2.
    ///    *
    ///    * If the prefs for the server don't include an OAuth2 config, but one could
    ///    * be found among the known OAuth2 providers using the server's hostname,
    ///    * this config is used instead and stored in the server's prefs.
    ///    *
    ///    * If `allowOverrides` is true, implementations should use the provided
    ///    * override values for the issuer, scopes, and issuer details.
    ///    *
    ///    * The `overrideProviderDetails` array is an associative list with key-value
    ///    * pairs interleaved with one another (i.e. for n key-value pairs, the array
        ///    * will contain 2*n values). These values are used to override default OAuth
    ///    * provider issuer details.
    ///    */
    /// ```
    ///

    /// `boolean initFromMailWithOptionalOverrides (in nsIMsgIncomingServer aServer, in boolean allowOverrides, in AUTF8String overrideIssuer, in AUTF8String overrideScopes, in Array<AUTF8String> overrideProviderDetails);`
    #[inline]
    pub unsafe fn InitFromMailWithOptionalOverrides(&self, aServer: *const nsIMsgIncomingServer, allowOverrides: bool, overrideIssuer: *const ::nsstring::nsACString, overrideScopes: *const ::nsstring::nsACString, overrideProviderDetails: *const thin_vec::ThinVec<::nsstring::nsCString>, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).InitFromMailWithOptionalOverrides)(self, aServer, allowOverrides, overrideIssuer, overrideScopes, overrideProviderDetails, _retval)
    }


    /// ```text
    /// /**
    ///    * Initialize the OAuth2 parameters using the provided hostname, username,
    ///    * and scope type. Returns whether or not we can authenticate with OAuth2.
    ///    *
    ///    * If `allowOverrides` is true, implementations should use the provided
    ///    * override values for the issuer, scopes, and issuer details.
    ///    *
    ///    * The `overrideProviderDetails` array is an associative list with key-value
    ///    * pairs interleaved with one another (i.e. for n key-value pairs, the array
        ///    * will contain 2*n values). These values are used to override default OAuth
    ///    * provider issuer details.
    ///    */
    /// ```
    ///

    /// `boolean initFromHostnameWithOptionalOverrides (in AUTF8String aHostname, in AUTF8String aUsername, in AUTF8String aType, in boolean allowOverrides, in AUTF8String overrideIssuer, in AUTF8String overrideScopes, in Array<AUTF8String> overrideProviderDetails);`
    #[inline]
    pub unsafe fn InitFromHostnameWithOptionalOverrides(&self, aHostname: *const ::nsstring::nsACString, aUsername: *const ::nsstring::nsACString, aType: *const ::nsstring::nsACString, allowOverrides: bool, overrideIssuer: *const ::nsstring::nsACString, overrideScopes: *const ::nsstring::nsACString, overrideProviderDetails: *const thin_vec::ThinVec<::nsstring::nsCString>, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).InitFromHostnameWithOptionalOverrides)(self, aHostname, aUsername, aType, allowOverrides, overrideIssuer, overrideScopes, overrideProviderDetails, _retval)
    }


    /// ```text
    /// /**
    ///    * Initialize the OAuth2 parameters using the provided hostname, username,
    ///    * and scope type. Returns whether or not we can authenticate with OAuth2.
    ///    */
    /// ```
    ///

    /// `boolean initFromHostname (in AUTF8String aHostname, in AUTF8String aUsername, in AUTF8String aType);`
    #[inline]
    pub unsafe fn InitFromHostname(&self, aHostname: *const ::nsstring::nsACString, aUsername: *const ::nsstring::nsACString, aType: *const ::nsstring::nsACString, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).InitFromHostname)(self, aHostname, aUsername, aType, _retval)
    }


    /// ```text
    /// /**
    ///    * Connect to the OAuth2 server to get an access token encoded for use with
    ///    * SASL XOAUTH2.
    ///    *
    ///    * @param aWithUI         If false, do not allow a dialog to be popped up to
    ///    *                        guide the user through the provider's login process.
    ///    * @param aCallback       Listener that handles the async response.
    ///    */
    /// ```
    ///

    /// `void connect (in boolean aWithUI, in msgIOAuth2ModuleListener aCallback);`
    #[inline]
    pub unsafe fn Connect(&self, aWithUI: bool, aCallback: *const msgIOAuth2ModuleListener) -> ::nserror::nsresult {
        ((*self.vtable).Connect)(self, aWithUI, aCallback)
    }


    /// ```text
    /// /**
    ///    * Fetches a current OAuth2 access token, refreshing the session with the
    ///    * provider if needed.
    ///    *
    ///    * Note that unlike `connect()`, this method calls the listener with the raw
    ///    * token (for use in e.g. an HTTP request), without any additional formatting
    ///    * or encoding.
    ///    *
    ///    * @param listener - A listener for receiving the retrieved access token.
    ///    */
    /// ```
    ///

    /// `void getAccessToken (in msgIOAuth2ModuleListener listener);`
    #[inline]
    pub unsafe fn GetAccessToken(&self, listener: *const msgIOAuth2ModuleListener) -> ::nserror::nsresult {
        ((*self.vtable).GetAccessToken)(self, listener)
    }


}


