//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/usdImaging/usdSkelImaging/skeletonSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(UsdSkelImagingSkeletonSchemaTokens,
    USD_SKEL_IMAGING_SKELETON_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdTokenArrayDataSourceHandle
UsdSkelImagingSkeletonSchema::GetJoints() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        UsdSkelImagingSkeletonSchemaTokens->joints);
}

HdTokenArrayDataSourceHandle
UsdSkelImagingSkeletonSchema::GetJointNames() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        UsdSkelImagingSkeletonSchemaTokens->jointNames);
}

HdMatrixArrayDataSourceHandle
UsdSkelImagingSkeletonSchema::GetBindTransforms() const
{
    return _GetTypedDataSource<HdMatrixArrayDataSource>(
        UsdSkelImagingSkeletonSchemaTokens->bindTransforms);
}

HdMatrixArrayDataSourceHandle
UsdSkelImagingSkeletonSchema::GetRestTransforms() const
{
    return _GetTypedDataSource<HdMatrixArrayDataSource>(
        UsdSkelImagingSkeletonSchemaTokens->restTransforms);
}

/*static*/
HdContainerDataSourceHandle
UsdSkelImagingSkeletonSchema::BuildRetained(
        const HdTokenArrayDataSourceHandle &joints,
        const HdTokenArrayDataSourceHandle &jointNames,
        const HdMatrixArrayDataSourceHandle &bindTransforms,
        const HdMatrixArrayDataSourceHandle &restTransforms
)
{
    TfToken _names[4];
    HdDataSourceBaseHandle _values[4];

    size_t _count = 0;

    if (joints) {
        _names[_count] = UsdSkelImagingSkeletonSchemaTokens->joints;
        _values[_count++] = joints;
    }

    if (jointNames) {
        _names[_count] = UsdSkelImagingSkeletonSchemaTokens->jointNames;
        _values[_count++] = jointNames;
    }

    if (bindTransforms) {
        _names[_count] = UsdSkelImagingSkeletonSchemaTokens->bindTransforms;
        _values[_count++] = bindTransforms;
    }

    if (restTransforms) {
        _names[_count] = UsdSkelImagingSkeletonSchemaTokens->restTransforms;
        _values[_count++] = restTransforms;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

UsdSkelImagingSkeletonSchema::Builder &
UsdSkelImagingSkeletonSchema::Builder::SetJoints(
    const HdTokenArrayDataSourceHandle &joints)
{
    _joints = joints;
    return *this;
}

UsdSkelImagingSkeletonSchema::Builder &
UsdSkelImagingSkeletonSchema::Builder::SetJointNames(
    const HdTokenArrayDataSourceHandle &jointNames)
{
    _jointNames = jointNames;
    return *this;
}

UsdSkelImagingSkeletonSchema::Builder &
UsdSkelImagingSkeletonSchema::Builder::SetBindTransforms(
    const HdMatrixArrayDataSourceHandle &bindTransforms)
{
    _bindTransforms = bindTransforms;
    return *this;
}

UsdSkelImagingSkeletonSchema::Builder &
UsdSkelImagingSkeletonSchema::Builder::SetRestTransforms(
    const HdMatrixArrayDataSourceHandle &restTransforms)
{
    _restTransforms = restTransforms;
    return *this;
}

HdContainerDataSourceHandle
UsdSkelImagingSkeletonSchema::Builder::Build()
{
    return UsdSkelImagingSkeletonSchema::BuildRetained(
        _joints,
        _jointNames,
        _bindTransforms,
        _restTransforms
    );
}

/*static*/
UsdSkelImagingSkeletonSchema
UsdSkelImagingSkeletonSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return UsdSkelImagingSkeletonSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                UsdSkelImagingSkeletonSchemaTokens->skeleton))
        : nullptr);
}

/*static*/
const TfToken &
UsdSkelImagingSkeletonSchema::GetSchemaToken()
{
    return UsdSkelImagingSkeletonSchemaTokens->skeleton;
}

/*static*/
const HdDataSourceLocator &
UsdSkelImagingSkeletonSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingSkeletonSchema::GetJointsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingSkeletonSchemaTokens->joints);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingSkeletonSchema::GetJointNamesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingSkeletonSchemaTokens->jointNames);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingSkeletonSchema::GetBindTransformsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingSkeletonSchemaTokens->bindTransforms);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingSkeletonSchema::GetRestTransformsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingSkeletonSchemaTokens->restTransforms);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE