// java wrapper for vtkUnsignedIntArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkUnsignedIntArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkUnsignedIntArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkUnsignedIntArray",dType)) { return me; }
  if ((res= vtkDataArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}

// Array conversion routines
extern "C" JNIEXPORT jintArray JNICALL Java_vtk_vtkUnsignedIntArray_GetJavaArray_10(JNIEnv* env, jobject obj)
{
  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  unsigned int* buffer = op->GetPointer(0);
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(buffer), op->GetSize());
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnsignedIntArray_SetJavaArray_10(JNIEnv* env, jobject obj, jintArray id0, jint len0)
{
  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTuples(len0 / op->GetNumberOfComponents());
  unsigned int* buffer = op->GetPointer(0);
  env->GetIntArrayRegion(id0, 0, len0, reinterpret_cast<jint*>(buffer));
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedIntArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedIntArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedIntArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedIntArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedIntArray_ExtendedNew_14(JNIEnv* env, jobject obj)
{
  vtkUnsignedIntArray * temp20;

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedIntArray_GetDataType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedIntArray_GetValue_16(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned int   temp20;
  temp0 = id0;

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnsignedIntArray_SetValue_17(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
   unsigned int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUnsignedIntArray_SetNumberOfValues_18(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfValues(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnsignedIntArray_InsertValue_19(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
   unsigned int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertValue(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedIntArray_InsertNextValue_110(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedIntArray_FastDownCast_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  vtkUnsignedIntArray * temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FastDownCast(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedIntArray_GetDataTypeValueMin_112(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMin();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedIntArray_GetDataTypeValueMax_113(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkUnsignedIntArray* op = static_cast<vtkUnsignedIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMax();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkUnsignedIntArray_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkUnsignedIntArray::New());
}
