// java wrapper for vtkGenericAttribute object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGenericAttribute.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGenericAttribute_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGenericAttribute",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericAttribute_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericAttribute_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericAttribute_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericAttribute_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGenericAttribute_GetName_14(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericAttribute_GetNumberOfComponents_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponents();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericAttribute_GetCentering_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCentering();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericAttribute_GetType_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericAttribute_GetComponentType_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericAttribute_GetSize_19(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericAttribute_GetActualMemorySize_110(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericAttribute_GetRange_111(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[2];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetRange(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGenericAttribute_GetMaxNorm_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxNorm();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGenericAttribute_GetComponent_113(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkGenericPointIterator * temp1;
  double   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkGenericPointIterator*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponent(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericAttribute_DeepCopy_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGenericAttribute * temp0;
  temp0 = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericAttribute_ShallowCopy_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGenericAttribute * temp0;
  temp0 = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericAttribute* op = static_cast<vtkGenericAttribute*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}
