// java wrapper for vtkGenericCell object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGenericCell.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkCell_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGenericCell_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGenericCell",dType)) { return me; }
  if ((res= vtkCell_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCell_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCell_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetPoints_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetPointIds_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdList * temp0;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointIds(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_ShallowCopy_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCell * temp0;
  temp0 = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_DeepCopy_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCell * temp0;
  temp0 = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_GetCellType_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_GetCellDimension_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_IsLinear_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsLinear();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_RequiresInitialization_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RequiresInitialization();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_Initialize_112(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_RequiresExplicitFaceRepresentation_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RequiresExplicitFaceRepresentation();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_SetCellFaces_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetCellFaces(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCell_GetCellFaces_115(JNIEnv* env, jobject obj)
{
  vtkCellArray * temp20;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellFaces();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_GetCellFaces_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellFaces(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_GetNumberOfEdges_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_GetNumberOfFaces_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCell_GetEdge_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCell_GetFace_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_CellBoundary_121(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CellBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_Contour_122(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jobject id7,jobject id8,jlong id9,jobject id10)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkCellArray * temp4;
  vtkCellArray * temp5;
  vtkPointData * temp6;
  vtkPointData * temp7;
  vtkCellData * temp8;
  long long   temp9;
  vtkCellData * temp10;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id7));
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;
  temp10 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id10));

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->Contour(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_Clip_123(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jlong id7,jobject id8,jint id9)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkPointData * temp4;
  vtkPointData * temp5;
  vtkCellData * temp6;
  long long   temp7;
  vtkCellData * temp8;
  int   temp9;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = id7;
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clip(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_Triangulate_124(JNIEnv* env, jobject obj,jint id0,jobject id1,jobject id2)
{
  int   temp0;
  vtkIdList * temp1;
  vtkPoints * temp2;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id2));

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Triangulate(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_TriangulateLocalIds_125(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateLocalIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_TriangulateIds_126(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_GetParametricCenter_127(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericCell_IsPrimaryCell_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPrimaryCell();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellType_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellType(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToEmptyCell_130(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToEmptyCell();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToVertex_131(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToVertex();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToPolyVertex_132(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToPolyVertex();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToLine_133(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToLine();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToPolyLine_134(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToPolyLine();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToTriangle_135(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToTriangle();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToTriangleStrip_136(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToTriangleStrip();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToPolygon_137(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToPolygon();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToPixel_138(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToPixel();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToQuad_139(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToQuad();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToTetra_140(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToTetra();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToVoxel_141(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToVoxel();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToHexahedron_142(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToHexahedron();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToWedge_143(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToWedge();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToPyramid_144(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToPyramid();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToPentagonalPrism_145(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToPentagonalPrism();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToHexagonalPrism_146(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToHexagonalPrism();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToPolyhedron_147(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToPolyhedron();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToConvexPointSet_148(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToConvexPointSet();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToQuadraticEdge_149(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToQuadraticEdge();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToCubicLine_150(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToCubicLine();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToQuadraticTriangle_151(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToQuadraticTriangle();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToBiQuadraticTriangle_152(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToBiQuadraticTriangle();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToQuadraticQuad_153(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToQuadraticQuad();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToQuadraticPolygon_154(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToQuadraticPolygon();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToQuadraticTetra_155(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToQuadraticTetra();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToQuadraticHexahedron_156(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToQuadraticHexahedron();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToQuadraticWedge_157(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToQuadraticWedge();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToQuadraticPyramid_158(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToQuadraticPyramid();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToQuadraticLinearQuad_159(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToQuadraticLinearQuad();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToBiQuadraticQuad_160(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToBiQuadraticQuad();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToQuadraticLinearWedge_161(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToQuadraticLinearWedge();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToBiQuadraticQuadraticWedge_162(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToBiQuadraticQuadraticWedge();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToTriQuadraticHexahedron_163(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToTriQuadraticHexahedron();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToTriQuadraticPyramid_164(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToTriQuadraticPyramid();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToBiQuadraticQuadraticHexahedron_165(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToBiQuadraticQuadraticHexahedron();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToLagrangeTriangle_166(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToLagrangeTriangle();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToLagrangeTetra_167(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToLagrangeTetra();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToLagrangeCurve_168(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToLagrangeCurve();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToLagrangeQuadrilateral_169(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToLagrangeQuadrilateral();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToLagrangeHexahedron_170(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToLagrangeHexahedron();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToLagrangeWedge_171(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToLagrangeWedge();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToBezierTriangle_172(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToBezierTriangle();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToBezierTetra_173(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToBezierTetra();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToBezierCurve_174(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToBezierCurve();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToBezierQuadrilateral_175(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToBezierQuadrilateral();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToBezierHexahedron_176(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToBezierHexahedron();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericCell_SetCellTypeToBezierWedge_177(JNIEnv* env, jobject obj)
{

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeToBezierWedge();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCell_InstantiateCell_178(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InstantiateCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericCell_GetRepresentativeCell_179(JNIEnv* env, jobject obj)
{
  vtkCell * temp20;

  vtkGenericCell* op = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRepresentativeCell();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGenericCell_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGenericCell::New());
}
