// java wrapper for vtkGenericDataSet object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGenericDataSet.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGenericDataSet_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGenericDataSet",dType)) { return me; }
  if ((res= vtkDataObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericDataSet_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericDataSet_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetNumberOfPoints_14(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetNumberOfCells_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetNumberOfElements_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElements(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericDataSet_GetCellDimension_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericDataSet_GetCellTypes_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellTypes * temp0;
  temp0 = static_cast<vtkCellTypes*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellTypes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_NewCellIterator_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkGenericCellIterator * temp20;
  temp0 = id0;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewCellIterator(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_NewBoundaryIterator_110(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkGenericCellIterator * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewBoundaryIterator(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_NewPointIterator_111(JNIEnv* env, jobject obj)
{
  vtkGenericPointIterator * temp20;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewPointIterator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericDataSet_FindPoint_112(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkGenericPointIterator * temp1;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkGenericPointIterator*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetMTime_113(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericDataSet_ComputeBounds_114(JNIEnv* env, jobject obj)
{

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBounds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericDataSet_GetBounds_115(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericDataSet_GetCenter_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGenericDataSet_GetLength_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLength();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetAttributes_118(JNIEnv* env, jobject obj)
{
  vtkGenericAttributeCollection * temp20;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributes();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetAttributes_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataSetAttributes * temp20;
  temp0 = id0;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributes(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericDataSet_SetTessellator_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGenericCellTessellator * temp0;
  temp0 = static_cast<vtkGenericCellTessellator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTessellator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetTessellator_121(JNIEnv* env, jobject obj)
{
  vtkGenericCellTessellator * temp20;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTessellator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetActualMemorySize_122(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericDataSet_GetDataObjectType_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetEstimatedSize_124(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEstimatedSize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetData_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkGenericDataSet * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericDataSet_GetData_126(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkGenericDataSet * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkGenericDataSet* op = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}
