// java wrapper for vtkImageWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageWriter",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageWriter_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageWriter_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageWriter_SetFilePrefix_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFilePrefix(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageWriter_GetFilePrefix_17(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFilePrefix();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageWriter_SetFilePattern_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFilePattern(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageWriter_GetFilePattern_19(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFilePattern();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageWriter_SetFileDimensionality_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileDimensionality(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageWriter_GetFileDimensionality_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileDimensionality();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageWriter_GetInput_112(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageWriter_Write_113(JNIEnv* env, jobject obj)
{

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->Write();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageWriter_DeleteFiles_114(JNIEnv* env, jobject obj)
{

  vtkImageWriter* op = static_cast<vtkImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeleteFiles();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageWriter::New());
}
