// java wrapper for vtkSQLDatabase object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSQLDatabase.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSQLDatabase_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSQLDatabase",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSQLDatabase_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSQLDatabase_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLDatabase_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLDatabase_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSQLDatabase_Open_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Open(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSQLDatabase_Close_15(JNIEnv* env, jobject obj)
{

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->Close();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSQLDatabase_IsOpen_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsOpen();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLDatabase_GetQueryInstance_17(JNIEnv* env, jobject obj)
{
  vtkSQLQuery * temp20;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetQueryInstance();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSQLDatabase_HasError_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasError();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSQLDatabase_GetLastErrorText_19(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastErrorText();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSQLDatabase_GetDatabaseType_110(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDatabaseType();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLDatabase_GetTables_111(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTables();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLDatabase_GetRecord_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkStringArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRecord(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSQLDatabase_IsSupported_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSupported(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSQLDatabase_GetURL_114(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetURL();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSQLDatabase_GetTablePreamble_115(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  vtkStdString   temp20;
  temp0 = (id0 != 0) ? true : false;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTablePreamble(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSQLDatabase_GetColumnSpecification_116(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkSQLDatabaseSchema * temp0;
  int   temp1;
  int   temp2;
  vtkStdString   temp20;
  temp0 = static_cast<vtkSQLDatabaseSchema*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnSpecification(temp0,temp1,temp2);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSQLDatabase_GetTriggerSpecification_117(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkSQLDatabaseSchema * temp0;
  int   temp1;
  int   temp2;
  vtkStdString   temp20;
  temp0 = static_cast<vtkSQLDatabaseSchema*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTriggerSpecification(temp0,temp1,temp2);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLDatabase_CreateFromURL_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkSQLDatabase * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateFromURL(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSQLDatabase_EffectSchema_119(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkSQLDatabaseSchema * temp0;
  bool   temp1;
  bool   temp20;
  temp0 = static_cast<vtkSQLDatabaseSchema*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EffectSchema(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSQLDatabase_UnRegisterAllCreateFromURLCallbacks_120(JNIEnv* env, jobject obj)
{

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnRegisterAllCreateFromURLCallbacks();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLDatabase_DATABASE_121(JNIEnv* env, jobject obj)
{
  vtkInformationObjectBaseKey * temp20;

  vtkSQLDatabase* op = static_cast<vtkSQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DATABASE();
  return reinterpret_cast<jlong>(temp20);
}
