// java wrapper for vtkProperty2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkProperty2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkProperty2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkProperty2D",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProperty2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProperty2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_DeepCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty2D * temp0;
  temp0 = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_SetColor_15(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_SetColor_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProperty2D_GetColor_17(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty2D_GetOpacity_18(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_SetOpacity_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOpacity(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_SetPointSize_110(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointSize(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty2D_GetPointSizeMinValue_111(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointSizeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty2D_GetPointSizeMaxValue_112(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointSizeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty2D_GetPointSize_113(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_SetLineWidth_114(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineWidth(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty2D_GetLineWidthMinValue_115(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineWidthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty2D_GetLineWidthMaxValue_116(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineWidthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty2D_GetLineWidth_117(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineWidth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_SetLineStipplePattern_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineStipplePattern(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty2D_GetLineStipplePattern_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineStipplePattern();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_SetLineStippleRepeatFactor_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineStippleRepeatFactor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty2D_GetLineStippleRepeatFactorMinValue_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineStippleRepeatFactorMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty2D_GetLineStippleRepeatFactorMaxValue_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineStippleRepeatFactorMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty2D_GetLineStippleRepeatFactor_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineStippleRepeatFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_SetDisplayLocation_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty2D_GetDisplayLocationMinValue_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplayLocationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty2D_GetDisplayLocationMaxValue_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplayLocationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty2D_GetDisplayLocation_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplayLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_SetDisplayLocationToBackground_128(JNIEnv* env, jobject obj)
{

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayLocationToBackground();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_SetDisplayLocationToForeground_129(JNIEnv* env, jobject obj)
{

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayLocationToForeground();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty2D_Render_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProperty2D* op = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkProperty2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkProperty2D::New());
}
