/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedWebDriverBidiDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "WebDriverBidiFrontendDispatchers.h"

#include <JavaScriptCore/InspectorFrontendRouter.h>

namespace Inspector {

#if ENABLE(WEBDRIVER_BIDI)
void BidiBrowsingContextFrontendDispatcher::userPromptClosed(const String& context, Protocol::BidiBrowsingContext::UserPromptType type, bool accepted, const String& opt_userText)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "browsingContext.userPromptClosed"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("context"_s, context);
    protocol_paramsObject->setString("type"_s, Protocol::WebDriverBidiHelpers::getEnumConstantValue(type));
    protocol_paramsObject->setBoolean("accepted"_s, accepted);
    if (!!opt_userText)
        protocol_paramsObject->setString("userText"_s, opt_userText);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void BidiBrowsingContextFrontendDispatcher::userPromptOpened(const String& context, Protocol::BidiBrowsingContext::UserPromptType type, Protocol::BidiSession::UserPromptHandlerType handler, const String& message, const String& opt_defaultValue)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "browsingContext.userPromptOpened"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("context"_s, context);
    protocol_paramsObject->setString("type"_s, Protocol::WebDriverBidiHelpers::getEnumConstantValue(type));
    protocol_paramsObject->setString("handler"_s, Protocol::WebDriverBidiHelpers::getEnumConstantValue(handler));
    protocol_paramsObject->setString("message"_s, message);
    if (!!opt_defaultValue)
        protocol_paramsObject->setString("defaultValue"_s, opt_defaultValue);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}
#endif // ENABLE(WEBDRIVER_BIDI)

#if ENABLE(WEBDRIVER_BIDI)
void BidiLogFrontendDispatcher::entryAdded(const String& level, const String& source, const String& text, double timestamp, const String& type, const String& opt_method)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "log.entryAdded"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("level"_s, level);
    protocol_paramsObject->setString("source"_s, source);
    protocol_paramsObject->setString("text"_s, text);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setString("type"_s, type);
    if (!!opt_method)
        protocol_paramsObject->setString("method"_s, opt_method);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}
#endif // ENABLE(WEBDRIVER_BIDI)

} // namespace Inspector
