/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSPaintSize.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSPaintSizeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPaintSize_width);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPaintSize_height);

class JSCSSPaintSizePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSPaintSizePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSPaintSizePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSPaintSizePrototype>(vm)) JSCSSPaintSizePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSPaintSizePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSPaintSizePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSPaintSizePrototype, JSCSSPaintSizePrototype::Base);

using JSCSSPaintSizeDOMConstructor = JSDOMConstructorNotConstructable<JSCSSPaintSize>;

template<> const ClassInfo JSCSSPaintSizeDOMConstructor::s_info = { "CSSPaintSize"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSPaintSizeDOMConstructor) };

template<> JSValue JSCSSPaintSizeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCSSPaintSizeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSPaintSize"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSPaintSize::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSCSSPaintSizePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPaintSizeConstructor, 0 } },
    HashTableValue { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPaintSize_width, 0 } },
    HashTableValue { "height"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPaintSize_height, 0 } },
};

const ClassInfo JSCSSPaintSizePrototype::s_info = { "CSSPaintSize"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSPaintSizePrototype) };

void JSCSSPaintSizePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSPaintSize::info(), JSCSSPaintSizePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSPaintSize::s_info = { "CSSPaintSize"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSPaintSize) };

JSCSSPaintSize::JSCSSPaintSize(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSPaintSize>&& impl)
    : JSDOMWrapper<CSSPaintSize>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSPaintSize>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSPaintSize::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSPaintSizePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCSSPaintSizePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSPaintSize::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSPaintSize>(vm, globalObject);
}

JSValue JSCSSPaintSize::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSPaintSizeDOMConstructor, DOMConstructorID::CSSPaintSize>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCSSPaintSize::destroy(JSC::JSCell* cell)
{
    JSCSSPaintSize* thisObject = static_cast<JSCSSPaintSize*>(cell);
    thisObject->JSCSSPaintSize::~JSCSSPaintSize();
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPaintSizeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSPaintSizePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSPaintSize::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSPaintSize_widthGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPaintSize& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPaintSize_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPaintSize>::get<jsCSSPaintSize_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSPaintSize_heightGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPaintSize& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPaintSize_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPaintSize>::get<jsCSSPaintSize_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSPaintSize::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSPaintSize, UseCustomHeapCellType::No>(vm, "JSCSSPaintSize"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSPaintSize.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSPaintSize = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSPaintSize.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSPaintSize = std::forward<decltype(space)>(space); }
    );
}

void JSCSSPaintSize::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSPaintSize*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSCSSPaintSizeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCSSPaintSizeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCSSPaintSize = static_cast<JSCSSPaintSize*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCSSPaintSize->protectedWrapped().ptr(), jsCSSPaintSize);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSPaintSize@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12CSSPaintSizeE[]; }
#endif
template<std::same_as<CSSPaintSize> T>
static inline void verifyVTable(CSSPaintSize* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSPaintSize@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12CSSPaintSizeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSPaintSize has subclasses. If CSSPaintSize has subclasses that get passed
        // to toJS() we currently require CSSPaintSize you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSPaintSize>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSPaintSize>(impl.ptr());
#endif
    return createWrapper<CSSPaintSize>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSPaintSize& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSPaintSize* JSCSSPaintSize::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSPaintSize*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
