/* zeitgeist-fts.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from zeitgeist-fts.vala, do not modify */

/* zeitgeist-fts.vala
 *
 * Copyright © 2012 Canonical Ltd.
 * Copyright © 2012 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#define _GNU_SOURCE

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "zeitgeist.h"
#include "zeitgeist-internal.h"
#include "fts.h"
#include "zeitgeist-datamodel.h"
#include <float.h>
#include <math.h>
#include <signal.h>
#include <stdio.h>
#include "config.h"

#define ZEITGEIST_FTS_DAEMON_DBUS_NAME "org.gnome.zeitgeist.SimpleIndexer"
#define ZEITGEIST_FTS_DAEMON_ZEITGEIST_DBUS_NAME "org.gnome.zeitgeist.Engine"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ZEITGEIST_TYPE_REMOTE_DBUS (zeitgeist_remote_dbus_get_type ())
#define ZEITGEIST_REMOTE_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_DBUS, ZeitgeistRemoteDBus))
#define ZEITGEIST_IS_REMOTE_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_DBUS))
#define ZEITGEIST_REMOTE_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_DBUS, ZeitgeistRemoteDBusIface))

typedef struct _ZeitgeistRemoteDBus ZeitgeistRemoteDBus;
typedef struct _ZeitgeistRemoteDBusIface ZeitgeistRemoteDBusIface;

#define ZEITGEIST_TYPE_REMOTE_DBUS_PROXY (zeitgeist_remote_dbus_proxy_get_type ())
typedef GDBusProxy ZeitgeistRemoteDBusProxy;
typedef GDBusProxyClass ZeitgeistRemoteDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define ZEITGEIST_TYPE_FTS_DAEMON (zeitgeist_fts_daemon_get_type ())
#define ZEITGEIST_FTS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_FTS_DAEMON, ZeitgeistFtsDaemon))
#define ZEITGEIST_FTS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_FTS_DAEMON, ZeitgeistFtsDaemonClass))
#define ZEITGEIST_IS_FTS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_FTS_DAEMON))
#define ZEITGEIST_IS_FTS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_FTS_DAEMON))
#define ZEITGEIST_FTS_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_FTS_DAEMON, ZeitgeistFtsDaemonClass))

typedef struct _ZeitgeistFtsDaemon ZeitgeistFtsDaemon;
typedef struct _ZeitgeistFtsDaemonClass ZeitgeistFtsDaemonClass;
typedef struct _ZeitgeistFtsDaemonPrivate ZeitgeistFtsDaemonPrivate;
enum  {
	ZEITGEIST_FTS_DAEMON_0_PROPERTY,
	ZEITGEIST_FTS_DAEMON_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_fts_daemon_properties[ZEITGEIST_FTS_DAEMON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _zeitgeist_indexer_free0(var) ((var == NULL) ? NULL : (var = (zeitgeist_indexer_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistFtsDaemonNotifyInsertData ZeitgeistFtsDaemonNotifyInsertData;
typedef struct _ZeitgeistFtsDaemonNotifyDeleteData ZeitgeistFtsDaemonNotifyDeleteData;
typedef struct _ZeitgeistFtsDaemonSearchData ZeitgeistFtsDaemonSearchData;
typedef struct _ZeitgeistFtsDaemonSearchWithRelevanciesData ZeitgeistFtsDaemonSearchWithRelevanciesData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _ZeitgeistRemoteDBusIface {
	GTypeInterface parent_iface;
	gboolean (*name_has_owner) (ZeitgeistRemoteDBus* self, const gchar* name, GError** error);
};

struct _ZeitgeistFtsDaemon {
	GObject parent_instance;
	ZeitgeistFtsDaemonPrivate * priv;
};

struct _ZeitgeistFtsDaemonClass {
	GObjectClass parent_class;
};

struct _ZeitgeistFtsDaemonPrivate {
	ZeitgeistDbReader* engine;
	ZeitgeistIndexer* indexer;
	guint indexer_register_id;
	guint monitor_register_id;
	GDBusConnection* connection;
};

struct _ZeitgeistFtsDaemonNotifyInsertData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistFtsDaemon* self;
	GVariant* time_range;
	GVariant* events;
	GPtrArray* events_arr;
	GPtrArray* _tmp0_;
	ZeitgeistIndexer* _tmp1_;
	GError* _inner_error0_;
};

struct _ZeitgeistFtsDaemonNotifyDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistFtsDaemon* self;
	GVariant* time_range;
	guint32* event_ids;
	gint event_ids_length1;
	ZeitgeistIndexer* _tmp0_;
};

struct _ZeitgeistFtsDaemonSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistFtsDaemon* self;
	gchar* query_string;
	GVariant* time_range;
	GVariant* filter_templates;
	guint offset;
	guint count;
	guint result_type;
	GCancellable* cancellable;
	GVariant* events;
	guint matches;
	ZeitgeistTimeRange* tr;
	ZeitgeistTimeRange* _tmp0_;
	GPtrArray* templates;
	GPtrArray* _tmp1_;
	GPtrArray* results;
	ZeitgeistFtsDaemon* _tmp2_;
	ZeitgeistIndexer* _tmp3_;
	ZeitgeistTimeRange* _tmp4_;
	GPtrArray* _tmp5_;
	guint _tmp6_;
	GPtrArray* _tmp7_;
	GPtrArray* _tmp8_;
	GVariant* _tmp9_;
	GError* _inner_error0_;
};

struct _ZeitgeistFtsDaemonSearchWithRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistFtsDaemon* self;
	gchar* query_string;
	GVariant* time_range;
	GVariant* filter_templates;
	guint storage_state;
	guint offset;
	guint count;
	guint result_type;
	GCancellable* cancellable;
	GVariant* events;
	gdouble* relevancies;
	gint relevancies_length1;
	guint matches;
	ZeitgeistTimeRange* tr;
	ZeitgeistTimeRange* _tmp0_;
	GPtrArray* templates;
	GPtrArray* _tmp1_;
	GPtrArray* results;
	ZeitgeistFtsDaemon* _tmp2_;
	ZeitgeistIndexer* _tmp3_;
	ZeitgeistTimeRange* _tmp4_;
	GPtrArray* _tmp5_;
	gdouble* _tmp6_;
	gint _tmp7_;
	guint _tmp8_;
	GPtrArray* _tmp9_;
	GPtrArray* _tmp10_;
	GVariant* _tmp11_;
	GError* _inner_error0_;
};

static gint ZeitgeistFtsDaemon_private_offset;
static gpointer zeitgeist_fts_daemon_parent_class = NULL;
static gboolean zeitgeist_fts_daemon_show_version_info;
static gchar* zeitgeist_fts_daemon_log_level;
static gboolean zeitgeist_fts_daemon_show_version_info = FALSE;
static gchar* zeitgeist_fts_daemon_log_level = NULL;
static ZeitgeistFtsDaemon* zeitgeist_fts_daemon_instance;
static ZeitgeistFtsDaemon* zeitgeist_fts_daemon_instance = NULL;
static GMainLoop* zeitgeist_fts_daemon_mainloop;
static GMainLoop* zeitgeist_fts_daemon_mainloop = NULL;
static gboolean zeitgeist_fts_daemon_name_acquired;
static gboolean zeitgeist_fts_daemon_name_acquired = FALSE;
static gboolean zeitgeist_fts_daemon_zeitgeist_up;
static gboolean zeitgeist_fts_daemon_zeitgeist_up = FALSE;
static ZeitgeistRemoteSimpleIndexerIface * zeitgeist_fts_daemon_zeitgeist_remote_simple_indexer_parent_iface = NULL;
static ZeitgeistRemoteMonitorIface * zeitgeist_fts_daemon_zeitgeist_remote_monitor_parent_iface = NULL;

VALA_EXTERN GType zeitgeist_remote_dbus_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint zeitgeist_remote_dbus_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GType zeitgeist_remote_dbus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistRemoteDBus, g_object_unref)
VALA_EXTERN gboolean zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self,
                                               const gchar* name,
                                               GError** error);
static GType zeitgeist_remote_dbus_get_type_once (void);
static void zeitgeist_remote_dbus_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters);
static gboolean zeitgeist_remote_dbus_proxy_name_has_owner (ZeitgeistRemoteDBus* self,
                                                     const gchar* name,
                                                     GError** error);
static void zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init (ZeitgeistRemoteDBusIface* iface);
static void _dbus_zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void zeitgeist_remote_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* zeitgeist_remote_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static gboolean zeitgeist_remote_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _zeitgeist_remote_dbus_unregister_object (gpointer user_data);
VALA_EXTERN GType zeitgeist_fts_daemon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistFtsDaemon, g_object_unref)
VALA_EXTERN ZeitgeistFtsDaemon* zeitgeist_fts_daemon_new (GError** error);
VALA_EXTERN ZeitgeistFtsDaemon* zeitgeist_fts_daemon_construct (GType object_type,
                                                    GError** error);
static void zeitgeist_fts_daemon_close (ZeitgeistFtsDaemon* self);
VALA_EXTERN void zeitgeist_fts_daemon_register_dbus_object (ZeitgeistFtsDaemon* self,
                                                GDBusConnection* conn,
                                                GError** error);
VALA_EXTERN void zeitgeist_fts_daemon_unregister_dbus_object (ZeitgeistFtsDaemon* self);
static void zeitgeist_fts_daemon_real_notify_insert_data_free (gpointer _data);
static void zeitgeist_fts_daemon_real_notify_insert (ZeitgeistRemoteMonitor* base,
                                              GVariant* time_range,
                                              GVariant* events,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean zeitgeist_fts_daemon_real_notify_insert_co (ZeitgeistFtsDaemonNotifyInsertData* _data_);
static void zeitgeist_fts_daemon_real_notify_delete_data_free (gpointer _data);
static void zeitgeist_fts_daemon_real_notify_delete (ZeitgeistRemoteMonitor* base,
                                              GVariant* time_range,
                                              guint32* event_ids,
                                              gint event_ids_length1,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean zeitgeist_fts_daemon_real_notify_delete_co (ZeitgeistFtsDaemonNotifyDeleteData* _data_);
static void zeitgeist_fts_daemon_real_search_data_free (gpointer _data);
static void zeitgeist_fts_daemon_real_search (ZeitgeistRemoteSimpleIndexer* base,
                                       const gchar* query_string,
                                       GVariant* time_range,
                                       GVariant* filter_templates,
                                       guint offset,
                                       guint count,
                                       guint result_type,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean zeitgeist_fts_daemon_real_search_co (ZeitgeistFtsDaemonSearchData* _data_);
static void zeitgeist_fts_daemon_real_search_with_relevancies_data_free (gpointer _data);
static void zeitgeist_fts_daemon_real_search_with_relevancies (ZeitgeistRemoteSimpleIndexer* base,
                                                        const gchar* query_string,
                                                        GVariant* time_range,
                                                        GVariant* filter_templates,
                                                        guint storage_state,
                                                        guint offset,
                                                        guint count,
                                                        guint result_type,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static gboolean zeitgeist_fts_daemon_real_search_with_relevancies_co (ZeitgeistFtsDaemonSearchWithRelevanciesData* _data_);
static void zeitgeist_fts_daemon_name_acquired_callback (GDBusConnection* conn);
static void zeitgeist_fts_daemon_name_lost_callback (GDBusConnection* conn);
static void zeitgeist_fts_daemon_zeitgeist_vanished (void);
static void zeitgeist_fts_daemon_run (GError** error);
static void _zeitgeist_fts_daemon_name_acquired_callback_gbus_name_acquired_callback (GDBusConnection* connection,
                                                                               const gchar* name,
                                                                               gpointer self);
static void _zeitgeist_fts_daemon_name_lost_callback_gbus_name_lost_callback (GDBusConnection* connection,
                                                                       const gchar* name,
                                                                       gpointer self);
static void __lambda4_ (void);
static void ___lambda4__gbus_name_appeared_callback (GDBusConnection* connection,
                                              const gchar* name,
                                              const gchar* name_owner,
                                              gpointer self);
static void _zeitgeist_fts_daemon_zeitgeist_vanished_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                           const gchar* name,
                                                                           gpointer self);
static void zeitgeist_fts_daemon_safe_exit (void);
static gint zeitgeist_fts_daemon_main (gchar** args,
                                gint args_length1);
static void _zeitgeist_fts_daemon_safe_exit_sighandler_t (gint signal);
static void ____lambda5_ (void);
static void _____lambda5__glog_func (const gchar* log_domain,
                              GLogLevelFlags log_levels,
                              const gchar* message,
                              gpointer self);
static void zeitgeist_fts_daemon_finalize (GObject * obj);
static GType zeitgeist_fts_daemon_get_type_once (void);

static const GDBusArgInfo _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_in[] = {&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_name, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_out[] = {&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_result, NULL};
static const GDBusMethodInfo _zeitgeist_remote_dbus_dbus_method_info_name_has_owner = {-1, "NameHasOwner", (GDBusArgInfo **) (&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_in), (GDBusArgInfo **) (&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_out), NULL};
static const GDBusMethodInfo * const _zeitgeist_remote_dbus_dbus_method_info[] = {&_zeitgeist_remote_dbus_dbus_method_info_name_has_owner, NULL};
static const GDBusSignalInfo * const _zeitgeist_remote_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_dbus_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_zeitgeist_remote_dbus_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _zeitgeist_remote_dbus_dbus_interface_vtable = {zeitgeist_remote_dbus_dbus_interface_method_call, zeitgeist_remote_dbus_dbus_interface_get_property, zeitgeist_remote_dbus_dbus_interface_set_property};
static const GOptionEntry ZEITGEIST_FTS_DAEMON_options[3] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, &zeitgeist_fts_daemon_show_version_info, "Print program's version number and exit", NULL}, {"log-level", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &zeitgeist_fts_daemon_log_level, "How much information should be printed; possible values: " "DEBUG, INFO, WARNING, ERROR, CRITICAL", "LEVEL"}, {NULL}};

gboolean
zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self,
                                      const gchar* name,
                                      GError** error)
{
	ZeitgeistRemoteDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = ZEITGEIST_REMOTE_DBUS_GET_INTERFACE (self);
	if (_iface_->name_has_owner) {
		return _iface_->name_has_owner (self, name, error);
	}
	return FALSE;
}

static void
zeitgeist_remote_dbus_default_init (ZeitgeistRemoteDBusIface * iface,
                                    gpointer iface_data)
{
}

static GType
zeitgeist_remote_dbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_remote_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType zeitgeist_remote_dbus_type_id;
	zeitgeist_remote_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "ZeitgeistRemoteDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_remote_dbus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_dbus_proxy_get_type);
	g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
	g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_zeitgeist_remote_dbus_dbus_interface_info));
	g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_dbus_register_object);
	return zeitgeist_remote_dbus_type_id;
}

GType
zeitgeist_remote_dbus_get_type (void)
{
	static volatile gsize zeitgeist_remote_dbus_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_remote_dbus_type_id__once)) {
		GType zeitgeist_remote_dbus_type_id;
		zeitgeist_remote_dbus_type_id = zeitgeist_remote_dbus_get_type_once ();
		g_once_init_leave (&zeitgeist_remote_dbus_type_id__once, zeitgeist_remote_dbus_type_id);
	}
	return zeitgeist_remote_dbus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (ZeitgeistRemoteDBusProxy, zeitgeist_remote_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ZEITGEIST_TYPE_REMOTE_DBUS, zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init) )
static void
zeitgeist_remote_dbus_proxy_class_init (ZeitgeistRemoteDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_dbus_proxy_g_signal;
}

static void
zeitgeist_remote_dbus_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters)
{
}

static void
zeitgeist_remote_dbus_proxy_init (ZeitgeistRemoteDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_zeitgeist_remote_dbus_dbus_interface_info));
}

static gboolean
zeitgeist_remote_dbus_proxy_name_has_owner (ZeitgeistRemoteDBus* self,
                                            const gchar* name,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp2_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "NameHasOwner");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp1_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp1_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp2_);
	g_variant_unref (_tmp2_);
	g_object_unref (_reply_message);
	return _result;
}

static void
zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init (ZeitgeistRemoteDBusIface* iface)
{
	iface->name_has_owner = zeitgeist_remote_dbus_proxy_name_has_owner;
}

static void
_dbus_zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp3_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	result = zeitgeist_remote_dbus_name_has_owner (self, name, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (name);
	;
}

static void
zeitgeist_remote_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "NameHasOwner") == 0) {
		_dbus_zeitgeist_remote_dbus_name_has_owner (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
zeitgeist_remote_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
zeitgeist_remote_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
zeitgeist_remote_dbus_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_dbus_dbus_interface_info), &_zeitgeist_remote_dbus_dbus_interface_vtable, data, _zeitgeist_remote_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_zeitgeist_remote_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
zeitgeist_fts_daemon_get_instance_private (ZeitgeistFtsDaemon* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistFtsDaemon_private_offset);
}

ZeitgeistFtsDaemon*
zeitgeist_fts_daemon_construct (GType object_type,
                                GError** error)
{
	ZeitgeistFtsDaemon * self = NULL;
	ZeitgeistDbReader* _tmp0_ = NULL;
	ZeitgeistDbReader* _tmp1_;
	ZeitgeistDbReader* _tmp2_;
	ZeitgeistDbReader* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	ZeitgeistSQLiteDatabase* _tmp5_;
	ZeitgeistIndexer* _tmp6_ = NULL;
	ZeitgeistDbReader* _tmp7_;
	ZeitgeistIndexer* _tmp8_;
	ZeitgeistIndexer* _tmp9_;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistFtsDaemon*) g_object_new (object_type, NULL);
	_tmp1_ = zeitgeist_db_reader_new (&_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp2_;
	_tmp3_ = self->priv->engine;
	_tmp4_ = zeitgeist_db_reader_get_database (_tmp3_);
	_tmp5_ = _tmp4_;
	zeitgeist_sq_lite_database_set_cache_size (_tmp5_, 16);
	_tmp7_ = self->priv->engine;
	_tmp8_ = zeitgeist_indexer_new (_tmp7_, &_inner_error0_);
	_tmp6_ = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp9_ = _tmp6_;
	_tmp6_ = NULL;
	_zeitgeist_indexer_free0 (self->priv->indexer);
	self->priv->indexer = _tmp9_;
	_zeitgeist_indexer_free0 (_tmp6_);
	_g_object_unref0 (_tmp0_);
	return self;
}

ZeitgeistFtsDaemon*
zeitgeist_fts_daemon_new (GError** error)
{
	return zeitgeist_fts_daemon_construct (ZEITGEIST_TYPE_FTS_DAEMON, error);
}

static void
zeitgeist_fts_daemon_close (ZeitgeistFtsDaemon* self)
{
	ZeitgeistDbReader* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->engine;
	zeitgeist_db_reader_close (_tmp0_);
	_zeitgeist_indexer_free0 (self->priv->indexer);
	self->priv->indexer = NULL;
}

void
zeitgeist_fts_daemon_register_dbus_object (ZeitgeistFtsDaemon* self,
                                           GDBusConnection* conn,
                                           GError** error)
{
	guint _tmp0_ = 0U;
	guint _tmp1_;
	guint _tmp2_ = 0U;
	guint _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	self->priv->connection = conn;
	_tmp1_ = zeitgeist_remote_simple_indexer_register_object ((ZeitgeistRemoteSimpleIndexer*) self, conn, "/org/gnome/zeitgeist/index/activity", &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	self->priv->indexer_register_id = _tmp0_;
	_tmp3_ = zeitgeist_remote_monitor_register_object ((ZeitgeistRemoteMonitor*) self, conn, "/org/gnome/zeitgeist/monitor/special", &_inner_error0_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	self->priv->monitor_register_id = _tmp2_;
}

void
zeitgeist_fts_daemon_unregister_dbus_object (ZeitgeistFtsDaemon* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->indexer_register_id != ((guint) 0)) {
		GDBusConnection* _tmp0_;
		_tmp0_ = self->priv->connection;
		g_dbus_connection_unregister_object (_tmp0_, self->priv->indexer_register_id);
		self->priv->indexer_register_id = (guint) 0;
	}
	if (self->priv->monitor_register_id != ((guint) 0)) {
		GDBusConnection* _tmp1_;
		_tmp1_ = self->priv->connection;
		g_dbus_connection_unregister_object (_tmp1_, self->priv->monitor_register_id);
		self->priv->monitor_register_id = (guint) 0;
	}
}

static void
zeitgeist_fts_daemon_real_notify_insert_data_free (gpointer _data)
{
	ZeitgeistFtsDaemonNotifyInsertData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->events);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistFtsDaemonNotifyInsertData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
zeitgeist_fts_daemon_real_notify_insert (ZeitgeistRemoteMonitor* base,
                                         GVariant* time_range,
                                         GVariant* events,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	ZeitgeistFtsDaemon * self;
	ZeitgeistFtsDaemonNotifyInsertData* _data_;
	ZeitgeistFtsDaemon* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (events != NULL);
	self = (ZeitgeistFtsDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistFtsDaemonNotifyInsertData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_fts_daemon_real_notify_insert_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp1_;
	_tmp2_ = _g_variant_ref0 (events);
	_g_variant_unref0 (_data_->events);
	_data_->events = _tmp2_;
	zeitgeist_fts_daemon_real_notify_insert_co (_data_);
}

static void
zeitgeist_fts_daemon_notify_insert_finish (ZeitgeistRemoteMonitor* base,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	ZeitgeistFtsDaemonNotifyInsertData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
zeitgeist_fts_daemon_real_notify_insert_co (ZeitgeistFtsDaemonNotifyInsertData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("zeitgeist-fts.vala:106: got insertion notification");
	_data_->_tmp0_ = zeitgeist_events_from_variant (_data_->events, &_data_->_inner_error0_);
	_data_->events_arr = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->indexer;
	zeitgeist_indexer_index_events (_data_->_tmp1_, _data_->events_arr);
	_g_ptr_array_unref0 (_data_->events_arr);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_fts_daemon_real_notify_delete_data_free (gpointer _data)
{
	ZeitgeistFtsDaemonNotifyDeleteData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistFtsDaemonNotifyDeleteData, _data_);
}

static void
zeitgeist_fts_daemon_real_notify_delete (ZeitgeistRemoteMonitor* base,
                                         GVariant* time_range,
                                         guint32* event_ids,
                                         gint event_ids_length1,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	ZeitgeistFtsDaemon * self;
	ZeitgeistFtsDaemonNotifyDeleteData* _data_;
	ZeitgeistFtsDaemon* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (time_range != NULL);
	self = (ZeitgeistFtsDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistFtsDaemonNotifyDeleteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_fts_daemon_real_notify_delete_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp1_;
	_data_->event_ids = event_ids;
	_data_->event_ids_length1 = event_ids_length1;
	zeitgeist_fts_daemon_real_notify_delete_co (_data_);
}

static void
zeitgeist_fts_daemon_notify_delete_finish (ZeitgeistRemoteMonitor* base,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	ZeitgeistFtsDaemonNotifyDeleteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
zeitgeist_fts_daemon_real_notify_delete_co (ZeitgeistFtsDaemonNotifyDeleteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("zeitgeist-fts.vala:114: got deletion notification");
	_data_->_tmp0_ = _data_->self->priv->indexer;
	zeitgeist_indexer_delete_events (_data_->_tmp0_, _data_->event_ids, (gint) _data_->event_ids_length1);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_fts_daemon_real_search_data_free (gpointer _data)
{
	ZeitgeistFtsDaemonSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query_string);
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->filter_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistFtsDaemonSearchData, _data_);
}

static void
zeitgeist_fts_daemon_real_search (ZeitgeistRemoteSimpleIndexer* base,
                                  const gchar* query_string,
                                  GVariant* time_range,
                                  GVariant* filter_templates,
                                  guint offset,
                                  guint count,
                                  guint result_type,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	ZeitgeistFtsDaemon * self;
	ZeitgeistFtsDaemonSearchData* _data_;
	ZeitgeistFtsDaemon* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (query_string != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (filter_templates != NULL);
	self = (ZeitgeistFtsDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistFtsDaemonSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_fts_daemon_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query_string);
	_g_free0 (_data_->query_string);
	_data_->query_string = _tmp1_;
	_tmp2_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = _g_variant_ref0 (filter_templates);
	_g_variant_unref0 (_data_->filter_templates);
	_data_->filter_templates = _tmp3_;
	_data_->offset = offset;
	_data_->count = count;
	_data_->result_type = result_type;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_fts_daemon_real_search_co (_data_);
}

static void
zeitgeist_fts_daemon_search_finish (ZeitgeistRemoteSimpleIndexer* base,
                                    GAsyncResult* _res_,
                                    GVariant** events,
                                    guint* matches,
                                    GError** error)
{
	ZeitgeistFtsDaemonSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (events) {
		*events = _data_->events;
	} else {
		_g_variant_unref0 (_data_->events);
	}
	_data_->events = NULL;
	if (matches) {
		*matches = _data_->matches;
	}
}

static gboolean
zeitgeist_fts_daemon_real_search_co (ZeitgeistFtsDaemonSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = zeitgeist_time_range_new_from_variant (_data_->time_range, &_data_->_inner_error0_);
	_data_->tr = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->events);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = zeitgeist_events_from_variant (_data_->filter_templates, &_data_->_inner_error0_);
	_data_->templates = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->tr);
		_g_variant_unref0 (_data_->events);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = zeitgeist_fts_daemon_instance;
	_data_->_tmp3_ = _data_->_tmp2_->priv->indexer;
	_data_->_tmp4_ = _data_->tr;
	_data_->_tmp5_ = _data_->templates;
	_data_->_tmp6_ = 0U;
	_data_->_tmp7_ = zeitgeist_indexer_search (_data_->_tmp3_, _data_->query_string, _data_->_tmp4_, _data_->_tmp5_, _data_->offset, _data_->count, (ZeitgeistResultType) _data_->result_type, &_data_->_tmp6_, &_data_->_inner_error0_);
	_data_->matches = _data_->_tmp6_;
	_data_->results = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->templates);
		_g_object_unref0 (_data_->tr);
		_g_variant_unref0 (_data_->events);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->results;
	_data_->_tmp9_ = zeitgeist_events_to_variant (_data_->_tmp8_);
	_g_variant_unref0 (_data_->events);
	_data_->events = _data_->_tmp9_;
	_g_ptr_array_unref0 (_data_->results);
	_g_ptr_array_unref0 (_data_->templates);
	_g_object_unref0 (_data_->tr);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_fts_daemon_real_search_with_relevancies_data_free (gpointer _data)
{
	ZeitgeistFtsDaemonSearchWithRelevanciesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query_string);
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->filter_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistFtsDaemonSearchWithRelevanciesData, _data_);
}

static void
zeitgeist_fts_daemon_real_search_with_relevancies (ZeitgeistRemoteSimpleIndexer* base,
                                                   const gchar* query_string,
                                                   GVariant* time_range,
                                                   GVariant* filter_templates,
                                                   guint storage_state,
                                                   guint offset,
                                                   guint count,
                                                   guint result_type,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	ZeitgeistFtsDaemon * self;
	ZeitgeistFtsDaemonSearchWithRelevanciesData* _data_;
	ZeitgeistFtsDaemon* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (query_string != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (filter_templates != NULL);
	self = (ZeitgeistFtsDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistFtsDaemonSearchWithRelevanciesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_fts_daemon_real_search_with_relevancies_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query_string);
	_g_free0 (_data_->query_string);
	_data_->query_string = _tmp1_;
	_tmp2_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = _g_variant_ref0 (filter_templates);
	_g_variant_unref0 (_data_->filter_templates);
	_data_->filter_templates = _tmp3_;
	_data_->storage_state = storage_state;
	_data_->offset = offset;
	_data_->count = count;
	_data_->result_type = result_type;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_fts_daemon_real_search_with_relevancies_co (_data_);
}

static void
zeitgeist_fts_daemon_search_with_relevancies_finish (ZeitgeistRemoteSimpleIndexer* base,
                                                     GAsyncResult* _res_,
                                                     GVariant** events,
                                                     gdouble** relevancies,
                                                     gint* relevancies_length1,
                                                     guint* matches,
                                                     GError** error)
{
	ZeitgeistFtsDaemonSearchWithRelevanciesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (events) {
		*events = _data_->events;
	} else {
		_g_variant_unref0 (_data_->events);
	}
	_data_->events = NULL;
	if (relevancies) {
		*relevancies = _data_->relevancies;
	} else {
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
	}
	if (relevancies_length1) {
		*relevancies_length1 = _data_->relevancies_length1;
	}
	_data_->relevancies = NULL;
	if (matches) {
		*matches = _data_->matches;
	}
}

static gboolean
zeitgeist_fts_daemon_real_search_with_relevancies_co (ZeitgeistFtsDaemonSearchWithRelevanciesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = zeitgeist_time_range_new_from_variant (_data_->time_range, &_data_->_inner_error0_);
	_data_->tr = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->events);
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = zeitgeist_events_from_variant (_data_->filter_templates, &_data_->_inner_error0_);
	_data_->templates = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->tr);
		_g_variant_unref0 (_data_->events);
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = zeitgeist_fts_daemon_instance;
	_data_->_tmp3_ = _data_->_tmp2_->priv->indexer;
	_data_->_tmp4_ = _data_->tr;
	_data_->_tmp5_ = _data_->templates;
	_data_->_tmp6_ = NULL;
	_data_->_tmp7_ = 0;
	_data_->_tmp8_ = 0U;
	_data_->_tmp9_ = zeitgeist_indexer_search_with_relevancies (_data_->_tmp3_, _data_->query_string, _data_->_tmp4_, _data_->_tmp5_, (ZeitgeistStorageState) _data_->storage_state, _data_->offset, _data_->count, (ZeitgeistResultType) _data_->result_type, &_data_->_tmp6_, &_data_->_tmp7_, &_data_->_tmp8_, &_data_->_inner_error0_);
	_data_->relevancies = (g_free (_data_->relevancies), NULL);
	_data_->relevancies = _data_->_tmp6_;
	_data_->relevancies_length1 = _data_->_tmp7_;
	_data_->matches = _data_->_tmp8_;
	_data_->results = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->templates);
		_g_object_unref0 (_data_->tr);
		_g_variant_unref0 (_data_->events);
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->results;
	_data_->_tmp11_ = zeitgeist_events_to_variant (_data_->_tmp10_);
	_g_variant_unref0 (_data_->events);
	_data_->events = _data_->_tmp11_;
	_g_ptr_array_unref0 (_data_->results);
	_g_ptr_array_unref0 (_data_->templates);
	_g_object_unref0 (_data_->tr);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_fts_daemon_name_acquired_callback (GDBusConnection* conn)
{
	g_return_if_fail (conn != NULL);
	zeitgeist_fts_daemon_name_acquired = TRUE;
}

static void
zeitgeist_fts_daemon_name_lost_callback (GDBusConnection* conn)
{
	if (conn == NULL) {
		GMainLoop* _tmp0_;
		_tmp0_ = zeitgeist_fts_daemon_mainloop;
		g_main_loop_quit (_tmp0_);
	} else {
		gboolean _tmp1_ = FALSE;
		ZeitgeistFtsDaemon* _tmp2_;
		_tmp2_ = zeitgeist_fts_daemon_instance;
		if (_tmp2_ != NULL) {
			_tmp1_ = zeitgeist_fts_daemon_name_acquired;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GMainLoop* _tmp3_;
			_tmp3_ = zeitgeist_fts_daemon_mainloop;
			g_main_loop_quit (_tmp3_);
		}
	}
}

static void
zeitgeist_fts_daemon_zeitgeist_vanished (void)
{
	if (zeitgeist_fts_daemon_zeitgeist_up) {
		GMainLoop* _tmp0_;
		_tmp0_ = zeitgeist_fts_daemon_mainloop;
		g_main_loop_quit (_tmp0_);
	}
	zeitgeist_fts_daemon_zeitgeist_up = FALSE;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
_zeitgeist_fts_daemon_name_acquired_callback_gbus_name_acquired_callback (GDBusConnection* connection,
                                                                          const gchar* name,
                                                                          gpointer self)
{
	zeitgeist_fts_daemon_name_acquired_callback (connection);
}

static void
_zeitgeist_fts_daemon_name_lost_callback_gbus_name_lost_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  gpointer self)
{
	zeitgeist_fts_daemon_name_lost_callback (connection);
}

static void
__lambda4_ (void)
{
	zeitgeist_fts_daemon_zeitgeist_up = TRUE;
}

static void
___lambda4__gbus_name_appeared_callback (GDBusConnection* connection,
                                         const gchar* name,
                                         const gchar* name_owner,
                                         gpointer self)
{
	__lambda4_ ();
}

static void
_zeitgeist_fts_daemon_zeitgeist_vanished_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                      const gchar* name,
                                                                      gpointer self)
{
	zeitgeist_fts_daemon_zeitgeist_vanished ();
}

static void
zeitgeist_fts_daemon_run (GError** error)
{
	GDBusConnection* connection = NULL;
	GDBusConnection* _tmp0_;
	ZeitgeistRemoteDBus* proxy = NULL;
	GDBusConnection* _tmp1_;
	ZeitgeistRemoteDBus* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ZeitgeistRemoteDBus* _tmp4_;
	guint owner_id = 0U;
	GDBusConnection* _tmp16_;
	GMainLoop* _tmp17_;
	GMainLoop* _tmp18_;
	ZeitgeistFtsDaemon* _tmp19_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
	connection = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = connection;
	_tmp2_ = (ZeitgeistRemoteDBus*) g_initable_new (ZEITGEIST_TYPE_REMOTE_DBUS_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", "org.freedesktop.DBus", "g-connection", _tmp1_, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", NULL);
	proxy = (ZeitgeistRemoteDBus*) _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (connection);
		return;
	}
	_tmp4_ = proxy;
	_tmp3_ = zeitgeist_remote_dbus_name_has_owner (_tmp4_, ZEITGEIST_FTS_DAEMON_DBUS_NAME, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (proxy);
		_g_object_unref0 (connection);
		return;
	}
	if (_tmp3_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE, "The FTS daemon is running already.");
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (proxy);
		_g_object_unref0 (connection);
		return;
	}
	{
		ZeitgeistFtsDaemon* _tmp6_ = NULL;
		ZeitgeistFtsDaemon* _tmp7_;
		ZeitgeistFtsDaemon* _tmp8_;
		ZeitgeistFtsDaemon* _tmp9_;
		GDBusConnection* _tmp10_;
		_tmp7_ = zeitgeist_fts_daemon_new (&_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (zeitgeist_fts_daemon_instance);
		zeitgeist_fts_daemon_instance = _tmp8_;
		_tmp9_ = zeitgeist_fts_daemon_instance;
		_tmp10_ = connection;
		zeitgeist_fts_daemon_register_dbus_object (_tmp9_, _tmp10_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		GError* _tmp14_;
		GError* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = err;
		if (g_error_matches (_tmp11_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
			const gchar* _tmp12_;
			_tmp12_ = zeitgeist_utils_get_database_file_path ();
			g_warning ("Could not access the database file.\n" "Please check the permissions of file %s.", _tmp12_);
		} else {
			GError* _tmp13_;
			_tmp13_ = err;
			if (g_error_matches (_tmp13_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
				g_warning ("zeitgeist-fts.vala:216: %s", "It looks like another Zeitgeist instance " "is already running (the database is locked).");
			}
		}
		_tmp14_ = err;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error0_ = _tmp15_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (proxy);
		_g_object_unref0 (connection);
		return;
	}
	_tmp16_ = connection;
	owner_id = g_bus_own_name_on_connection_with_closures (_tmp16_, ZEITGEIST_FTS_DAEMON_DBUS_NAME, G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) g_cclosure_new ((GCallback) _zeitgeist_fts_daemon_name_acquired_callback_gbus_name_acquired_callback, NULL, (GClosureNotify) NULL), (GClosure*) g_cclosure_new ((GCallback) _zeitgeist_fts_daemon_name_lost_callback_gbus_name_lost_callback, NULL, (GClosureNotify) NULL));
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, ZEITGEIST_FTS_DAEMON_ZEITGEIST_DBUS_NAME, 0, (GClosure*) ((___lambda4__gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda4__gbus_name_appeared_callback, NULL, (GClosureNotify) NULL)), (GClosure*) g_cclosure_new ((GCallback) _zeitgeist_fts_daemon_zeitgeist_vanished_gbus_name_vanished_callback, NULL, (GClosureNotify) NULL));
	_tmp17_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (zeitgeist_fts_daemon_mainloop);
	zeitgeist_fts_daemon_mainloop = _tmp17_;
	_tmp18_ = zeitgeist_fts_daemon_mainloop;
	g_main_loop_run (_tmp18_);
	_tmp19_ = zeitgeist_fts_daemon_instance;
	if (_tmp19_ != NULL) {
		ZeitgeistFtsDaemon* _tmp20_;
		ZeitgeistFtsDaemon* _tmp21_;
		_tmp20_ = zeitgeist_fts_daemon_instance;
		zeitgeist_fts_daemon_close (_tmp20_);
		g_bus_unown_name (owner_id);
		_tmp21_ = zeitgeist_fts_daemon_instance;
		zeitgeist_fts_daemon_unregister_dbus_object (_tmp21_);
		_g_object_unref0 (zeitgeist_fts_daemon_instance);
		zeitgeist_fts_daemon_instance = NULL;
		{
			GDBusConnection* _tmp22_;
			_tmp22_ = connection;
			g_dbus_connection_flush_sync (_tmp22_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp23_;
			const gchar* _tmp24_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			g_warning ("zeitgeist-fts.vala:252: %s", _tmp24_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (proxy);
			_g_object_unref0 (connection);
			return;
		}
	}
	_g_object_unref0 (proxy);
	_g_object_unref0 (connection);
}

static void
zeitgeist_fts_daemon_safe_exit (void)
{
	GMainLoop* _tmp0_;
	_tmp0_ = zeitgeist_fts_daemon_mainloop;
	g_main_loop_quit (_tmp0_);
}

static void
_zeitgeist_fts_daemon_safe_exit_sighandler_t (gint signal)
{
	zeitgeist_fts_daemon_safe_exit ();
}

static void
____lambda5_ (void)
{
}

static void
_____lambda5__glog_func (const gchar* log_domain,
                         GLogLevelFlags log_levels,
                         const gchar* message,
                         gpointer self)
{
	____lambda5_ ();
}

static gint
zeitgeist_fts_daemon_main (gchar** args,
                           gint args_length1)
{
	GOptionContext* opt_context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GError* _inner_error0_ = NULL;
	gint result;
	signal (SIGHUP, _zeitgeist_fts_daemon_safe_exit_sighandler_t);
	signal (SIGINT, _zeitgeist_fts_daemon_safe_exit_sighandler_t);
	signal (SIGTERM, _zeitgeist_fts_daemon_safe_exit_sighandler_t);
	_tmp0_ = g_option_context_new (" - Zeitgeist FTS daemon");
	opt_context = _tmp0_;
	_tmp1_ = opt_context;
	g_option_context_add_main_entries (_tmp1_, ZEITGEIST_FTS_DAEMON_options, NULL);
	{
		GOptionContext* _tmp2_;
		GLogLevelFlags discarded = 0U;
		const gchar* _tmp4_;
		_tmp2_ = opt_context;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (zeitgeist_fts_daemon_show_version_info) {
			FILE* _tmp3_;
			_tmp3_ = stdout;
			fprintf (_tmp3_, "%s", VERSION "\n");
			result = 0;
			_g_option_context_free0 (opt_context);
			return result;
		}
		discarded = G_LOG_LEVEL_DEBUG;
		_tmp4_ = zeitgeist_fts_daemon_log_level;
		if (_tmp4_ != NULL) {
			GLogLevelFlags ld = 0U;
			GLogLevelFlags li = 0U;
			GLogLevelFlags lm = 0U;
			GLogLevelFlags lw = 0U;
			GLogLevelFlags lc = 0U;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			GQuark _tmp9_ = 0U;
			static GQuark _tmp8_label0 = 0;
			static GQuark _tmp8_label1 = 0;
			static GQuark _tmp8_label2 = 0;
			static GQuark _tmp8_label3 = 0;
			static GQuark _tmp8_label4 = 0;
			ld = G_LOG_LEVEL_DEBUG;
			li = G_LOG_LEVEL_INFO;
			lm = G_LOG_LEVEL_MESSAGE;
			lw = G_LOG_LEVEL_WARNING;
			lc = G_LOG_LEVEL_CRITICAL;
			_tmp5_ = zeitgeist_fts_daemon_log_level;
			_tmp6_ = g_utf8_strup (_tmp5_, (gssize) -1);
			_tmp7_ = _tmp6_;
			_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
			g_free (_tmp7_);
			if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("DEBUG")))) {
				switch (0) {
					default:
					{
						discarded = 0;
						break;
					}
				}
			} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("INFO")))) {
				switch (0) {
					default:
					{
						discarded = ld;
						break;
					}
				}
			} else if (_tmp9_ == ((0 != _tmp8_label2) ? _tmp8_label2 : (_tmp8_label2 = g_quark_from_static_string ("WARNING")))) {
				switch (0) {
					default:
					{
						discarded = (ld | li) | lm;
						break;
					}
				}
			} else if (_tmp9_ == ((0 != _tmp8_label3) ? _tmp8_label3 : (_tmp8_label3 = g_quark_from_static_string ("CRITICAL")))) {
				switch (0) {
					default:
					{
						discarded = ((ld | li) | lm) | lw;
						break;
					}
				}
			} else if (_tmp9_ == ((0 != _tmp8_label4) ? _tmp8_label4 : (_tmp8_label4 = g_quark_from_static_string ("ERROR")))) {
				switch (0) {
					default:
					{
						discarded = (((ld | li) | lm) | lw) | lc;
						break;
					}
				}
			}
		}
		if (discarded != 0) {
			g_log_set_handler ("", discarded, _____lambda5__glog_func, NULL);
		} else {
			g_setenv ("G_MESSAGES_DEBUG", "all", TRUE);
		}
		zeitgeist_fts_daemon_run (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = err;
		if (g_error_matches (_tmp10_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
			result = 21;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp11_ = err;
		if (g_error_matches (_tmp11_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
			result = 22;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		g_warning ("zeitgeist-fts.vala:328: %s", _tmp13_);
		result = 1;
		_g_error_free0 (err);
		_g_option_context_free0 (opt_context);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp14_ = -1;
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = 0;
	_g_option_context_free0 (opt_context);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return zeitgeist_fts_daemon_main (argv, argc);
}

static void
zeitgeist_fts_daemon_class_init (ZeitgeistFtsDaemonClass * klass,
                                 gpointer klass_data)
{
	gchar* _tmp0_;
	zeitgeist_fts_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistFtsDaemon_private_offset);
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_fts_daemon_finalize;
	_tmp0_ = g_strdup ("");
	zeitgeist_fts_daemon_log_level = _tmp0_;
}

static void
zeitgeist_fts_daemon_zeitgeist_remote_simple_indexer_interface_init (ZeitgeistRemoteSimpleIndexerIface * iface,
                                                                     gpointer iface_data)
{
	zeitgeist_fts_daemon_zeitgeist_remote_simple_indexer_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (ZeitgeistRemoteSimpleIndexer*, const gchar*, GVariant*, GVariant*, guint, guint, guint, GCancellable*, GAsyncReadyCallback, gpointer)) zeitgeist_fts_daemon_real_search;
	iface->search_finish = (void (*) (ZeitgeistRemoteSimpleIndexer*, GAsyncResult*, GVariant**, guint*, GError**)) zeitgeist_fts_daemon_search_finish;
	iface->search_with_relevancies = (void (*) (ZeitgeistRemoteSimpleIndexer*, const gchar*, GVariant*, GVariant*, guint, guint, guint, guint, GCancellable*, GAsyncReadyCallback, gpointer)) zeitgeist_fts_daemon_real_search_with_relevancies;
	iface->search_with_relevancies_finish = (void (*) (ZeitgeistRemoteSimpleIndexer*, GAsyncResult*, GVariant**, gdouble**, gint*, guint*, GError**)) zeitgeist_fts_daemon_search_with_relevancies_finish;
}

static void
zeitgeist_fts_daemon_zeitgeist_remote_monitor_interface_init (ZeitgeistRemoteMonitorIface * iface,
                                                              gpointer iface_data)
{
	zeitgeist_fts_daemon_zeitgeist_remote_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->notify_insert = (void (*) (ZeitgeistRemoteMonitor*, GVariant*, GVariant*, GAsyncReadyCallback, gpointer)) zeitgeist_fts_daemon_real_notify_insert;
	iface->notify_insert_finish = (void (*) (ZeitgeistRemoteMonitor*, GAsyncResult*, GError**)) zeitgeist_fts_daemon_notify_insert_finish;
	iface->notify_delete = (void (*) (ZeitgeistRemoteMonitor*, GVariant*, guint32*, gint, GAsyncReadyCallback, gpointer)) zeitgeist_fts_daemon_real_notify_delete;
	iface->notify_delete_finish = (void (*) (ZeitgeistRemoteMonitor*, GAsyncResult*, GError**)) zeitgeist_fts_daemon_notify_delete_finish;
}

static void
zeitgeist_fts_daemon_instance_init (ZeitgeistFtsDaemon * self,
                                    gpointer klass)
{
	self->priv = zeitgeist_fts_daemon_get_instance_private (self);
}

static void
zeitgeist_fts_daemon_finalize (GObject * obj)
{
	ZeitgeistFtsDaemon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_FTS_DAEMON, ZeitgeistFtsDaemon);
	_g_object_unref0 (self->priv->engine);
	_zeitgeist_indexer_free0 (self->priv->indexer);
	G_OBJECT_CLASS (zeitgeist_fts_daemon_parent_class)->finalize (obj);
}

static GType
zeitgeist_fts_daemon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistFtsDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_fts_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistFtsDaemon), 0, (GInstanceInitFunc) zeitgeist_fts_daemon_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_simple_indexer_info = { (GInterfaceInitFunc) zeitgeist_fts_daemon_zeitgeist_remote_simple_indexer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo zeitgeist_remote_monitor_info = { (GInterfaceInitFunc) zeitgeist_fts_daemon_zeitgeist_remote_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType zeitgeist_fts_daemon_type_id;
	zeitgeist_fts_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistFtsDaemon", &g_define_type_info, 0);
	g_type_add_interface_static (zeitgeist_fts_daemon_type_id, ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER, &zeitgeist_remote_simple_indexer_info);
	g_type_add_interface_static (zeitgeist_fts_daemon_type_id, ZEITGEIST_TYPE_REMOTE_MONITOR, &zeitgeist_remote_monitor_info);
	ZeitgeistFtsDaemon_private_offset = g_type_add_instance_private (zeitgeist_fts_daemon_type_id, sizeof (ZeitgeistFtsDaemonPrivate));
	return zeitgeist_fts_daemon_type_id;
}

GType
zeitgeist_fts_daemon_get_type (void)
{
	static volatile gsize zeitgeist_fts_daemon_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_fts_daemon_type_id__once)) {
		GType zeitgeist_fts_daemon_type_id;
		zeitgeist_fts_daemon_type_id = zeitgeist_fts_daemon_get_type_once ();
		g_once_init_leave (&zeitgeist_fts_daemon_type_id__once, zeitgeist_fts_daemon_type_id);
	}
	return zeitgeist_fts_daemon_type_id__once;
}

