#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-6gKBNVTwDUK4dO1sNyR8d8
key:                  hOpenPGP-2.10.1-6gKBNVTwDUK4dO1sNyR8d8
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  1ac3630882726eea4420edd01ee8b28d
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-6gKBNVTwDUK4dO1sNyR8d8
depends:
    aeson-2.1.2.1-JZeWX2s1eQL7Ta3HF3w6fW
    asn1-encoding-0.9.6-5OP0Q8LgdK7BnavlpIcm0B
    attoparsec-0.14.4-K96akOPZKYDKXaMIGNQXgm base-4.18.2.1
    base16-bytestring-1.0.2.0-HJCFai38hrd834YANCdq3
    bifunctors-5.6.2-54TfPo2cnqTHFBk3WlFXDd binary-0.8.9.1
    binary-conduit-1.3.1-IQVpYcpn2t9K1tGB16Cma1 bytestring-0.11.5.3
    bz2-1.0.1.1-GKZlKSgoCj0E5vntWSGkmw
    conduit-1.3.6.1-JmvSlylEAqiI8LFhx2lxVp
    conduit-extra-1.3.8-IF1ZquB86eb2RrOex2bqoF containers-0.6.7
    crypto-cipher-types-0.0.9-KR6SDml7aC01N7sg8RBO5C
    crypton-1.0.4-HsWWtLvSQjKFYKNmIISx6y
    errors-2.3.0-BEv9aDvoNDaHTiTr4IkxOU
    hashable-1.4.7.0-L2Cc1YdcpYH9U2sZW5osde
    incremental-parser-0.5.1-JEA0uISryuw6gnhWeYZpJf
    ixset-typed-0.5.1.0-KogQ93zMCWrDXbonX1rFJ8
    lens-5.3.3-6yFfjYmjPBKuNNVCwyEN9
    memory-0.18.0-6zo36PbRecTK4fqbBnx0f5
    monad-loops-0.4.3-LG7facWXNYz9W52syv7lz8
    nettle-0.3.1.1-DuwdlQIRX7hBXjJiv7OWDZ
    network-uri-2.6.4.2-4GU1spYfCy5EsCjKjgc97p
    openpgp-asciiarmor-0.1.2-2jKpgbziymEGLt8SVLHUCc
    prettyprinter-1.7.1-6IACTyjRPms8kgGy0SUdjP
    resourcet-1.2.6-6GDX0mNNFVQIZmMacsito5
    split-0.2.5-LIo01L9HFTI75RwsLzYVkn text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-8XUEctZKps57K6Zw5siYoh
    transformers-0.6.1.0 unliftio-core-0.2.1.0-6sOpIonHj8t5wIbPhWbPHY
    unordered-containers-0.2.20.1-8SON4238u8N3rDHPceHjHx
    zlib-0.7.0.0-1ujaGtF2c5l6Jpv01tSCEr

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

