/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseKatakanaStemFilter;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;

public class KuromojiKatakanaStemmerFactory
extends AbstractTokenFilterFactory {
    private final int minimumLength;

    public KuromojiKatakanaStemmerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.minimumLength = settings.getAsInt("minimum_length", Integer.valueOf(4));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new JapaneseKatakanaStemFilter(tokenStream, this.minimumLength);
    }
}

