\name{GaussianImageSource}
\alias{GaussianImageSource}
\title{GaussianImageSource}
\Rdversion{1.1}
\docType{class}
\description{
Generate an n-dimensional image of a Gaussian.
GaussianImageSource}
\details{
GaussianImageSource generates an image of a Gaussian. m_Normalized determines whether or
not the Gaussian is normalized (whether or not the sum over infinite
space is 1.0) When creating an image, it is preferable to not
normalize the Gaussian m_Scale scales the output of the Gaussian to
span a range larger than 0->1, and is typically set to the maximum
value of the output data type (for instance, 255 for uchars)
The output image may be of any dimension.
See:
GaussianSource for the procedural interface
itk::GaussianImageSource for the Doxygen on the original ITK class.
GaussianImageSource}
%C++ includes: sitkGaussianImageSource.h
\section{Methods}{
\describe{
\item{Image Execute():}{
Execute the filter on the input image
}
\item{ GaussianImageSource():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::vector< double > GetDirection() const:}{}
\item{std::vector< double > GetMean() const:}{
Set/Get the mean in each direction.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalized() const:}{
Set/Get whether or not to normalize the Gaussian. Default is false.
}
\item{std::vector< double > GetOrigin() const:}{}
\item{PixelIDValueEnum GetOutputPixelType() const:}{}
\item{double GetScale() const:}{
Gets and sets for Gaussian parameters Set/Get the scale factor to
multiply the true value of the Gaussian.
}
\item{std::vector< double > GetSigma() const:}{
Set/Get the standard deviation in each direction.
}
\item{std::vector< unsigned int > GetSize() const:}{}
\item{std::vector< double > GetSpacing() const:}{}
\item{Self NormalizedOff():}{}
\item{Self NormalizedOn():}{
Set the value of Normalized to true or false respectfully.
}
\item{Self SetDirection(std::vector< double > Direction):}{}
\item{Self SetMean(double value):}{
Set the values of the Mean vector all to value
}
\item{Self SetMean(std::vector< double > Mean):}{
Set/Get the mean in each direction.
}
\item{Self SetNormalized(bool Normalized):}{
Set/Get whether or not to normalize the Gaussian. Default is false.
}
\item{Self SetOrigin(std::vector< double > Origin):}{}
\item{Self SetOutputPixelType(PixelIDValueEnum OutputPixelType):}{}
\item{Self SetScale(double Scale):}{
Gets and sets for Gaussian parameters Set/Get the scale factor to
multiply the true value of the Gaussian.
}
\item{Self SetSigma(double value):}{
Set the values of the Sigma vector all to value
}
\item{Self SetSigma(std::vector< double > Sigma):}{
Set/Get the standard deviation in each direction.
}
\item{Self SetSize(std::vector< unsigned int > Size):}{}
\item{Self SetSpacing(std::vector< double > Spacing):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GaussianImageSource():}{
Destructor
}
}
}
