/* screenlock.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from screenlock.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <upower.h>
#include <budgie-config.h>
#include <gobject/gvaluecollector.h>

#define BUDGIE_DBUS_SCREENLOCK "org.buddiesofbudgie.BudgieScreenlock"
#define BUDGIE_DBUS_SCREENLOCK_PATH "/org/buddiesofbudgie/Screenlock"
#define BUDGIE_POWERSCREEN_DBUS_NAME "org.gnome.SettingsDaemon.Power"
#define BUDGIE_POWERSCREEN_DBUS_OBJECT_PATH "/org/gnome/SettingsDaemon/Power"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_POWER_SCREEN_REMOTE (budgie_power_screen_remote_get_type ())
#define BUDGIE_POWER_SCREEN_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_POWER_SCREEN_REMOTE, BudgiePowerScreenRemote))
#define BUDGIE_IS_POWER_SCREEN_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_POWER_SCREEN_REMOTE))
#define BUDGIE_POWER_SCREEN_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_POWER_SCREEN_REMOTE, BudgiePowerScreenRemoteIface))

typedef struct _BudgiePowerScreenRemote BudgiePowerScreenRemote;
typedef struct _BudgiePowerScreenRemoteIface BudgiePowerScreenRemoteIface;

#define BUDGIE_TYPE_POWER_SCREEN_REMOTE_PROXY (budgie_power_screen_remote_proxy_get_type ())
typedef GDBusProxy BudgiePowerScreenRemoteProxy;
typedef GDBusProxyClass BudgiePowerScreenRemoteProxyClass;

#define BUDGIE_TYPE_SCREENLOCK (budgie_screenlock_get_type ())
#define BUDGIE_SCREENLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREENLOCK, BudgieScreenlock))
#define BUDGIE_SCREENLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SCREENLOCK, BudgieScreenlockClass))
#define BUDGIE_IS_SCREENLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREENLOCK))
#define BUDGIE_IS_SCREENLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SCREENLOCK))
#define BUDGIE_SCREENLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SCREENLOCK, BudgieScreenlockClass))

typedef struct _BudgieScreenlock BudgieScreenlock;
typedef struct _BudgieScreenlockClass BudgieScreenlockClass;
typedef struct _BudgieScreenlockPrivate BudgieScreenlockPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _budgie_screenlock_unref0(var) ((var == NULL) ? NULL : (var = (budgie_screenlock_unref (var), NULL)))
typedef struct _BudgieScreenlockDimData BudgieScreenlockDimData;
typedef struct _BudgieScreenlockUndimData BudgieScreenlockUndimData;
typedef struct _BudgieScreenlockLockData BudgieScreenlockLockData;
typedef struct _BudgieParamSpecScreenlock BudgieParamSpecScreenlock;
typedef struct _BudgieScreenlockDimReadyData BudgieScreenlockDimReadyData;
typedef struct _BudgieScreenlockUndimReadyData BudgieScreenlockUndimReadyData;
typedef struct _BudgieScreenlockLockReadyData BudgieScreenlockLockReadyData;

struct _BudgiePowerScreenRemoteIface {
	GTypeInterface parent_iface;
	gint32 (*get_Brightness) (BudgiePowerScreenRemote* self);
	void (*set_Brightness) (BudgiePowerScreenRemote* self, gint32 value);
};

struct _BudgieScreenlock {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgieScreenlockPrivate * priv;
};

struct _BudgieScreenlockClass {
	GTypeClass parent_class;
	void (*finalize) (BudgieScreenlock *self);
};

struct _BudgieScreenlockPrivate {
	BudgiePowerScreenRemote* powerscreen_proxy;
	gboolean isdimmable;
	gint32 current_brightness;
	GSettings* power;
	GSettings* session;
	GSettings* screensaver;
	GSettings* lockdown;
	gboolean all_apps;
	gchar* locker;
	UpClient* client;
	GPtrArray* devices;
	gboolean battery_mode;
};

struct _BudgieScreenlockDimData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieScreenlock* self;
	BudgiePowerScreenRemote* _tmp0_;
	BudgiePowerScreenRemote* _tmp1_;
	gint32 _tmp2_;
	gint32 _tmp3_;
	gint32 idle_brightness;
	GSettings* _tmp4_;
	BudgiePowerScreenRemote* _tmp5_;
};

struct _BudgieScreenlockUndimData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieScreenlock* self;
	BudgiePowerScreenRemote* _tmp0_;
	BudgiePowerScreenRemote* _tmp1_;
};

struct _BudgieScreenlockLockData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieScreenlock* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* e;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_;
};

struct _BudgieParamSpecScreenlock {
	GParamSpec parent_instance;
};

struct _BudgieScreenlockDimReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _BudgieScreenlockUndimReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _BudgieScreenlockLockReadyData {
	GDBusMethodInvocation* _invocation_;
};

static gint BudgieScreenlock_private_offset;
static gpointer budgie_screenlock_parent_class = NULL;
static BudgieScreenlock* budgie_screenlock_instance;
static BudgieScreenlock* budgie_screenlock_instance = NULL;
static gboolean budgie_screenlock__is_dimming;
static gboolean budgie_screenlock__is_dimming = FALSE;

VALA_EXTERN GType budgie_power_screen_remote_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePowerScreenRemote, g_object_unref)
VALA_EXTERN GType budgie_power_screen_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_power_screen_remote_register_object (void* object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error);
VALA_EXTERN gint32 budgie_power_screen_remote_get_Brightness (BudgiePowerScreenRemote* self);
VALA_EXTERN void budgie_power_screen_remote_set_Brightness (BudgiePowerScreenRemote* self,
                                                gint32 value);
static GType budgie_power_screen_remote_get_type_once (void);
static void budgie_power_screen_remote_proxy_g_signal (GDBusProxy* proxy,
                                                const gchar* sender_name,
                                                const gchar* signal_name,
                                                GVariant* parameters);
static gint32 budgie_power_screen_remote_dbus_proxy_get_Brightness (BudgiePowerScreenRemote* self);
static void budgie_power_screen_remote_dbus_proxy_set_Brightness (BudgiePowerScreenRemote* self,
                                                           gint32 value);
static void budgie_power_screen_remote_proxy_budgie_power_screen_remote_interface_init (BudgiePowerScreenRemoteIface* iface);
static void budgie_power_screen_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data);
static GVariant* budgie_power_screen_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GError** error,
                                                                  gpointer user_data);
static GVariant* _dbus_budgie_power_screen_remote_get_Brightness (BudgiePowerScreenRemote* self);
static gboolean budgie_power_screen_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GVariant* value,
                                                                 GError** error,
                                                                 gpointer user_data);
static void _dbus_budgie_power_screen_remote_set_Brightness (BudgiePowerScreenRemote* self,
                                                      GVariant* _value);
static void _budgie_power_screen_remote_unregister_object (gpointer user_data);
VALA_EXTERN gpointer budgie_screenlock_ref (gpointer instance);
VALA_EXTERN void budgie_screenlock_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_screenlock (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void budgie_value_set_screenlock (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void budgie_value_take_screenlock (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_screenlock (const GValue* value);
VALA_EXTERN GType budgie_screenlock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieScreenlock, budgie_screenlock_unref)
VALA_EXTERN guint budgie_screenlock_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
static gchar* budgie_screenlock_calculate_dim (BudgieScreenlock* self);
static gchar* budgie_screenlock_calculate_lockcommand (BudgieScreenlock* self);
static gchar* budgie_screenlock_calculate_sleep (BudgieScreenlock* self);
static void budgie_screenlock_calculate_idle (BudgieScreenlock* self);
static void budgie_screenlock_on_powerscreen_get (BudgieScreenlock* self,
                                           GObject* o,
                                           GAsyncResult* res);
VALA_EXTERN void budgie_screenlock_setup_dbus (BudgieScreenlock* self);
static void budgie_screenlock_on_bus_acquired (BudgieScreenlock* self,
                                        GDBusConnection* conn);
static void _budgie_screenlock_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                const gchar* name,
                                                                gpointer self);
static void __lambda37_ (BudgieScreenlock* self);
static void ___lambda37__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
static void __lambda38_ (BudgieScreenlock* self);
static void ___lambda38__gbus_name_lost_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
static void budgie_screenlock_dim_data_free (gpointer _data);
VALA_EXTERN void budgie_screenlock_dim (BudgieScreenlock* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_);
VALA_EXTERN void budgie_screenlock_dim_finish (BudgieScreenlock* self,
                                   GAsyncResult* _res_,
                                   GError** error);
static gboolean budgie_screenlock_dim_co (BudgieScreenlockDimData* _data_);
static void budgie_screenlock_set_is_dimming (gboolean value);
static void budgie_screenlock_undim_data_free (gpointer _data);
VALA_EXTERN void budgie_screenlock_undim (BudgieScreenlock* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN void budgie_screenlock_undim_finish (BudgieScreenlock* self,
                                     GAsyncResult* _res_,
                                     GError** error);
static gboolean budgie_screenlock_undim_co (BudgieScreenlockUndimData* _data_);
static gboolean __lambda39_ (BudgieScreenlock* self);
static gboolean ___lambda39__gsource_func (gpointer self);
static void budgie_screenlock_lock_data_free (gpointer _data);
VALA_EXTERN void budgie_screenlock_lock (BudgieScreenlock* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN void budgie_screenlock_lock_finish (BudgieScreenlock* self,
                                    GAsyncResult* _res_,
                                    GError** error);
static gboolean budgie_screenlock_lock_co (BudgieScreenlockLockData* _data_);
VALA_EXTERN BudgieScreenlock* budgie_screenlock_init (void);
static BudgieScreenlock* budgie_screenlock_new (void);
static BudgieScreenlock* budgie_screenlock_construct (GType object_type);
VALA_EXTERN gboolean budgie_screenlock_on_battery (BudgieScreenlock* self,
                                       GError** error);
static void budgie_screenlock_client_daemon (BudgieScreenlock* self,
                                      GObject* obj,
                                      GParamSpec* sp);
static void _budgie_screenlock_on_powerscreen_get_gasync_ready_callback (GObject* source_object,
                                                                  GAsyncResult* res,
                                                                  gpointer self);
static void _budgie_screenlock_client_daemon_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void __lambda40_ (BudgieScreenlock* self,
                  const gchar* key);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void ___lambda40__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda41_ (BudgieScreenlock* self,
                  const gchar* key);
static void ___lambda41__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda42_ (BudgieScreenlock* self,
                  const gchar* key);
static void ___lambda42__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda43_ (BudgieScreenlock* self,
                  const gchar* key);
static void ___lambda43__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
VALA_EXTERN gboolean budgie_screenlock_get_is_dimming (void);
static void budgie_screenlock_finalize (BudgieScreenlock * obj);
static GType budgie_screenlock_get_type_once (void);
static void _dbus_budgie_screenlock_dim (BudgieScreenlock* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation);
static void _dbus_budgie_screenlock_dim_ready (GObject * source_object,
                                        GAsyncResult * _res_,
                                        gpointer _user_data_);
static void _dbus_budgie_screenlock_undim (BudgieScreenlock* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation);
static void _dbus_budgie_screenlock_undim_ready (GObject * source_object,
                                          GAsyncResult * _res_,
                                          gpointer _user_data_);
static void _dbus_budgie_screenlock_lock (BudgieScreenlock* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_budgie_screenlock_lock_ready (GObject * source_object,
                                         GAsyncResult * _res_,
                                         gpointer _user_data_);
static void _dbus_budgie_screenlock_on_battery (BudgieScreenlock* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void budgie_screenlock_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* budgie_screenlock_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static gboolean budgie_screenlock_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _budgie_screenlock_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusMethodInfo * const _budgie_power_screen_remote_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _budgie_power_screen_remote_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _budgie_power_screen_remote_dbus_property_info_Brightness = {-1, "Brightness", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _budgie_power_screen_remote_dbus_property_info[] = {&_budgie_power_screen_remote_dbus_property_info_Brightness, NULL};
static const GDBusInterfaceInfo _budgie_power_screen_remote_dbus_interface_info = {-1, "org.gnome.SettingsDaemon.Power.Screen", (GDBusMethodInfo **) (&_budgie_power_screen_remote_dbus_method_info), (GDBusSignalInfo **) (&_budgie_power_screen_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_power_screen_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_power_screen_remote_dbus_interface_vtable = {budgie_power_screen_remote_dbus_interface_method_call, budgie_power_screen_remote_dbus_interface_get_property, budgie_power_screen_remote_dbus_interface_set_property};
static const GDBusArgInfo * const _budgie_screenlock_dbus_arg_info_dim_in[] = {NULL};
static const GDBusArgInfo * const _budgie_screenlock_dbus_arg_info_dim_out[] = {NULL};
static const GDBusMethodInfo _budgie_screenlock_dbus_method_info_dim = {-1, "Dim", (GDBusArgInfo **) (&_budgie_screenlock_dbus_arg_info_dim_in), (GDBusArgInfo **) (&_budgie_screenlock_dbus_arg_info_dim_out), NULL};
static const GDBusArgInfo * const _budgie_screenlock_dbus_arg_info_undim_in[] = {NULL};
static const GDBusArgInfo * const _budgie_screenlock_dbus_arg_info_undim_out[] = {NULL};
static const GDBusMethodInfo _budgie_screenlock_dbus_method_info_undim = {-1, "Undim", (GDBusArgInfo **) (&_budgie_screenlock_dbus_arg_info_undim_in), (GDBusArgInfo **) (&_budgie_screenlock_dbus_arg_info_undim_out), NULL};
static const GDBusArgInfo * const _budgie_screenlock_dbus_arg_info_lock_in[] = {NULL};
static const GDBusArgInfo * const _budgie_screenlock_dbus_arg_info_lock_out[] = {NULL};
static const GDBusMethodInfo _budgie_screenlock_dbus_method_info_lock = {-1, "Lock", (GDBusArgInfo **) (&_budgie_screenlock_dbus_arg_info_lock_in), (GDBusArgInfo **) (&_budgie_screenlock_dbus_arg_info_lock_out), NULL};
static const GDBusArgInfo _budgie_screenlock_dbus_arg_info_on_battery_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _budgie_screenlock_dbus_arg_info_on_battery_in[] = {NULL};
static const GDBusArgInfo * const _budgie_screenlock_dbus_arg_info_on_battery_out[] = {&_budgie_screenlock_dbus_arg_info_on_battery_result, NULL};
static const GDBusMethodInfo _budgie_screenlock_dbus_method_info_on_battery = {-1, "OnBattery", (GDBusArgInfo **) (&_budgie_screenlock_dbus_arg_info_on_battery_in), (GDBusArgInfo **) (&_budgie_screenlock_dbus_arg_info_on_battery_out), NULL};
static const GDBusMethodInfo * const _budgie_screenlock_dbus_method_info[] = {&_budgie_screenlock_dbus_method_info_dim, &_budgie_screenlock_dbus_method_info_undim, &_budgie_screenlock_dbus_method_info_lock, &_budgie_screenlock_dbus_method_info_on_battery, NULL};
static const GDBusSignalInfo * const _budgie_screenlock_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_screenlock_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_screenlock_dbus_interface_info = {-1, "org.buddiesofbudgie.BudgieScreenlock", (GDBusMethodInfo **) (&_budgie_screenlock_dbus_method_info), (GDBusSignalInfo **) (&_budgie_screenlock_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_screenlock_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_screenlock_dbus_interface_vtable = {budgie_screenlock_dbus_interface_method_call, budgie_screenlock_dbus_interface_get_property, budgie_screenlock_dbus_interface_set_property};

gint32
budgie_power_screen_remote_get_Brightness (BudgiePowerScreenRemote* self)
{
	BudgiePowerScreenRemoteIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = BUDGIE_POWER_SCREEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->get_Brightness) {
		return _iface_->get_Brightness (self);
	}
	return -1;
}

void
budgie_power_screen_remote_set_Brightness (BudgiePowerScreenRemote* self,
                                           gint32 value)
{
	BudgiePowerScreenRemoteIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BUDGIE_POWER_SCREEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->set_Brightness) {
		_iface_->set_Brightness (self, value);
	}
}

static void
budgie_power_screen_remote_default_init (BudgiePowerScreenRemoteIface * iface,
                                         gpointer iface_data)
{
}

static GType
budgie_power_screen_remote_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgiePowerScreenRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_power_screen_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_power_screen_remote_type_id;
	budgie_power_screen_remote_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgiePowerScreenRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_power_screen_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_power_screen_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_power_screen_remote_proxy_get_type);
	g_type_set_qdata (budgie_power_screen_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SettingsDaemon.Power.Screen");
	g_type_set_qdata (budgie_power_screen_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_power_screen_remote_dbus_interface_info));
	g_type_set_qdata (budgie_power_screen_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_power_screen_remote_register_object);
	return budgie_power_screen_remote_type_id;
}

GType
budgie_power_screen_remote_get_type (void)
{
	static volatile gsize budgie_power_screen_remote_type_id__once = 0;
	if (g_once_init_enter (&budgie_power_screen_remote_type_id__once)) {
		GType budgie_power_screen_remote_type_id;
		budgie_power_screen_remote_type_id = budgie_power_screen_remote_get_type_once ();
		g_once_init_leave (&budgie_power_screen_remote_type_id__once, budgie_power_screen_remote_type_id);
	}
	return budgie_power_screen_remote_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgiePowerScreenRemoteProxy, budgie_power_screen_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_POWER_SCREEN_REMOTE, budgie_power_screen_remote_proxy_budgie_power_screen_remote_interface_init) )
static void
budgie_power_screen_remote_proxy_class_init (BudgiePowerScreenRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_power_screen_remote_proxy_g_signal;
}

static void
budgie_power_screen_remote_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters)
{
}

static void
budgie_power_screen_remote_proxy_init (BudgiePowerScreenRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_power_screen_remote_dbus_interface_info));
}

static gint32
budgie_power_screen_remote_dbus_proxy_get_Brightness (BudgiePowerScreenRemote* self)
{
	GVariant *_inner_reply;
	gint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Brightness");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Power.Screen"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Brightness"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint32 _tmp55_ = 0;
			return _tmp55_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
budgie_power_screen_remote_dbus_proxy_set_Brightness (BudgiePowerScreenRemote* self,
                                                      gint32 value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Power.Screen"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Brightness"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
budgie_power_screen_remote_proxy_budgie_power_screen_remote_interface_init (BudgiePowerScreenRemoteIface* iface)
{
	iface->get_Brightness = budgie_power_screen_remote_dbus_proxy_get_Brightness;
	iface->set_Brightness = budgie_power_screen_remote_dbus_proxy_set_Brightness;
}

static void
budgie_power_screen_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_budgie_power_screen_remote_get_Brightness (BudgiePowerScreenRemote* self)
{
	gint32 result;
	GVariant* _reply;
	result = budgie_power_screen_remote_get_Brightness (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
budgie_power_screen_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Brightness") == 0) {
		return _dbus_budgie_power_screen_remote_get_Brightness (object);
	}
	return NULL;
}

static void
_dbus_budgie_power_screen_remote_set_Brightness (BudgiePowerScreenRemote* self,
                                                 GVariant* _value)
{
	gint32 value = 0;
	value = g_variant_get_int32 (_value);
	budgie_power_screen_remote_set_Brightness (self, value);
}

static gboolean
budgie_power_screen_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Brightness") == 0) {
		_dbus_budgie_power_screen_remote_set_Brightness (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
budgie_power_screen_remote_register_object (gpointer object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_power_screen_remote_dbus_interface_info), &_budgie_power_screen_remote_dbus_interface_vtable, data, _budgie_power_screen_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_power_screen_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_screenlock_get_instance_private (BudgieScreenlock* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieScreenlock_private_offset);
}

static gchar*
budgie_screenlock_calculate_dim (BudgieScreenlock* self)
{
	GSettings* _tmp0_;
	gchar* dbus_call = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->power;
	self->priv->isdimmable = g_settings_get_boolean (_tmp0_, "idle-dim");
	if (!self->priv->isdimmable) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_strdup ("timeout 30 'dbus-send --type=method_call --dest=org.buddiesofbudgie.Bu" \
"dgieScreenlock /org/buddiesofbudgie/Screenlock org.buddiesofbudgie.Bud" \
"gieScreenlock.Dim' ");
	dbus_call = _tmp2_;
	_tmp3_ = dbus_call;
	_tmp4_ = g_strconcat (_tmp3_, "resume 'dbus-send --type=method_call --dest=org.buddiesofbudgie.Budgie" \
"Screenlock /org/buddiesofbudgie/Screenlock org.buddiesofbudgie.BudgieS" \
"creenlock.Undim' ", NULL);
	_g_free0 (dbus_call);
	dbus_call = _tmp4_;
	result = dbus_call;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
budgie_screenlock_calculate_lockcommand (BudgieScreenlock* self)
{
	gchar* output = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	output = _tmp0_;
	_tmp1_ = self->priv->locker;
	if (g_strcmp0 (_tmp1_, "swaylock") == 0) {
		gchar* current_wallpaper = NULL;
		GSettings* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		GFile* file = NULL;
		const gchar* _tmp9_;
		GFile* _tmp10_;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp2_ = self->priv->screensaver;
		_tmp3_ = g_settings_get_string (_tmp2_, "picture-uri");
		_tmp4_ = _tmp3_;
		_tmp5_ = string_replace (_tmp4_, "file://", "");
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		current_wallpaper = _tmp6_;
		_tmp7_ = current_wallpaper;
		_tmp8_ = string_replace (_tmp7_, ":", "::");
		_g_free0 (current_wallpaper);
		current_wallpaper = _tmp8_;
		_tmp9_ = current_wallpaper;
		_tmp10_ = g_file_new_for_path (_tmp9_);
		file = _tmp10_;
		_tmp12_ = current_wallpaper;
		if (g_strcmp0 (_tmp12_, "") == 0) {
			_tmp11_ = TRUE;
		} else {
			GFile* _tmp13_;
			_tmp13_ = file;
			_tmp11_ = !g_file_query_exists (_tmp13_, NULL);
		}
		if (_tmp11_) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("-c 000000");
			_g_free0 (output);
			output = _tmp14_;
		} else {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = current_wallpaper;
			_tmp16_ = g_strconcat ("-i ", _tmp15_, NULL);
			_g_free0 (output);
			output = _tmp16_;
		}
		_tmp17_ = output;
		_tmp18_ = g_strconcat ("swaylock -Fklf ", _tmp17_, NULL);
		_g_free0 (output);
		output = _tmp18_;
		_g_object_unref0 (file);
		_g_free0 (current_wallpaper);
	} else {
		const gchar* _tmp19_;
		_tmp19_ = self->priv->locker;
		if (g_strcmp0 (_tmp19_, "gtklock") == 0) {
			gchar* _tmp20_;
			gchar** lock_configs = NULL;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			gchar** _tmp29_;
			gchar** _tmp30_;
			gint _tmp30__length1;
			gint lock_configs_length1;
			gint _lock_configs_size_;
			gchar** _tmp31_;
			gint _tmp31__length1;
			gchar** style_configs = NULL;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			gchar** _tmp51_;
			gchar** _tmp52_;
			gint _tmp52__length1;
			gint style_configs_length1;
			gint _style_configs_size_;
			gchar** _tmp53_;
			gint _tmp53__length1;
			_tmp20_ = g_strdup ("gtklock -d");
			_g_free0 (output);
			output = _tmp20_;
			_tmp21_ = g_get_user_config_dir ();
			_tmp22_ = g_strconcat ("file://", _tmp21_, NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strconcat (_tmp23_, "/budgie-desktop/gtklock.ini", NULL);
			_tmp25_ = string_to_string (BUDGIE_CONFDIR);
			_tmp26_ = g_strconcat ("file://", _tmp25_, "/budgie-desktop/gtklock.ini", NULL);
			_tmp27_ = string_to_string (BUDGIE_DATADIR);
			_tmp28_ = g_strconcat ("file://", _tmp27_, "/budgie-desktop/gtklock.ini", NULL);
			_tmp29_ = g_new0 (gchar*, 3 + 1);
			_tmp29_[0] = _tmp24_;
			_tmp29_[1] = _tmp26_;
			_tmp29_[2] = _tmp28_;
			_tmp30_ = _tmp29_;
			_tmp30__length1 = 3;
			_g_free0 (_tmp23_);
			lock_configs = _tmp30_;
			lock_configs_length1 = _tmp30__length1;
			_lock_configs_size_ = lock_configs_length1;
			_tmp31_ = lock_configs;
			_tmp31__length1 = lock_configs_length1;
			{
				gchar** filepath_collection = NULL;
				gint filepath_collection_length1 = 0;
				gint _filepath_collection_size_ = 0;
				gint filepath_it = 0;
				filepath_collection = _tmp31_;
				filepath_collection_length1 = _tmp31__length1;
				for (filepath_it = 0; filepath_it < filepath_collection_length1; filepath_it = filepath_it + 1) {
					gchar* _tmp32_;
					gchar* filepath = NULL;
					_tmp32_ = g_strdup (filepath_collection[filepath_it]);
					filepath = _tmp32_;
					{
						GFile* file = NULL;
						const gchar* _tmp33_;
						GFile* _tmp34_;
						gboolean tmp = FALSE;
						GFile* _tmp35_;
						_tmp33_ = filepath;
						_tmp34_ = g_file_new_for_uri (_tmp33_);
						file = _tmp34_;
						_tmp35_ = file;
						tmp = g_file_query_exists (_tmp35_, NULL);
						if (tmp) {
							const gchar* _tmp36_;
							GFile* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							gchar* _tmp42_;
							_tmp36_ = output;
							_tmp37_ = file;
							_tmp38_ = g_file_get_path (_tmp37_);
							_tmp39_ = _tmp38_;
							_tmp40_ = g_strconcat (" -c ", _tmp39_, NULL);
							_tmp41_ = _tmp40_;
							_tmp42_ = g_strconcat (_tmp36_, _tmp41_, NULL);
							_g_free0 (output);
							output = _tmp42_;
							_g_free0 (_tmp41_);
							_g_free0 (_tmp39_);
							_g_object_unref0 (file);
							_g_free0 (filepath);
							break;
						}
						_g_object_unref0 (file);
						_g_free0 (filepath);
					}
				}
			}
			_tmp43_ = g_get_user_config_dir ();
			_tmp44_ = g_strconcat ("file://", _tmp43_, NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strconcat (_tmp45_, "/budgie-desktop/gtklock.css", NULL);
			_tmp47_ = string_to_string (BUDGIE_CONFDIR);
			_tmp48_ = g_strconcat ("file://", _tmp47_, "/budgie-desktop/gtklock.css", NULL);
			_tmp49_ = string_to_string (BUDGIE_DATADIR);
			_tmp50_ = g_strconcat ("file://", _tmp49_, "/budgie-desktop/gtklock.css", NULL);
			_tmp51_ = g_new0 (gchar*, 3 + 1);
			_tmp51_[0] = _tmp46_;
			_tmp51_[1] = _tmp48_;
			_tmp51_[2] = _tmp50_;
			_tmp52_ = _tmp51_;
			_tmp52__length1 = 3;
			_g_free0 (_tmp45_);
			style_configs = _tmp52_;
			style_configs_length1 = _tmp52__length1;
			_style_configs_size_ = style_configs_length1;
			_tmp53_ = style_configs;
			_tmp53__length1 = style_configs_length1;
			{
				gchar** filepath_collection = NULL;
				gint filepath_collection_length1 = 0;
				gint _filepath_collection_size_ = 0;
				gint filepath_it = 0;
				filepath_collection = _tmp53_;
				filepath_collection_length1 = _tmp53__length1;
				for (filepath_it = 0; filepath_it < filepath_collection_length1; filepath_it = filepath_it + 1) {
					gchar* _tmp54_;
					gchar* filepath = NULL;
					_tmp54_ = g_strdup (filepath_collection[filepath_it]);
					filepath = _tmp54_;
					{
						GFile* file = NULL;
						const gchar* _tmp55_;
						GFile* _tmp56_;
						gboolean tmp = FALSE;
						GFile* _tmp57_;
						_tmp55_ = filepath;
						_tmp56_ = g_file_new_for_uri (_tmp55_);
						file = _tmp56_;
						_tmp57_ = file;
						tmp = g_file_query_exists (_tmp57_, NULL);
						if (tmp) {
							const gchar* _tmp58_;
							GFile* _tmp59_;
							gchar* _tmp60_;
							gchar* _tmp61_;
							gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp64_;
							_tmp58_ = output;
							_tmp59_ = file;
							_tmp60_ = g_file_get_path (_tmp59_);
							_tmp61_ = _tmp60_;
							_tmp62_ = g_strconcat (" -s ", _tmp61_, NULL);
							_tmp63_ = _tmp62_;
							_tmp64_ = g_strconcat (_tmp58_, _tmp63_, NULL);
							_g_free0 (output);
							output = _tmp64_;
							_g_free0 (_tmp63_);
							_g_free0 (_tmp61_);
							_g_object_unref0 (file);
							_g_free0 (filepath);
							break;
						}
						_g_object_unref0 (file);
						_g_free0 (filepath);
					}
				}
			}
			style_configs = (_vala_array_free (style_configs, style_configs_length1, (GDestroyNotify) g_free), NULL);
			lock_configs = (_vala_array_free (lock_configs, lock_configs_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	result = output;
	return result;
}

static gchar*
budgie_screenlock_calculate_sleep (BudgieScreenlock* self)
{
	gchar* output = NULL;
	gchar* _tmp0_;
	gint sleep_inactive_ac_timeout = 0;
	GSettings* _tmp1_;
	gchar* sleep_inactive_ac_type = NULL;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gint sleep_inactive_battery_timeout = 0;
	GSettings* _tmp4_;
	gchar* sleep_inactive_battery_type = NULL;
	GSettings* _tmp5_;
	gchar* _tmp6_;
	gchar* suspend = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	output = _tmp0_;
	_tmp1_ = self->priv->power;
	sleep_inactive_ac_timeout = g_settings_get_int (_tmp1_, "sleep-inactive-ac-timeout");
	_tmp2_ = self->priv->power;
	_tmp3_ = g_settings_get_string (_tmp2_, "sleep-inactive-ac-type");
	sleep_inactive_ac_type = _tmp3_;
	_tmp4_ = self->priv->power;
	sleep_inactive_battery_timeout = g_settings_get_int (_tmp4_, "sleep-inactive-battery-timeout");
	_tmp5_ = self->priv->power;
	_tmp6_ = g_settings_get_string (_tmp5_, "sleep-inactive-battery-type");
	sleep_inactive_battery_type = _tmp6_;
	_tmp7_ = g_strdup ("dbus-send --system --print-reply --dest=org.freedesktop.login1 /org/fr" \
"eedesktop/login1 org.freedesktop.login1.Manager.Suspend boolean:false");
	suspend = _tmp7_;
	_tmp9_ = sleep_inactive_battery_type;
	if (g_strcmp0 (_tmp9_, "suspend") == 0) {
		_tmp8_ = sleep_inactive_battery_timeout != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp10_ = g_strdup_printf ("%i", sleep_inactive_battery_timeout);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat ("timeout ", _tmp11_, NULL);
		_g_free0 (output);
		output = _tmp12_;
		_g_free0 (_tmp11_);
		_tmp13_ = output;
		_tmp14_ = g_strconcat (_tmp13_, " 'if dbus-send --print-reply=literal --dest=org.buddiesofbudgie.Budgie" \
"Screenlock /org/buddiesofbudgie/Screenlock org.buddiesofbudgie.BudgieS" \
"creenlock.OnBattery | grep \"boolean true\" > /dev/null; then ", NULL);
		_g_free0 (output);
		output = _tmp14_;
		_tmp15_ = output;
		_tmp16_ = suspend;
		_tmp17_ = g_strconcat (_tmp16_, "; fi' ", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
		_g_free0 (output);
		output = _tmp19_;
		_g_free0 (_tmp18_);
	}
	_tmp21_ = sleep_inactive_ac_type;
	if (g_strcmp0 (_tmp21_, "suspend") == 0) {
		_tmp20_ = sleep_inactive_ac_timeout != 0;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp22_ = output;
		_tmp23_ = g_strdup_printf ("%i", sleep_inactive_ac_timeout);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (" timeout ", _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp22_, _tmp26_, NULL);
		_g_free0 (output);
		output = _tmp27_;
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_tmp28_ = output;
		_tmp29_ = g_strconcat (_tmp28_, " 'if dbus-send --print-reply=literal --dest=org.buddiesofbudgie.Budgie" \
"Screenlock /org/buddiesofbudgie/Screenlock org.buddiesofbudgie.BudgieS" \
"creenlock.OnBattery | grep \"boolean false\" > /dev/null; then ", NULL);
		_g_free0 (output);
		output = _tmp29_;
		_tmp30_ = output;
		_tmp31_ = suspend;
		_tmp32_ = g_strconcat (_tmp31_, "; fi' ", NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat (_tmp30_, _tmp33_, NULL);
		_g_free0 (output);
		output = _tmp34_;
		_g_free0 (_tmp33_);
	}
	result = output;
	_g_free0 (suspend);
	_g_free0 (sleep_inactive_battery_type);
	_g_free0 (sleep_inactive_ac_type);
	return result;
}

static void
budgie_screenlock_calculate_idle (BudgieScreenlock* self)
{
	guint idle_delay = 0U;
	gchar* new_idle = NULL;
	gchar* _tmp0_;
	gboolean lock_enabled = FALSE;
	guint lock_delay = 0U;
	gboolean disable_lock_screen = FALSE;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	idle_delay = (guint) 0;
	_tmp0_ = g_strdup ("");
	new_idle = _tmp0_;
	lock_enabled = FALSE;
	lock_delay = (guint) 0;
	disable_lock_screen = FALSE;
	_tmp1_ = self->priv->session;
	idle_delay = g_settings_get_uint (_tmp1_, "idle-delay");
	_tmp2_ = self->priv->screensaver;
	lock_enabled = g_settings_get_boolean (_tmp2_, "lock-enabled");
	_tmp3_ = self->priv->screensaver;
	lock_delay = g_settings_get_uint (_tmp3_, "lock-delay");
	_tmp4_ = self->priv->lockdown;
	disable_lock_screen = g_settings_get_boolean (_tmp4_, "disable-lock-screen");
	_tmp5_ = g_strdup ("swayidle -w ");
	_g_free0 (new_idle);
	new_idle = _tmp5_;
	_tmp6_ = new_idle;
	_tmp7_ = budgie_screenlock_calculate_dim (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
	_g_free0 (new_idle);
	new_idle = _tmp9_;
	_g_free0 (_tmp8_);
	if (idle_delay != ((guint) 0)) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp10_ = new_idle;
		_tmp11_ = g_strdup_printf ("%u", idle_delay);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat ("timeout ", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, " 'wlopm --off \\*' resume 'wlopm --on \\*' ", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp10_, _tmp16_, NULL);
		_g_free0 (new_idle);
		new_idle = _tmp17_;
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
	}
	if (lock_enabled) {
		_tmp18_ = !disable_lock_screen;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp19_ = new_idle;
		_tmp20_ = g_strdup_printf ("%u", idle_delay + lock_delay);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat ("timeout ", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, " '", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = budgie_screenlock_calculate_lockcommand (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp25_, _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, "' ", NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp19_, _tmp31_, NULL);
		_g_free0 (new_idle);
		new_idle = _tmp32_;
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
	}
	if (!disable_lock_screen) {
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp33_ = new_idle;
		_tmp34_ = budgie_screenlock_calculate_lockcommand (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat ("before-sleep '", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp37_, "'", NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp33_, _tmp39_, NULL);
		_g_free0 (new_idle);
		new_idle = _tmp40_;
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
	}
	_tmp41_ = new_idle;
	_tmp42_ = budgie_screenlock_calculate_sleep (self);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strconcat (" ", _tmp43_, NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strconcat (_tmp41_, _tmp45_, NULL);
	_g_free0 (new_idle);
	new_idle = _tmp46_;
	_g_free0 (_tmp45_);
	_g_free0 (_tmp43_);
	_tmp47_ = new_idle;
	g_debug ("screenlock.vala:200: %s", _tmp47_);
	{
		gchar** spawn_args = NULL;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar** _tmp50_;
		gint spawn_args_length1;
		gint _spawn_args_size_;
		gchar** spawn_env = NULL;
		gchar** _tmp51_;
		gchar** _tmp52_;
		gint spawn_env_length1;
		gint _spawn_env_size_;
		const gchar* _tmp57_;
		_tmp48_ = g_strdup ("killall");
		_tmp49_ = g_strdup ("swayidle");
		_tmp50_ = g_new0 (gchar*, 2 + 1);
		_tmp50_[0] = _tmp48_;
		_tmp50_[1] = _tmp49_;
		spawn_args = _tmp50_;
		spawn_args_length1 = 2;
		_spawn_args_size_ = spawn_args_length1;
		_tmp52_ = _tmp51_ = g_get_environ ();
		spawn_env = _tmp52_;
		spawn_env_length1 = _vala_array_length (_tmp51_);
		_spawn_env_size_ = spawn_env_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp53_ = FALSE;
				_tmp53_ = TRUE;
				while (TRUE) {
					gchar** _tmp55_;
					gint _tmp55__length1;
					gchar** _tmp56_;
					gint _tmp56__length1;
					if (!_tmp53_) {
						gint _tmp54_;
						_tmp54_ = i;
						i = _tmp54_ + 1;
					}
					_tmp53_ = FALSE;
					if (!(i <= 1)) {
						break;
					}
					_tmp55_ = spawn_args;
					_tmp55__length1 = spawn_args_length1;
					_tmp56_ = spawn_env;
					_tmp56__length1 = spawn_env_length1;
					g_spawn_sync ("/", _tmp55_, _tmp56_, (G_SPAWN_SEARCH_PATH | G_SPAWN_STDERR_TO_DEV_NULL) | G_SPAWN_STDOUT_TO_DEV_NULL, NULL, NULL, NULL, NULL, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
						spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_SPAWN_ERROR) {
							goto __catch0_g_spawn_error;
						}
						_g_free0 (new_idle);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
		}
		_tmp57_ = new_idle;
		g_spawn_command_line_async (_tmp57_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (new_idle);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp58_;
		const gchar* _tmp59_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp58_ = e;
		_tmp59_ = _tmp58_->message;
		g_print ("Error: %s\n", _tmp59_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (new_idle);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (new_idle);
}

static void
budgie_screenlock_on_powerscreen_get (BudgieScreenlock* self,
                                      GObject* o,
                                      GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgiePowerScreenRemote* _tmp0_ = NULL;
		BudgiePowerScreenRemote* _tmp1_;
		BudgiePowerScreenRemote* _tmp2_;
		BudgiePowerScreenRemote* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (BudgiePowerScreenRemote*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (BudgiePowerScreenRemote*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->powerscreen_proxy);
		self->priv->powerscreen_proxy = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("screenlock.vala:232: Failed to get PowerScreen proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_budgie_screenlock_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                           const gchar* name,
                                                           gpointer self)
{
	budgie_screenlock_on_bus_acquired ((BudgieScreenlock*) self, connection);
}

static void
__lambda37_ (BudgieScreenlock* self)
{
}

static void
___lambda37__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda37_ ((BudgieScreenlock*) self);
}

static void
__lambda38_ (BudgieScreenlock* self)
{
}

static void
___lambda38__gbus_name_lost_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda38_ ((BudgieScreenlock*) self);
}

void
budgie_screenlock_setup_dbus (BudgieScreenlock* self)
{
	g_return_if_fail (self != NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_DBUS_SCREENLOCK, G_BUS_NAME_OWNER_FLAGS_REPLACE, (GClosure*) ((_budgie_screenlock_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_screenlock_on_bus_acquired_gbus_acquired_callback, budgie_screenlock_ref (self), (GClosureNotify) budgie_screenlock_unref)), (GClosure*) ((___lambda37__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda37__gbus_name_acquired_callback, budgie_screenlock_ref (self), (GClosureNotify) budgie_screenlock_unref)), (GClosure*) ((___lambda38__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda38__gbus_name_lost_callback, budgie_screenlock_ref (self), (GClosureNotify) budgie_screenlock_unref)));
}

static void
budgie_screenlock_dim_data_free (gpointer _data)
{
	BudgieScreenlockDimData* _data_;
	_data_ = _data;
	_budgie_screenlock_unref0 (_data_->self);
	g_slice_free (BudgieScreenlockDimData, _data_);
}

static gpointer
_budgie_screenlock_ref0 (gpointer self)
{
	return self ? budgie_screenlock_ref (self) : NULL;
}

void
budgie_screenlock_dim (BudgieScreenlock* self,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	BudgieScreenlockDimData* _data_;
	BudgieScreenlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgieScreenlockDimData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_screenlock_dim_data_free);
	_tmp0_ = _budgie_screenlock_ref0 (self);
	_data_->self = _tmp0_;
	budgie_screenlock_dim_co (_data_);
}

void
budgie_screenlock_dim_finish (BudgieScreenlock* self,
                              GAsyncResult* _res_,
                              GError** error)
{
	BudgieScreenlockDimData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
budgie_screenlock_dim_co (BudgieScreenlockDimData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->powerscreen_proxy;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	budgie_screenlock_set_is_dimming (TRUE);
	_data_->_tmp1_ = _data_->self->priv->powerscreen_proxy;
	_data_->_tmp2_ = budgie_power_screen_remote_get_Brightness (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->self->priv->current_brightness = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->self->priv->power;
	_data_->idle_brightness = (gint32) g_settings_get_int (_data_->_tmp4_, "idle-brightness");
	if (_data_->self->priv->current_brightness > _data_->idle_brightness) {
		_data_->_tmp5_ = _data_->self->priv->powerscreen_proxy;
		budgie_power_screen_remote_set_Brightness (_data_->_tmp5_, _data_->idle_brightness);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
budgie_screenlock_undim_data_free (gpointer _data)
{
	BudgieScreenlockUndimData* _data_;
	_data_ = _data;
	_budgie_screenlock_unref0 (_data_->self);
	g_slice_free (BudgieScreenlockUndimData, _data_);
}

void
budgie_screenlock_undim (BudgieScreenlock* self,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	BudgieScreenlockUndimData* _data_;
	BudgieScreenlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgieScreenlockUndimData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_screenlock_undim_data_free);
	_tmp0_ = _budgie_screenlock_ref0 (self);
	_data_->self = _tmp0_;
	budgie_screenlock_undim_co (_data_);
}

void
budgie_screenlock_undim_finish (BudgieScreenlock* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	BudgieScreenlockUndimData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
__lambda39_ (BudgieScreenlock* self)
{
	gboolean result;
	budgie_screenlock_set_is_dimming (FALSE);
	result = FALSE;
	return result;
}

static gboolean
___lambda39__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda39_ ((BudgieScreenlock*) self);
	return result;
}

static gboolean
budgie_screenlock_undim_co (BudgieScreenlockUndimData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->powerscreen_proxy;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->powerscreen_proxy;
	budgie_power_screen_remote_set_Brightness (_data_->_tmp1_, _data_->self->priv->current_brightness);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda39__gsource_func, budgie_screenlock_ref (_data_->self), budgie_screenlock_unref);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
budgie_screenlock_on_bus_acquired (BudgieScreenlock* self,
                                   GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_screenlock_register_object (self, conn, BUDGIE_DBUS_SCREENLOCK_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_message ("screenlock.vala:277: Unable to register Screenlock: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_screenlock_lock_data_free (gpointer _data)
{
	BudgieScreenlockLockData* _data_;
	_data_ = _data;
	_budgie_screenlock_unref0 (_data_->self);
	g_slice_free (BudgieScreenlockLockData, _data_);
}

void
budgie_screenlock_lock (BudgieScreenlock* self,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	BudgieScreenlockLockData* _data_;
	BudgieScreenlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgieScreenlockLockData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_screenlock_lock_data_free);
	_tmp0_ = _budgie_screenlock_ref0 (self);
	_data_->self = _tmp0_;
	budgie_screenlock_lock_co (_data_);
}

void
budgie_screenlock_lock_finish (BudgieScreenlock* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	BudgieScreenlockLockData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
budgie_screenlock_lock_co (BudgieScreenlockLockData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!_data_->self->priv->all_apps) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp0_ = budgie_screenlock_calculate_lockcommand (_data_->self);
		_data_->_tmp1_ = _data_->_tmp0_;
		g_spawn_command_line_async (_data_->_tmp1_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp1_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->e;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_print ("Error: %s\n", _data_->_tmp3_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

BudgieScreenlock*
budgie_screenlock_init (void)
{
	BudgieScreenlock* _tmp0_;
	BudgieScreenlock* _tmp2_;
	BudgieScreenlock* result;
	_tmp0_ = budgie_screenlock_instance;
	if (_tmp0_ == NULL) {
		BudgieScreenlock* _tmp1_;
		_tmp1_ = budgie_screenlock_new ();
		_budgie_screenlock_unref0 (budgie_screenlock_instance);
		budgie_screenlock_instance = _tmp1_;
	}
	_tmp2_ = budgie_screenlock_instance;
	result = _tmp2_;
	return result;
}

gboolean
budgie_screenlock_on_battery (BudgieScreenlock* self,
                              GError** error)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->battery_mode;
	return result;
}

static void
budgie_screenlock_client_daemon (BudgieScreenlock* self,
                                 GObject* obj,
                                 GParamSpec* sp)
{
	UpClient* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = self->priv->client;
	self->priv->battery_mode = up_client_get_on_battery (_tmp0_);
}

static void
_budgie_screenlock_on_powerscreen_get_gasync_ready_callback (GObject* source_object,
                                                             GAsyncResult* res,
                                                             gpointer self)
{
	budgie_screenlock_on_powerscreen_get ((BudgieScreenlock*) self, source_object, res);
	budgie_screenlock_unref (self);
}

static void
_budgie_screenlock_client_daemon_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	budgie_screenlock_client_daemon ((BudgieScreenlock*) self, _sender, pspec);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
__lambda40_ (BudgieScreenlock* self,
             const gchar* key)
{
	gchar** search = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint search_length1;
	gint _search_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (key != NULL);
	_tmp0_ = g_strdup ("sleep-inactive-ac-timeout");
	_tmp1_ = g_strdup ("sleep-inactive-ac-type");
	_tmp2_ = g_strdup ("sleep-inactive-battery-timeout");
	_tmp3_ = g_strdup ("sleep-inactive-battery-type");
	_tmp4_ = g_strdup ("idle-dim");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	search = _tmp5_;
	search_length1 = 5;
	_search_size_ = search_length1;
	_tmp6_ = search;
	_tmp6__length1 = search_length1;
	if (_vala_string_array_contains (_tmp6_, _tmp6__length1, key)) {
		budgie_screenlock_calculate_idle (self);
	}
	search = (_vala_array_free (search, search_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda40__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda40_ ((BudgieScreenlock*) self, key);
}

static void
__lambda41_ (BudgieScreenlock* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "idle-delay") == 0) {
		budgie_screenlock_calculate_idle (self);
	}
}

static void
___lambda41__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda41_ ((BudgieScreenlock*) self, key);
}

static void
__lambda42_ (BudgieScreenlock* self,
             const gchar* key)
{
	gchar** search = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint search_length1;
	gint _search_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (key != NULL);
	_tmp0_ = g_strdup ("lock-enabled");
	_tmp1_ = g_strdup ("lock-delay");
	_tmp2_ = g_strdup ("picture-uri");
	_tmp3_ = g_new0 (gchar*, 3 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	search = _tmp3_;
	search_length1 = 3;
	_search_size_ = search_length1;
	_tmp4_ = search;
	_tmp4__length1 = search_length1;
	if (_vala_string_array_contains (_tmp4_, _tmp4__length1, key)) {
		budgie_screenlock_calculate_idle (self);
	}
	search = (_vala_array_free (search, search_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda42__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda42_ ((BudgieScreenlock*) self, key);
}

static void
__lambda43_ (BudgieScreenlock* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "disable-lock-screen") == 0) {
		budgie_screenlock_calculate_idle (self);
	}
}

static void
___lambda43__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda43_ ((BudgieScreenlock*) self, key);
}

static BudgieScreenlock*
budgie_screenlock_construct (GType object_type)
{
	BudgieScreenlock* self = NULL;
	gchar* check_apps[4] = {0};
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_[4] = {0};
	gchar* supported_lockers[2] = {0};
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_[2] = {0};
	const gchar* _tmp21_;
	gboolean _tmp22_ = FALSE;
	UpClient* _tmp24_;
	UpClient* _tmp25_;
	UpClient* _tmp26_;
	GPtrArray* _tmp27_;
	GPtrArray* _tmp28_;
	UpClient* _tmp38_;
	GSettings* _tmp39_;
	GSettings* _tmp40_;
	GSettings* _tmp41_;
	GSettings* _tmp42_;
	GSettings* _tmp43_;
	GSettings* _tmp44_;
	GSettings* _tmp45_;
	GSettings* _tmp46_;
	GError* _inner_error0_ = NULL;
	self = (BudgieScreenlock*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup ("swayidle");
	_tmp1_ = g_strdup ("killall");
	_tmp2_ = g_strdup ("wlopm");
	_tmp3_ = g_strdup ("dbus-send");
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	memcpy (check_apps, _tmp4_, 4 * sizeof (gchar*));
	{
		gchar** app_collection = NULL;
		gint app_collection_length1 = 0;
		gint _app_collection_size_ = 0;
		gint app_it = 0;
		app_collection = check_apps;
		app_collection_length1 = 4;
		for (app_it = 0; app_it < app_collection_length1; app_it = app_it + 1) {
			const gchar* app = NULL;
			app = app_collection[app_it];
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gboolean _tmp8_;
				_tmp5_ = app;
				_tmp6_ = g_find_program_in_path (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_ == NULL;
				_g_free0 (_tmp7_);
				if (_tmp8_) {
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = app;
					_tmp10_ = g_strconcat (_tmp9_, " is not found for screenlocking", NULL);
					_tmp11_ = _tmp10_;
					g_warning ("screenlock.vala:314: %s", _tmp11_);
					_g_free0 (_tmp11_);
					self->priv->all_apps = FALSE;
				}
			}
		}
	}
	_tmp12_ = g_strdup ("gtklock");
	_tmp13_ = g_strdup ("swaylock");
	_tmp14_[0] = _tmp12_;
	_tmp14_[1] = _tmp13_;
	memcpy (supported_lockers, _tmp14_, 2 * sizeof (gchar*));
	{
		gchar** app_collection = NULL;
		gint app_collection_length1 = 0;
		gint _app_collection_size_ = 0;
		gint app_it = 0;
		app_collection = supported_lockers;
		app_collection_length1 = 2;
		for (app_it = 0; app_it < app_collection_length1; app_it = app_it + 1) {
			const gchar* app = NULL;
			app = app_collection[app_it];
			{
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gboolean _tmp18_;
				_tmp15_ = app;
				_tmp16_ = g_find_program_in_path (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = _tmp17_ != NULL;
				_g_free0 (_tmp17_);
				if (_tmp18_) {
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp19_ = app;
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (self->priv->locker);
					self->priv->locker = _tmp20_;
					break;
				}
			}
		}
	}
	_tmp21_ = self->priv->locker;
	if (g_strcmp0 (_tmp21_, "") == 0) {
		g_warning ("screenlock.vala:330: No supported screen-locker has been found");
	}
	if (!self->priv->all_apps) {
		_tmp22_ = TRUE;
	} else {
		const gchar* _tmp23_;
		_tmp23_ = self->priv->locker;
		_tmp22_ = g_strcmp0 (_tmp23_, "") == 0;
	}
	if (_tmp22_) {
		_vala_array_destroy (supported_lockers, 2, (GDestroyNotify) g_free);
		_vala_array_destroy (check_apps, 4, (GDestroyNotify) g_free);
		return self;
	}
	g_async_initable_new_async (BUDGIE_TYPE_POWER_SCREEN_REMOTE_PROXY, 0, NULL, _budgie_screenlock_on_powerscreen_get_gasync_ready_callback, budgie_screenlock_ref (self), "g-flags", 0, "g-name", BUDGIE_POWERSCREEN_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", BUDGIE_POWERSCREEN_DBUS_OBJECT_PATH, "g-interface-name", "org.gnome.SettingsDaemon.Power.Screen", NULL);
	_tmp24_ = up_client_new ();
	_g_object_unref0 (self->priv->client);
	self->priv->client = _tmp24_;
	_tmp25_ = self->priv->client;
	g_signal_connect ((GObject*) _tmp25_, "notify", (GCallback) _budgie_screenlock_client_daemon_g_object_notify, self);
	_tmp26_ = self->priv->client;
	_tmp27_ = up_client_get_devices2 (_tmp26_);
	_g_ptr_array_unref0 (self->priv->devices);
	self->priv->devices = _tmp27_;
	_tmp28_ = self->priv->devices;
	{
		GPtrArray* device_collection = NULL;
		guint device_index = 0U;
		device_collection = _tmp28_;
		for (device_index = 0; device_index < device_collection->len; device_index = device_index + 1) {
			UpDevice* _tmp29_;
			UpDevice* device = NULL;
			_tmp29_ = _g_object_ref0 ((UpDevice*) g_ptr_array_index (device_collection, device_index));
			device = _tmp29_;
			{
				gboolean _tmp30_ = FALSE;
				UpDevice* _tmp31_;
				guint _tmp32_;
				guint _tmp33_;
				_tmp31_ = device;
				g_object_get (_tmp31_, "kind", &_tmp32_, NULL);
				_tmp33_ = _tmp32_;
				if (_tmp33_ == ((guint) UP_DEVICE_KIND_LINE_POWER)) {
					_tmp30_ = TRUE;
				} else {
					UpDevice* _tmp34_;
					guint _tmp35_;
					guint _tmp36_;
					_tmp34_ = device;
					g_object_get (_tmp34_, "kind", &_tmp35_, NULL);
					_tmp36_ = _tmp35_;
					_tmp30_ = _tmp36_ == ((guint) UP_DEVICE_KIND_BATTERY);
				}
				if (_tmp30_) {
					UpDevice* _tmp37_;
					_tmp37_ = device;
					g_signal_connect ((GObject*) _tmp37_, "notify", (GCallback) _budgie_screenlock_client_daemon_g_object_notify, self);
				}
				_g_object_unref0 (device);
			}
		}
	}
	_tmp38_ = self->priv->client;
	self->priv->battery_mode = up_client_get_on_battery (_tmp38_);
	_tmp39_ = g_settings_new ("org.gnome.settings-daemon.plugins.power");
	_g_object_unref0 (self->priv->power);
	self->priv->power = _tmp39_;
	_tmp40_ = self->priv->power;
	g_signal_connect (_tmp40_, "changed", (GCallback) ___lambda40__g_settings_changed, self);
	_tmp41_ = g_settings_new ("org.gnome.desktop.session");
	_g_object_unref0 (self->priv->session);
	self->priv->session = _tmp41_;
	_tmp42_ = self->priv->session;
	g_signal_connect (_tmp42_, "changed", (GCallback) ___lambda41__g_settings_changed, self);
	_tmp43_ = g_settings_new ("org.gnome.desktop.screensaver");
	_g_object_unref0 (self->priv->screensaver);
	self->priv->screensaver = _tmp43_;
	_tmp44_ = self->priv->screensaver;
	g_signal_connect (_tmp44_, "changed", (GCallback) ___lambda42__g_settings_changed, self);
	_tmp45_ = g_settings_new ("org.gnome.desktop.lockdown");
	_g_object_unref0 (self->priv->lockdown);
	self->priv->lockdown = _tmp45_;
	_tmp46_ = self->priv->lockdown;
	g_signal_connect (_tmp46_, "changed", (GCallback) ___lambda43__g_settings_changed, self);
	budgie_screenlock_calculate_idle (self);
	_vala_array_destroy (supported_lockers, 2, (GDestroyNotify) g_free);
	_vala_array_destroy (check_apps, 4, (GDestroyNotify) g_free);
	return self;
}

static BudgieScreenlock*
budgie_screenlock_new (void)
{
	return budgie_screenlock_construct (BUDGIE_TYPE_SCREENLOCK);
}

gboolean
budgie_screenlock_get_is_dimming (void)
{
	gboolean result;
	result = budgie_screenlock__is_dimming;
	return result;
}

static void
budgie_screenlock_set_is_dimming (gboolean value)
{
	budgie_screenlock__is_dimming = value;
}

static void
budgie_value_screenlock_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_screenlock_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_screenlock_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_screenlock_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_screenlock_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_screenlock_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_screenlock_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieScreenlock * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_screenlock_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_screenlock_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	BudgieScreenlock ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_screenlock_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_screenlock (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	BudgieParamSpecScreenlock* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_SCREENLOCK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_screenlock (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_SCREENLOCK), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_screenlock (GValue* value,
                             gpointer v_object)
{
	BudgieScreenlock * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_SCREENLOCK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_SCREENLOCK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_screenlock_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_screenlock_unref (old);
	}
}

void
budgie_value_take_screenlock (GValue* value,
                              gpointer v_object)
{
	BudgieScreenlock * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_SCREENLOCK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_SCREENLOCK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_screenlock_unref (old);
	}
}

static void
budgie_screenlock_class_init (BudgieScreenlockClass * klass,
                              gpointer klass_data)
{
	budgie_screenlock_parent_class = g_type_class_peek_parent (klass);
	((BudgieScreenlockClass *) klass)->finalize = budgie_screenlock_finalize;
	g_type_class_adjust_private_offset (klass, &BudgieScreenlock_private_offset);
}

static void
budgie_screenlock_instance_init (BudgieScreenlock * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	self->priv = budgie_screenlock_get_instance_private (self);
	self->priv->powerscreen_proxy = NULL;
	self->priv->isdimmable = FALSE;
	self->priv->current_brightness = (gint32) 0;
	self->priv->all_apps = TRUE;
	_tmp0_ = g_strdup ("");
	self->priv->locker = _tmp0_;
	self->ref_count = 1;
}

static void
budgie_screenlock_finalize (BudgieScreenlock * obj)
{
	BudgieScreenlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SCREENLOCK, BudgieScreenlock);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->powerscreen_proxy);
	_g_object_unref0 (self->priv->power);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->screensaver);
	_g_object_unref0 (self->priv->lockdown);
	_g_free0 (self->priv->locker);
	_g_object_unref0 (self->priv->client);
	_g_ptr_array_unref0 (self->priv->devices);
}

static GType
budgie_screenlock_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_screenlock_init, budgie_value_screenlock_free_value, budgie_value_screenlock_copy_value, budgie_value_screenlock_peek_pointer, "p", budgie_value_screenlock_collect_value, "p", budgie_value_screenlock_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieScreenlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_screenlock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieScreenlock), 0, (GInstanceInitFunc) budgie_screenlock_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_screenlock_type_id;
	budgie_screenlock_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieScreenlock", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_set_qdata (budgie_screenlock_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_screenlock_register_object);
	BudgieScreenlock_private_offset = g_type_add_instance_private (budgie_screenlock_type_id, sizeof (BudgieScreenlockPrivate));
	return budgie_screenlock_type_id;
}

GType
budgie_screenlock_get_type (void)
{
	static volatile gsize budgie_screenlock_type_id__once = 0;
	if (g_once_init_enter (&budgie_screenlock_type_id__once)) {
		GType budgie_screenlock_type_id;
		budgie_screenlock_type_id = budgie_screenlock_get_type_once ();
		g_once_init_leave (&budgie_screenlock_type_id__once, budgie_screenlock_type_id);
	}
	return budgie_screenlock_type_id__once;
}

gpointer
budgie_screenlock_ref (gpointer instance)
{
	BudgieScreenlock * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_screenlock_unref (gpointer instance)
{
	BudgieScreenlock * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_SCREENLOCK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_dbus_budgie_screenlock_dim (BudgieScreenlock* self,
                             GVariant* _parameters_,
                             GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BudgieScreenlockDimReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BudgieScreenlockDimReadyData);
	_ready_data->_invocation_ = invocation;
	budgie_screenlock_dim (self, (GAsyncReadyCallback) _dbus_budgie_screenlock_dim_ready, _ready_data);
}

static void
_dbus_budgie_screenlock_dim_ready (GObject * source_object,
                                   GAsyncResult * _res_,
                                   gpointer _user_data_)
{
	BudgieScreenlockDimReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_screenlock_dim_finish ((BudgieScreenlock*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (BudgieScreenlockDimReadyData, _ready_data);
}

static void
_dbus_budgie_screenlock_undim (BudgieScreenlock* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BudgieScreenlockUndimReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BudgieScreenlockUndimReadyData);
	_ready_data->_invocation_ = invocation;
	budgie_screenlock_undim (self, (GAsyncReadyCallback) _dbus_budgie_screenlock_undim_ready, _ready_data);
}

static void
_dbus_budgie_screenlock_undim_ready (GObject * source_object,
                                     GAsyncResult * _res_,
                                     gpointer _user_data_)
{
	BudgieScreenlockUndimReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_screenlock_undim_finish ((BudgieScreenlock*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (BudgieScreenlockUndimReadyData, _ready_data);
}

static void
_dbus_budgie_screenlock_lock (BudgieScreenlock* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BudgieScreenlockLockReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BudgieScreenlockLockReadyData);
	_ready_data->_invocation_ = invocation;
	budgie_screenlock_lock (self, (GAsyncReadyCallback) _dbus_budgie_screenlock_lock_ready, _ready_data);
}

static void
_dbus_budgie_screenlock_lock_ready (GObject * source_object,
                                    GAsyncResult * _res_,
                                    gpointer _user_data_)
{
	BudgieScreenlockLockReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_screenlock_lock_finish ((BudgieScreenlock*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (BudgieScreenlockLockReadyData, _ready_data);
}

static void
_dbus_budgie_screenlock_on_battery (BudgieScreenlock* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_screenlock_on_battery (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_screenlock_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Dim") == 0) {
		_dbus_budgie_screenlock_dim (object, parameters, invocation);
	} else if (strcmp (method_name, "Undim") == 0) {
		_dbus_budgie_screenlock_undim (object, parameters, invocation);
	} else if (strcmp (method_name, "Lock") == 0) {
		_dbus_budgie_screenlock_lock (object, parameters, invocation);
	} else if (strcmp (method_name, "OnBattery") == 0) {
		_dbus_budgie_screenlock_on_battery (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_screenlock_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_screenlock_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_screenlock_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = budgie_screenlock_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_screenlock_dbus_interface_info), &_budgie_screenlock_dbus_interface_vtable, data, _budgie_screenlock_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_screenlock_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	budgie_screenlock_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

