#ifndef _ECTOR_GL_SURFACE_EO_H_
#define _ECTOR_GL_SURFACE_EO_H_

#ifndef _ECTOR_GL_SURFACE_EO_CLASS_TYPE
#define _ECTOR_GL_SURFACE_EO_CLASS_TYPE

typedef Eo Ector_GL_Surface;

#endif

#ifndef _ECTOR_GL_SURFACE_EO_TYPES
#define _ECTOR_GL_SURFACE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Ector GL surface class
 *
 * @ingroup Ector_GL_Surface
 */
#define ECTOR_GL_SURFACE_CLASS ector_gl_surface_class_get()

ECTOR_API ECTOR_API_WEAK const Efl_Class *ector_gl_surface_class_get(void) EINA_CONST;

/**
 * @brief Get shader
 *
 * @param[in] obj The object.
 * @param[in] flags Flags
 *
 * @return Shader count
 *
 * @ingroup Ector_GL_Surface
 */
ECTOR_API ECTOR_API_WEAK unsigned int ector_gl_surface_shader_get(Eo *obj, uint64_t flags);

/**
 * @brief Push surface to GPU
 *
 * @param[in] obj The object.
 * @param[in] flags GL flags
 * @param[in] vertex GL vertex
 * @param[in] vertex_count GL vertex count
 * @param[in] mul_col Premultiplied color
 *
 * @return @c true on success, @c false otherwise
 *
 * @ingroup Ector_GL_Surface
 */
ECTOR_API ECTOR_API_WEAK Eina_Bool ector_gl_surface_push(Eo *obj, uint64_t flags, GLshort *vertex, unsigned int vertex_count, unsigned int mul_col);

/**
 * @brief Define state
 *
 * @param[in] obj The object.
 * @param[in] op Render operation
 * @param[in] clips Array of @ref Eina_Rect clip
 *
 * @return @c true on success, @c false otherwise
 *
 * @ingroup Ector_GL_Surface
 */
ECTOR_API ECTOR_API_WEAK Eina_Bool ector_gl_surface_state_define(Eo *obj, Efl_Gfx_Render_Op op, Eina_Array *clips);
#endif /* EFL_BETA_API_SUPPORT */

#endif
