// Generated from libavcodec/vulkan/ffv1_enc_setup.comp
const char *ff_source_ffv1_enc_setup_comp =
"/*\n"
" * FFv1 codec\n"
" *\n"
" * Copyright (c) 2024 Lynne <dev@lynne.ee>\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"uint8_t state[CONTEXT_SIZE];\n"
"\n"
"void init_slice(inout SliceContext sc, const uint slice_idx)\n"
"{\n"
"    /* Set coordinates */\n"
"    uvec2 img_size = imageSize(src[0]);\n"
"    uint sxs = slice_coord(img_size.x, gl_WorkGroupID.x + 0,\n"
"                           gl_NumWorkGroups.x, chroma_shift.x);\n"
"    uint sxe = slice_coord(img_size.x, gl_WorkGroupID.x + 1,\n"
"                           gl_NumWorkGroups.x, chroma_shift.x);\n"
"    uint sys = slice_coord(img_size.y, gl_WorkGroupID.y + 0,\n"
"                           gl_NumWorkGroups.y, chroma_shift.y);\n"
"    uint sye = slice_coord(img_size.y, gl_WorkGroupID.y + 1,\n"
"                           gl_NumWorkGroups.y, chroma_shift.y);\n"
"\n"
"    sc.slice_pos = ivec2(sxs, sys);\n"
"    sc.slice_dim = ivec2(sxe - sxs, sye - sys);\n"
"    sc.slice_coding_mode = int(force_pcm == 1);\n"
"    sc.slice_reset_contexts = sc.slice_coding_mode == 1;\n"
"    sc.quant_table_idx = u8vec3(context_model);\n"
"\n"
"    if ((rct_search == 0) || (sc.slice_coding_mode == 1))\n"
"        sc.slice_rct_coef = ivec2(1, 1);\n"
"\n"
"    rac_init(sc.c,\n"
"             OFFBUF(u8buf, out_data, slice_idx * slice_size_max),\n"
"             slice_size_max);\n"
"}\n"
"\n"
"void put_usymbol(inout RangeCoder c, uint v)\n"
"{\n"
"    bool is_nil = (v == 0);\n"
"    put_rac_direct(c, state[0], is_nil);\n"
"    if (is_nil)\n"
"        return;\n"
"\n"
"    const int e = findMSB(v);\n"
"\n"
"    for (int i = 0; i < e; i++)\n"
"        put_rac_direct(c, state[1 + min(i, 9)], true);\n"
"    put_rac_direct(c, state[1 + min(e, 9)], false);\n"
"\n"
"    for (int i = e - 1; i >= 0; i--)\n"
"        put_rac_direct(c, state[22 + min(i, 9)], bool(bitfieldExtract(v, i, 1)));\n"
"}\n"
"\n"
"void write_slice_header(inout SliceContext sc)\n"
"{\n"
"    [[unroll]]\n"
"    for (int i = 0; i < CONTEXT_SIZE; i++)\n"
"        state[i] = uint8_t(128);\n"
"\n"
"    put_usymbol(sc.c, gl_WorkGroupID.x);\n"
"    put_usymbol(sc.c, gl_WorkGroupID.y);\n"
"    put_usymbol(sc.c, 0);\n"
"    put_usymbol(sc.c, 0);\n"
"\n"
"    for (int i = 0; i < codec_planes; i++)\n"
"        put_usymbol(sc.c, sc.quant_table_idx[i]);\n"
"\n"
"    put_usymbol(sc.c, pic_mode);\n"
"    put_usymbol(sc.c, sar.x);\n"
"    put_usymbol(sc.c, sar.y);\n"
"\n"
"    if (version >= 4) {\n"
"        put_rac_direct(sc.c, state[0], sc.slice_reset_contexts);\n"
"        put_usymbol(sc.c, sc.slice_coding_mode);\n"
"        if (sc.slice_coding_mode != 1 && colorspace == 1) {\n"
"            put_usymbol(sc.c, sc.slice_rct_coef.y);\n"
"            put_usymbol(sc.c, sc.slice_rct_coef.x);\n"
"        }\n"
"    }\n"
"}\n"
"\n"
"void write_frame_header(inout SliceContext sc)\n"
"{\n"
"    put_rac_equi(sc.c, bool(key_frame));\n"
"}\n"
"\n"
"#ifdef GOLOMB\n"
"void init_golomb(inout SliceContext sc)\n"
"{\n"
"    sc.hdr_len = rac_terminate(sc.c);\n"
"    init_put_bits(sc.pb,\n"
"                  OFFBUF(u8buf, sc.c.bytestream_start, sc.hdr_len),\n"
"                  slice_size_max - sc.hdr_len);\n"
"}\n"
"#endif\n"
"\n"
"void main(void)\n"
"{\n"
"    const uint slice_idx = gl_WorkGroupID.y*gl_NumWorkGroups.x + gl_WorkGroupID.x;\n"
"\n"
"    init_slice(slice_ctx[slice_idx], slice_idx);\n"
"\n"
"    if (slice_idx == 0)\n"
"        write_frame_header(slice_ctx[slice_idx]);\n"
"\n"
"    write_slice_header(slice_ctx[slice_idx]);\n"
"\n"
"#ifdef GOLOMB\n"
"    init_golomb(slice_ctx[slice_idx]);\n"
"#endif\n"
"}\n"
;
