/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_SanitizerDefaultConfig_h
#define mozilla_dom_SanitizerDefaultConfig_h

// This file is automatically generated by update-safe-default-configuration.py

#include "mozilla/dom/SanitizerTypes.h"
#include "nsGkAtoms.h"

namespace mozilla::dom::sanitizer {

constexpr nsStaticAtom* kDefaultHTMLElements[] = {
    // clang-format off
    nsGkAtoms::a,
    nsGkAtoms::abbr,
    nsGkAtoms::address,
    nsGkAtoms::article,
    nsGkAtoms::aside,
    nsGkAtoms::b,
    nsGkAtoms::bdi,
    nsGkAtoms::bdo,
    nsGkAtoms::blockquote,
    nsGkAtoms::body,
    nsGkAtoms::br,
    nsGkAtoms::caption,
    nsGkAtoms::cite,
    nsGkAtoms::code,
    nsGkAtoms::col,
    nsGkAtoms::colgroup,
    nsGkAtoms::data,
    nsGkAtoms::dd,
    nsGkAtoms::del,
    nsGkAtoms::dfn,
    nsGkAtoms::div,
    nsGkAtoms::dl,
    nsGkAtoms::dt,
    nsGkAtoms::em,
    nsGkAtoms::figcaption,
    nsGkAtoms::figure,
    nsGkAtoms::footer,
    nsGkAtoms::h1,
    nsGkAtoms::h2,
    nsGkAtoms::h3,
    nsGkAtoms::h4,
    nsGkAtoms::h5,
    nsGkAtoms::h6,
    nsGkAtoms::head,
    nsGkAtoms::header,
    nsGkAtoms::hgroup,
    nsGkAtoms::hr,
    nsGkAtoms::html,
    nsGkAtoms::i,
    nsGkAtoms::ins,
    nsGkAtoms::kbd,
    nsGkAtoms::li,
    nsGkAtoms::main,
    nsGkAtoms::mark,
    nsGkAtoms::menu,
    nsGkAtoms::nav,
    nsGkAtoms::ol,
    nsGkAtoms::p,
    nsGkAtoms::pre,
    nsGkAtoms::q,
    nsGkAtoms::rp,
    nsGkAtoms::rt,
    nsGkAtoms::ruby,
    nsGkAtoms::s,
    nsGkAtoms::samp,
    nsGkAtoms::search,
    nsGkAtoms::section,
    nsGkAtoms::small,
    nsGkAtoms::span,
    nsGkAtoms::strong,
    nsGkAtoms::sub,
    nsGkAtoms::sup,
    nsGkAtoms::table,
    nsGkAtoms::tbody,
    nsGkAtoms::td,
    nsGkAtoms::tfoot,
    nsGkAtoms::th,
    nsGkAtoms::thead,
    nsGkAtoms::time,
    nsGkAtoms::title,
    nsGkAtoms::tr,
    nsGkAtoms::u,
    nsGkAtoms::ul,
    nsGkAtoms::var,
    nsGkAtoms::wbr,
    // clang-format on
};

constexpr nsStaticAtom* kDefaultMathMLElements[] = {
    // clang-format off
    nsGkAtoms::math,
    nsGkAtoms::merror,
    nsGkAtoms::mfrac,
    nsGkAtoms::mi,
    nsGkAtoms::mmultiscripts,
    nsGkAtoms::mn,
    nsGkAtoms::mo,
    nsGkAtoms::mover,
    nsGkAtoms::mpadded,
    nsGkAtoms::mphantom,
    nsGkAtoms::mprescripts,
    nsGkAtoms::mroot,
    nsGkAtoms::mrow,
    nsGkAtoms::ms,
    nsGkAtoms::mspace,
    nsGkAtoms::msqrt,
    nsGkAtoms::mstyle,
    nsGkAtoms::msub,
    nsGkAtoms::msubsup,
    nsGkAtoms::msup,
    nsGkAtoms::mtable,
    nsGkAtoms::mtd,
    nsGkAtoms::mtext,
    nsGkAtoms::mtr,
    nsGkAtoms::munder,
    nsGkAtoms::munderover,
    nsGkAtoms::semantics,
    // clang-format on
};

constexpr nsStaticAtom* kDefaultSVGElements[] = {
    // clang-format off
    nsGkAtoms::circle,
    nsGkAtoms::defs,
    nsGkAtoms::desc,
    nsGkAtoms::ellipse,
    nsGkAtoms::foreignObject,
    nsGkAtoms::g,
    nsGkAtoms::line,
    nsGkAtoms::marker,
    nsGkAtoms::metadata,
    nsGkAtoms::path,
    nsGkAtoms::polygon,
    nsGkAtoms::polyline,
    nsGkAtoms::rect,
    nsGkAtoms::svg,
    nsGkAtoms::text,
    nsGkAtoms::textPath,
    nsGkAtoms::title,
    nsGkAtoms::tspan,
    // clang-format on
};

constexpr nsStaticAtom* kDefaultAttributes[] = {
    // clang-format off
    nsGkAtoms::alignment_baseline,
    nsGkAtoms::baseline_shift,
    nsGkAtoms::clip_path,
    nsGkAtoms::clip_rule,
    nsGkAtoms::color,
    nsGkAtoms::color_interpolation,
    nsGkAtoms::cursor,
    nsGkAtoms::dir,
    nsGkAtoms::direction,
    nsGkAtoms::display,
    nsGkAtoms::displaystyle,
    nsGkAtoms::dominant_baseline,
    nsGkAtoms::fill,
    nsGkAtoms::fill_opacity,
    nsGkAtoms::fill_rule,
    nsGkAtoms::font_family,
    nsGkAtoms::font_size,
    nsGkAtoms::font_size_adjust,
    nsGkAtoms::font_stretch,
    nsGkAtoms::font_style,
    nsGkAtoms::font_variant,
    nsGkAtoms::font_weight,
    nsGkAtoms::lang,
    nsGkAtoms::letter_spacing,
    nsGkAtoms::marker_end,
    nsGkAtoms::marker_mid,
    nsGkAtoms::marker_start,
    nsGkAtoms::mathbackground,
    nsGkAtoms::mathcolor,
    nsGkAtoms::mathsize,
    nsGkAtoms::opacity,
    nsGkAtoms::paint_order,
    nsGkAtoms::pointer_events,
    nsGkAtoms::scriptlevel,
    nsGkAtoms::shape_rendering,
    nsGkAtoms::stop_color,
    nsGkAtoms::stop_opacity,
    nsGkAtoms::stroke,
    nsGkAtoms::stroke_dasharray,
    nsGkAtoms::stroke_dashoffset,
    nsGkAtoms::stroke_linecap,
    nsGkAtoms::stroke_linejoin,
    nsGkAtoms::stroke_miterlimit,
    nsGkAtoms::stroke_opacity,
    nsGkAtoms::stroke_width,
    nsGkAtoms::text_anchor,
    nsGkAtoms::text_decoration,
    nsGkAtoms::text_overflow,
    nsGkAtoms::text_rendering,
    nsGkAtoms::title,
    nsGkAtoms::transform,
    nsGkAtoms::transform_origin,
    nsGkAtoms::unicode_bidi,
    nsGkAtoms::vector_effect,
    nsGkAtoms::visibility,
    nsGkAtoms::white_space,
    nsGkAtoms::word_spacing,
    nsGkAtoms::writing_mode,
    // clang-format on
};

// Data is encoded as: element, attributes..., nullptr
constexpr nsStaticAtom* kHTMLElementWithAttributes[] = {
    // clang-format off
    /* element */ nsGkAtoms::a,
    nsGkAtoms::href,
    nsGkAtoms::hreflang,
    nsGkAtoms::type,
    nullptr,
    /* element */ nsGkAtoms::blockquote,
    nsGkAtoms::cite,
    nullptr,
    /* element */ nsGkAtoms::col,
    nsGkAtoms::span,
    nullptr,
    /* element */ nsGkAtoms::colgroup,
    nsGkAtoms::span,
    nullptr,
    /* element */ nsGkAtoms::data,
    nsGkAtoms::value,
    nullptr,
    /* element */ nsGkAtoms::del,
    nsGkAtoms::cite,
    nsGkAtoms::datetime,
    nullptr,
    /* element */ nsGkAtoms::ins,
    nsGkAtoms::cite,
    nsGkAtoms::datetime,
    nullptr,
    /* element */ nsGkAtoms::li,
    nsGkAtoms::value,
    nullptr,
    /* element */ nsGkAtoms::ol,
    nsGkAtoms::reversed,
    nsGkAtoms::start,
    nsGkAtoms::type,
    nullptr,
    /* element */ nsGkAtoms::td,
    nsGkAtoms::colspan,
    nsGkAtoms::headers,
    nsGkAtoms::rowspan,
    nullptr,
    /* element */ nsGkAtoms::th,
    nsGkAtoms::abbr,
    nsGkAtoms::colspan,
    nsGkAtoms::headers,
    nsGkAtoms::rowspan,
    nsGkAtoms::scope,
    nullptr,
    /* element */ nsGkAtoms::time,
    nsGkAtoms::datetime,
    nullptr,
    /* sentinel */ nullptr,
    // clang-format on
};

constexpr nsStaticAtom* kMathMLElementWithAttributes[] = {
    // clang-format off
    /* element */ nsGkAtoms::mo,
    nsGkAtoms::fence,
    nsGkAtoms::form,
    nsGkAtoms::largeop,
    nsGkAtoms::lspace,
    nsGkAtoms::maxsize,
    nsGkAtoms::minsize,
    nsGkAtoms::movablelimits,
    nsGkAtoms::rspace,
    nsGkAtoms::separator,
    nsGkAtoms::stretchy,
    nsGkAtoms::symmetric,
    nullptr,
    /* element */ nsGkAtoms::mover,
    nsGkAtoms::accent,
    nullptr,
    /* element */ nsGkAtoms::mpadded,
    nsGkAtoms::depth,
    nsGkAtoms::height,
    nsGkAtoms::lspace,
    nsGkAtoms::voffset,
    nsGkAtoms::width,
    nullptr,
    /* element */ nsGkAtoms::mspace,
    nsGkAtoms::depth,
    nsGkAtoms::height,
    nsGkAtoms::width,
    nullptr,
    /* element */ nsGkAtoms::mtd,
    nsGkAtoms::columnspan,
    nsGkAtoms::rowspan,
    nullptr,
    /* element */ nsGkAtoms::munder,
    nsGkAtoms::accentunder,
    nullptr,
    /* element */ nsGkAtoms::munderover,
    nsGkAtoms::accent,
    nsGkAtoms::accentunder,
    nullptr,
    /* sentinel */ nullptr,
    // clang-format on
};

constexpr nsStaticAtom* kSVGElementWithAttributes[] = {
    // clang-format off
    /* element */ nsGkAtoms::circle,
    nsGkAtoms::cx,
    nsGkAtoms::cy,
    nsGkAtoms::pathLength,
    nsGkAtoms::r,
    nullptr,
    /* element */ nsGkAtoms::ellipse,
    nsGkAtoms::cx,
    nsGkAtoms::cy,
    nsGkAtoms::pathLength,
    nsGkAtoms::rx,
    nsGkAtoms::ry,
    nullptr,
    /* element */ nsGkAtoms::foreignObject,
    nsGkAtoms::height,
    nsGkAtoms::width,
    nsGkAtoms::x,
    nsGkAtoms::y,
    nullptr,
    /* element */ nsGkAtoms::line,
    nsGkAtoms::pathLength,
    nsGkAtoms::x1,
    nsGkAtoms::x2,
    nsGkAtoms::y1,
    nsGkAtoms::y2,
    nullptr,
    /* element */ nsGkAtoms::marker,
    nsGkAtoms::markerHeight,
    nsGkAtoms::markerUnits,
    nsGkAtoms::markerWidth,
    nsGkAtoms::orient,
    nsGkAtoms::preserveAspectRatio,
    nsGkAtoms::refX,
    nsGkAtoms::refY,
    nsGkAtoms::viewBox,
    nullptr,
    /* element */ nsGkAtoms::path,
    nsGkAtoms::d,
    nsGkAtoms::pathLength,
    nullptr,
    /* element */ nsGkAtoms::polygon,
    nsGkAtoms::pathLength,
    nsGkAtoms::points,
    nullptr,
    /* element */ nsGkAtoms::polyline,
    nsGkAtoms::pathLength,
    nsGkAtoms::points,
    nullptr,
    /* element */ nsGkAtoms::rect,
    nsGkAtoms::height,
    nsGkAtoms::pathLength,
    nsGkAtoms::rx,
    nsGkAtoms::ry,
    nsGkAtoms::width,
    nsGkAtoms::x,
    nsGkAtoms::y,
    nullptr,
    /* element */ nsGkAtoms::svg,
    nsGkAtoms::height,
    nsGkAtoms::preserveAspectRatio,
    nsGkAtoms::viewBox,
    nsGkAtoms::width,
    nsGkAtoms::x,
    nsGkAtoms::y,
    nullptr,
    /* element */ nsGkAtoms::text,
    nsGkAtoms::dx,
    nsGkAtoms::dy,
    nsGkAtoms::lengthAdjust,
    nsGkAtoms::rotate,
    nsGkAtoms::textLength,
    nsGkAtoms::x,
    nsGkAtoms::y,
    nullptr,
    /* element */ nsGkAtoms::textPath,
    nsGkAtoms::lengthAdjust,
    nsGkAtoms::method,
    nsGkAtoms::path,
    nsGkAtoms::side,
    nsGkAtoms::spacing,
    nsGkAtoms::startOffset,
    nsGkAtoms::textLength,
    nullptr,
    /* element */ nsGkAtoms::tspan,
    nsGkAtoms::dx,
    nsGkAtoms::dy,
    nsGkAtoms::lengthAdjust,
    nsGkAtoms::rotate,
    nsGkAtoms::textLength,
    nsGkAtoms::x,
    nsGkAtoms::y,
    nullptr,
    /* sentinel */ nullptr,
    // clang-format on
};

}  // namespace mozilla::dom::sanitizer

#endif  // mozilla_dom_SanitizerDefaultConfig_h
