/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM GamepadAxisMoveEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "GamepadAxisMoveEvent.h"
#include "GamepadAxisMoveEventBinding.h"
#include "GamepadEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/GamepadAxisMoveEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


GamepadAxisMoveEvent::GamepadAxisMoveEvent(mozilla::dom::EventTarget* aOwner)
  : GamepadEvent(aOwner)
{
}

GamepadAxisMoveEvent::~GamepadAxisMoveEvent()
{
}

GamepadAxisMoveEvent*
GamepadAxisMoveEvent::AsGamepadAxisMoveEvent()
{
  return this;
}

JSObject*
GamepadAxisMoveEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return GamepadAxisMoveEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<GamepadAxisMoveEvent>
GamepadAxisMoveEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const GamepadAxisMoveEventInit& aEventInitDict)
{
  RefPtr<GamepadAxisMoveEvent> e = new GamepadAxisMoveEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mAxis = aEventInitDict.mAxis;
  e->mValue = aEventInitDict.mValue;
  e->mGamepad = aEventInitDict.mGamepad;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<GamepadAxisMoveEvent>
GamepadAxisMoveEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const GamepadAxisMoveEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

uint32_t
GamepadAxisMoveEvent::Axis() const
{
  return mAxis;
}

double
GamepadAxisMoveEvent::Value() const
{
  return mValue;
}


} // namespace mozilla::dom
