// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanGleanMetrics_h
#define mozilla_GleanGleanMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace fog {
  /**
   * generated from fog.data_directory_info
   */

  struct DataDirectoryInfoObjectItemFilesItem {
    Maybe<nsCString> file_name;
    Maybe<int64_t> file_created;
    Maybe<int64_t> file_modified;
    Maybe<int64_t> file_size;
  };

  using DataDirectoryInfoObjectItemFiles = nsTArray<DataDirectoryInfoObjectItemFilesItem>;


  struct DataDirectoryInfoObjectItem {
    Maybe<nsCString> dir_name;
    Maybe<bool> dir_exists;
    Maybe<int64_t> dir_created;
    Maybe<int64_t> dir_modified;
    Maybe<int64_t> file_count;
    Maybe<DataDirectoryInfoObjectItemFiles> files;
  };

  using DataDirectoryInfoObject = nsTArray<DataDirectoryInfoObjectItem>;
  /**
   * Information about the data directories and files used by FOG.
   * 
   * Structure is an array of objects, each containing the following properties:
   * - `dir_name`: The name of the directory. This is the subdirectory name relative to the
   *   FOG data directory and should only include "db", "events", and "pending_pings".
   * - `dir_exists`: Whether the directory exists. This should only be false on the first
   *   run of FOG, or if the directory was deleted.
   * - `dir_created`: The creation time of the directory, in seconds since the unix epoch. If
   *   the directory does not exist, this will be `null` and if the time cannot be determined,
   *   it will default to `0`.
   * - `dir_modified`: The last modification time of the directory, in seconds since the unix
   *   epoch. If the directory does not exist, this will be `null` and if the time cannot be
   *   determined, it will default to `0`.
   * - `file_count`: The number of files in the directory. If the directory does not exist,
   *   this will be `0`.
   * - `files`: An array of objects, each containing:
   *   - `file_name`: The name of the file. Could be `data.safe.bin`, `events.safe.bin`, or
   *     A uuid representing the doc-id of a pending ping.
   *   - `file_created`: The creation time of the file, in seconds since the epoch. If the
   *     file does not exist, this will be `null` and if the time cannot be determined, it
   *     will default to `0`.
   *   - `file_modified`: The last modification time of the file, in seconds since the epoch.
   *     If the file does not exist, this will be `null` and if the time cannot be determined,
   *     it will default to `0`.
   *   - `file_size`: The size of the file in bytes. This can be just about any size but a
   *     `0` value indicates the file is empty.
   */
  constexpr impl::ObjectMetric<DataDirectoryInfoObject, struct DataDirectoryInfoObjectTag> data_directory_info(4893);

  /**
   * generated from fog.failed_idle_registration
   * True if we failed to register with the idle service. Absent otherwise.
   * Means IPC probably isn't working well.
   * Child-process data will likely be absent, or incomplete.
   */
  constexpr impl::BooleanMetric failed_idle_registration(4894);

  /**
   * generated from fog.initializations
   * Time the FOG initializations take.
   */
  constexpr impl::TimingDistributionMetric initializations(4895);

  /**
   * generated from fog.inits_during_shutdown
   * Counts the number of times init had to be called during shutdown.
   * Should never have a value for any session long enough to grow idle.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> inits_during_shutdown(4896);

  /**
   * generated from fog.max_pings_per_minute
   * Value of the configurable rate limit, in pings per minute, for Glean pings as set at init.
   */
  constexpr impl::QuantityMetric max_pings_per_minute(4897);

  /**
   * generated from fog.subdir_entry_err
   */
  enum class SubdirEntryErrLabel: uint16_t {
    eDb = 0,
    eEvents = 1,
    ePendingPings = 2,
    e__Other__,
  };
  /**
   * How many dir entries per data subdirectory errored while reporting fog.data_diretory_info.
   * (Potentially because they were removed between `read_dir` and the iteration).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SubdirEntryErrLabel> subdir_entry_err(4898);

  /**
   * generated from fog.subdir_entry_metadata_err
   */
  enum class SubdirEntryMetadataErrLabel: uint16_t {
    eDb = 0,
    eEvents = 1,
    ePendingPings = 2,
    e__Other__,
  };
  /**
   * How many dir entries per data subdirectory errored while retrieving their metadata
   * while reporting fog.data_diretory_info.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SubdirEntryMetadataErrLabel> subdir_entry_metadata_err(4899);

  /**
   * generated from fog.subdir_err
   */
  enum class SubdirErrLabel: uint16_t {
    eDb = 0,
    eEvents = 1,
    ePendingPings = 2,
    e__Other__,
  };
  /**
   * Which data subdirectories suffered an err between is_dir and read_dir
   * while reporting fog.data_diretory_info.
   * (Potentially because they were removed in the interim).
   */
  constexpr impl::Labeled<impl::BooleanMetric, SubdirErrLabel> subdir_err(4900);
}

template <>
inline void impl::ObjectMetric<fog::DataDirectoryInfoObject, fog::DataDirectoryInfoObjectTag>::Set(const fog::DataDirectoryInfoObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.dir_name.isSome()) {
          writer.StringProperty("dir_name", *(aobjItem.dir_name));
        }
        if (aobjItem.dir_exists.isSome()) {
          writer.BoolProperty("dir_exists", *(aobjItem.dir_exists));
        }
        if (aobjItem.dir_created.isSome()) {
          writer.IntProperty("dir_created", *(aobjItem.dir_created));
        }
        if (aobjItem.dir_modified.isSome()) {
          writer.IntProperty("dir_modified", *(aobjItem.dir_modified));
        }
        if (aobjItem.file_count.isSome()) {
          writer.IntProperty("file_count", *(aobjItem.file_count));
        }
        if (aobjItem.files.isSome()) {
          writer.StartArrayProperty("files");
          for (const auto& aobjitemFilesItem: *aobjItem.files) {
            writer.StartObjectElement();
            {
              if (aobjitemFilesItem.file_name.isSome()) {
                writer.StringProperty("file_name", *(aobjitemFilesItem.file_name));
              }
              if (aobjitemFilesItem.file_created.isSome()) {
                writer.IntProperty("file_created", *(aobjitemFilesItem.file_created));
              }
              if (aobjitemFilesItem.file_modified.isSome()) {
                writer.IntProperty("file_modified", *(aobjitemFilesItem.file_modified));
              }
              if (aobjitemFilesItem.file_size.isSome()) {
                writer.IntProperty("file_size", *(aobjitemFilesItem.file_size));
              }
            }
            writer.EndObject();

          }
          writer.EndArray();
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

namespace fog_ipc {
  /**
   * generated from fog.ipc.buffer_sizes
   * The number and size of the IPC buffers being received over FOG IPC.
   */
  constexpr impl::MemoryDistributionMetric buffer_sizes(4901);

  /**
   * generated from fog.ipc.flush_durations
   * The length of time between asking the child processes for their
   * IPC buffers and all of them being received by the parent.
   */
  constexpr impl::TimingDistributionMetric flush_durations(4902);

  /**
   * generated from fog.ipc.flush_failures
   * The number of times we failed to flush all non-parent-process data,
   * throwing even partial results into the trash.
   * If this number is high, we might consider writing custom `MozPromise`-
   * handling code instead of using `MozPromise::All`.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> flush_failures(4903);

  /**
   * generated from fog.ipc.replay_failures
   * The number of times the ipc buffer failed to be replayed in the
   * parent process.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> replay_failures(4904);

  /**
   * generated from fog.ipc.shutdown_registration_failures
   * The number of times we tried to register shutdown flush routines for
   * content child processes, and failed (probably because there was no main
   * thread).
   * As a result there may be data loss from content child processes.
   * Large or rising number of clients experiencing this indicates we should
   * perhaps refactor content child shutdown in FOG to try harder to register
   * flush operations.
   * Will likely be obsoleted by bug 1641989.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> shutdown_registration_failures(4905);
}

} // namespace mozilla::glean

#endif // mozilla_GleanGleanMetrics_h
