/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM XRReferenceSpaceEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "XRReferenceSpaceEvent.h"
#include "XRReferenceSpaceEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/XRReferenceSpace.h"
#include "mozilla/dom/XRReferenceSpaceEvent.h"
#include "mozilla/dom/XRRigidTransform.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(XRReferenceSpaceEvent)

NS_IMPL_ADDREF_INHERITED(XRReferenceSpaceEvent, Event)
NS_IMPL_RELEASE_INHERITED(XRReferenceSpaceEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(XRReferenceSpaceEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mReferenceSpace)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mTransform)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(XRReferenceSpaceEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(XRReferenceSpaceEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mReferenceSpace)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mTransform)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(XRReferenceSpaceEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

XRReferenceSpaceEvent::XRReferenceSpaceEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

XRReferenceSpaceEvent::~XRReferenceSpaceEvent()
{
}

XRReferenceSpaceEvent*
XRReferenceSpaceEvent::AsXRReferenceSpaceEvent()
{
  return this;
}

JSObject*
XRReferenceSpaceEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return XRReferenceSpaceEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<XRReferenceSpaceEvent>
XRReferenceSpaceEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const XRReferenceSpaceEventInit& aEventInitDict)
{
  RefPtr<XRReferenceSpaceEvent> e = new XRReferenceSpaceEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mReferenceSpace = aEventInitDict.mReferenceSpace;
  e->mTransform = aEventInitDict.mTransform;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<XRReferenceSpaceEvent>
XRReferenceSpaceEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const XRReferenceSpaceEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

XRReferenceSpace*
XRReferenceSpaceEvent::ReferenceSpace() const
{
  return mReferenceSpace;
}

XRRigidTransform*
XRReferenceSpaceEvent::GetTransform() const
{
  return mTransform;
}


} // namespace mozilla::dom
