//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/indexedDB/PBackgroundIDBFactoryParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/indexedDB/ActorsChild.h"
#include "mozilla/dom/indexedDB/Key.h"
#include "mozilla/dom/indexedDB/KeyPath.h"
#include "mozilla/dom/indexedDB/SerializationHelpers.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBFactoryRequestParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace indexedDB {


auto PBackgroundIDBFactoryParent::RecvPBackgroundIDBFactoryRequestConstructor(
        PBackgroundIDBFactoryRequestParent* actor,
        const FactoryRequestParams& params) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundIDBFactoryParent::PBackgroundIDBFactoryParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundIDBFactoryParent);
}

PBackgroundIDBFactoryParent::~PBackgroundIDBFactoryParent()
{
    MOZ_COUNT_DTOR(PBackgroundIDBFactoryParent);
}

auto PBackgroundIDBFactoryParent::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundIDBFactoryParent::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundIDBFactoryParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundIDBFactoryParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundIDBFactoryParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundIDBFactoryParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PBackgroundIDBFactoryParent::ManagedPBackgroundIDBDatabaseParent(nsTArray<PBackgroundIDBDatabaseParent*>& aArr) const -> void
{
    mManagedPBackgroundIDBDatabaseParent.ToArray(aArr);
}

auto PBackgroundIDBFactoryParent::ManagedPBackgroundIDBDatabaseParent() const -> const ManagedContainer<PBackgroundIDBDatabaseParent>&
{
    return mManagedPBackgroundIDBDatabaseParent;
}

auto PBackgroundIDBFactoryParent::ManagedPBackgroundIDBFactoryRequestParent(nsTArray<PBackgroundIDBFactoryRequestParent*>& aArr) const -> void
{
    mManagedPBackgroundIDBFactoryRequestParent.ToArray(aArr);
}

auto PBackgroundIDBFactoryParent::ManagedPBackgroundIDBFactoryRequestParent() const -> const ManagedContainer<PBackgroundIDBFactoryRequestParent>&
{
    return mManagedPBackgroundIDBFactoryRequestParent;
}

auto PBackgroundIDBFactoryParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundIDBDatabaseMsgStart,
        PBackgroundIDBFactoryRequestMsgStart
    };
    return sIds;
}

auto PBackgroundIDBFactoryParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundIDBDatabaseMsgStart:
        return (&(mManagedPBackgroundIDBDatabaseParent));
    case PBackgroundIDBFactoryRequestMsgStart:
        return (&(mManagedPBackgroundIDBFactoryRequestParent));
    default:
        return nullptr;
    }
}

auto PBackgroundIDBFactoryParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PBackgroundIDBFactoryParent::OpenPBackgroundIDBDatabaseEndpoint(PBackgroundIDBDatabaseParent* aActor) -> ManagedEndpoint<PBackgroundIDBDatabaseChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBDatabaseParent actor");
        return ManagedEndpoint<PBackgroundIDBDatabaseChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBDatabaseParent actor");
        return ManagedEndpoint<PBackgroundIDBDatabaseChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBDatabaseChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBFactoryParent::BindPBackgroundIDBDatabaseEndpoint(
        ManagedEndpoint<PBackgroundIDBDatabaseParent> aEndpoint,
        PBackgroundIDBDatabaseParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBFactoryParent::OpenPBackgroundIDBFactoryRequestEndpoint(PBackgroundIDBFactoryRequestParent* aActor) -> ManagedEndpoint<PBackgroundIDBFactoryRequestChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBFactoryRequestParent actor");
        return ManagedEndpoint<PBackgroundIDBFactoryRequestChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBFactoryRequestParent actor");
        return ManagedEndpoint<PBackgroundIDBFactoryRequestChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBFactoryRequestChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBFactoryParent::BindPBackgroundIDBFactoryRequestEndpoint(
        ManagedEndpoint<PBackgroundIDBFactoryRequestParent> aEndpoint,
        PBackgroundIDBFactoryRequestParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBFactoryParent::Send__delete__(PBackgroundIDBFactoryParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBFactory::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBFactoryParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBFactory::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBackgroundIDBFactoryParent::SendPBackgroundIDBDatabaseConstructor(
        PBackgroundIDBDatabaseParent* actor,
        const DatabaseSpec& spec,
        mozilla::NotNull<PBackgroundIDBFactoryRequestParent*> request) -> PBackgroundIDBDatabaseParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PBackgroundIDBDatabaseParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBDatabaseParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBFactory::Msg_PBackgroundIDBDatabaseConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), spec);
    // Sentinel = 'spec'
    ((&(writer__)))->WriteSentinel(72155564);
    IPC::WriteParam((&(writer__)), request);
    // Sentinel = 'request'
    ((&(writer__)))->WriteSentinel(202703626);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBFactoryParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBFactory::Msg_PBackgroundIDBDatabaseConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PBackgroundIDBDatabaseParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PBackgroundIDBFactoryParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PBackgroundIDBFactoryRequestMsgStart:
        this->DeallocPBackgroundIDBFactoryRequestParent(static_cast<PBackgroundIDBFactoryRequestParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundIDBFactoryParent::OnMessageReceived(const Message& msg__) -> PBackgroundIDBFactoryParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundIDBFactory::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBFactoryParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBFactory::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBFactory::Msg_PBackgroundIDBFactoryRequestConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBFactoryParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBFactory::Msg_PBackgroundIDBFactoryRequestConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__params = IPC::ReadParam<FactoryRequestParams>((&(reader__)));
            if (!maybe__params) {
                FatalError("Error deserializing 'FactoryRequestParams'");
                return MsgValueError;

            }
            auto& params = *maybe__params;
            // Sentinel = 'params'
            if ((!(((&(reader__)))->ReadSentinel(146997893)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FactoryRequestParams'");
                return MsgValueError;
            }
            reader__.EndRead();
            PBackgroundIDBFactoryRequestParent* actor = (this)->AllocPBackgroundIDBFactoryRequestParent(params);
            if (!actor) {
                NS_WARNING("Cannot bind null PBackgroundIDBFactoryRequestParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PBackgroundIDBFactoryRequestParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPBackgroundIDBFactoryRequestConstructor(std::move(actor), std::move(params));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBFactory::Msg_GetDatabases__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBFactoryParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBFactory::Msg_GetDatabases", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__persistenceType = IPC::ReadParam<PersistenceType>((&(reader__)));
            if (!maybe__persistenceType) {
                FatalError("Error deserializing 'PersistenceType'");
                return MsgValueError;

            }
            auto& persistenceType = *maybe__persistenceType;
            // Sentinel = 'persistenceType'
            if ((!(((&(reader__)))->ReadSentinel(853345864)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PersistenceType'");
                return MsgValueError;
            }
            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PBackgroundIDBFactory::Reply_GetDatabases(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetDatabasesResolver resolver = [resolver__ = std::move(resolver__)](const GetDatabasesResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PBackgroundIDBFactoryParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvGetDatabases(std::move(persistenceType), std::move(principalInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBFactory::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PBackgroundIDBFactory::Reply_PBackgroundIDBDatabaseConstructor__ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundIDBFactoryParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundIDBFactoryParent::Result
{
    return MsgNotKnown;
}



} // namespace indexedDB
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBFactoryParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PBackgroundIDBFactory'
    (aWriter)->WriteSentinel(1435305976);
}

auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBFactoryParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PBackgroundIDBFactory actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PBackgroundIDBFactory'
    if ((!((aReader)->ReadSentinel(1435305976)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PBackgroundIDBFactory actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PBackgroundIDBFactoryMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PBackgroundIDBFactory)");

        return {};
    }
    return static_cast<::mozilla::dom::indexedDB::PBackgroundIDBFactoryParent*>(actor);
}

} // namespace IPC
