struct cs_fast_linear_gradient_common {
struct Samplers {
 bool set_slot(int index, int value) {
  switch (index) {
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int aTaskRect = NULL_ATTRIB;
 int aColor0 = NULL_ATTRIB;
 int aColor1 = NULL_ATTRIB;
 int aAxisSelect = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("aTaskRect", name) == 0) { aTaskRect = index; return; }
  if (strcmp("aColor0", name) == 0) { aColor0 = index; return; }
  if (strcmp("aColor1", name) == 0) { aColor1 = index; return; }
  if (strcmp("aAxisSelect", name) == 0) { aAxisSelect = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("aTaskRect", name) == 0) { return aTaskRect != NULL_ATTRIB ? aTaskRect : -1; }
  if (strcmp("aColor0", name) == 0) { return aColor0 != NULL_ATTRIB ? aColor0 : -1; }
  if (strcmp("aColor1", name) == 0) { return aColor1 != NULL_ATTRIB ? aColor1 : -1; }
  if (strcmp("aAxisSelect", name) == 0) { return aAxisSelect != NULL_ATTRIB ? aAxisSelect : -1; }
  return -1;
 }
} attrib_locations;
vec4_scalar vColor0;
vec4_scalar vColor1;
mat4_scalar uTransform;
void bind_textures() {
}
};
struct cs_fast_linear_gradient_vert : VertexShaderImpl, cs_fast_linear_gradient_common {
private:
typedef cs_fast_linear_gradient_vert Self;
// mat4_scalar uTransform;
vec2 aPosition;
Float vPos;
// vec4_scalar vColor0;
// vec4_scalar vColor1;
vec4_scalar aTaskRect;
vec4_scalar aColor0;
vec4_scalar aColor1;
float aAxisSelect;
ALWAYS_INLINE void main(void) {
 vPos = mix(0.f, 1.f, mix((aPosition).x, (aPosition).y, aAxisSelect));
 vColor0 = aColor0;
 vColor1 = aColor1;
 gl_Position = (uTransform)*(make_vec4(mix((aTaskRect).sel(X,Y), (aTaskRect).sel(Z,W), (aPosition).sel(X,Y)), 0.f, 1.f));
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 1:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 1:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 1:
  self->uTransform = mat4_scalar::load_from_ptr(value);
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_flat_attrib(self->aTaskRect, attribs[self->attrib_locations.aTaskRect], start, instance, count);
 load_flat_attrib(self->aColor0, attribs[self->attrib_locations.aColor0], start, instance, count);
 load_flat_attrib(self->aColor1, attribs[self->attrib_locations.aColor1], start, instance, count);
 load_flat_attrib(self->aAxisSelect, attribs[self->attrib_locations.aAxisSelect], start, instance, count);
}
public:
struct InterpOutputs {
float vPos;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->vPos = get_nth(vPos, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
cs_fast_linear_gradient_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct cs_fast_linear_gradient_frag : FragmentShaderImpl, cs_fast_linear_gradient_vert {
private:
typedef cs_fast_linear_gradient_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
Float vPos;
// vec4_scalar vColor0;
// vec4_scalar vColor1;
ALWAYS_INLINE void main(void) {
 oFragColor = mix(vColor0, vColor1, vPos);
}
typedef cs_fast_linear_gradient_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
Float vPos;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->vPos = init_interp(init->vPos, step->vPos);
  self->interp_step.vPos = step->vPos * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.vPos = init_interp(init->vPos, step->vPos);
  self->vPos = self->interp_perspective.vPos * w;
  self->interp_step.vPos = step->vPos * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  vPos += interp_step.vPos * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.vPos += interp_step.vPos * chunks;
  vPos = w * interp_perspective.vPos;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
public:
cs_fast_linear_gradient_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct cs_fast_linear_gradient_program : ProgramImpl, cs_fast_linear_gradient_frag {
int get_uniform(const char *name) const override {
 if (strcmp("uTransform", name) == 0) { return 1; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "cs_fast_linear_gradient"; }
static ProgramImpl* loader() { return new cs_fast_linear_gradient_program; }
};

