/* gitg-label-renderer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-label-renderer.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define GITG_LABEL_RENDERER_margin 2
#define GITG_LABEL_RENDERER_padding 6
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _GitgParamSpecLabelRenderer GitgParamSpecLabelRenderer;

struct _GitgParamSpecLabelRenderer {
	GParamSpec parent_instance;
};

static gpointer gitg_label_renderer_parent_class = NULL;

static gchar* gitg_label_renderer_label_text (GitgRef* r);
static gint gitg_label_renderer_get_label_width (PangoLayout* layout,
                                          GitgRef* r);
static gchar* gitg_label_renderer_class_from_ref (GitgRefType type);
static gint gitg_label_renderer_render_label (GtkWidget* widget,
                                       cairo_t* cr,
                                       PangoLayout* layout,
                                       GitgRef* r,
                                       gdouble x,
                                       gdouble y,
                                       gint height,
                                       gboolean use_state);
static guchar gitg_label_renderer_convert_color_channel (guchar color,
                                                  guchar alpha);
static void gitg_label_renderer_convert_bgra_to_rgba (guchar* src,
                                               gint src_length1,
                                               guchar* dst,
                                               gint dst_length1,
                                               gint width,
                                               gint height);
static guchar* _vala_array_dup17 (guchar* self,
                           gssize length);
static guint8* _vala_array_dup18 (guint8* self,
                           gssize length);
static void gitg_label_renderer_finalize (GitgLabelRenderer * obj);
static GType gitg_label_renderer_get_type_once (void);

static gchar*
gitg_label_renderer_label_text (GitgRef* r)
{
	gchar* escaped = NULL;
	GitgParsedRefName* _tmp0_;
	GitgParsedRefName* _tmp1_;
	GitgParsedRefName* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = gitg_ref_get_parsed_name (r);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gitg_parsed_ref_name_get_shortname (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_markup_escape_text (_tmp5_, (gssize) -1);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp2_);
	escaped = _tmp7_;
	_tmp8_ = g_strdup_printf ("<span size='smaller'>%s</span>", escaped);
	result = _tmp8_;
	_g_free0 (escaped);
	return result;
}

static gint
gitg_label_renderer_get_label_width (PangoLayout* layout,
                                     GitgRef* r)
{
	gchar* smaller = NULL;
	gchar* _tmp0_;
	gint w = 0;
	gint _tmp1_ = 0;
	gint result;
	g_return_val_if_fail (layout != NULL, 0);
	g_return_val_if_fail (r != NULL, 0);
	_tmp0_ = gitg_label_renderer_label_text (r);
	smaller = _tmp0_;
	pango_layout_set_markup (layout, smaller, -1);
	pango_layout_get_pixel_size (layout, &_tmp1_, NULL);
	w = _tmp1_;
	result = w + (GITG_LABEL_RENDERER_padding * 2);
	_g_free0 (smaller);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gint
gitg_label_renderer_width (GtkWidget* widget,
                           PangoFontDescription* font,
                           GSList* labels)
{
	gint ret = 0;
	PangoContext* ctx = NULL;
	PangoContext* _tmp0_;
	PangoContext* _tmp1_;
	PangoLayout* layout = NULL;
	PangoContext* _tmp2_;
	PangoLayout* _tmp3_;
	PangoLayout* _tmp4_;
	gint result;
	g_return_val_if_fail (widget != NULL, 0);
	if (labels == NULL) {
		result = 0;
		return result;
	}
	ret = 0;
	_tmp0_ = gtk_widget_get_pango_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = ctx;
	_tmp3_ = pango_layout_new (_tmp2_);
	layout = _tmp3_;
	_tmp4_ = layout;
	pango_layout_set_font_description (_tmp4_, font);
	{
		GSList* r_collection = NULL;
		GSList* r_it = NULL;
		r_collection = labels;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			GitgRef* _tmp5_;
			GitgRef* r = NULL;
			_tmp5_ = _g_object_ref0 ((GitgRef*) r_it->data);
			r = _tmp5_;
			{
				PangoLayout* _tmp6_;
				GitgRef* _tmp7_;
				_tmp6_ = layout;
				_tmp7_ = r;
				ret += gitg_label_renderer_get_label_width (_tmp6_, _tmp7_) + GITG_LABEL_RENDERER_margin;
				_g_object_unref0 (r);
			}
		}
	}
	result = ret + GITG_LABEL_RENDERER_margin;
	_g_object_unref0 (layout);
	_g_object_unref0 (ctx);
	return result;
}

static gchar*
gitg_label_renderer_class_from_ref (GitgRefType type)
{
	gchar* style_class = NULL;
	gchar* result;
	switch (type) {
		case GITG_REF_TYPE_BRANCH:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("branch");
			_g_free0 (style_class);
			style_class = _tmp0_;
			break;
		}
		case GITG_REF_TYPE_REMOTE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("remote");
			_g_free0 (style_class);
			style_class = _tmp1_;
			break;
		}
		case GITG_REF_TYPE_TAG:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("tag");
			_g_free0 (style_class);
			style_class = _tmp2_;
			break;
		}
		case GITG_REF_TYPE_STASH:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("stash");
			_g_free0 (style_class);
			style_class = _tmp3_;
			break;
		}
		default:
		{
			_g_free0 (style_class);
			style_class = NULL;
			break;
		}
	}
	result = style_class;
	return result;
}

static gint
gitg_label_renderer_render_label (GtkWidget* widget,
                                  cairo_t* cr,
                                  PangoLayout* layout,
                                  GitgRef* r,
                                  gdouble x,
                                  gdouble y,
                                  gint height,
                                  gboolean use_state)
{
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gchar* smaller = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gint w = 0;
	gint h = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkStyleContext* _tmp6_;
	gchar* style_class = NULL;
	GitgParsedRefName* _tmp7_;
	GitgParsedRefName* _tmp8_;
	GitgParsedRefName* _tmp9_;
	GitgRefType _tmp10_;
	GitgRefType _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gboolean rtl = FALSE;
	GtkStyleContext* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkStyleContext* _tmp20_;
	GtkStyleContext* _tmp21_;
	gint result;
	g_return_val_if_fail (widget != NULL, 0);
	g_return_val_if_fail (cr != NULL, 0);
	g_return_val_if_fail (layout != NULL, 0);
	g_return_val_if_fail (r != NULL, 0);
	_tmp0_ = gtk_widget_get_style_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = gitg_label_renderer_label_text (r);
	smaller = _tmp2_;
	_tmp3_ = smaller;
	pango_layout_set_markup (layout, _tmp3_, -1);
	pango_layout_get_pixel_size (layout, &_tmp4_, &_tmp5_);
	w = _tmp4_;
	h = _tmp5_;
	_tmp6_ = context;
	gtk_style_context_save (_tmp6_);
	_tmp7_ = gitg_ref_get_parsed_name (r);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = gitg_parsed_ref_name_get_rtype (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gitg_label_renderer_class_from_ref (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp9_);
	style_class = _tmp13_;
	_tmp14_ = style_class;
	if (_tmp14_ != NULL) {
		GtkStyleContext* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = context;
		_tmp16_ = style_class;
		gtk_style_context_add_class (_tmp15_, _tmp16_);
	}
	_tmp17_ = gtk_widget_get_style_context (widget);
	rtl = (gtk_style_context_get_state (_tmp17_) & GTK_STATE_FLAG_DIR_RTL) != 0;
	if (rtl) {
		x = x - (w + (GITG_LABEL_RENDERER_padding * 2));
	}
	_tmp18_ = context;
	gtk_render_background (_tmp18_, cr, x, y + GITG_LABEL_RENDERER_margin, (gdouble) (w + (GITG_LABEL_RENDERER_padding * 2)), (gdouble) (height - (GITG_LABEL_RENDERER_margin * 2)));
	_tmp19_ = context;
	gtk_render_frame (_tmp19_, cr, x, y + GITG_LABEL_RENDERER_margin, (gdouble) (w + (GITG_LABEL_RENDERER_padding * 2)), (gdouble) (height - (GITG_LABEL_RENDERER_margin * 2)));
	_tmp20_ = context;
	gtk_render_layout (_tmp20_, cr, x + GITG_LABEL_RENDERER_padding, (y + ((height - h) / 2.0)) - 1, layout);
	_tmp21_ = context;
	gtk_style_context_restore (_tmp21_);
	result = w;
	_g_free0 (style_class);
	_g_free0 (smaller);
	_g_object_unref0 (context);
	return result;
}

void
gitg_label_renderer_draw (GtkWidget* widget,
                          PangoFontDescription* font,
                          cairo_t* context,
                          GSList* labels,
                          GdkRectangle* area)
{
	gdouble pos = 0.0;
	gboolean rtl = FALSE;
	GtkStyleContext* _tmp0_;
	PangoContext* ctx = NULL;
	PangoContext* _tmp4_;
	PangoContext* _tmp5_;
	PangoLayout* layout = NULL;
	PangoContext* _tmp6_;
	PangoLayout* _tmp7_;
	PangoLayout* _tmp8_;
	g_return_if_fail (widget != NULL);
	g_return_if_fail (font != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = gtk_widget_get_style_context (widget);
	rtl = (gtk_style_context_get_state (_tmp0_) & GTK_STATE_FLAG_DIR_RTL) != 0;
	if (!rtl) {
		GdkRectangle _tmp1_;
		_tmp1_ = *area;
		pos = (_tmp1_.x + GITG_LABEL_RENDERER_margin) + 0.5;
	} else {
		GdkRectangle _tmp2_;
		GdkRectangle _tmp3_;
		_tmp2_ = *area;
		_tmp3_ = *area;
		pos = ((_tmp2_.x + _tmp3_.width) - GITG_LABEL_RENDERER_margin) - 0.5;
	}
	cairo_save (context);
	cairo_set_line_width (context, 1.0);
	_tmp4_ = gtk_widget_get_pango_context (widget);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	ctx = _tmp5_;
	_tmp6_ = ctx;
	_tmp7_ = pango_layout_new (_tmp6_);
	layout = _tmp7_;
	_tmp8_ = layout;
	pango_layout_set_font_description (_tmp8_, font);
	{
		GSList* r_collection = NULL;
		GSList* r_it = NULL;
		r_collection = labels;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			GitgRef* _tmp9_;
			GitgRef* r = NULL;
			_tmp9_ = _g_object_ref0 ((GitgRef*) r_it->data);
			r = _tmp9_;
			{
				gint w = 0;
				PangoLayout* _tmp10_;
				GitgRef* _tmp11_;
				GdkRectangle _tmp12_;
				GdkRectangle _tmp13_;
				gint o = 0;
				gint _tmp14_ = 0;
				_tmp10_ = layout;
				_tmp11_ = r;
				_tmp12_ = *area;
				_tmp13_ = *area;
				w = gitg_label_renderer_render_label (widget, context, _tmp10_, _tmp11_, (gdouble) ((gint) pos), (gdouble) _tmp12_.y, _tmp13_.height, TRUE);
				o = (w + (GITG_LABEL_RENDERER_padding * 2)) + GITG_LABEL_RENDERER_margin;
				if (rtl) {
					_tmp14_ = -o;
				} else {
					_tmp14_ = o;
				}
				pos += (gdouble) _tmp14_;
				_g_object_unref0 (r);
			}
		}
	}
	cairo_restore (context);
	_g_object_unref0 (layout);
	_g_object_unref0 (ctx);
}

GitgRef*
gitg_label_renderer_get_ref_at_pos (GtkWidget* widget,
                                    PangoFontDescription* font,
                                    GSList* labels,
                                    gint x,
                                    gint* hot_x)
{
	gint _vala_hot_x = 0;
	PangoContext* ctx = NULL;
	PangoContext* _tmp0_;
	PangoContext* _tmp1_;
	PangoLayout* layout = NULL;
	PangoContext* _tmp2_;
	PangoLayout* _tmp3_;
	PangoLayout* _tmp4_;
	gint start = 0;
	GitgRef* ret = NULL;
	GitgRef* result;
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (font != NULL, NULL);
	_vala_hot_x = 0;
	if (labels == NULL) {
		result = NULL;
		if (hot_x) {
			*hot_x = _vala_hot_x;
		}
		return result;
	}
	_tmp0_ = gtk_widget_get_pango_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = ctx;
	_tmp3_ = pango_layout_new (_tmp2_);
	layout = _tmp3_;
	_tmp4_ = layout;
	pango_layout_set_font_description (_tmp4_, font);
	start = GITG_LABEL_RENDERER_margin;
	ret = NULL;
	{
		GSList* r_collection = NULL;
		GSList* r_it = NULL;
		r_collection = labels;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			GitgRef* _tmp5_;
			GitgRef* r = NULL;
			_tmp5_ = _g_object_ref0 ((GitgRef*) r_it->data);
			r = _tmp5_;
			{
				gint width = 0;
				PangoLayout* _tmp6_;
				GitgRef* _tmp7_;
				gboolean _tmp8_ = FALSE;
				_tmp6_ = layout;
				_tmp7_ = r;
				width = gitg_label_renderer_get_label_width (_tmp6_, _tmp7_);
				if (x >= start) {
					_tmp8_ = x <= (start + width);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					GitgRef* _tmp9_;
					GitgRef* _tmp10_;
					_tmp9_ = r;
					_tmp10_ = _g_object_ref0 (_tmp9_);
					_g_object_unref0 (ret);
					ret = _tmp10_;
					_vala_hot_x = x - start;
					_g_object_unref0 (r);
					break;
				}
				start += width + GITG_LABEL_RENDERER_margin;
				_g_object_unref0 (r);
			}
		}
	}
	result = ret;
	_g_object_unref0 (layout);
	_g_object_unref0 (ctx);
	if (hot_x) {
		*hot_x = _vala_hot_x;
	}
	return result;
}

static guchar
gitg_label_renderer_convert_color_channel (guchar color,
                                           guchar alpha)
{
	gdouble _tmp0_ = 0.0;
	guchar result;
	if (((gint) alpha) != 0) {
		_tmp0_ = color / (alpha / 255.0);
	} else {
		_tmp0_ = (gdouble) 0;
	}
	result = (guchar) _tmp0_;
	return result;
}

static void
gitg_label_renderer_convert_bgra_to_rgba (guchar* src,
                                          gint src_length1,
                                          guchar* dst,
                                          gint dst_length1,
                                          gint width,
                                          gint height)
{
	gint i = 0;
	i = 0;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					y = y + 1;
					_tmp1_ = y;
				}
				_tmp0_ = FALSE;
				if (!(y < height)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							guchar _tmp4_;
							guchar _tmp5_;
							guchar _tmp6_;
							guchar _tmp7_;
							guchar _tmp8_;
							guchar _tmp9_;
							guchar _tmp10_;
							if (!_tmp2_) {
								gint _tmp3_;
								x = x + 1;
								_tmp3_ = x;
							}
							_tmp2_ = FALSE;
							if (!(x < width)) {
								break;
							}
							_tmp4_ = src[i + 2];
							_tmp5_ = src[i + 3];
							dst[i] = gitg_label_renderer_convert_color_channel (_tmp4_, _tmp5_);
							_tmp6_ = src[i + 1];
							_tmp7_ = src[i + 3];
							dst[i + 1] = gitg_label_renderer_convert_color_channel (_tmp6_, _tmp7_);
							_tmp8_ = src[i];
							_tmp9_ = src[i + 3];
							dst[i + 2] = gitg_label_renderer_convert_color_channel (_tmp8_, _tmp9_);
							_tmp10_ = src[i + 3];
							dst[i + 3] = _tmp10_;
							i += 4;
						}
					}
				}
			}
		}
	}
}

static guchar*
_vala_array_dup17 (guchar* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guchar));
	}
	return NULL;
}

static guint8*
_vala_array_dup18 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

GdkPixbuf*
gitg_label_renderer_render_ref (GtkWidget* widget,
                                PangoFontDescription* font,
                                GitgRef* r,
                                gint height,
                                gint minwidth)
{
	PangoContext* ctx = NULL;
	PangoContext* _tmp0_;
	PangoContext* _tmp1_;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp2_;
	gint width = 0;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp3_;
	cairo_t* context = NULL;
	cairo_t* _tmp4_;
	guchar* data = NULL;
	guchar* _tmp5_;
	guchar* _tmp6_;
	gint _tmp6__length1;
	gint data_length1;
	gint _data_size_;
	GdkPixbuf* ret = NULL;
	GdkPixbuf* _tmp7_;
	guint8* pixdata = NULL;
	guint8* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	gint pixdata_length1;
	gint _pixdata_size_;
	GdkPixbuf* result;
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (font != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = gtk_widget_get_pango_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = pango_layout_new (ctx);
	layout = _tmp2_;
	pango_layout_set_font_description (layout, font);
	width = MAX (gitg_label_renderer_get_label_width (layout, r), minwidth);
	_tmp3_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width + 2, height + 2);
	surface = _tmp3_;
	_tmp4_ = cairo_create (surface);
	context = _tmp4_;
	cairo_set_line_width (context, (gdouble) 1);
	gitg_label_renderer_render_label (widget, context, layout, r, (gdouble) 1, (gdouble) 1, height, FALSE);
	_tmp5_ = cairo_image_surface_get_data (surface);
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup17 (_tmp5_, -1) : _tmp5_;
	_tmp6__length1 = -1;
	data = _tmp6_;
	data_length1 = _tmp6__length1;
	_data_size_ = data_length1;
	_tmp7_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, width + 2, height + 2);
	ret = _tmp7_;
	_tmp8_ = gdk_pixbuf_get_pixels (ret);
	_tmp9_ = (_tmp8_ != NULL) ? _vala_array_dup18 (_tmp8_, -1) : _tmp8_;
	_tmp9__length1 = -1;
	pixdata = _tmp9_;
	pixdata_length1 = _tmp9__length1;
	_pixdata_size_ = pixdata_length1;
	gitg_label_renderer_convert_bgra_to_rgba (data, (gint) data_length1, pixdata, (gint) pixdata_length1, width + 2, height + 2);
	result = ret;
	pixdata = (g_free (pixdata), NULL);
	data = (g_free (data), NULL);
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
	_g_object_unref0 (layout);
	_g_object_unref0 (ctx);
	return result;
}

GitgLabelRenderer*
gitg_label_renderer_construct (GType object_type)
{
	GitgLabelRenderer* self = NULL;
	self = (GitgLabelRenderer*) g_type_create_instance (object_type);
	return self;
}

GitgLabelRenderer*
gitg_label_renderer_new (void)
{
	return gitg_label_renderer_construct (GITG_TYPE_LABEL_RENDERER);
}

static void
gitg_value_label_renderer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_value_label_renderer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_label_renderer_unref (value->data[0].v_pointer);
	}
}

static void
gitg_value_label_renderer_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_label_renderer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_value_label_renderer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_value_label_renderer_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgLabelRenderer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_label_renderer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_value_label_renderer_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	GitgLabelRenderer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_label_renderer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gitg_param_spec_label_renderer (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	GitgParamSpecLabelRenderer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_LABEL_RENDERER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gitg_value_get_label_renderer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_LABEL_RENDERER), NULL);
	return value->data[0].v_pointer;
}

void
gitg_value_set_label_renderer (GValue* value,
                               gpointer v_object)
{
	GitgLabelRenderer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_LABEL_RENDERER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_LABEL_RENDERER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_label_renderer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_label_renderer_unref (old);
	}
}

void
gitg_value_take_label_renderer (GValue* value,
                                gpointer v_object)
{
	GitgLabelRenderer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_LABEL_RENDERER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_LABEL_RENDERER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_label_renderer_unref (old);
	}
}

static void
gitg_label_renderer_class_init (GitgLabelRendererClass * klass,
                                gpointer klass_data)
{
	gitg_label_renderer_parent_class = g_type_class_peek_parent (klass);
	((GitgLabelRendererClass *) klass)->finalize = gitg_label_renderer_finalize;
}

static void
gitg_label_renderer_instance_init (GitgLabelRenderer * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
gitg_label_renderer_finalize (GitgLabelRenderer * obj)
{
	GitgLabelRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_LABEL_RENDERER, GitgLabelRenderer);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
gitg_label_renderer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_value_label_renderer_init, gitg_value_label_renderer_free_value, gitg_value_label_renderer_copy_value, gitg_value_label_renderer_peek_pointer, "p", gitg_value_label_renderer_collect_value, "p", gitg_value_label_renderer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgLabelRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_label_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgLabelRenderer), 0, (GInstanceInitFunc) gitg_label_renderer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_label_renderer_type_id;
	gitg_label_renderer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgLabelRenderer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gitg_label_renderer_type_id;
}

GType
gitg_label_renderer_get_type (void)
{
	static gsize gitg_label_renderer_type_id__once = 0;
	if (g_once_init_enter (&gitg_label_renderer_type_id__once)) {
		GType gitg_label_renderer_type_id;
		gitg_label_renderer_type_id = gitg_label_renderer_get_type_once ();
		g_once_init_leave (&gitg_label_renderer_type_id__once, gitg_label_renderer_type_id);
	}
	return gitg_label_renderer_type_id__once;
}

gpointer
gitg_label_renderer_ref (gpointer instance)
{
	GitgLabelRenderer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gitg_label_renderer_unref (gpointer instance)
{
	GitgLabelRenderer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_LABEL_RENDERER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

