/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_waterfall_sink_f = R"doc(A graphical sink to display multiple signals on a waterfall (spectrogram) plot.

This is a QT-based graphical sink the takes set of a floating point streams and plots a waterfall (spectrogram) plot.


Note that unlike the other qtgui sinks, this one does not support multiple input streams. We have yet to figure out a good way to display multiple, independent signals on this kind of a plot. If there are any suggestions or examples of this, we would love to see them. Otherwise, to display multiple signals here, it's probably best to sum the signals together and connect that here.


The sink supports plotting streaming float data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Float Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of float 32 values (pmt::is_f32vector) or PDUs where the data is a uniform vector of float 32 values.


Message Ports:

Constructor Specific Documentation:

Build a floating point waterfall sink.

Args:
    size : size of the FFT to compute and display. If using the PDU message port to plot samples, the length of each PDU must be a multiple of the FFT size.
    wintype : type of window to apply (see gr::fft::window::win_type)
    fc : center frequency of signal (use for x-axis labels)
    bw : bandwidth of signal (used to set x-axis labels)
    name : title for the plot
    nconnections : number of signals to be connected to the sink. The PDU message port is always available for a connection, and this value must be set to 0 if only the PDU message port is being used.
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_waterfall_sink_f_0 = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_waterfall_sink_f_1 = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_make = R"doc(A graphical sink to display multiple signals on a waterfall (spectrogram) plot.

This is a QT-based graphical sink the takes set of a floating point streams and plots a waterfall (spectrogram) plot.


Note that unlike the other qtgui sinks, this one does not support multiple input streams. We have yet to figure out a good way to display multiple, independent signals on this kind of a plot. If there are any suggestions or examples of this, we would love to see them. Otherwise, to display multiple signals here, it's probably best to sum the signals together and connect that here.


The sink supports plotting streaming float data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Float Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of float 32 values (pmt::is_f32vector) or PDUs where the data is a uniform vector of float 32 values.


Message Ports:

Constructor Specific Documentation:

Build a floating point waterfall sink.

Args:
    size : size of the FFT to compute and display. If using the PDU message port to plot samples, the length of each PDU must be a multiple of the FFT size.
    wintype : type of window to apply (see gr::fft::window::win_type)
    fc : center frequency of signal (use for x-axis labels)
    bw : bandwidth of signal (used to set x-axis labels)
    name : title for the plot
    nconnections : number of signals to be connected to the sink. The PDU message port is always available for a connection, and this value must be set to 0 if only the PDU message port is being used.
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_qwidget = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_clear_data = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_fft_size = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_fft_size = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_time_per_fft = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_fft_average = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_fft_average = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_fft_window = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_fft_window = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_frequency_range = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_intensity_range = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_update_time = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_title = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_time_title = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_color_map = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_plot_pos_half = R"doc(Pass \"true\" to this function to only show the positive half of the spectrum. By default, this plotter shows the full spectrum (positive and negative halves).)doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_title = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_color_map = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_set_size = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_auto_scale = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_min_intensity = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_max_intensity = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_enable_menu = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_enable_grid = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_disable_legend = R"doc()doc";


static const char* __doc_gr_qtgui_waterfall_sink_f_enable_axis_labels = R"doc()doc";
