/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_protocol_formatter_bb = R"doc(Uses a header format object to create a header from a tagged stream packet.

This block takes in tagged stream and creates a header, generally for MAC-level processing. Each received tagged stream is assumed to be its own frame, so any fragmentation would be done upstream in or before the flowgraph.


The header that is created and transmitted from this block. The payload should then be sent as a parallel tagged stream to be muxed together later. The header is based entirely on the  object, which is an object derived from the header_format_base class. All of these packet header format objects operate the same: they take in the payload data as well as possible extra metadata info about the PDU; the format object then returns the output and metadata info. This block then transmits the header vector and attaches and metadata as tags at the start of the header.

Constructor Specific Documentation:

Make a packet header block using a given .

Args:
    format : The format object to use when creating the header for the packet. Derived from the header_format_base class.
    len_tag_key : The tagged stream length key.)doc";


static const char* __doc_gr_digital_protocol_formatter_bb_protocol_formatter_bb_0 =
    R"doc()doc";


static const char* __doc_gr_digital_protocol_formatter_bb_protocol_formatter_bb_1 =
    R"doc()doc";


static const char* __doc_gr_digital_protocol_formatter_bb_make = R"doc(Uses a header format object to create a header from a tagged stream packet.

This block takes in tagged stream and creates a header, generally for MAC-level processing. Each received tagged stream is assumed to be its own frame, so any fragmentation would be done upstream in or before the flowgraph.


The header that is created and transmitted from this block. The payload should then be sent as a parallel tagged stream to be muxed together later. The header is based entirely on the  object, which is an object derived from the header_format_base class. All of these packet header format objects operate the same: they take in the payload data as well as possible extra metadata info about the PDU; the format object then returns the output and metadata info. This block then transmits the header vector and attaches and metadata as tags at the start of the header.

Constructor Specific Documentation:

Make a packet header block using a given .

Args:
    format : The format object to use when creating the header for the packet. Derived from the header_format_base class.
    len_tag_key : The tagged stream length key.)doc";


static const char* __doc_gr_digital_protocol_formatter_bb_set_header_format = R"doc()doc";
