// Copyright 2019 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package containerd

import (
	"sync"

	"github.com/google/cadvisor/container"
	"github.com/google/cadvisor/fs"
	info "github.com/google/cadvisor/info/v1"
)

func NewPluginWithOptions(o *Options) container.Plugin {
	return &plugin{options: o}
}

type plugin struct {
	options *Options
}

type Options struct {
	ContainerdEndpoint  string
	ContainerdNamespace string

	once          sync.Once
	ctrdClient    ContainerdClient
	ctrdClientErr error
}

func (p *plugin) InitializeFSContext(context *fs.Context) error {
	return nil
}

func (p *plugin) Register(factory info.MachineInfoFactory, fsInfo fs.FsInfo, includedMetrics container.MetricSet) (container.Factories, error) {
	return Register(p.options, factory, fsInfo, includedMetrics)
}
