/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package v1alpha3

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-codegen.sh

// AUTO-GENERATED FUNCTIONS START HERE. DO NOT EDIT.
var map_CELDeviceSelector = map[string]string{
	"":           "CELDeviceSelector contains a CEL expression for selecting a device.",
	"expression": "Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.\n\nThe expression's input is an object named \"device\", which carries the following properties:\n - driver (string): the name of the driver which defines this device.\n - attributes (map[string]object): the device's attributes, grouped by prefix\n   (e.g. device.attributes[\"dra.example.com\"] evaluates to an object with all\n   of the attributes which were prefixed by \"dra.example.com\".\n - capacity (map[string]object): the device's capacities, grouped by prefix.\n\nExample: Consider a device with driver=\"dra.example.com\", which exposes two attributes named \"model\" and \"ext.example.com/family\" and which exposes one capacity named \"modules\". This input to this expression would have the following fields:\n\n    device.driver\n    device.attributes[\"dra.example.com\"].model\n    device.attributes[\"ext.example.com\"].family\n    device.capacity[\"dra.example.com\"].modules\n\nThe device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.\n\nThe value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.\n\nIf an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.\n\nA robust expression should check for the existence of attributes before referencing them.\n\nFor ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:\n\n    cel.bind(dra, device.attributes[\"dra.example.com\"], dra.someBool && dra.anotherBool)\n\nThe length of the expression must be smaller or equal to 10 Ki. The cost of evaluating it is also limited based on the estimated number of logical steps.",
}

func (CELDeviceSelector) SwaggerDoc() map[string]string {
	return map_CELDeviceSelector
}

var map_DeviceSelector = map[string]string{
	"":    "DeviceSelector must have exactly one field set.",
	"cel": "CEL contains a CEL expression for selecting a device.",
}

func (DeviceSelector) SwaggerDoc() map[string]string {
	return map_DeviceSelector
}

var map_DeviceTaint = map[string]string{
	"":          "The device this taint is attached to has the \"effect\" on any claim which does not tolerate the taint and, through the claim, to pods using the claim.",
	"key":       "The taint key to be applied to a device. Must be a label name.",
	"value":     "The taint value corresponding to the taint key. Must be a label value.",
	"effect":    "The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them.\n\nValid effects are None, NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here. More effects may get added in the future. Consumers must treat unknown effects like None.",
	"timeAdded": "TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.",
}

func (DeviceTaint) SwaggerDoc() map[string]string {
	return map_DeviceTaint
}

var map_DeviceTaintRule = map[string]string{
	"":         "DeviceTaintRule adds one taint to all devices which match the selector. This has the same effect as if the taint was specified directly in the ResourceSlice by the DRA driver.",
	"metadata": "Standard object metadata",
	"spec":     "Spec specifies the selector and one taint.\n\nChanging the spec automatically increments the metadata.generation number.",
	"status":   "Status provides information about what was requested in the spec.",
}

func (DeviceTaintRule) SwaggerDoc() map[string]string {
	return map_DeviceTaintRule
}

var map_DeviceTaintRuleList = map[string]string{
	"":         "DeviceTaintRuleList is a collection of DeviceTaintRules.",
	"metadata": "Standard list metadata",
	"items":    "Items is the list of DeviceTaintRules.",
}

func (DeviceTaintRuleList) SwaggerDoc() map[string]string {
	return map_DeviceTaintRuleList
}

var map_DeviceTaintRuleSpec = map[string]string{
	"":               "DeviceTaintRuleSpec specifies the selector and one taint.",
	"deviceSelector": "DeviceSelector defines which device(s) the taint is applied to. All selector criteria must be satisfied for a device to match. The empty selector matches all devices. Without a selector, no devices are matches.",
	"taint":          "The taint that gets applied to matching devices.",
}

func (DeviceTaintRuleSpec) SwaggerDoc() map[string]string {
	return map_DeviceTaintRuleSpec
}

var map_DeviceTaintRuleStatus = map[string]string{
	"":           "DeviceTaintRuleStatus provides information about an on-going pod eviction.",
	"conditions": "Conditions provide information about the state of the DeviceTaintRule and the cluster at some point in time, in a machine-readable and human-readable format.\n\nThe following condition is currently defined as part of this API, more may get added: - Type: EvictionInProgress - Status: True if there are currently pods which need to be evicted, False otherwise\n  (includes the effects which don't cause eviction).\n- Reason: not specified, may change - Message: includes information about number of pending pods and already evicted pods\n  in a human-readable format, updated periodically, may change\n\nFor `effect: None`, the condition above gets set once for each change to the spec, with the message containing information about what would happen if the effect was `NoExecute`. This feedback can be used to decide whether changing the effect to `NoExecute` will work as intended. It only gets set once to avoid having to constantly update the status.\n\nMust have 8 or fewer entries.",
}

func (DeviceTaintRuleStatus) SwaggerDoc() map[string]string {
	return map_DeviceTaintRuleStatus
}

var map_DeviceTaintSelector = map[string]string{
	"":       "DeviceTaintSelector defines which device(s) a DeviceTaintRule applies to. The empty selector matches all devices. Without a selector, no devices are matched.",
	"driver": "If driver is set, only devices from that driver are selected. This fields corresponds to slice.spec.driver.",
	"pool":   "If pool is set, only devices in that pool are selected.\n\nAlso setting the driver name may be useful to avoid ambiguity when different drivers use the same pool name, but this is not required because selecting pools from different drivers may also be useful, for example when drivers with node-local devices use the node name as their pool name.",
	"device": "If device is set, only devices with that name are selected. This field corresponds to slice.spec.devices[].name.\n\nSetting also driver and pool may be required to avoid ambiguity, but is not required.",
}

func (DeviceTaintSelector) SwaggerDoc() map[string]string {
	return map_DeviceTaintSelector
}

// AUTO-GENERATED FUNCTIONS END HERE
