//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: contrib/envoy/extensions/filters/listener/postgres_inspector/v3alpha/postgres_inspector.proto

package v3alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on PostgresInspector with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *PostgresInspector) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PostgresInspector with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// PostgresInspectorMultiError, or nil if none found.
func (m *PostgresInspector) ValidateAll() error {
	return m.validate(true)
}

func (m *PostgresInspector) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetEnableMetadataExtraction()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PostgresInspectorValidationError{
					field:  "EnableMetadataExtraction",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PostgresInspectorValidationError{
					field:  "EnableMetadataExtraction",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEnableMetadataExtraction()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PostgresInspectorValidationError{
				field:  "EnableMetadataExtraction",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if wrapper := m.GetMaxStartupMessageSize(); wrapper != nil {

		if val := wrapper.GetValue(); val < 256 || val > 10000 {
			err := PostgresInspectorValidationError{
				field:  "MaxStartupMessageSize",
				reason: "value must be inside range [256, 10000]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if d := m.GetStartupTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = PostgresInspectorValidationError{
				field:  "StartupTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(1*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := PostgresInspectorValidationError{
					field:  "StartupTimeout",
					reason: "value must be greater than or equal to 1s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return PostgresInspectorMultiError(errors)
	}

	return nil
}

// PostgresInspectorMultiError is an error wrapping multiple validation errors
// returned by PostgresInspector.ValidateAll() if the designated constraints
// aren't met.
type PostgresInspectorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PostgresInspectorMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PostgresInspectorMultiError) AllErrors() []error { return m }

// PostgresInspectorValidationError is the validation error returned by
// PostgresInspector.Validate if the designated constraints aren't met.
type PostgresInspectorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PostgresInspectorValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PostgresInspectorValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PostgresInspectorValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PostgresInspectorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PostgresInspectorValidationError) ErrorName() string {
	return "PostgresInspectorValidationError"
}

// Error satisfies the builtin error interface
func (e PostgresInspectorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPostgresInspector.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PostgresInspectorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PostgresInspectorValidationError{}

// Validate checks the field values on StartupMetadata with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *StartupMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on StartupMetadata with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// StartupMetadataMultiError, or nil if none found.
func (m *StartupMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *StartupMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for User

	// no validation rules for Database

	// no validation rules for ApplicationName

	if len(errors) > 0 {
		return StartupMetadataMultiError(errors)
	}

	return nil
}

// StartupMetadataMultiError is an error wrapping multiple validation errors
// returned by StartupMetadata.ValidateAll() if the designated constraints
// aren't met.
type StartupMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m StartupMetadataMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m StartupMetadataMultiError) AllErrors() []error { return m }

// StartupMetadataValidationError is the validation error returned by
// StartupMetadata.Validate if the designated constraints aren't met.
type StartupMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e StartupMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e StartupMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e StartupMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e StartupMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e StartupMetadataValidationError) ErrorName() string { return "StartupMetadataValidationError" }

// Error satisfies the builtin error interface
func (e StartupMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStartupMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = StartupMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = StartupMetadataValidationError{}
