//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.proto

package gcp_authnv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on GcpAuthnFilterConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GcpAuthnFilterConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GcpAuthnFilterConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GcpAuthnFilterConfigMultiError, or nil if none found.
func (m *GcpAuthnFilterConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *GcpAuthnFilterConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetHttpUri()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GcpAuthnFilterConfigValidationError{
					field:  "HttpUri",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GcpAuthnFilterConfigValidationError{
					field:  "HttpUri",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHttpUri()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GcpAuthnFilterConfigValidationError{
				field:  "HttpUri",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRetryPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GcpAuthnFilterConfigValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GcpAuthnFilterConfigValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GcpAuthnFilterConfigValidationError{
				field:  "RetryPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetCacheConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GcpAuthnFilterConfigValidationError{
					field:  "CacheConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GcpAuthnFilterConfigValidationError{
					field:  "CacheConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCacheConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GcpAuthnFilterConfigValidationError{
				field:  "CacheConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTokenHeader()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GcpAuthnFilterConfigValidationError{
					field:  "TokenHeader",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GcpAuthnFilterConfigValidationError{
					field:  "TokenHeader",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTokenHeader()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GcpAuthnFilterConfigValidationError{
				field:  "TokenHeader",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Cluster

	if d := m.GetTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = GcpAuthnFilterConfigValidationError{
				field:  "Timeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			lt := time.Duration(4294967296*time.Second + 0*time.Nanosecond)
			gte := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur < gte || dur >= lt {
				err := GcpAuthnFilterConfigValidationError{
					field:  "Timeout",
					reason: "value must be inside range [0s, 1193046h28m16s)",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return GcpAuthnFilterConfigMultiError(errors)
	}

	return nil
}

// GcpAuthnFilterConfigMultiError is an error wrapping multiple validation
// errors returned by GcpAuthnFilterConfig.ValidateAll() if the designated
// constraints aren't met.
type GcpAuthnFilterConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GcpAuthnFilterConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GcpAuthnFilterConfigMultiError) AllErrors() []error { return m }

// GcpAuthnFilterConfigValidationError is the validation error returned by
// GcpAuthnFilterConfig.Validate if the designated constraints aren't met.
type GcpAuthnFilterConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GcpAuthnFilterConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GcpAuthnFilterConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GcpAuthnFilterConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GcpAuthnFilterConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GcpAuthnFilterConfigValidationError) ErrorName() string {
	return "GcpAuthnFilterConfigValidationError"
}

// Error satisfies the builtin error interface
func (e GcpAuthnFilterConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGcpAuthnFilterConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GcpAuthnFilterConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GcpAuthnFilterConfigValidationError{}

// Validate checks the field values on Audience with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Audience) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Audience with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in AudienceMultiError, or nil
// if none found.
func (m *Audience) ValidateAll() error {
	return m.validate(true)
}

func (m *Audience) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetUrl()) < 1 {
		err := AudienceValidationError{
			field:  "Url",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return AudienceMultiError(errors)
	}

	return nil
}

// AudienceMultiError is an error wrapping multiple validation errors returned
// by Audience.ValidateAll() if the designated constraints aren't met.
type AudienceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AudienceMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AudienceMultiError) AllErrors() []error { return m }

// AudienceValidationError is the validation error returned by
// Audience.Validate if the designated constraints aren't met.
type AudienceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AudienceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AudienceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AudienceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AudienceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AudienceValidationError) ErrorName() string { return "AudienceValidationError" }

// Error satisfies the builtin error interface
func (e AudienceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAudience.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AudienceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AudienceValidationError{}

// Validate checks the field values on TokenCacheConfig with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *TokenCacheConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TokenCacheConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TokenCacheConfigMultiError, or nil if none found.
func (m *TokenCacheConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *TokenCacheConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetCacheSize(); wrapper != nil {

		if wrapper.GetValue() > 9223372036854775807 {
			err := TokenCacheConfigValidationError{
				field:  "CacheSize",
				reason: "value must be less than or equal to 9223372036854775807",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return TokenCacheConfigMultiError(errors)
	}

	return nil
}

// TokenCacheConfigMultiError is an error wrapping multiple validation errors
// returned by TokenCacheConfig.ValidateAll() if the designated constraints
// aren't met.
type TokenCacheConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TokenCacheConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TokenCacheConfigMultiError) AllErrors() []error { return m }

// TokenCacheConfigValidationError is the validation error returned by
// TokenCacheConfig.Validate if the designated constraints aren't met.
type TokenCacheConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TokenCacheConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TokenCacheConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TokenCacheConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TokenCacheConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TokenCacheConfigValidationError) ErrorName() string { return "TokenCacheConfigValidationError" }

// Error satisfies the builtin error interface
func (e TokenCacheConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTokenCacheConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TokenCacheConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TokenCacheConfigValidationError{}

// Validate checks the field values on TokenHeader with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TokenHeader) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TokenHeader with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TokenHeaderMultiError, or
// nil if none found.
func (m *TokenHeader) ValidateAll() error {
	return m.validate(true)
}

func (m *TokenHeader) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := TokenHeaderValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_TokenHeader_Name_Pattern.MatchString(m.GetName()) {
		err := TokenHeaderValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_TokenHeader_ValuePrefix_Pattern.MatchString(m.GetValuePrefix()) {
		err := TokenHeaderValidationError{
			field:  "ValuePrefix",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return TokenHeaderMultiError(errors)
	}

	return nil
}

// TokenHeaderMultiError is an error wrapping multiple validation errors
// returned by TokenHeader.ValidateAll() if the designated constraints aren't met.
type TokenHeaderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TokenHeaderMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TokenHeaderMultiError) AllErrors() []error { return m }

// TokenHeaderValidationError is the validation error returned by
// TokenHeader.Validate if the designated constraints aren't met.
type TokenHeaderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TokenHeaderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TokenHeaderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TokenHeaderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TokenHeaderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TokenHeaderValidationError) ErrorName() string { return "TokenHeaderValidationError" }

// Error satisfies the builtin error interface
func (e TokenHeaderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTokenHeader.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TokenHeaderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TokenHeaderValidationError{}

var _TokenHeader_Name_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _TokenHeader_ValuePrefix_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")
