//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/type/matcher/v3/address.proto

package matcherv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on AddressMatcher with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *AddressMatcher) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AddressMatcher with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in AddressMatcherMultiError,
// or nil if none found.
func (m *AddressMatcher) ValidateAll() error {
	return m.validate(true)
}

func (m *AddressMatcher) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetRanges() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AddressMatcherValidationError{
						field:  fmt.Sprintf("Ranges[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AddressMatcherValidationError{
						field:  fmt.Sprintf("Ranges[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AddressMatcherValidationError{
					field:  fmt.Sprintf("Ranges[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return AddressMatcherMultiError(errors)
	}

	return nil
}

// AddressMatcherMultiError is an error wrapping multiple validation errors
// returned by AddressMatcher.ValidateAll() if the designated constraints
// aren't met.
type AddressMatcherMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AddressMatcherMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AddressMatcherMultiError) AllErrors() []error { return m }

// AddressMatcherValidationError is the validation error returned by
// AddressMatcher.Validate if the designated constraints aren't met.
type AddressMatcherValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AddressMatcherValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AddressMatcherValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AddressMatcherValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AddressMatcherValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AddressMatcherValidationError) ErrorName() string { return "AddressMatcherValidationError" }

// Error satisfies the builtin error interface
func (e AddressMatcherValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAddressMatcher.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AddressMatcherValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AddressMatcherValidationError{}
