/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// IngressServiceBackendApplyConfiguration represents a declarative configuration of the IngressServiceBackend type for use
// with apply.
//
// IngressServiceBackend references a Kubernetes Service as a Backend.
type IngressServiceBackendApplyConfiguration struct {
	// name is the referenced service. The service must exist in
	// the same namespace as the Ingress object.
	Name *string `json:"name,omitempty"`
	// port of the referenced service. A port name or port number
	// is required for a IngressServiceBackend.
	Port *ServiceBackendPortApplyConfiguration `json:"port,omitempty"`
}

// IngressServiceBackendApplyConfiguration constructs a declarative configuration of the IngressServiceBackend type for use with
// apply.
func IngressServiceBackend() *IngressServiceBackendApplyConfiguration {
	return &IngressServiceBackendApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *IngressServiceBackendApplyConfiguration) WithName(value string) *IngressServiceBackendApplyConfiguration {
	b.Name = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *IngressServiceBackendApplyConfiguration) WithPort(value *ServiceBackendPortApplyConfiguration) *IngressServiceBackendApplyConfiguration {
	b.Port = value
	return b
}
