
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kactionmenu_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "ktoolbarspaceraction_wrapper.h"

// Argument includes
#include <QString>
#include <qaction.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qtoolbutton.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KActionMenu_Type = nullptr;
static PyTypeObject *Sbk_KActionMenu_TypeF(void)
{
    return _Sbk_KActionMenu_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KActionMenuWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KActionMenuWrapper::KActionMenuWrapper(::QObject * parent) : KActionMenu(parent)
{
}

KActionMenuWrapper::KActionMenuWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent) : KActionMenu(icon, text, parent)
{
}

KActionMenuWrapper::KActionMenuWrapper(const ::QString & text, ::QObject * parent) : KActionMenu(text, parent)
{
}

void KActionMenuWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionMenu_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KActionMenu", funcName, gil, pyOverride, event);
}

void KActionMenuWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionMenu_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KActionMenu", funcName, gil, pyOverride, signal);
}

::QWidget * KActionMenuWrapper::createWidget(::QWidget * parent)
{
    static const char *funcName = "createWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionMenu_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KActionMenu::createWidget(parent);
    }
    return KToolBarSpacerActionWrapper::sbk_o_createWidget("KActionMenu", funcName, gil, pyOverride, parent);
}

void KActionMenuWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionMenu_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KActionMenu", funcName, gil, pyOverride, event);
}

void KActionMenuWrapper::deleteWidget(::QWidget * widget)
{
    static const char *funcName = "deleteWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionMenu_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidgetAction::deleteWidget(widget);
    }
    KToolBarSpacerActionWrapper::sbk_o_deleteWidget("KActionMenu", funcName, gil, pyOverride, widget);
}

void KActionMenuWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionMenu_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KActionMenu", funcName, gil, pyOverride, signal);
}

bool KActionMenuWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionMenu_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidgetAction::event(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_event("KActionMenu", funcName, gil, pyOverride, arg__1);
}

bool KActionMenuWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionMenu_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidgetAction::eventFilter(arg__1, arg__2);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KActionMenu", funcName, gil, pyOverride, arg__1, arg__2);
}

void KActionMenuWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionMenu_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KActionMenu", funcName, gil, pyOverride, event);
}

const QMetaObject *KActionMenuWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KActionMenu::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KActionMenuWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KActionMenu::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KActionMenuWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KActionMenuWrapper *>(this));
    }
    return KActionMenu::qt_metacast(_clname);
}

KActionMenuWrapper::~KActionMenuWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KActionMenu_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KActionMenu_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KActionMenu >()))
        return -1;

    KActionMenuWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KActionMenu", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KActionMenu::KActionMenu(QObject*)
    // 1: KActionMenu::KActionMenu(QIcon,QString,QObject*)
    // 2: KActionMenu::KActionMenu(QString,QObject*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
        overloadId = 1; // KActionMenu(QIcon,QString,QObject*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KActionMenu(QObject*)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
        overloadId = 2; // KActionMenu(QString,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KActionMenu(QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KActionMenu(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KActionMenuWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KActionMenuWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KActionMenu(const QIcon &icon, const QString &text, QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KActionMenu(QIcon,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KActionMenuWrapper(*cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KActionMenuWrapper(*cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
        case 2: // KActionMenu(const QString &text, QObject *parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KActionMenu(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KActionMenuWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KActionMenuWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KActionMenu >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KActionMenuFunc_addAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionMenu::addAction(QAction*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // addAction(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addAction(QAction*)
            cppSelf->addAction(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionMenuFunc_addSeparator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // addSeparator()
        QAction * cppResult = cppSelf->addSeparator();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionMenuFunc_createWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidgetAction::createWidget(QWidget*)->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // createWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createWidget(QWidget*)
            QWidget * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KActionMenu::createWidget(cppArg0)
                : cppSelf->createWidget(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionMenuFunc_insertAction(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "insertAction", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KActionMenu::insertAction(QAction*,QAction*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertAction(QAction*,QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "insertAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QAction *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QAction *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // insertAction(QAction*,QAction*)
            cppSelf->insertAction(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionMenuFunc_insertSeparator(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionMenu::insertSeparator(QAction*)->QAction*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // insertSeparator(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "insertSeparator", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // insertSeparator(QAction*)
            QAction * cppResult = cppSelf->insertSeparator(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionMenuFunc_popupMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // popupMode()const
        QToolButton::ToolButtonPopupMode cppResult = const_cast<const ::KActionMenu *>(cppSelf)->popupMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_ToolButtonPopupMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionMenuFunc_removeAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionMenu::removeAction(QAction*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // removeAction(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeAction(QAction*)
            cppSelf->removeAction(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionMenuFunc_setPopupMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionMenu::setPopupMode(QToolButton::ToolButtonPopupMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_ToolButtonPopupMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setPopupMode(QToolButton::ToolButtonPopupMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPopupMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]);

    // Call function/method
    {
        ::QToolButton::ToolButtonPopupMode cppArg0{QToolButton::DelayedPopup};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPopupMode(QToolButton::ToolButtonPopupMode)
            cppSelf->setPopupMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KActionMenu_PropertyStrings[] = {
    "popupMode::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KActionMenu_methods[] = {
    {"addAction", reinterpret_cast<PyCFunction>(Sbk_KActionMenuFunc_addAction), METH_O, nullptr},
    {"addSeparator", reinterpret_cast<PyCFunction>(Sbk_KActionMenuFunc_addSeparator), METH_NOARGS, nullptr},
    {"createWidget", reinterpret_cast<PyCFunction>(Sbk_KActionMenuFunc_createWidget), METH_O, nullptr},
    {"insertAction", reinterpret_cast<PyCFunction>(Sbk_KActionMenuFunc_insertAction), METH_VARARGS, nullptr},
    {"insertSeparator", reinterpret_cast<PyCFunction>(Sbk_KActionMenuFunc_insertSeparator), METH_O, nullptr},
    {"popupMode", reinterpret_cast<PyCFunction>(Sbk_KActionMenuFunc_popupMode), METH_NOARGS, nullptr},
    {"removeAction", reinterpret_cast<PyCFunction>(Sbk_KActionMenuFunc_removeAction), METH_O, nullptr},
    {"setPopupMode", reinterpret_cast<PyCFunction>(Sbk_KActionMenuFunc_setPopupMode), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KActionMenu_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KActionMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KActionMenuWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KActionMenu_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KActionMenu_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KActionMenu_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KActionMenu_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KActionMenu_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KActionMenu_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KActionMenu_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KActionMenu_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KActionMenu_spec = {
    "1:KWidgetsAddons.KActionMenu",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KActionMenu_slots
};

} //extern "C"

static void *Sbk_KActionMenu_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KActionMenu *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KActionMenu_PythonToCpp_KActionMenu_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KActionMenu_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KActionMenu_PythonToCpp_KActionMenu_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KActionMenu_TypeF()))
        return KActionMenu_PythonToCpp_KActionMenu_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KActionMenu_PTR_CppToPython_KActionMenu(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KActionMenu *>(const_cast<void *>(cppIn)), Sbk_KActionMenu_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KActionMenu_SignatureStrings[] = {
    "2:KWidgetsAddons.KActionMenu(self,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,popupMode:PySide6.QtWidgets.QToolButton.ToolButtonPopupMode=None)",
    "1:KWidgetsAddons.KActionMenu(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],text:QString,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,popupMode:PySide6.QtWidgets.QToolButton.ToolButtonPopupMode=None)",
    "0:KWidgetsAddons.KActionMenu(self,text:QString,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,popupMode:PySide6.QtWidgets.QToolButton.ToolButtonPopupMode=None)",
    "KWidgetsAddons.KActionMenu.addAction(self,action:PySide6.QtGui.QAction)",
    "KWidgetsAddons.KActionMenu.addSeparator(self)->PySide6.QtGui.QAction",
    "KWidgetsAddons.KActionMenu.createWidget(self,parent:PySide6.QtWidgets.QWidget)->PySide6.QtWidgets.QWidget",
    "KWidgetsAddons.KActionMenu.insertAction(self,before:PySide6.QtGui.QAction,action:PySide6.QtGui.QAction)",
    "KWidgetsAddons.KActionMenu.insertSeparator(self,before:PySide6.QtGui.QAction)->PySide6.QtGui.QAction",
    "KWidgetsAddons.KActionMenu.popupMode(self)->PySide6.QtWidgets.QToolButton.ToolButtonPopupMode",
    "KWidgetsAddons.KActionMenu.removeAction(self,action:PySide6.QtGui.QAction)",
    "KWidgetsAddons.KActionMenu.setPopupMode(self,popupMode:PySide6.QtWidgets.QToolButton.ToolButtonPopupMode)",
    nullptr}; // Sentinel
#else
static constexpr size_t KActionMenu_SignatureByteSize = 290;
static constexpr uint8_t KActionMenu_SignatureBytes[290] = {
    0x78, 0xda, 0xc5, 0x52, 0x3d, 0x4f, 0xc3, 0x30, 0x10, 0xdd, 0xfb, 0x2b, 0x18, 0x09, 0x0a, 0x16,
    0x30, 0x30, 0x58, 0x02, 0xa9, 0x30, 0x20, 0x14, 0x95, 0x26, 0x0a, 0x88, 0x01, 0x31, 0xb8, 0xf1,
    0xb5, 0x32, 0x4a, 0xef, 0x2c, 0xe7, 0x02, 0xcd, 0xbf, 0x27, 0xaa, 0xa1, 0x6d, 0x42, 0x9b, 0xa0,
    0x82, 0xd4, 0xed, 0xec, 0xf3, 0xbd, 0x8f, 0xf3, 0xbb, 0x90, 0xd1, 0xb3, 0xd1, 0x33, 0xe0, 0x62,
    0xa8, 0x35, 0x61, 0x21, 0xa2, 0x61, 0xc6, 0x86, 0x70, 0x04, 0x58, 0x1e, 0x17, 0x90, 0x4f, 0x43,
    0xab, 0x1c, 0x20, 0xcb, 0xb8, 0x4a, 0x8d, 0x86, 0x4b, 0x91, 0xf0, 0x2d, 0x39, 0x10, 0xc9, 0x78,
    0xf2, 0x06, 0x19, 0x87, 0x27, 0x32, 0x82, 0xea, 0x83, 0x9c, 0x1e, 0x63, 0x5e, 0x5d, 0x3d, 0x10,
    0x42, 0x68, 0xc9, 0x96, 0x76, 0x44, 0x1a, 0x36, 0x66, 0xbe, 0x38, 0x44, 0xf2, 0x48, 0x94, 0xdf,
    0x94, 0xcc, 0x84, 0x62, 0x5d, 0xc6, 0xdf, 0x13, 0x4b, 0x80, 0x60, 0x70, 0xde, 0x2b, 0xca, 0x64,
    0x84, 0x92, 0x2b, 0x6b, 0x70, 0x26, 0x9e, 0xb0, 0x6e, 0xbd, 0xac, 0xb9, 0xee, 0x4a, 0x23, 0x92,
    0xfb, 0xfa, 0x41, 0x78, 0xd4, 0xba, 0x8c, 0xcd, 0x62, 0xae, 0xec, 0x6b, 0xc8, 0xb0, 0x60, 0x99,
    0xa4, 0xec, 0xea, 0xf1, 0x43, 0xf8, 0x3b, 0xeb, 0xf5, 0x77, 0x68, 0x85, 0xbb, 0xf5, 0x09, 0xa5,
    0xb5, 0x3f, 0x79, 0xa5, 0x6a, 0x59, 0xcb, 0xd6, 0xa6, 0xfd, 0x8b, 0x3e, 0x9c, 0x14, 0x6a, 0x6b,
    0x8a, 0xc9, 0x2d, 0xa1, 0x82, 0xd3, 0xeb, 0xad, 0x28, 0x5d, 0x20, 0x99, 0x03, 0xc5, 0xe0, 0xfb,
    0x3b, 0xe2, 0xba, 0x32, 0xee, 0x8b, 0x06, 0x4b, 0xab, 0xd7, 0xc5, 0x64, 0xb0, 0x00, 0xc7, 0x9b,
    0xce, 0x27, 0x30, 0xad, 0xff, 0x61, 0xbb, 0xf3, 0xfd, 0xd7, 0xe2, 0x79, 0x9a, 0x9b, 0xe9, 0xa4,
    0xda, 0x67, 0x6d, 0xab, 0x80, 0xfc, 0x5c, 0xfc, 0x2f, 0x73, 0xd2, 0x85, 0xee, 0x60, 0x4e, 0xef,
    0xf0, 0x2f, 0x21, 0x29, 0x80, 0xe3, 0x86, 0xd6, 0xbf, 0x64, 0x3b, 0x18, 0x7c, 0x02, 0xbf, 0xeb,
    0xce, 0x4e
};
#endif

PyTypeObject *init_KActionMenu(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX].type;

    Shiboken::AutoDecRef Sbk_KActionMenu_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidgetAction_IDX]))));

    _Sbk_KActionMenu_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KActionMenu",
        "KActionMenu*",
        &Sbk_KActionMenu_spec,
        &Shiboken::callCppDestructor< KActionMenu >,
        Sbk_KActionMenu_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KActionMenu_Type; // references _Sbk_KActionMenu_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KActionMenu_SignatureStrings);
#else
    InitSignatureBytes(pyType, KActionMenu_SignatureBytes, KActionMenu_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KActionMenu_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KActionMenu_PythonToCpp_KActionMenu_PTR,
        is_KActionMenu_PythonToCpp_KActionMenu_PTR_Convertible,
        KActionMenu_PTR_CppToPython_KActionMenu);

    Shiboken::Conversions::registerConverterName(converter, "KActionMenu");
    Shiboken::Conversions::registerConverterName(converter, "KActionMenu*");
    Shiboken::Conversions::registerConverterName(converter, "KActionMenu&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KActionMenu).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KActionMenuWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KActionMenu_TypeF(), &Sbk_KActionMenu_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KActionMenu::staticMetaObject, sizeof(KActionMenuWrapper));

    return pyType;
}
