
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kgradientselector_wrapper.h"

// Wrappers providing overrides
#include "kselector_wrapper.h"
#include "kxyselector_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <qabstractslider.h>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>
#include <utility>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KGradientSelector_Type = nullptr;
static PyTypeObject *Sbk_KGradientSelector_TypeF(void)
{
    return _Sbk_KGradientSelector_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KGradientSelectorWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KGradientSelectorWrapper::KGradientSelectorWrapper(::QWidget * parent) : KGradientSelector(parent)
{
}

KGradientSelectorWrapper::KGradientSelectorWrapper(::Qt::Orientation o, ::QWidget * parent) : KGradientSelector(o, parent)
{
}

void KGradientSelectorWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::changeEvent(::QEvent * e)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractSlider::changeEvent(e);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KGradientSelector", funcName, gil, pyOverride, e);
}

void KGradientSelectorWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KGradientSelector", funcName, gil, pyOverride, signal);
}

void KGradientSelectorWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

int KGradientSelectorWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KGradientSelector", funcName, gil, pyOverride);
}

void KGradientSelectorWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KGradientSelector", funcName, gil, pyOverride, signal);
}

void KGradientSelectorWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::drawArrow(::QPainter * painter, const ::QPoint & pos)
{
    static const char *funcName = "drawArrow";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelector::drawArrow(painter, pos);
    }
    KSelectorWrapper::sbk_o_drawArrow("KGradientSelector", funcName, gil, pyOverride, painter, pos);
}

void KGradientSelectorWrapper::drawContents(::QPainter * arg__1)
{
    static const char *funcName = "drawContents";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::KGradientSelector::drawContents(arg__1);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KGradientSelector", funcName, gil, pyOverride, arg__1);
}

void KGradientSelectorWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

bool KGradientSelectorWrapper::event(::QEvent * e)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractSlider::event(e);
    }
    return KXYSelectorWrapper::sbk_o_event("KGradientSelector", funcName, gil, pyOverride, e);
}

bool KGradientSelectorWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KGradientSelector", funcName, gil, pyOverride, watched, event);
}

void KGradientSelectorWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

bool KGradientSelectorWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KGradientSelector", funcName, gil, pyOverride, next);
}

void KGradientSelectorWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

bool KGradientSelectorWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KGradientSelector", funcName, gil, pyOverride);
}

int KGradientSelectorWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KGradientSelector", funcName, gil, pyOverride, arg__1);
}

void KGradientSelectorWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KGradientSelector", funcName, gil, pyOverride, painter);
}

void KGradientSelectorWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

::QVariant KGradientSelectorWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KGradientSelector", funcName, gil, pyOverride, arg__1);
}

void KGradientSelectorWrapper::keyPressEvent(::QKeyEvent * ev)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractSlider::keyPressEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KGradientSelector", funcName, gil, pyOverride, ev);
}

void KGradientSelectorWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

int KGradientSelectorWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KGradientSelector", funcName, gil, pyOverride, arg__1);
}

::QSize KGradientSelectorWrapper::minimumSize() const
{
    static const char *funcName = "minimumSize";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::KGradientSelector::minimumSize();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KGradientSelector", funcName, gil, pyOverride);
}

::QSize KGradientSelectorWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KGradientSelector", funcName, gil, pyOverride);
}

void KGradientSelectorWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::mouseMoveEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelector::mouseMoveEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KGradientSelector", funcName, gil, pyOverride, e);
}

void KGradientSelectorWrapper::mousePressEvent(::QMouseEvent * e)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelector::mousePressEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KGradientSelector", funcName, gil, pyOverride, e);
}

void KGradientSelectorWrapper::mouseReleaseEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelector::mouseReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KGradientSelector", funcName, gil, pyOverride, e);
}

void KGradientSelectorWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

bool KGradientSelectorWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KGradientSelector", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KGradientSelectorWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KGradientSelector", funcName, gil, pyOverride);
}

void KGradientSelectorWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelector::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KGradientSelector", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KGradientSelectorWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KGradientSelector", funcName, gil, pyOverride, offset);
}

void KGradientSelectorWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KGradientSelector", funcName, gil, pyOverride, visible);
}

::QPainter * KGradientSelectorWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KGradientSelector", funcName, gil, pyOverride);
}

void KGradientSelectorWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

::QSize KGradientSelectorWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KGradientSelector", funcName, gil, pyOverride);
}

void KGradientSelectorWrapper::sliderChange(::QAbstractSlider::SliderChange change)
{
    static const char *funcName = "sliderChange";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractSlider::sliderChange(change);
    }
    KSelectorWrapper::sbk_o_sliderChange("KGradientSelector", funcName, gil, pyOverride, change);
}

void KGradientSelectorWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KGradientSelector", funcName, gil, pyOverride, event);
}

void KGradientSelectorWrapper::timerEvent(::QTimerEvent * arg__1)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractSlider::timerEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KGradientSelector", funcName, gil, pyOverride, arg__1);
}

void KGradientSelectorWrapper::wheelEvent(::QWheelEvent * arg__1)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KGradientSelector_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelector::wheelEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KGradientSelector", funcName, gil, pyOverride, arg__1);
}

const QMetaObject *KGradientSelectorWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KGradientSelector::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KGradientSelectorWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KGradientSelector::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KGradientSelectorWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KGradientSelectorWrapper *>(this));
    }
    return KGradientSelector::qt_metacast(_clname);
}

KGradientSelectorWrapper::~KGradientSelectorWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KGradientSelector_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KGradientSelector_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KGradientSelector >()))
        return -1;

    KGradientSelectorWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KGradientSelector", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KGradientSelector::KGradientSelector(QWidget*=)
    // 1: KGradientSelector::KGradientSelector(Qt::Orientation,QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KGradientSelector(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Orientation_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KGradientSelector(Qt::Orientation,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 1; // KGradientSelector(Qt::Orientation,QWidget*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KGradientSelector(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KGradientSelector(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KGradientSelector(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KGradientSelectorWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KGradientSelectorWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KGradientSelector(Qt::Orientation o, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);
                }
            }
            ::Qt::Orientation cppArg0 = static_cast< ::Qt::Orientation>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KGradientSelector(Qt::Orientation,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KGradientSelectorWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KGradientSelectorWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KGradientSelector >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KGradientSelectorFunc_drawContents(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelector::drawContents(QPainter*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_IDX]), (pyArg)))) {
        overloadId = 0; // drawContents(QPainter*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "drawContents", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // drawContents(QPainter*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KGradientSelector::drawContents(cppArg0)
                : cppSelf->drawContents(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGradientSelectorFunc_firstColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // firstColor()const
        QColor cppResult = const_cast<const ::KGradientSelector *>(cppSelf)->firstColor();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGradientSelectorFunc_firstText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // firstText()const
        QString cppResult = const_cast<const ::KGradientSelector *>(cppSelf)->firstText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGradientSelectorFunc_minimumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumSize()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KGradientSelector *>(cppSelf)->::KGradientSelector::minimumSize()
            : const_cast<const ::KGradientSelector *>(cppSelf)->minimumSize();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGradientSelectorFunc_secondColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // secondColor()const
        QColor cppResult = const_cast<const ::KGradientSelector *>(cppSelf)->secondColor();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGradientSelectorFunc_secondText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // secondText()const
        QString cppResult = const_cast<const ::KGradientSelector *>(cppSelf)->secondText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGradientSelectorFunc_setColors(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setColors", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KGradientSelector::setColors(QColor,QColor)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setColors(QColor,QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setColors", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QColor cppArg1_local;
        ::QColor *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setColors(QColor,QColor)
            cppSelf->setColors(*cppArg0, *cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGradientSelectorFunc_setFirstColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KGradientSelector::setFirstColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // setFirstColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFirstColor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setFirstColor(QColor)
            cppSelf->setFirstColor(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGradientSelectorFunc_setFirstText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KGradientSelector::setFirstText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setFirstText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFirstText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFirstText(QString)
            cppSelf->setFirstText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGradientSelectorFunc_setSecondColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KGradientSelector::setSecondColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // setSecondColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSecondColor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setSecondColor(QColor)
            cppSelf->setSecondColor(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGradientSelectorFunc_setSecondText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KGradientSelector::setSecondText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setSecondText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSecondText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSecondText(QString)
            cppSelf->setSecondText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGradientSelectorFunc_setStops(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KGradientSelector::setStops(QList<std::pair<qreal,QColor>>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_std_pair_qreal_QColor_IDX], (pyArg)))) {
        overloadId = 0; // setStops(QList<std::pair<qreal,QColor>>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setStops", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);

    // Call function/method
    {
        ::QList<std::pair<qreal,QColor>> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStops(QList<std::pair<qreal,QColor>>)
            cppSelf->setStops(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGradientSelectorFunc_setText(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setText", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KGradientSelector::setText(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setText(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setText(QString,QString)
            cppSelf->setText(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGradientSelectorFunc_stops(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stops()const
        QList<std::pair<qreal,QColor>> cppResult = const_cast<const ::KGradientSelector *>(cppSelf)->stops();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_std_pair_qreal_QColor_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KGradientSelector_PropertyStrings[] = {
    "firstColor::",
    "firstText::",
    "secondColor::",
    "secondText::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KGradientSelector_methods[] = {
    {"drawContents", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_drawContents), METH_O, nullptr},
    {"firstColor", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_firstColor), METH_NOARGS, nullptr},
    {"firstText", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_firstText), METH_NOARGS, nullptr},
    {"minimumSize", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_minimumSize), METH_NOARGS, nullptr},
    {"secondColor", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_secondColor), METH_NOARGS, nullptr},
    {"secondText", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_secondText), METH_NOARGS, nullptr},
    {"setColors", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_setColors), METH_VARARGS, nullptr},
    {"setFirstColor", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_setFirstColor), METH_O, nullptr},
    {"setFirstText", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_setFirstText), METH_O, nullptr},
    {"setSecondColor", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_setSecondColor), METH_O, nullptr},
    {"setSecondText", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_setSecondText), METH_O, nullptr},
    {"setStops", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_setStops), METH_O, nullptr},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_setText), METH_VARARGS, nullptr},
    {"stops", reinterpret_cast<PyCFunction>(Sbk_KGradientSelectorFunc_stops), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KGradientSelector_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KGradientSelector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KGradientSelectorWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KGradientSelector_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KGradientSelector_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KGradientSelectorSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KGradientSelector *>(obj);
    if (desiredType == Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelector_IDX]))
        return static_cast< ::KSelector *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractSlider_IDX]))
        return static_cast< ::QAbstractSlider *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KGradientSelector_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KGradientSelector_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KGradientSelector_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KGradientSelector_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KGradientSelector_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KGradientSelector_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KGradientSelector_spec = {
    "1:KWidgetsAddons.KGradientSelector",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KGradientSelector_slots
};

} //extern "C"

static void *Sbk_KGradientSelector_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KGradientSelector *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KGradientSelector *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KGradientSelector *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KGradientSelector_PythonToCpp_KGradientSelector_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KGradientSelector_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KGradientSelector_PythonToCpp_KGradientSelector_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KGradientSelector_TypeF()))
        return KGradientSelector_PythonToCpp_KGradientSelector_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KGradientSelector_PTR_CppToPython_KGradientSelector(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KGradientSelector *>(const_cast<void *>(cppIn)), Sbk_KGradientSelector_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KGradientSelector_SignatureStrings[] = {
    "1:KWidgetsAddons.KGradientSelector(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,firstColor:QColor=None,secondColor:QColor=None,firstText:QString=None,secondText:QString=None)",
    "0:KWidgetsAddons.KGradientSelector(self,o:PySide6.QtCore.Qt.Orientation,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,firstColor:QColor=None,secondColor:QColor=None,firstText:QString=None,secondText:QString=None)",
    "KWidgetsAddons.KGradientSelector.drawContents(self,arg__1:PySide6.QtGui.QPainter)",
    "KWidgetsAddons.KGradientSelector.firstColor(self)->PySide6.QtGui.QColor",
    "KWidgetsAddons.KGradientSelector.firstText(self)->QString",
    "KWidgetsAddons.KGradientSelector.minimumSize(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KGradientSelector.secondColor(self)->PySide6.QtGui.QColor",
    "KWidgetsAddons.KGradientSelector.secondText(self)->QString",
    "KWidgetsAddons.KGradientSelector.setColors(self,col1:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],col2:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "KWidgetsAddons.KGradientSelector.setFirstColor(self,col:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "KWidgetsAddons.KGradientSelector.setFirstText(self,t:QString)",
    "KWidgetsAddons.KGradientSelector.setSecondColor(self,col:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "KWidgetsAddons.KGradientSelector.setSecondText(self,t:QString)",
    "KWidgetsAddons.KGradientSelector.setStops(self,stops:QList[std.pair[qreal, PySide6.QtGui.QColor]])",
    "KWidgetsAddons.KGradientSelector.setText(self,t1:QString,t2:QString)",
    "KWidgetsAddons.KGradientSelector.stops(self)->QList[std.pair[qreal, PySide6.QtGui.QColor]]",
    nullptr}; // Sentinel
#else
static constexpr size_t KGradientSelector_SignatureByteSize = 397;
static constexpr uint8_t KGradientSelector_SignatureBytes[397] = {
    0x78, 0xda, 0xd5, 0x54, 0x5d, 0x6b, 0xc2, 0x30, 0x14, 0x7d, 0xf7, 0x57, 0xf8, 0x38, 0x47, 0x17,
    0x56, 0x19, 0x3e, 0x14, 0x1c, 0x0c, 0x61, 0x3e, 0x28, 0xd3, 0xae, 0xfb, 0x78, 0x10, 0x91, 0x68,
    0x62, 0x09, 0xc4, 0xa4, 0xbb, 0xb9, 0xc5, 0x75, 0xbf, 0x7e, 0xe9, 0x97, 0x56, 0x1d, 0xd8, 0xb2,
    0x17, 0x7d, 0x4a, 0xb8, 0x39, 0xf7, 0xf4, 0x9c, 0xfb, 0x51, 0xd7, 0x1b, 0x7d, 0x0a, 0x16, 0x72,
    0x34, 0x4f, 0x8c, 0x69, 0x65, 0xc8, 0x68, 0x08, 0x94, 0x09, 0xae, 0x30, 0xe0, 0x92, 0xaf, 0x50,
    0xc3, 0x8d, 0xe1, 0x72, 0xed, 0x44, 0x14, 0x6c, 0xcc, 0x9b, 0x26, 0x81, 0x60, 0xbc, 0x47, 0x7c,
    0x2c, 0xb2, 0x88, 0x9f, 0x5f, 0xfa, 0x2a, 0x96, 0x32, 0x42, 0x70, 0x6e, 0xbd, 0x11, 0x4f, 0xb6,
    0x1a, 0xd8, 0x44, 0xc9, 0xa4, 0xff, 0xa2, 0x15, 0x77, 0xd6, 0x02, 0x0c, 0x0e, 0xb4, 0xd4, 0xe0,
    0xf9, 0xd9, 0x91, 0x87, 0x0d, 0x5f, 0x69, 0xc5, 0x4e, 0xe3, 0x19, 0xfc, 0x8d, 0x7f, 0xa3, 0xe7,
    0x07, 0x08, 0x42, 0x85, 0x55, 0xf8, 0x49, 0xbc, 0xd3, 0xba, 0xaf, 0x69, 0x41, 0x57, 0xd4, 0x0f,
    0x34, 0x70, 0x7b, 0x90, 0x09, 0xa4, 0x38, 0x8a, 0x42, 0xab, 0x4b, 0xb6, 0x78, 0xce, 0x20, 0x61,
    0x40, 0xb7, 0x03, 0xad, 0xd0, 0xc6, 0x4c, 0xee, 0x96, 0x42, 0xb8, 0x58, 0xb8, 0x15, 0x37, 0xc3,
    0x58, 0x10, 0x7f, 0x4a, 0x85, 0x05, 0x41, 0x0d, 0xc6, 0xbd, 0xa3, 0x8c, 0xaf, 0x73, 0xf7, 0x78,
    0x44, 0x95, 0xbd, 0xd5, 0xe4, 0x49, 0x2d, 0x95, 0x34, 0x85, 0xb3, 0xf3, 0x99, 0x1b, 0xa1, 0xc4,
    0x26, 0xde, 0x04, 0xe2, 0x87, 0x9f, 0x4a, 0xc8, 0x1b, 0x98, 0xbe, 0x9d, 0x27, 0xaa, 0x74, 0xe1,
    0x7f, 0x5e, 0xf6, 0xfd, 0x69, 0x6c, 0xc6, 0xf0, 0xbc, 0x98, 0x45, 0x77, 0x56, 0x5a, 0xba, 0x1e,
    0x26, 0x91, 0xcd, 0x25, 0xef, 0xca, 0x4e, 0xdf, 0xec, 0x2f, 0x45, 0x4e, 0xdb, 0x1f, 0xdb, 0xd9,
    0x54, 0x6e, 0xfe, 0x15, 0xa7, 0x7d, 0x04, 0x7a, 0x0d, 0x97, 0xb4, 0xf7, 0x60, 0x51, 0x1f, 0x14,
    0x04, 0x55, 0x58, 0x05, 0x94, 0x13, 0x3e, 0x94, 0x7a, 0x49, 0x65, 0x49, 0x57, 0x12, 0xc5, 0xca,
    0x88, 0x50, 0x71, 0xd6, 0xb6, 0xe3, 0x30, 0x4f, 0xd5, 0x74, 0x2f, 0x46, 0x4d, 0xa7, 0x56, 0x31,
    0x9f, 0x0f, 0xc7, 0x33, 0xb5, 0x70, 0x8d, 0x0e, 0x76, 0xb3, 0xe4, 0xec, 0x56, 0xbe, 0x5e, 0x76,
    0x70, 0x34, 0xd3, 0x57, 0x58, 0x80, 0xe0, 0x70, 0x9b, 0x1a, 0x57, 0x00, 0x75, 0x54, 0x6c, 0x93,
    0x49, 0xaf, 0x9e, 0x3f, 0x16, 0x06, 0x67, 0x06, 0x19, 0x89, 0xa8, 0x80, 0xd9, 0x17, 0x70, 0x2a,
    0x4f, 0x1c, 0x66, 0xba, 0xe7, 0x35, 0x15, 0x56, 0xb4, 0xb9, 0xa5, 0x38, 0x07, 0xbb, 0x4d, 0x74,
    0xee, 0x44, 0xa6, 0x3f, 0x8b, 0x06, 0x02, 0x5b, 0xbf, 0xd8, 0x8b, 0xc3, 0x50
};
#endif

PyTypeObject *init_KGradientSelector(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX].type;

    Shiboken::AutoDecRef Sbk_KGradientSelector_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelector_IDX]))));

    _Sbk_KGradientSelector_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KGradientSelector",
        "KGradientSelector*",
        &Sbk_KGradientSelector_spec,
        &Shiboken::callCppDestructor< KGradientSelector >,
        Sbk_KGradientSelector_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KGradientSelector_Type; // references _Sbk_KGradientSelector_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KGradientSelector_SignatureStrings);
#else
    InitSignatureBytes(pyType, KGradientSelector_SignatureBytes, KGradientSelector_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KGradientSelector_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KGradientSelector_PythonToCpp_KGradientSelector_PTR,
        is_KGradientSelector_PythonToCpp_KGradientSelector_PTR_Convertible,
        KGradientSelector_PTR_CppToPython_KGradientSelector);

    Shiboken::Conversions::registerConverterName(converter, "KGradientSelector");
    Shiboken::Conversions::registerConverterName(converter, "KGradientSelector*");
    Shiboken::Conversions::registerConverterName(converter, "KGradientSelector&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KGradientSelector).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KGradientSelectorWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KGradientSelector_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KGradientSelector_TypeF(), &Sbk_KGradientSelectorSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KGradientSelector_TypeF(), &Sbk_KGradientSelector_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KGradientSelector::staticMetaObject, sizeof(KGradientSelectorWrapper));

    return pyType;
}
