#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x007a\x0068";
static constexpr OUStringLiteral langDefaultName = u"\x0053\x0069\x006d\x0070\x006c\x0069\x0066\x0069\x0065\x0064\x0020\x0043\x0068\x0069\x006e\x0065\x0073\x0065";
static constexpr OUStringLiteral countryID = u"\x0043\x004e";
static constexpr OUStringLiteral countryDefaultName = u"\x0043\x0068\x0069\x006e\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_zh_CN(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}


static constexpr OUStringLiteral LC_CTYPE_Unoid = u"\x0067\x0065\x006e\x0065\x0072\x0069\x0063";
static constexpr OUStringLiteral dateSeparator = u"\x002f";
static constexpr OUStringLiteral thousandSeparator = u"\x002c";
static constexpr OUStringLiteral decimalSeparator = u"\x002e";
static constexpr OUStringLiteral decimalSeparatorAlternative = u"";
static constexpr OUStringLiteral timeSeparator = u"\x003a";
static constexpr OUStringLiteral time100SecSeparator = u"\x002e";
static constexpr OUStringLiteral listSeparator = u"\x003b";
static constexpr OUStringLiteral LongDateDayOfWeekSeparator = u"";
static constexpr OUStringLiteral LongDateDaySeparator = u"\x65e5";
static constexpr OUStringLiteral LongDateMonthSeparator = u"\x6708";
static constexpr OUStringLiteral LongDateYearSeparator = u"\x5e74";
static constexpr OUStringLiteral quotationStart = u"\x2018";
static constexpr OUStringLiteral quotationEnd = u"\x2019";
static constexpr OUStringLiteral doubleQuotationStart = u"\x201c";
static constexpr OUStringLiteral doubleQuotationEnd = u"\x201d";
static constexpr OUStringLiteral timeAM = u"\x4e0a\x5348";
static constexpr OUStringLiteral timePM = u"\x4e0b\x5348";
static constexpr OUStringLiteral measurementSystem = u"\x006d\x0065\x0074\x0072\x0069\x0063";

static constexpr OUString LCType[] = {
	LC_CTYPE_Unoid,
	dateSeparator,
	thousandSeparator,
	decimalSeparator,
	timeSeparator,
	time100SecSeparator,
	listSeparator,
	quotationStart,
	quotationEnd,
	doubleQuotationStart,
	doubleQuotationEnd,
	timeAM,
	timePM,
	measurementSystem,
	LongDateDayOfWeekSeparator,
	LongDateDaySeparator,
	LongDateMonthSeparator,
	LongDateYearSeparator,
	decimalSeparatorAlternative
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLocaleItem_zh_CN(sal_Int16& count)
{
	count = std::size(LCType);
	return (OUString const *)LCType;
}
static const sal_Unicode replaceFrom0[] = {0x0};
static const sal_Unicode replaceTo0[] = {0x0};
static constexpr OUStringLiteral FormatKey0 = u"\x004e\x0075\x006d\x0062\x0065\x0072\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement0 = u"\x1";
static constexpr OUStringLiteral FormatType0 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage0 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex0 = u"\x0";
static constexpr OUStringLiteral FormatCode0 = u"\x5e38\x89c4";
static constexpr OUStringLiteral FormatDefaultName0 = u"";
static constexpr OUStringLiteral FormatKey1 = u"\x004e\x0075\x006d\x0062\x0065\x0072\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement1 = u"\x0";
static constexpr OUStringLiteral FormatType1 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage1 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex1 = u"\x1";
static constexpr OUStringLiteral FormatCode1 = u"\x0030";
static constexpr OUStringLiteral FormatDefaultName1 = u"";
static constexpr OUStringLiteral FormatKey2 = u"\x004e\x0075\x006d\x0062\x0065\x0072\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement2 = u"\x0";
static constexpr OUStringLiteral FormatType2 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage2 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex2 = u"\x2";
static constexpr OUStringLiteral FormatCode2 = u"\x0030\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName2 = u"";
static constexpr OUStringLiteral FormatKey3 = u"\x004e\x0075\x006d\x0062\x0065\x0072\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0034";
static constexpr OUStringLiteral defaultFormatElement3 = u"\x1";
static constexpr OUStringLiteral FormatType3 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage3 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex3 = u"\x3";
static constexpr OUStringLiteral FormatCode3 = u"\x0023\x002c\x0023\x0023\x0030";
static constexpr OUStringLiteral FormatDefaultName3 = u"";
static constexpr OUStringLiteral FormatKey4 = u"\x004e\x0075\x006d\x0062\x0065\x0072\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0035";
static constexpr OUStringLiteral defaultFormatElement4 = u"\x0";
static constexpr OUStringLiteral FormatType4 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage4 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex4 = u"\x4";
static constexpr OUStringLiteral FormatCode4 = u"\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName4 = u"";
static constexpr OUStringLiteral FormatKey5 = u"\x004e\x0075\x006d\x0062\x0065\x0072\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0036";
static constexpr OUStringLiteral defaultFormatElement5 = u"\x0";
static constexpr OUStringLiteral FormatType5 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage5 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex5 = u"\x5";
static constexpr OUStringLiteral FormatCode5 = u"\x0023\x002c\x0023\x0023\x0023\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName5 = u"";
static constexpr OUStringLiteral FormatKey6 = u"\x0053\x0063\x0069\x0065\x006e\x0074\x0069\x0066\x0069\x0063\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement6 = u"\x0";
static constexpr OUStringLiteral FormatType6 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage6 = u"\x0053\x0043\x0049\x0045\x004e\x0054\x0049\x0046\x0049\x0043\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex6 = u"\x6";
static constexpr OUStringLiteral FormatCode6 = u"\x0030\x002e\x0030\x0030\x0045\x002b\x0030\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName6 = u"";
static constexpr OUStringLiteral FormatKey7 = u"\x0053\x0063\x0069\x0065\x006e\x0074\x0069\x0066\x0069\x0063\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement7 = u"\x1";
static constexpr OUStringLiteral FormatType7 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage7 = u"\x0053\x0043\x0049\x0045\x004e\x0054\x0049\x0046\x0049\x0043\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex7 = u"\x7";
static constexpr OUStringLiteral FormatCode7 = u"\x0030\x002e\x0030\x0030\x0045\x002b\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName7 = u"";
static constexpr OUStringLiteral FormatKey8 = u"\x0053\x0063\x0069\x0065\x006e\x0074\x0069\x0066\x0069\x0063\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement8 = u"\x0";
static constexpr OUStringLiteral FormatType8 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage8 = u"\x0053\x0043\x0049\x0045\x004e\x0054\x0049\x0046\x0049\x0043\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex8 = u"\x4e";
static constexpr OUStringLiteral FormatCode8 = u"\x0023\x0023\x0030\x002e\x0030\x0030\x0045\x002b\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName8 = u"";
static constexpr OUStringLiteral FormatKey9 = u"\x0050\x0065\x0072\x0063\x0065\x006e\x0074\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement9 = u"\x1";
static constexpr OUStringLiteral FormatType9 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage9 = u"\x0050\x0045\x0052\x0043\x0045\x004e\x0054\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex9 = u"\x8";
static constexpr OUStringLiteral FormatCode9 = u"\x0030\x0025";
static constexpr OUStringLiteral FormatDefaultName9 = u"";
static constexpr OUStringLiteral FormatKey10 = u"\x0050\x0065\x0072\x0063\x0065\x006e\x0074\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement10 = u"\x1";
static constexpr OUStringLiteral FormatType10 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage10 = u"\x0050\x0045\x0052\x0043\x0045\x004e\x0054\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex10 = u"\x9";
static constexpr OUStringLiteral FormatCode10 = u"\x0030\x002e\x0030\x0030\x0025";
static constexpr OUStringLiteral FormatDefaultName10 = u"";
static constexpr OUStringLiteral FormatKey11 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement11 = u"\x1";
static constexpr OUStringLiteral FormatType11 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage11 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex11 = u"\xc";
static constexpr OUStringLiteral FormatCode11 = u"\x005b\x0024\xffe5\x002d\x0038\x0030\x0034\x005d\x0023\x002c\x0023\x0023\x0030\x003b\x002d\x005b\x0024\xffe5\x002d\x0038\x0030\x0034\x005d\x0023\x002c\x0023\x0023\x0030";
static constexpr OUStringLiteral FormatDefaultName11 = u"";
static constexpr OUStringLiteral FormatKey12 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement12 = u"\x0";
static constexpr OUStringLiteral FormatType12 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage12 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex12 = u"\xd";
static constexpr OUStringLiteral FormatCode12 = u"\x005b\x0024\xffe5\x002d\x0038\x0030\x0034\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030\x003b\x002d\x005b\x0024\xffe5\x002d\x0038\x0030\x0034\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName12 = u"";
static constexpr OUStringLiteral FormatKey13 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement13 = u"\x0";
static constexpr OUStringLiteral FormatType13 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage13 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex13 = u"\xe";
static constexpr OUStringLiteral FormatCode13 = u"\x005b\x0024\xffe5\x002d\x0038\x0030\x0034\x005d\x0023\x002c\x0023\x0023\x0030\x003b\x005b\x0052\x0045\x0044\x005d\x002d\x005b\x0024\xffe5\x002d\x0038\x0030\x0034\x005d\x0023\x002c\x0023\x0023\x0030";
static constexpr OUStringLiteral FormatDefaultName13 = u"";
static constexpr OUStringLiteral FormatKey14 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0034";
static constexpr OUStringLiteral defaultFormatElement14 = u"\x1";
static constexpr OUStringLiteral FormatType14 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage14 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex14 = u"\xf";
static constexpr OUStringLiteral FormatCode14 = u"\x005b\x0024\xffe5\x002d\x0038\x0030\x0034\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030\x003b\x005b\x0052\x0045\x0044\x005d\x002d\x005b\x0024\xffe5\x002d\x0038\x0030\x0034\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName14 = u"";
static constexpr OUStringLiteral FormatKey15 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0035";
static constexpr OUStringLiteral defaultFormatElement15 = u"\x0";
static constexpr OUStringLiteral FormatType15 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage15 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex15 = u"\x10";
static constexpr OUStringLiteral FormatCode15 = u"\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030\x0020\x0043\x0043\x0043";
static constexpr OUStringLiteral FormatDefaultName15 = u"";
static constexpr OUStringLiteral FormatKey16 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0036";
static constexpr OUStringLiteral defaultFormatElement16 = u"\x0";
static constexpr OUStringLiteral FormatType16 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage16 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex16 = u"\x11";
static constexpr OUStringLiteral FormatCode16 = u"\x005b\x0024\xffe5\x002d\x0038\x0030\x0034\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x002d\x002d\x003b\x005b\x0052\x0045\x0044\x005d\x002d\x005b\x0024\xffe5\x002d\x0038\x0030\x0034\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x002d\x002d";
static constexpr OUStringLiteral FormatDefaultName16 = u"";
static constexpr OUStringLiteral FormatKey17 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement17 = u"\x1";
static constexpr OUStringLiteral FormatType17 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage17 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex17 = u"\x12";
static constexpr OUStringLiteral FormatCode17 = u"\x0059\x0059\x0022\x5e74\x0022\x004d\x0022\x6708\x0022\x0044\x0022\x65e5\x0022";
static constexpr OUStringLiteral FormatDefaultName17 = u"";
static constexpr OUStringLiteral FormatKey18 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement18 = u"\x1";
static constexpr OUStringLiteral FormatType18 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage18 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex18 = u"\x13";
static constexpr OUStringLiteral FormatCode18 = u"\x0059\x0059\x0059\x0059\x0022\x5e74\x0022\x004d\x0022\x6708\x0022\x0044\x0022\x65e5\x0022\x3000\x004e\x004e\x004e\x004e";
static constexpr OUStringLiteral FormatDefaultName18 = u"";
static constexpr OUStringLiteral FormatKey19 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement19 = u"\x0";
static constexpr OUStringLiteral FormatType19 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage19 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex19 = u"\x14";
static constexpr OUStringLiteral FormatCode19 = u"\x0059\x0059\x002f\x004d\x002f\x0044";
static constexpr OUStringLiteral FormatDefaultName19 = u"";
static constexpr OUStringLiteral FormatKey20 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0034";
static constexpr OUStringLiteral defaultFormatElement20 = u"\x0";
static constexpr OUStringLiteral FormatType20 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage20 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex20 = u"\x15";
static constexpr OUStringLiteral FormatCode20 = u"\x0059\x0059\x0059\x0059\x002f\x004d\x002f\x0044";
static constexpr OUStringLiteral FormatDefaultName20 = u"";
static constexpr OUStringLiteral FormatKey21 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0035";
static constexpr OUStringLiteral defaultFormatElement21 = u"\x0";
static constexpr OUStringLiteral FormatType21 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage21 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex21 = u"\x16";
static constexpr OUStringLiteral FormatCode21 = u"\x0059\x0059\x0059\x0059\x0022\x5e74\x0022\x004d\x0022\x6708\x0022";
static constexpr OUStringLiteral FormatDefaultName21 = u"";
static constexpr OUStringLiteral FormatKey22 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0036";
static constexpr OUStringLiteral defaultFormatElement22 = u"\x0";
static constexpr OUStringLiteral FormatType22 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage22 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex22 = u"\x17";
static constexpr OUStringLiteral FormatCode22 = u"\x0059\x0059\x0059\x0059\x002e\x004d\x004d\x002e\x0044\x0044";
static constexpr OUStringLiteral FormatDefaultName22 = u"";
static constexpr OUStringLiteral FormatKey23 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0037";
static constexpr OUStringLiteral defaultFormatElement23 = u"\x0";
static constexpr OUStringLiteral FormatType23 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage23 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex23 = u"\x18";
static constexpr OUStringLiteral FormatCode23 = u"\x0059\x0059\x002e\x004d\x004d\x002e\x0044\x0044";
static constexpr OUStringLiteral FormatDefaultName23 = u"";
static constexpr OUStringLiteral FormatKey24 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0038";
static constexpr OUStringLiteral defaultFormatElement24 = u"\x0";
static constexpr OUStringLiteral FormatType24 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage24 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex24 = u"\x19";
static constexpr OUStringLiteral FormatCode24 = u"\x0059\x0059\x0059\x0059\x0022\x5e74\x0022\x004d\x0022\x6708\x0022\x0044\x0022\x65e5\x0022";
static constexpr OUStringLiteral FormatDefaultName24 = u"";
static constexpr OUStringLiteral FormatKey25 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0039";
static constexpr OUStringLiteral defaultFormatElement25 = u"\x0";
static constexpr OUStringLiteral FormatType25 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage25 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex25 = u"\x1a";
static constexpr OUStringLiteral FormatCode25 = u"\x0059\x0059\x0059\x0059\x0020\x0022\x5e74\x0022\x004d\x0022\x6708\x0022\x0044\x0022\x65e5\x0022";
static constexpr OUStringLiteral FormatDefaultName25 = u"";
static constexpr OUStringLiteral FormatKey26 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0030";
static constexpr OUStringLiteral defaultFormatElement26 = u"\x0";
static constexpr OUStringLiteral FormatType26 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage26 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex26 = u"\x1b";
static constexpr OUStringLiteral FormatCode26 = u"\x0059\x0059\x0022\x5e74\x0022\x004d\x0022\x6708\x0022\x0044\x0022\x65e5\x0022\x0020\x004e\x004e\x004e\x004e";
static constexpr OUStringLiteral FormatDefaultName26 = u"";
static constexpr OUStringLiteral FormatKey27 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0031";
static constexpr OUStringLiteral defaultFormatElement27 = u"\x0";
static constexpr OUStringLiteral FormatType27 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage27 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex27 = u"\x1c";
static constexpr OUStringLiteral FormatCode27 = u"\x0059\x0059\x002f\x004d\x002f\x0044\x0020\x004e\x004e\x004e\x004e";
static constexpr OUStringLiteral FormatDefaultName27 = u"";
static constexpr OUStringLiteral FormatKey28 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0032";
static constexpr OUStringLiteral defaultFormatElement28 = u"\x0";
static constexpr OUStringLiteral FormatType28 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage28 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex28 = u"\x1d";
static constexpr OUStringLiteral FormatCode28 = u"\x0059\x0059\x0059\x0059\x002f\x004d\x002f\x0044\x0020\x004e\x004e\x004e\x004e";
static constexpr OUStringLiteral FormatDefaultName28 = u"";
static constexpr OUStringLiteral FormatKey29 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0033";
static constexpr OUStringLiteral defaultFormatElement29 = u"\x0";
static constexpr OUStringLiteral FormatType29 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage29 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex29 = u"\x1e";
static constexpr OUStringLiteral FormatCode29 = u"\x0059\x0059\x0059\x0059\x0022\x5e74\x0022\x004d\x0022\x6708\x0022\x0044\x0022\x65e5\x0022\x0020\x004e\x004e\x004e\x004e";
static constexpr OUStringLiteral FormatDefaultName29 = u"";
static constexpr OUStringLiteral FormatKey30 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0034";
static constexpr OUStringLiteral defaultFormatElement30 = u"\x1";
static constexpr OUStringLiteral FormatType30 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage30 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex30 = u"\x1f";
static constexpr OUStringLiteral FormatCode30 = u"\x004d\x0022\x6708\x0022\x0044\x0022\x65e5\x0022";
static constexpr OUStringLiteral FormatDefaultName30 = u"";
static constexpr OUStringLiteral FormatKey31 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0035";
static constexpr OUStringLiteral defaultFormatElement31 = u"\x0";
static constexpr OUStringLiteral FormatType31 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage31 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex31 = u"\x20";
static constexpr OUStringLiteral FormatCode31 = u"\x0059\x0059\x002d\x004d\x004d\x002d\x0044\x0044";
static constexpr OUStringLiteral FormatDefaultName31 = u"";
static constexpr OUStringLiteral FormatKey32 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0036";
static constexpr OUStringLiteral defaultFormatElement32 = u"\x0";
static constexpr OUStringLiteral FormatType32 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage32 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex32 = u"\x21";
static constexpr OUStringLiteral FormatCode32 = u"\x0059\x0059\x0059\x0059\x002d\x004d\x004d\x002d\x0044\x0044";
static constexpr OUStringLiteral FormatDefaultName32 = u"\x0049\x0053\x004f\x0020\x0038\x0036\x0030\x0031";
static constexpr OUStringLiteral FormatKey33 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0037";
static constexpr OUStringLiteral defaultFormatElement33 = u"\x0";
static constexpr OUStringLiteral FormatType33 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage33 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex33 = u"\x22";
static constexpr OUStringLiteral FormatCode33 = u"\x0059\x0059\x0022\x5e74\x0022\x004d\x0022\x6708\x0022";
static constexpr OUStringLiteral FormatDefaultName33 = u"";
static constexpr OUStringLiteral FormatKey34 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0038";
static constexpr OUStringLiteral defaultFormatElement34 = u"\x0";
static constexpr OUStringLiteral FormatType34 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage34 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex34 = u"\x23";
static constexpr OUStringLiteral FormatCode34 = u"\x004d\x0022\x6708\x0022\x0044\x0022\x65e5\x0022";
static constexpr OUStringLiteral FormatDefaultName34 = u"";
static constexpr OUStringLiteral FormatKey35 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0039";
static constexpr OUStringLiteral defaultFormatElement35 = u"\x0";
static constexpr OUStringLiteral FormatType35 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage35 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex35 = u"\x24";
static constexpr OUStringLiteral FormatCode35 = u"\x004d\x004d\x004d\x004d";
static constexpr OUStringLiteral FormatDefaultName35 = u"";
static constexpr OUStringLiteral FormatKey36 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032\x0030";
static constexpr OUStringLiteral defaultFormatElement36 = u"\x0";
static constexpr OUStringLiteral FormatType36 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage36 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex36 = u"\x25";
static constexpr OUStringLiteral FormatCode36 = u"\x0059\x0059\x0059\x0059\x0022\x5e74\x0022\x0051\x0051";
static constexpr OUStringLiteral FormatDefaultName36 = u"";
static constexpr OUStringLiteral FormatKey37 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032\x0031";
static constexpr OUStringLiteral defaultFormatElement37 = u"\x0";
static constexpr OUStringLiteral FormatType37 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage37 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex37 = u"\x26";
static constexpr OUStringLiteral FormatCode37 = u"\x0022\x7b2c\x0022\x0057\x0057\x0022\x5468\x0022";
static constexpr OUStringLiteral FormatDefaultName37 = u"";
static constexpr OUStringLiteral FormatKey38 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement38 = u"\x1";
static constexpr OUStringLiteral FormatType38 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage38 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex38 = u"\x27";
static constexpr OUStringLiteral FormatCode38 = u"\x0048\x0048\x003a\x004d\x004d";
static constexpr OUStringLiteral FormatDefaultName38 = u"";
static constexpr OUStringLiteral FormatKey39 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement39 = u"\x1";
static constexpr OUStringLiteral FormatType39 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage39 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex39 = u"\x28";
static constexpr OUStringLiteral FormatCode39 = u"\x0048\x0048\x003a\x004d\x004d\x003a\x0053\x0053";
static constexpr OUStringLiteral FormatDefaultName39 = u"";
static constexpr OUStringLiteral FormatKey40 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement40 = u"\x0";
static constexpr OUStringLiteral FormatType40 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage40 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex40 = u"\x29";
static constexpr OUStringLiteral FormatCode40 = u"\x0041\x004d\x002f\x0050\x004d\x0020\x0048\x0048\x003a\x004d\x004d";
static constexpr OUStringLiteral FormatDefaultName40 = u"";
static constexpr OUStringLiteral FormatKey41 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0034";
static constexpr OUStringLiteral defaultFormatElement41 = u"\x0";
static constexpr OUStringLiteral FormatType41 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage41 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex41 = u"\x2a";
static constexpr OUStringLiteral FormatCode41 = u"\x0041\x004d\x002f\x0050\x004d\x0020\x0048\x0048\x003a\x004d\x004d\x003a\x0053\x0053";
static constexpr OUStringLiteral FormatDefaultName41 = u"";
static constexpr OUStringLiteral FormatKey42 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0035";
static constexpr OUStringLiteral defaultFormatElement42 = u"\x0";
static constexpr OUStringLiteral FormatType42 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage42 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex42 = u"\x2b";
static constexpr OUStringLiteral FormatCode42 = u"\x005b\x0048\x0048\x005d\x003a\x004d\x004d\x003a\x0053\x0053";
static constexpr OUStringLiteral FormatDefaultName42 = u"";
static constexpr OUStringLiteral FormatKey43 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0036";
static constexpr OUStringLiteral defaultFormatElement43 = u"\x0";
static constexpr OUStringLiteral FormatType43 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage43 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex43 = u"\x2c";
static constexpr OUStringLiteral FormatCode43 = u"\x004d\x004d\x003a\x0053\x0053\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName43 = u"";
static constexpr OUStringLiteral FormatKey44 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0037";
static constexpr OUStringLiteral defaultFormatElement44 = u"\x1";
static constexpr OUStringLiteral FormatType44 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage44 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex44 = u"\x2d";
static constexpr OUStringLiteral FormatCode44 = u"\x005b\x0048\x0048\x005d\x003a\x004d\x004d\x003a\x0053\x0053\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName44 = u"";
static constexpr OUStringLiteral FormatKey45 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0038";
static constexpr OUStringLiteral defaultFormatElement45 = u"\x0";
static constexpr OUStringLiteral FormatType45 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage45 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex45 = u"\x42";
static constexpr OUStringLiteral FormatCode45 = u"\x0048\x0048\x0022\x65f6\x0022\x004d\x004d\x0022\x5206\x0022";
static constexpr OUStringLiteral FormatDefaultName45 = u"";
static constexpr OUStringLiteral FormatKey46 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0039";
static constexpr OUStringLiteral defaultFormatElement46 = u"\x0";
static constexpr OUStringLiteral FormatType46 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage46 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex46 = u"\x43";
static constexpr OUStringLiteral FormatCode46 = u"\x0048\x0048\x0022\x65f6\x0022\x004d\x004d\x0022\x5206\x0022\x0053\x0053\x0022\x79d2\x0022";
static constexpr OUStringLiteral FormatDefaultName46 = u"";
static constexpr OUStringLiteral FormatKey47 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0030";
static constexpr OUStringLiteral defaultFormatElement47 = u"\x0";
static constexpr OUStringLiteral FormatType47 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage47 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex47 = u"\x44";
static constexpr OUStringLiteral FormatCode47 = u"\x0041\x004d\x002f\x0050\x004d\x0020\x0048\x0048\x0022\x65f6\x0022\x004d\x004d\x0022\x5206\x0022";
static constexpr OUStringLiteral FormatDefaultName47 = u"";
static constexpr OUStringLiteral FormatKey48 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0031";
static constexpr OUStringLiteral defaultFormatElement48 = u"\x0";
static constexpr OUStringLiteral FormatType48 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage48 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex48 = u"\x45";
static constexpr OUStringLiteral FormatCode48 = u"\x0041\x004d\x002f\x0050\x004d\x0020\x0048\x0048\x0022\x65f6\x0022\x004d\x004d\x0022\x5206\x0022\x0053\x0053\x0022\x79d2\x0022";
static constexpr OUStringLiteral FormatDefaultName48 = u"";
static constexpr OUStringLiteral FormatKey49 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0032";
static constexpr OUStringLiteral defaultFormatElement49 = u"\x0";
static constexpr OUStringLiteral FormatType49 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage49 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex49 = u"\x46";
static constexpr OUStringLiteral FormatCode49 = u"\x005b\x0048\x0048\x005d\x0022\x65f6\x0022\x004d\x004d\x0022\x5206\x0022\x0053\x0053\x0022\x79d2\x0022";
static constexpr OUStringLiteral FormatDefaultName49 = u"";
static constexpr OUStringLiteral FormatKey50 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0033";
static constexpr OUStringLiteral defaultFormatElement50 = u"\x0";
static constexpr OUStringLiteral FormatType50 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage50 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex50 = u"\x47";
static constexpr OUStringLiteral FormatCode50 = u"\x004d\x004d\x0022\x5206\x0022\x0053\x0053\x0022\x79d2\x0022\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName50 = u"";
static constexpr OUStringLiteral FormatKey51 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0034";
static constexpr OUStringLiteral defaultFormatElement51 = u"\x0";
static constexpr OUStringLiteral FormatType51 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage51 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex51 = u"\x48";
static constexpr OUStringLiteral FormatCode51 = u"\x005b\x0048\x0048\x005d\x0022\x65f6\x0022\x004d\x004d\x0022\x5206\x0022\x0053\x0053\x0022\x79d2\x0022\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName51 = u"";
static constexpr OUStringLiteral FormatKey52 = u"\x0044\x0061\x0074\x0065\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0034";
static constexpr OUStringLiteral defaultFormatElement52 = u"\x0";
static constexpr OUStringLiteral FormatType52 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage52 = u"\x0044\x0041\x0054\x0045\x005f\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex52 = u"\x2e";
static constexpr OUStringLiteral FormatCode52 = u"\x0059\x0059\x0059\x0059\x0022\x5e74\x0022\x004d\x004d\x0022\x6708\x0022\x0044\x0022\x65e5\x0022\x0020\x0048\x0048\x0022\x65f6\x0022\x004d\x004d\x0022\x5206\x0022\x0053\x0053\x0022\x79d2\x0022";
static constexpr OUStringLiteral FormatDefaultName52 = u"";
static constexpr OUStringLiteral FormatKey53 = u"\x0044\x0061\x0074\x0065\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement53 = u"\x1";
static constexpr OUStringLiteral FormatType53 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage53 = u"\x0044\x0041\x0054\x0045\x005f\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex53 = u"\x2f";
static constexpr OUStringLiteral FormatCode53 = u"\x0059\x0059\x0059\x0059\x002f\x004d\x004d\x002f\x0044\x0044\x0020\x0048\x0048\x003a\x004d\x004d\x003a\x0053\x0053";
static constexpr OUStringLiteral FormatDefaultName53 = u"";
static constexpr OUStringLiteral FormatKey54 = u"\x0044\x0061\x0074\x0065\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0035";
static constexpr OUStringLiteral defaultFormatElement54 = u"\x0";
static constexpr OUStringLiteral FormatType54 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage54 = u"\x0044\x0041\x0054\x0045\x005f\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex54 = u"\x32";
static constexpr OUStringLiteral FormatCode54 = u"\x0059\x0059\x0059\x0059\x0022\x5e74\x0022\x004d\x004d\x0022\x6708\x0022\x0044\x0022\x65e5\x0022\x0020\x0048\x0048\x0022\x65f6\x0022\x004d\x004d\x0022\x5206\x0022";
static constexpr OUStringLiteral FormatDefaultName54 = u"";
static constexpr OUStringLiteral FormatKey55 = u"\x0044\x0061\x0074\x0065\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement55 = u"\x0";
static constexpr OUStringLiteral FormatType55 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage55 = u"\x0044\x0041\x0054\x0045\x005f\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex55 = u"\x4a";
static constexpr OUStringLiteral FormatCode55 = u"\x004d\x002f\x0044\x002f\x0059\x0059\x0020\x0048\x0048\x003a\x004d\x004d";
static constexpr OUStringLiteral FormatDefaultName55 = u"";
static constexpr OUStringLiteral FormatKey56 = u"\x0044\x0061\x0074\x0065\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement56 = u"\x0";
static constexpr OUStringLiteral FormatType56 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage56 = u"\x0044\x0041\x0054\x0045\x005f\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex56 = u"\x4b";
static constexpr OUStringLiteral FormatCode56 = u"\x004d\x004d\x002f\x0044\x0044\x002f\x0059\x0059\x0059\x0059\x0020\x0048\x0048\x003a\x004d\x004d\x003a\x0053\x0053";
static constexpr OUStringLiteral FormatDefaultName56 = u"";

static const sal_Int16 FormatElementsCount0 = 57;
static constexpr OUString FormatElementsArray0[] = {
	FormatCode0,
	FormatDefaultName0,
	FormatKey0,
	FormatType0,
	FormatUsage0,
	Formatindex0,
	defaultFormatElement0,
	FormatCode1,
	FormatDefaultName1,
	FormatKey1,
	FormatType1,
	FormatUsage1,
	Formatindex1,
	defaultFormatElement1,
	FormatCode2,
	FormatDefaultName2,
	FormatKey2,
	FormatType2,
	FormatUsage2,
	Formatindex2,
	defaultFormatElement2,
	FormatCode3,
	FormatDefaultName3,
	FormatKey3,
	FormatType3,
	FormatUsage3,
	Formatindex3,
	defaultFormatElement3,
	FormatCode4,
	FormatDefaultName4,
	FormatKey4,
	FormatType4,
	FormatUsage4,
	Formatindex4,
	defaultFormatElement4,
	FormatCode5,
	FormatDefaultName5,
	FormatKey5,
	FormatType5,
	FormatUsage5,
	Formatindex5,
	defaultFormatElement5,
	FormatCode6,
	FormatDefaultName6,
	FormatKey6,
	FormatType6,
	FormatUsage6,
	Formatindex6,
	defaultFormatElement6,
	FormatCode7,
	FormatDefaultName7,
	FormatKey7,
	FormatType7,
	FormatUsage7,
	Formatindex7,
	defaultFormatElement7,
	FormatCode8,
	FormatDefaultName8,
	FormatKey8,
	FormatType8,
	FormatUsage8,
	Formatindex8,
	defaultFormatElement8,
	FormatCode9,
	FormatDefaultName9,
	FormatKey9,
	FormatType9,
	FormatUsage9,
	Formatindex9,
	defaultFormatElement9,
	FormatCode10,
	FormatDefaultName10,
	FormatKey10,
	FormatType10,
	FormatUsage10,
	Formatindex10,
	defaultFormatElement10,
	FormatCode11,
	FormatDefaultName11,
	FormatKey11,
	FormatType11,
	FormatUsage11,
	Formatindex11,
	defaultFormatElement11,
	FormatCode12,
	FormatDefaultName12,
	FormatKey12,
	FormatType12,
	FormatUsage12,
	Formatindex12,
	defaultFormatElement12,
	FormatCode13,
	FormatDefaultName13,
	FormatKey13,
	FormatType13,
	FormatUsage13,
	Formatindex13,
	defaultFormatElement13,
	FormatCode14,
	FormatDefaultName14,
	FormatKey14,
	FormatType14,
	FormatUsage14,
	Formatindex14,
	defaultFormatElement14,
	FormatCode15,
	FormatDefaultName15,
	FormatKey15,
	FormatType15,
	FormatUsage15,
	Formatindex15,
	defaultFormatElement15,
	FormatCode16,
	FormatDefaultName16,
	FormatKey16,
	FormatType16,
	FormatUsage16,
	Formatindex16,
	defaultFormatElement16,
	FormatCode17,
	FormatDefaultName17,
	FormatKey17,
	FormatType17,
	FormatUsage17,
	Formatindex17,
	defaultFormatElement17,
	FormatCode18,
	FormatDefaultName18,
	FormatKey18,
	FormatType18,
	FormatUsage18,
	Formatindex18,
	defaultFormatElement18,
	FormatCode19,
	FormatDefaultName19,
	FormatKey19,
	FormatType19,
	FormatUsage19,
	Formatindex19,
	defaultFormatElement19,
	FormatCode20,
	FormatDefaultName20,
	FormatKey20,
	FormatType20,
	FormatUsage20,
	Formatindex20,
	defaultFormatElement20,
	FormatCode21,
	FormatDefaultName21,
	FormatKey21,
	FormatType21,
	FormatUsage21,
	Formatindex21,
	defaultFormatElement21,
	FormatCode22,
	FormatDefaultName22,
	FormatKey22,
	FormatType22,
	FormatUsage22,
	Formatindex22,
	defaultFormatElement22,
	FormatCode23,
	FormatDefaultName23,
	FormatKey23,
	FormatType23,
	FormatUsage23,
	Formatindex23,
	defaultFormatElement23,
	FormatCode24,
	FormatDefaultName24,
	FormatKey24,
	FormatType24,
	FormatUsage24,
	Formatindex24,
	defaultFormatElement24,
	FormatCode25,
	FormatDefaultName25,
	FormatKey25,
	FormatType25,
	FormatUsage25,
	Formatindex25,
	defaultFormatElement25,
	FormatCode26,
	FormatDefaultName26,
	FormatKey26,
	FormatType26,
	FormatUsage26,
	Formatindex26,
	defaultFormatElement26,
	FormatCode27,
	FormatDefaultName27,
	FormatKey27,
	FormatType27,
	FormatUsage27,
	Formatindex27,
	defaultFormatElement27,
	FormatCode28,
	FormatDefaultName28,
	FormatKey28,
	FormatType28,
	FormatUsage28,
	Formatindex28,
	defaultFormatElement28,
	FormatCode29,
	FormatDefaultName29,
	FormatKey29,
	FormatType29,
	FormatUsage29,
	Formatindex29,
	defaultFormatElement29,
	FormatCode30,
	FormatDefaultName30,
	FormatKey30,
	FormatType30,
	FormatUsage30,
	Formatindex30,
	defaultFormatElement30,
	FormatCode31,
	FormatDefaultName31,
	FormatKey31,
	FormatType31,
	FormatUsage31,
	Formatindex31,
	defaultFormatElement31,
	FormatCode32,
	FormatDefaultName32,
	FormatKey32,
	FormatType32,
	FormatUsage32,
	Formatindex32,
	defaultFormatElement32,
	FormatCode33,
	FormatDefaultName33,
	FormatKey33,
	FormatType33,
	FormatUsage33,
	Formatindex33,
	defaultFormatElement33,
	FormatCode34,
	FormatDefaultName34,
	FormatKey34,
	FormatType34,
	FormatUsage34,
	Formatindex34,
	defaultFormatElement34,
	FormatCode35,
	FormatDefaultName35,
	FormatKey35,
	FormatType35,
	FormatUsage35,
	Formatindex35,
	defaultFormatElement35,
	FormatCode36,
	FormatDefaultName36,
	FormatKey36,
	FormatType36,
	FormatUsage36,
	Formatindex36,
	defaultFormatElement36,
	FormatCode37,
	FormatDefaultName37,
	FormatKey37,
	FormatType37,
	FormatUsage37,
	Formatindex37,
	defaultFormatElement37,
	FormatCode38,
	FormatDefaultName38,
	FormatKey38,
	FormatType38,
	FormatUsage38,
	Formatindex38,
	defaultFormatElement38,
	FormatCode39,
	FormatDefaultName39,
	FormatKey39,
	FormatType39,
	FormatUsage39,
	Formatindex39,
	defaultFormatElement39,
	FormatCode40,
	FormatDefaultName40,
	FormatKey40,
	FormatType40,
	FormatUsage40,
	Formatindex40,
	defaultFormatElement40,
	FormatCode41,
	FormatDefaultName41,
	FormatKey41,
	FormatType41,
	FormatUsage41,
	Formatindex41,
	defaultFormatElement41,
	FormatCode42,
	FormatDefaultName42,
	FormatKey42,
	FormatType42,
	FormatUsage42,
	Formatindex42,
	defaultFormatElement42,
	FormatCode43,
	FormatDefaultName43,
	FormatKey43,
	FormatType43,
	FormatUsage43,
	Formatindex43,
	defaultFormatElement43,
	FormatCode44,
	FormatDefaultName44,
	FormatKey44,
	FormatType44,
	FormatUsage44,
	Formatindex44,
	defaultFormatElement44,
	FormatCode45,
	FormatDefaultName45,
	FormatKey45,
	FormatType45,
	FormatUsage45,
	Formatindex45,
	defaultFormatElement45,
	FormatCode46,
	FormatDefaultName46,
	FormatKey46,
	FormatType46,
	FormatUsage46,
	Formatindex46,
	defaultFormatElement46,
	FormatCode47,
	FormatDefaultName47,
	FormatKey47,
	FormatType47,
	FormatUsage47,
	Formatindex47,
	defaultFormatElement47,
	FormatCode48,
	FormatDefaultName48,
	FormatKey48,
	FormatType48,
	FormatUsage48,
	Formatindex48,
	defaultFormatElement48,
	FormatCode49,
	FormatDefaultName49,
	FormatKey49,
	FormatType49,
	FormatUsage49,
	Formatindex49,
	defaultFormatElement49,
	FormatCode50,
	FormatDefaultName50,
	FormatKey50,
	FormatType50,
	FormatUsage50,
	Formatindex50,
	defaultFormatElement50,
	FormatCode51,
	FormatDefaultName51,
	FormatKey51,
	FormatType51,
	FormatUsage51,
	Formatindex51,
	defaultFormatElement51,
	FormatCode52,
	FormatDefaultName52,
	FormatKey52,
	FormatType52,
	FormatUsage52,
	Formatindex52,
	defaultFormatElement52,
	FormatCode53,
	FormatDefaultName53,
	FormatKey53,
	FormatType53,
	FormatUsage53,
	Formatindex53,
	defaultFormatElement53,
	FormatCode54,
	FormatDefaultName54,
	FormatKey54,
	FormatType54,
	FormatUsage54,
	Formatindex54,
	defaultFormatElement54,
	FormatCode55,
	FormatDefaultName55,
	FormatKey55,
	FormatType55,
	FormatUsage55,
	Formatindex55,
	defaultFormatElement55,
	FormatCode56,
	FormatDefaultName56,
	FormatKey56,
	FormatType56,
	FormatUsage56,
	Formatindex56,
	defaultFormatElement56,
};

SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_zh_CN(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	count = FormatElementsCount0;
	from = replaceFrom0;
	to = replaceTo0;
	return (const OUString *)FormatElementsArray0;
}
static constexpr OUStringLiteral DateAcceptancePattern0 = u"\x004d\x002d\x0044";
static constexpr OUStringLiteral DateAcceptancePattern1 = u"\x004d\x002f\x0044";
static constexpr OUStringLiteral DateAcceptancePattern2 = u"\x004d\xff0f\x0044";
static constexpr OUStringLiteral DateAcceptancePattern3 = u"\x0059\x002e\x004d\x002e\x0044";
static constexpr OUStringLiteral DateAcceptancePattern4 = u"\x0059\xff0f\x004d\xff0f\x0044";
static constexpr OUStringLiteral DateAcceptancePattern5 = u"\x0059\x5e74\x004d\x6708\x0044\x65e5";
static constexpr OUStringLiteral DateAcceptancePattern6 = u"\x004d\x6708\x0044\x65e5";
static constexpr OUStringLiteral DateAcceptancePattern7 = u"\x0059\x002f\x004d\x002f\x0044";
static const sal_Int16 DateAcceptancePatternsCount = 8;
static constexpr OUString DateAcceptancePatternsArray[] = {
	DateAcceptancePattern0,
	DateAcceptancePattern1,
	DateAcceptancePattern2,
	DateAcceptancePattern3,
	DateAcceptancePattern4,
	DateAcceptancePattern5,
	DateAcceptancePattern6,
	DateAcceptancePattern7,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getDateAcceptancePatterns_zh_CN(sal_Int16& count)
{
	count = DateAcceptancePatternsCount;
	return (OUString const *)DateAcceptancePatternsArray;
}
static constexpr OUStringLiteral CollatorID0 = u"\x0070\x0069\x006e\x0079\x0069\x006e";
static constexpr OUStringLiteral CollatorRule0 = u"";
static constexpr OUStringLiteral defaultCollator0 = u"\x1";

static constexpr OUStringLiteral CollatorID1 = u"\x0073\x0074\x0072\x006f\x006b\x0065";
static constexpr OUStringLiteral CollatorRule1 = u"";
static constexpr OUStringLiteral defaultCollator1 = u"\x0";

static constexpr OUStringLiteral CollatorID2 = u"\x0072\x0061\x0064\x0069\x0063\x0061\x006c";
static constexpr OUStringLiteral CollatorRule2 = u"";
static constexpr OUStringLiteral defaultCollator2 = u"\x0";

static constexpr OUStringLiteral CollatorID3 = u"\x0063\x0068\x0061\x0072\x0073\x0065\x0074";
static constexpr OUStringLiteral CollatorRule3 = u"";
static constexpr OUStringLiteral defaultCollator3 = u"\x0";

static constexpr OUStringLiteral collationOption0 = u"\x0049\x0047\x004e\x004f\x0052\x0045\x005f\x0043\x0041\x0053\x0045";
static const sal_Int16 nbOfCollationOptions = 1;

static const sal_Int16 nbOfCollations = 4;


static constexpr OUString LCCollatorArray[] = {
	CollatorID0,
	defaultCollator0,
	CollatorRule0,
	CollatorID1,
	defaultCollator1,
	CollatorRule1,
	CollatorID2,
	defaultCollator2,
	CollatorRule2,
	CollatorID3,
	defaultCollator3,
	CollatorRule3,
};

static constexpr OUString collationOptions[] = {collationOption0};
SAL_DLLPUBLIC_EXPORT OUString const *  getCollatorImplementation_zh_CN(sal_Int16& count)
{
	count = nbOfCollations;
	return (OUString const *)LCCollatorArray;
}
SAL_DLLPUBLIC_EXPORT OUString const *  getCollationOptions_zh_CN(sal_Int16& count)
{
	count = nbOfCollationOptions;
	return (OUString const *)collationOptions;
}
static constexpr OUStringLiteral searchOption0 = u"\x0049\x0047\x004e\x004f\x0052\x0045\x005f\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral searchOption1 = u"\x0049\x0047\x004e\x004f\x0052\x0045\x005f\x0057\x0049\x0044\x0054\x0048";
static const sal_Int16 nbOfSearchOptions = 2;

static constexpr OUString searchOptions[] = {searchOption0, searchOption1 };
SAL_DLLPUBLIC_EXPORT OUString const *  getSearchOptions_zh_CN(sal_Int16& count)
{
	count = nbOfSearchOptions;
	return (OUString const *)searchOptions;
}
static constexpr OUStringLiteral IndexID0 = u"\x0070\x0069\x006e\x0079\x0069\x006e";
static constexpr OUStringLiteral IndexModule0 = u"\x0061\x0073\x0069\x0061\x006e";
static constexpr OUStringLiteral IndexKey0 = u"";
static constexpr OUStringLiteral defaultIndex0 = u"\x1";
static constexpr OUStringLiteral defaultPhonetic0 = u"\x1";

static constexpr OUStringLiteral IndexID1 = u"\x0073\x0074\x0072\x006f\x006b\x0065";
static constexpr OUStringLiteral IndexModule1 = u"\x0061\x0073\x0069\x0061\x006e";
static constexpr OUStringLiteral IndexKey1 = u"";
static constexpr OUStringLiteral defaultIndex1 = u"\x0";
static constexpr OUStringLiteral defaultPhonetic1 = u"\x0";

static constexpr OUStringLiteral IndexID2 = u"\x0072\x0061\x0064\x0069\x0063\x0061\x006c";
static constexpr OUStringLiteral IndexModule2 = u"\x0061\x0073\x0069\x0061\x006e";
static constexpr OUStringLiteral IndexKey2 = u"";
static constexpr OUStringLiteral defaultIndex2 = u"\x0";
static constexpr OUStringLiteral defaultPhonetic2 = u"\x0";

static constexpr OUStringLiteral unicodeScript0 = u"\x0037\x0030";
static constexpr OUStringLiteral followPageWord0 = u"";
static constexpr OUStringLiteral followPageWord1 = u"";
static const sal_Int16 nbOfIndexs = 3;


static constexpr OUString IndexArray[] = {
	IndexID0,
	IndexModule0,
	IndexKey0,
	defaultIndex0,
	defaultPhonetic0,
	IndexID1,
	IndexModule1,
	IndexKey1,
	defaultIndex1,
	defaultPhonetic1,
	IndexID2,
	IndexModule2,
	IndexKey2,
	defaultIndex2,
	defaultPhonetic2,
};

static const sal_Int16 nbOfUnicodeScripts = 1;

static constexpr OUString UnicodeScriptArray[] = {unicodeScript0 };

static const sal_Int16 nbOfPageWords = 2;

static constexpr OUString FollowPageWordArray[] = {
	followPageWord0,
	followPageWord1	
};

SAL_DLLPUBLIC_EXPORT OUString const *  getIndexAlgorithm_zh_CN(sal_Int16& count)
{
	count = nbOfIndexs;
	return (OUString const *)IndexArray;
}
SAL_DLLPUBLIC_EXPORT OUString const *  getUnicodeScripts_zh_CN(sal_Int16& count)
{
	count = nbOfUnicodeScripts;
	return (OUString const *)UnicodeScriptArray;
}
SAL_DLLPUBLIC_EXPORT OUString const *  getFollowPageWords_zh_CN(sal_Int16& count)
{
	count = nbOfPageWords;
	return (OUString const *)FollowPageWordArray;
}
static constexpr OUStringLiteral calendarID0 = u"\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral defaultCalendar0 = u"\x1";
static constexpr OUStringLiteral dayID00 = u"\x0073\x0075\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName00 = u"\x65e5";
static constexpr OUStringLiteral dayDefaultFullName00 = u"\x661f\x671f\x65e5";
static constexpr OUStringLiteral dayDefaultNarrowName00 = u"\x661f";
static constexpr OUStringLiteral dayID01 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName01 = u"\x4e00";
static constexpr OUStringLiteral dayDefaultFullName01 = u"\x661f\x671f\x4e00";
static constexpr OUStringLiteral dayDefaultNarrowName01 = u"\x661f";
static constexpr OUStringLiteral dayID02 = u"\x0074\x0075\x0065";
static constexpr OUStringLiteral dayDefaultAbbrvName02 = u"\x4e8c";
static constexpr OUStringLiteral dayDefaultFullName02 = u"\x661f\x671f\x4e8c";
static constexpr OUStringLiteral dayDefaultNarrowName02 = u"\x661f";
static constexpr OUStringLiteral dayID03 = u"\x0077\x0065\x0064";
static constexpr OUStringLiteral dayDefaultAbbrvName03 = u"\x4e09";
static constexpr OUStringLiteral dayDefaultFullName03 = u"\x661f\x671f\x4e09";
static constexpr OUStringLiteral dayDefaultNarrowName03 = u"\x661f";
static constexpr OUStringLiteral dayID04 = u"\x0074\x0068\x0075";
static constexpr OUStringLiteral dayDefaultAbbrvName04 = u"\x56db";
static constexpr OUStringLiteral dayDefaultFullName04 = u"\x661f\x671f\x56db";
static constexpr OUStringLiteral dayDefaultNarrowName04 = u"\x661f";
static constexpr OUStringLiteral dayID05 = u"\x0066\x0072\x0069";
static constexpr OUStringLiteral dayDefaultAbbrvName05 = u"\x4e94";
static constexpr OUStringLiteral dayDefaultFullName05 = u"\x661f\x671f\x4e94";
static constexpr OUStringLiteral dayDefaultNarrowName05 = u"\x661f";
static constexpr OUStringLiteral dayID06 = u"\x0073\x0061\x0074";
static constexpr OUStringLiteral dayDefaultAbbrvName06 = u"\x516d";
static constexpr OUStringLiteral dayDefaultFullName06 = u"\x661f\x671f\x516d";
static constexpr OUStringLiteral dayDefaultNarrowName06 = u"\x661f";
static constexpr OUStringLiteral monthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName00 = u"\x0031\x6708";
static constexpr OUStringLiteral monthDefaultFullName00 = u"\x4e00\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName00 = u"\x4e00";
static constexpr OUStringLiteral monthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral monthDefaultAbbrvName01 = u"\x0032\x6708";
static constexpr OUStringLiteral monthDefaultFullName01 = u"\x4e8c\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName01 = u"\x4e8c";
static constexpr OUStringLiteral monthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName02 = u"\x0033\x6708";
static constexpr OUStringLiteral monthDefaultFullName02 = u"\x4e09\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName02 = u"\x4e09";
static constexpr OUStringLiteral monthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName03 = u"\x0034\x6708";
static constexpr OUStringLiteral monthDefaultFullName03 = u"\x56db\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName03 = u"\x56db";
static constexpr OUStringLiteral monthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral monthDefaultAbbrvName04 = u"\x0035\x6708";
static constexpr OUStringLiteral monthDefaultFullName04 = u"\x4e94\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName04 = u"\x4e94";
static constexpr OUStringLiteral monthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName05 = u"\x0036\x6708";
static constexpr OUStringLiteral monthDefaultFullName05 = u"\x516d\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName05 = u"\x516d";
static constexpr OUStringLiteral monthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral monthDefaultAbbrvName06 = u"\x0037\x6708";
static constexpr OUStringLiteral monthDefaultFullName06 = u"\x4e03\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName06 = u"\x4e03";
static constexpr OUStringLiteral monthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral monthDefaultAbbrvName07 = u"\x0038\x6708";
static constexpr OUStringLiteral monthDefaultFullName07 = u"\x516b\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName07 = u"\x516b";
static constexpr OUStringLiteral monthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral monthDefaultAbbrvName08 = u"\x0039\x6708";
static constexpr OUStringLiteral monthDefaultFullName08 = u"\x4e5d\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName08 = u"\x4e5d";
static constexpr OUStringLiteral monthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral monthDefaultAbbrvName09 = u"\x0031\x0030\x6708";
static constexpr OUStringLiteral monthDefaultFullName09 = u"\x5341\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName09 = u"\x5341";
static constexpr OUStringLiteral monthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral monthDefaultAbbrvName010 = u"\x0031\x0031\x6708";
static constexpr OUStringLiteral monthDefaultFullName010 = u"\x5341\x4e00\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName010 = u"\x5341";
static constexpr OUStringLiteral monthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral monthDefaultAbbrvName011 = u"\x0031\x0032\x6708";
static constexpr OUStringLiteral monthDefaultFullName011 = u"\x5341\x4e8c\x6708";
static constexpr OUStringLiteral monthDefaultNarrowName011 = u"\x5341";
static constexpr OUStringLiteral genitiveMonthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName00 = u"\x0031\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName00 = u"\x4e00\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName00 = u"\x4e00";
static constexpr OUStringLiteral genitiveMonthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName01 = u"\x0032\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName01 = u"\x4e8c\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName01 = u"\x4e8c";
static constexpr OUStringLiteral genitiveMonthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName02 = u"\x0033\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName02 = u"\x4e09\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName02 = u"\x4e09";
static constexpr OUStringLiteral genitiveMonthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName03 = u"\x0034\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName03 = u"\x56db\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName03 = u"\x56db";
static constexpr OUStringLiteral genitiveMonthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName04 = u"\x0035\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName04 = u"\x4e94\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName04 = u"\x4e94";
static constexpr OUStringLiteral genitiveMonthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName05 = u"\x0036\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName05 = u"\x516d\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName05 = u"\x516d";
static constexpr OUStringLiteral genitiveMonthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName06 = u"\x0037\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName06 = u"\x4e03\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName06 = u"\x4e03";
static constexpr OUStringLiteral genitiveMonthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName07 = u"\x0038\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName07 = u"\x516b\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName07 = u"\x516b";
static constexpr OUStringLiteral genitiveMonthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName08 = u"\x0039\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName08 = u"\x4e5d\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName08 = u"\x4e5d";
static constexpr OUStringLiteral genitiveMonthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName09 = u"\x0031\x0030\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName09 = u"\x5341\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName09 = u"\x5341";
static constexpr OUStringLiteral genitiveMonthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName010 = u"\x0031\x0031\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName010 = u"\x5341\x4e00\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName010 = u"\x5341";
static constexpr OUStringLiteral genitiveMonthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName011 = u"\x0031\x0032\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultFullName011 = u"\x5341\x4e8c\x6708";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName011 = u"\x5341";
static constexpr OUStringLiteral partitiveMonthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName00 = u"\x0031\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName00 = u"\x4e00\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName00 = u"\x4e00";
static constexpr OUStringLiteral partitiveMonthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName01 = u"\x0032\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName01 = u"\x4e8c\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName01 = u"\x4e8c";
static constexpr OUStringLiteral partitiveMonthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName02 = u"\x0033\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName02 = u"\x4e09\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName02 = u"\x4e09";
static constexpr OUStringLiteral partitiveMonthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName03 = u"\x0034\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName03 = u"\x56db\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName03 = u"\x56db";
static constexpr OUStringLiteral partitiveMonthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName04 = u"\x0035\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName04 = u"\x4e94\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName04 = u"\x4e94";
static constexpr OUStringLiteral partitiveMonthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName05 = u"\x0036\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName05 = u"\x516d\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName05 = u"\x516d";
static constexpr OUStringLiteral partitiveMonthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName06 = u"\x0037\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName06 = u"\x4e03\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName06 = u"\x4e03";
static constexpr OUStringLiteral partitiveMonthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName07 = u"\x0038\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName07 = u"\x516b\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName07 = u"\x516b";
static constexpr OUStringLiteral partitiveMonthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName08 = u"\x0039\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName08 = u"\x4e5d\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName08 = u"\x4e5d";
static constexpr OUStringLiteral partitiveMonthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName09 = u"\x0031\x0030\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName09 = u"\x5341\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName09 = u"\x5341";
static constexpr OUStringLiteral partitiveMonthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName010 = u"\x0031\x0031\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName010 = u"\x5341\x4e00\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName010 = u"\x5341";
static constexpr OUStringLiteral partitiveMonthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName011 = u"\x0031\x0032\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultFullName011 = u"\x5341\x4e8c\x6708";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName011 = u"\x5341";
static constexpr OUStringLiteral eraID00 = u"\x0062\x0063";

static constexpr OUStringLiteral eraDefaultAbbrvName00 = u"\x524d";
static constexpr OUStringLiteral eraDefaultFullName00 = u"\x516c\x5143\x524d";
static constexpr OUStringLiteral eraID01 = u"\x0061\x0064";

static constexpr OUStringLiteral eraDefaultAbbrvName01 = u"";
static constexpr OUStringLiteral eraDefaultFullName01 = u"\x516c\x5143";
static constexpr OUStringLiteral startDayOfWeek0 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral minimalDaysInFirstWeek0 = u"\x4";
static const sal_Int16 calendarsCount = 1;

static constexpr OUStringLiteral nbOfDays = u"\x7";
static constexpr OUStringLiteral nbOfMonths = u"\xc";
static constexpr OUStringLiteral nbOfGenitiveMonths = u"\xc";
static constexpr OUStringLiteral nbOfPartitiveMonths = u"\xc";
static constexpr OUStringLiteral nbOfEras = u"\x2";
static constexpr OUString calendars[] = {
	nbOfDays,
	nbOfMonths,
	nbOfGenitiveMonths,
	nbOfPartitiveMonths,
	nbOfEras,
	calendarID0,
	defaultCalendar0,
	dayID00,
	dayDefaultAbbrvName00,
	dayDefaultFullName00,
	dayDefaultNarrowName00,
	dayID01,
	dayDefaultAbbrvName01,
	dayDefaultFullName01,
	dayDefaultNarrowName01,
	dayID02,
	dayDefaultAbbrvName02,
	dayDefaultFullName02,
	dayDefaultNarrowName02,
	dayID03,
	dayDefaultAbbrvName03,
	dayDefaultFullName03,
	dayDefaultNarrowName03,
	dayID04,
	dayDefaultAbbrvName04,
	dayDefaultFullName04,
	dayDefaultNarrowName04,
	dayID05,
	dayDefaultAbbrvName05,
	dayDefaultFullName05,
	dayDefaultNarrowName05,
	dayID06,
	dayDefaultAbbrvName06,
	dayDefaultFullName06,
	dayDefaultNarrowName06,
	monthID00,
	monthDefaultAbbrvName00,
	monthDefaultFullName00,
	monthDefaultNarrowName00,
	monthID01,
	monthDefaultAbbrvName01,
	monthDefaultFullName01,
	monthDefaultNarrowName01,
	monthID02,
	monthDefaultAbbrvName02,
	monthDefaultFullName02,
	monthDefaultNarrowName02,
	monthID03,
	monthDefaultAbbrvName03,
	monthDefaultFullName03,
	monthDefaultNarrowName03,
	monthID04,
	monthDefaultAbbrvName04,
	monthDefaultFullName04,
	monthDefaultNarrowName04,
	monthID05,
	monthDefaultAbbrvName05,
	monthDefaultFullName05,
	monthDefaultNarrowName05,
	monthID06,
	monthDefaultAbbrvName06,
	monthDefaultFullName06,
	monthDefaultNarrowName06,
	monthID07,
	monthDefaultAbbrvName07,
	monthDefaultFullName07,
	monthDefaultNarrowName07,
	monthID08,
	monthDefaultAbbrvName08,
	monthDefaultFullName08,
	monthDefaultNarrowName08,
	monthID09,
	monthDefaultAbbrvName09,
	monthDefaultFullName09,
	monthDefaultNarrowName09,
	monthID010,
	monthDefaultAbbrvName010,
	monthDefaultFullName010,
	monthDefaultNarrowName010,
	monthID011,
	monthDefaultAbbrvName011,
	monthDefaultFullName011,
	monthDefaultNarrowName011,
	genitiveMonthID00,
	genitiveMonthDefaultAbbrvName00,
	genitiveMonthDefaultFullName00,
	genitiveMonthDefaultNarrowName00,
	genitiveMonthID01,
	genitiveMonthDefaultAbbrvName01,
	genitiveMonthDefaultFullName01,
	genitiveMonthDefaultNarrowName01,
	genitiveMonthID02,
	genitiveMonthDefaultAbbrvName02,
	genitiveMonthDefaultFullName02,
	genitiveMonthDefaultNarrowName02,
	genitiveMonthID03,
	genitiveMonthDefaultAbbrvName03,
	genitiveMonthDefaultFullName03,
	genitiveMonthDefaultNarrowName03,
	genitiveMonthID04,
	genitiveMonthDefaultAbbrvName04,
	genitiveMonthDefaultFullName04,
	genitiveMonthDefaultNarrowName04,
	genitiveMonthID05,
	genitiveMonthDefaultAbbrvName05,
	genitiveMonthDefaultFullName05,
	genitiveMonthDefaultNarrowName05,
	genitiveMonthID06,
	genitiveMonthDefaultAbbrvName06,
	genitiveMonthDefaultFullName06,
	genitiveMonthDefaultNarrowName06,
	genitiveMonthID07,
	genitiveMonthDefaultAbbrvName07,
	genitiveMonthDefaultFullName07,
	genitiveMonthDefaultNarrowName07,
	genitiveMonthID08,
	genitiveMonthDefaultAbbrvName08,
	genitiveMonthDefaultFullName08,
	genitiveMonthDefaultNarrowName08,
	genitiveMonthID09,
	genitiveMonthDefaultAbbrvName09,
	genitiveMonthDefaultFullName09,
	genitiveMonthDefaultNarrowName09,
	genitiveMonthID010,
	genitiveMonthDefaultAbbrvName010,
	genitiveMonthDefaultFullName010,
	genitiveMonthDefaultNarrowName010,
	genitiveMonthID011,
	genitiveMonthDefaultAbbrvName011,
	genitiveMonthDefaultFullName011,
	genitiveMonthDefaultNarrowName011,
	partitiveMonthID00,
	partitiveMonthDefaultAbbrvName00,
	partitiveMonthDefaultFullName00,
	partitiveMonthDefaultNarrowName00,
	partitiveMonthID01,
	partitiveMonthDefaultAbbrvName01,
	partitiveMonthDefaultFullName01,
	partitiveMonthDefaultNarrowName01,
	partitiveMonthID02,
	partitiveMonthDefaultAbbrvName02,
	partitiveMonthDefaultFullName02,
	partitiveMonthDefaultNarrowName02,
	partitiveMonthID03,
	partitiveMonthDefaultAbbrvName03,
	partitiveMonthDefaultFullName03,
	partitiveMonthDefaultNarrowName03,
	partitiveMonthID04,
	partitiveMonthDefaultAbbrvName04,
	partitiveMonthDefaultFullName04,
	partitiveMonthDefaultNarrowName04,
	partitiveMonthID05,
	partitiveMonthDefaultAbbrvName05,
	partitiveMonthDefaultFullName05,
	partitiveMonthDefaultNarrowName05,
	partitiveMonthID06,
	partitiveMonthDefaultAbbrvName06,
	partitiveMonthDefaultFullName06,
	partitiveMonthDefaultNarrowName06,
	partitiveMonthID07,
	partitiveMonthDefaultAbbrvName07,
	partitiveMonthDefaultFullName07,
	partitiveMonthDefaultNarrowName07,
	partitiveMonthID08,
	partitiveMonthDefaultAbbrvName08,
	partitiveMonthDefaultFullName08,
	partitiveMonthDefaultNarrowName08,
	partitiveMonthID09,
	partitiveMonthDefaultAbbrvName09,
	partitiveMonthDefaultFullName09,
	partitiveMonthDefaultNarrowName09,
	partitiveMonthID010,
	partitiveMonthDefaultAbbrvName010,
	partitiveMonthDefaultFullName010,
	partitiveMonthDefaultNarrowName010,
	partitiveMonthID011,
	partitiveMonthDefaultAbbrvName011,
	partitiveMonthDefaultFullName011,
	partitiveMonthDefaultNarrowName011,
	eraID00,
	eraDefaultAbbrvName00,
	eraDefaultFullName00,
	eraID01,
	eraDefaultAbbrvName01,
	eraDefaultFullName01,
	startDayOfWeek0,
	minimalDaysInFirstWeek0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCalendars_zh_CN(sal_Int16& count)
{
	count = calendarsCount;
	return (OUString const *)calendars;
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0043\x004e\x0059";
static constexpr OUStringLiteral currencySymbol0 = u"\xffe5";
static constexpr OUStringLiteral bankSymbol0 = u"\x0043\x004e\x0059";
static constexpr OUStringLiteral currencyName0 = u"\x4eba\x6c11\x5e01";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_zh_CN(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
static constexpr OUStringLiteral Transliteration0 = u"\x0053\x0045\x004e\x0054\x0045\x004e\x0043\x0045\x005f\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral Transliteration1 = u"\x004c\x004f\x0057\x0045\x0052\x0043\x0041\x0053\x0045\x005f\x0055\x0050\x0050\x0045\x0052\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral Transliteration2 = u"\x0055\x0050\x0050\x0045\x0052\x0043\x0041\x0053\x0045\x005f\x004c\x004f\x0057\x0045\x0052\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral Transliteration3 = u"\x0054\x0049\x0054\x004c\x0045\x005f\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral Transliteration4 = u"\x0054\x004f\x0047\x0047\x004c\x0045\x005f\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral Transliteration5 = u"\x004e\x0075\x006d\x0054\x006f\x0054\x0065\x0078\x0074\x004c\x006f\x0077\x0065\x0072\x005f\x007a\x0068\x005f\x0043\x004e";
static constexpr OUStringLiteral Transliteration6 = u"\x004e\x0075\x006d\x0054\x006f\x0054\x0065\x0078\x0074\x0055\x0070\x0070\x0065\x0072\x005f\x007a\x0068\x005f\x0043\x004e";
static constexpr OUStringLiteral Transliteration7 = u"\x004e\x0075\x006d\x0054\x006f\x0043\x0068\x0061\x0072\x004c\x006f\x0077\x0065\x0072\x005f\x007a\x0068\x005f\x0043\x004e";
static constexpr OUStringLiteral Transliteration8 = u"\x004e\x0075\x006d\x0054\x006f\x0043\x0068\x0061\x0072\x0055\x0070\x0070\x0065\x0072\x005f\x007a\x0068\x005f\x0043\x004e";
static constexpr OUStringLiteral Transliteration9 = u"\x0048\x0041\x004c\x0046\x0057\x0049\x0044\x0054\x0048\x005f\x0046\x0055\x004c\x004c\x0057\x0049\x0044\x0054\x0048";
static constexpr OUStringLiteral Transliteration10 = u"\x0046\x0055\x004c\x004c\x0057\x0049\x0044\x0054\x0048\x005f\x0048\x0041\x004c\x0046\x0057\x0049\x0044\x0054\x0048";
static constexpr OUStringLiteral Transliteration11 = u"\x0049\x0047\x004e\x004f\x0052\x0045\x005f\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral Transliteration12 = u"\x0049\x0047\x004e\x004f\x0052\x0045\x005f\x0057\x0049\x0044\x0054\x0048";
static const sal_Int16 nbOfTransliterations = 13;


static constexpr OUString LCTransliterationsArray[] = {
	Transliteration0,
	Transliteration1,
	Transliteration2,
	Transliteration3,
	Transliteration4,
	Transliteration5,
	Transliteration6,
	Transliteration7,
	Transliteration8,
	Transliteration9,
	Transliteration10,
	Transliteration11,
	Transliteration12,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getTransliterations_zh_CN(sal_Int16& count)
{
	count = nbOfTransliterations;
	return (OUString const *)LCTransliterationsArray;
}
static constexpr OUStringLiteral ReservedWord0 = u"\x0054\x0052\x0055\x0045";
static constexpr OUStringLiteral ReservedWord1 = u"\x0046\x0041\x004c\x0053\x0045";
static constexpr OUStringLiteral ReservedWord2 = u"\x7b2c\x0031\x5b63\x5ea6";
static constexpr OUStringLiteral ReservedWord3 = u"\x7b2c\x0032\x5b63\x5ea6";
static constexpr OUStringLiteral ReservedWord4 = u"\x7b2c\x0033\x5b63\x5ea6";
static constexpr OUStringLiteral ReservedWord5 = u"\x7b2c\x0034\x5b63\x5ea6";
static constexpr OUStringLiteral ReservedWord6 = u"\x4e0a\x65b9";
static constexpr OUStringLiteral ReservedWord7 = u"\x4e0b\x65b9";
static constexpr OUStringLiteral ReservedWord8 = u"\x0051\x0031";
static constexpr OUStringLiteral ReservedWord9 = u"\x0051\x0032";
static constexpr OUStringLiteral ReservedWord10 = u"\x0051\x0033";
static constexpr OUStringLiteral ReservedWord11 = u"\x0051\x0034";
static const sal_Int16 nbOfReservedWords = 12;


static constexpr OUString LCReservedWordsArray[] = {
	ReservedWord0,
	ReservedWord1,
	ReservedWord2,
	ReservedWord3,
	ReservedWord4,
	ReservedWord5,
	ReservedWord6,
	ReservedWord7,
	ReservedWord8,
	ReservedWord9,
	ReservedWord10,
	ReservedWord11,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getReservedWords_zh_CN(sal_Int16& count)
{
	count = nbOfReservedWords;
	return (OUString const *)LCReservedWordsArray;
}
static constexpr OUStringLiteral forbiddenBegin = u"\x003a\x0021\x0029\x002c\x002e\x003a\x003b\x003f\x005d\x007d\x00a2\x0027\x0022\x3001\x3002\x3009\x300b\x300d\x300f\x3011\x3015\x3017\x301e\xfe30\xfe31\xfe33\xfe50\xff64\xfe52\xfe54\xfe55\xfe56\xfe57\xfe5a\xfe5c\xfe5e\xff01\xff09\xff0c\xff0e\xff1a\xff1b\xff1f\xff5c\xff5d\xfe34\xfe36\xfe38\xfe3a\xfe3c\xfe3e\xfe40\xfe42\xfe44\xfe4f\xff64\xff5e\xffe0\x3005\x2016\x2022\x00b7\x02c7\x02c9\x2015\x002d\x002d\x2032\x2019\x201d";
static constexpr OUStringLiteral forbiddenEnd = u"\x0028\x005b\x007b\x00a3\x00a5\x0027\x0022\x2035\x3008\x300a\x300c\x300e\x3010\x3014\x3016\xff08\xff3b\xff5b\xffe1\xffe5\x301d\xfe35\xfe37\xfe39\xfe3b\xfe3d\xfe3f\xfe41\xfe43\xfe59\xfe5b\xfe5d\xff08\xff5b\x201c\x2018";
static constexpr OUStringLiteral hangingChars = u"\x0021\x002c\x002e\x003a\x003b\x003f\x3001\x3002\xff01\xff0c\xff0e\xff1a\xff1b\xff1f";

static constexpr OUString LCForbiddenCharactersArray[] = {
	forbiddenBegin,
	forbiddenEnd,
	hangingChars
};

SAL_DLLPUBLIC_EXPORT OUString const *  getForbiddenCharacters_zh_CN(sal_Int16& count)
{
	count = 3;
	return (OUString const *)LCForbiddenCharactersArray;
}
static constexpr OUStringLiteral EditMode = u"";
static constexpr OUStringLiteral DictionaryMode = u"";
static constexpr OUStringLiteral WordCountMode = u"";
static constexpr OUStringLiteral CharacterMode = u"";
static constexpr OUStringLiteral LineMode = u"\x006c\x0069\x006e\x0065\x005f\x0063\x006a";

static constexpr OUString LCBreakIteratorRulesArray[] = {
	EditMode,
	DictionaryMode,
	WordCountMode,
	CharacterMode,
	LineMode
};

SAL_DLLPUBLIC_EXPORT OUString const *  getBreakIteratorRules_zh_CN(sal_Int16& count)
{
	count = 5;
	return (OUString const *)LCBreakIteratorRulesArray;
}
// ---> ContinuousNumbering
static constexpr OUStringLiteral continuousPrefix0 = u"\x0020";
static constexpr OUStringLiteral continuousNumType0 = u"\x0034";
static constexpr OUStringLiteral continuousSuffix0 = u"\x0029";
static constexpr OUStringLiteral continuousTransliteration0 = u"";
static constexpr OUStringLiteral continuousNatNum0 = u"";
static constexpr OUStringLiteral continuousPrefix1 = u"\x0020";
static constexpr OUStringLiteral continuousNumType1 = u"\x0034";
static constexpr OUStringLiteral continuousSuffix1 = u"\x002e";
static constexpr OUStringLiteral continuousTransliteration1 = u"";
static constexpr OUStringLiteral continuousNatNum1 = u"";
static constexpr OUStringLiteral continuousPrefix2 = u"\x0028";
static constexpr OUStringLiteral continuousNumType2 = u"\x0034";
static constexpr OUStringLiteral continuousSuffix2 = u"\x0029";
static constexpr OUStringLiteral continuousTransliteration2 = u"";
static constexpr OUStringLiteral continuousNatNum2 = u"";
static constexpr OUStringLiteral continuousPrefix3 = u"\x0020";
static constexpr OUStringLiteral continuousNumType3 = u"\x0032";
static constexpr OUStringLiteral continuousSuffix3 = u"\x002e";
static constexpr OUStringLiteral continuousTransliteration3 = u"";
static constexpr OUStringLiteral continuousNatNum3 = u"";
static constexpr OUStringLiteral continuousPrefix4 = u"\x0020";
static constexpr OUStringLiteral continuousNumType4 = u"\x0030";
static constexpr OUStringLiteral continuousSuffix4 = u"\x0029";
static constexpr OUStringLiteral continuousTransliteration4 = u"";
static constexpr OUStringLiteral continuousNatNum4 = u"";
static constexpr OUStringLiteral continuousPrefix5 = u"\x0020";
static constexpr OUStringLiteral continuousNumType5 = u"\x0031";
static constexpr OUStringLiteral continuousSuffix5 = u"\x0029";
static constexpr OUStringLiteral continuousTransliteration5 = u"";
static constexpr OUStringLiteral continuousNatNum5 = u"";
static constexpr OUStringLiteral continuousPrefix6 = u"\x0028";
static constexpr OUStringLiteral continuousNumType6 = u"\x0031";
static constexpr OUStringLiteral continuousSuffix6 = u"\x0029";
static constexpr OUStringLiteral continuousTransliteration6 = u"";
static constexpr OUStringLiteral continuousNatNum6 = u"";
static constexpr OUStringLiteral continuousPrefix7 = u"\x0020";
static constexpr OUStringLiteral continuousNumType7 = u"\x0033";
static constexpr OUStringLiteral continuousSuffix7 = u"\x002e";
static constexpr OUStringLiteral continuousTransliteration7 = u"";
static constexpr OUStringLiteral continuousNatNum7 = u"";
static constexpr OUStringLiteral continuousPrefix8 = u"\x0020";
static constexpr OUStringLiteral continuousNumType8 = u"\x0034";
static constexpr OUStringLiteral continuousSuffix8 = u"\x3001";
static constexpr OUStringLiteral continuousTransliteration8 = u"";
static constexpr OUStringLiteral continuousNatNum8 = u"";
static constexpr OUStringLiteral continuousPrefix9 = u"\x005b";
static constexpr OUStringLiteral continuousNumType9 = u"\x0034";
static constexpr OUStringLiteral continuousSuffix9 = u"\x005d";
static constexpr OUStringLiteral continuousTransliteration9 = u"";
static constexpr OUStringLiteral continuousNatNum9 = u"";
static constexpr OUStringLiteral continuousPrefix10 = u"\x0020";
static constexpr OUStringLiteral continuousNumType10 = u"\x0030";
static constexpr OUStringLiteral continuousSuffix10 = u"\x002e";
static constexpr OUStringLiteral continuousTransliteration10 = u"";
static constexpr OUStringLiteral continuousNatNum10 = u"";
static constexpr OUStringLiteral continuousPrefix11 = u"\x0020";
static constexpr OUStringLiteral continuousNumType11 = u"\x0031";
static constexpr OUStringLiteral continuousSuffix11 = u"\x002e";
static constexpr OUStringLiteral continuousTransliteration11 = u"";
static constexpr OUStringLiteral continuousNatNum11 = u"";
static constexpr OUStringLiteral continuousPrefix12 = u"\x0020";
static constexpr OUStringLiteral continuousNumType12 = u"\x0031\x0035";
static constexpr OUStringLiteral continuousSuffix12 = u"\x3001";
static constexpr OUStringLiteral continuousTransliteration12 = u"";
static constexpr OUStringLiteral continuousNatNum12 = u"";
static constexpr OUStringLiteral continuousPrefix13 = u"\xff08";
static constexpr OUStringLiteral continuousNumType13 = u"\x0031\x0035";
static constexpr OUStringLiteral continuousSuffix13 = u"\xff09";
static constexpr OUStringLiteral continuousTransliteration13 = u"";
static constexpr OUStringLiteral continuousNatNum13 = u"";
static constexpr OUStringLiteral continuousPrefix14 = u"\x0020";
static constexpr OUStringLiteral continuousNumType14 = u"\x0031\x0036";
static constexpr OUStringLiteral continuousSuffix14 = u"\x3001";
static constexpr OUStringLiteral continuousTransliteration14 = u"";
static constexpr OUStringLiteral continuousNatNum14 = u"";
static constexpr OUStringLiteral continuousPrefix15 = u"\x0020";
static constexpr OUStringLiteral continuousNumType15 = u"\x0031\x0038";
static constexpr OUStringLiteral continuousSuffix15 = u"\x3001";
static constexpr OUStringLiteral continuousTransliteration15 = u"";
static constexpr OUStringLiteral continuousNatNum15 = u"";
static constexpr OUStringLiteral continuousPrefix16 = u"\x0020";
static constexpr OUStringLiteral continuousNumType16 = u"\x0031\x0039";
static constexpr OUStringLiteral continuousSuffix16 = u"\x3001";
static constexpr OUStringLiteral continuousTransliteration16 = u"";
static constexpr OUStringLiteral continuousNatNum16 = u"";
static const sal_Int16 continuousNbOfStyles = 17;

static const sal_Int16 continuousNbOfAttributesPerStyle = 5;


static constexpr OUString continuousStyle0[] = {
	continuousPrefix0,
	continuousNumType0,
	continuousSuffix0,
	continuousTransliteration0,
	continuousNatNum0,
	
};


static constexpr OUString continuousStyle1[] = {
	continuousPrefix1,
	continuousNumType1,
	continuousSuffix1,
	continuousTransliteration1,
	continuousNatNum1,
	
};


static constexpr OUString continuousStyle2[] = {
	continuousPrefix2,
	continuousNumType2,
	continuousSuffix2,
	continuousTransliteration2,
	continuousNatNum2,
	
};


static constexpr OUString continuousStyle3[] = {
	continuousPrefix3,
	continuousNumType3,
	continuousSuffix3,
	continuousTransliteration3,
	continuousNatNum3,
	
};


static constexpr OUString continuousStyle4[] = {
	continuousPrefix4,
	continuousNumType4,
	continuousSuffix4,
	continuousTransliteration4,
	continuousNatNum4,
	
};


static constexpr OUString continuousStyle5[] = {
	continuousPrefix5,
	continuousNumType5,
	continuousSuffix5,
	continuousTransliteration5,
	continuousNatNum5,
	
};


static constexpr OUString continuousStyle6[] = {
	continuousPrefix6,
	continuousNumType6,
	continuousSuffix6,
	continuousTransliteration6,
	continuousNatNum6,
	
};


static constexpr OUString continuousStyle7[] = {
	continuousPrefix7,
	continuousNumType7,
	continuousSuffix7,
	continuousTransliteration7,
	continuousNatNum7,
	
};


static constexpr OUString continuousStyle8[] = {
	continuousPrefix8,
	continuousNumType8,
	continuousSuffix8,
	continuousTransliteration8,
	continuousNatNum8,
	
};


static constexpr OUString continuousStyle9[] = {
	continuousPrefix9,
	continuousNumType9,
	continuousSuffix9,
	continuousTransliteration9,
	continuousNatNum9,
	
};


static constexpr OUString continuousStyle10[] = {
	continuousPrefix10,
	continuousNumType10,
	continuousSuffix10,
	continuousTransliteration10,
	continuousNatNum10,
	
};


static constexpr OUString continuousStyle11[] = {
	continuousPrefix11,
	continuousNumType11,
	continuousSuffix11,
	continuousTransliteration11,
	continuousNatNum11,
	
};


static constexpr OUString continuousStyle12[] = {
	continuousPrefix12,
	continuousNumType12,
	continuousSuffix12,
	continuousTransliteration12,
	continuousNatNum12,
	
};


static constexpr OUString continuousStyle13[] = {
	continuousPrefix13,
	continuousNumType13,
	continuousSuffix13,
	continuousTransliteration13,
	continuousNatNum13,
	
};


static constexpr OUString continuousStyle14[] = {
	continuousPrefix14,
	continuousNumType14,
	continuousSuffix14,
	continuousTransliteration14,
	continuousNatNum14,
	
};


static constexpr OUString continuousStyle15[] = {
	continuousPrefix15,
	continuousNumType15,
	continuousSuffix15,
	continuousTransliteration15,
	continuousNatNum15,
	
};


static constexpr OUString continuousStyle16[] = {
	continuousPrefix16,
	continuousNumType16,
	continuousSuffix16,
	continuousTransliteration16,
	continuousNatNum16,
	
};


static const OUString* const LCContinuousNumberingLevelsArray[] = {
	continuousStyle0,
	continuousStyle1,
	continuousStyle2,
	continuousStyle3,
	continuousStyle4,
	continuousStyle5,
	continuousStyle6,
	continuousStyle7,
	continuousStyle8,
	continuousStyle9,
	continuousStyle10,
	continuousStyle11,
	continuousStyle12,
	continuousStyle13,
	continuousStyle14,
	continuousStyle15,
	continuousStyle16,
	0
};

SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_zh_CN( sal_Int16& nStyles, sal_Int16& nAttributes )
{
	nStyles     = continuousNbOfStyles;
	nAttributes = continuousNbOfAttributesPerStyle;
	return (const OUString **)LCContinuousNumberingLevelsArray;
}
// ---> OutlineNumbering
static constexpr OUStringLiteral outlinePrefix00 = u"\x0020";
static constexpr OUStringLiteral outlineNumType00 = u"\x0032";
static constexpr OUStringLiteral outlineSuffix00 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar00 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName00 = u"";
static constexpr OUStringLiteral outlineParentNumbering00 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin00 = u"\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance00 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset00 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust00 = u"\x0031";
static constexpr OUStringLiteral outlineTransliteration00 = u"";
static constexpr OUStringLiteral outlineNatNum00 = u"";
static constexpr OUStringLiteral outlinePrefix01 = u"\x0020";
static constexpr OUStringLiteral outlineNumType01 = u"\x0030";
static constexpr OUStringLiteral outlineSuffix01 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar01 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName01 = u"";
static constexpr OUStringLiteral outlineParentNumbering01 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin01 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance01 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset01 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust01 = u"";
static constexpr OUStringLiteral outlineTransliteration01 = u"";
static constexpr OUStringLiteral outlineNatNum01 = u"";
static constexpr OUStringLiteral outlinePrefix02 = u"\x0020";
static constexpr OUStringLiteral outlineNumType02 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix02 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar02 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName02 = u"";
static constexpr OUStringLiteral outlineParentNumbering02 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin02 = u"\x0031\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance02 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset02 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust02 = u"";
static constexpr OUStringLiteral outlineTransliteration02 = u"";
static constexpr OUStringLiteral outlineNatNum02 = u"";
static constexpr OUStringLiteral outlinePrefix03 = u"\x0020";
static constexpr OUStringLiteral outlineNumType03 = u"\x0031";
static constexpr OUStringLiteral outlineSuffix03 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar03 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName03 = u"";
static constexpr OUStringLiteral outlineParentNumbering03 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin03 = u"\x0031\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance03 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset03 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust03 = u"";
static constexpr OUStringLiteral outlineTransliteration03 = u"";
static constexpr OUStringLiteral outlineNatNum03 = u"";
static constexpr OUStringLiteral outlinePrefix04 = u"\x0020";
static constexpr OUStringLiteral outlineNumType04 = u"\x0033";
static constexpr OUStringLiteral outlineSuffix04 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar04 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName04 = u"";
static constexpr OUStringLiteral outlineParentNumbering04 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin04 = u"\x0032\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance04 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset04 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust04 = u"\x0031";
static constexpr OUStringLiteral outlineTransliteration04 = u"";
static constexpr OUStringLiteral outlineNatNum04 = u"";
static constexpr OUStringLiteral outlinePrefix05 = u"\x0020";
static constexpr OUStringLiteral outlineNumType05 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix05 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar05 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName05 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering05 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin05 = u"\x0032\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance05 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset05 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust05 = u"";
static constexpr OUStringLiteral outlineTransliteration05 = u"";
static constexpr OUStringLiteral outlineNatNum05 = u"";
static constexpr OUStringLiteral outlinePrefix10 = u"\x0020";
static constexpr OUStringLiteral outlineNumType10 = u"\x0030";
static constexpr OUStringLiteral outlineSuffix10 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar10 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName10 = u"";
static constexpr OUStringLiteral outlineParentNumbering10 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin10 = u"\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance10 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset10 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust10 = u"";
static constexpr OUStringLiteral outlineTransliteration10 = u"";
static constexpr OUStringLiteral outlineNatNum10 = u"";
static constexpr OUStringLiteral outlinePrefix11 = u"\x0020";
static constexpr OUStringLiteral outlineNumType11 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix11 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar11 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName11 = u"";
static constexpr OUStringLiteral outlineParentNumbering11 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin11 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance11 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset11 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust11 = u"";
static constexpr OUStringLiteral outlineTransliteration11 = u"";
static constexpr OUStringLiteral outlineNatNum11 = u"";
static constexpr OUStringLiteral outlinePrefix12 = u"\x0020";
static constexpr OUStringLiteral outlineNumType12 = u"\x0031";
static constexpr OUStringLiteral outlineSuffix12 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar12 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName12 = u"";
static constexpr OUStringLiteral outlineParentNumbering12 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin12 = u"\x0031\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance12 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset12 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust12 = u"";
static constexpr OUStringLiteral outlineTransliteration12 = u"";
static constexpr OUStringLiteral outlineNatNum12 = u"";
static constexpr OUStringLiteral outlinePrefix13 = u"\x0020";
static constexpr OUStringLiteral outlineNumType13 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix13 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar13 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName13 = u"";
static constexpr OUStringLiteral outlineParentNumbering13 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin13 = u"\x0031\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance13 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset13 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust13 = u"";
static constexpr OUStringLiteral outlineTransliteration13 = u"";
static constexpr OUStringLiteral outlineNatNum13 = u"";
static constexpr OUStringLiteral outlinePrefix14 = u"\x0020";
static constexpr OUStringLiteral outlineNumType14 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix14 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar14 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName14 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering14 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin14 = u"\x0032\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance14 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset14 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust14 = u"";
static constexpr OUStringLiteral outlineTransliteration14 = u"";
static constexpr OUStringLiteral outlineNatNum14 = u"";
static constexpr OUStringLiteral outlinePrefix15 = u"\x0020";
static constexpr OUStringLiteral outlineNumType15 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix15 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar15 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName15 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering15 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin15 = u"\x0032\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance15 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset15 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust15 = u"";
static constexpr OUStringLiteral outlineTransliteration15 = u"";
static constexpr OUStringLiteral outlineNatNum15 = u"";
static constexpr OUStringLiteral outlinePrefix20 = u"\x0020";
static constexpr OUStringLiteral outlineNumType20 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix20 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar20 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName20 = u"";
static constexpr OUStringLiteral outlineParentNumbering20 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin20 = u"\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance20 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset20 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust20 = u"";
static constexpr OUStringLiteral outlineTransliteration20 = u"";
static constexpr OUStringLiteral outlineNatNum20 = u"";
static constexpr OUStringLiteral outlinePrefix21 = u"\x0020";
static constexpr OUStringLiteral outlineNumType21 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix21 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar21 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName21 = u"";
static constexpr OUStringLiteral outlineParentNumbering21 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin21 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance21 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset21 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust21 = u"";
static constexpr OUStringLiteral outlineTransliteration21 = u"";
static constexpr OUStringLiteral outlineNatNum21 = u"";
static constexpr OUStringLiteral outlinePrefix22 = u"\x0020";
static constexpr OUStringLiteral outlineNumType22 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix22 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar22 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName22 = u"";
static constexpr OUStringLiteral outlineParentNumbering22 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin22 = u"\x0031\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance22 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset22 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust22 = u"";
static constexpr OUStringLiteral outlineTransliteration22 = u"";
static constexpr OUStringLiteral outlineNatNum22 = u"";
static constexpr OUStringLiteral outlinePrefix23 = u"\x0020";
static constexpr OUStringLiteral outlineNumType23 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix23 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar23 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName23 = u"";
static constexpr OUStringLiteral outlineParentNumbering23 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin23 = u"\x0031\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance23 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset23 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust23 = u"";
static constexpr OUStringLiteral outlineTransliteration23 = u"";
static constexpr OUStringLiteral outlineNatNum23 = u"";
static constexpr OUStringLiteral outlinePrefix24 = u"\x0020";
static constexpr OUStringLiteral outlineNumType24 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix24 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar24 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName24 = u"";
static constexpr OUStringLiteral outlineParentNumbering24 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin24 = u"\x0032\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance24 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset24 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust24 = u"";
static constexpr OUStringLiteral outlineTransliteration24 = u"";
static constexpr OUStringLiteral outlineNatNum24 = u"";
static constexpr OUStringLiteral outlinePrefix25 = u"\x0020";
static constexpr OUStringLiteral outlineNumType25 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix25 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar25 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName25 = u"";
static constexpr OUStringLiteral outlineParentNumbering25 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin25 = u"\x0032\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance25 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset25 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust25 = u"";
static constexpr OUStringLiteral outlineTransliteration25 = u"";
static constexpr OUStringLiteral outlineNatNum25 = u"";
static constexpr OUStringLiteral outlinePrefix30 = u"\x0020";
static constexpr OUStringLiteral outlineNumType30 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix30 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar30 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName30 = u"";
static constexpr OUStringLiteral outlineParentNumbering30 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin30 = u"\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance30 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset30 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust30 = u"";
static constexpr OUStringLiteral outlineTransliteration30 = u"";
static constexpr OUStringLiteral outlineNatNum30 = u"";
static constexpr OUStringLiteral outlinePrefix31 = u"\x0020";
static constexpr OUStringLiteral outlineNumType31 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix31 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar31 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName31 = u"";
static constexpr OUStringLiteral outlineParentNumbering31 = u"\x0031";
static constexpr OUStringLiteral outlineLeftMargin31 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance31 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset31 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust31 = u"";
static constexpr OUStringLiteral outlineTransliteration31 = u"";
static constexpr OUStringLiteral outlineNatNum31 = u"";
static constexpr OUStringLiteral outlinePrefix32 = u"\x0020";
static constexpr OUStringLiteral outlineNumType32 = u"\x0031";
static constexpr OUStringLiteral outlineSuffix32 = u"\x0029";
static constexpr OUStringLiteral outlineBulletChar32 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName32 = u"";
static constexpr OUStringLiteral outlineParentNumbering32 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin32 = u"\x0031\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance32 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset32 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust32 = u"";
static constexpr OUStringLiteral outlineTransliteration32 = u"";
static constexpr OUStringLiteral outlineNatNum32 = u"";
static constexpr OUStringLiteral outlinePrefix33 = u"\x0020";
static constexpr OUStringLiteral outlineNumType33 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix33 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar33 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName33 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering33 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin33 = u"\x0031\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance33 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset33 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust33 = u"";
static constexpr OUStringLiteral outlineTransliteration33 = u"";
static constexpr OUStringLiteral outlineNatNum33 = u"";
static constexpr OUStringLiteral outlinePrefix34 = u"\x0020";
static constexpr OUStringLiteral outlineNumType34 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix34 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar34 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName34 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering34 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin34 = u"\x0032\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance34 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset34 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust34 = u"";
static constexpr OUStringLiteral outlineTransliteration34 = u"";
static constexpr OUStringLiteral outlineNatNum34 = u"";
static constexpr OUStringLiteral outlinePrefix35 = u"\x0020";
static constexpr OUStringLiteral outlineNumType35 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix35 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar35 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName35 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering35 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin35 = u"\x0032\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance35 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset35 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust35 = u"";
static constexpr OUStringLiteral outlineTransliteration35 = u"";
static constexpr OUStringLiteral outlineNatNum35 = u"";
static constexpr OUStringLiteral outlinePrefix40 = u"\x0020";
static constexpr OUStringLiteral outlineNumType40 = u"\x0030";
static constexpr OUStringLiteral outlineSuffix40 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar40 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName40 = u"";
static constexpr OUStringLiteral outlineParentNumbering40 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin40 = u"\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance40 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset40 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust40 = u"";
static constexpr OUStringLiteral outlineTransliteration40 = u"";
static constexpr OUStringLiteral outlineNatNum40 = u"";
static constexpr OUStringLiteral outlinePrefix41 = u"\x0020";
static constexpr OUStringLiteral outlineNumType41 = u"\x0032";
static constexpr OUStringLiteral outlineSuffix41 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar41 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName41 = u"";
static constexpr OUStringLiteral outlineParentNumbering41 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin41 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance41 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset41 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust41 = u"\x0031";
static constexpr OUStringLiteral outlineTransliteration41 = u"";
static constexpr OUStringLiteral outlineNatNum41 = u"";
static constexpr OUStringLiteral outlinePrefix42 = u"\x0020";
static constexpr OUStringLiteral outlineNumType42 = u"\x0031";
static constexpr OUStringLiteral outlineSuffix42 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar42 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName42 = u"";
static constexpr OUStringLiteral outlineParentNumbering42 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin42 = u"\x0031\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance42 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset42 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust42 = u"";
static constexpr OUStringLiteral outlineTransliteration42 = u"";
static constexpr OUStringLiteral outlineNatNum42 = u"";
static constexpr OUStringLiteral outlinePrefix43 = u"\x0020";
static constexpr OUStringLiteral outlineNumType43 = u"\x0033";
static constexpr OUStringLiteral outlineSuffix43 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar43 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName43 = u"";
static constexpr OUStringLiteral outlineParentNumbering43 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin43 = u"\x0031\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance43 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset43 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust43 = u"\x0031";
static constexpr OUStringLiteral outlineTransliteration43 = u"";
static constexpr OUStringLiteral outlineNatNum43 = u"";
static constexpr OUStringLiteral outlinePrefix44 = u"\x0020";
static constexpr OUStringLiteral outlineNumType44 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix44 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar44 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName44 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering44 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin44 = u"\x0032\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance44 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset44 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust44 = u"";
static constexpr OUStringLiteral outlineTransliteration44 = u"";
static constexpr OUStringLiteral outlineNatNum44 = u"";
static constexpr OUStringLiteral outlinePrefix45 = u"\x0020";
static constexpr OUStringLiteral outlineNumType45 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix45 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar45 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName45 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering45 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin45 = u"\x0032\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance45 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset45 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust45 = u"";
static constexpr OUStringLiteral outlineTransliteration45 = u"";
static constexpr OUStringLiteral outlineNatNum45 = u"";
static constexpr OUStringLiteral outlinePrefix50 = u"\x0020";
static constexpr OUStringLiteral outlineNumType50 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix50 = u"\x0029";
static constexpr OUStringLiteral outlineBulletChar50 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName50 = u"";
static constexpr OUStringLiteral outlineParentNumbering50 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin50 = u"\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance50 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset50 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust50 = u"";
static constexpr OUStringLiteral outlineTransliteration50 = u"";
static constexpr OUStringLiteral outlineNatNum50 = u"";
static constexpr OUStringLiteral outlinePrefix51 = u"\x0020";
static constexpr OUStringLiteral outlineNumType51 = u"\x0031";
static constexpr OUStringLiteral outlineSuffix51 = u"\x0029";
static constexpr OUStringLiteral outlineBulletChar51 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName51 = u"";
static constexpr OUStringLiteral outlineParentNumbering51 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin51 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance51 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset51 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust51 = u"";
static constexpr OUStringLiteral outlineTransliteration51 = u"";
static constexpr OUStringLiteral outlineNatNum51 = u"";
static constexpr OUStringLiteral outlinePrefix52 = u"\x0020";
static constexpr OUStringLiteral outlineNumType52 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix52 = u"\x0029";
static constexpr OUStringLiteral outlineBulletChar52 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName52 = u"";
static constexpr OUStringLiteral outlineParentNumbering52 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin52 = u"\x0031\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance52 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset52 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust52 = u"";
static constexpr OUStringLiteral outlineTransliteration52 = u"";
static constexpr OUStringLiteral outlineNatNum52 = u"";
static constexpr OUStringLiteral outlinePrefix53 = u"\x0020";
static constexpr OUStringLiteral outlineNumType53 = u"\x0030";
static constexpr OUStringLiteral outlineSuffix53 = u"\x0029";
static constexpr OUStringLiteral outlineBulletChar53 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName53 = u"";
static constexpr OUStringLiteral outlineParentNumbering53 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin53 = u"\x0031\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance53 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset53 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust53 = u"";
static constexpr OUStringLiteral outlineTransliteration53 = u"";
static constexpr OUStringLiteral outlineNatNum53 = u"";
static constexpr OUStringLiteral outlinePrefix54 = u"\x0020";
static constexpr OUStringLiteral outlineNumType54 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix54 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar54 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName54 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering54 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin54 = u"\x0032\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance54 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset54 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust54 = u"";
static constexpr OUStringLiteral outlineTransliteration54 = u"";
static constexpr OUStringLiteral outlineNatNum54 = u"";
static constexpr OUStringLiteral outlinePrefix55 = u"\x0020";
static constexpr OUStringLiteral outlineNumType55 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix55 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar55 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName55 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering55 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin55 = u"\x0032\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance55 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset55 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust55 = u"";
static constexpr OUStringLiteral outlineTransliteration55 = u"";
static constexpr OUStringLiteral outlineNatNum55 = u"";
static constexpr OUStringLiteral outlinePrefix60 = u"\x0020";
static constexpr OUStringLiteral outlineNumType60 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix60 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar60 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName60 = u"";
static constexpr OUStringLiteral outlineParentNumbering60 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin60 = u"\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance60 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset60 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust60 = u"";
static constexpr OUStringLiteral outlineTransliteration60 = u"";
static constexpr OUStringLiteral outlineNatNum60 = u"";
static constexpr OUStringLiteral outlinePrefix61 = u"\x0020";
static constexpr OUStringLiteral outlineNumType61 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix61 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar61 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName61 = u"";
static constexpr OUStringLiteral outlineParentNumbering61 = u"\x0031";
static constexpr OUStringLiteral outlineLeftMargin61 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance61 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset61 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust61 = u"";
static constexpr OUStringLiteral outlineTransliteration61 = u"";
static constexpr OUStringLiteral outlineNatNum61 = u"";
static constexpr OUStringLiteral outlinePrefix62 = u"\x0020";
static constexpr OUStringLiteral outlineNumType62 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix62 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar62 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName62 = u"";
static constexpr OUStringLiteral outlineParentNumbering62 = u"\x0032";
static constexpr OUStringLiteral outlineLeftMargin62 = u"\x0031\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance62 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset62 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust62 = u"";
static constexpr OUStringLiteral outlineTransliteration62 = u"";
static constexpr OUStringLiteral outlineNatNum62 = u"";
static constexpr OUStringLiteral outlinePrefix63 = u"\x0020";
static constexpr OUStringLiteral outlineNumType63 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix63 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar63 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName63 = u"";
static constexpr OUStringLiteral outlineParentNumbering63 = u"\x0033";
static constexpr OUStringLiteral outlineLeftMargin63 = u"\x0031\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance63 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset63 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust63 = u"";
static constexpr OUStringLiteral outlineTransliteration63 = u"";
static constexpr OUStringLiteral outlineNatNum63 = u"";
static constexpr OUStringLiteral outlinePrefix64 = u"\x0020";
static constexpr OUStringLiteral outlineNumType64 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix64 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar64 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName64 = u"";
static constexpr OUStringLiteral outlineParentNumbering64 = u"\x0034";
static constexpr OUStringLiteral outlineLeftMargin64 = u"\x0032\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance64 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset64 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust64 = u"";
static constexpr OUStringLiteral outlineTransliteration64 = u"";
static constexpr OUStringLiteral outlineNatNum64 = u"";
static constexpr OUStringLiteral outlinePrefix65 = u"\x0020";
static constexpr OUStringLiteral outlineNumType65 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix65 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar65 = u"\x0030\x0030\x0032\x0030";
static constexpr OUStringLiteral outlineBulletFontName65 = u"";
static constexpr OUStringLiteral outlineParentNumbering65 = u"\x0035";
static constexpr OUStringLiteral outlineLeftMargin65 = u"\x0032\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance65 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset65 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust65 = u"";
static constexpr OUStringLiteral outlineTransliteration65 = u"";
static constexpr OUStringLiteral outlineNatNum65 = u"";
static constexpr OUStringLiteral outlinePrefix70 = u"\x0020";
static constexpr OUStringLiteral outlineNumType70 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix70 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar70 = u"\x0032\x0037\x0041\x0032";
static constexpr OUStringLiteral outlineBulletFontName70 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering70 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin70 = u"\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance70 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset70 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust70 = u"";
static constexpr OUStringLiteral outlineTransliteration70 = u"";
static constexpr OUStringLiteral outlineNatNum70 = u"";
static constexpr OUStringLiteral outlinePrefix71 = u"\x0020";
static constexpr OUStringLiteral outlineNumType71 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix71 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar71 = u"\x0045\x0030\x0030\x0036";
static constexpr OUStringLiteral outlineBulletFontName71 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering71 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin71 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance71 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset71 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust71 = u"";
static constexpr OUStringLiteral outlineTransliteration71 = u"";
static constexpr OUStringLiteral outlineNatNum71 = u"";
static constexpr OUStringLiteral outlinePrefix72 = u"\x0020";
static constexpr OUStringLiteral outlineNumType72 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix72 = u"\x0029";
static constexpr OUStringLiteral outlineBulletChar72 = u"\x0045\x0030\x0030\x0034";
static constexpr OUStringLiteral outlineBulletFontName72 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering72 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin72 = u"\x0031\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance72 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset72 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust72 = u"";
static constexpr OUStringLiteral outlineTransliteration72 = u"";
static constexpr OUStringLiteral outlineNatNum72 = u"";
static constexpr OUStringLiteral outlinePrefix73 = u"\x0020";
static constexpr OUStringLiteral outlineNumType73 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix73 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar73 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName73 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering73 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin73 = u"\x0031\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance73 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset73 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust73 = u"";
static constexpr OUStringLiteral outlineTransliteration73 = u"";
static constexpr OUStringLiteral outlineNatNum73 = u"";
static constexpr OUStringLiteral outlinePrefix74 = u"\x0020";
static constexpr OUStringLiteral outlineNumType74 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix74 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar74 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName74 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering74 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin74 = u"\x0032\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance74 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset74 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust74 = u"";
static constexpr OUStringLiteral outlineTransliteration74 = u"";
static constexpr OUStringLiteral outlineNatNum74 = u"";
static constexpr OUStringLiteral outlinePrefix75 = u"\x0020";
static constexpr OUStringLiteral outlineNumType75 = u"\x0036";
static constexpr OUStringLiteral outlineSuffix75 = u"\x0020";
static constexpr OUStringLiteral outlineBulletChar75 = u"\x0032\x0030\x0032\x0032";
static constexpr OUStringLiteral outlineBulletFontName75 = u"\x0053\x0074\x0061\x0072\x0053\x0079\x006d\x0062\x006f\x006c";
static constexpr OUStringLiteral outlineParentNumbering75 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin75 = u"\x0032\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance75 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset75 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust75 = u"";
static constexpr OUStringLiteral outlineTransliteration75 = u"";
static constexpr OUStringLiteral outlineNatNum75 = u"";
static constexpr OUStringLiteral outlinePrefix80 = u"";
static constexpr OUStringLiteral outlineNumType80 = u"\x0031\x0035";
static constexpr OUStringLiteral outlineSuffix80 = u"\x3001";
static constexpr OUStringLiteral outlineBulletChar80 = u"";
static constexpr OUStringLiteral outlineBulletFontName80 = u"";
static constexpr OUStringLiteral outlineParentNumbering80 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin80 = u"\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance80 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset80 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust80 = u"";
static constexpr OUStringLiteral outlineTransliteration80 = u"";
static constexpr OUStringLiteral outlineNatNum80 = u"";
static constexpr OUStringLiteral outlinePrefix81 = u"\xff08";
static constexpr OUStringLiteral outlineNumType81 = u"\x0031\x0035";
static constexpr OUStringLiteral outlineSuffix81 = u"\xff09";
static constexpr OUStringLiteral outlineBulletChar81 = u"";
static constexpr OUStringLiteral outlineBulletFontName81 = u"";
static constexpr OUStringLiteral outlineParentNumbering81 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin81 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance81 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset81 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust81 = u"";
static constexpr OUStringLiteral outlineTransliteration81 = u"";
static constexpr OUStringLiteral outlineNatNum81 = u"";
static constexpr OUStringLiteral outlinePrefix82 = u"";
static constexpr OUStringLiteral outlineNumType82 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix82 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar82 = u"";
static constexpr OUStringLiteral outlineBulletFontName82 = u"";
static constexpr OUStringLiteral outlineParentNumbering82 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin82 = u"\x0031\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance82 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset82 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust82 = u"";
static constexpr OUStringLiteral outlineTransliteration82 = u"";
static constexpr OUStringLiteral outlineNatNum82 = u"";
static constexpr OUStringLiteral outlinePrefix83 = u"\xff08";
static constexpr OUStringLiteral outlineNumType83 = u"\x0034";
static constexpr OUStringLiteral outlineSuffix83 = u"\xff09";
static constexpr OUStringLiteral outlineBulletChar83 = u"";
static constexpr OUStringLiteral outlineBulletFontName83 = u"";
static constexpr OUStringLiteral outlineParentNumbering83 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin83 = u"\x0031\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance83 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset83 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust83 = u"";
static constexpr OUStringLiteral outlineTransliteration83 = u"";
static constexpr OUStringLiteral outlineNatNum83 = u"";
static constexpr OUStringLiteral outlinePrefix84 = u"";
static constexpr OUStringLiteral outlineNumType84 = u"\x0031\x0034";
static constexpr OUStringLiteral outlineSuffix84 = u"";
static constexpr OUStringLiteral outlineBulletChar84 = u"";
static constexpr OUStringLiteral outlineBulletFontName84 = u"";
static constexpr OUStringLiteral outlineParentNumbering84 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin84 = u"\x0032\x0030\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance84 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset84 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust84 = u"";
static constexpr OUStringLiteral outlineTransliteration84 = u"";
static constexpr OUStringLiteral outlineNatNum84 = u"";
static constexpr OUStringLiteral outlinePrefix85 = u"";
static constexpr OUStringLiteral outlineNumType85 = u"\x0031";
static constexpr OUStringLiteral outlineSuffix85 = u"\x002e";
static constexpr OUStringLiteral outlineBulletChar85 = u"";
static constexpr OUStringLiteral outlineBulletFontName85 = u"";
static constexpr OUStringLiteral outlineParentNumbering85 = u"\x0030";
static constexpr OUStringLiteral outlineLeftMargin85 = u"\x0032\x0035\x0030";
static constexpr OUStringLiteral outlineSymbolTextDistance85 = u"\x0035\x0030";
static constexpr OUStringLiteral outlineFirstLineOffset85 = u"\x0030";
static constexpr OUStringLiteral outlineAdjust85 = u"";
static constexpr OUStringLiteral outlineTransliteration85 = u"";
static constexpr OUStringLiteral outlineNatNum85 = u"";
static const sal_Int16 outlineNbOfStyles = 9;

static const sal_Int16 outlineNbOfLevelsPerStyle = 6;

static const sal_Int16 outlineNbOfAttributesPerLevel = 12;

static constexpr OUString outlineStyle0Level0[] = { outlinePrefix00, outlineNumType00, outlineSuffix00, outlineBulletChar00, outlineBulletFontName00, outlineParentNumbering00, outlineLeftMargin00, outlineSymbolTextDistance00, outlineFirstLineOffset00, outlineAdjust00, outlineTransliteration00, outlineNatNum00,  };
static constexpr OUString outlineStyle0Level1[] = { outlinePrefix01, outlineNumType01, outlineSuffix01, outlineBulletChar01, outlineBulletFontName01, outlineParentNumbering01, outlineLeftMargin01, outlineSymbolTextDistance01, outlineFirstLineOffset01, outlineAdjust01, outlineTransliteration01, outlineNatNum01,  };
static constexpr OUString outlineStyle0Level2[] = { outlinePrefix02, outlineNumType02, outlineSuffix02, outlineBulletChar02, outlineBulletFontName02, outlineParentNumbering02, outlineLeftMargin02, outlineSymbolTextDistance02, outlineFirstLineOffset02, outlineAdjust02, outlineTransliteration02, outlineNatNum02,  };
static constexpr OUString outlineStyle0Level3[] = { outlinePrefix03, outlineNumType03, outlineSuffix03, outlineBulletChar03, outlineBulletFontName03, outlineParentNumbering03, outlineLeftMargin03, outlineSymbolTextDistance03, outlineFirstLineOffset03, outlineAdjust03, outlineTransliteration03, outlineNatNum03,  };
static constexpr OUString outlineStyle0Level4[] = { outlinePrefix04, outlineNumType04, outlineSuffix04, outlineBulletChar04, outlineBulletFontName04, outlineParentNumbering04, outlineLeftMargin04, outlineSymbolTextDistance04, outlineFirstLineOffset04, outlineAdjust04, outlineTransliteration04, outlineNatNum04,  };
static constexpr OUString outlineStyle0Level5[] = { outlinePrefix05, outlineNumType05, outlineSuffix05, outlineBulletChar05, outlineBulletFontName05, outlineParentNumbering05, outlineLeftMargin05, outlineSymbolTextDistance05, outlineFirstLineOffset05, outlineAdjust05, outlineTransliteration05, outlineNatNum05,  };
static constexpr OUString outlineStyle1Level0[] = { outlinePrefix10, outlineNumType10, outlineSuffix10, outlineBulletChar10, outlineBulletFontName10, outlineParentNumbering10, outlineLeftMargin10, outlineSymbolTextDistance10, outlineFirstLineOffset10, outlineAdjust10, outlineTransliteration10, outlineNatNum10,  };
static constexpr OUString outlineStyle1Level1[] = { outlinePrefix11, outlineNumType11, outlineSuffix11, outlineBulletChar11, outlineBulletFontName11, outlineParentNumbering11, outlineLeftMargin11, outlineSymbolTextDistance11, outlineFirstLineOffset11, outlineAdjust11, outlineTransliteration11, outlineNatNum11,  };
static constexpr OUString outlineStyle1Level2[] = { outlinePrefix12, outlineNumType12, outlineSuffix12, outlineBulletChar12, outlineBulletFontName12, outlineParentNumbering12, outlineLeftMargin12, outlineSymbolTextDistance12, outlineFirstLineOffset12, outlineAdjust12, outlineTransliteration12, outlineNatNum12,  };
static constexpr OUString outlineStyle1Level3[] = { outlinePrefix13, outlineNumType13, outlineSuffix13, outlineBulletChar13, outlineBulletFontName13, outlineParentNumbering13, outlineLeftMargin13, outlineSymbolTextDistance13, outlineFirstLineOffset13, outlineAdjust13, outlineTransliteration13, outlineNatNum13,  };
static constexpr OUString outlineStyle1Level4[] = { outlinePrefix14, outlineNumType14, outlineSuffix14, outlineBulletChar14, outlineBulletFontName14, outlineParentNumbering14, outlineLeftMargin14, outlineSymbolTextDistance14, outlineFirstLineOffset14, outlineAdjust14, outlineTransliteration14, outlineNatNum14,  };
static constexpr OUString outlineStyle1Level5[] = { outlinePrefix15, outlineNumType15, outlineSuffix15, outlineBulletChar15, outlineBulletFontName15, outlineParentNumbering15, outlineLeftMargin15, outlineSymbolTextDistance15, outlineFirstLineOffset15, outlineAdjust15, outlineTransliteration15, outlineNatNum15,  };
static constexpr OUString outlineStyle2Level0[] = { outlinePrefix20, outlineNumType20, outlineSuffix20, outlineBulletChar20, outlineBulletFontName20, outlineParentNumbering20, outlineLeftMargin20, outlineSymbolTextDistance20, outlineFirstLineOffset20, outlineAdjust20, outlineTransliteration20, outlineNatNum20,  };
static constexpr OUString outlineStyle2Level1[] = { outlinePrefix21, outlineNumType21, outlineSuffix21, outlineBulletChar21, outlineBulletFontName21, outlineParentNumbering21, outlineLeftMargin21, outlineSymbolTextDistance21, outlineFirstLineOffset21, outlineAdjust21, outlineTransliteration21, outlineNatNum21,  };
static constexpr OUString outlineStyle2Level2[] = { outlinePrefix22, outlineNumType22, outlineSuffix22, outlineBulletChar22, outlineBulletFontName22, outlineParentNumbering22, outlineLeftMargin22, outlineSymbolTextDistance22, outlineFirstLineOffset22, outlineAdjust22, outlineTransliteration22, outlineNatNum22,  };
static constexpr OUString outlineStyle2Level3[] = { outlinePrefix23, outlineNumType23, outlineSuffix23, outlineBulletChar23, outlineBulletFontName23, outlineParentNumbering23, outlineLeftMargin23, outlineSymbolTextDistance23, outlineFirstLineOffset23, outlineAdjust23, outlineTransliteration23, outlineNatNum23,  };
static constexpr OUString outlineStyle2Level4[] = { outlinePrefix24, outlineNumType24, outlineSuffix24, outlineBulletChar24, outlineBulletFontName24, outlineParentNumbering24, outlineLeftMargin24, outlineSymbolTextDistance24, outlineFirstLineOffset24, outlineAdjust24, outlineTransliteration24, outlineNatNum24,  };
static constexpr OUString outlineStyle2Level5[] = { outlinePrefix25, outlineNumType25, outlineSuffix25, outlineBulletChar25, outlineBulletFontName25, outlineParentNumbering25, outlineLeftMargin25, outlineSymbolTextDistance25, outlineFirstLineOffset25, outlineAdjust25, outlineTransliteration25, outlineNatNum25,  };
static constexpr OUString outlineStyle3Level0[] = { outlinePrefix30, outlineNumType30, outlineSuffix30, outlineBulletChar30, outlineBulletFontName30, outlineParentNumbering30, outlineLeftMargin30, outlineSymbolTextDistance30, outlineFirstLineOffset30, outlineAdjust30, outlineTransliteration30, outlineNatNum30,  };
static constexpr OUString outlineStyle3Level1[] = { outlinePrefix31, outlineNumType31, outlineSuffix31, outlineBulletChar31, outlineBulletFontName31, outlineParentNumbering31, outlineLeftMargin31, outlineSymbolTextDistance31, outlineFirstLineOffset31, outlineAdjust31, outlineTransliteration31, outlineNatNum31,  };
static constexpr OUString outlineStyle3Level2[] = { outlinePrefix32, outlineNumType32, outlineSuffix32, outlineBulletChar32, outlineBulletFontName32, outlineParentNumbering32, outlineLeftMargin32, outlineSymbolTextDistance32, outlineFirstLineOffset32, outlineAdjust32, outlineTransliteration32, outlineNatNum32,  };
static constexpr OUString outlineStyle3Level3[] = { outlinePrefix33, outlineNumType33, outlineSuffix33, outlineBulletChar33, outlineBulletFontName33, outlineParentNumbering33, outlineLeftMargin33, outlineSymbolTextDistance33, outlineFirstLineOffset33, outlineAdjust33, outlineTransliteration33, outlineNatNum33,  };
static constexpr OUString outlineStyle3Level4[] = { outlinePrefix34, outlineNumType34, outlineSuffix34, outlineBulletChar34, outlineBulletFontName34, outlineParentNumbering34, outlineLeftMargin34, outlineSymbolTextDistance34, outlineFirstLineOffset34, outlineAdjust34, outlineTransliteration34, outlineNatNum34,  };
static constexpr OUString outlineStyle3Level5[] = { outlinePrefix35, outlineNumType35, outlineSuffix35, outlineBulletChar35, outlineBulletFontName35, outlineParentNumbering35, outlineLeftMargin35, outlineSymbolTextDistance35, outlineFirstLineOffset35, outlineAdjust35, outlineTransliteration35, outlineNatNum35,  };
static constexpr OUString outlineStyle4Level0[] = { outlinePrefix40, outlineNumType40, outlineSuffix40, outlineBulletChar40, outlineBulletFontName40, outlineParentNumbering40, outlineLeftMargin40, outlineSymbolTextDistance40, outlineFirstLineOffset40, outlineAdjust40, outlineTransliteration40, outlineNatNum40,  };
static constexpr OUString outlineStyle4Level1[] = { outlinePrefix41, outlineNumType41, outlineSuffix41, outlineBulletChar41, outlineBulletFontName41, outlineParentNumbering41, outlineLeftMargin41, outlineSymbolTextDistance41, outlineFirstLineOffset41, outlineAdjust41, outlineTransliteration41, outlineNatNum41,  };
static constexpr OUString outlineStyle4Level2[] = { outlinePrefix42, outlineNumType42, outlineSuffix42, outlineBulletChar42, outlineBulletFontName42, outlineParentNumbering42, outlineLeftMargin42, outlineSymbolTextDistance42, outlineFirstLineOffset42, outlineAdjust42, outlineTransliteration42, outlineNatNum42,  };
static constexpr OUString outlineStyle4Level3[] = { outlinePrefix43, outlineNumType43, outlineSuffix43, outlineBulletChar43, outlineBulletFontName43, outlineParentNumbering43, outlineLeftMargin43, outlineSymbolTextDistance43, outlineFirstLineOffset43, outlineAdjust43, outlineTransliteration43, outlineNatNum43,  };
static constexpr OUString outlineStyle4Level4[] = { outlinePrefix44, outlineNumType44, outlineSuffix44, outlineBulletChar44, outlineBulletFontName44, outlineParentNumbering44, outlineLeftMargin44, outlineSymbolTextDistance44, outlineFirstLineOffset44, outlineAdjust44, outlineTransliteration44, outlineNatNum44,  };
static constexpr OUString outlineStyle4Level5[] = { outlinePrefix45, outlineNumType45, outlineSuffix45, outlineBulletChar45, outlineBulletFontName45, outlineParentNumbering45, outlineLeftMargin45, outlineSymbolTextDistance45, outlineFirstLineOffset45, outlineAdjust45, outlineTransliteration45, outlineNatNum45,  };
static constexpr OUString outlineStyle5Level0[] = { outlinePrefix50, outlineNumType50, outlineSuffix50, outlineBulletChar50, outlineBulletFontName50, outlineParentNumbering50, outlineLeftMargin50, outlineSymbolTextDistance50, outlineFirstLineOffset50, outlineAdjust50, outlineTransliteration50, outlineNatNum50,  };
static constexpr OUString outlineStyle5Level1[] = { outlinePrefix51, outlineNumType51, outlineSuffix51, outlineBulletChar51, outlineBulletFontName51, outlineParentNumbering51, outlineLeftMargin51, outlineSymbolTextDistance51, outlineFirstLineOffset51, outlineAdjust51, outlineTransliteration51, outlineNatNum51,  };
static constexpr OUString outlineStyle5Level2[] = { outlinePrefix52, outlineNumType52, outlineSuffix52, outlineBulletChar52, outlineBulletFontName52, outlineParentNumbering52, outlineLeftMargin52, outlineSymbolTextDistance52, outlineFirstLineOffset52, outlineAdjust52, outlineTransliteration52, outlineNatNum52,  };
static constexpr OUString outlineStyle5Level3[] = { outlinePrefix53, outlineNumType53, outlineSuffix53, outlineBulletChar53, outlineBulletFontName53, outlineParentNumbering53, outlineLeftMargin53, outlineSymbolTextDistance53, outlineFirstLineOffset53, outlineAdjust53, outlineTransliteration53, outlineNatNum53,  };
static constexpr OUString outlineStyle5Level4[] = { outlinePrefix54, outlineNumType54, outlineSuffix54, outlineBulletChar54, outlineBulletFontName54, outlineParentNumbering54, outlineLeftMargin54, outlineSymbolTextDistance54, outlineFirstLineOffset54, outlineAdjust54, outlineTransliteration54, outlineNatNum54,  };
static constexpr OUString outlineStyle5Level5[] = { outlinePrefix55, outlineNumType55, outlineSuffix55, outlineBulletChar55, outlineBulletFontName55, outlineParentNumbering55, outlineLeftMargin55, outlineSymbolTextDistance55, outlineFirstLineOffset55, outlineAdjust55, outlineTransliteration55, outlineNatNum55,  };
static constexpr OUString outlineStyle6Level0[] = { outlinePrefix60, outlineNumType60, outlineSuffix60, outlineBulletChar60, outlineBulletFontName60, outlineParentNumbering60, outlineLeftMargin60, outlineSymbolTextDistance60, outlineFirstLineOffset60, outlineAdjust60, outlineTransliteration60, outlineNatNum60,  };
static constexpr OUString outlineStyle6Level1[] = { outlinePrefix61, outlineNumType61, outlineSuffix61, outlineBulletChar61, outlineBulletFontName61, outlineParentNumbering61, outlineLeftMargin61, outlineSymbolTextDistance61, outlineFirstLineOffset61, outlineAdjust61, outlineTransliteration61, outlineNatNum61,  };
static constexpr OUString outlineStyle6Level2[] = { outlinePrefix62, outlineNumType62, outlineSuffix62, outlineBulletChar62, outlineBulletFontName62, outlineParentNumbering62, outlineLeftMargin62, outlineSymbolTextDistance62, outlineFirstLineOffset62, outlineAdjust62, outlineTransliteration62, outlineNatNum62,  };
static constexpr OUString outlineStyle6Level3[] = { outlinePrefix63, outlineNumType63, outlineSuffix63, outlineBulletChar63, outlineBulletFontName63, outlineParentNumbering63, outlineLeftMargin63, outlineSymbolTextDistance63, outlineFirstLineOffset63, outlineAdjust63, outlineTransliteration63, outlineNatNum63,  };
static constexpr OUString outlineStyle6Level4[] = { outlinePrefix64, outlineNumType64, outlineSuffix64, outlineBulletChar64, outlineBulletFontName64, outlineParentNumbering64, outlineLeftMargin64, outlineSymbolTextDistance64, outlineFirstLineOffset64, outlineAdjust64, outlineTransliteration64, outlineNatNum64,  };
static constexpr OUString outlineStyle6Level5[] = { outlinePrefix65, outlineNumType65, outlineSuffix65, outlineBulletChar65, outlineBulletFontName65, outlineParentNumbering65, outlineLeftMargin65, outlineSymbolTextDistance65, outlineFirstLineOffset65, outlineAdjust65, outlineTransliteration65, outlineNatNum65,  };
static constexpr OUString outlineStyle7Level0[] = { outlinePrefix70, outlineNumType70, outlineSuffix70, outlineBulletChar70, outlineBulletFontName70, outlineParentNumbering70, outlineLeftMargin70, outlineSymbolTextDistance70, outlineFirstLineOffset70, outlineAdjust70, outlineTransliteration70, outlineNatNum70,  };
static constexpr OUString outlineStyle7Level1[] = { outlinePrefix71, outlineNumType71, outlineSuffix71, outlineBulletChar71, outlineBulletFontName71, outlineParentNumbering71, outlineLeftMargin71, outlineSymbolTextDistance71, outlineFirstLineOffset71, outlineAdjust71, outlineTransliteration71, outlineNatNum71,  };
static constexpr OUString outlineStyle7Level2[] = { outlinePrefix72, outlineNumType72, outlineSuffix72, outlineBulletChar72, outlineBulletFontName72, outlineParentNumbering72, outlineLeftMargin72, outlineSymbolTextDistance72, outlineFirstLineOffset72, outlineAdjust72, outlineTransliteration72, outlineNatNum72,  };
static constexpr OUString outlineStyle7Level3[] = { outlinePrefix73, outlineNumType73, outlineSuffix73, outlineBulletChar73, outlineBulletFontName73, outlineParentNumbering73, outlineLeftMargin73, outlineSymbolTextDistance73, outlineFirstLineOffset73, outlineAdjust73, outlineTransliteration73, outlineNatNum73,  };
static constexpr OUString outlineStyle7Level4[] = { outlinePrefix74, outlineNumType74, outlineSuffix74, outlineBulletChar74, outlineBulletFontName74, outlineParentNumbering74, outlineLeftMargin74, outlineSymbolTextDistance74, outlineFirstLineOffset74, outlineAdjust74, outlineTransliteration74, outlineNatNum74,  };
static constexpr OUString outlineStyle7Level5[] = { outlinePrefix75, outlineNumType75, outlineSuffix75, outlineBulletChar75, outlineBulletFontName75, outlineParentNumbering75, outlineLeftMargin75, outlineSymbolTextDistance75, outlineFirstLineOffset75, outlineAdjust75, outlineTransliteration75, outlineNatNum75,  };
static constexpr OUString outlineStyle8Level0[] = { outlinePrefix80, outlineNumType80, outlineSuffix80, outlineBulletChar80, outlineBulletFontName80, outlineParentNumbering80, outlineLeftMargin80, outlineSymbolTextDistance80, outlineFirstLineOffset80, outlineAdjust80, outlineTransliteration80, outlineNatNum80,  };
static constexpr OUString outlineStyle8Level1[] = { outlinePrefix81, outlineNumType81, outlineSuffix81, outlineBulletChar81, outlineBulletFontName81, outlineParentNumbering81, outlineLeftMargin81, outlineSymbolTextDistance81, outlineFirstLineOffset81, outlineAdjust81, outlineTransliteration81, outlineNatNum81,  };
static constexpr OUString outlineStyle8Level2[] = { outlinePrefix82, outlineNumType82, outlineSuffix82, outlineBulletChar82, outlineBulletFontName82, outlineParentNumbering82, outlineLeftMargin82, outlineSymbolTextDistance82, outlineFirstLineOffset82, outlineAdjust82, outlineTransliteration82, outlineNatNum82,  };
static constexpr OUString outlineStyle8Level3[] = { outlinePrefix83, outlineNumType83, outlineSuffix83, outlineBulletChar83, outlineBulletFontName83, outlineParentNumbering83, outlineLeftMargin83, outlineSymbolTextDistance83, outlineFirstLineOffset83, outlineAdjust83, outlineTransliteration83, outlineNatNum83,  };
static constexpr OUString outlineStyle8Level4[] = { outlinePrefix84, outlineNumType84, outlineSuffix84, outlineBulletChar84, outlineBulletFontName84, outlineParentNumbering84, outlineLeftMargin84, outlineSymbolTextDistance84, outlineFirstLineOffset84, outlineAdjust84, outlineTransliteration84, outlineNatNum84,  };
static constexpr OUString outlineStyle8Level5[] = { outlinePrefix85, outlineNumType85, outlineSuffix85, outlineBulletChar85, outlineBulletFontName85, outlineParentNumbering85, outlineLeftMargin85, outlineSymbolTextDistance85, outlineFirstLineOffset85, outlineAdjust85, outlineTransliteration85, outlineNatNum85,  };

static constexpr OUString const * outlineStyle0[] = { outlineStyle0Level0, outlineStyle0Level1, outlineStyle0Level2, outlineStyle0Level3, outlineStyle0Level4, outlineStyle0Level5, NULL };
static constexpr OUString const * outlineStyle1[] = { outlineStyle1Level0, outlineStyle1Level1, outlineStyle1Level2, outlineStyle1Level3, outlineStyle1Level4, outlineStyle1Level5, NULL };
static constexpr OUString const * outlineStyle2[] = { outlineStyle2Level0, outlineStyle2Level1, outlineStyle2Level2, outlineStyle2Level3, outlineStyle2Level4, outlineStyle2Level5, NULL };
static constexpr OUString const * outlineStyle3[] = { outlineStyle3Level0, outlineStyle3Level1, outlineStyle3Level2, outlineStyle3Level3, outlineStyle3Level4, outlineStyle3Level5, NULL };
static constexpr OUString const * outlineStyle4[] = { outlineStyle4Level0, outlineStyle4Level1, outlineStyle4Level2, outlineStyle4Level3, outlineStyle4Level4, outlineStyle4Level5, NULL };
static constexpr OUString const * outlineStyle5[] = { outlineStyle5Level0, outlineStyle5Level1, outlineStyle5Level2, outlineStyle5Level3, outlineStyle5Level4, outlineStyle5Level5, NULL };
static constexpr OUString const * outlineStyle6[] = { outlineStyle6Level0, outlineStyle6Level1, outlineStyle6Level2, outlineStyle6Level3, outlineStyle6Level4, outlineStyle6Level5, NULL };
static constexpr OUString const * outlineStyle7[] = { outlineStyle7Level0, outlineStyle7Level1, outlineStyle7Level2, outlineStyle7Level3, outlineStyle7Level4, outlineStyle7Level5, NULL };
static constexpr OUString const * outlineStyle8[] = { outlineStyle8Level0, outlineStyle8Level1, outlineStyle8Level2, outlineStyle8Level3, outlineStyle8Level4, outlineStyle8Level5, NULL };

static constexpr OUString const * const * LCOutlineNumberingLevelsArray[] = {
	outlineStyle0,
	outlineStyle1,
	outlineStyle2,
	outlineStyle3,
	outlineStyle4,
	outlineStyle5,
	outlineStyle6,
	outlineStyle7,
	outlineStyle8,
	NULL
};

SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_zh_CN( sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes )
{
	nStyles     = outlineNbOfStyles;
	nLevels     = outlineNbOfLevelsPerStyle;
	nAttributes = outlineNbOfAttributesPerLevel;
	return (const OUString ***) LCOutlineNumberingLevelsArray;
}
} // extern "C"

