// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_marshaling_guest
//
// (impl) generated by ../mesa-25.3.2/src/gfxstream/codegen/scripts/genvk.py -registry ../mesa-25.3.2/src/vulkan/registry/vk.xml -registryGfxstream ../mesa-25.3.2/src/gfxstream/codegen/xml/vk_gfxstream.xml cereal -o /build/mesa/src/build/src/gfxstream/guest/vulkan_enc/host/vulkan/cereal
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//

#include "goldfish_vk_marshaling_guest.h"
#include "goldfish_vk_extension_structs_guest.h"
#include "goldfish_vk_private_defs.h"

#include <cstring>

namespace gfxstream {
namespace vk {

void marshal_extension_struct(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const void* structExtension);

void unmarshal_extension_struct(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    void* structExtension_out);

#ifdef VK_VERSION_1_0
void marshal_VkExtent2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtent2D* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->width, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->height, sizeof(uint32_t));
}

void unmarshal_VkExtent2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExtent2D* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->width, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->height, sizeof(uint32_t));
}

void marshal_VkExtent3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtent3D* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->width, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->height, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->depth, sizeof(uint32_t));
}

void unmarshal_VkExtent3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExtent3D* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->width, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->height, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->depth, sizeof(uint32_t));
}

void marshal_VkOffset2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkOffset2D* forMarshaling)
{
    (void)rootType;
    vkStream->write((int32_t*)&forMarshaling->x, sizeof(int32_t));
    vkStream->write((int32_t*)&forMarshaling->y, sizeof(int32_t));
}

void unmarshal_VkOffset2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkOffset2D* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((int32_t*)&forUnmarshaling->x, sizeof(int32_t));
    vkStream->read((int32_t*)&forUnmarshaling->y, sizeof(int32_t));
}

void marshal_VkOffset3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkOffset3D* forMarshaling)
{
    (void)rootType;
    vkStream->write((int32_t*)&forMarshaling->x, sizeof(int32_t));
    vkStream->write((int32_t*)&forMarshaling->y, sizeof(int32_t));
    vkStream->write((int32_t*)&forMarshaling->z, sizeof(int32_t));
}

void unmarshal_VkOffset3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkOffset3D* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((int32_t*)&forUnmarshaling->x, sizeof(int32_t));
    vkStream->read((int32_t*)&forUnmarshaling->y, sizeof(int32_t));
    vkStream->read((int32_t*)&forUnmarshaling->z, sizeof(int32_t));
}

void marshal_VkRect2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRect2D* forMarshaling)
{
    (void)rootType;
    marshal_VkOffset2D(vkStream, rootType, (VkOffset2D*)(&forMarshaling->offset));
    marshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forMarshaling->extent));
}

void unmarshal_VkRect2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRect2D* forUnmarshaling)
{
    (void)rootType;
    unmarshal_VkOffset2D(vkStream, rootType, (VkOffset2D*)(&forUnmarshaling->offset));
    unmarshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forUnmarshaling->extent));
}

void marshal_VkBaseInStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBaseInStructure* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
}

void unmarshal_VkBaseInStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBaseInStructure* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
}

void marshal_VkBaseOutStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBaseOutStructure* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
}

void unmarshal_VkBaseOutStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBaseOutStructure* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
}

void marshal_VkBufferMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryBarrier* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkAccessFlags*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags));
    vkStream->write((VkAccessFlags*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags));
    vkStream->write((uint32_t*)&forMarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->buffer, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
}

void unmarshal_VkBufferMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferMemoryBarrier* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkAccessFlags*)&forUnmarshaling->srcAccessMask, sizeof(VkAccessFlags));
    vkStream->read((VkAccessFlags*)&forUnmarshaling->dstAccessMask, sizeof(VkAccessFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_0, (VkBuffer*)&forUnmarshaling->buffer, 1);
    vkStream->read((VkDeviceSize*)&forUnmarshaling->offset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
}

void marshal_VkDispatchIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDispatchIndirectCommand* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->x, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->y, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->z, sizeof(uint32_t));
}

void unmarshal_VkDispatchIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDispatchIndirectCommand* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->x, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->y, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->z, sizeof(uint32_t));
}

void marshal_VkDrawIndexedIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrawIndexedIndirectCommand* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->indexCount, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->instanceCount, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->firstIndex, sizeof(uint32_t));
    vkStream->write((int32_t*)&forMarshaling->vertexOffset, sizeof(int32_t));
    vkStream->write((uint32_t*)&forMarshaling->firstInstance, sizeof(uint32_t));
}

void unmarshal_VkDrawIndexedIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrawIndexedIndirectCommand* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->indexCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->instanceCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->firstIndex, sizeof(uint32_t));
    vkStream->read((int32_t*)&forUnmarshaling->vertexOffset, sizeof(int32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->firstInstance, sizeof(uint32_t));
}

void marshal_VkDrawIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrawIndirectCommand* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->vertexCount, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->instanceCount, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->firstVertex, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->firstInstance, sizeof(uint32_t));
}

void unmarshal_VkDrawIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrawIndirectCommand* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->vertexCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->instanceCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->firstVertex, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->firstInstance, sizeof(uint32_t));
}

void marshal_VkImageSubresourceRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresourceRange* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    vkStream->write((uint32_t*)&forMarshaling->baseMipLevel, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->levelCount, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->baseArrayLayer, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->layerCount, sizeof(uint32_t));
}

void unmarshal_VkImageSubresourceRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageSubresourceRange* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkImageAspectFlags*)&forUnmarshaling->aspectMask, sizeof(VkImageAspectFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->baseMipLevel, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->levelCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->baseArrayLayer, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->layerCount, sizeof(uint32_t));
}

void marshal_VkImageMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryBarrier* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkAccessFlags*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags));
    vkStream->write((VkAccessFlags*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags));
    vkStream->write((VkImageLayout*)&forMarshaling->oldLayout, sizeof(VkImageLayout));
    vkStream->write((VkImageLayout*)&forMarshaling->newLayout, sizeof(VkImageLayout));
    vkStream->write((uint32_t*)&forMarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->image, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    marshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forMarshaling->subresourceRange));
}

void unmarshal_VkImageMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageMemoryBarrier* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkAccessFlags*)&forUnmarshaling->srcAccessMask, sizeof(VkAccessFlags));
    vkStream->read((VkAccessFlags*)&forUnmarshaling->dstAccessMask, sizeof(VkAccessFlags));
    vkStream->read((VkImageLayout*)&forUnmarshaling->oldLayout, sizeof(VkImageLayout));
    vkStream->read((VkImageLayout*)&forUnmarshaling->newLayout, sizeof(VkImageLayout));
    vkStream->read((uint32_t*)&forUnmarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->image, 1);
    unmarshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forUnmarshaling->subresourceRange));
}

void marshal_VkMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryBarrier* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkAccessFlags*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags));
    vkStream->write((VkAccessFlags*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags));
}

void unmarshal_VkMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryBarrier* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkAccessFlags*)&forUnmarshaling->srcAccessMask, sizeof(VkAccessFlags));
    vkStream->read((VkAccessFlags*)&forUnmarshaling->dstAccessMask, sizeof(VkAccessFlags));
}

void marshal_VkPipelineCacheHeaderVersionOne(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCacheHeaderVersionOne* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->headerSize, sizeof(uint32_t));
    vkStream->write((VkPipelineCacheHeaderVersion*)&forMarshaling->headerVersion, sizeof(VkPipelineCacheHeaderVersion));
    vkStream->write((uint32_t*)&forMarshaling->vendorID, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->deviceID, sizeof(uint32_t));
    vkStream->write((uint8_t*)forMarshaling->pipelineCacheUUID, VK_UUID_SIZE * sizeof(uint8_t));
}

void unmarshal_VkPipelineCacheHeaderVersionOne(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineCacheHeaderVersionOne* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->headerSize, sizeof(uint32_t));
    vkStream->read((VkPipelineCacheHeaderVersion*)&forUnmarshaling->headerVersion, sizeof(VkPipelineCacheHeaderVersion));
    vkStream->read((uint32_t*)&forUnmarshaling->vendorID, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->deviceID, sizeof(uint32_t));
    vkStream->read((uint8_t*)forUnmarshaling->pipelineCacheUUID, VK_UUID_SIZE * sizeof(uint8_t));
}

void marshal_VkAllocationCallbacks(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAllocationCallbacks* forMarshaling)
{
    (void)rootType;
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pUserData;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pUserData)
    {
        vkStream->write((void*)forMarshaling->pUserData, sizeof(uint8_t));
    }
    uint64_t cgen_var_1 = (uint64_t)forMarshaling->pfnAllocation;
    vkStream->putBe64(cgen_var_1);
    uint64_t cgen_var_2 = (uint64_t)forMarshaling->pfnReallocation;
    vkStream->putBe64(cgen_var_2);
    uint64_t cgen_var_3 = (uint64_t)forMarshaling->pfnFree;
    vkStream->putBe64(cgen_var_3);
    uint64_t cgen_var_4 = (uint64_t)forMarshaling->pfnInternalAllocation;
    vkStream->putBe64(cgen_var_4);
    uint64_t cgen_var_5 = (uint64_t)forMarshaling->pfnInternalFree;
    vkStream->putBe64(cgen_var_5);
}

void unmarshal_VkAllocationCallbacks(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAllocationCallbacks* forUnmarshaling)
{
    (void)rootType;
    // WARNING PTR CHECK
    void* check_pUserData;
    (void)check_pUserData;
    check_pUserData = (void*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pUserData)
    {
        if (!(check_pUserData))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pUserData inconsistent between guest and host\n");
        }
        vkStream->read((void*)forUnmarshaling->pUserData, sizeof(uint8_t));
    }
    forUnmarshaling->pfnAllocation = (PFN_vkAllocationFunction)vkStream->getBe64();
    forUnmarshaling->pfnReallocation = (PFN_vkReallocationFunction)vkStream->getBe64();
    forUnmarshaling->pfnFree = (PFN_vkFreeFunction)vkStream->getBe64();
    forUnmarshaling->pfnInternalAllocation = (PFN_vkInternalAllocationNotification)vkStream->getBe64();
    forUnmarshaling->pfnInternalFree = (PFN_vkInternalFreeNotification)vkStream->getBe64();
}

void marshal_VkApplicationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkApplicationInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pApplicationName;
        vkStream->putBe64(cgen_var_0);
        if (forMarshaling->pApplicationName)
        {
            vkStream->putString(forMarshaling->pApplicationName);
        }
    }
    else
    {
        vkStream->putString(forMarshaling->pApplicationName);
    }
    vkStream->write((uint32_t*)&forMarshaling->applicationVersion, sizeof(uint32_t));
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pEngineName;
        vkStream->putBe64(cgen_var_0);
        if (forMarshaling->pEngineName)
        {
            vkStream->putString(forMarshaling->pEngineName);
        }
    }
    else
    {
        vkStream->putString(forMarshaling->pEngineName);
    }
    vkStream->write((uint32_t*)&forMarshaling->engineVersion, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->apiVersion, sizeof(uint32_t));
}

void unmarshal_VkApplicationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkApplicationInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        const char* check_pApplicationName;
        (void)check_pApplicationName;
        check_pApplicationName = (const char*)(uintptr_t)vkStream->getBe64();
        if (forUnmarshaling->pApplicationName)
        {
            if (!(check_pApplicationName))
            {
                fprintf(stderr, "fatal: forUnmarshaling->pApplicationName inconsistent between guest and host\n");
            }
            vkStream->loadStringInPlace((char**)&forUnmarshaling->pApplicationName);
        }
    }
    else
    {
        vkStream->loadStringInPlace((char**)&forUnmarshaling->pApplicationName);
    }
    vkStream->read((uint32_t*)&forUnmarshaling->applicationVersion, sizeof(uint32_t));
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT)
    {
        // WARNING PTR CHECK
        const char* check_pEngineName;
        (void)check_pEngineName;
        check_pEngineName = (const char*)(uintptr_t)vkStream->getBe64();
        if (forUnmarshaling->pEngineName)
        {
            if (!(check_pEngineName))
            {
                fprintf(stderr, "fatal: forUnmarshaling->pEngineName inconsistent between guest and host\n");
            }
            vkStream->loadStringInPlace((char**)&forUnmarshaling->pEngineName);
        }
    }
    else
    {
        vkStream->loadStringInPlace((char**)&forUnmarshaling->pEngineName);
    }
    vkStream->read((uint32_t*)&forUnmarshaling->engineVersion, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->apiVersion, sizeof(uint32_t));
}

void marshal_VkFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkFormatFeatureFlags*)&forMarshaling->linearTilingFeatures, sizeof(VkFormatFeatureFlags));
    vkStream->write((VkFormatFeatureFlags*)&forMarshaling->optimalTilingFeatures, sizeof(VkFormatFeatureFlags));
    vkStream->write((VkFormatFeatureFlags*)&forMarshaling->bufferFeatures, sizeof(VkFormatFeatureFlags));
}

void unmarshal_VkFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFormatProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkFormatFeatureFlags*)&forUnmarshaling->linearTilingFeatures, sizeof(VkFormatFeatureFlags));
    vkStream->read((VkFormatFeatureFlags*)&forUnmarshaling->optimalTilingFeatures, sizeof(VkFormatFeatureFlags));
    vkStream->read((VkFormatFeatureFlags*)&forUnmarshaling->bufferFeatures, sizeof(VkFormatFeatureFlags));
}

void marshal_VkImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatProperties* forMarshaling)
{
    (void)rootType;
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->maxExtent));
    vkStream->write((uint32_t*)&forMarshaling->maxMipLevels, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxArrayLayers, sizeof(uint32_t));
    vkStream->write((VkSampleCountFlags*)&forMarshaling->sampleCounts, sizeof(VkSampleCountFlags));
    vkStream->write((VkDeviceSize*)&forMarshaling->maxResourceSize, sizeof(VkDeviceSize));
}

void unmarshal_VkImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageFormatProperties* forUnmarshaling)
{
    (void)rootType;
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->maxExtent));
    vkStream->read((uint32_t*)&forUnmarshaling->maxMipLevels, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxArrayLayers, sizeof(uint32_t));
    vkStream->read((VkSampleCountFlags*)&forUnmarshaling->sampleCounts, sizeof(VkSampleCountFlags));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->maxResourceSize, sizeof(VkDeviceSize));
}

void marshal_VkInstanceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkInstanceCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkInstanceCreateFlags*)&forMarshaling->flags, sizeof(VkInstanceCreateFlags));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pApplicationInfo;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pApplicationInfo)
    {
        marshal_VkApplicationInfo(vkStream, rootType, (const VkApplicationInfo*)(forMarshaling->pApplicationInfo));
    }
    vkStream->write((uint32_t*)&forMarshaling->enabledLayerCount, sizeof(uint32_t));
    saveStringArray(vkStream, forMarshaling->ppEnabledLayerNames, forMarshaling->enabledLayerCount);
    vkStream->write((uint32_t*)&forMarshaling->enabledExtensionCount, sizeof(uint32_t));
    saveStringArray(vkStream, forMarshaling->ppEnabledExtensionNames, forMarshaling->enabledExtensionCount);
}

void unmarshal_VkInstanceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkInstanceCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkInstanceCreateFlags*)&forUnmarshaling->flags, sizeof(VkInstanceCreateFlags));
    // WARNING PTR CHECK
    const VkApplicationInfo* check_pApplicationInfo;
    (void)check_pApplicationInfo;
    check_pApplicationInfo = (const VkApplicationInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pApplicationInfo)
    {
        if (!(check_pApplicationInfo))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pApplicationInfo inconsistent between guest and host\n");
        }
        unmarshal_VkApplicationInfo(vkStream, rootType, (VkApplicationInfo*)(forUnmarshaling->pApplicationInfo));
    }
    vkStream->read((uint32_t*)&forUnmarshaling->enabledLayerCount, sizeof(uint32_t));
    vkStream->loadStringArrayInPlace((char***)&forUnmarshaling->ppEnabledLayerNames);
    vkStream->read((uint32_t*)&forUnmarshaling->enabledExtensionCount, sizeof(uint32_t));
    vkStream->loadStringArrayInPlace((char***)&forUnmarshaling->ppEnabledExtensionNames);
}

void marshal_VkMemoryHeap(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryHeap* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    vkStream->write((VkMemoryHeapFlags*)&forMarshaling->flags, sizeof(VkMemoryHeapFlags));
}

void unmarshal_VkMemoryHeap(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryHeap* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
    vkStream->read((VkMemoryHeapFlags*)&forUnmarshaling->flags, sizeof(VkMemoryHeapFlags));
}

void marshal_VkMemoryType(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryType* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkMemoryPropertyFlags*)&forMarshaling->propertyFlags, sizeof(VkMemoryPropertyFlags));
    vkStream->write((uint32_t*)&forMarshaling->heapIndex, sizeof(uint32_t));
}

void unmarshal_VkMemoryType(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryType* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkMemoryPropertyFlags*)&forUnmarshaling->propertyFlags, sizeof(VkMemoryPropertyFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->heapIndex, sizeof(uint32_t));
}

void marshal_VkPhysicalDeviceFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkBool32*)&forMarshaling->robustBufferAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->fullDrawIndexUint32, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->imageCubeArray, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->independentBlend, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->geometryShader, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->tessellationShader, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->sampleRateShading, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->dualSrcBlend, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->logicOp, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->multiDrawIndirect, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->drawIndirectFirstInstance, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->depthClamp, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->depthBiasClamp, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->fillModeNonSolid, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->depthBounds, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->wideLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->largePoints, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->alphaToOne, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->multiViewport, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->samplerAnisotropy, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->textureCompressionETC2, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->textureCompressionASTC_LDR, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->textureCompressionBC, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->occlusionQueryPrecise, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->pipelineStatisticsQuery, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->vertexPipelineStoresAndAtomics, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->fragmentStoresAndAtomics, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderTessellationAndGeometryPointSize, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderImageGatherExtended, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageImageExtendedFormats, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageImageMultisample, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageImageReadWithoutFormat, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageImageWriteWithoutFormat, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderUniformBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSampledImageArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageImageArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderClipDistance, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderCullDistance, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderFloat64, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderInt64, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderInt16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderResourceResidency, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderResourceMinLod, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->sparseBinding, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->sparseResidencyBuffer, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->sparseResidencyImage2D, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->sparseResidencyImage3D, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->sparseResidency2Samples, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->sparseResidency4Samples, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->sparseResidency8Samples, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->sparseResidency16Samples, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->sparseResidencyAliased, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->variableMultisampleRate, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->inheritedQueries, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkBool32*)&forUnmarshaling->robustBufferAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->fullDrawIndexUint32, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->imageCubeArray, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->independentBlend, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->geometryShader, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->tessellationShader, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->sampleRateShading, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->dualSrcBlend, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->logicOp, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->multiDrawIndirect, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->drawIndirectFirstInstance, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->depthClamp, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->depthBiasClamp, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->fillModeNonSolid, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->depthBounds, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->wideLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->largePoints, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->alphaToOne, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->multiViewport, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->samplerAnisotropy, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->textureCompressionETC2, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->textureCompressionASTC_LDR, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->textureCompressionBC, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->occlusionQueryPrecise, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->pipelineStatisticsQuery, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->vertexPipelineStoresAndAtomics, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->fragmentStoresAndAtomics, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderTessellationAndGeometryPointSize, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderImageGatherExtended, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageImageExtendedFormats, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageImageMultisample, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageImageReadWithoutFormat, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageImageWriteWithoutFormat, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderUniformBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSampledImageArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageImageArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderClipDistance, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderCullDistance, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderFloat64, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderInt64, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderInt16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderResourceResidency, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderResourceMinLod, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->sparseBinding, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->sparseResidencyBuffer, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->sparseResidencyImage2D, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->sparseResidencyImage3D, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->sparseResidency2Samples, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->sparseResidency4Samples, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->sparseResidency8Samples, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->sparseResidency16Samples, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->sparseResidencyAliased, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->variableMultisampleRate, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->inheritedQueries, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceLimits(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLimits* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->maxImageDimension1D, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxImageDimension2D, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxImageDimension3D, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxImageDimensionCube, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxImageArrayLayers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTexelBufferElements, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxUniformBufferRange, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxStorageBufferRange, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPushConstantsSize, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxMemoryAllocationCount, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxSamplerAllocationCount, sizeof(uint32_t));
    vkStream->write((VkDeviceSize*)&forMarshaling->bufferImageGranularity, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->sparseAddressSpaceSize, sizeof(VkDeviceSize));
    vkStream->write((uint32_t*)&forMarshaling->maxBoundDescriptorSets, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorSamplers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUniformBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorStorageBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorSampledImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorStorageImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorInputAttachments, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageResources, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetSamplers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUniformBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUniformBuffersDynamic, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetStorageBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetStorageBuffersDynamic, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetSampledImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetStorageImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetInputAttachments, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxVertexInputAttributes, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxVertexInputBindings, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxVertexInputAttributeOffset, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxVertexInputBindingStride, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxVertexOutputComponents, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTessellationGenerationLevel, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTessellationPatchSize, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTessellationControlPerVertexInputComponents, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTessellationControlPerVertexOutputComponents, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTessellationControlPerPatchOutputComponents, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTessellationControlTotalOutputComponents, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTessellationEvaluationInputComponents, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTessellationEvaluationOutputComponents, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxGeometryShaderInvocations, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxGeometryInputComponents, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxGeometryOutputComponents, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxGeometryOutputVertices, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxGeometryTotalOutputComponents, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxFragmentInputComponents, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxFragmentOutputAttachments, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxFragmentDualSrcAttachments, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxFragmentCombinedOutputResources, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxComputeSharedMemorySize, sizeof(uint32_t));
    vkStream->write((uint32_t*)forMarshaling->maxComputeWorkGroupCount, 3 * sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxComputeWorkGroupInvocations, sizeof(uint32_t));
    vkStream->write((uint32_t*)forMarshaling->maxComputeWorkGroupSize, 3 * sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->subPixelPrecisionBits, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->subTexelPrecisionBits, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->mipmapPrecisionBits, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDrawIndexedIndexValue, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDrawIndirectCount, sizeof(uint32_t));
    vkStream->write((float*)&forMarshaling->maxSamplerLodBias, sizeof(float));
    vkStream->write((float*)&forMarshaling->maxSamplerAnisotropy, sizeof(float));
    vkStream->write((uint32_t*)&forMarshaling->maxViewports, sizeof(uint32_t));
    vkStream->write((uint32_t*)forMarshaling->maxViewportDimensions, 2 * sizeof(uint32_t));
    vkStream->write((float*)forMarshaling->viewportBoundsRange, 2 * sizeof(float));
    vkStream->write((uint32_t*)&forMarshaling->viewportSubPixelBits, sizeof(uint32_t));
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->minMemoryMapAlignment;
    vkStream->putBe64(cgen_var_0);
    vkStream->write((VkDeviceSize*)&forMarshaling->minTexelBufferOffsetAlignment, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->minUniformBufferOffsetAlignment, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->minStorageBufferOffsetAlignment, sizeof(VkDeviceSize));
    vkStream->write((int32_t*)&forMarshaling->minTexelOffset, sizeof(int32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTexelOffset, sizeof(uint32_t));
    vkStream->write((int32_t*)&forMarshaling->minTexelGatherOffset, sizeof(int32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTexelGatherOffset, sizeof(uint32_t));
    vkStream->write((float*)&forMarshaling->minInterpolationOffset, sizeof(float));
    vkStream->write((float*)&forMarshaling->maxInterpolationOffset, sizeof(float));
    vkStream->write((uint32_t*)&forMarshaling->subPixelInterpolationOffsetBits, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxFramebufferWidth, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxFramebufferHeight, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxFramebufferLayers, sizeof(uint32_t));
    vkStream->write((VkSampleCountFlags*)&forMarshaling->framebufferColorSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->write((VkSampleCountFlags*)&forMarshaling->framebufferDepthSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->write((VkSampleCountFlags*)&forMarshaling->framebufferStencilSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->write((VkSampleCountFlags*)&forMarshaling->framebufferNoAttachmentsSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->write((uint32_t*)&forMarshaling->maxColorAttachments, sizeof(uint32_t));
    vkStream->write((VkSampleCountFlags*)&forMarshaling->sampledImageColorSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->write((VkSampleCountFlags*)&forMarshaling->sampledImageIntegerSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->write((VkSampleCountFlags*)&forMarshaling->sampledImageDepthSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->write((VkSampleCountFlags*)&forMarshaling->sampledImageStencilSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->write((VkSampleCountFlags*)&forMarshaling->storageImageSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->write((uint32_t*)&forMarshaling->maxSampleMaskWords, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->timestampComputeAndGraphics, sizeof(VkBool32));
    vkStream->write((float*)&forMarshaling->timestampPeriod, sizeof(float));
    vkStream->write((uint32_t*)&forMarshaling->maxClipDistances, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxCullDistances, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxCombinedClipAndCullDistances, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->discreteQueuePriorities, sizeof(uint32_t));
    vkStream->write((float*)forMarshaling->pointSizeRange, 2 * sizeof(float));
    vkStream->write((float*)forMarshaling->lineWidthRange, 2 * sizeof(float));
    vkStream->write((float*)&forMarshaling->pointSizeGranularity, sizeof(float));
    vkStream->write((float*)&forMarshaling->lineWidthGranularity, sizeof(float));
    vkStream->write((VkBool32*)&forMarshaling->strictLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->standardSampleLocations, sizeof(VkBool32));
    vkStream->write((VkDeviceSize*)&forMarshaling->optimalBufferCopyOffsetAlignment, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->optimalBufferCopyRowPitchAlignment, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->nonCoherentAtomSize, sizeof(VkDeviceSize));
}

void unmarshal_VkPhysicalDeviceLimits(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceLimits* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->maxImageDimension1D, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxImageDimension2D, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxImageDimension3D, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxImageDimensionCube, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxImageArrayLayers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTexelBufferElements, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxUniformBufferRange, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxStorageBufferRange, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPushConstantsSize, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxMemoryAllocationCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxSamplerAllocationCount, sizeof(uint32_t));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->bufferImageGranularity, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->sparseAddressSpaceSize, sizeof(VkDeviceSize));
    vkStream->read((uint32_t*)&forUnmarshaling->maxBoundDescriptorSets, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorSamplers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUniformBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorStorageBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorSampledImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorStorageImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorInputAttachments, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageResources, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetSamplers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUniformBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUniformBuffersDynamic, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetStorageBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetStorageBuffersDynamic, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetSampledImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetStorageImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetInputAttachments, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxVertexInputAttributes, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxVertexInputBindings, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxVertexInputAttributeOffset, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxVertexInputBindingStride, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxVertexOutputComponents, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTessellationGenerationLevel, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTessellationPatchSize, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTessellationControlPerVertexInputComponents, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTessellationControlPerVertexOutputComponents, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTessellationControlPerPatchOutputComponents, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTessellationControlTotalOutputComponents, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTessellationEvaluationInputComponents, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTessellationEvaluationOutputComponents, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxGeometryShaderInvocations, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxGeometryInputComponents, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxGeometryOutputComponents, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxGeometryOutputVertices, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxGeometryTotalOutputComponents, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxFragmentInputComponents, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxFragmentOutputAttachments, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxFragmentDualSrcAttachments, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxFragmentCombinedOutputResources, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxComputeSharedMemorySize, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->maxComputeWorkGroupCount, 3 * sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxComputeWorkGroupInvocations, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->maxComputeWorkGroupSize, 3 * sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->subPixelPrecisionBits, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->subTexelPrecisionBits, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->mipmapPrecisionBits, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDrawIndexedIndexValue, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDrawIndirectCount, sizeof(uint32_t));
    vkStream->read((float*)&forUnmarshaling->maxSamplerLodBias, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->maxSamplerAnisotropy, sizeof(float));
    vkStream->read((uint32_t*)&forUnmarshaling->maxViewports, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->maxViewportDimensions, 2 * sizeof(uint32_t));
    vkStream->read((float*)forUnmarshaling->viewportBoundsRange, 2 * sizeof(float));
    vkStream->read((uint32_t*)&forUnmarshaling->viewportSubPixelBits, sizeof(uint32_t));
    forUnmarshaling->minMemoryMapAlignment = (size_t)vkStream->getBe64();
    vkStream->read((VkDeviceSize*)&forUnmarshaling->minTexelBufferOffsetAlignment, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->minUniformBufferOffsetAlignment, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->minStorageBufferOffsetAlignment, sizeof(VkDeviceSize));
    vkStream->read((int32_t*)&forUnmarshaling->minTexelOffset, sizeof(int32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTexelOffset, sizeof(uint32_t));
    vkStream->read((int32_t*)&forUnmarshaling->minTexelGatherOffset, sizeof(int32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTexelGatherOffset, sizeof(uint32_t));
    vkStream->read((float*)&forUnmarshaling->minInterpolationOffset, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->maxInterpolationOffset, sizeof(float));
    vkStream->read((uint32_t*)&forUnmarshaling->subPixelInterpolationOffsetBits, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxFramebufferWidth, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxFramebufferHeight, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxFramebufferLayers, sizeof(uint32_t));
    vkStream->read((VkSampleCountFlags*)&forUnmarshaling->framebufferColorSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->read((VkSampleCountFlags*)&forUnmarshaling->framebufferDepthSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->read((VkSampleCountFlags*)&forUnmarshaling->framebufferStencilSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->read((VkSampleCountFlags*)&forUnmarshaling->framebufferNoAttachmentsSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->maxColorAttachments, sizeof(uint32_t));
    vkStream->read((VkSampleCountFlags*)&forUnmarshaling->sampledImageColorSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->read((VkSampleCountFlags*)&forUnmarshaling->sampledImageIntegerSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->read((VkSampleCountFlags*)&forUnmarshaling->sampledImageDepthSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->read((VkSampleCountFlags*)&forUnmarshaling->sampledImageStencilSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->read((VkSampleCountFlags*)&forUnmarshaling->storageImageSampleCounts, sizeof(VkSampleCountFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->maxSampleMaskWords, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->timestampComputeAndGraphics, sizeof(VkBool32));
    vkStream->read((float*)&forUnmarshaling->timestampPeriod, sizeof(float));
    vkStream->read((uint32_t*)&forUnmarshaling->maxClipDistances, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxCullDistances, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxCombinedClipAndCullDistances, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->discreteQueuePriorities, sizeof(uint32_t));
    vkStream->read((float*)forUnmarshaling->pointSizeRange, 2 * sizeof(float));
    vkStream->read((float*)forUnmarshaling->lineWidthRange, 2 * sizeof(float));
    vkStream->read((float*)&forUnmarshaling->pointSizeGranularity, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->lineWidthGranularity, sizeof(float));
    vkStream->read((VkBool32*)&forUnmarshaling->strictLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->standardSampleLocations, sizeof(VkBool32));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->optimalBufferCopyOffsetAlignment, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->optimalBufferCopyRowPitchAlignment, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->nonCoherentAtomSize, sizeof(VkDeviceSize));
}

void marshal_VkPhysicalDeviceMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->memoryTypeCount, sizeof(uint32_t));
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_TYPES; ++i)
    {
        marshal_VkMemoryType(vkStream, rootType, (VkMemoryType*)(forMarshaling->memoryTypes + i));
    }
    vkStream->write((uint32_t*)&forMarshaling->memoryHeapCount, sizeof(uint32_t));
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_HEAPS; ++i)
    {
        marshal_VkMemoryHeap(vkStream, rootType, (VkMemoryHeap*)(forMarshaling->memoryHeaps + i));
    }
}

void unmarshal_VkPhysicalDeviceMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMemoryProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->memoryTypeCount, sizeof(uint32_t));
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_TYPES; ++i)
    {
        unmarshal_VkMemoryType(vkStream, rootType, (VkMemoryType*)(forUnmarshaling->memoryTypes + i));
    }
    vkStream->read((uint32_t*)&forUnmarshaling->memoryHeapCount, sizeof(uint32_t));
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_HEAPS; ++i)
    {
        unmarshal_VkMemoryHeap(vkStream, rootType, (VkMemoryHeap*)(forUnmarshaling->memoryHeaps + i));
    }
}

void marshal_VkPhysicalDeviceSparseProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkBool32*)&forMarshaling->residencyStandard2DBlockShape, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->residencyStandard2DMultisampleBlockShape, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->residencyStandard3DBlockShape, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->residencyAlignedMipSize, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->residencyNonResidentStrict, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceSparseProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSparseProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkBool32*)&forUnmarshaling->residencyStandard2DBlockShape, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->residencyStandard2DMultisampleBlockShape, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->residencyStandard3DBlockShape, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->residencyAlignedMipSize, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->residencyNonResidentStrict, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->apiVersion, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->driverVersion, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->vendorID, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->deviceID, sizeof(uint32_t));
    vkStream->write((VkPhysicalDeviceType*)&forMarshaling->deviceType, sizeof(VkPhysicalDeviceType));
    vkStream->write((char*)forMarshaling->deviceName, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE * sizeof(char));
    vkStream->write((uint8_t*)forMarshaling->pipelineCacheUUID, VK_UUID_SIZE * sizeof(uint8_t));
    marshal_VkPhysicalDeviceLimits(vkStream, rootType, (VkPhysicalDeviceLimits*)(&forMarshaling->limits));
    marshal_VkPhysicalDeviceSparseProperties(vkStream, rootType, (VkPhysicalDeviceSparseProperties*)(&forMarshaling->sparseProperties));
}

void unmarshal_VkPhysicalDeviceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->apiVersion, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->driverVersion, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->vendorID, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->deviceID, sizeof(uint32_t));
    vkStream->read((VkPhysicalDeviceType*)&forUnmarshaling->deviceType, sizeof(VkPhysicalDeviceType));
    vkStream->read((char*)forUnmarshaling->deviceName, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE * sizeof(char));
    vkStream->read((uint8_t*)forUnmarshaling->pipelineCacheUUID, VK_UUID_SIZE * sizeof(uint8_t));
    unmarshal_VkPhysicalDeviceLimits(vkStream, rootType, (VkPhysicalDeviceLimits*)(&forUnmarshaling->limits));
    unmarshal_VkPhysicalDeviceSparseProperties(vkStream, rootType, (VkPhysicalDeviceSparseProperties*)(&forUnmarshaling->sparseProperties));
}

void marshal_VkQueueFamilyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkQueueFlags*)&forMarshaling->queueFlags, sizeof(VkQueueFlags));
    vkStream->write((uint32_t*)&forMarshaling->queueCount, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->timestampValidBits, sizeof(uint32_t));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->minImageTransferGranularity));
}

void unmarshal_VkQueueFamilyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkQueueFamilyProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkQueueFlags*)&forUnmarshaling->queueFlags, sizeof(VkQueueFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->queueCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->timestampValidBits, sizeof(uint32_t));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->minImageTransferGranularity));
}

void marshal_VkDeviceQueueCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceQueueCreateFlags*)&forMarshaling->flags, sizeof(VkDeviceQueueCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->queueFamilyIndex, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->queueCount, sizeof(uint32_t));
    vkStream->write((const float*)forMarshaling->pQueuePriorities, forMarshaling->queueCount * sizeof(const float));
}

void unmarshal_VkDeviceQueueCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceQueueCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceQueueCreateFlags*)&forUnmarshaling->flags, sizeof(VkDeviceQueueCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->queueFamilyIndex, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->queueCount, sizeof(uint32_t));
    vkStream->read((float*)forUnmarshaling->pQueuePriorities, forUnmarshaling->queueCount * sizeof(const float));
}

void marshal_VkDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceCreateFlags*)&forMarshaling->flags, sizeof(VkDeviceCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->queueCreateInfoCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->queueCreateInfoCount; ++i)
        {
            marshal_VkDeviceQueueCreateInfo(vkStream, rootType, (const VkDeviceQueueCreateInfo*)(forMarshaling->pQueueCreateInfos + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->enabledLayerCount, sizeof(uint32_t));
    saveStringArray(vkStream, forMarshaling->ppEnabledLayerNames, forMarshaling->enabledLayerCount);
    vkStream->write((uint32_t*)&forMarshaling->enabledExtensionCount, sizeof(uint32_t));
    saveStringArray(vkStream, forMarshaling->ppEnabledExtensionNames, forMarshaling->enabledExtensionCount);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pEnabledFeatures;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pEnabledFeatures)
    {
        marshal_VkPhysicalDeviceFeatures(vkStream, rootType, (const VkPhysicalDeviceFeatures*)(forMarshaling->pEnabledFeatures));
    }
}

void unmarshal_VkDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceCreateFlags*)&forUnmarshaling->flags, sizeof(VkDeviceCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->queueCreateInfoCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->queueCreateInfoCount; ++i)
        {
            unmarshal_VkDeviceQueueCreateInfo(vkStream, rootType, (VkDeviceQueueCreateInfo*)(forUnmarshaling->pQueueCreateInfos + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->enabledLayerCount, sizeof(uint32_t));
    vkStream->loadStringArrayInPlace((char***)&forUnmarshaling->ppEnabledLayerNames);
    vkStream->read((uint32_t*)&forUnmarshaling->enabledExtensionCount, sizeof(uint32_t));
    vkStream->loadStringArrayInPlace((char***)&forUnmarshaling->ppEnabledExtensionNames);
    // WARNING PTR CHECK
    const VkPhysicalDeviceFeatures* check_pEnabledFeatures;
    (void)check_pEnabledFeatures;
    check_pEnabledFeatures = (const VkPhysicalDeviceFeatures*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pEnabledFeatures)
    {
        if (!(check_pEnabledFeatures))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pEnabledFeatures inconsistent between guest and host\n");
        }
        unmarshal_VkPhysicalDeviceFeatures(vkStream, rootType, (VkPhysicalDeviceFeatures*)(forUnmarshaling->pEnabledFeatures));
    }
}

void marshal_VkExtensionProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtensionProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((char*)forMarshaling->extensionName, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    vkStream->write((uint32_t*)&forMarshaling->specVersion, sizeof(uint32_t));
}

void unmarshal_VkExtensionProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExtensionProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((char*)forUnmarshaling->extensionName, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    vkStream->read((uint32_t*)&forUnmarshaling->specVersion, sizeof(uint32_t));
}

void marshal_VkLayerProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkLayerProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((char*)forMarshaling->layerName, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    vkStream->write((uint32_t*)&forMarshaling->specVersion, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->implementationVersion, sizeof(uint32_t));
    vkStream->write((char*)forMarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
}

void unmarshal_VkLayerProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkLayerProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((char*)forUnmarshaling->layerName, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    vkStream->read((uint32_t*)&forUnmarshaling->specVersion, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->implementationVersion, sizeof(uint32_t));
    vkStream->read((char*)forUnmarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
}

void marshal_VkSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubmitInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->waitSemaphoreCount, sizeof(uint32_t));
    if (forMarshaling->waitSemaphoreCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forMarshaling->waitSemaphoreCount * 8);
        vkStream->handleMapping()->mapHandles_VkSemaphore_u64(forMarshaling->pWaitSemaphores, cgen_var_0, forMarshaling->waitSemaphoreCount);
        vkStream->write((uint64_t*)cgen_var_0, forMarshaling->waitSemaphoreCount * 8);
    }
    vkStream->write((const VkPipelineStageFlags*)forMarshaling->pWaitDstStageMask, forMarshaling->waitSemaphoreCount * sizeof(const VkPipelineStageFlags));
    vkStream->write((uint32_t*)&forMarshaling->commandBufferCount, sizeof(uint32_t));
    if (forMarshaling->commandBufferCount)
    {
        uint64_t* cgen_var_1;
        vkStream->alloc((void**)&cgen_var_1, forMarshaling->commandBufferCount * 8);
        vkStream->handleMapping()->mapHandles_VkCommandBuffer_u64(forMarshaling->pCommandBuffers, cgen_var_1, forMarshaling->commandBufferCount);
        vkStream->write((uint64_t*)cgen_var_1, forMarshaling->commandBufferCount * 8);
    }
    vkStream->write((uint32_t*)&forMarshaling->signalSemaphoreCount, sizeof(uint32_t));
    if (forMarshaling->signalSemaphoreCount)
    {
        uint64_t* cgen_var_2;
        vkStream->alloc((void**)&cgen_var_2, forMarshaling->signalSemaphoreCount * 8);
        vkStream->handleMapping()->mapHandles_VkSemaphore_u64(forMarshaling->pSignalSemaphores, cgen_var_2, forMarshaling->signalSemaphoreCount);
        vkStream->write((uint64_t*)cgen_var_2, forMarshaling->signalSemaphoreCount * 8);
    }
}

void unmarshal_VkSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubmitInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->waitSemaphoreCount, sizeof(uint32_t));
    if (forUnmarshaling->waitSemaphoreCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forUnmarshaling->waitSemaphoreCount * 8);
        vkStream->read((uint64_t*)cgen_var_0, forUnmarshaling->waitSemaphoreCount * 8);
        vkStream->handleMapping()->mapHandles_u64_VkSemaphore(cgen_var_0, (VkSemaphore*)forUnmarshaling->pWaitSemaphores, forUnmarshaling->waitSemaphoreCount);
    }
    vkStream->read((VkPipelineStageFlags*)forUnmarshaling->pWaitDstStageMask, forUnmarshaling->waitSemaphoreCount * sizeof(const VkPipelineStageFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->commandBufferCount, sizeof(uint32_t));
    if (forUnmarshaling->commandBufferCount)
    {
        uint64_t* cgen_var_1;
        vkStream->alloc((void**)&cgen_var_1, forUnmarshaling->commandBufferCount * 8);
        vkStream->read((uint64_t*)cgen_var_1, forUnmarshaling->commandBufferCount * 8);
        vkStream->handleMapping()->mapHandles_u64_VkCommandBuffer(cgen_var_1, (VkCommandBuffer*)forUnmarshaling->pCommandBuffers, forUnmarshaling->commandBufferCount);
    }
    vkStream->read((uint32_t*)&forUnmarshaling->signalSemaphoreCount, sizeof(uint32_t));
    if (forUnmarshaling->signalSemaphoreCount)
    {
        uint64_t* cgen_var_2;
        vkStream->alloc((void**)&cgen_var_2, forUnmarshaling->signalSemaphoreCount * 8);
        vkStream->read((uint64_t*)cgen_var_2, forUnmarshaling->signalSemaphoreCount * 8);
        vkStream->handleMapping()->mapHandles_u64_VkSemaphore(cgen_var_2, (VkSemaphore*)forUnmarshaling->pSignalSemaphores, forUnmarshaling->signalSemaphoreCount);
    }
}

void marshal_VkMappedMemoryRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMappedMemoryRange* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkDeviceMemory_u64(&forMarshaling->memory, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
}

void unmarshal_VkMappedMemoryRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMappedMemoryRange* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDeviceMemory(&cgen_var_0, (VkDeviceMemory*)&forUnmarshaling->memory, 1);
    vkStream->read((VkDeviceSize*)&forUnmarshaling->offset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
}

void marshal_VkMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryAllocateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceSize*)&forMarshaling->allocationSize, sizeof(VkDeviceSize));
    vkStream->write((uint32_t*)&forMarshaling->memoryTypeIndex, sizeof(uint32_t));
}

void unmarshal_VkMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryAllocateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->allocationSize, sizeof(VkDeviceSize));
    vkStream->read((uint32_t*)&forUnmarshaling->memoryTypeIndex, sizeof(uint32_t));
}

void marshal_VkMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryRequirements* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->alignment, sizeof(VkDeviceSize));
    vkStream->write((uint32_t*)&forMarshaling->memoryTypeBits, sizeof(uint32_t));
}

void unmarshal_VkMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryRequirements* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->alignment, sizeof(VkDeviceSize));
    vkStream->read((uint32_t*)&forUnmarshaling->memoryTypeBits, sizeof(uint32_t));
}

void marshal_VkSparseMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseMemoryBind* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkDeviceSize*)&forMarshaling->resourceOffset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkDeviceMemory_u64(&forMarshaling->memory, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkDeviceSize*)&forMarshaling->memoryOffset, sizeof(VkDeviceSize));
    vkStream->write((VkSparseMemoryBindFlags*)&forMarshaling->flags, sizeof(VkSparseMemoryBindFlags));
}

void unmarshal_VkSparseMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseMemoryBind* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkDeviceSize*)&forUnmarshaling->resourceOffset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDeviceMemory(&cgen_var_0, (VkDeviceMemory*)&forUnmarshaling->memory, 1);
    vkStream->read((VkDeviceSize*)&forUnmarshaling->memoryOffset, sizeof(VkDeviceSize));
    vkStream->read((VkSparseMemoryBindFlags*)&forUnmarshaling->flags, sizeof(VkSparseMemoryBindFlags));
}

void marshal_VkSparseBufferMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseBufferMemoryBindInfo* forMarshaling)
{
    (void)rootType;
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->buffer, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->bindCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->bindCount; ++i)
        {
            marshal_VkSparseMemoryBind(vkStream, rootType, (const VkSparseMemoryBind*)(forMarshaling->pBinds + i));
        }
    }
}

void unmarshal_VkSparseBufferMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseBufferMemoryBindInfo* forUnmarshaling)
{
    (void)rootType;
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_0, (VkBuffer*)&forUnmarshaling->buffer, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->bindCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bindCount; ++i)
        {
            unmarshal_VkSparseMemoryBind(vkStream, rootType, (VkSparseMemoryBind*)(forUnmarshaling->pBinds + i));
        }
    }
}

void marshal_VkSparseImageOpaqueMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageOpaqueMemoryBindInfo* forMarshaling)
{
    (void)rootType;
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->image, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->bindCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->bindCount; ++i)
        {
            marshal_VkSparseMemoryBind(vkStream, rootType, (const VkSparseMemoryBind*)(forMarshaling->pBinds + i));
        }
    }
}

void unmarshal_VkSparseImageOpaqueMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageOpaqueMemoryBindInfo* forUnmarshaling)
{
    (void)rootType;
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->image, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->bindCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bindCount; ++i)
        {
            unmarshal_VkSparseMemoryBind(vkStream, rootType, (VkSparseMemoryBind*)(forUnmarshaling->pBinds + i));
        }
    }
}

void marshal_VkImageSubresource(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresource* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    vkStream->write((uint32_t*)&forMarshaling->mipLevel, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->arrayLayer, sizeof(uint32_t));
}

void unmarshal_VkImageSubresource(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageSubresource* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkImageAspectFlags*)&forUnmarshaling->aspectMask, sizeof(VkImageAspectFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->mipLevel, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->arrayLayer, sizeof(uint32_t));
}

void marshal_VkSparseImageMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryBind* forMarshaling)
{
    (void)rootType;
    marshal_VkImageSubresource(vkStream, rootType, (VkImageSubresource*)(&forMarshaling->subresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->offset));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkDeviceMemory_u64(&forMarshaling->memory, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkDeviceSize*)&forMarshaling->memoryOffset, sizeof(VkDeviceSize));
    vkStream->write((VkSparseMemoryBindFlags*)&forMarshaling->flags, sizeof(VkSparseMemoryBindFlags));
}

void unmarshal_VkSparseImageMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageMemoryBind* forUnmarshaling)
{
    (void)rootType;
    unmarshal_VkImageSubresource(vkStream, rootType, (VkImageSubresource*)(&forUnmarshaling->subresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->offset));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDeviceMemory(&cgen_var_0, (VkDeviceMemory*)&forUnmarshaling->memory, 1);
    vkStream->read((VkDeviceSize*)&forUnmarshaling->memoryOffset, sizeof(VkDeviceSize));
    vkStream->read((VkSparseMemoryBindFlags*)&forUnmarshaling->flags, sizeof(VkSparseMemoryBindFlags));
}

void marshal_VkSparseImageMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryBindInfo* forMarshaling)
{
    (void)rootType;
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->image, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->bindCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->bindCount; ++i)
        {
            marshal_VkSparseImageMemoryBind(vkStream, rootType, (const VkSparseImageMemoryBind*)(forMarshaling->pBinds + i));
        }
    }
}

void unmarshal_VkSparseImageMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageMemoryBindInfo* forUnmarshaling)
{
    (void)rootType;
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->image, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->bindCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bindCount; ++i)
        {
            unmarshal_VkSparseImageMemoryBind(vkStream, rootType, (VkSparseImageMemoryBind*)(forUnmarshaling->pBinds + i));
        }
    }
}

void marshal_VkBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindSparseInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->waitSemaphoreCount, sizeof(uint32_t));
    if (forMarshaling->waitSemaphoreCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forMarshaling->waitSemaphoreCount * 8);
        vkStream->handleMapping()->mapHandles_VkSemaphore_u64(forMarshaling->pWaitSemaphores, cgen_var_0, forMarshaling->waitSemaphoreCount);
        vkStream->write((uint64_t*)cgen_var_0, forMarshaling->waitSemaphoreCount * 8);
    }
    vkStream->write((uint32_t*)&forMarshaling->bufferBindCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->bufferBindCount; ++i)
        {
            marshal_VkSparseBufferMemoryBindInfo(vkStream, rootType, (const VkSparseBufferMemoryBindInfo*)(forMarshaling->pBufferBinds + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->imageOpaqueBindCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->imageOpaqueBindCount; ++i)
        {
            marshal_VkSparseImageOpaqueMemoryBindInfo(vkStream, rootType, (const VkSparseImageOpaqueMemoryBindInfo*)(forMarshaling->pImageOpaqueBinds + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->imageBindCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->imageBindCount; ++i)
        {
            marshal_VkSparseImageMemoryBindInfo(vkStream, rootType, (const VkSparseImageMemoryBindInfo*)(forMarshaling->pImageBinds + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->signalSemaphoreCount, sizeof(uint32_t));
    if (forMarshaling->signalSemaphoreCount)
    {
        uint64_t* cgen_var_1;
        vkStream->alloc((void**)&cgen_var_1, forMarshaling->signalSemaphoreCount * 8);
        vkStream->handleMapping()->mapHandles_VkSemaphore_u64(forMarshaling->pSignalSemaphores, cgen_var_1, forMarshaling->signalSemaphoreCount);
        vkStream->write((uint64_t*)cgen_var_1, forMarshaling->signalSemaphoreCount * 8);
    }
}

void unmarshal_VkBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindSparseInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->waitSemaphoreCount, sizeof(uint32_t));
    if (forUnmarshaling->waitSemaphoreCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forUnmarshaling->waitSemaphoreCount * 8);
        vkStream->read((uint64_t*)cgen_var_0, forUnmarshaling->waitSemaphoreCount * 8);
        vkStream->handleMapping()->mapHandles_u64_VkSemaphore(cgen_var_0, (VkSemaphore*)forUnmarshaling->pWaitSemaphores, forUnmarshaling->waitSemaphoreCount);
    }
    vkStream->read((uint32_t*)&forUnmarshaling->bufferBindCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bufferBindCount; ++i)
        {
            unmarshal_VkSparseBufferMemoryBindInfo(vkStream, rootType, (VkSparseBufferMemoryBindInfo*)(forUnmarshaling->pBufferBinds + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->imageOpaqueBindCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->imageOpaqueBindCount; ++i)
        {
            unmarshal_VkSparseImageOpaqueMemoryBindInfo(vkStream, rootType, (VkSparseImageOpaqueMemoryBindInfo*)(forUnmarshaling->pImageOpaqueBinds + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->imageBindCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->imageBindCount; ++i)
        {
            unmarshal_VkSparseImageMemoryBindInfo(vkStream, rootType, (VkSparseImageMemoryBindInfo*)(forUnmarshaling->pImageBinds + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->signalSemaphoreCount, sizeof(uint32_t));
    if (forUnmarshaling->signalSemaphoreCount)
    {
        uint64_t* cgen_var_1;
        vkStream->alloc((void**)&cgen_var_1, forUnmarshaling->signalSemaphoreCount * 8);
        vkStream->read((uint64_t*)cgen_var_1, forUnmarshaling->signalSemaphoreCount * 8);
        vkStream->handleMapping()->mapHandles_u64_VkSemaphore(cgen_var_1, (VkSemaphore*)forUnmarshaling->pSignalSemaphores, forUnmarshaling->signalSemaphoreCount);
    }
}

void marshal_VkSparseImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageFormatProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->imageGranularity));
    vkStream->write((VkSparseImageFormatFlags*)&forMarshaling->flags, sizeof(VkSparseImageFormatFlags));
}

void unmarshal_VkSparseImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageFormatProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkImageAspectFlags*)&forUnmarshaling->aspectMask, sizeof(VkImageAspectFlags));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->imageGranularity));
    vkStream->read((VkSparseImageFormatFlags*)&forUnmarshaling->flags, sizeof(VkSparseImageFormatFlags));
}

void marshal_VkSparseImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements* forMarshaling)
{
    (void)rootType;
    marshal_VkSparseImageFormatProperties(vkStream, rootType, (VkSparseImageFormatProperties*)(&forMarshaling->formatProperties));
    vkStream->write((uint32_t*)&forMarshaling->imageMipTailFirstLod, sizeof(uint32_t));
    vkStream->write((VkDeviceSize*)&forMarshaling->imageMipTailSize, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->imageMipTailOffset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->imageMipTailStride, sizeof(VkDeviceSize));
}

void unmarshal_VkSparseImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageMemoryRequirements* forUnmarshaling)
{
    (void)rootType;
    unmarshal_VkSparseImageFormatProperties(vkStream, rootType, (VkSparseImageFormatProperties*)(&forUnmarshaling->formatProperties));
    vkStream->read((uint32_t*)&forUnmarshaling->imageMipTailFirstLod, sizeof(uint32_t));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->imageMipTailSize, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->imageMipTailOffset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->imageMipTailStride, sizeof(VkDeviceSize));
}

void marshal_VkFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFenceCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkFenceCreateFlags*)&forMarshaling->flags, sizeof(VkFenceCreateFlags));
}

void unmarshal_VkFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFenceCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkFenceCreateFlags*)&forUnmarshaling->flags, sizeof(VkFenceCreateFlags));
}

void marshal_VkSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkSemaphoreCreateFlags*)&forMarshaling->flags, sizeof(VkSemaphoreCreateFlags));
}

void unmarshal_VkSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkSemaphoreCreateFlags*)&forUnmarshaling->flags, sizeof(VkSemaphoreCreateFlags));
}

void marshal_VkEventCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkEventCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkEventCreateFlags*)&forMarshaling->flags, sizeof(VkEventCreateFlags));
}

void unmarshal_VkEventCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkEventCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkEventCreateFlags*)&forUnmarshaling->flags, sizeof(VkEventCreateFlags));
}

void marshal_VkQueryPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueryPoolCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkQueryPoolCreateFlags*)&forMarshaling->flags, sizeof(VkQueryPoolCreateFlags));
    vkStream->write((VkQueryType*)&forMarshaling->queryType, sizeof(VkQueryType));
    vkStream->write((uint32_t*)&forMarshaling->queryCount, sizeof(uint32_t));
    vkStream->write((VkQueryPipelineStatisticFlags*)&forMarshaling->pipelineStatistics, sizeof(VkQueryPipelineStatisticFlags));
}

void unmarshal_VkQueryPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkQueryPoolCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkQueryPoolCreateFlags*)&forUnmarshaling->flags, sizeof(VkQueryPoolCreateFlags));
    vkStream->read((VkQueryType*)&forUnmarshaling->queryType, sizeof(VkQueryType));
    vkStream->read((uint32_t*)&forUnmarshaling->queryCount, sizeof(uint32_t));
    vkStream->read((VkQueryPipelineStatisticFlags*)&forUnmarshaling->pipelineStatistics, sizeof(VkQueryPipelineStatisticFlags));
}

void marshal_VkBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBufferCreateFlags*)&forMarshaling->flags, sizeof(VkBufferCreateFlags));
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    vkStream->write((VkBufferUsageFlags*)&forMarshaling->usage, sizeof(VkBufferUsageFlags));
    vkStream->write((VkSharingMode*)&forMarshaling->sharingMode, sizeof(VkSharingMode));
    vkStream->write((uint32_t*)&forMarshaling->queueFamilyIndexCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pQueueFamilyIndices;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pQueueFamilyIndices)
    {
        vkStream->write((const uint32_t*)forMarshaling->pQueueFamilyIndices, forMarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
    }
}

void unmarshal_VkBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBufferCreateFlags*)&forUnmarshaling->flags, sizeof(VkBufferCreateFlags));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
    vkStream->read((VkBufferUsageFlags*)&forUnmarshaling->usage, sizeof(VkBufferUsageFlags));
    vkStream->read((VkSharingMode*)&forUnmarshaling->sharingMode, sizeof(VkSharingMode));
    vkStream->read((uint32_t*)&forUnmarshaling->queueFamilyIndexCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const uint32_t* check_pQueueFamilyIndices;
    (void)check_pQueueFamilyIndices;
    check_pQueueFamilyIndices = (const uint32_t*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pQueueFamilyIndices)
    {
        if (!(check_pQueueFamilyIndices))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pQueueFamilyIndices inconsistent between guest and host\n");
        }
        vkStream->read((uint32_t*)forUnmarshaling->pQueueFamilyIndices, forUnmarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
    }
}

void marshal_VkBufferViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferViewCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBufferViewCreateFlags*)&forMarshaling->flags, sizeof(VkBufferViewCreateFlags));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->buffer, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    vkStream->write((VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->range, sizeof(VkDeviceSize));
}

void unmarshal_VkBufferViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferViewCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBufferViewCreateFlags*)&forUnmarshaling->flags, sizeof(VkBufferViewCreateFlags));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_0, (VkBuffer*)&forUnmarshaling->buffer, 1);
    vkStream->read((VkFormat*)&forUnmarshaling->format, sizeof(VkFormat));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->offset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->range, sizeof(VkDeviceSize));
}

void marshal_VkImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkImageCreateFlags*)&forMarshaling->flags, sizeof(VkImageCreateFlags));
    vkStream->write((VkImageType*)&forMarshaling->imageType, sizeof(VkImageType));
    vkStream->write((VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent));
    vkStream->write((uint32_t*)&forMarshaling->mipLevels, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->arrayLayers, sizeof(uint32_t));
    vkStream->write((VkSampleCountFlagBits*)&forMarshaling->samples, sizeof(VkSampleCountFlagBits));
    vkStream->write((VkImageTiling*)&forMarshaling->tiling, sizeof(VkImageTiling));
    vkStream->write((VkImageUsageFlags*)&forMarshaling->usage, sizeof(VkImageUsageFlags));
    vkStream->write((VkSharingMode*)&forMarshaling->sharingMode, sizeof(VkSharingMode));
    vkStream->write((uint32_t*)&forMarshaling->queueFamilyIndexCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pQueueFamilyIndices;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pQueueFamilyIndices)
    {
        vkStream->write((const uint32_t*)forMarshaling->pQueueFamilyIndices, forMarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
    }
    vkStream->write((VkImageLayout*)&forMarshaling->initialLayout, sizeof(VkImageLayout));
}

void unmarshal_VkImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkImageCreateFlags*)&forUnmarshaling->flags, sizeof(VkImageCreateFlags));
    vkStream->read((VkImageType*)&forUnmarshaling->imageType, sizeof(VkImageType));
    vkStream->read((VkFormat*)&forUnmarshaling->format, sizeof(VkFormat));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent));
    vkStream->read((uint32_t*)&forUnmarshaling->mipLevels, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->arrayLayers, sizeof(uint32_t));
    vkStream->read((VkSampleCountFlagBits*)&forUnmarshaling->samples, sizeof(VkSampleCountFlagBits));
    vkStream->read((VkImageTiling*)&forUnmarshaling->tiling, sizeof(VkImageTiling));
    vkStream->read((VkImageUsageFlags*)&forUnmarshaling->usage, sizeof(VkImageUsageFlags));
    vkStream->read((VkSharingMode*)&forUnmarshaling->sharingMode, sizeof(VkSharingMode));
    vkStream->read((uint32_t*)&forUnmarshaling->queueFamilyIndexCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const uint32_t* check_pQueueFamilyIndices;
    (void)check_pQueueFamilyIndices;
    check_pQueueFamilyIndices = (const uint32_t*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pQueueFamilyIndices)
    {
        if (!(check_pQueueFamilyIndices))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pQueueFamilyIndices inconsistent between guest and host\n");
        }
        vkStream->read((uint32_t*)forUnmarshaling->pQueueFamilyIndices, forUnmarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
    }
    vkStream->read((VkImageLayout*)&forUnmarshaling->initialLayout, sizeof(VkImageLayout));
}

void marshal_VkSubresourceLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceLayout* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->rowPitch, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->arrayPitch, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->depthPitch, sizeof(VkDeviceSize));
}

void unmarshal_VkSubresourceLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubresourceLayout* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkDeviceSize*)&forUnmarshaling->offset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->rowPitch, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->arrayPitch, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->depthPitch, sizeof(VkDeviceSize));
}

void marshal_VkComponentMapping(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkComponentMapping* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkComponentSwizzle*)&forMarshaling->r, sizeof(VkComponentSwizzle));
    vkStream->write((VkComponentSwizzle*)&forMarshaling->g, sizeof(VkComponentSwizzle));
    vkStream->write((VkComponentSwizzle*)&forMarshaling->b, sizeof(VkComponentSwizzle));
    vkStream->write((VkComponentSwizzle*)&forMarshaling->a, sizeof(VkComponentSwizzle));
}

void unmarshal_VkComponentMapping(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkComponentMapping* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkComponentSwizzle*)&forUnmarshaling->r, sizeof(VkComponentSwizzle));
    vkStream->read((VkComponentSwizzle*)&forUnmarshaling->g, sizeof(VkComponentSwizzle));
    vkStream->read((VkComponentSwizzle*)&forUnmarshaling->b, sizeof(VkComponentSwizzle));
    vkStream->read((VkComponentSwizzle*)&forUnmarshaling->a, sizeof(VkComponentSwizzle));
}

void marshal_VkImageViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageViewCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkImageViewCreateFlags*)&forMarshaling->flags, sizeof(VkImageViewCreateFlags));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->image, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkImageViewType*)&forMarshaling->viewType, sizeof(VkImageViewType));
    vkStream->write((VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    marshal_VkComponentMapping(vkStream, rootType, (VkComponentMapping*)(&forMarshaling->components));
    marshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forMarshaling->subresourceRange));
}

void unmarshal_VkImageViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageViewCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkImageViewCreateFlags*)&forUnmarshaling->flags, sizeof(VkImageViewCreateFlags));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->image, 1);
    vkStream->read((VkImageViewType*)&forUnmarshaling->viewType, sizeof(VkImageViewType));
    vkStream->read((VkFormat*)&forUnmarshaling->format, sizeof(VkFormat));
    unmarshal_VkComponentMapping(vkStream, rootType, (VkComponentMapping*)(&forUnmarshaling->components));
    unmarshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forUnmarshaling->subresourceRange));
}

void marshal_VkShaderModuleCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkShaderModuleCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkShaderModuleCreateFlags*)&forMarshaling->flags, sizeof(VkShaderModuleCreateFlags));
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->codeSize;
    vkStream->putBe64(cgen_var_0);
    vkStream->write((const uint32_t*)forMarshaling->pCode, (forMarshaling->codeSize / 4) * sizeof(const uint32_t));
}

void unmarshal_VkShaderModuleCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkShaderModuleCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkShaderModuleCreateFlags*)&forUnmarshaling->flags, sizeof(VkShaderModuleCreateFlags));
    forUnmarshaling->codeSize = (size_t)vkStream->getBe64();
    vkStream->read((uint32_t*)forUnmarshaling->pCode, (forUnmarshaling->codeSize / 4) * sizeof(const uint32_t));
}

void marshal_VkPipelineCacheCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCacheCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineCacheCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineCacheCreateFlags));
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->initialDataSize;
    vkStream->putBe64(cgen_var_0);
    vkStream->write((const void*)forMarshaling->pInitialData, forMarshaling->initialDataSize * sizeof(const uint8_t));
}

void unmarshal_VkPipelineCacheCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineCacheCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineCacheCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineCacheCreateFlags));
    forUnmarshaling->initialDataSize = (size_t)vkStream->getBe64();
    vkStream->read((void*)forUnmarshaling->pInitialData, forUnmarshaling->initialDataSize * sizeof(const uint8_t));
}

void marshal_VkSpecializationMapEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSpecializationMapEntry* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->constantID, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->offset, sizeof(uint32_t));
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->size;
    vkStream->putBe64(cgen_var_0);
}

void unmarshal_VkSpecializationMapEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSpecializationMapEntry* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->constantID, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->offset, sizeof(uint32_t));
    forUnmarshaling->size = (size_t)vkStream->getBe64();
}

void marshal_VkSpecializationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSpecializationInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->mapEntryCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->mapEntryCount; ++i)
        {
            marshal_VkSpecializationMapEntry(vkStream, rootType, (const VkSpecializationMapEntry*)(forMarshaling->pMapEntries + i));
        }
    }
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->dataSize;
    vkStream->putBe64(cgen_var_0);
    vkStream->write((const void*)forMarshaling->pData, forMarshaling->dataSize * sizeof(const uint8_t));
}

void unmarshal_VkSpecializationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSpecializationInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->mapEntryCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->mapEntryCount; ++i)
        {
            unmarshal_VkSpecializationMapEntry(vkStream, rootType, (VkSpecializationMapEntry*)(forUnmarshaling->pMapEntries + i));
        }
    }
    forUnmarshaling->dataSize = (size_t)vkStream->getBe64();
    vkStream->read((void*)forUnmarshaling->pData, forUnmarshaling->dataSize * sizeof(const uint8_t));
}

void marshal_VkPipelineShaderStageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineShaderStageCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineShaderStageCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineShaderStageCreateFlags));
    vkStream->write((VkShaderStageFlagBits*)&forMarshaling->stage, sizeof(VkShaderStageFlagBits));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkShaderModule_u64(&forMarshaling->module, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->putString(forMarshaling->pName);
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pSpecializationInfo;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pSpecializationInfo)
    {
        marshal_VkSpecializationInfo(vkStream, rootType, (const VkSpecializationInfo*)(forMarshaling->pSpecializationInfo));
    }
}

void unmarshal_VkPipelineShaderStageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineShaderStageCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineShaderStageCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineShaderStageCreateFlags));
    vkStream->read((VkShaderStageFlagBits*)&forUnmarshaling->stage, sizeof(VkShaderStageFlagBits));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkShaderModule(&cgen_var_0, (VkShaderModule*)&forUnmarshaling->module, 1);
    vkStream->loadStringInPlace((char**)&forUnmarshaling->pName);
    // WARNING PTR CHECK
    const VkSpecializationInfo* check_pSpecializationInfo;
    (void)check_pSpecializationInfo;
    check_pSpecializationInfo = (const VkSpecializationInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pSpecializationInfo)
    {
        if (!(check_pSpecializationInfo))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pSpecializationInfo inconsistent between guest and host\n");
        }
        unmarshal_VkSpecializationInfo(vkStream, rootType, (VkSpecializationInfo*)(forUnmarshaling->pSpecializationInfo));
    }
}

void marshal_VkComputePipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkComputePipelineCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineCreateFlags));
    marshal_VkPipelineShaderStageCreateInfo(vkStream, rootType, (VkPipelineShaderStageCreateInfo*)(&forMarshaling->stage));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkPipelineLayout_u64(&forMarshaling->layout, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkPipeline_u64(&forMarshaling->basePipelineHandle, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((int32_t*)&forMarshaling->basePipelineIndex, sizeof(int32_t));
}

void unmarshal_VkComputePipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkComputePipelineCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineCreateFlags));
    unmarshal_VkPipelineShaderStageCreateInfo(vkStream, rootType, (VkPipelineShaderStageCreateInfo*)(&forUnmarshaling->stage));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkPipelineLayout(&cgen_var_0, (VkPipelineLayout*)&forUnmarshaling->layout, 1);
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkPipeline(&cgen_var_1, (VkPipeline*)&forUnmarshaling->basePipelineHandle, 1);
    vkStream->read((int32_t*)&forUnmarshaling->basePipelineIndex, sizeof(int32_t));
}

void marshal_VkVertexInputBindingDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputBindingDescription* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->binding, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->stride, sizeof(uint32_t));
    vkStream->write((VkVertexInputRate*)&forMarshaling->inputRate, sizeof(VkVertexInputRate));
}

void unmarshal_VkVertexInputBindingDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkVertexInputBindingDescription* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->binding, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->stride, sizeof(uint32_t));
    vkStream->read((VkVertexInputRate*)&forUnmarshaling->inputRate, sizeof(VkVertexInputRate));
}

void marshal_VkVertexInputAttributeDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputAttributeDescription* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->location, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->binding, sizeof(uint32_t));
    vkStream->write((VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    vkStream->write((uint32_t*)&forMarshaling->offset, sizeof(uint32_t));
}

void unmarshal_VkVertexInputAttributeDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkVertexInputAttributeDescription* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->location, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->binding, sizeof(uint32_t));
    vkStream->read((VkFormat*)&forUnmarshaling->format, sizeof(VkFormat));
    vkStream->read((uint32_t*)&forUnmarshaling->offset, sizeof(uint32_t));
}

void marshal_VkPipelineVertexInputStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineVertexInputStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineVertexInputStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineVertexInputStateCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->vertexBindingDescriptionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->vertexBindingDescriptionCount; ++i)
        {
            marshal_VkVertexInputBindingDescription(vkStream, rootType, (const VkVertexInputBindingDescription*)(forMarshaling->pVertexBindingDescriptions + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->vertexAttributeDescriptionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->vertexAttributeDescriptionCount; ++i)
        {
            marshal_VkVertexInputAttributeDescription(vkStream, rootType, (const VkVertexInputAttributeDescription*)(forMarshaling->pVertexAttributeDescriptions + i));
        }
    }
}

void unmarshal_VkPipelineVertexInputStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineVertexInputStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineVertexInputStateCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineVertexInputStateCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->vertexBindingDescriptionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->vertexBindingDescriptionCount; ++i)
        {
            unmarshal_VkVertexInputBindingDescription(vkStream, rootType, (VkVertexInputBindingDescription*)(forUnmarshaling->pVertexBindingDescriptions + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->vertexAttributeDescriptionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->vertexAttributeDescriptionCount; ++i)
        {
            unmarshal_VkVertexInputAttributeDescription(vkStream, rootType, (VkVertexInputAttributeDescription*)(forUnmarshaling->pVertexAttributeDescriptions + i));
        }
    }
}

void marshal_VkPipelineInputAssemblyStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineInputAssemblyStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineInputAssemblyStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineInputAssemblyStateCreateFlags));
    vkStream->write((VkPrimitiveTopology*)&forMarshaling->topology, sizeof(VkPrimitiveTopology));
    vkStream->write((VkBool32*)&forMarshaling->primitiveRestartEnable, sizeof(VkBool32));
}

void unmarshal_VkPipelineInputAssemblyStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineInputAssemblyStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineInputAssemblyStateCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineInputAssemblyStateCreateFlags));
    vkStream->read((VkPrimitiveTopology*)&forUnmarshaling->topology, sizeof(VkPrimitiveTopology));
    vkStream->read((VkBool32*)&forUnmarshaling->primitiveRestartEnable, sizeof(VkBool32));
}

void marshal_VkPipelineTessellationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineTessellationStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineTessellationStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineTessellationStateCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->patchControlPoints, sizeof(uint32_t));
}

void unmarshal_VkPipelineTessellationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineTessellationStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineTessellationStateCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineTessellationStateCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->patchControlPoints, sizeof(uint32_t));
}

void marshal_VkViewport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkViewport* forMarshaling)
{
    (void)rootType;
    vkStream->write((float*)&forMarshaling->x, sizeof(float));
    vkStream->write((float*)&forMarshaling->y, sizeof(float));
    vkStream->write((float*)&forMarshaling->width, sizeof(float));
    vkStream->write((float*)&forMarshaling->height, sizeof(float));
    vkStream->write((float*)&forMarshaling->minDepth, sizeof(float));
    vkStream->write((float*)&forMarshaling->maxDepth, sizeof(float));
}

void unmarshal_VkViewport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkViewport* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((float*)&forUnmarshaling->x, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->y, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->width, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->height, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->minDepth, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->maxDepth, sizeof(float));
}

void marshal_VkPipelineViewportStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineViewportStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineViewportStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineViewportStateCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->viewportCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pViewports;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pViewports)
    {
        if (forMarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forMarshaling->viewportCount; ++i)
            {
                marshal_VkViewport(vkStream, rootType, (const VkViewport*)(forMarshaling->pViewports + i));
            }
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->scissorCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pScissors;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pScissors)
    {
        if (forMarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forMarshaling->scissorCount; ++i)
            {
                marshal_VkRect2D(vkStream, rootType, (const VkRect2D*)(forMarshaling->pScissors + i));
            }
        }
    }
}

void unmarshal_VkPipelineViewportStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineViewportStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineViewportStateCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineViewportStateCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->viewportCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const VkViewport* check_pViewports;
    (void)check_pViewports;
    check_pViewports = (const VkViewport*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pViewports)
    {
        if (!(check_pViewports))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pViewports inconsistent between guest and host\n");
        }
        if (forUnmarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->viewportCount; ++i)
            {
                unmarshal_VkViewport(vkStream, rootType, (VkViewport*)(forUnmarshaling->pViewports + i));
            }
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->scissorCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const VkRect2D* check_pScissors;
    (void)check_pScissors;
    check_pScissors = (const VkRect2D*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pScissors)
    {
        if (!(check_pScissors))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pScissors inconsistent between guest and host\n");
        }
        if (forUnmarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->scissorCount; ++i)
            {
                unmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(forUnmarshaling->pScissors + i));
            }
        }
    }
}

void marshal_VkPipelineRasterizationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineRasterizationStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineRasterizationStateCreateFlags));
    vkStream->write((VkBool32*)&forMarshaling->depthClampEnable, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->rasterizerDiscardEnable, sizeof(VkBool32));
    vkStream->write((VkPolygonMode*)&forMarshaling->polygonMode, sizeof(VkPolygonMode));
    vkStream->write((VkCullModeFlags*)&forMarshaling->cullMode, sizeof(VkCullModeFlags));
    vkStream->write((VkFrontFace*)&forMarshaling->frontFace, sizeof(VkFrontFace));
    vkStream->write((VkBool32*)&forMarshaling->depthBiasEnable, sizeof(VkBool32));
    vkStream->write((float*)&forMarshaling->depthBiasConstantFactor, sizeof(float));
    vkStream->write((float*)&forMarshaling->depthBiasClamp, sizeof(float));
    vkStream->write((float*)&forMarshaling->depthBiasSlopeFactor, sizeof(float));
    vkStream->write((float*)&forMarshaling->lineWidth, sizeof(float));
}

void unmarshal_VkPipelineRasterizationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRasterizationStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineRasterizationStateCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineRasterizationStateCreateFlags));
    vkStream->read((VkBool32*)&forUnmarshaling->depthClampEnable, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->rasterizerDiscardEnable, sizeof(VkBool32));
    vkStream->read((VkPolygonMode*)&forUnmarshaling->polygonMode, sizeof(VkPolygonMode));
    vkStream->read((VkCullModeFlags*)&forUnmarshaling->cullMode, sizeof(VkCullModeFlags));
    vkStream->read((VkFrontFace*)&forUnmarshaling->frontFace, sizeof(VkFrontFace));
    vkStream->read((VkBool32*)&forUnmarshaling->depthBiasEnable, sizeof(VkBool32));
    vkStream->read((float*)&forUnmarshaling->depthBiasConstantFactor, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->depthBiasClamp, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->depthBiasSlopeFactor, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->lineWidth, sizeof(float));
}

void marshal_VkPipelineMultisampleStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineMultisampleStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineMultisampleStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineMultisampleStateCreateFlags));
    vkStream->write((VkSampleCountFlagBits*)&forMarshaling->rasterizationSamples, sizeof(VkSampleCountFlagBits));
    vkStream->write((VkBool32*)&forMarshaling->sampleShadingEnable, sizeof(VkBool32));
    vkStream->write((float*)&forMarshaling->minSampleShading, sizeof(float));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pSampleMask;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pSampleMask)
    {
        vkStream->write((const VkSampleMask*)forMarshaling->pSampleMask, (((forMarshaling->rasterizationSamples) + 31) / 32) * sizeof(const VkSampleMask));
    }
    vkStream->write((VkBool32*)&forMarshaling->alphaToCoverageEnable, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->alphaToOneEnable, sizeof(VkBool32));
}

void unmarshal_VkPipelineMultisampleStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineMultisampleStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineMultisampleStateCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineMultisampleStateCreateFlags));
    vkStream->read((VkSampleCountFlagBits*)&forUnmarshaling->rasterizationSamples, sizeof(VkSampleCountFlagBits));
    vkStream->read((VkBool32*)&forUnmarshaling->sampleShadingEnable, sizeof(VkBool32));
    vkStream->read((float*)&forUnmarshaling->minSampleShading, sizeof(float));
    // WARNING PTR CHECK
    const VkSampleMask* check_pSampleMask;
    (void)check_pSampleMask;
    check_pSampleMask = (const VkSampleMask*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pSampleMask)
    {
        if (!(check_pSampleMask))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pSampleMask inconsistent between guest and host\n");
        }
        vkStream->read((VkSampleMask*)forUnmarshaling->pSampleMask, (((forUnmarshaling->rasterizationSamples) + 31) / 32) * sizeof(const VkSampleMask));
    }
    vkStream->read((VkBool32*)&forUnmarshaling->alphaToCoverageEnable, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->alphaToOneEnable, sizeof(VkBool32));
}

void marshal_VkStencilOpState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkStencilOpState* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStencilOp*)&forMarshaling->failOp, sizeof(VkStencilOp));
    vkStream->write((VkStencilOp*)&forMarshaling->passOp, sizeof(VkStencilOp));
    vkStream->write((VkStencilOp*)&forMarshaling->depthFailOp, sizeof(VkStencilOp));
    vkStream->write((VkCompareOp*)&forMarshaling->compareOp, sizeof(VkCompareOp));
    vkStream->write((uint32_t*)&forMarshaling->compareMask, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->writeMask, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->reference, sizeof(uint32_t));
}

void unmarshal_VkStencilOpState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkStencilOpState* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStencilOp*)&forUnmarshaling->failOp, sizeof(VkStencilOp));
    vkStream->read((VkStencilOp*)&forUnmarshaling->passOp, sizeof(VkStencilOp));
    vkStream->read((VkStencilOp*)&forUnmarshaling->depthFailOp, sizeof(VkStencilOp));
    vkStream->read((VkCompareOp*)&forUnmarshaling->compareOp, sizeof(VkCompareOp));
    vkStream->read((uint32_t*)&forUnmarshaling->compareMask, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->writeMask, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->reference, sizeof(uint32_t));
}

void marshal_VkPipelineDepthStencilStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineDepthStencilStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineDepthStencilStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineDepthStencilStateCreateFlags));
    vkStream->write((VkBool32*)&forMarshaling->depthTestEnable, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->depthWriteEnable, sizeof(VkBool32));
    vkStream->write((VkCompareOp*)&forMarshaling->depthCompareOp, sizeof(VkCompareOp));
    vkStream->write((VkBool32*)&forMarshaling->depthBoundsTestEnable, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->stencilTestEnable, sizeof(VkBool32));
    marshal_VkStencilOpState(vkStream, rootType, (VkStencilOpState*)(&forMarshaling->front));
    marshal_VkStencilOpState(vkStream, rootType, (VkStencilOpState*)(&forMarshaling->back));
    vkStream->write((float*)&forMarshaling->minDepthBounds, sizeof(float));
    vkStream->write((float*)&forMarshaling->maxDepthBounds, sizeof(float));
}

void unmarshal_VkPipelineDepthStencilStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineDepthStencilStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineDepthStencilStateCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineDepthStencilStateCreateFlags));
    vkStream->read((VkBool32*)&forUnmarshaling->depthTestEnable, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->depthWriteEnable, sizeof(VkBool32));
    vkStream->read((VkCompareOp*)&forUnmarshaling->depthCompareOp, sizeof(VkCompareOp));
    vkStream->read((VkBool32*)&forUnmarshaling->depthBoundsTestEnable, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->stencilTestEnable, sizeof(VkBool32));
    unmarshal_VkStencilOpState(vkStream, rootType, (VkStencilOpState*)(&forUnmarshaling->front));
    unmarshal_VkStencilOpState(vkStream, rootType, (VkStencilOpState*)(&forUnmarshaling->back));
    vkStream->read((float*)&forUnmarshaling->minDepthBounds, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->maxDepthBounds, sizeof(float));
}

void marshal_VkPipelineColorBlendAttachmentState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorBlendAttachmentState* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkBool32*)&forMarshaling->blendEnable, sizeof(VkBool32));
    vkStream->write((VkBlendFactor*)&forMarshaling->srcColorBlendFactor, sizeof(VkBlendFactor));
    vkStream->write((VkBlendFactor*)&forMarshaling->dstColorBlendFactor, sizeof(VkBlendFactor));
    vkStream->write((VkBlendOp*)&forMarshaling->colorBlendOp, sizeof(VkBlendOp));
    vkStream->write((VkBlendFactor*)&forMarshaling->srcAlphaBlendFactor, sizeof(VkBlendFactor));
    vkStream->write((VkBlendFactor*)&forMarshaling->dstAlphaBlendFactor, sizeof(VkBlendFactor));
    vkStream->write((VkBlendOp*)&forMarshaling->alphaBlendOp, sizeof(VkBlendOp));
    vkStream->write((VkColorComponentFlags*)&forMarshaling->colorWriteMask, sizeof(VkColorComponentFlags));
}

void unmarshal_VkPipelineColorBlendAttachmentState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineColorBlendAttachmentState* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkBool32*)&forUnmarshaling->blendEnable, sizeof(VkBool32));
    vkStream->read((VkBlendFactor*)&forUnmarshaling->srcColorBlendFactor, sizeof(VkBlendFactor));
    vkStream->read((VkBlendFactor*)&forUnmarshaling->dstColorBlendFactor, sizeof(VkBlendFactor));
    vkStream->read((VkBlendOp*)&forUnmarshaling->colorBlendOp, sizeof(VkBlendOp));
    vkStream->read((VkBlendFactor*)&forUnmarshaling->srcAlphaBlendFactor, sizeof(VkBlendFactor));
    vkStream->read((VkBlendFactor*)&forUnmarshaling->dstAlphaBlendFactor, sizeof(VkBlendFactor));
    vkStream->read((VkBlendOp*)&forUnmarshaling->alphaBlendOp, sizeof(VkBlendOp));
    vkStream->read((VkColorComponentFlags*)&forUnmarshaling->colorWriteMask, sizeof(VkColorComponentFlags));
}

void marshal_VkPipelineColorBlendStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorBlendStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineColorBlendStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineColorBlendStateCreateFlags));
    vkStream->write((VkBool32*)&forMarshaling->logicOpEnable, sizeof(VkBool32));
    vkStream->write((VkLogicOp*)&forMarshaling->logicOp, sizeof(VkLogicOp));
    vkStream->write((uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->attachmentCount; ++i)
        {
            marshal_VkPipelineColorBlendAttachmentState(vkStream, rootType, (const VkPipelineColorBlendAttachmentState*)(forMarshaling->pAttachments + i));
        }
    }
    vkStream->write((float*)forMarshaling->blendConstants, 4 * sizeof(float));
}

void unmarshal_VkPipelineColorBlendStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineColorBlendStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineColorBlendStateCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineColorBlendStateCreateFlags));
    vkStream->read((VkBool32*)&forUnmarshaling->logicOpEnable, sizeof(VkBool32));
    vkStream->read((VkLogicOp*)&forUnmarshaling->logicOp, sizeof(VkLogicOp));
    vkStream->read((uint32_t*)&forUnmarshaling->attachmentCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->attachmentCount; ++i)
        {
            unmarshal_VkPipelineColorBlendAttachmentState(vkStream, rootType, (VkPipelineColorBlendAttachmentState*)(forUnmarshaling->pAttachments + i));
        }
    }
    vkStream->read((float*)forUnmarshaling->blendConstants, 4 * sizeof(float));
}

void marshal_VkPipelineDynamicStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineDynamicStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineDynamicStateCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineDynamicStateCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->dynamicStateCount, sizeof(uint32_t));
    vkStream->write((const VkDynamicState*)forMarshaling->pDynamicStates, forMarshaling->dynamicStateCount * sizeof(const VkDynamicState));
}

void unmarshal_VkPipelineDynamicStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineDynamicStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineDynamicStateCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineDynamicStateCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->dynamicStateCount, sizeof(uint32_t));
    vkStream->read((VkDynamicState*)forUnmarshaling->pDynamicStates, forUnmarshaling->dynamicStateCount * sizeof(const VkDynamicState));
}

void marshal_VkGraphicsPipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkGraphicsPipelineCreateInfo* forMarshaling)
{
    (void)rootType;
    uint32_t hasRasterization = 1;
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        hasRasterization = ((((0 == forMarshaling->pRasterizationState)) ? (0) : (!((*(forMarshaling->pRasterizationState)).rasterizerDiscardEnable))) || (((0 == forMarshaling->pDynamicState)) ? (0) : (arrayany((*(forMarshaling->pDynamicState)).pDynamicStates, 0, (*(forMarshaling->pDynamicState)).dynamicStateCount, [](VkDynamicState s) { return (s == VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE); }))));
        uint32_t cgen_var_0 = (uint32_t)hasRasterization;
        vkStream->putBe32(cgen_var_0);
    }
    uint32_t hasTessellation = 1;
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        hasTessellation = arrayany(forMarshaling->pStages, 0, forMarshaling->stageCount, [](VkPipelineShaderStageCreateInfo s) { return ((s.stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT) || (s.stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)); });
        uint32_t cgen_var_0 = (uint32_t)hasTessellation;
        vkStream->putBe32(cgen_var_0);
    }
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->stageCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->stageCount; ++i)
        {
            marshal_VkPipelineShaderStageCreateInfo(vkStream, rootType, (const VkPipelineShaderStageCreateInfo*)(forMarshaling->pStages + i));
        }
    }
    // WARNING PTR CHECK
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pVertexInputState;
        vkStream->putBe64(cgen_var_0);
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || forMarshaling->pVertexInputState))
    {
        marshal_VkPipelineVertexInputStateCreateInfo(vkStream, rootType, (const VkPipelineVertexInputStateCreateInfo*)(forMarshaling->pVertexInputState));
    }
    // WARNING PTR CHECK
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pInputAssemblyState;
        vkStream->putBe64(cgen_var_0);
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || forMarshaling->pInputAssemblyState))
    {
        marshal_VkPipelineInputAssemblyStateCreateInfo(vkStream, rootType, (const VkPipelineInputAssemblyStateCreateInfo*)(forMarshaling->pInputAssemblyState));
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pTessellationState;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pTessellationState)
    {
        if (hasTessellation)
        {
            marshal_VkPipelineTessellationStateCreateInfo(vkStream, rootType, (const VkPipelineTessellationStateCreateInfo*)(forMarshaling->pTessellationState));
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pViewportState;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pViewportState)
    {
        if (hasRasterization)
        {
            marshal_VkPipelineViewportStateCreateInfo(vkStream, rootType, (const VkPipelineViewportStateCreateInfo*)(forMarshaling->pViewportState));
        }
    }
    // WARNING PTR CHECK
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        uint64_t cgen_var_1_0 = (uint64_t)(uintptr_t)forMarshaling->pRasterizationState;
        vkStream->putBe64(cgen_var_1_0);
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || forMarshaling->pRasterizationState))
    {
        marshal_VkPipelineRasterizationStateCreateInfo(vkStream, rootType, (const VkPipelineRasterizationStateCreateInfo*)(forMarshaling->pRasterizationState));
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_2 = (uint64_t)(uintptr_t)forMarshaling->pMultisampleState;
    vkStream->putBe64(cgen_var_2);
    if (forMarshaling->pMultisampleState)
    {
        if (hasRasterization)
        {
            marshal_VkPipelineMultisampleStateCreateInfo(vkStream, rootType, (const VkPipelineMultisampleStateCreateInfo*)(forMarshaling->pMultisampleState));
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_3 = (uint64_t)(uintptr_t)forMarshaling->pDepthStencilState;
    vkStream->putBe64(cgen_var_3);
    if (forMarshaling->pDepthStencilState)
    {
        if (hasRasterization)
        {
            marshal_VkPipelineDepthStencilStateCreateInfo(vkStream, rootType, (const VkPipelineDepthStencilStateCreateInfo*)(forMarshaling->pDepthStencilState));
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_4 = (uint64_t)(uintptr_t)forMarshaling->pColorBlendState;
    vkStream->putBe64(cgen_var_4);
    if (forMarshaling->pColorBlendState)
    {
        if (hasRasterization)
        {
            marshal_VkPipelineColorBlendStateCreateInfo(vkStream, rootType, (const VkPipelineColorBlendStateCreateInfo*)(forMarshaling->pColorBlendState));
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_5 = (uint64_t)(uintptr_t)forMarshaling->pDynamicState;
    vkStream->putBe64(cgen_var_5);
    if (forMarshaling->pDynamicState)
    {
        marshal_VkPipelineDynamicStateCreateInfo(vkStream, rootType, (const VkPipelineDynamicStateCreateInfo*)(forMarshaling->pDynamicState));
    }
    uint64_t cgen_var_6;
    vkStream->handleMapping()->mapHandles_VkPipelineLayout_u64(&forMarshaling->layout, &cgen_var_6, 1);
    vkStream->write((uint64_t*)&cgen_var_6, 1 * 8);
    uint64_t cgen_var_7;
    vkStream->handleMapping()->mapHandles_VkRenderPass_u64(&forMarshaling->renderPass, &cgen_var_7, 1);
    vkStream->write((uint64_t*)&cgen_var_7, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->subpass, sizeof(uint32_t));
    uint64_t cgen_var_8;
    vkStream->handleMapping()->mapHandles_VkPipeline_u64(&forMarshaling->basePipelineHandle, &cgen_var_8, 1);
    vkStream->write((uint64_t*)&cgen_var_8, 1 * 8);
    vkStream->write((int32_t*)&forMarshaling->basePipelineIndex, sizeof(int32_t));
}

void unmarshal_VkGraphicsPipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkGraphicsPipelineCreateInfo* forUnmarshaling)
{
    (void)rootType;
    uint32_t hasRasterization = 1;
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        hasRasterization = (const uint32_t)vkStream->getBe32();
    }
    uint32_t hasTessellation = 1;
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        hasTessellation = (const uint32_t)vkStream->getBe32();
    }
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->stageCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->stageCount; ++i)
        {
            unmarshal_VkPipelineShaderStageCreateInfo(vkStream, rootType, (VkPipelineShaderStageCreateInfo*)(forUnmarshaling->pStages + i));
        }
    }
    // WARNING PTR CHECK
    const VkPipelineVertexInputStateCreateInfo* check_pVertexInputState;
    (void)check_pVertexInputState;
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        check_pVertexInputState = (const VkPipelineVertexInputStateCreateInfo*)(uintptr_t)vkStream->getBe64();
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || forUnmarshaling->pVertexInputState))
    {
        unmarshal_VkPipelineVertexInputStateCreateInfo(vkStream, rootType, (VkPipelineVertexInputStateCreateInfo*)(forUnmarshaling->pVertexInputState));
    }
    // WARNING PTR CHECK
    const VkPipelineInputAssemblyStateCreateInfo* check_pInputAssemblyState;
    (void)check_pInputAssemblyState;
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        check_pInputAssemblyState = (const VkPipelineInputAssemblyStateCreateInfo*)(uintptr_t)vkStream->getBe64();
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || forUnmarshaling->pInputAssemblyState))
    {
        unmarshal_VkPipelineInputAssemblyStateCreateInfo(vkStream, rootType, (VkPipelineInputAssemblyStateCreateInfo*)(forUnmarshaling->pInputAssemblyState));
    }
    // WARNING PTR CHECK
    const VkPipelineTessellationStateCreateInfo* check_pTessellationState;
    (void)check_pTessellationState;
    check_pTessellationState = (const VkPipelineTessellationStateCreateInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pTessellationState)
    {
        if (!(check_pTessellationState))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pTessellationState inconsistent between guest and host\n");
        }
        if (hasTessellation)
        {
            unmarshal_VkPipelineTessellationStateCreateInfo(vkStream, rootType, (VkPipelineTessellationStateCreateInfo*)(forUnmarshaling->pTessellationState));
        }
        else
        {
            forUnmarshaling->pTessellationState = 0;
        }
    }
    // WARNING PTR CHECK
    const VkPipelineViewportStateCreateInfo* check_pViewportState;
    (void)check_pViewportState;
    check_pViewportState = (const VkPipelineViewportStateCreateInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pViewportState)
    {
        if (!(check_pViewportState))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pViewportState inconsistent between guest and host\n");
        }
        if (hasRasterization)
        {
            unmarshal_VkPipelineViewportStateCreateInfo(vkStream, rootType, (VkPipelineViewportStateCreateInfo*)(forUnmarshaling->pViewportState));
        }
        else
        {
            forUnmarshaling->pViewportState = 0;
        }
    }
    // WARNING PTR CHECK
    const VkPipelineRasterizationStateCreateInfo* check_pRasterizationState;
    (void)check_pRasterizationState;
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT)
    {
        check_pRasterizationState = (const VkPipelineRasterizationStateCreateInfo*)(uintptr_t)vkStream->getBe64();
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || forUnmarshaling->pRasterizationState))
    {
        unmarshal_VkPipelineRasterizationStateCreateInfo(vkStream, rootType, (VkPipelineRasterizationStateCreateInfo*)(forUnmarshaling->pRasterizationState));
    }
    // WARNING PTR CHECK
    const VkPipelineMultisampleStateCreateInfo* check_pMultisampleState;
    (void)check_pMultisampleState;
    check_pMultisampleState = (const VkPipelineMultisampleStateCreateInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pMultisampleState)
    {
        if (!(check_pMultisampleState))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pMultisampleState inconsistent between guest and host\n");
        }
        if (hasRasterization)
        {
            unmarshal_VkPipelineMultisampleStateCreateInfo(vkStream, rootType, (VkPipelineMultisampleStateCreateInfo*)(forUnmarshaling->pMultisampleState));
        }
        else
        {
            forUnmarshaling->pMultisampleState = 0;
        }
    }
    // WARNING PTR CHECK
    const VkPipelineDepthStencilStateCreateInfo* check_pDepthStencilState;
    (void)check_pDepthStencilState;
    check_pDepthStencilState = (const VkPipelineDepthStencilStateCreateInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pDepthStencilState)
    {
        if (!(check_pDepthStencilState))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pDepthStencilState inconsistent between guest and host\n");
        }
        if (hasRasterization)
        {
            unmarshal_VkPipelineDepthStencilStateCreateInfo(vkStream, rootType, (VkPipelineDepthStencilStateCreateInfo*)(forUnmarshaling->pDepthStencilState));
        }
        else
        {
            forUnmarshaling->pDepthStencilState = 0;
        }
    }
    // WARNING PTR CHECK
    const VkPipelineColorBlendStateCreateInfo* check_pColorBlendState;
    (void)check_pColorBlendState;
    check_pColorBlendState = (const VkPipelineColorBlendStateCreateInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pColorBlendState)
    {
        if (!(check_pColorBlendState))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pColorBlendState inconsistent between guest and host\n");
        }
        if (hasRasterization)
        {
            unmarshal_VkPipelineColorBlendStateCreateInfo(vkStream, rootType, (VkPipelineColorBlendStateCreateInfo*)(forUnmarshaling->pColorBlendState));
        }
        else
        {
            forUnmarshaling->pColorBlendState = 0;
        }
    }
    // WARNING PTR CHECK
    const VkPipelineDynamicStateCreateInfo* check_pDynamicState;
    (void)check_pDynamicState;
    check_pDynamicState = (const VkPipelineDynamicStateCreateInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pDynamicState)
    {
        if (!(check_pDynamicState))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pDynamicState inconsistent between guest and host\n");
        }
        unmarshal_VkPipelineDynamicStateCreateInfo(vkStream, rootType, (VkPipelineDynamicStateCreateInfo*)(forUnmarshaling->pDynamicState));
    }
    uint64_t cgen_var_6;
    vkStream->read((uint64_t*)&cgen_var_6, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkPipelineLayout(&cgen_var_6, (VkPipelineLayout*)&forUnmarshaling->layout, 1);
    uint64_t cgen_var_7;
    vkStream->read((uint64_t*)&cgen_var_7, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkRenderPass(&cgen_var_7, (VkRenderPass*)&forUnmarshaling->renderPass, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->subpass, sizeof(uint32_t));
    uint64_t cgen_var_8;
    vkStream->read((uint64_t*)&cgen_var_8, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkPipeline(&cgen_var_8, (VkPipeline*)&forUnmarshaling->basePipelineHandle, 1);
    vkStream->read((int32_t*)&forUnmarshaling->basePipelineIndex, sizeof(int32_t));
}

void marshal_VkPushConstantRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushConstantRange* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkShaderStageFlags*)&forMarshaling->stageFlags, sizeof(VkShaderStageFlags));
    vkStream->write((uint32_t*)&forMarshaling->offset, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->size, sizeof(uint32_t));
}

void unmarshal_VkPushConstantRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPushConstantRange* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkShaderStageFlags*)&forUnmarshaling->stageFlags, sizeof(VkShaderStageFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->offset, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->size, sizeof(uint32_t));
}

void marshal_VkPipelineLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineLayoutCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineLayoutCreateFlags*)&forMarshaling->flags, sizeof(VkPipelineLayoutCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->setLayoutCount, sizeof(uint32_t));
    if (forMarshaling->setLayoutCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forMarshaling->setLayoutCount * 8);
        vkStream->handleMapping()->mapHandles_VkDescriptorSetLayout_u64(forMarshaling->pSetLayouts, cgen_var_0, forMarshaling->setLayoutCount);
        vkStream->write((uint64_t*)cgen_var_0, forMarshaling->setLayoutCount * 8);
    }
    vkStream->write((uint32_t*)&forMarshaling->pushConstantRangeCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->pushConstantRangeCount; ++i)
        {
            marshal_VkPushConstantRange(vkStream, rootType, (const VkPushConstantRange*)(forMarshaling->pPushConstantRanges + i));
        }
    }
}

void unmarshal_VkPipelineLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineLayoutCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineLayoutCreateFlags*)&forUnmarshaling->flags, sizeof(VkPipelineLayoutCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->setLayoutCount, sizeof(uint32_t));
    if (forUnmarshaling->setLayoutCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forUnmarshaling->setLayoutCount * 8);
        vkStream->read((uint64_t*)cgen_var_0, forUnmarshaling->setLayoutCount * 8);
        vkStream->handleMapping()->mapHandles_u64_VkDescriptorSetLayout(cgen_var_0, (VkDescriptorSetLayout*)forUnmarshaling->pSetLayouts, forUnmarshaling->setLayoutCount);
    }
    vkStream->read((uint32_t*)&forUnmarshaling->pushConstantRangeCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->pushConstantRangeCount; ++i)
        {
            unmarshal_VkPushConstantRange(vkStream, rootType, (VkPushConstantRange*)(forUnmarshaling->pPushConstantRanges + i));
        }
    }
}

void marshal_VkSamplerCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkSamplerCreateFlags*)&forMarshaling->flags, sizeof(VkSamplerCreateFlags));
    vkStream->write((VkFilter*)&forMarshaling->magFilter, sizeof(VkFilter));
    vkStream->write((VkFilter*)&forMarshaling->minFilter, sizeof(VkFilter));
    vkStream->write((VkSamplerMipmapMode*)&forMarshaling->mipmapMode, sizeof(VkSamplerMipmapMode));
    vkStream->write((VkSamplerAddressMode*)&forMarshaling->addressModeU, sizeof(VkSamplerAddressMode));
    vkStream->write((VkSamplerAddressMode*)&forMarshaling->addressModeV, sizeof(VkSamplerAddressMode));
    vkStream->write((VkSamplerAddressMode*)&forMarshaling->addressModeW, sizeof(VkSamplerAddressMode));
    vkStream->write((float*)&forMarshaling->mipLodBias, sizeof(float));
    vkStream->write((VkBool32*)&forMarshaling->anisotropyEnable, sizeof(VkBool32));
    vkStream->write((float*)&forMarshaling->maxAnisotropy, sizeof(float));
    vkStream->write((VkBool32*)&forMarshaling->compareEnable, sizeof(VkBool32));
    vkStream->write((VkCompareOp*)&forMarshaling->compareOp, sizeof(VkCompareOp));
    vkStream->write((float*)&forMarshaling->minLod, sizeof(float));
    vkStream->write((float*)&forMarshaling->maxLod, sizeof(float));
    vkStream->write((VkBorderColor*)&forMarshaling->borderColor, sizeof(VkBorderColor));
    vkStream->write((VkBool32*)&forMarshaling->unnormalizedCoordinates, sizeof(VkBool32));
}

void unmarshal_VkSamplerCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkSamplerCreateFlags*)&forUnmarshaling->flags, sizeof(VkSamplerCreateFlags));
    vkStream->read((VkFilter*)&forUnmarshaling->magFilter, sizeof(VkFilter));
    vkStream->read((VkFilter*)&forUnmarshaling->minFilter, sizeof(VkFilter));
    vkStream->read((VkSamplerMipmapMode*)&forUnmarshaling->mipmapMode, sizeof(VkSamplerMipmapMode));
    vkStream->read((VkSamplerAddressMode*)&forUnmarshaling->addressModeU, sizeof(VkSamplerAddressMode));
    vkStream->read((VkSamplerAddressMode*)&forUnmarshaling->addressModeV, sizeof(VkSamplerAddressMode));
    vkStream->read((VkSamplerAddressMode*)&forUnmarshaling->addressModeW, sizeof(VkSamplerAddressMode));
    vkStream->read((float*)&forUnmarshaling->mipLodBias, sizeof(float));
    vkStream->read((VkBool32*)&forUnmarshaling->anisotropyEnable, sizeof(VkBool32));
    vkStream->read((float*)&forUnmarshaling->maxAnisotropy, sizeof(float));
    vkStream->read((VkBool32*)&forUnmarshaling->compareEnable, sizeof(VkBool32));
    vkStream->read((VkCompareOp*)&forUnmarshaling->compareOp, sizeof(VkCompareOp));
    vkStream->read((float*)&forUnmarshaling->minLod, sizeof(float));
    vkStream->read((float*)&forUnmarshaling->maxLod, sizeof(float));
    vkStream->read((VkBorderColor*)&forUnmarshaling->borderColor, sizeof(VkBorderColor));
    vkStream->read((VkBool32*)&forUnmarshaling->unnormalizedCoordinates, sizeof(VkBool32));
}

void marshal_VkCopyDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyDescriptorSet* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkDescriptorSet_u64(&forMarshaling->srcSet, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->srcBinding, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->srcArrayElement, sizeof(uint32_t));
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkDescriptorSet_u64(&forMarshaling->dstSet, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->dstBinding, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->dstArrayElement, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->descriptorCount, sizeof(uint32_t));
}

void unmarshal_VkCopyDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyDescriptorSet* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDescriptorSet(&cgen_var_0, (VkDescriptorSet*)&forUnmarshaling->srcSet, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->srcBinding, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->srcArrayElement, sizeof(uint32_t));
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDescriptorSet(&cgen_var_1, (VkDescriptorSet*)&forUnmarshaling->dstSet, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->dstBinding, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->dstArrayElement, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->descriptorCount, sizeof(uint32_t));
}

void marshal_VkDescriptorBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorBufferInfo* forMarshaling)
{
    (void)rootType;
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->buffer, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->range, sizeof(VkDeviceSize));
}

void unmarshal_VkDescriptorBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorBufferInfo* forUnmarshaling)
{
    (void)rootType;
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_0, (VkBuffer*)&forUnmarshaling->buffer, 1);
    vkStream->read((VkDeviceSize*)&forUnmarshaling->offset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->range, sizeof(VkDeviceSize));
}

void marshal_VkDescriptorImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorImageInfo* forMarshaling)
{
    (void)rootType;
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkSampler_u64(&forMarshaling->sampler, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkImageView_u64(&forMarshaling->imageView, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->imageLayout, sizeof(VkImageLayout));
}

void unmarshal_VkDescriptorImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorImageInfo* forUnmarshaling)
{
    (void)rootType;
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkSampler(&cgen_var_0, (VkSampler*)&forUnmarshaling->sampler, 1);
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImageView(&cgen_var_1, (VkImageView*)&forUnmarshaling->imageView, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->imageLayout, sizeof(VkImageLayout));
}

void marshal_VkDescriptorPoolSize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolSize* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkDescriptorType*)&forMarshaling->type, sizeof(VkDescriptorType));
    vkStream->write((uint32_t*)&forMarshaling->descriptorCount, sizeof(uint32_t));
}

void unmarshal_VkDescriptorPoolSize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorPoolSize* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkDescriptorType*)&forUnmarshaling->type, sizeof(VkDescriptorType));
    vkStream->read((uint32_t*)&forUnmarshaling->descriptorCount, sizeof(uint32_t));
}

void marshal_VkDescriptorPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDescriptorPoolCreateFlags*)&forMarshaling->flags, sizeof(VkDescriptorPoolCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->maxSets, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->poolSizeCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->poolSizeCount; ++i)
        {
            marshal_VkDescriptorPoolSize(vkStream, rootType, (const VkDescriptorPoolSize*)(forMarshaling->pPoolSizes + i));
        }
    }
}

void unmarshal_VkDescriptorPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorPoolCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDescriptorPoolCreateFlags*)&forUnmarshaling->flags, sizeof(VkDescriptorPoolCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->maxSets, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->poolSizeCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->poolSizeCount; ++i)
        {
            unmarshal_VkDescriptorPoolSize(vkStream, rootType, (VkDescriptorPoolSize*)(forUnmarshaling->pPoolSizes + i));
        }
    }
}

void marshal_VkDescriptorSetAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetAllocateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkDescriptorPool_u64(&forMarshaling->descriptorPool, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->descriptorSetCount, sizeof(uint32_t));
    if (forMarshaling->descriptorSetCount)
    {
        uint64_t* cgen_var_1;
        vkStream->alloc((void**)&cgen_var_1, forMarshaling->descriptorSetCount * 8);
        vkStream->handleMapping()->mapHandles_VkDescriptorSetLayout_u64(forMarshaling->pSetLayouts, cgen_var_1, forMarshaling->descriptorSetCount);
        vkStream->write((uint64_t*)cgen_var_1, forMarshaling->descriptorSetCount * 8);
    }
}

void unmarshal_VkDescriptorSetAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetAllocateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDescriptorPool(&cgen_var_0, (VkDescriptorPool*)&forUnmarshaling->descriptorPool, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->descriptorSetCount, sizeof(uint32_t));
    if (forUnmarshaling->descriptorSetCount)
    {
        uint64_t* cgen_var_1;
        vkStream->alloc((void**)&cgen_var_1, forUnmarshaling->descriptorSetCount * 8);
        vkStream->read((uint64_t*)cgen_var_1, forUnmarshaling->descriptorSetCount * 8);
        vkStream->handleMapping()->mapHandles_u64_VkDescriptorSetLayout(cgen_var_1, (VkDescriptorSetLayout*)forUnmarshaling->pSetLayouts, forUnmarshaling->descriptorSetCount);
    }
}

void marshal_VkDescriptorSetLayoutBinding(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBinding* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->binding, sizeof(uint32_t));
    vkStream->write((VkDescriptorType*)&forMarshaling->descriptorType, sizeof(VkDescriptorType));
    vkStream->write((uint32_t*)&forMarshaling->descriptorCount, sizeof(uint32_t));
    vkStream->write((VkShaderStageFlags*)&forMarshaling->stageFlags, sizeof(VkShaderStageFlags));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pImmutableSamplers;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pImmutableSamplers)
    {
        if (forMarshaling->descriptorCount)
        {
            uint64_t* cgen_var_0_0;
            vkStream->alloc((void**)&cgen_var_0_0, forMarshaling->descriptorCount * 8);
            vkStream->handleMapping()->mapHandles_VkSampler_u64(forMarshaling->pImmutableSamplers, cgen_var_0_0, forMarshaling->descriptorCount);
            vkStream->write((uint64_t*)cgen_var_0_0, forMarshaling->descriptorCount * 8);
        }
    }
}

void unmarshal_VkDescriptorSetLayoutBinding(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetLayoutBinding* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->binding, sizeof(uint32_t));
    vkStream->read((VkDescriptorType*)&forUnmarshaling->descriptorType, sizeof(VkDescriptorType));
    vkStream->read((uint32_t*)&forUnmarshaling->descriptorCount, sizeof(uint32_t));
    vkStream->read((VkShaderStageFlags*)&forUnmarshaling->stageFlags, sizeof(VkShaderStageFlags));
    // WARNING PTR CHECK
    const VkSampler* check_pImmutableSamplers;
    (void)check_pImmutableSamplers;
    check_pImmutableSamplers = (const VkSampler*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pImmutableSamplers)
    {
        if (!(check_pImmutableSamplers))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pImmutableSamplers inconsistent between guest and host\n");
        }
        if (forUnmarshaling->descriptorCount)
        {
            uint64_t* cgen_var_0_0;
            vkStream->alloc((void**)&cgen_var_0_0, forUnmarshaling->descriptorCount * 8);
            vkStream->read((uint64_t*)cgen_var_0_0, forUnmarshaling->descriptorCount * 8);
            vkStream->handleMapping()->mapHandles_u64_VkSampler(cgen_var_0_0, (VkSampler*)forUnmarshaling->pImmutableSamplers, forUnmarshaling->descriptorCount);
        }
    }
}

void marshal_VkDescriptorSetLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDescriptorSetLayoutCreateFlags*)&forMarshaling->flags, sizeof(VkDescriptorSetLayoutCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->bindingCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->bindingCount; ++i)
        {
            marshal_VkDescriptorSetLayoutBinding(vkStream, rootType, (const VkDescriptorSetLayoutBinding*)(forMarshaling->pBindings + i));
        }
    }
}

void unmarshal_VkDescriptorSetLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetLayoutCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDescriptorSetLayoutCreateFlags*)&forUnmarshaling->flags, sizeof(VkDescriptorSetLayoutCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->bindingCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bindingCount; ++i)
        {
            unmarshal_VkDescriptorSetLayoutBinding(vkStream, rootType, (VkDescriptorSetLayoutBinding*)(forUnmarshaling->pBindings + i));
        }
    }
}

void marshal_VkWriteDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkWriteDescriptorSet* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkDescriptorSet_u64(&forMarshaling->dstSet, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->dstBinding, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->dstArrayElement, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->descriptorCount, sizeof(uint32_t));
    vkStream->write((VkDescriptorType*)&forMarshaling->descriptorType, sizeof(VkDescriptorType));
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pImageInfo;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pImageInfo)
    {
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_SAMPLER == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_IMAGE == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT == forMarshaling->descriptorType))))
        {
            if (forMarshaling)
            {
                for (uint32_t i = 0; i < (uint32_t)forMarshaling->descriptorCount; ++i)
                {
                    marshal_VkDescriptorImageInfo(vkStream, rootType, (const VkDescriptorImageInfo*)(forMarshaling->pImageInfo + i));
                }
            }
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_2 = (uint64_t)(uintptr_t)forMarshaling->pBufferInfo;
    vkStream->putBe64(cgen_var_2);
    if (forMarshaling->pBufferInfo)
    {
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_BUFFER == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC == forMarshaling->descriptorType))))
        {
            if (forMarshaling)
            {
                for (uint32_t i = 0; i < (uint32_t)forMarshaling->descriptorCount; ++i)
                {
                    marshal_VkDescriptorBufferInfo(vkStream, rootType, (const VkDescriptorBufferInfo*)(forMarshaling->pBufferInfo + i));
                }
            }
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_3 = (uint64_t)(uintptr_t)forMarshaling->pTexelBufferView;
    vkStream->putBe64(cgen_var_3);
    if (forMarshaling->pTexelBufferView)
    {
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER == forMarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER == forMarshaling->descriptorType))))
        {
            if (forMarshaling->descriptorCount)
            {
                uint64_t* cgen_var_3_0;
                vkStream->alloc((void**)&cgen_var_3_0, forMarshaling->descriptorCount * 8);
                vkStream->handleMapping()->mapHandles_VkBufferView_u64(forMarshaling->pTexelBufferView, cgen_var_3_0, forMarshaling->descriptorCount);
                vkStream->write((uint64_t*)cgen_var_3_0, forMarshaling->descriptorCount * 8);
            }
        }
    }
}

void unmarshal_VkWriteDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkWriteDescriptorSet* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDescriptorSet(&cgen_var_0, (VkDescriptorSet*)&forUnmarshaling->dstSet, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->dstBinding, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->dstArrayElement, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->descriptorCount, sizeof(uint32_t));
    vkStream->read((VkDescriptorType*)&forUnmarshaling->descriptorType, sizeof(VkDescriptorType));
    // WARNING PTR CHECK
    const VkDescriptorImageInfo* check_pImageInfo;
    (void)check_pImageInfo;
    check_pImageInfo = (const VkDescriptorImageInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pImageInfo)
    {
        if (!(check_pImageInfo))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pImageInfo inconsistent between guest and host\n");
        }
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_SAMPLER == forUnmarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER == forUnmarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE == forUnmarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_IMAGE == forUnmarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT == forUnmarshaling->descriptorType))))
        {
            if (forUnmarshaling)
            {
                for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->descriptorCount; ++i)
                {
                    unmarshal_VkDescriptorImageInfo(vkStream, rootType, (VkDescriptorImageInfo*)(forUnmarshaling->pImageInfo + i));
                }
            }
        }
        else
        {
            forUnmarshaling->pImageInfo = 0;
        }
    }
    // WARNING PTR CHECK
    const VkDescriptorBufferInfo* check_pBufferInfo;
    (void)check_pBufferInfo;
    check_pBufferInfo = (const VkDescriptorBufferInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pBufferInfo)
    {
        if (!(check_pBufferInfo))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pBufferInfo inconsistent between guest and host\n");
        }
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER == forUnmarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC == forUnmarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_BUFFER == forUnmarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC == forUnmarshaling->descriptorType))))
        {
            if (forUnmarshaling)
            {
                for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->descriptorCount; ++i)
                {
                    unmarshal_VkDescriptorBufferInfo(vkStream, rootType, (VkDescriptorBufferInfo*)(forUnmarshaling->pBufferInfo + i));
                }
            }
        }
        else
        {
            forUnmarshaling->pBufferInfo = 0;
        }
    }
    // WARNING PTR CHECK
    const VkBufferView* check_pTexelBufferView;
    (void)check_pTexelBufferView;
    check_pTexelBufferView = (const VkBufferView*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pTexelBufferView)
    {
        if (!(check_pTexelBufferView))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pTexelBufferView inconsistent between guest and host\n");
        }
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || ((VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER == forUnmarshaling->descriptorType) || (VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER == forUnmarshaling->descriptorType))))
        {
            if (forUnmarshaling->descriptorCount)
            {
                uint64_t* cgen_var_3_0;
                vkStream->alloc((void**)&cgen_var_3_0, forUnmarshaling->descriptorCount * 8);
                vkStream->read((uint64_t*)cgen_var_3_0, forUnmarshaling->descriptorCount * 8);
                vkStream->handleMapping()->mapHandles_u64_VkBufferView(cgen_var_3_0, (VkBufferView*)forUnmarshaling->pTexelBufferView, forUnmarshaling->descriptorCount);
            }
        }
        else
        {
            forUnmarshaling->pTexelBufferView = 0;
        }
    }
}

void marshal_VkAttachmentDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescription* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkAttachmentDescriptionFlags*)&forMarshaling->flags, sizeof(VkAttachmentDescriptionFlags));
    vkStream->write((VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    vkStream->write((VkSampleCountFlagBits*)&forMarshaling->samples, sizeof(VkSampleCountFlagBits));
    vkStream->write((VkAttachmentLoadOp*)&forMarshaling->loadOp, sizeof(VkAttachmentLoadOp));
    vkStream->write((VkAttachmentStoreOp*)&forMarshaling->storeOp, sizeof(VkAttachmentStoreOp));
    vkStream->write((VkAttachmentLoadOp*)&forMarshaling->stencilLoadOp, sizeof(VkAttachmentLoadOp));
    vkStream->write((VkAttachmentStoreOp*)&forMarshaling->stencilStoreOp, sizeof(VkAttachmentStoreOp));
    vkStream->write((VkImageLayout*)&forMarshaling->initialLayout, sizeof(VkImageLayout));
    vkStream->write((VkImageLayout*)&forMarshaling->finalLayout, sizeof(VkImageLayout));
}

void unmarshal_VkAttachmentDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentDescription* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkAttachmentDescriptionFlags*)&forUnmarshaling->flags, sizeof(VkAttachmentDescriptionFlags));
    vkStream->read((VkFormat*)&forUnmarshaling->format, sizeof(VkFormat));
    vkStream->read((VkSampleCountFlagBits*)&forUnmarshaling->samples, sizeof(VkSampleCountFlagBits));
    vkStream->read((VkAttachmentLoadOp*)&forUnmarshaling->loadOp, sizeof(VkAttachmentLoadOp));
    vkStream->read((VkAttachmentStoreOp*)&forUnmarshaling->storeOp, sizeof(VkAttachmentStoreOp));
    vkStream->read((VkAttachmentLoadOp*)&forUnmarshaling->stencilLoadOp, sizeof(VkAttachmentLoadOp));
    vkStream->read((VkAttachmentStoreOp*)&forUnmarshaling->stencilStoreOp, sizeof(VkAttachmentStoreOp));
    vkStream->read((VkImageLayout*)&forUnmarshaling->initialLayout, sizeof(VkImageLayout));
    vkStream->read((VkImageLayout*)&forUnmarshaling->finalLayout, sizeof(VkImageLayout));
}

void marshal_VkAttachmentReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReference* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->attachment, sizeof(uint32_t));
    vkStream->write((VkImageLayout*)&forMarshaling->layout, sizeof(VkImageLayout));
}

void unmarshal_VkAttachmentReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentReference* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->attachment, sizeof(uint32_t));
    vkStream->read((VkImageLayout*)&forUnmarshaling->layout, sizeof(VkImageLayout));
}

void marshal_VkFramebufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkFramebufferCreateFlags*)&forMarshaling->flags, sizeof(VkFramebufferCreateFlags));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkRenderPass_u64(&forMarshaling->renderPass, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || (((forMarshaling->flags & VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT) == 0))))
    {
        if (forMarshaling->attachmentCount)
        {
            uint64_t* cgen_var_0_0;
            vkStream->alloc((void**)&cgen_var_0_0, forMarshaling->attachmentCount * 8);
            vkStream->handleMapping()->mapHandles_VkImageView_u64(forMarshaling->pAttachments, cgen_var_0_0, forMarshaling->attachmentCount);
            vkStream->write((uint64_t*)cgen_var_0_0, forMarshaling->attachmentCount * 8);
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->width, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->height, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->layers, sizeof(uint32_t));
}

void unmarshal_VkFramebufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFramebufferCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkFramebufferCreateFlags*)&forUnmarshaling->flags, sizeof(VkFramebufferCreateFlags));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkRenderPass(&cgen_var_0, (VkRenderPass*)&forUnmarshaling->renderPass, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->attachmentCount, sizeof(uint32_t));
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) || (((forUnmarshaling->flags & VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT) == 0))))
    {
        if (forUnmarshaling->attachmentCount)
        {
            uint64_t* cgen_var_0_0;
            vkStream->alloc((void**)&cgen_var_0_0, forUnmarshaling->attachmentCount * 8);
            vkStream->read((uint64_t*)cgen_var_0_0, forUnmarshaling->attachmentCount * 8);
            vkStream->handleMapping()->mapHandles_u64_VkImageView(cgen_var_0_0, (VkImageView*)forUnmarshaling->pAttachments, forUnmarshaling->attachmentCount);
        }
    }
    else
    {
        forUnmarshaling->pAttachments = 0;
    }
    vkStream->read((uint32_t*)&forUnmarshaling->width, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->height, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->layers, sizeof(uint32_t));
}

void marshal_VkSubpassDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescription* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkSubpassDescriptionFlags*)&forMarshaling->flags, sizeof(VkSubpassDescriptionFlags));
    vkStream->write((VkPipelineBindPoint*)&forMarshaling->pipelineBindPoint, sizeof(VkPipelineBindPoint));
    vkStream->write((uint32_t*)&forMarshaling->inputAttachmentCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->inputAttachmentCount; ++i)
        {
            marshal_VkAttachmentReference(vkStream, rootType, (const VkAttachmentReference*)(forMarshaling->pInputAttachments + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->colorAttachmentCount; ++i)
        {
            marshal_VkAttachmentReference(vkStream, rootType, (const VkAttachmentReference*)(forMarshaling->pColorAttachments + i));
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pResolveAttachments;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pResolveAttachments)
    {
        if (forMarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forMarshaling->colorAttachmentCount; ++i)
            {
                marshal_VkAttachmentReference(vkStream, rootType, (const VkAttachmentReference*)(forMarshaling->pResolveAttachments + i));
            }
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pDepthStencilAttachment;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pDepthStencilAttachment)
    {
        marshal_VkAttachmentReference(vkStream, rootType, (const VkAttachmentReference*)(forMarshaling->pDepthStencilAttachment));
    }
    vkStream->write((uint32_t*)&forMarshaling->preserveAttachmentCount, sizeof(uint32_t));
    vkStream->write((const uint32_t*)forMarshaling->pPreserveAttachments, forMarshaling->preserveAttachmentCount * sizeof(const uint32_t));
}

void unmarshal_VkSubpassDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassDescription* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkSubpassDescriptionFlags*)&forUnmarshaling->flags, sizeof(VkSubpassDescriptionFlags));
    vkStream->read((VkPipelineBindPoint*)&forUnmarshaling->pipelineBindPoint, sizeof(VkPipelineBindPoint));
    vkStream->read((uint32_t*)&forUnmarshaling->inputAttachmentCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->inputAttachmentCount; ++i)
        {
            unmarshal_VkAttachmentReference(vkStream, rootType, (VkAttachmentReference*)(forUnmarshaling->pInputAttachments + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->colorAttachmentCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->colorAttachmentCount; ++i)
        {
            unmarshal_VkAttachmentReference(vkStream, rootType, (VkAttachmentReference*)(forUnmarshaling->pColorAttachments + i));
        }
    }
    // WARNING PTR CHECK
    const VkAttachmentReference* check_pResolveAttachments;
    (void)check_pResolveAttachments;
    check_pResolveAttachments = (const VkAttachmentReference*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pResolveAttachments)
    {
        if (!(check_pResolveAttachments))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pResolveAttachments inconsistent between guest and host\n");
        }
        if (forUnmarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->colorAttachmentCount; ++i)
            {
                unmarshal_VkAttachmentReference(vkStream, rootType, (VkAttachmentReference*)(forUnmarshaling->pResolveAttachments + i));
            }
        }
    }
    // WARNING PTR CHECK
    const VkAttachmentReference* check_pDepthStencilAttachment;
    (void)check_pDepthStencilAttachment;
    check_pDepthStencilAttachment = (const VkAttachmentReference*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pDepthStencilAttachment)
    {
        if (!(check_pDepthStencilAttachment))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pDepthStencilAttachment inconsistent between guest and host\n");
        }
        unmarshal_VkAttachmentReference(vkStream, rootType, (VkAttachmentReference*)(forUnmarshaling->pDepthStencilAttachment));
    }
    vkStream->read((uint32_t*)&forUnmarshaling->preserveAttachmentCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->pPreserveAttachments, forUnmarshaling->preserveAttachmentCount * sizeof(const uint32_t));
}

void marshal_VkSubpassDependency(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDependency* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->srcSubpass, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->dstSubpass, sizeof(uint32_t));
    vkStream->write((VkPipelineStageFlags*)&forMarshaling->srcStageMask, sizeof(VkPipelineStageFlags));
    vkStream->write((VkPipelineStageFlags*)&forMarshaling->dstStageMask, sizeof(VkPipelineStageFlags));
    vkStream->write((VkAccessFlags*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags));
    vkStream->write((VkAccessFlags*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags));
    vkStream->write((VkDependencyFlags*)&forMarshaling->dependencyFlags, sizeof(VkDependencyFlags));
}

void unmarshal_VkSubpassDependency(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassDependency* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->srcSubpass, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->dstSubpass, sizeof(uint32_t));
    vkStream->read((VkPipelineStageFlags*)&forUnmarshaling->srcStageMask, sizeof(VkPipelineStageFlags));
    vkStream->read((VkPipelineStageFlags*)&forUnmarshaling->dstStageMask, sizeof(VkPipelineStageFlags));
    vkStream->read((VkAccessFlags*)&forUnmarshaling->srcAccessMask, sizeof(VkAccessFlags));
    vkStream->read((VkAccessFlags*)&forUnmarshaling->dstAccessMask, sizeof(VkAccessFlags));
    vkStream->read((VkDependencyFlags*)&forUnmarshaling->dependencyFlags, sizeof(VkDependencyFlags));
}

void marshal_VkRenderPassCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkRenderPassCreateFlags*)&forMarshaling->flags, sizeof(VkRenderPassCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->attachmentCount; ++i)
        {
            marshal_VkAttachmentDescription(vkStream, rootType, (const VkAttachmentDescription*)(forMarshaling->pAttachments + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->subpassCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->subpassCount; ++i)
        {
            marshal_VkSubpassDescription(vkStream, rootType, (const VkSubpassDescription*)(forMarshaling->pSubpasses + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->dependencyCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->dependencyCount; ++i)
        {
            marshal_VkSubpassDependency(vkStream, rootType, (const VkSubpassDependency*)(forMarshaling->pDependencies + i));
        }
    }
}

void unmarshal_VkRenderPassCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkRenderPassCreateFlags*)&forUnmarshaling->flags, sizeof(VkRenderPassCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->attachmentCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->attachmentCount; ++i)
        {
            unmarshal_VkAttachmentDescription(vkStream, rootType, (VkAttachmentDescription*)(forUnmarshaling->pAttachments + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->subpassCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->subpassCount; ++i)
        {
            unmarshal_VkSubpassDescription(vkStream, rootType, (VkSubpassDescription*)(forUnmarshaling->pSubpasses + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->dependencyCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->dependencyCount; ++i)
        {
            unmarshal_VkSubpassDependency(vkStream, rootType, (VkSubpassDependency*)(forUnmarshaling->pDependencies + i));
        }
    }
}

void marshal_VkCommandPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandPoolCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkCommandPoolCreateFlags*)&forMarshaling->flags, sizeof(VkCommandPoolCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->queueFamilyIndex, sizeof(uint32_t));
}

void unmarshal_VkCommandPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandPoolCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkCommandPoolCreateFlags*)&forUnmarshaling->flags, sizeof(VkCommandPoolCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->queueFamilyIndex, sizeof(uint32_t));
}

void marshal_VkCommandBufferAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferAllocateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkCommandPool_u64(&forMarshaling->commandPool, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkCommandBufferLevel*)&forMarshaling->level, sizeof(VkCommandBufferLevel));
    vkStream->write((uint32_t*)&forMarshaling->commandBufferCount, sizeof(uint32_t));
}

void unmarshal_VkCommandBufferAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandBufferAllocateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkCommandPool(&cgen_var_0, (VkCommandPool*)&forUnmarshaling->commandPool, 1);
    vkStream->read((VkCommandBufferLevel*)&forUnmarshaling->level, sizeof(VkCommandBufferLevel));
    vkStream->read((uint32_t*)&forUnmarshaling->commandBufferCount, sizeof(uint32_t));
}

void marshal_VkCommandBufferInheritanceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferInheritanceInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkRenderPass_u64(&forMarshaling->renderPass, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->subpass, sizeof(uint32_t));
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkFramebuffer_u64(&forMarshaling->framebuffer, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((VkBool32*)&forMarshaling->occlusionQueryEnable, sizeof(VkBool32));
    vkStream->write((VkQueryControlFlags*)&forMarshaling->queryFlags, sizeof(VkQueryControlFlags));
    vkStream->write((VkQueryPipelineStatisticFlags*)&forMarshaling->pipelineStatistics, sizeof(VkQueryPipelineStatisticFlags));
}

void unmarshal_VkCommandBufferInheritanceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandBufferInheritanceInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkRenderPass(&cgen_var_0, (VkRenderPass*)&forUnmarshaling->renderPass, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->subpass, sizeof(uint32_t));
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkFramebuffer(&cgen_var_1, (VkFramebuffer*)&forUnmarshaling->framebuffer, 1);
    vkStream->read((VkBool32*)&forUnmarshaling->occlusionQueryEnable, sizeof(VkBool32));
    vkStream->read((VkQueryControlFlags*)&forUnmarshaling->queryFlags, sizeof(VkQueryControlFlags));
    vkStream->read((VkQueryPipelineStatisticFlags*)&forUnmarshaling->pipelineStatistics, sizeof(VkQueryPipelineStatisticFlags));
}

void marshal_VkCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferBeginInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkCommandBufferUsageFlags*)&forMarshaling->flags, sizeof(VkCommandBufferUsageFlags));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pInheritanceInfo;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pInheritanceInfo)
    {
        marshal_VkCommandBufferInheritanceInfo(vkStream, rootType, (const VkCommandBufferInheritanceInfo*)(forMarshaling->pInheritanceInfo));
    }
}

void unmarshal_VkCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandBufferBeginInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkCommandBufferUsageFlags*)&forUnmarshaling->flags, sizeof(VkCommandBufferUsageFlags));
    // WARNING PTR CHECK
    const VkCommandBufferInheritanceInfo* check_pInheritanceInfo;
    (void)check_pInheritanceInfo;
    check_pInheritanceInfo = (const VkCommandBufferInheritanceInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pInheritanceInfo)
    {
        if (!(check_pInheritanceInfo))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pInheritanceInfo inconsistent between guest and host\n");
        }
        unmarshal_VkCommandBufferInheritanceInfo(vkStream, rootType, (VkCommandBufferInheritanceInfo*)(forUnmarshaling->pInheritanceInfo));
    }
}

void marshal_VkBufferCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCopy* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkDeviceSize*)&forMarshaling->srcOffset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->dstOffset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
}

void unmarshal_VkBufferCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferCopy* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkDeviceSize*)&forUnmarshaling->srcOffset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->dstOffset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
}

void marshal_VkImageSubresourceLayers(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresourceLayers* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    vkStream->write((uint32_t*)&forMarshaling->mipLevel, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->baseArrayLayer, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->layerCount, sizeof(uint32_t));
}

void unmarshal_VkImageSubresourceLayers(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageSubresourceLayers* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkImageAspectFlags*)&forUnmarshaling->aspectMask, sizeof(VkImageAspectFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->mipLevel, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->baseArrayLayer, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->layerCount, sizeof(uint32_t));
}

void marshal_VkBufferImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferImageCopy* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkDeviceSize*)&forMarshaling->bufferOffset, sizeof(VkDeviceSize));
    vkStream->write((uint32_t*)&forMarshaling->bufferRowLength, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->bufferImageHeight, sizeof(uint32_t));
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->imageSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->imageOffset));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->imageExtent));
}

void unmarshal_VkBufferImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferImageCopy* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkDeviceSize*)&forUnmarshaling->bufferOffset, sizeof(VkDeviceSize));
    vkStream->read((uint32_t*)&forUnmarshaling->bufferRowLength, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->bufferImageHeight, sizeof(uint32_t));
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->imageSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->imageOffset));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->imageExtent));
}

void marshal_VkClearColorValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearColorValue* forMarshaling)
{
    (void)rootType;
    vkStream->write((float*)forMarshaling->float32, 4 * sizeof(float));
}

void unmarshal_VkClearColorValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkClearColorValue* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((float*)forUnmarshaling->float32, 4 * sizeof(float));
}

void marshal_VkClearDepthStencilValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearDepthStencilValue* forMarshaling)
{
    (void)rootType;
    vkStream->write((float*)&forMarshaling->depth, sizeof(float));
    vkStream->write((uint32_t*)&forMarshaling->stencil, sizeof(uint32_t));
}

void unmarshal_VkClearDepthStencilValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkClearDepthStencilValue* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((float*)&forUnmarshaling->depth, sizeof(float));
    vkStream->read((uint32_t*)&forUnmarshaling->stencil, sizeof(uint32_t));
}

void marshal_VkClearValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearValue* forMarshaling)
{
    (void)rootType;
    marshal_VkClearColorValue(vkStream, rootType, (VkClearColorValue*)(&forMarshaling->color));
}

void unmarshal_VkClearValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkClearValue* forUnmarshaling)
{
    (void)rootType;
    unmarshal_VkClearColorValue(vkStream, rootType, (VkClearColorValue*)(&forUnmarshaling->color));
}

void marshal_VkClearAttachment(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearAttachment* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
    vkStream->write((uint32_t*)&forMarshaling->colorAttachment, sizeof(uint32_t));
    marshal_VkClearValue(vkStream, rootType, (VkClearValue*)(&forMarshaling->clearValue));
}

void unmarshal_VkClearAttachment(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkClearAttachment* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkImageAspectFlags*)&forUnmarshaling->aspectMask, sizeof(VkImageAspectFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->colorAttachment, sizeof(uint32_t));
    unmarshal_VkClearValue(vkStream, rootType, (VkClearValue*)(&forUnmarshaling->clearValue));
}

void marshal_VkClearRect(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearRect* forMarshaling)
{
    (void)rootType;
    marshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forMarshaling->rect));
    vkStream->write((uint32_t*)&forMarshaling->baseArrayLayer, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->layerCount, sizeof(uint32_t));
}

void unmarshal_VkClearRect(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkClearRect* forUnmarshaling)
{
    (void)rootType;
    unmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forUnmarshaling->rect));
    vkStream->read((uint32_t*)&forUnmarshaling->baseArrayLayer, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->layerCount, sizeof(uint32_t));
}

void marshal_VkImageBlit(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageBlit* forMarshaling)
{
    (void)rootType;
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forMarshaling->srcOffsets + i));
    }
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forMarshaling->dstOffsets + i));
    }
}

void unmarshal_VkImageBlit(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageBlit* forUnmarshaling)
{
    (void)rootType;
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forUnmarshaling->srcOffsets + i));
    }
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forUnmarshaling->dstOffsets + i));
    }
}

void marshal_VkImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCopy* forMarshaling)
{
    (void)rootType;
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->srcOffset));
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->dstOffset));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent));
}

void unmarshal_VkImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageCopy* forUnmarshaling)
{
    (void)rootType;
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->srcOffset));
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->dstOffset));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent));
}

void marshal_VkImageResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageResolve* forMarshaling)
{
    (void)rootType;
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->srcOffset));
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->dstOffset));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent));
}

void unmarshal_VkImageResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageResolve* forUnmarshaling)
{
    (void)rootType;
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->srcOffset));
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->dstOffset));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent));
}

void marshal_VkRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassBeginInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkRenderPass_u64(&forMarshaling->renderPass, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkFramebuffer_u64(&forMarshaling->framebuffer, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    marshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forMarshaling->renderArea));
    vkStream->write((uint32_t*)&forMarshaling->clearValueCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_2 = (uint64_t)(uintptr_t)forMarshaling->pClearValues;
    vkStream->putBe64(cgen_var_2);
    if (forMarshaling->pClearValues)
    {
        if (forMarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forMarshaling->clearValueCount; ++i)
            {
                marshal_VkClearValue(vkStream, rootType, (const VkClearValue*)(forMarshaling->pClearValues + i));
            }
        }
    }
}

void unmarshal_VkRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassBeginInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkRenderPass(&cgen_var_0, (VkRenderPass*)&forUnmarshaling->renderPass, 1);
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkFramebuffer(&cgen_var_1, (VkFramebuffer*)&forUnmarshaling->framebuffer, 1);
    unmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forUnmarshaling->renderArea));
    vkStream->read((uint32_t*)&forUnmarshaling->clearValueCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const VkClearValue* check_pClearValues;
    (void)check_pClearValues;
    check_pClearValues = (const VkClearValue*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pClearValues)
    {
        if (!(check_pClearValues))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pClearValues inconsistent between guest and host\n");
        }
        if (forUnmarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->clearValueCount; ++i)
            {
                unmarshal_VkClearValue(vkStream, rootType, (VkClearValue*)(forUnmarshaling->pClearValues + i));
            }
        }
    }
}

#endif
#ifdef VK_VERSION_1_1
void marshal_VkPhysicalDeviceSubgroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->subgroupSize, sizeof(uint32_t));
    vkStream->write((VkShaderStageFlags*)&forMarshaling->supportedStages, sizeof(VkShaderStageFlags));
    vkStream->write((VkSubgroupFeatureFlags*)&forMarshaling->supportedOperations, sizeof(VkSubgroupFeatureFlags));
    vkStream->write((VkBool32*)&forMarshaling->quadOperationsInAllStages, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceSubgroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSubgroupProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->subgroupSize, sizeof(uint32_t));
    vkStream->read((VkShaderStageFlags*)&forUnmarshaling->supportedStages, sizeof(VkShaderStageFlags));
    vkStream->read((VkSubgroupFeatureFlags*)&forUnmarshaling->supportedOperations, sizeof(VkSubgroupFeatureFlags));
    vkStream->read((VkBool32*)&forUnmarshaling->quadOperationsInAllStages, sizeof(VkBool32));
}

void marshal_VkBindBufferMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindBufferMemoryInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->buffer, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkDeviceMemory_u64(&forMarshaling->memory, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((VkDeviceSize*)&forMarshaling->memoryOffset, sizeof(VkDeviceSize));
}

void unmarshal_VkBindBufferMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindBufferMemoryInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_0, (VkBuffer*)&forUnmarshaling->buffer, 1);
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDeviceMemory(&cgen_var_1, (VkDeviceMemory*)&forUnmarshaling->memory, 1);
    vkStream->read((VkDeviceSize*)&forUnmarshaling->memoryOffset, sizeof(VkDeviceSize));
}

void marshal_VkBindImageMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImageMemoryInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->image, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkDeviceMemory_u64(&forMarshaling->memory, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((VkDeviceSize*)&forMarshaling->memoryOffset, sizeof(VkDeviceSize));
}

void unmarshal_VkBindImageMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindImageMemoryInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->image, 1);
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDeviceMemory(&cgen_var_1, (VkDeviceMemory*)&forUnmarshaling->memory, 1);
    vkStream->read((VkDeviceSize*)&forUnmarshaling->memoryOffset, sizeof(VkDeviceSize));
}

void marshal_VkPhysicalDevice16BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice16BitStorageFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->storageBuffer16BitAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->uniformAndStorageBuffer16BitAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->storagePushConstant16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->storageInputOutput16, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDevice16BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevice16BitStorageFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->storageBuffer16BitAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->uniformAndStorageBuffer16BitAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->storagePushConstant16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->storageInputOutput16, sizeof(VkBool32));
}

void marshal_VkMemoryDedicatedRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryDedicatedRequirements* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->prefersDedicatedAllocation, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->requiresDedicatedAllocation, sizeof(VkBool32));
}

void unmarshal_VkMemoryDedicatedRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryDedicatedRequirements* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->prefersDedicatedAllocation, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->requiresDedicatedAllocation, sizeof(VkBool32));
}

void marshal_VkMemoryDedicatedAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryDedicatedAllocateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->image, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->buffer, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
}

void unmarshal_VkMemoryDedicatedAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryDedicatedAllocateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->image, 1);
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_1, (VkBuffer*)&forUnmarshaling->buffer, 1);
}

void marshal_VkMemoryAllocateFlagsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryAllocateFlagsInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkMemoryAllocateFlags*)&forMarshaling->flags, sizeof(VkMemoryAllocateFlags));
    vkStream->write((uint32_t*)&forMarshaling->deviceMask, sizeof(uint32_t));
}

void unmarshal_VkMemoryAllocateFlagsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryAllocateFlagsInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkMemoryAllocateFlags*)&forUnmarshaling->flags, sizeof(VkMemoryAllocateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->deviceMask, sizeof(uint32_t));
}

void marshal_VkDeviceGroupRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupRenderPassBeginInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->deviceMask, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->deviceRenderAreaCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->deviceRenderAreaCount; ++i)
        {
            marshal_VkRect2D(vkStream, rootType, (const VkRect2D*)(forMarshaling->pDeviceRenderAreas + i));
        }
    }
}

void unmarshal_VkDeviceGroupRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceGroupRenderPassBeginInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->deviceMask, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->deviceRenderAreaCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->deviceRenderAreaCount; ++i)
        {
            unmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(forUnmarshaling->pDeviceRenderAreas + i));
        }
    }
}

void marshal_VkDeviceGroupCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupCommandBufferBeginInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->deviceMask, sizeof(uint32_t));
}

void unmarshal_VkDeviceGroupCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceGroupCommandBufferBeginInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->deviceMask, sizeof(uint32_t));
}

void marshal_VkDeviceGroupSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupSubmitInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->waitSemaphoreCount, sizeof(uint32_t));
    vkStream->write((const uint32_t*)forMarshaling->pWaitSemaphoreDeviceIndices, forMarshaling->waitSemaphoreCount * sizeof(const uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->commandBufferCount, sizeof(uint32_t));
    vkStream->write((const uint32_t*)forMarshaling->pCommandBufferDeviceMasks, forMarshaling->commandBufferCount * sizeof(const uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->signalSemaphoreCount, sizeof(uint32_t));
    vkStream->write((const uint32_t*)forMarshaling->pSignalSemaphoreDeviceIndices, forMarshaling->signalSemaphoreCount * sizeof(const uint32_t));
}

void unmarshal_VkDeviceGroupSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceGroupSubmitInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->waitSemaphoreCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->pWaitSemaphoreDeviceIndices, forUnmarshaling->waitSemaphoreCount * sizeof(const uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->commandBufferCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->pCommandBufferDeviceMasks, forUnmarshaling->commandBufferCount * sizeof(const uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->signalSemaphoreCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->pSignalSemaphoreDeviceIndices, forUnmarshaling->signalSemaphoreCount * sizeof(const uint32_t));
}

void marshal_VkDeviceGroupBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupBindSparseInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->resourceDeviceIndex, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->memoryDeviceIndex, sizeof(uint32_t));
}

void unmarshal_VkDeviceGroupBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceGroupBindSparseInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->resourceDeviceIndex, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->memoryDeviceIndex, sizeof(uint32_t));
}

void marshal_VkBindBufferMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindBufferMemoryDeviceGroupInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->deviceIndexCount, sizeof(uint32_t));
    vkStream->write((const uint32_t*)forMarshaling->pDeviceIndices, forMarshaling->deviceIndexCount * sizeof(const uint32_t));
}

void unmarshal_VkBindBufferMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindBufferMemoryDeviceGroupInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->deviceIndexCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->pDeviceIndices, forUnmarshaling->deviceIndexCount * sizeof(const uint32_t));
}

void marshal_VkBindImageMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImageMemoryDeviceGroupInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->deviceIndexCount, sizeof(uint32_t));
    vkStream->write((const uint32_t*)forMarshaling->pDeviceIndices, forMarshaling->deviceIndexCount * sizeof(const uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->splitInstanceBindRegionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->splitInstanceBindRegionCount; ++i)
        {
            marshal_VkRect2D(vkStream, rootType, (const VkRect2D*)(forMarshaling->pSplitInstanceBindRegions + i));
        }
    }
}

void unmarshal_VkBindImageMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindImageMemoryDeviceGroupInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->deviceIndexCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->pDeviceIndices, forUnmarshaling->deviceIndexCount * sizeof(const uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->splitInstanceBindRegionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->splitInstanceBindRegionCount; ++i)
        {
            unmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(forUnmarshaling->pSplitInstanceBindRegions + i));
        }
    }
}

void marshal_VkPhysicalDeviceGroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGroupProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->physicalDeviceCount, sizeof(uint32_t));
    vkStream->write((VkPhysicalDevice*)forMarshaling->physicalDevices, VK_MAX_DEVICE_GROUP_SIZE * sizeof(VkPhysicalDevice));
    vkStream->write((VkBool32*)&forMarshaling->subsetAllocation, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceGroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceGroupProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->physicalDeviceCount, sizeof(uint32_t));
    vkStream->read((VkPhysicalDevice*)forUnmarshaling->physicalDevices, VK_MAX_DEVICE_GROUP_SIZE * sizeof(VkPhysicalDevice));
    vkStream->read((VkBool32*)&forUnmarshaling->subsetAllocation, sizeof(VkBool32));
}

void marshal_VkDeviceGroupDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupDeviceCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->physicalDeviceCount, sizeof(uint32_t));
    if (forMarshaling->physicalDeviceCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forMarshaling->physicalDeviceCount * 8);
        vkStream->handleMapping()->mapHandles_VkPhysicalDevice_u64(forMarshaling->pPhysicalDevices, cgen_var_0, forMarshaling->physicalDeviceCount);
        vkStream->write((uint64_t*)cgen_var_0, forMarshaling->physicalDeviceCount * 8);
    }
}

void unmarshal_VkDeviceGroupDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceGroupDeviceCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->physicalDeviceCount, sizeof(uint32_t));
    if (forUnmarshaling->physicalDeviceCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forUnmarshaling->physicalDeviceCount * 8);
        vkStream->read((uint64_t*)cgen_var_0, forUnmarshaling->physicalDeviceCount * 8);
        vkStream->handleMapping()->mapHandles_u64_VkPhysicalDevice(cgen_var_0, (VkPhysicalDevice*)forUnmarshaling->pPhysicalDevices, forUnmarshaling->physicalDeviceCount);
    }
}

void marshal_VkBufferMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryRequirementsInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->buffer, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
}

void unmarshal_VkBufferMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferMemoryRequirementsInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_0, (VkBuffer*)&forUnmarshaling->buffer, 1);
}

void marshal_VkImageMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryRequirementsInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->image, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
}

void unmarshal_VkImageMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageMemoryRequirementsInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->image, 1);
}

void marshal_VkImageSparseMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSparseMemoryRequirementsInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->image, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
}

void unmarshal_VkImageSparseMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageSparseMemoryRequirementsInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->image, 1);
}

void marshal_VkMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryRequirements2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkMemoryRequirements(vkStream, rootType, (VkMemoryRequirements*)(&forMarshaling->memoryRequirements));
}

void unmarshal_VkMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryRequirements2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkMemoryRequirements(vkStream, rootType, (VkMemoryRequirements*)(&forUnmarshaling->memoryRequirements));
}

void marshal_VkSparseImageMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkSparseImageMemoryRequirements(vkStream, rootType, (VkSparseImageMemoryRequirements*)(&forMarshaling->memoryRequirements));
}

void unmarshal_VkSparseImageMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageMemoryRequirements2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkSparseImageMemoryRequirements(vkStream, rootType, (VkSparseImageMemoryRequirements*)(&forUnmarshaling->memoryRequirements));
}

void marshal_VkPhysicalDeviceFeatures2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkPhysicalDeviceFeatures(vkStream, rootType, (VkPhysicalDeviceFeatures*)(&forMarshaling->features));
}

void unmarshal_VkPhysicalDeviceFeatures2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceFeatures2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkPhysicalDeviceFeatures(vkStream, rootType, (VkPhysicalDeviceFeatures*)(&forUnmarshaling->features));
}

void marshal_VkPhysicalDeviceProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkPhysicalDeviceProperties(vkStream, rootType, (VkPhysicalDeviceProperties*)(&forMarshaling->properties));
}

void unmarshal_VkPhysicalDeviceProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProperties2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkPhysicalDeviceProperties(vkStream, rootType, (VkPhysicalDeviceProperties*)(&forUnmarshaling->properties));
}

void marshal_VkFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkFormatProperties(vkStream, rootType, (VkFormatProperties*)(&forMarshaling->formatProperties));
}

void unmarshal_VkFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFormatProperties2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkFormatProperties(vkStream, rootType, (VkFormatProperties*)(&forUnmarshaling->formatProperties));
}

void marshal_VkImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatProperties2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkImageFormatProperties(vkStream, rootType, (VkImageFormatProperties*)(&forMarshaling->imageFormatProperties));
}

void unmarshal_VkImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageFormatProperties2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkImageFormatProperties(vkStream, rootType, (VkImageFormatProperties*)(&forUnmarshaling->imageFormatProperties));
}

void marshal_VkPhysicalDeviceImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageFormatInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    vkStream->write((VkImageType*)&forMarshaling->type, sizeof(VkImageType));
    vkStream->write((VkImageTiling*)&forMarshaling->tiling, sizeof(VkImageTiling));
    vkStream->write((VkImageUsageFlags*)&forMarshaling->usage, sizeof(VkImageUsageFlags));
    vkStream->write((VkImageCreateFlags*)&forMarshaling->flags, sizeof(VkImageCreateFlags));
}

void unmarshal_VkPhysicalDeviceImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImageFormatInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkFormat*)&forUnmarshaling->format, sizeof(VkFormat));
    vkStream->read((VkImageType*)&forUnmarshaling->type, sizeof(VkImageType));
    vkStream->read((VkImageTiling*)&forUnmarshaling->tiling, sizeof(VkImageTiling));
    vkStream->read((VkImageUsageFlags*)&forUnmarshaling->usage, sizeof(VkImageUsageFlags));
    vkStream->read((VkImageCreateFlags*)&forUnmarshaling->flags, sizeof(VkImageCreateFlags));
}

void marshal_VkQueueFamilyProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyProperties2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkQueueFamilyProperties(vkStream, rootType, (VkQueueFamilyProperties*)(&forMarshaling->queueFamilyProperties));
}

void unmarshal_VkQueueFamilyProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkQueueFamilyProperties2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkQueueFamilyProperties(vkStream, rootType, (VkQueueFamilyProperties*)(&forUnmarshaling->queueFamilyProperties));
}

void marshal_VkPhysicalDeviceMemoryProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkPhysicalDeviceMemoryProperties(vkStream, rootType, (VkPhysicalDeviceMemoryProperties*)(&forMarshaling->memoryProperties));
}

void unmarshal_VkPhysicalDeviceMemoryProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMemoryProperties2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkPhysicalDeviceMemoryProperties(vkStream, rootType, (VkPhysicalDeviceMemoryProperties*)(&forUnmarshaling->memoryProperties));
}

void marshal_VkSparseImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageFormatProperties2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkSparseImageFormatProperties(vkStream, rootType, (VkSparseImageFormatProperties*)(&forMarshaling->properties));
}

void unmarshal_VkSparseImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageFormatProperties2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkSparseImageFormatProperties(vkStream, rootType, (VkSparseImageFormatProperties*)(&forUnmarshaling->properties));
}

void marshal_VkPhysicalDeviceSparseImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseImageFormatInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    vkStream->write((VkImageType*)&forMarshaling->type, sizeof(VkImageType));
    vkStream->write((VkSampleCountFlagBits*)&forMarshaling->samples, sizeof(VkSampleCountFlagBits));
    vkStream->write((VkImageUsageFlags*)&forMarshaling->usage, sizeof(VkImageUsageFlags));
    vkStream->write((VkImageTiling*)&forMarshaling->tiling, sizeof(VkImageTiling));
}

void unmarshal_VkPhysicalDeviceSparseImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSparseImageFormatInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkFormat*)&forUnmarshaling->format, sizeof(VkFormat));
    vkStream->read((VkImageType*)&forUnmarshaling->type, sizeof(VkImageType));
    vkStream->read((VkSampleCountFlagBits*)&forUnmarshaling->samples, sizeof(VkSampleCountFlagBits));
    vkStream->read((VkImageUsageFlags*)&forUnmarshaling->usage, sizeof(VkImageUsageFlags));
    vkStream->read((VkImageTiling*)&forUnmarshaling->tiling, sizeof(VkImageTiling));
}

void marshal_VkPhysicalDevicePointClippingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePointClippingProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPointClippingBehavior*)&forMarshaling->pointClippingBehavior, sizeof(VkPointClippingBehavior));
}

void unmarshal_VkPhysicalDevicePointClippingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePointClippingProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPointClippingBehavior*)&forUnmarshaling->pointClippingBehavior, sizeof(VkPointClippingBehavior));
}

void marshal_VkInputAttachmentAspectReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkInputAttachmentAspectReference* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->subpass, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->inputAttachmentIndex, sizeof(uint32_t));
    vkStream->write((VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
}

void unmarshal_VkInputAttachmentAspectReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkInputAttachmentAspectReference* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->subpass, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->inputAttachmentIndex, sizeof(uint32_t));
    vkStream->read((VkImageAspectFlags*)&forUnmarshaling->aspectMask, sizeof(VkImageAspectFlags));
}

void marshal_VkRenderPassInputAttachmentAspectCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassInputAttachmentAspectCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->aspectReferenceCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->aspectReferenceCount; ++i)
        {
            marshal_VkInputAttachmentAspectReference(vkStream, rootType, (const VkInputAttachmentAspectReference*)(forMarshaling->pAspectReferences + i));
        }
    }
}

void unmarshal_VkRenderPassInputAttachmentAspectCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassInputAttachmentAspectCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->aspectReferenceCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->aspectReferenceCount; ++i)
        {
            unmarshal_VkInputAttachmentAspectReference(vkStream, rootType, (VkInputAttachmentAspectReference*)(forUnmarshaling->pAspectReferences + i));
        }
    }
}

void marshal_VkImageViewUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageViewUsageCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkImageUsageFlags*)&forMarshaling->usage, sizeof(VkImageUsageFlags));
}

void unmarshal_VkImageViewUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageViewUsageCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkImageUsageFlags*)&forUnmarshaling->usage, sizeof(VkImageUsageFlags));
}

void marshal_VkPipelineTessellationDomainOriginStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineTessellationDomainOriginStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkTessellationDomainOrigin*)&forMarshaling->domainOrigin, sizeof(VkTessellationDomainOrigin));
}

void unmarshal_VkPipelineTessellationDomainOriginStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineTessellationDomainOriginStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkTessellationDomainOrigin*)&forUnmarshaling->domainOrigin, sizeof(VkTessellationDomainOrigin));
}

void marshal_VkRenderPassMultiviewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassMultiviewCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->subpassCount, sizeof(uint32_t));
    vkStream->write((const uint32_t*)forMarshaling->pViewMasks, forMarshaling->subpassCount * sizeof(const uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->dependencyCount, sizeof(uint32_t));
    vkStream->write((const int32_t*)forMarshaling->pViewOffsets, forMarshaling->dependencyCount * sizeof(const int32_t));
    vkStream->write((uint32_t*)&forMarshaling->correlationMaskCount, sizeof(uint32_t));
    vkStream->write((const uint32_t*)forMarshaling->pCorrelationMasks, forMarshaling->correlationMaskCount * sizeof(const uint32_t));
}

void unmarshal_VkRenderPassMultiviewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassMultiviewCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->subpassCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->pViewMasks, forUnmarshaling->subpassCount * sizeof(const uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->dependencyCount, sizeof(uint32_t));
    vkStream->read((int32_t*)forUnmarshaling->pViewOffsets, forUnmarshaling->dependencyCount * sizeof(const int32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->correlationMaskCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->pCorrelationMasks, forUnmarshaling->correlationMaskCount * sizeof(const uint32_t));
}

void marshal_VkPhysicalDeviceMultiviewFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->multiview, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->multiviewGeometryShader, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->multiviewTessellationShader, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceMultiviewFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMultiviewFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->multiview, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->multiviewGeometryShader, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->multiviewTessellationShader, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceMultiviewProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->maxMultiviewViewCount, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxMultiviewInstanceIndex, sizeof(uint32_t));
}

void unmarshal_VkPhysicalDeviceMultiviewProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMultiviewProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->maxMultiviewViewCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxMultiviewInstanceIndex, sizeof(uint32_t));
}

void marshal_VkPhysicalDeviceVariablePointersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVariablePointersFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->variablePointersStorageBuffer, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->variablePointers, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceVariablePointersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVariablePointersFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->variablePointersStorageBuffer, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->variablePointers, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceProtectedMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->protectedMemory, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceProtectedMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProtectedMemoryFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->protectedMemory, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceProtectedMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->protectedNoFault, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceProtectedMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProtectedMemoryProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->protectedNoFault, sizeof(VkBool32));
}

void marshal_VkDeviceQueueInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceQueueCreateFlags*)&forMarshaling->flags, sizeof(VkDeviceQueueCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->queueFamilyIndex, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->queueIndex, sizeof(uint32_t));
}

void unmarshal_VkDeviceQueueInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceQueueInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceQueueCreateFlags*)&forUnmarshaling->flags, sizeof(VkDeviceQueueCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->queueFamilyIndex, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->queueIndex, sizeof(uint32_t));
}

void marshal_VkProtectedSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkProtectedSubmitInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->protectedSubmit, sizeof(VkBool32));
}

void unmarshal_VkProtectedSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkProtectedSubmitInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->protectedSubmit, sizeof(VkBool32));
}

void marshal_VkSamplerYcbcrConversionCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    vkStream->write((VkSamplerYcbcrModelConversion*)&forMarshaling->ycbcrModel, sizeof(VkSamplerYcbcrModelConversion));
    vkStream->write((VkSamplerYcbcrRange*)&forMarshaling->ycbcrRange, sizeof(VkSamplerYcbcrRange));
    marshal_VkComponentMapping(vkStream, rootType, (VkComponentMapping*)(&forMarshaling->components));
    vkStream->write((VkChromaLocation*)&forMarshaling->xChromaOffset, sizeof(VkChromaLocation));
    vkStream->write((VkChromaLocation*)&forMarshaling->yChromaOffset, sizeof(VkChromaLocation));
    vkStream->write((VkFilter*)&forMarshaling->chromaFilter, sizeof(VkFilter));
    vkStream->write((VkBool32*)&forMarshaling->forceExplicitReconstruction, sizeof(VkBool32));
}

void unmarshal_VkSamplerYcbcrConversionCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerYcbcrConversionCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkFormat*)&forUnmarshaling->format, sizeof(VkFormat));
    vkStream->read((VkSamplerYcbcrModelConversion*)&forUnmarshaling->ycbcrModel, sizeof(VkSamplerYcbcrModelConversion));
    vkStream->read((VkSamplerYcbcrRange*)&forUnmarshaling->ycbcrRange, sizeof(VkSamplerYcbcrRange));
    unmarshal_VkComponentMapping(vkStream, rootType, (VkComponentMapping*)(&forUnmarshaling->components));
    vkStream->read((VkChromaLocation*)&forUnmarshaling->xChromaOffset, sizeof(VkChromaLocation));
    vkStream->read((VkChromaLocation*)&forUnmarshaling->yChromaOffset, sizeof(VkChromaLocation));
    vkStream->read((VkFilter*)&forUnmarshaling->chromaFilter, sizeof(VkFilter));
    vkStream->read((VkBool32*)&forUnmarshaling->forceExplicitReconstruction, sizeof(VkBool32));
}

void marshal_VkSamplerYcbcrConversionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkSamplerYcbcrConversion_u64(&forMarshaling->conversion, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
}

void unmarshal_VkSamplerYcbcrConversionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerYcbcrConversionInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkSamplerYcbcrConversion(&cgen_var_0, (VkSamplerYcbcrConversion*)&forUnmarshaling->conversion, 1);
}

void marshal_VkBindImagePlaneMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImagePlaneMemoryInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkImageAspectFlagBits*)&forMarshaling->planeAspect, sizeof(VkImageAspectFlagBits));
}

void unmarshal_VkBindImagePlaneMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindImagePlaneMemoryInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkImageAspectFlagBits*)&forUnmarshaling->planeAspect, sizeof(VkImageAspectFlagBits));
}

void marshal_VkImagePlaneMemoryRequirementsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImagePlaneMemoryRequirementsInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkImageAspectFlagBits*)&forMarshaling->planeAspect, sizeof(VkImageAspectFlagBits));
}

void unmarshal_VkImagePlaneMemoryRequirementsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImagePlaneMemoryRequirementsInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkImageAspectFlagBits*)&forUnmarshaling->planeAspect, sizeof(VkImageAspectFlagBits));
}

void marshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerYcbcrConversionFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->samplerYcbcrConversion, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->samplerYcbcrConversion, sizeof(VkBool32));
}

void marshal_VkSamplerYcbcrConversionImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionImageFormatProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->combinedImageSamplerDescriptorCount, sizeof(uint32_t));
}

void unmarshal_VkSamplerYcbcrConversionImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerYcbcrConversionImageFormatProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->combinedImageSamplerDescriptorCount, sizeof(uint32_t));
}

void marshal_VkDescriptorUpdateTemplateEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateEntry* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->dstBinding, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->dstArrayElement, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->descriptorCount, sizeof(uint32_t));
    vkStream->write((VkDescriptorType*)&forMarshaling->descriptorType, sizeof(VkDescriptorType));
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->offset;
    vkStream->putBe64(cgen_var_0);
    uint64_t cgen_var_1 = (uint64_t)forMarshaling->stride;
    vkStream->putBe64(cgen_var_1);
}

void unmarshal_VkDescriptorUpdateTemplateEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorUpdateTemplateEntry* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->dstBinding, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->dstArrayElement, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->descriptorCount, sizeof(uint32_t));
    vkStream->read((VkDescriptorType*)&forUnmarshaling->descriptorType, sizeof(VkDescriptorType));
    forUnmarshaling->offset = (size_t)vkStream->getBe64();
    forUnmarshaling->stride = (size_t)vkStream->getBe64();
}

void marshal_VkDescriptorUpdateTemplateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDescriptorUpdateTemplateCreateFlags*)&forMarshaling->flags, sizeof(VkDescriptorUpdateTemplateCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->descriptorUpdateEntryCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->descriptorUpdateEntryCount; ++i)
        {
            marshal_VkDescriptorUpdateTemplateEntry(vkStream, rootType, (const VkDescriptorUpdateTemplateEntry*)(forMarshaling->pDescriptorUpdateEntries + i));
        }
    }
    vkStream->write((VkDescriptorUpdateTemplateType*)&forMarshaling->templateType, sizeof(VkDescriptorUpdateTemplateType));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkDescriptorSetLayout_u64(&forMarshaling->descriptorSetLayout, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkPipelineBindPoint*)&forMarshaling->pipelineBindPoint, sizeof(VkPipelineBindPoint));
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkPipelineLayout_u64(&forMarshaling->pipelineLayout, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->set, sizeof(uint32_t));
}

void unmarshal_VkDescriptorUpdateTemplateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorUpdateTemplateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDescriptorUpdateTemplateCreateFlags*)&forUnmarshaling->flags, sizeof(VkDescriptorUpdateTemplateCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->descriptorUpdateEntryCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->descriptorUpdateEntryCount; ++i)
        {
            unmarshal_VkDescriptorUpdateTemplateEntry(vkStream, rootType, (VkDescriptorUpdateTemplateEntry*)(forUnmarshaling->pDescriptorUpdateEntries + i));
        }
    }
    vkStream->read((VkDescriptorUpdateTemplateType*)&forUnmarshaling->templateType, sizeof(VkDescriptorUpdateTemplateType));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDescriptorSetLayout(&cgen_var_0, (VkDescriptorSetLayout*)&forUnmarshaling->descriptorSetLayout, 1);
    vkStream->read((VkPipelineBindPoint*)&forUnmarshaling->pipelineBindPoint, sizeof(VkPipelineBindPoint));
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkPipelineLayout(&cgen_var_1, (VkPipelineLayout*)&forUnmarshaling->pipelineLayout, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->set, sizeof(uint32_t));
}

void marshal_VkExternalMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkExternalMemoryFeatureFlags*)&forMarshaling->externalMemoryFeatures, sizeof(VkExternalMemoryFeatureFlags));
    vkStream->write((VkExternalMemoryHandleTypeFlags*)&forMarshaling->exportFromImportedHandleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
    vkStream->write((VkExternalMemoryHandleTypeFlags*)&forMarshaling->compatibleHandleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
}

void unmarshal_VkExternalMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalMemoryProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkExternalMemoryFeatureFlags*)&forUnmarshaling->externalMemoryFeatures, sizeof(VkExternalMemoryFeatureFlags));
    vkStream->read((VkExternalMemoryHandleTypeFlags*)&forUnmarshaling->exportFromImportedHandleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
    vkStream->read((VkExternalMemoryHandleTypeFlags*)&forUnmarshaling->compatibleHandleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
}

void marshal_VkPhysicalDeviceExternalImageFormatInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalImageFormatInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkExternalMemoryHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalMemoryHandleTypeFlagBits));
}

void unmarshal_VkPhysicalDeviceExternalImageFormatInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExternalImageFormatInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkExternalMemoryHandleTypeFlagBits*)&forUnmarshaling->handleType, sizeof(VkExternalMemoryHandleTypeFlagBits));
}

void marshal_VkExternalImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalImageFormatProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkExternalMemoryProperties(vkStream, rootType, (VkExternalMemoryProperties*)(&forMarshaling->externalMemoryProperties));
}

void unmarshal_VkExternalImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalImageFormatProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkExternalMemoryProperties(vkStream, rootType, (VkExternalMemoryProperties*)(&forUnmarshaling->externalMemoryProperties));
}

void marshal_VkPhysicalDeviceExternalBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalBufferInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBufferCreateFlags*)&forMarshaling->flags, sizeof(VkBufferCreateFlags));
    vkStream->write((VkBufferUsageFlags*)&forMarshaling->usage, sizeof(VkBufferUsageFlags));
    vkStream->write((VkExternalMemoryHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalMemoryHandleTypeFlagBits));
}

void unmarshal_VkPhysicalDeviceExternalBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExternalBufferInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBufferCreateFlags*)&forUnmarshaling->flags, sizeof(VkBufferCreateFlags));
    vkStream->read((VkBufferUsageFlags*)&forUnmarshaling->usage, sizeof(VkBufferUsageFlags));
    vkStream->read((VkExternalMemoryHandleTypeFlagBits*)&forUnmarshaling->handleType, sizeof(VkExternalMemoryHandleTypeFlagBits));
}

void marshal_VkExternalBufferProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalBufferProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkExternalMemoryProperties(vkStream, rootType, (VkExternalMemoryProperties*)(&forMarshaling->externalMemoryProperties));
}

void unmarshal_VkExternalBufferProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalBufferProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkExternalMemoryProperties(vkStream, rootType, (VkExternalMemoryProperties*)(&forUnmarshaling->externalMemoryProperties));
}

void marshal_VkPhysicalDeviceIDProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceIDProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint8_t*)forMarshaling->deviceUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->write((uint8_t*)forMarshaling->driverUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->write((uint8_t*)forMarshaling->deviceLUID, VK_LUID_SIZE * sizeof(uint8_t));
    vkStream->write((uint32_t*)&forMarshaling->deviceNodeMask, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->deviceLUIDValid, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceIDProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceIDProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint8_t*)forUnmarshaling->deviceUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->read((uint8_t*)forUnmarshaling->driverUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->read((uint8_t*)forUnmarshaling->deviceLUID, VK_LUID_SIZE * sizeof(uint8_t));
    vkStream->read((uint32_t*)&forUnmarshaling->deviceNodeMask, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->deviceLUIDValid, sizeof(VkBool32));
}

void marshal_VkExternalMemoryImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryImageCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkExternalMemoryHandleTypeFlags*)&forMarshaling->handleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
}

void unmarshal_VkExternalMemoryImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalMemoryImageCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkExternalMemoryHandleTypeFlags*)&forUnmarshaling->handleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
}

void marshal_VkExternalMemoryBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryBufferCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkExternalMemoryHandleTypeFlags*)&forMarshaling->handleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
}

void unmarshal_VkExternalMemoryBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalMemoryBufferCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkExternalMemoryHandleTypeFlags*)&forUnmarshaling->handleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
}

void marshal_VkExportMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportMemoryAllocateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkExternalMemoryHandleTypeFlags*)&forMarshaling->handleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
}

void unmarshal_VkExportMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExportMemoryAllocateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkExternalMemoryHandleTypeFlags*)&forUnmarshaling->handleTypes, sizeof(VkExternalMemoryHandleTypeFlags));
}

void marshal_VkPhysicalDeviceExternalFenceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalFenceInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkExternalFenceHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalFenceHandleTypeFlagBits));
}

void unmarshal_VkPhysicalDeviceExternalFenceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExternalFenceInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkExternalFenceHandleTypeFlagBits*)&forUnmarshaling->handleType, sizeof(VkExternalFenceHandleTypeFlagBits));
}

void marshal_VkExternalFenceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalFenceProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkExternalFenceHandleTypeFlags*)&forMarshaling->exportFromImportedHandleTypes, sizeof(VkExternalFenceHandleTypeFlags));
    vkStream->write((VkExternalFenceHandleTypeFlags*)&forMarshaling->compatibleHandleTypes, sizeof(VkExternalFenceHandleTypeFlags));
    vkStream->write((VkExternalFenceFeatureFlags*)&forMarshaling->externalFenceFeatures, sizeof(VkExternalFenceFeatureFlags));
}

void unmarshal_VkExternalFenceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalFenceProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkExternalFenceHandleTypeFlags*)&forUnmarshaling->exportFromImportedHandleTypes, sizeof(VkExternalFenceHandleTypeFlags));
    vkStream->read((VkExternalFenceHandleTypeFlags*)&forUnmarshaling->compatibleHandleTypes, sizeof(VkExternalFenceHandleTypeFlags));
    vkStream->read((VkExternalFenceFeatureFlags*)&forUnmarshaling->externalFenceFeatures, sizeof(VkExternalFenceFeatureFlags));
}

void marshal_VkExportFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportFenceCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkExternalFenceHandleTypeFlags*)&forMarshaling->handleTypes, sizeof(VkExternalFenceHandleTypeFlags));
}

void unmarshal_VkExportFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExportFenceCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkExternalFenceHandleTypeFlags*)&forUnmarshaling->handleTypes, sizeof(VkExternalFenceHandleTypeFlags));
}

void marshal_VkExportSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportSemaphoreCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkExternalSemaphoreHandleTypeFlags*)&forMarshaling->handleTypes, sizeof(VkExternalSemaphoreHandleTypeFlags));
}

void unmarshal_VkExportSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExportSemaphoreCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkExternalSemaphoreHandleTypeFlags*)&forUnmarshaling->handleTypes, sizeof(VkExternalSemaphoreHandleTypeFlags));
}

void marshal_VkPhysicalDeviceExternalSemaphoreInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalSemaphoreInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkExternalSemaphoreHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalSemaphoreHandleTypeFlagBits));
}

void unmarshal_VkPhysicalDeviceExternalSemaphoreInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExternalSemaphoreInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkExternalSemaphoreHandleTypeFlagBits*)&forUnmarshaling->handleType, sizeof(VkExternalSemaphoreHandleTypeFlagBits));
}

void marshal_VkExternalSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalSemaphoreProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkExternalSemaphoreHandleTypeFlags*)&forMarshaling->exportFromImportedHandleTypes, sizeof(VkExternalSemaphoreHandleTypeFlags));
    vkStream->write((VkExternalSemaphoreHandleTypeFlags*)&forMarshaling->compatibleHandleTypes, sizeof(VkExternalSemaphoreHandleTypeFlags));
    vkStream->write((VkExternalSemaphoreFeatureFlags*)&forMarshaling->externalSemaphoreFeatures, sizeof(VkExternalSemaphoreFeatureFlags));
}

void unmarshal_VkExternalSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalSemaphoreProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkExternalSemaphoreHandleTypeFlags*)&forUnmarshaling->exportFromImportedHandleTypes, sizeof(VkExternalSemaphoreHandleTypeFlags));
    vkStream->read((VkExternalSemaphoreHandleTypeFlags*)&forUnmarshaling->compatibleHandleTypes, sizeof(VkExternalSemaphoreHandleTypeFlags));
    vkStream->read((VkExternalSemaphoreFeatureFlags*)&forUnmarshaling->externalSemaphoreFeatures, sizeof(VkExternalSemaphoreFeatureFlags));
}

void marshal_VkPhysicalDeviceMaintenance3Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance3Properties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->maxPerSetDescriptors, sizeof(uint32_t));
    vkStream->write((VkDeviceSize*)&forMarshaling->maxMemoryAllocationSize, sizeof(VkDeviceSize));
}

void unmarshal_VkPhysicalDeviceMaintenance3Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance3Properties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerSetDescriptors, sizeof(uint32_t));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->maxMemoryAllocationSize, sizeof(VkDeviceSize));
}

void marshal_VkDescriptorSetLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutSupport* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->supported, sizeof(VkBool32));
}

void unmarshal_VkDescriptorSetLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetLayoutSupport* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->supported, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceShaderDrawParametersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDrawParametersFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderDrawParameters, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceShaderDrawParametersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderDrawParametersFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDrawParameters, sizeof(VkBool32));
}

#endif
#ifdef VK_VERSION_1_2
void marshal_VkPhysicalDeviceVulkan11Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->storageBuffer16BitAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->uniformAndStorageBuffer16BitAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->storagePushConstant16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->storageInputOutput16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->multiview, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->multiviewGeometryShader, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->multiviewTessellationShader, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->variablePointersStorageBuffer, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->variablePointers, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->protectedMemory, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->samplerYcbcrConversion, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDrawParameters, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceVulkan11Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan11Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->storageBuffer16BitAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->uniformAndStorageBuffer16BitAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->storagePushConstant16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->storageInputOutput16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->multiview, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->multiviewGeometryShader, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->multiviewTessellationShader, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->variablePointersStorageBuffer, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->variablePointers, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->protectedMemory, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->samplerYcbcrConversion, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDrawParameters, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceVulkan11Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Properties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint8_t*)forMarshaling->deviceUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->write((uint8_t*)forMarshaling->driverUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->write((uint8_t*)forMarshaling->deviceLUID, VK_LUID_SIZE * sizeof(uint8_t));
    vkStream->write((uint32_t*)&forMarshaling->deviceNodeMask, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->deviceLUIDValid, sizeof(VkBool32));
    vkStream->write((uint32_t*)&forMarshaling->subgroupSize, sizeof(uint32_t));
    vkStream->write((VkShaderStageFlags*)&forMarshaling->subgroupSupportedStages, sizeof(VkShaderStageFlags));
    vkStream->write((VkSubgroupFeatureFlags*)&forMarshaling->subgroupSupportedOperations, sizeof(VkSubgroupFeatureFlags));
    vkStream->write((VkBool32*)&forMarshaling->subgroupQuadOperationsInAllStages, sizeof(VkBool32));
    vkStream->write((VkPointClippingBehavior*)&forMarshaling->pointClippingBehavior, sizeof(VkPointClippingBehavior));
    vkStream->write((uint32_t*)&forMarshaling->maxMultiviewViewCount, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxMultiviewInstanceIndex, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->protectedNoFault, sizeof(VkBool32));
    vkStream->write((uint32_t*)&forMarshaling->maxPerSetDescriptors, sizeof(uint32_t));
    vkStream->write((VkDeviceSize*)&forMarshaling->maxMemoryAllocationSize, sizeof(VkDeviceSize));
}

void unmarshal_VkPhysicalDeviceVulkan11Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan11Properties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint8_t*)forUnmarshaling->deviceUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->read((uint8_t*)forUnmarshaling->driverUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->read((uint8_t*)forUnmarshaling->deviceLUID, VK_LUID_SIZE * sizeof(uint8_t));
    vkStream->read((uint32_t*)&forUnmarshaling->deviceNodeMask, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->deviceLUIDValid, sizeof(VkBool32));
    vkStream->read((uint32_t*)&forUnmarshaling->subgroupSize, sizeof(uint32_t));
    vkStream->read((VkShaderStageFlags*)&forUnmarshaling->subgroupSupportedStages, sizeof(VkShaderStageFlags));
    vkStream->read((VkSubgroupFeatureFlags*)&forUnmarshaling->subgroupSupportedOperations, sizeof(VkSubgroupFeatureFlags));
    vkStream->read((VkBool32*)&forUnmarshaling->subgroupQuadOperationsInAllStages, sizeof(VkBool32));
    vkStream->read((VkPointClippingBehavior*)&forUnmarshaling->pointClippingBehavior, sizeof(VkPointClippingBehavior));
    vkStream->read((uint32_t*)&forUnmarshaling->maxMultiviewViewCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxMultiviewInstanceIndex, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->protectedNoFault, sizeof(VkBool32));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerSetDescriptors, sizeof(uint32_t));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->maxMemoryAllocationSize, sizeof(VkDeviceSize));
}

void marshal_VkPhysicalDeviceVulkan12Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->samplerMirrorClampToEdge, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->drawIndirectCount, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->storageBuffer8BitAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->uniformAndStorageBuffer8BitAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->storagePushConstant8, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderBufferInt64Atomics, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSharedInt64Atomics, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderInt8, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderInputAttachmentArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderUniformTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderUniformBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSampledImageArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageImageArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderInputAttachmentArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderUniformTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingUniformBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingSampledImageUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingStorageImageUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingStorageBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingUniformTexelBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingStorageTexelBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingUpdateUnusedWhilePending, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingPartiallyBound, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingVariableDescriptorCount, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->runtimeDescriptorArray, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->samplerFilterMinmax, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->scalarBlockLayout, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->imagelessFramebuffer, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->uniformBufferStandardLayout, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSubgroupExtendedTypes, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->separateDepthStencilLayouts, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->hostQueryReset, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->timelineSemaphore, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->bufferDeviceAddress, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->bufferDeviceAddressCaptureReplay, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->bufferDeviceAddressMultiDevice, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->vulkanMemoryModel, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->vulkanMemoryModelDeviceScope, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->vulkanMemoryModelAvailabilityVisibilityChains, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderOutputViewportIndex, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderOutputLayer, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->subgroupBroadcastDynamicId, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceVulkan12Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan12Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->samplerMirrorClampToEdge, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->drawIndirectCount, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->storageBuffer8BitAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->uniformAndStorageBuffer8BitAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->storagePushConstant8, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderBufferInt64Atomics, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSharedInt64Atomics, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderInt8, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderUniformTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderUniformBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSampledImageArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageImageArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderUniformTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingUniformBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingSampledImageUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingStorageImageUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingStorageBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingUniformTexelBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingStorageTexelBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingUpdateUnusedWhilePending, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingPartiallyBound, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingVariableDescriptorCount, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->runtimeDescriptorArray, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->samplerFilterMinmax, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->scalarBlockLayout, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->imagelessFramebuffer, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->uniformBufferStandardLayout, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSubgroupExtendedTypes, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->separateDepthStencilLayouts, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->hostQueryReset, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->timelineSemaphore, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->bufferDeviceAddress, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->bufferDeviceAddressCaptureReplay, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->bufferDeviceAddressMultiDevice, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->vulkanMemoryModel, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->vulkanMemoryModelDeviceScope, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->vulkanMemoryModelAvailabilityVisibilityChains, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderOutputViewportIndex, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderOutputLayer, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->subgroupBroadcastDynamicId, sizeof(VkBool32));
}

void marshal_VkConformanceVersion(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkConformanceVersion* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint8_t*)&forMarshaling->major, sizeof(uint8_t));
    vkStream->write((uint8_t*)&forMarshaling->minor, sizeof(uint8_t));
    vkStream->write((uint8_t*)&forMarshaling->subminor, sizeof(uint8_t));
    vkStream->write((uint8_t*)&forMarshaling->patch, sizeof(uint8_t));
}

void unmarshal_VkConformanceVersion(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkConformanceVersion* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint8_t*)&forUnmarshaling->major, sizeof(uint8_t));
    vkStream->read((uint8_t*)&forUnmarshaling->minor, sizeof(uint8_t));
    vkStream->read((uint8_t*)&forUnmarshaling->subminor, sizeof(uint8_t));
    vkStream->read((uint8_t*)&forUnmarshaling->patch, sizeof(uint8_t));
}

void marshal_VkPhysicalDeviceVulkan12Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Properties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDriverId*)&forMarshaling->driverID, sizeof(VkDriverId));
    vkStream->write((char*)forMarshaling->driverName, VK_MAX_DRIVER_NAME_SIZE * sizeof(char));
    vkStream->write((char*)forMarshaling->driverInfo, VK_MAX_DRIVER_INFO_SIZE * sizeof(char));
    marshal_VkConformanceVersion(vkStream, rootType, (VkConformanceVersion*)(&forMarshaling->conformanceVersion));
    vkStream->write((VkShaderFloatControlsIndependence*)&forMarshaling->denormBehaviorIndependence, sizeof(VkShaderFloatControlsIndependence));
    vkStream->write((VkShaderFloatControlsIndependence*)&forMarshaling->roundingModeIndependence, sizeof(VkShaderFloatControlsIndependence));
    vkStream->write((VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat32, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat64, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormPreserveFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormPreserveFloat32, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormPreserveFloat64, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat32, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat64, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat32, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat64, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat32, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat64, sizeof(VkBool32));
    vkStream->write((uint32_t*)&forMarshaling->maxUpdateAfterBindDescriptorsInAllPools, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->shaderUniformBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSampledImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderInputAttachmentArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->robustBufferAccessUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->quadDivergentImplicitLod, sizeof(VkBool32));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindSamplers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindSampledImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindStorageImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindInputAttachments, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageUpdateAfterBindResources, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindSamplers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindSampledImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindInputAttachments, sizeof(uint32_t));
    vkStream->write((VkResolveModeFlags*)&forMarshaling->supportedDepthResolveModes, sizeof(VkResolveModeFlags));
    vkStream->write((VkResolveModeFlags*)&forMarshaling->supportedStencilResolveModes, sizeof(VkResolveModeFlags));
    vkStream->write((VkBool32*)&forMarshaling->independentResolveNone, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->independentResolve, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->filterMinmaxSingleComponentFormats, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->filterMinmaxImageComponentMapping, sizeof(VkBool32));
    vkStream->write((uint64_t*)&forMarshaling->maxTimelineSemaphoreValueDifference, sizeof(uint64_t));
    vkStream->write((VkSampleCountFlags*)&forMarshaling->framebufferIntegerColorSampleCounts, sizeof(VkSampleCountFlags));
}

void unmarshal_VkPhysicalDeviceVulkan12Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan12Properties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDriverId*)&forUnmarshaling->driverID, sizeof(VkDriverId));
    vkStream->read((char*)forUnmarshaling->driverName, VK_MAX_DRIVER_NAME_SIZE * sizeof(char));
    vkStream->read((char*)forUnmarshaling->driverInfo, VK_MAX_DRIVER_INFO_SIZE * sizeof(char));
    unmarshal_VkConformanceVersion(vkStream, rootType, (VkConformanceVersion*)(&forUnmarshaling->conformanceVersion));
    vkStream->read((VkShaderFloatControlsIndependence*)&forUnmarshaling->denormBehaviorIndependence, sizeof(VkShaderFloatControlsIndependence));
    vkStream->read((VkShaderFloatControlsIndependence*)&forUnmarshaling->roundingModeIndependence, sizeof(VkShaderFloatControlsIndependence));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat32, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat64, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat32, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat64, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat32, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat64, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat32, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat64, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat32, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat64, sizeof(VkBool32));
    vkStream->read((uint32_t*)&forUnmarshaling->maxUpdateAfterBindDescriptorsInAllPools, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderUniformBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSampledImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->robustBufferAccessUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->quadDivergentImplicitLod, sizeof(VkBool32));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindSamplers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindSampledImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindStorageImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindInputAttachments, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageUpdateAfterBindResources, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindSamplers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindSampledImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindInputAttachments, sizeof(uint32_t));
    vkStream->read((VkResolveModeFlags*)&forUnmarshaling->supportedDepthResolveModes, sizeof(VkResolveModeFlags));
    vkStream->read((VkResolveModeFlags*)&forUnmarshaling->supportedStencilResolveModes, sizeof(VkResolveModeFlags));
    vkStream->read((VkBool32*)&forUnmarshaling->independentResolveNone, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->independentResolve, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->filterMinmaxSingleComponentFormats, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->filterMinmaxImageComponentMapping, sizeof(VkBool32));
    vkStream->read((uint64_t*)&forUnmarshaling->maxTimelineSemaphoreValueDifference, sizeof(uint64_t));
    vkStream->read((VkSampleCountFlags*)&forUnmarshaling->framebufferIntegerColorSampleCounts, sizeof(VkSampleCountFlags));
}

void marshal_VkImageFormatListCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatListCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->viewFormatCount, sizeof(uint32_t));
    vkStream->write((const VkFormat*)forMarshaling->pViewFormats, forMarshaling->viewFormatCount * sizeof(const VkFormat));
}

void unmarshal_VkImageFormatListCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageFormatListCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->viewFormatCount, sizeof(uint32_t));
    vkStream->read((VkFormat*)forUnmarshaling->pViewFormats, forUnmarshaling->viewFormatCount * sizeof(const VkFormat));
}

void marshal_VkAttachmentDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescription2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkAttachmentDescriptionFlags*)&forMarshaling->flags, sizeof(VkAttachmentDescriptionFlags));
    vkStream->write((VkFormat*)&forMarshaling->format, sizeof(VkFormat));
    vkStream->write((VkSampleCountFlagBits*)&forMarshaling->samples, sizeof(VkSampleCountFlagBits));
    vkStream->write((VkAttachmentLoadOp*)&forMarshaling->loadOp, sizeof(VkAttachmentLoadOp));
    vkStream->write((VkAttachmentStoreOp*)&forMarshaling->storeOp, sizeof(VkAttachmentStoreOp));
    vkStream->write((VkAttachmentLoadOp*)&forMarshaling->stencilLoadOp, sizeof(VkAttachmentLoadOp));
    vkStream->write((VkAttachmentStoreOp*)&forMarshaling->stencilStoreOp, sizeof(VkAttachmentStoreOp));
    vkStream->write((VkImageLayout*)&forMarshaling->initialLayout, sizeof(VkImageLayout));
    vkStream->write((VkImageLayout*)&forMarshaling->finalLayout, sizeof(VkImageLayout));
}

void unmarshal_VkAttachmentDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentDescription2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkAttachmentDescriptionFlags*)&forUnmarshaling->flags, sizeof(VkAttachmentDescriptionFlags));
    vkStream->read((VkFormat*)&forUnmarshaling->format, sizeof(VkFormat));
    vkStream->read((VkSampleCountFlagBits*)&forUnmarshaling->samples, sizeof(VkSampleCountFlagBits));
    vkStream->read((VkAttachmentLoadOp*)&forUnmarshaling->loadOp, sizeof(VkAttachmentLoadOp));
    vkStream->read((VkAttachmentStoreOp*)&forUnmarshaling->storeOp, sizeof(VkAttachmentStoreOp));
    vkStream->read((VkAttachmentLoadOp*)&forUnmarshaling->stencilLoadOp, sizeof(VkAttachmentLoadOp));
    vkStream->read((VkAttachmentStoreOp*)&forUnmarshaling->stencilStoreOp, sizeof(VkAttachmentStoreOp));
    vkStream->read((VkImageLayout*)&forUnmarshaling->initialLayout, sizeof(VkImageLayout));
    vkStream->read((VkImageLayout*)&forUnmarshaling->finalLayout, sizeof(VkImageLayout));
}

void marshal_VkAttachmentReference2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReference2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->attachment, sizeof(uint32_t));
    vkStream->write((VkImageLayout*)&forMarshaling->layout, sizeof(VkImageLayout));
    vkStream->write((VkImageAspectFlags*)&forMarshaling->aspectMask, sizeof(VkImageAspectFlags));
}

void unmarshal_VkAttachmentReference2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentReference2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->attachment, sizeof(uint32_t));
    vkStream->read((VkImageLayout*)&forUnmarshaling->layout, sizeof(VkImageLayout));
    vkStream->read((VkImageAspectFlags*)&forUnmarshaling->aspectMask, sizeof(VkImageAspectFlags));
}

void marshal_VkSubpassDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescription2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkSubpassDescriptionFlags*)&forMarshaling->flags, sizeof(VkSubpassDescriptionFlags));
    vkStream->write((VkPipelineBindPoint*)&forMarshaling->pipelineBindPoint, sizeof(VkPipelineBindPoint));
    vkStream->write((uint32_t*)&forMarshaling->viewMask, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->inputAttachmentCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->inputAttachmentCount; ++i)
        {
            marshal_VkAttachmentReference2(vkStream, rootType, (const VkAttachmentReference2*)(forMarshaling->pInputAttachments + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->colorAttachmentCount; ++i)
        {
            marshal_VkAttachmentReference2(vkStream, rootType, (const VkAttachmentReference2*)(forMarshaling->pColorAttachments + i));
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pResolveAttachments;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pResolveAttachments)
    {
        if (forMarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forMarshaling->colorAttachmentCount; ++i)
            {
                marshal_VkAttachmentReference2(vkStream, rootType, (const VkAttachmentReference2*)(forMarshaling->pResolveAttachments + i));
            }
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pDepthStencilAttachment;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pDepthStencilAttachment)
    {
        marshal_VkAttachmentReference2(vkStream, rootType, (const VkAttachmentReference2*)(forMarshaling->pDepthStencilAttachment));
    }
    vkStream->write((uint32_t*)&forMarshaling->preserveAttachmentCount, sizeof(uint32_t));
    vkStream->write((const uint32_t*)forMarshaling->pPreserveAttachments, forMarshaling->preserveAttachmentCount * sizeof(const uint32_t));
}

void unmarshal_VkSubpassDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassDescription2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkSubpassDescriptionFlags*)&forUnmarshaling->flags, sizeof(VkSubpassDescriptionFlags));
    vkStream->read((VkPipelineBindPoint*)&forUnmarshaling->pipelineBindPoint, sizeof(VkPipelineBindPoint));
    vkStream->read((uint32_t*)&forUnmarshaling->viewMask, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->inputAttachmentCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->inputAttachmentCount; ++i)
        {
            unmarshal_VkAttachmentReference2(vkStream, rootType, (VkAttachmentReference2*)(forUnmarshaling->pInputAttachments + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->colorAttachmentCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->colorAttachmentCount; ++i)
        {
            unmarshal_VkAttachmentReference2(vkStream, rootType, (VkAttachmentReference2*)(forUnmarshaling->pColorAttachments + i));
        }
    }
    // WARNING PTR CHECK
    const VkAttachmentReference2* check_pResolveAttachments;
    (void)check_pResolveAttachments;
    check_pResolveAttachments = (const VkAttachmentReference2*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pResolveAttachments)
    {
        if (!(check_pResolveAttachments))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pResolveAttachments inconsistent between guest and host\n");
        }
        if (forUnmarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->colorAttachmentCount; ++i)
            {
                unmarshal_VkAttachmentReference2(vkStream, rootType, (VkAttachmentReference2*)(forUnmarshaling->pResolveAttachments + i));
            }
        }
    }
    // WARNING PTR CHECK
    const VkAttachmentReference2* check_pDepthStencilAttachment;
    (void)check_pDepthStencilAttachment;
    check_pDepthStencilAttachment = (const VkAttachmentReference2*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pDepthStencilAttachment)
    {
        if (!(check_pDepthStencilAttachment))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pDepthStencilAttachment inconsistent between guest and host\n");
        }
        unmarshal_VkAttachmentReference2(vkStream, rootType, (VkAttachmentReference2*)(forUnmarshaling->pDepthStencilAttachment));
    }
    vkStream->read((uint32_t*)&forUnmarshaling->preserveAttachmentCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->pPreserveAttachments, forUnmarshaling->preserveAttachmentCount * sizeof(const uint32_t));
}

void marshal_VkSubpassDependency2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDependency2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->srcSubpass, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->dstSubpass, sizeof(uint32_t));
    vkStream->write((VkPipelineStageFlags*)&forMarshaling->srcStageMask, sizeof(VkPipelineStageFlags));
    vkStream->write((VkPipelineStageFlags*)&forMarshaling->dstStageMask, sizeof(VkPipelineStageFlags));
    vkStream->write((VkAccessFlags*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags));
    vkStream->write((VkAccessFlags*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags));
    vkStream->write((VkDependencyFlags*)&forMarshaling->dependencyFlags, sizeof(VkDependencyFlags));
    vkStream->write((int32_t*)&forMarshaling->viewOffset, sizeof(int32_t));
}

void unmarshal_VkSubpassDependency2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassDependency2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->srcSubpass, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->dstSubpass, sizeof(uint32_t));
    vkStream->read((VkPipelineStageFlags*)&forUnmarshaling->srcStageMask, sizeof(VkPipelineStageFlags));
    vkStream->read((VkPipelineStageFlags*)&forUnmarshaling->dstStageMask, sizeof(VkPipelineStageFlags));
    vkStream->read((VkAccessFlags*)&forUnmarshaling->srcAccessMask, sizeof(VkAccessFlags));
    vkStream->read((VkAccessFlags*)&forUnmarshaling->dstAccessMask, sizeof(VkAccessFlags));
    vkStream->read((VkDependencyFlags*)&forUnmarshaling->dependencyFlags, sizeof(VkDependencyFlags));
    vkStream->read((int32_t*)&forUnmarshaling->viewOffset, sizeof(int32_t));
}

void marshal_VkRenderPassCreateInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassCreateInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkRenderPassCreateFlags*)&forMarshaling->flags, sizeof(VkRenderPassCreateFlags));
    vkStream->write((uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->attachmentCount; ++i)
        {
            marshal_VkAttachmentDescription2(vkStream, rootType, (const VkAttachmentDescription2*)(forMarshaling->pAttachments + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->subpassCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->subpassCount; ++i)
        {
            marshal_VkSubpassDescription2(vkStream, rootType, (const VkSubpassDescription2*)(forMarshaling->pSubpasses + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->dependencyCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->dependencyCount; ++i)
        {
            marshal_VkSubpassDependency2(vkStream, rootType, (const VkSubpassDependency2*)(forMarshaling->pDependencies + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->correlatedViewMaskCount, sizeof(uint32_t));
    vkStream->write((const uint32_t*)forMarshaling->pCorrelatedViewMasks, forMarshaling->correlatedViewMaskCount * sizeof(const uint32_t));
}

void unmarshal_VkRenderPassCreateInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassCreateInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkRenderPassCreateFlags*)&forUnmarshaling->flags, sizeof(VkRenderPassCreateFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->attachmentCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->attachmentCount; ++i)
        {
            unmarshal_VkAttachmentDescription2(vkStream, rootType, (VkAttachmentDescription2*)(forUnmarshaling->pAttachments + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->subpassCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->subpassCount; ++i)
        {
            unmarshal_VkSubpassDescription2(vkStream, rootType, (VkSubpassDescription2*)(forUnmarshaling->pSubpasses + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->dependencyCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->dependencyCount; ++i)
        {
            unmarshal_VkSubpassDependency2(vkStream, rootType, (VkSubpassDependency2*)(forUnmarshaling->pDependencies + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->correlatedViewMaskCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->pCorrelatedViewMasks, forUnmarshaling->correlatedViewMaskCount * sizeof(const uint32_t));
}

void marshal_VkSubpassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassBeginInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkSubpassContents*)&forMarshaling->contents, sizeof(VkSubpassContents));
}

void unmarshal_VkSubpassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassBeginInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkSubpassContents*)&forUnmarshaling->contents, sizeof(VkSubpassContents));
}

void marshal_VkSubpassEndInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassEndInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
}

void unmarshal_VkSubpassEndInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassEndInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
}

void marshal_VkPhysicalDevice8BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice8BitStorageFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->storageBuffer8BitAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->uniformAndStorageBuffer8BitAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->storagePushConstant8, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDevice8BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevice8BitStorageFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->storageBuffer8BitAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->uniformAndStorageBuffer8BitAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->storagePushConstant8, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceDriverProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDriverProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDriverId*)&forMarshaling->driverID, sizeof(VkDriverId));
    vkStream->write((char*)forMarshaling->driverName, VK_MAX_DRIVER_NAME_SIZE * sizeof(char));
    vkStream->write((char*)forMarshaling->driverInfo, VK_MAX_DRIVER_INFO_SIZE * sizeof(char));
    marshal_VkConformanceVersion(vkStream, rootType, (VkConformanceVersion*)(&forMarshaling->conformanceVersion));
}

void unmarshal_VkPhysicalDeviceDriverProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDriverProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDriverId*)&forUnmarshaling->driverID, sizeof(VkDriverId));
    vkStream->read((char*)forUnmarshaling->driverName, VK_MAX_DRIVER_NAME_SIZE * sizeof(char));
    vkStream->read((char*)forUnmarshaling->driverInfo, VK_MAX_DRIVER_INFO_SIZE * sizeof(char));
    unmarshal_VkConformanceVersion(vkStream, rootType, (VkConformanceVersion*)(&forUnmarshaling->conformanceVersion));
}

void marshal_VkPhysicalDeviceShaderAtomicInt64Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderAtomicInt64Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderBufferInt64Atomics, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSharedInt64Atomics, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceShaderAtomicInt64Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderAtomicInt64Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderBufferInt64Atomics, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSharedInt64Atomics, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceShaderFloat16Int8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloat16Int8Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderInt8, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceShaderFloat16Int8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderFloat16Int8Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderInt8, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceFloatControlsProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFloatControlsProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkShaderFloatControlsIndependence*)&forMarshaling->denormBehaviorIndependence, sizeof(VkShaderFloatControlsIndependence));
    vkStream->write((VkShaderFloatControlsIndependence*)&forMarshaling->roundingModeIndependence, sizeof(VkShaderFloatControlsIndependence));
    vkStream->write((VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat32, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSignedZeroInfNanPreserveFloat64, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormPreserveFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormPreserveFloat32, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormPreserveFloat64, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat32, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDenormFlushToZeroFloat64, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat32, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTEFloat64, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat16, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat32, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderRoundingModeRTZFloat64, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceFloatControlsProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceFloatControlsProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkShaderFloatControlsIndependence*)&forUnmarshaling->denormBehaviorIndependence, sizeof(VkShaderFloatControlsIndependence));
    vkStream->read((VkShaderFloatControlsIndependence*)&forUnmarshaling->roundingModeIndependence, sizeof(VkShaderFloatControlsIndependence));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat32, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat64, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat32, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat64, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat32, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat64, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat32, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat64, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat16, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat32, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat64, sizeof(VkBool32));
}

void marshal_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBindingFlagsCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->bindingCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pBindingFlags;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pBindingFlags)
    {
        vkStream->write((const VkDescriptorBindingFlags*)forMarshaling->pBindingFlags, forMarshaling->bindingCount * sizeof(const VkDescriptorBindingFlags));
    }
}

void unmarshal_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetLayoutBindingFlagsCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->bindingCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const VkDescriptorBindingFlags* check_pBindingFlags;
    (void)check_pBindingFlags;
    check_pBindingFlags = (const VkDescriptorBindingFlags*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pBindingFlags)
    {
        if (!(check_pBindingFlags))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pBindingFlags inconsistent between guest and host\n");
        }
        vkStream->read((VkDescriptorBindingFlags*)forUnmarshaling->pBindingFlags, forUnmarshaling->bindingCount * sizeof(const VkDescriptorBindingFlags));
    }
}

void marshal_VkPhysicalDeviceDescriptorIndexingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderInputAttachmentArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderUniformTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderUniformBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSampledImageArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageImageArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderInputAttachmentArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderUniformTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingUniformBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingSampledImageUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingStorageImageUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingStorageBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingUniformTexelBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingStorageTexelBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingUpdateUnusedWhilePending, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingPartiallyBound, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingVariableDescriptorCount, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->runtimeDescriptorArray, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceDescriptorIndexingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDescriptorIndexingFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderUniformTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageTexelBufferArrayDynamicIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderUniformBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSampledImageArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageImageArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderUniformTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageTexelBufferArrayNonUniformIndexing, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingUniformBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingSampledImageUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingStorageImageUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingStorageBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingUniformTexelBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingStorageTexelBufferUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingUpdateUnusedWhilePending, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingPartiallyBound, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingVariableDescriptorCount, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->runtimeDescriptorArray, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceDescriptorIndexingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->maxUpdateAfterBindDescriptorsInAllPools, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->shaderUniformBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSampledImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderStorageImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderInputAttachmentArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->robustBufferAccessUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->quadDivergentImplicitLod, sizeof(VkBool32));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindSamplers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindSampledImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindStorageImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindInputAttachments, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageUpdateAfterBindResources, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindSamplers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindSampledImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindStorageImages, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindInputAttachments, sizeof(uint32_t));
}

void unmarshal_VkPhysicalDeviceDescriptorIndexingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDescriptorIndexingProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->maxUpdateAfterBindDescriptorsInAllPools, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderUniformBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSampledImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageBufferArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderStorageImageArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayNonUniformIndexingNative, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->robustBufferAccessUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->quadDivergentImplicitLod, sizeof(VkBool32));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindSamplers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindSampledImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindStorageImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindInputAttachments, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageUpdateAfterBindResources, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindSamplers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindUniformBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageBuffers, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindSampledImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageImages, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindInputAttachments, sizeof(uint32_t));
}

void marshal_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountAllocateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->descriptorSetCount, sizeof(uint32_t));
    vkStream->write((const uint32_t*)forMarshaling->pDescriptorCounts, forMarshaling->descriptorSetCount * sizeof(const uint32_t));
}

void unmarshal_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetVariableDescriptorCountAllocateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->descriptorSetCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)forUnmarshaling->pDescriptorCounts, forUnmarshaling->descriptorSetCount * sizeof(const uint32_t));
}

void marshal_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountLayoutSupport* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->maxVariableDescriptorCount, sizeof(uint32_t));
}

void unmarshal_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetVariableDescriptorCountLayoutSupport* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->maxVariableDescriptorCount, sizeof(uint32_t));
}

void marshal_VkSubpassDescriptionDepthStencilResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescriptionDepthStencilResolve* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkResolveModeFlagBits*)&forMarshaling->depthResolveMode, sizeof(VkResolveModeFlagBits));
    vkStream->write((VkResolveModeFlagBits*)&forMarshaling->stencilResolveMode, sizeof(VkResolveModeFlagBits));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pDepthStencilResolveAttachment;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pDepthStencilResolveAttachment)
    {
        marshal_VkAttachmentReference2(vkStream, rootType, (const VkAttachmentReference2*)(forMarshaling->pDepthStencilResolveAttachment));
    }
}

void unmarshal_VkSubpassDescriptionDepthStencilResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassDescriptionDepthStencilResolve* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkResolveModeFlagBits*)&forUnmarshaling->depthResolveMode, sizeof(VkResolveModeFlagBits));
    vkStream->read((VkResolveModeFlagBits*)&forUnmarshaling->stencilResolveMode, sizeof(VkResolveModeFlagBits));
    // WARNING PTR CHECK
    const VkAttachmentReference2* check_pDepthStencilResolveAttachment;
    (void)check_pDepthStencilResolveAttachment;
    check_pDepthStencilResolveAttachment = (const VkAttachmentReference2*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pDepthStencilResolveAttachment)
    {
        if (!(check_pDepthStencilResolveAttachment))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pDepthStencilResolveAttachment inconsistent between guest and host\n");
        }
        unmarshal_VkAttachmentReference2(vkStream, rootType, (VkAttachmentReference2*)(forUnmarshaling->pDepthStencilResolveAttachment));
    }
}

void marshal_VkPhysicalDeviceDepthStencilResolveProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthStencilResolveProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkResolveModeFlags*)&forMarshaling->supportedDepthResolveModes, sizeof(VkResolveModeFlags));
    vkStream->write((VkResolveModeFlags*)&forMarshaling->supportedStencilResolveModes, sizeof(VkResolveModeFlags));
    vkStream->write((VkBool32*)&forMarshaling->independentResolveNone, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->independentResolve, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceDepthStencilResolveProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDepthStencilResolveProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkResolveModeFlags*)&forUnmarshaling->supportedDepthResolveModes, sizeof(VkResolveModeFlags));
    vkStream->read((VkResolveModeFlags*)&forUnmarshaling->supportedStencilResolveModes, sizeof(VkResolveModeFlags));
    vkStream->read((VkBool32*)&forUnmarshaling->independentResolveNone, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->independentResolve, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceScalarBlockLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceScalarBlockLayoutFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->scalarBlockLayout, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceScalarBlockLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceScalarBlockLayoutFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->scalarBlockLayout, sizeof(VkBool32));
}

void marshal_VkImageStencilUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageStencilUsageCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkImageUsageFlags*)&forMarshaling->stencilUsage, sizeof(VkImageUsageFlags));
}

void unmarshal_VkImageStencilUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageStencilUsageCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkImageUsageFlags*)&forUnmarshaling->stencilUsage, sizeof(VkImageUsageFlags));
}

void marshal_VkSamplerReductionModeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerReductionModeCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkSamplerReductionMode*)&forMarshaling->reductionMode, sizeof(VkSamplerReductionMode));
}

void unmarshal_VkSamplerReductionModeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerReductionModeCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkSamplerReductionMode*)&forUnmarshaling->reductionMode, sizeof(VkSamplerReductionMode));
}

void marshal_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerFilterMinmaxProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->filterMinmaxSingleComponentFormats, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->filterMinmaxImageComponentMapping, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSamplerFilterMinmaxProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->filterMinmaxSingleComponentFormats, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->filterMinmaxImageComponentMapping, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceVulkanMemoryModelFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkanMemoryModelFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->vulkanMemoryModel, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->vulkanMemoryModelDeviceScope, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->vulkanMemoryModelAvailabilityVisibilityChains, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceVulkanMemoryModelFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkanMemoryModelFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->vulkanMemoryModel, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->vulkanMemoryModelDeviceScope, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->vulkanMemoryModelAvailabilityVisibilityChains, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceImagelessFramebufferFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImagelessFramebufferFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->imagelessFramebuffer, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceImagelessFramebufferFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImagelessFramebufferFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->imagelessFramebuffer, sizeof(VkBool32));
}

void marshal_VkFramebufferAttachmentImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferAttachmentImageInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkImageCreateFlags*)&forMarshaling->flags, sizeof(VkImageCreateFlags));
    vkStream->write((VkImageUsageFlags*)&forMarshaling->usage, sizeof(VkImageUsageFlags));
    vkStream->write((uint32_t*)&forMarshaling->width, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->height, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->layerCount, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->viewFormatCount, sizeof(uint32_t));
    vkStream->write((const VkFormat*)forMarshaling->pViewFormats, forMarshaling->viewFormatCount * sizeof(const VkFormat));
}

void unmarshal_VkFramebufferAttachmentImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFramebufferAttachmentImageInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkImageCreateFlags*)&forUnmarshaling->flags, sizeof(VkImageCreateFlags));
    vkStream->read((VkImageUsageFlags*)&forUnmarshaling->usage, sizeof(VkImageUsageFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->width, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->height, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->layerCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->viewFormatCount, sizeof(uint32_t));
    vkStream->read((VkFormat*)forUnmarshaling->pViewFormats, forUnmarshaling->viewFormatCount * sizeof(const VkFormat));
}

void marshal_VkFramebufferAttachmentsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferAttachmentsCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->attachmentImageInfoCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->attachmentImageInfoCount; ++i)
        {
            marshal_VkFramebufferAttachmentImageInfo(vkStream, rootType, (const VkFramebufferAttachmentImageInfo*)(forMarshaling->pAttachmentImageInfos + i));
        }
    }
}

void unmarshal_VkFramebufferAttachmentsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFramebufferAttachmentsCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->attachmentImageInfoCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->attachmentImageInfoCount; ++i)
        {
            unmarshal_VkFramebufferAttachmentImageInfo(vkStream, rootType, (VkFramebufferAttachmentImageInfo*)(forUnmarshaling->pAttachmentImageInfos + i));
        }
    }
}

void marshal_VkRenderPassAttachmentBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassAttachmentBeginInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    if (forMarshaling->attachmentCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forMarshaling->attachmentCount * 8);
        vkStream->handleMapping()->mapHandles_VkImageView_u64(forMarshaling->pAttachments, cgen_var_0, forMarshaling->attachmentCount);
        vkStream->write((uint64_t*)cgen_var_0, forMarshaling->attachmentCount * 8);
    }
}

void unmarshal_VkRenderPassAttachmentBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassAttachmentBeginInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->attachmentCount, sizeof(uint32_t));
    if (forUnmarshaling->attachmentCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forUnmarshaling->attachmentCount * 8);
        vkStream->read((uint64_t*)cgen_var_0, forUnmarshaling->attachmentCount * 8);
        vkStream->handleMapping()->mapHandles_u64_VkImageView(cgen_var_0, (VkImageView*)forUnmarshaling->pAttachments, forUnmarshaling->attachmentCount);
    }
}

void marshal_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->uniformBufferStandardLayout, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->uniformBufferStandardLayout, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderSubgroupExtendedTypes, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSubgroupExtendedTypes, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->separateDepthStencilLayouts, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->separateDepthStencilLayouts, sizeof(VkBool32));
}

void marshal_VkAttachmentReferenceStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReferenceStencilLayout* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkImageLayout*)&forMarshaling->stencilLayout, sizeof(VkImageLayout));
}

void unmarshal_VkAttachmentReferenceStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentReferenceStencilLayout* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkImageLayout*)&forUnmarshaling->stencilLayout, sizeof(VkImageLayout));
}

void marshal_VkAttachmentDescriptionStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescriptionStencilLayout* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkImageLayout*)&forMarshaling->stencilInitialLayout, sizeof(VkImageLayout));
    vkStream->write((VkImageLayout*)&forMarshaling->stencilFinalLayout, sizeof(VkImageLayout));
}

void unmarshal_VkAttachmentDescriptionStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentDescriptionStencilLayout* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkImageLayout*)&forUnmarshaling->stencilInitialLayout, sizeof(VkImageLayout));
    vkStream->read((VkImageLayout*)&forUnmarshaling->stencilFinalLayout, sizeof(VkImageLayout));
}

void marshal_VkPhysicalDeviceHostQueryResetFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostQueryResetFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->hostQueryReset, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceHostQueryResetFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceHostQueryResetFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->hostQueryReset, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceTimelineSemaphoreFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->timelineSemaphore, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceTimelineSemaphoreFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTimelineSemaphoreFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->timelineSemaphore, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceTimelineSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint64_t*)&forMarshaling->maxTimelineSemaphoreValueDifference, sizeof(uint64_t));
}

void unmarshal_VkPhysicalDeviceTimelineSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTimelineSemaphoreProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint64_t*)&forUnmarshaling->maxTimelineSemaphoreValueDifference, sizeof(uint64_t));
}

void marshal_VkSemaphoreTypeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreTypeCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkSemaphoreType*)&forMarshaling->semaphoreType, sizeof(VkSemaphoreType));
    vkStream->write((uint64_t*)&forMarshaling->initialValue, sizeof(uint64_t));
}

void unmarshal_VkSemaphoreTypeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreTypeCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkSemaphoreType*)&forUnmarshaling->semaphoreType, sizeof(VkSemaphoreType));
    vkStream->read((uint64_t*)&forUnmarshaling->initialValue, sizeof(uint64_t));
}

void marshal_VkTimelineSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkTimelineSemaphoreSubmitInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->waitSemaphoreValueCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pWaitSemaphoreValues;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pWaitSemaphoreValues)
    {
        vkStream->write((const uint64_t*)forMarshaling->pWaitSemaphoreValues, forMarshaling->waitSemaphoreValueCount * sizeof(const uint64_t));
    }
    vkStream->write((uint32_t*)&forMarshaling->signalSemaphoreValueCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pSignalSemaphoreValues;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pSignalSemaphoreValues)
    {
        vkStream->write((const uint64_t*)forMarshaling->pSignalSemaphoreValues, forMarshaling->signalSemaphoreValueCount * sizeof(const uint64_t));
    }
}

void unmarshal_VkTimelineSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkTimelineSemaphoreSubmitInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->waitSemaphoreValueCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const uint64_t* check_pWaitSemaphoreValues;
    (void)check_pWaitSemaphoreValues;
    check_pWaitSemaphoreValues = (const uint64_t*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pWaitSemaphoreValues)
    {
        if (!(check_pWaitSemaphoreValues))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pWaitSemaphoreValues inconsistent between guest and host\n");
        }
        vkStream->read((uint64_t*)forUnmarshaling->pWaitSemaphoreValues, forUnmarshaling->waitSemaphoreValueCount * sizeof(const uint64_t));
    }
    vkStream->read((uint32_t*)&forUnmarshaling->signalSemaphoreValueCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const uint64_t* check_pSignalSemaphoreValues;
    (void)check_pSignalSemaphoreValues;
    check_pSignalSemaphoreValues = (const uint64_t*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pSignalSemaphoreValues)
    {
        if (!(check_pSignalSemaphoreValues))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pSignalSemaphoreValues inconsistent between guest and host\n");
        }
        vkStream->read((uint64_t*)forUnmarshaling->pSignalSemaphoreValues, forUnmarshaling->signalSemaphoreValueCount * sizeof(const uint64_t));
    }
}

void marshal_VkSemaphoreWaitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreWaitInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkSemaphoreWaitFlags*)&forMarshaling->flags, sizeof(VkSemaphoreWaitFlags));
    vkStream->write((uint32_t*)&forMarshaling->semaphoreCount, sizeof(uint32_t));
    if (forMarshaling->semaphoreCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forMarshaling->semaphoreCount * 8);
        vkStream->handleMapping()->mapHandles_VkSemaphore_u64(forMarshaling->pSemaphores, cgen_var_0, forMarshaling->semaphoreCount);
        vkStream->write((uint64_t*)cgen_var_0, forMarshaling->semaphoreCount * 8);
    }
    vkStream->write((const uint64_t*)forMarshaling->pValues, forMarshaling->semaphoreCount * sizeof(const uint64_t));
}

void unmarshal_VkSemaphoreWaitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreWaitInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkSemaphoreWaitFlags*)&forUnmarshaling->flags, sizeof(VkSemaphoreWaitFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->semaphoreCount, sizeof(uint32_t));
    if (forUnmarshaling->semaphoreCount)
    {
        uint64_t* cgen_var_0;
        vkStream->alloc((void**)&cgen_var_0, forUnmarshaling->semaphoreCount * 8);
        vkStream->read((uint64_t*)cgen_var_0, forUnmarshaling->semaphoreCount * 8);
        vkStream->handleMapping()->mapHandles_u64_VkSemaphore(cgen_var_0, (VkSemaphore*)forUnmarshaling->pSemaphores, forUnmarshaling->semaphoreCount);
    }
    vkStream->read((uint64_t*)forUnmarshaling->pValues, forUnmarshaling->semaphoreCount * sizeof(const uint64_t));
}

void marshal_VkSemaphoreSignalInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreSignalInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkSemaphore_u64(&forMarshaling->semaphore, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint64_t*)&forMarshaling->value, sizeof(uint64_t));
}

void unmarshal_VkSemaphoreSignalInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreSignalInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkSemaphore(&cgen_var_0, (VkSemaphore*)&forUnmarshaling->semaphore, 1);
    vkStream->read((uint64_t*)&forUnmarshaling->value, sizeof(uint64_t));
}

void marshal_VkPhysicalDeviceBufferDeviceAddressFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceBufferDeviceAddressFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->bufferDeviceAddress, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->bufferDeviceAddressCaptureReplay, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->bufferDeviceAddressMultiDevice, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceBufferDeviceAddressFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceBufferDeviceAddressFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->bufferDeviceAddress, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->bufferDeviceAddressCaptureReplay, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->bufferDeviceAddressMultiDevice, sizeof(VkBool32));
}

void marshal_VkBufferDeviceAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferDeviceAddressInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->buffer, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
}

void unmarshal_VkBufferDeviceAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferDeviceAddressInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_0, (VkBuffer*)&forUnmarshaling->buffer, 1);
}

void marshal_VkBufferOpaqueCaptureAddressCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferOpaqueCaptureAddressCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint64_t*)&forMarshaling->opaqueCaptureAddress, sizeof(uint64_t));
}

void unmarshal_VkBufferOpaqueCaptureAddressCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferOpaqueCaptureAddressCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint64_t*)&forUnmarshaling->opaqueCaptureAddress, sizeof(uint64_t));
}

void marshal_VkMemoryOpaqueCaptureAddressAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryOpaqueCaptureAddressAllocateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint64_t*)&forMarshaling->opaqueCaptureAddress, sizeof(uint64_t));
}

void unmarshal_VkMemoryOpaqueCaptureAddressAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryOpaqueCaptureAddressAllocateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint64_t*)&forUnmarshaling->opaqueCaptureAddress, sizeof(uint64_t));
}

void marshal_VkDeviceMemoryOpaqueCaptureAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceMemoryOpaqueCaptureAddressInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkDeviceMemory_u64(&forMarshaling->memory, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
}

void unmarshal_VkDeviceMemoryOpaqueCaptureAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceMemoryOpaqueCaptureAddressInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDeviceMemory(&cgen_var_0, (VkDeviceMemory*)&forUnmarshaling->memory, 1);
}

#endif
#ifdef VK_VERSION_1_3
void marshal_VkPhysicalDeviceVulkan13Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->robustImageAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->inlineUniformBlock, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingInlineUniformBlockUpdateAfterBind, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->pipelineCreationCacheControl, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->privateData, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderDemoteToHelperInvocation, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderTerminateInvocation, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->subgroupSizeControl, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->computeFullSubgroups, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->synchronization2, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->textureCompressionASTC_HDR, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderZeroInitializeWorkgroupMemory, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->dynamicRendering, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderIntegerDotProduct, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->maintenance4, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceVulkan13Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan13Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->robustImageAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->inlineUniformBlock, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingInlineUniformBlockUpdateAfterBind, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->pipelineCreationCacheControl, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->privateData, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDemoteToHelperInvocation, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderTerminateInvocation, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->subgroupSizeControl, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->computeFullSubgroups, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->synchronization2, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->textureCompressionASTC_HDR, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderZeroInitializeWorkgroupMemory, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->dynamicRendering, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderIntegerDotProduct, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->maintenance4, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceVulkan13Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Properties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->minSubgroupSize, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxSubgroupSize, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxComputeWorkgroupSubgroups, sizeof(uint32_t));
    vkStream->write((VkShaderStageFlags*)&forMarshaling->requiredSubgroupSizeStages, sizeof(VkShaderStageFlags));
    vkStream->write((uint32_t*)&forMarshaling->maxInlineUniformBlockSize, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorInlineUniformBlocks, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetInlineUniformBlocks, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxInlineUniformTotalSize, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct8BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct8BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct8BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct16BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct16BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct16BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct32BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct32BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct32BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct64BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct64BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct64BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkDeviceSize*)&forMarshaling->storageTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    vkStream->write((VkBool32*)&forMarshaling->storageTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
    vkStream->write((VkDeviceSize*)&forMarshaling->uniformTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    vkStream->write((VkBool32*)&forMarshaling->uniformTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
    vkStream->write((VkDeviceSize*)&forMarshaling->maxBufferSize, sizeof(VkDeviceSize));
}

void unmarshal_VkPhysicalDeviceVulkan13Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan13Properties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->minSubgroupSize, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxSubgroupSize, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxComputeWorkgroupSubgroups, sizeof(uint32_t));
    vkStream->read((VkShaderStageFlags*)&forUnmarshaling->requiredSubgroupSizeStages, sizeof(VkShaderStageFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->maxInlineUniformBlockSize, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorInlineUniformBlocks, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetInlineUniformBlocks, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxInlineUniformTotalSize, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct8BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct8BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct8BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct16BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct16BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct16BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct32BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct32BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct32BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct64BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct64BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct64BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating8BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating16BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating32BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating64BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->storageTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    vkStream->read((VkBool32*)&forUnmarshaling->storageTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->uniformTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    vkStream->read((VkBool32*)&forUnmarshaling->uniformTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->maxBufferSize, sizeof(VkDeviceSize));
}

void marshal_VkPipelineCreationFeedback(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreationFeedback* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkPipelineCreationFeedbackFlags*)&forMarshaling->flags, sizeof(VkPipelineCreationFeedbackFlags));
    vkStream->write((uint64_t*)&forMarshaling->duration, sizeof(uint64_t));
}

void unmarshal_VkPipelineCreationFeedback(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineCreationFeedback* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkPipelineCreationFeedbackFlags*)&forUnmarshaling->flags, sizeof(VkPipelineCreationFeedbackFlags));
    vkStream->read((uint64_t*)&forUnmarshaling->duration, sizeof(uint64_t));
}

void marshal_VkPipelineCreationFeedbackCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreationFeedbackCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkPipelineCreationFeedback(vkStream, rootType, (VkPipelineCreationFeedback*)(forMarshaling->pPipelineCreationFeedback));
    vkStream->write((uint32_t*)&forMarshaling->pipelineStageCreationFeedbackCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->pipelineStageCreationFeedbackCount; ++i)
        {
            marshal_VkPipelineCreationFeedback(vkStream, rootType, (VkPipelineCreationFeedback*)(forMarshaling->pPipelineStageCreationFeedbacks + i));
        }
    }
}

void unmarshal_VkPipelineCreationFeedbackCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineCreationFeedbackCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkPipelineCreationFeedback(vkStream, rootType, (VkPipelineCreationFeedback*)(forUnmarshaling->pPipelineCreationFeedback));
    vkStream->read((uint32_t*)&forUnmarshaling->pipelineStageCreationFeedbackCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->pipelineStageCreationFeedbackCount; ++i)
        {
            unmarshal_VkPipelineCreationFeedback(vkStream, rootType, (VkPipelineCreationFeedback*)(forUnmarshaling->pPipelineStageCreationFeedbacks + i));
        }
    }
}

void marshal_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderTerminateInvocationFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderTerminateInvocation, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderTerminateInvocationFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderTerminateInvocation, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceToolProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceToolProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((char*)forMarshaling->name, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    vkStream->write((char*)forMarshaling->version, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    vkStream->write((VkToolPurposeFlags*)&forMarshaling->purposes, sizeof(VkToolPurposeFlags));
    vkStream->write((char*)forMarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->write((char*)forMarshaling->layer, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
}

void unmarshal_VkPhysicalDeviceToolProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceToolProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((char*)forUnmarshaling->name, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    vkStream->read((char*)forUnmarshaling->version, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    vkStream->read((VkToolPurposeFlags*)&forUnmarshaling->purposes, sizeof(VkToolPurposeFlags));
    vkStream->read((char*)forUnmarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->read((char*)forUnmarshaling->layer, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
}

void marshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderDemoteToHelperInvocation, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderDemoteToHelperInvocation, sizeof(VkBool32));
}

void marshal_VkPhysicalDevicePrivateDataFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePrivateDataFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->privateData, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDevicePrivateDataFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePrivateDataFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->privateData, sizeof(VkBool32));
}

void marshal_VkDevicePrivateDataCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDevicePrivateDataCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->privateDataSlotRequestCount, sizeof(uint32_t));
}

void unmarshal_VkDevicePrivateDataCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDevicePrivateDataCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->privateDataSlotRequestCount, sizeof(uint32_t));
}

void marshal_VkPrivateDataSlotCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPrivateDataSlotCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPrivateDataSlotCreateFlags*)&forMarshaling->flags, sizeof(VkPrivateDataSlotCreateFlags));
}

void unmarshal_VkPrivateDataSlotCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPrivateDataSlotCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPrivateDataSlotCreateFlags*)&forUnmarshaling->flags, sizeof(VkPrivateDataSlotCreateFlags));
}

void marshal_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineCreationCacheControlFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->pipelineCreationCacheControl, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePipelineCreationCacheControlFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->pipelineCreationCacheControl, sizeof(VkBool32));
}

void marshal_VkMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryBarrier2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineStageFlags2*)&forMarshaling->srcStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->write((VkAccessFlags2*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags2));
    vkStream->write((VkPipelineStageFlags2*)&forMarshaling->dstStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->write((VkAccessFlags2*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags2));
}

void unmarshal_VkMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryBarrier2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineStageFlags2*)&forUnmarshaling->srcStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->read((VkAccessFlags2*)&forUnmarshaling->srcAccessMask, sizeof(VkAccessFlags2));
    vkStream->read((VkPipelineStageFlags2*)&forUnmarshaling->dstStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->read((VkAccessFlags2*)&forUnmarshaling->dstAccessMask, sizeof(VkAccessFlags2));
}

void marshal_VkBufferMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryBarrier2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineStageFlags2*)&forMarshaling->srcStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->write((VkAccessFlags2*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags2));
    vkStream->write((VkPipelineStageFlags2*)&forMarshaling->dstStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->write((VkAccessFlags2*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags2));
    vkStream->write((uint32_t*)&forMarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->buffer, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
}

void unmarshal_VkBufferMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferMemoryBarrier2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineStageFlags2*)&forUnmarshaling->srcStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->read((VkAccessFlags2*)&forUnmarshaling->srcAccessMask, sizeof(VkAccessFlags2));
    vkStream->read((VkPipelineStageFlags2*)&forUnmarshaling->dstStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->read((VkAccessFlags2*)&forUnmarshaling->dstAccessMask, sizeof(VkAccessFlags2));
    vkStream->read((uint32_t*)&forUnmarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_0, (VkBuffer*)&forUnmarshaling->buffer, 1);
    vkStream->read((VkDeviceSize*)&forUnmarshaling->offset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
}

void marshal_VkImageMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryBarrier2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineStageFlags2*)&forMarshaling->srcStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->write((VkAccessFlags2*)&forMarshaling->srcAccessMask, sizeof(VkAccessFlags2));
    vkStream->write((VkPipelineStageFlags2*)&forMarshaling->dstStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->write((VkAccessFlags2*)&forMarshaling->dstAccessMask, sizeof(VkAccessFlags2));
    vkStream->write((VkImageLayout*)&forMarshaling->oldLayout, sizeof(VkImageLayout));
    vkStream->write((VkImageLayout*)&forMarshaling->newLayout, sizeof(VkImageLayout));
    vkStream->write((uint32_t*)&forMarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->image, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    marshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forMarshaling->subresourceRange));
}

void unmarshal_VkImageMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageMemoryBarrier2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineStageFlags2*)&forUnmarshaling->srcStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->read((VkAccessFlags2*)&forUnmarshaling->srcAccessMask, sizeof(VkAccessFlags2));
    vkStream->read((VkPipelineStageFlags2*)&forUnmarshaling->dstStageMask, sizeof(VkPipelineStageFlags2));
    vkStream->read((VkAccessFlags2*)&forUnmarshaling->dstAccessMask, sizeof(VkAccessFlags2));
    vkStream->read((VkImageLayout*)&forUnmarshaling->oldLayout, sizeof(VkImageLayout));
    vkStream->read((VkImageLayout*)&forUnmarshaling->newLayout, sizeof(VkImageLayout));
    vkStream->read((uint32_t*)&forUnmarshaling->srcQueueFamilyIndex, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->dstQueueFamilyIndex, sizeof(uint32_t));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->image, 1);
    unmarshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forUnmarshaling->subresourceRange));
}

void marshal_VkDependencyInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDependencyInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDependencyFlags*)&forMarshaling->dependencyFlags, sizeof(VkDependencyFlags));
    vkStream->write((uint32_t*)&forMarshaling->memoryBarrierCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->memoryBarrierCount; ++i)
        {
            marshal_VkMemoryBarrier2(vkStream, rootType, (const VkMemoryBarrier2*)(forMarshaling->pMemoryBarriers + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->bufferMemoryBarrierCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->bufferMemoryBarrierCount; ++i)
        {
            marshal_VkBufferMemoryBarrier2(vkStream, rootType, (const VkBufferMemoryBarrier2*)(forMarshaling->pBufferMemoryBarriers + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->imageMemoryBarrierCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->imageMemoryBarrierCount; ++i)
        {
            marshal_VkImageMemoryBarrier2(vkStream, rootType, (const VkImageMemoryBarrier2*)(forMarshaling->pImageMemoryBarriers + i));
        }
    }
}

void unmarshal_VkDependencyInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDependencyInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDependencyFlags*)&forUnmarshaling->dependencyFlags, sizeof(VkDependencyFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->memoryBarrierCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->memoryBarrierCount; ++i)
        {
            unmarshal_VkMemoryBarrier2(vkStream, rootType, (VkMemoryBarrier2*)(forUnmarshaling->pMemoryBarriers + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->bufferMemoryBarrierCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bufferMemoryBarrierCount; ++i)
        {
            unmarshal_VkBufferMemoryBarrier2(vkStream, rootType, (VkBufferMemoryBarrier2*)(forUnmarshaling->pBufferMemoryBarriers + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->imageMemoryBarrierCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->imageMemoryBarrierCount; ++i)
        {
            unmarshal_VkImageMemoryBarrier2(vkStream, rootType, (VkImageMemoryBarrier2*)(forUnmarshaling->pImageMemoryBarriers + i));
        }
    }
}

void marshal_VkSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreSubmitInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkSemaphore_u64(&forMarshaling->semaphore, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint64_t*)&forMarshaling->value, sizeof(uint64_t));
    vkStream->write((VkPipelineStageFlags2*)&forMarshaling->stageMask, sizeof(VkPipelineStageFlags2));
    vkStream->write((uint32_t*)&forMarshaling->deviceIndex, sizeof(uint32_t));
}

void unmarshal_VkSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreSubmitInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkSemaphore(&cgen_var_0, (VkSemaphore*)&forUnmarshaling->semaphore, 1);
    vkStream->read((uint64_t*)&forUnmarshaling->value, sizeof(uint64_t));
    vkStream->read((VkPipelineStageFlags2*)&forUnmarshaling->stageMask, sizeof(VkPipelineStageFlags2));
    vkStream->read((uint32_t*)&forUnmarshaling->deviceIndex, sizeof(uint32_t));
}

void marshal_VkCommandBufferSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferSubmitInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkCommandBuffer_u64(&forMarshaling->commandBuffer, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->deviceMask, sizeof(uint32_t));
}

void unmarshal_VkCommandBufferSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandBufferSubmitInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkCommandBuffer(&cgen_var_0, (VkCommandBuffer*)&forUnmarshaling->commandBuffer, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->deviceMask, sizeof(uint32_t));
}

void marshal_VkSubmitInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubmitInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkSubmitFlags*)&forMarshaling->flags, sizeof(VkSubmitFlags));
    vkStream->write((uint32_t*)&forMarshaling->waitSemaphoreInfoCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->waitSemaphoreInfoCount; ++i)
        {
            marshal_VkSemaphoreSubmitInfo(vkStream, rootType, (const VkSemaphoreSubmitInfo*)(forMarshaling->pWaitSemaphoreInfos + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->commandBufferInfoCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->commandBufferInfoCount; ++i)
        {
            marshal_VkCommandBufferSubmitInfo(vkStream, rootType, (const VkCommandBufferSubmitInfo*)(forMarshaling->pCommandBufferInfos + i));
        }
    }
    vkStream->write((uint32_t*)&forMarshaling->signalSemaphoreInfoCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->signalSemaphoreInfoCount; ++i)
        {
            marshal_VkSemaphoreSubmitInfo(vkStream, rootType, (const VkSemaphoreSubmitInfo*)(forMarshaling->pSignalSemaphoreInfos + i));
        }
    }
}

void unmarshal_VkSubmitInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubmitInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkSubmitFlags*)&forUnmarshaling->flags, sizeof(VkSubmitFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->waitSemaphoreInfoCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->waitSemaphoreInfoCount; ++i)
        {
            unmarshal_VkSemaphoreSubmitInfo(vkStream, rootType, (VkSemaphoreSubmitInfo*)(forUnmarshaling->pWaitSemaphoreInfos + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->commandBufferInfoCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->commandBufferInfoCount; ++i)
        {
            unmarshal_VkCommandBufferSubmitInfo(vkStream, rootType, (VkCommandBufferSubmitInfo*)(forUnmarshaling->pCommandBufferInfos + i));
        }
    }
    vkStream->read((uint32_t*)&forUnmarshaling->signalSemaphoreInfoCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->signalSemaphoreInfoCount; ++i)
        {
            unmarshal_VkSemaphoreSubmitInfo(vkStream, rootType, (VkSemaphoreSubmitInfo*)(forUnmarshaling->pSignalSemaphoreInfos + i));
        }
    }
}

void marshal_VkPhysicalDeviceSynchronization2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSynchronization2Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->synchronization2, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceSynchronization2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSynchronization2Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->synchronization2, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderZeroInitializeWorkgroupMemory, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderZeroInitializeWorkgroupMemory, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceImageRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageRobustnessFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->robustImageAccess, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceImageRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImageRobustnessFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->robustImageAccess, sizeof(VkBool32));
}

void marshal_VkBufferCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCopy2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceSize*)&forMarshaling->srcOffset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->dstOffset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
}

void unmarshal_VkBufferCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferCopy2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->srcOffset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->dstOffset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
}

void marshal_VkCopyBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyBufferInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->srcBuffer, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->dstBuffer, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
        {
            marshal_VkBufferCopy2(vkStream, rootType, (const VkBufferCopy2*)(forMarshaling->pRegions + i));
        }
    }
}

void unmarshal_VkCopyBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyBufferInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_0, (VkBuffer*)&forUnmarshaling->srcBuffer, 1);
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_1, (VkBuffer*)&forUnmarshaling->dstBuffer, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->regionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i)
        {
            unmarshal_VkBufferCopy2(vkStream, rootType, (VkBufferCopy2*)(forUnmarshaling->pRegions + i));
        }
    }
}

void marshal_VkImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCopy2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->srcOffset));
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->dstOffset));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent));
}

void unmarshal_VkImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageCopy2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->srcOffset));
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->dstOffset));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent));
}

void marshal_VkCopyImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->srcImage, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->dstImage, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->write((uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
        {
            marshal_VkImageCopy2(vkStream, rootType, (const VkImageCopy2*)(forMarshaling->pRegions + i));
        }
    }
}

void unmarshal_VkCopyImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyImageInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->srcImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->srcImageLayout, sizeof(VkImageLayout));
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_1, (VkImage*)&forUnmarshaling->dstImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->read((uint32_t*)&forUnmarshaling->regionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i)
        {
            unmarshal_VkImageCopy2(vkStream, rootType, (VkImageCopy2*)(forUnmarshaling->pRegions + i));
        }
    }
}

void marshal_VkBufferImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferImageCopy2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceSize*)&forMarshaling->bufferOffset, sizeof(VkDeviceSize));
    vkStream->write((uint32_t*)&forMarshaling->bufferRowLength, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->bufferImageHeight, sizeof(uint32_t));
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->imageSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->imageOffset));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->imageExtent));
}

void unmarshal_VkBufferImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferImageCopy2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->bufferOffset, sizeof(VkDeviceSize));
    vkStream->read((uint32_t*)&forUnmarshaling->bufferRowLength, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->bufferImageHeight, sizeof(uint32_t));
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->imageSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->imageOffset));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->imageExtent));
}

void marshal_VkCopyBufferToImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyBufferToImageInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->srcBuffer, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->dstImage, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->write((uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
        {
            marshal_VkBufferImageCopy2(vkStream, rootType, (const VkBufferImageCopy2*)(forMarshaling->pRegions + i));
        }
    }
}

void unmarshal_VkCopyBufferToImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyBufferToImageInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_0, (VkBuffer*)&forUnmarshaling->srcBuffer, 1);
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_1, (VkImage*)&forUnmarshaling->dstImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->read((uint32_t*)&forUnmarshaling->regionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i)
        {
            unmarshal_VkBufferImageCopy2(vkStream, rootType, (VkBufferImageCopy2*)(forUnmarshaling->pRegions + i));
        }
    }
}

void marshal_VkCopyImageToBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToBufferInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->srcImage, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkBuffer_u64(&forMarshaling->dstBuffer, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
        {
            marshal_VkBufferImageCopy2(vkStream, rootType, (const VkBufferImageCopy2*)(forMarshaling->pRegions + i));
        }
    }
}

void unmarshal_VkCopyImageToBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyImageToBufferInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->srcImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->srcImageLayout, sizeof(VkImageLayout));
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkBuffer(&cgen_var_1, (VkBuffer*)&forUnmarshaling->dstBuffer, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->regionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i)
        {
            unmarshal_VkBufferImageCopy2(vkStream, rootType, (VkBufferImageCopy2*)(forUnmarshaling->pRegions + i));
        }
    }
}

void marshal_VkImageBlit2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageBlit2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forMarshaling->srcOffsets + i));
    }
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forMarshaling->dstOffsets + i));
    }
}

void unmarshal_VkImageBlit2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageBlit2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forUnmarshaling->srcOffsets + i));
    }
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(forUnmarshaling->dstOffsets + i));
    }
}

void marshal_VkBlitImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBlitImageInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->srcImage, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->dstImage, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->write((uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
        {
            marshal_VkImageBlit2(vkStream, rootType, (const VkImageBlit2*)(forMarshaling->pRegions + i));
        }
    }
    vkStream->write((VkFilter*)&forMarshaling->filter, sizeof(VkFilter));
}

void unmarshal_VkBlitImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBlitImageInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->srcImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->srcImageLayout, sizeof(VkImageLayout));
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_1, (VkImage*)&forUnmarshaling->dstImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->read((uint32_t*)&forUnmarshaling->regionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i)
        {
            unmarshal_VkImageBlit2(vkStream, rootType, (VkImageBlit2*)(forUnmarshaling->pRegions + i));
        }
    }
    vkStream->read((VkFilter*)&forUnmarshaling->filter, sizeof(VkFilter));
}

void marshal_VkImageResolve2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageResolve2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->srcSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->srcOffset));
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->dstSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->dstOffset));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->extent));
}

void unmarshal_VkImageResolve2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageResolve2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->srcOffset));
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->dstOffset));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent));
}

void marshal_VkResolveImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkResolveImageInfo2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->srcImage, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->dstImage, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->write((uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
        {
            marshal_VkImageResolve2(vkStream, rootType, (const VkImageResolve2*)(forMarshaling->pRegions + i));
        }
    }
}

void unmarshal_VkResolveImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkResolveImageInfo2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->srcImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->srcImageLayout, sizeof(VkImageLayout));
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_1, (VkImage*)&forUnmarshaling->dstImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->read((uint32_t*)&forUnmarshaling->regionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i)
        {
            unmarshal_VkImageResolve2(vkStream, rootType, (VkImageResolve2*)(forUnmarshaling->pRegions + i));
        }
    }
}

void marshal_VkPhysicalDeviceSubgroupSizeControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->subgroupSizeControl, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->computeFullSubgroups, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceSubgroupSizeControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSubgroupSizeControlFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->subgroupSizeControl, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->computeFullSubgroups, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceSubgroupSizeControlProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->minSubgroupSize, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxSubgroupSize, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxComputeWorkgroupSubgroups, sizeof(uint32_t));
    vkStream->write((VkShaderStageFlags*)&forMarshaling->requiredSubgroupSizeStages, sizeof(VkShaderStageFlags));
}

void unmarshal_VkPhysicalDeviceSubgroupSizeControlProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSubgroupSizeControlProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->minSubgroupSize, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxSubgroupSize, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxComputeWorkgroupSubgroups, sizeof(uint32_t));
    vkStream->read((VkShaderStageFlags*)&forUnmarshaling->requiredSubgroupSizeStages, sizeof(VkShaderStageFlags));
}

void marshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->requiredSubgroupSize, sizeof(uint32_t));
}

void unmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->requiredSubgroupSize, sizeof(uint32_t));
}

void marshal_VkPhysicalDeviceInlineUniformBlockFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->inlineUniformBlock, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->descriptorBindingInlineUniformBlockUpdateAfterBind, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceInlineUniformBlockFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceInlineUniformBlockFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->inlineUniformBlock, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->descriptorBindingInlineUniformBlockUpdateAfterBind, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceInlineUniformBlockProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->maxInlineUniformBlockSize, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorInlineUniformBlocks, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetInlineUniformBlocks, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxDescriptorSetUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
}

void unmarshal_VkPhysicalDeviceInlineUniformBlockProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceInlineUniformBlockProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->maxInlineUniformBlockSize, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorInlineUniformBlocks, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetInlineUniformBlocks, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindInlineUniformBlocks, sizeof(uint32_t));
}

void marshal_VkWriteDescriptorSetInlineUniformBlock(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkWriteDescriptorSetInlineUniformBlock* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->dataSize, sizeof(uint32_t));
    vkStream->write((const void*)forMarshaling->pData, forMarshaling->dataSize * sizeof(const uint8_t));
}

void unmarshal_VkWriteDescriptorSetInlineUniformBlock(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkWriteDescriptorSetInlineUniformBlock* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->dataSize, sizeof(uint32_t));
    vkStream->read((void*)forUnmarshaling->pData, forUnmarshaling->dataSize * sizeof(const uint8_t));
}

void marshal_VkDescriptorPoolInlineUniformBlockCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolInlineUniformBlockCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->maxInlineUniformBlockBindings, sizeof(uint32_t));
}

void unmarshal_VkDescriptorPoolInlineUniformBlockCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorPoolInlineUniformBlockCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->maxInlineUniformBlockBindings, sizeof(uint32_t));
}

void marshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTextureCompressionASTCHDRFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->textureCompressionASTC_HDR, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->textureCompressionASTC_HDR, sizeof(VkBool32));
}

void marshal_VkRenderingAttachmentInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAttachmentInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImageView_u64(&forMarshaling->imageView, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->imageLayout, sizeof(VkImageLayout));
    vkStream->write((VkResolveModeFlagBits*)&forMarshaling->resolveMode, sizeof(VkResolveModeFlagBits));
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkImageView_u64(&forMarshaling->resolveImageView, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->resolveImageLayout, sizeof(VkImageLayout));
    vkStream->write((VkAttachmentLoadOp*)&forMarshaling->loadOp, sizeof(VkAttachmentLoadOp));
    vkStream->write((VkAttachmentStoreOp*)&forMarshaling->storeOp, sizeof(VkAttachmentStoreOp));
    marshal_VkClearValue(vkStream, rootType, (VkClearValue*)(&forMarshaling->clearValue));
}

void unmarshal_VkRenderingAttachmentInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingAttachmentInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImageView(&cgen_var_0, (VkImageView*)&forUnmarshaling->imageView, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->imageLayout, sizeof(VkImageLayout));
    vkStream->read((VkResolveModeFlagBits*)&forUnmarshaling->resolveMode, sizeof(VkResolveModeFlagBits));
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImageView(&cgen_var_1, (VkImageView*)&forUnmarshaling->resolveImageView, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->resolveImageLayout, sizeof(VkImageLayout));
    vkStream->read((VkAttachmentLoadOp*)&forUnmarshaling->loadOp, sizeof(VkAttachmentLoadOp));
    vkStream->read((VkAttachmentStoreOp*)&forUnmarshaling->storeOp, sizeof(VkAttachmentStoreOp));
    unmarshal_VkClearValue(vkStream, rootType, (VkClearValue*)(&forUnmarshaling->clearValue));
}

void marshal_VkRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkRenderingFlags*)&forMarshaling->flags, sizeof(VkRenderingFlags));
    marshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forMarshaling->renderArea));
    vkStream->write((uint32_t*)&forMarshaling->layerCount, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->viewMask, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->colorAttachmentCount; ++i)
        {
            marshal_VkRenderingAttachmentInfo(vkStream, rootType, (const VkRenderingAttachmentInfo*)(forMarshaling->pColorAttachments + i));
        }
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pDepthAttachment;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pDepthAttachment)
    {
        marshal_VkRenderingAttachmentInfo(vkStream, rootType, (const VkRenderingAttachmentInfo*)(forMarshaling->pDepthAttachment));
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pStencilAttachment;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pStencilAttachment)
    {
        marshal_VkRenderingAttachmentInfo(vkStream, rootType, (const VkRenderingAttachmentInfo*)(forMarshaling->pStencilAttachment));
    }
}

void unmarshal_VkRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkRenderingFlags*)&forUnmarshaling->flags, sizeof(VkRenderingFlags));
    unmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forUnmarshaling->renderArea));
    vkStream->read((uint32_t*)&forUnmarshaling->layerCount, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->viewMask, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->colorAttachmentCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->colorAttachmentCount; ++i)
        {
            unmarshal_VkRenderingAttachmentInfo(vkStream, rootType, (VkRenderingAttachmentInfo*)(forUnmarshaling->pColorAttachments + i));
        }
    }
    // WARNING PTR CHECK
    const VkRenderingAttachmentInfo* check_pDepthAttachment;
    (void)check_pDepthAttachment;
    check_pDepthAttachment = (const VkRenderingAttachmentInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pDepthAttachment)
    {
        if (!(check_pDepthAttachment))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pDepthAttachment inconsistent between guest and host\n");
        }
        unmarshal_VkRenderingAttachmentInfo(vkStream, rootType, (VkRenderingAttachmentInfo*)(forUnmarshaling->pDepthAttachment));
    }
    // WARNING PTR CHECK
    const VkRenderingAttachmentInfo* check_pStencilAttachment;
    (void)check_pStencilAttachment;
    check_pStencilAttachment = (const VkRenderingAttachmentInfo*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pStencilAttachment)
    {
        if (!(check_pStencilAttachment))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pStencilAttachment inconsistent between guest and host\n");
        }
        unmarshal_VkRenderingAttachmentInfo(vkStream, rootType, (VkRenderingAttachmentInfo*)(forUnmarshaling->pStencilAttachment));
    }
}

void marshal_VkPipelineRenderingCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRenderingCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->viewMask, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pColorAttachmentFormats;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pColorAttachmentFormats)
    {
        vkStream->write((const VkFormat*)forMarshaling->pColorAttachmentFormats, forMarshaling->colorAttachmentCount * sizeof(const VkFormat));
    }
    vkStream->write((VkFormat*)&forMarshaling->depthAttachmentFormat, sizeof(VkFormat));
    vkStream->write((VkFormat*)&forMarshaling->stencilAttachmentFormat, sizeof(VkFormat));
}

void unmarshal_VkPipelineRenderingCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRenderingCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->viewMask, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->colorAttachmentCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const VkFormat* check_pColorAttachmentFormats;
    (void)check_pColorAttachmentFormats;
    check_pColorAttachmentFormats = (const VkFormat*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pColorAttachmentFormats)
    {
        if (!(check_pColorAttachmentFormats))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pColorAttachmentFormats inconsistent between guest and host\n");
        }
        vkStream->read((VkFormat*)forUnmarshaling->pColorAttachmentFormats, forUnmarshaling->colorAttachmentCount * sizeof(const VkFormat));
    }
    vkStream->read((VkFormat*)&forUnmarshaling->depthAttachmentFormat, sizeof(VkFormat));
    vkStream->read((VkFormat*)&forUnmarshaling->stencilAttachmentFormat, sizeof(VkFormat));
}

void marshal_VkPhysicalDeviceDynamicRenderingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->dynamicRendering, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceDynamicRenderingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDynamicRenderingFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->dynamicRendering, sizeof(VkBool32));
}

void marshal_VkCommandBufferInheritanceRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferInheritanceRenderingInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkRenderingFlags*)&forMarshaling->flags, sizeof(VkRenderingFlags));
    vkStream->write((uint32_t*)&forMarshaling->viewMask, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    vkStream->write((const VkFormat*)forMarshaling->pColorAttachmentFormats, forMarshaling->colorAttachmentCount * sizeof(const VkFormat));
    vkStream->write((VkFormat*)&forMarshaling->depthAttachmentFormat, sizeof(VkFormat));
    vkStream->write((VkFormat*)&forMarshaling->stencilAttachmentFormat, sizeof(VkFormat));
    vkStream->write((VkSampleCountFlagBits*)&forMarshaling->rasterizationSamples, sizeof(VkSampleCountFlagBits));
}

void unmarshal_VkCommandBufferInheritanceRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandBufferInheritanceRenderingInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkRenderingFlags*)&forUnmarshaling->flags, sizeof(VkRenderingFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->viewMask, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->colorAttachmentCount, sizeof(uint32_t));
    vkStream->read((VkFormat*)forUnmarshaling->pColorAttachmentFormats, forUnmarshaling->colorAttachmentCount * sizeof(const VkFormat));
    vkStream->read((VkFormat*)&forUnmarshaling->depthAttachmentFormat, sizeof(VkFormat));
    vkStream->read((VkFormat*)&forUnmarshaling->stencilAttachmentFormat, sizeof(VkFormat));
    vkStream->read((VkSampleCountFlagBits*)&forUnmarshaling->rasterizationSamples, sizeof(VkSampleCountFlagBits));
}

void marshal_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderIntegerDotProduct, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderIntegerDotProductFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderIntegerDotProduct, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceShaderIntegerDotProductProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct8BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct8BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct8BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct16BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct16BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct16BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct32BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct32BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct32BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct64BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct64BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProduct64BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitSignedAccelerated, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceShaderIntegerDotProductProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderIntegerDotProductProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct8BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct8BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct8BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct16BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct16BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct16BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct32BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct32BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct32BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct64BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct64BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProduct64BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating8BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating16BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating32BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating64BitSignedAccelerated, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceTexelBufferAlignmentProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceSize*)&forMarshaling->storageTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    vkStream->write((VkBool32*)&forMarshaling->storageTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
    vkStream->write((VkDeviceSize*)&forMarshaling->uniformTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    vkStream->write((VkBool32*)&forMarshaling->uniformTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceTexelBufferAlignmentProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTexelBufferAlignmentProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->storageTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    vkStream->read((VkBool32*)&forUnmarshaling->storageTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->uniformTexelBufferOffsetAlignmentBytes, sizeof(VkDeviceSize));
    vkStream->read((VkBool32*)&forUnmarshaling->uniformTexelBufferOffsetSingleTexelAlignment, sizeof(VkBool32));
}

void marshal_VkFormatProperties3(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties3* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkFormatFeatureFlags2*)&forMarshaling->linearTilingFeatures, sizeof(VkFormatFeatureFlags2));
    vkStream->write((VkFormatFeatureFlags2*)&forMarshaling->optimalTilingFeatures, sizeof(VkFormatFeatureFlags2));
    vkStream->write((VkFormatFeatureFlags2*)&forMarshaling->bufferFeatures, sizeof(VkFormatFeatureFlags2));
}

void unmarshal_VkFormatProperties3(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFormatProperties3* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkFormatFeatureFlags2*)&forUnmarshaling->linearTilingFeatures, sizeof(VkFormatFeatureFlags2));
    vkStream->read((VkFormatFeatureFlags2*)&forUnmarshaling->optimalTilingFeatures, sizeof(VkFormatFeatureFlags2));
    vkStream->read((VkFormatFeatureFlags2*)&forUnmarshaling->bufferFeatures, sizeof(VkFormatFeatureFlags2));
}

void marshal_VkPhysicalDeviceMaintenance4Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->maintenance4, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceMaintenance4Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance4Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->maintenance4, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceMaintenance4Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Properties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceSize*)&forMarshaling->maxBufferSize, sizeof(VkDeviceSize));
}

void unmarshal_VkPhysicalDeviceMaintenance4Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance4Properties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->maxBufferSize, sizeof(VkDeviceSize));
}

void marshal_VkDeviceBufferMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceBufferMemoryRequirements* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkBufferCreateInfo(vkStream, rootType, (const VkBufferCreateInfo*)(forMarshaling->pCreateInfo));
}

void unmarshal_VkDeviceBufferMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceBufferMemoryRequirements* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkBufferCreateInfo(vkStream, rootType, (VkBufferCreateInfo*)(forUnmarshaling->pCreateInfo));
}

void marshal_VkDeviceImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceImageMemoryRequirements* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkImageCreateInfo(vkStream, rootType, (const VkImageCreateInfo*)(forMarshaling->pCreateInfo));
    vkStream->write((VkImageAspectFlagBits*)&forMarshaling->planeAspect, sizeof(VkImageAspectFlagBits));
}

void unmarshal_VkDeviceImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceImageMemoryRequirements* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkImageCreateInfo(vkStream, rootType, (VkImageCreateInfo*)(forUnmarshaling->pCreateInfo));
    vkStream->read((VkImageAspectFlagBits*)&forUnmarshaling->planeAspect, sizeof(VkImageAspectFlagBits));
}

#endif
#ifdef VK_VERSION_1_4
void marshal_VkPhysicalDeviceVulkan14Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->globalPriorityQuery, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSubgroupRotate, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSubgroupRotateClustered, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderFloatControls2, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderExpectAssume, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->rectangularLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->bresenhamLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->smoothLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->stippledRectangularLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->stippledBresenhamLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->stippledSmoothLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->vertexAttributeInstanceRateDivisor, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->vertexAttributeInstanceRateZeroDivisor, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->indexTypeUint8, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->dynamicRenderingLocalRead, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->maintenance5, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->maintenance6, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->pipelineProtectedAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->pipelineRobustness, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->hostImageCopy, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->pushDescriptor, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceVulkan14Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan14Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->globalPriorityQuery, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSubgroupRotate, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSubgroupRotateClustered, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderFloatControls2, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderExpectAssume, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->rectangularLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->bresenhamLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->smoothLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->stippledRectangularLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->stippledBresenhamLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->stippledSmoothLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->vertexAttributeInstanceRateDivisor, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->vertexAttributeInstanceRateZeroDivisor, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->indexTypeUint8, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->dynamicRenderingLocalRead, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->maintenance5, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->maintenance6, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->pipelineProtectedAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->pipelineRobustness, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->hostImageCopy, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->pushDescriptor, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceVulkan14Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Properties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->lineSubPixelPrecisionBits, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxVertexAttribDivisor, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->supportsNonZeroFirstInstance, sizeof(VkBool32));
    vkStream->write((uint32_t*)&forMarshaling->maxPushDescriptors, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->dynamicRenderingLocalReadDepthStencilAttachments, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->dynamicRenderingLocalReadMultisampledAttachments, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->earlyFragmentMultisampleCoverageAfterSampleCounting, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->earlyFragmentSampleMaskTestBeforeSampleCounting, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->depthStencilSwizzleOneSupport, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->polygonModePointSize, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->nonStrictSinglePixelWideLinesUseParallelogram, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->nonStrictWideLinesUseParallelogram, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->blockTexelViewCompatibleMultipleLayers, sizeof(VkBool32));
    vkStream->write((uint32_t*)&forMarshaling->maxCombinedImageSamplerDescriptorCount, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->fragmentShadingRateClampCombinerInputs, sizeof(VkBool32));
    vkStream->write((VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessStorageBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->write((VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessUniformBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->write((VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessVertexInputs, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->write((VkPipelineRobustnessImageBehavior*)&forMarshaling->defaultRobustnessImages, sizeof(VkPipelineRobustnessImageBehavior));
    vkStream->write((uint32_t*)&forMarshaling->copySrcLayoutCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pCopySrcLayouts;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pCopySrcLayouts)
    {
        vkStream->write((VkImageLayout*)forMarshaling->pCopySrcLayouts, forMarshaling->copySrcLayoutCount * sizeof(VkImageLayout));
    }
    vkStream->write((uint32_t*)&forMarshaling->copyDstLayoutCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pCopyDstLayouts;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pCopyDstLayouts)
    {
        vkStream->write((VkImageLayout*)forMarshaling->pCopyDstLayouts, forMarshaling->copyDstLayoutCount * sizeof(VkImageLayout));
    }
    vkStream->write((uint8_t*)forMarshaling->optimalTilingLayoutUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->write((VkBool32*)&forMarshaling->identicalMemoryTypeRequirements, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceVulkan14Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan14Properties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->lineSubPixelPrecisionBits, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxVertexAttribDivisor, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->supportsNonZeroFirstInstance, sizeof(VkBool32));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPushDescriptors, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->dynamicRenderingLocalReadDepthStencilAttachments, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->dynamicRenderingLocalReadMultisampledAttachments, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->earlyFragmentMultisampleCoverageAfterSampleCounting, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->earlyFragmentSampleMaskTestBeforeSampleCounting, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->depthStencilSwizzleOneSupport, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->polygonModePointSize, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->nonStrictSinglePixelWideLinesUseParallelogram, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->nonStrictWideLinesUseParallelogram, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->blockTexelViewCompatibleMultipleLayers, sizeof(VkBool32));
    vkStream->read((uint32_t*)&forUnmarshaling->maxCombinedImageSamplerDescriptorCount, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->fragmentShadingRateClampCombinerInputs, sizeof(VkBool32));
    vkStream->read((VkPipelineRobustnessBufferBehavior*)&forUnmarshaling->defaultRobustnessStorageBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->read((VkPipelineRobustnessBufferBehavior*)&forUnmarshaling->defaultRobustnessUniformBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->read((VkPipelineRobustnessBufferBehavior*)&forUnmarshaling->defaultRobustnessVertexInputs, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->read((VkPipelineRobustnessImageBehavior*)&forUnmarshaling->defaultRobustnessImages, sizeof(VkPipelineRobustnessImageBehavior));
    vkStream->read((uint32_t*)&forUnmarshaling->copySrcLayoutCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    VkImageLayout* check_pCopySrcLayouts;
    (void)check_pCopySrcLayouts;
    check_pCopySrcLayouts = (VkImageLayout*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pCopySrcLayouts)
    {
        if (!(check_pCopySrcLayouts))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pCopySrcLayouts inconsistent between guest and host\n");
        }
        vkStream->read((VkImageLayout*)forUnmarshaling->pCopySrcLayouts, forUnmarshaling->copySrcLayoutCount * sizeof(VkImageLayout));
    }
    vkStream->read((uint32_t*)&forUnmarshaling->copyDstLayoutCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    VkImageLayout* check_pCopyDstLayouts;
    (void)check_pCopyDstLayouts;
    check_pCopyDstLayouts = (VkImageLayout*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pCopyDstLayouts)
    {
        if (!(check_pCopyDstLayouts))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pCopyDstLayouts inconsistent between guest and host\n");
        }
        vkStream->read((VkImageLayout*)forUnmarshaling->pCopyDstLayouts, forUnmarshaling->copyDstLayoutCount * sizeof(VkImageLayout));
    }
    vkStream->read((uint8_t*)forUnmarshaling->optimalTilingLayoutUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->read((VkBool32*)&forUnmarshaling->identicalMemoryTypeRequirements, sizeof(VkBool32));
}

void marshal_VkDeviceQueueGlobalPriorityCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueGlobalPriorityCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkQueueGlobalPriority*)&forMarshaling->globalPriority, sizeof(VkQueueGlobalPriority));
}

void unmarshal_VkDeviceQueueGlobalPriorityCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceQueueGlobalPriorityCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkQueueGlobalPriority*)&forUnmarshaling->globalPriority, sizeof(VkQueueGlobalPriority));
}

void marshal_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGlobalPriorityQueryFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->globalPriorityQuery, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceGlobalPriorityQueryFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->globalPriorityQuery, sizeof(VkBool32));
}

void marshal_VkQueueFamilyGlobalPriorityProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyGlobalPriorityProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->priorityCount, sizeof(uint32_t));
    vkStream->write((VkQueueGlobalPriority*)forMarshaling->priorities, VK_MAX_GLOBAL_PRIORITY_SIZE * sizeof(VkQueueGlobalPriority));
}

void unmarshal_VkQueueFamilyGlobalPriorityProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkQueueFamilyGlobalPriorityProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->priorityCount, sizeof(uint32_t));
    vkStream->read((VkQueueGlobalPriority*)forUnmarshaling->priorities, VK_MAX_GLOBAL_PRIORITY_SIZE * sizeof(VkQueueGlobalPriority));
}

void marshal_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupRotateFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderSubgroupRotate, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->shaderSubgroupRotateClustered, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderSubgroupRotateFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSubgroupRotate, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderSubgroupRotateClustered, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceShaderFloatControls2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloatControls2Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderFloatControls2, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceShaderFloatControls2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderFloatControls2Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderFloatControls2, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceShaderExpectAssumeFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderExpectAssumeFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->shaderExpectAssume, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceShaderExpectAssumeFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderExpectAssumeFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->shaderExpectAssume, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceLineRasterizationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->rectangularLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->bresenhamLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->smoothLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->stippledRectangularLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->stippledBresenhamLines, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->stippledSmoothLines, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceLineRasterizationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceLineRasterizationFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->rectangularLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->bresenhamLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->smoothLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->stippledRectangularLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->stippledBresenhamLines, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->stippledSmoothLines, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceLineRasterizationProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->lineSubPixelPrecisionBits, sizeof(uint32_t));
}

void unmarshal_VkPhysicalDeviceLineRasterizationProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceLineRasterizationProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->lineSubPixelPrecisionBits, sizeof(uint32_t));
}

void marshal_VkPipelineRasterizationLineStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationLineStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkLineRasterizationMode*)&forMarshaling->lineRasterizationMode, sizeof(VkLineRasterizationMode));
    vkStream->write((VkBool32*)&forMarshaling->stippledLineEnable, sizeof(VkBool32));
    vkStream->write((uint32_t*)&forMarshaling->lineStippleFactor, sizeof(uint32_t));
    vkStream->write((uint16_t*)&forMarshaling->lineStipplePattern, sizeof(uint16_t));
}

void unmarshal_VkPipelineRasterizationLineStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRasterizationLineStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkLineRasterizationMode*)&forUnmarshaling->lineRasterizationMode, sizeof(VkLineRasterizationMode));
    vkStream->read((VkBool32*)&forUnmarshaling->stippledLineEnable, sizeof(VkBool32));
    vkStream->read((uint32_t*)&forUnmarshaling->lineStippleFactor, sizeof(uint32_t));
    vkStream->read((uint16_t*)&forUnmarshaling->lineStipplePattern, sizeof(uint16_t));
}

void marshal_VkPhysicalDeviceVertexAttributeDivisorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->maxVertexAttribDivisor, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->supportsNonZeroFirstInstance, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceVertexAttributeDivisorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVertexAttributeDivisorProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->maxVertexAttribDivisor, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->supportsNonZeroFirstInstance, sizeof(VkBool32));
}

void marshal_VkVertexInputBindingDivisorDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputBindingDivisorDescription* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->binding, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->divisor, sizeof(uint32_t));
}

void unmarshal_VkVertexInputBindingDivisorDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkVertexInputBindingDivisorDescription* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->binding, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->divisor, sizeof(uint32_t));
}

void marshal_VkPipelineVertexInputDivisorStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineVertexInputDivisorStateCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->vertexBindingDivisorCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->vertexBindingDivisorCount; ++i)
        {
            marshal_VkVertexInputBindingDivisorDescription(vkStream, rootType, (const VkVertexInputBindingDivisorDescription*)(forMarshaling->pVertexBindingDivisors + i));
        }
    }
}

void unmarshal_VkPipelineVertexInputDivisorStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineVertexInputDivisorStateCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->vertexBindingDivisorCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->vertexBindingDivisorCount; ++i)
        {
            unmarshal_VkVertexInputBindingDivisorDescription(vkStream, rootType, (VkVertexInputBindingDivisorDescription*)(forUnmarshaling->pVertexBindingDivisors + i));
        }
    }
}

void marshal_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->vertexAttributeInstanceRateDivisor, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->vertexAttributeInstanceRateZeroDivisor, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVertexAttributeDivisorFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->vertexAttributeInstanceRateDivisor, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->vertexAttributeInstanceRateZeroDivisor, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceIndexTypeUint8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceIndexTypeUint8Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->indexTypeUint8, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceIndexTypeUint8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceIndexTypeUint8Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->indexTypeUint8, sizeof(VkBool32));
}

void marshal_VkMemoryMapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryMapInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkMemoryMapFlags*)&forMarshaling->flags, sizeof(VkMemoryMapFlags));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkDeviceMemory_u64(&forMarshaling->memory, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkDeviceSize*)&forMarshaling->offset, sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
}

void unmarshal_VkMemoryMapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryMapInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkMemoryMapFlags*)&forUnmarshaling->flags, sizeof(VkMemoryMapFlags));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDeviceMemory(&cgen_var_0, (VkDeviceMemory*)&forUnmarshaling->memory, 1);
    vkStream->read((VkDeviceSize*)&forUnmarshaling->offset, sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
}

void marshal_VkMemoryUnmapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryUnmapInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkMemoryUnmapFlags*)&forMarshaling->flags, sizeof(VkMemoryUnmapFlags));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkDeviceMemory_u64(&forMarshaling->memory, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
}

void unmarshal_VkMemoryUnmapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryUnmapInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkMemoryUnmapFlags*)&forUnmarshaling->flags, sizeof(VkMemoryUnmapFlags));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDeviceMemory(&cgen_var_0, (VkDeviceMemory*)&forUnmarshaling->memory, 1);
}

void marshal_VkPhysicalDeviceMaintenance5Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->maintenance5, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceMaintenance5Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance5Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->maintenance5, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceMaintenance5Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Properties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->earlyFragmentMultisampleCoverageAfterSampleCounting, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->earlyFragmentSampleMaskTestBeforeSampleCounting, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->depthStencilSwizzleOneSupport, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->polygonModePointSize, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->nonStrictSinglePixelWideLinesUseParallelogram, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->nonStrictWideLinesUseParallelogram, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceMaintenance5Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance5Properties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->earlyFragmentMultisampleCoverageAfterSampleCounting, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->earlyFragmentSampleMaskTestBeforeSampleCounting, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->depthStencilSwizzleOneSupport, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->polygonModePointSize, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->nonStrictSinglePixelWideLinesUseParallelogram, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->nonStrictWideLinesUseParallelogram, sizeof(VkBool32));
}

void marshal_VkRenderingAreaInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAreaInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->viewMask, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pColorAttachmentFormats;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pColorAttachmentFormats)
    {
        vkStream->write((const VkFormat*)forMarshaling->pColorAttachmentFormats, forMarshaling->colorAttachmentCount * sizeof(const VkFormat));
    }
    vkStream->write((VkFormat*)&forMarshaling->depthAttachmentFormat, sizeof(VkFormat));
    vkStream->write((VkFormat*)&forMarshaling->stencilAttachmentFormat, sizeof(VkFormat));
}

void unmarshal_VkRenderingAreaInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingAreaInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->viewMask, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->colorAttachmentCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const VkFormat* check_pColorAttachmentFormats;
    (void)check_pColorAttachmentFormats;
    check_pColorAttachmentFormats = (const VkFormat*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pColorAttachmentFormats)
    {
        if (!(check_pColorAttachmentFormats))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pColorAttachmentFormats inconsistent between guest and host\n");
        }
        vkStream->read((VkFormat*)forUnmarshaling->pColorAttachmentFormats, forUnmarshaling->colorAttachmentCount * sizeof(const VkFormat));
    }
    vkStream->read((VkFormat*)&forUnmarshaling->depthAttachmentFormat, sizeof(VkFormat));
    vkStream->read((VkFormat*)&forUnmarshaling->stencilAttachmentFormat, sizeof(VkFormat));
}

void marshal_VkImageSubresource2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresource2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkImageSubresource(vkStream, rootType, (VkImageSubresource*)(&forMarshaling->imageSubresource));
}

void unmarshal_VkImageSubresource2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageSubresource2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkImageSubresource(vkStream, rootType, (VkImageSubresource*)(&forUnmarshaling->imageSubresource));
}

void marshal_VkDeviceImageSubresourceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceImageSubresourceInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkImageCreateInfo(vkStream, rootType, (const VkImageCreateInfo*)(forMarshaling->pCreateInfo));
    marshal_VkImageSubresource2(vkStream, rootType, (const VkImageSubresource2*)(forMarshaling->pSubresource));
}

void unmarshal_VkDeviceImageSubresourceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceImageSubresourceInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkImageCreateInfo(vkStream, rootType, (VkImageCreateInfo*)(forUnmarshaling->pCreateInfo));
    unmarshal_VkImageSubresource2(vkStream, rootType, (VkImageSubresource2*)(forUnmarshaling->pSubresource));
}

void marshal_VkSubresourceLayout2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceLayout2* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkSubresourceLayout(vkStream, rootType, (VkSubresourceLayout*)(&forMarshaling->subresourceLayout));
}

void unmarshal_VkSubresourceLayout2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubresourceLayout2* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkSubresourceLayout(vkStream, rootType, (VkSubresourceLayout*)(&forUnmarshaling->subresourceLayout));
}

void marshal_VkPipelineCreateFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreateFlags2CreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineCreateFlags2*)&forMarshaling->flags, sizeof(VkPipelineCreateFlags2));
}

void unmarshal_VkPipelineCreateFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineCreateFlags2CreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineCreateFlags2*)&forUnmarshaling->flags, sizeof(VkPipelineCreateFlags2));
}

void marshal_VkBufferUsageFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferUsageFlags2CreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBufferUsageFlags2*)&forMarshaling->usage, sizeof(VkBufferUsageFlags2));
}

void unmarshal_VkBufferUsageFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferUsageFlags2CreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBufferUsageFlags2*)&forUnmarshaling->usage, sizeof(VkBufferUsageFlags2));
}

void marshal_VkPhysicalDevicePushDescriptorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePushDescriptorProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->maxPushDescriptors, sizeof(uint32_t));
}

void unmarshal_VkPhysicalDevicePushDescriptorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePushDescriptorProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->maxPushDescriptors, sizeof(uint32_t));
}

void marshal_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingLocalReadFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->dynamicRenderingLocalRead, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDynamicRenderingLocalReadFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->dynamicRenderingLocalRead, sizeof(VkBool32));
}

void marshal_VkRenderingAttachmentLocationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAttachmentLocationInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pColorAttachmentLocations;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pColorAttachmentLocations)
    {
        vkStream->write((const uint32_t*)forMarshaling->pColorAttachmentLocations, forMarshaling->colorAttachmentCount * sizeof(const uint32_t));
    }
}

void unmarshal_VkRenderingAttachmentLocationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingAttachmentLocationInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->colorAttachmentCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const uint32_t* check_pColorAttachmentLocations;
    (void)check_pColorAttachmentLocations;
    check_pColorAttachmentLocations = (const uint32_t*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pColorAttachmentLocations)
    {
        if (!(check_pColorAttachmentLocations))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pColorAttachmentLocations inconsistent between guest and host\n");
        }
        vkStream->read((uint32_t*)forUnmarshaling->pColorAttachmentLocations, forUnmarshaling->colorAttachmentCount * sizeof(const uint32_t));
    }
}

void marshal_VkRenderingInputAttachmentIndexInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingInputAttachmentIndexInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->colorAttachmentCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pColorAttachmentInputIndices;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pColorAttachmentInputIndices)
    {
        vkStream->write((const uint32_t*)forMarshaling->pColorAttachmentInputIndices, forMarshaling->colorAttachmentCount * sizeof(const uint32_t));
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pDepthInputAttachmentIndex;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pDepthInputAttachmentIndex)
    {
        vkStream->write((const uint32_t*)forMarshaling->pDepthInputAttachmentIndex, sizeof(const uint32_t));
    }
    // WARNING PTR CHECK
    uint64_t cgen_var_2 = (uint64_t)(uintptr_t)forMarshaling->pStencilInputAttachmentIndex;
    vkStream->putBe64(cgen_var_2);
    if (forMarshaling->pStencilInputAttachmentIndex)
    {
        vkStream->write((const uint32_t*)forMarshaling->pStencilInputAttachmentIndex, sizeof(const uint32_t));
    }
}

void unmarshal_VkRenderingInputAttachmentIndexInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingInputAttachmentIndexInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->colorAttachmentCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const uint32_t* check_pColorAttachmentInputIndices;
    (void)check_pColorAttachmentInputIndices;
    check_pColorAttachmentInputIndices = (const uint32_t*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pColorAttachmentInputIndices)
    {
        if (!(check_pColorAttachmentInputIndices))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pColorAttachmentInputIndices inconsistent between guest and host\n");
        }
        vkStream->read((uint32_t*)forUnmarshaling->pColorAttachmentInputIndices, forUnmarshaling->colorAttachmentCount * sizeof(const uint32_t));
    }
    // WARNING PTR CHECK
    const uint32_t* check_pDepthInputAttachmentIndex;
    (void)check_pDepthInputAttachmentIndex;
    check_pDepthInputAttachmentIndex = (const uint32_t*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pDepthInputAttachmentIndex)
    {
        if (!(check_pDepthInputAttachmentIndex))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pDepthInputAttachmentIndex inconsistent between guest and host\n");
        }
        vkStream->read((uint32_t*)forUnmarshaling->pDepthInputAttachmentIndex, sizeof(const uint32_t));
    }
    // WARNING PTR CHECK
    const uint32_t* check_pStencilInputAttachmentIndex;
    (void)check_pStencilInputAttachmentIndex;
    check_pStencilInputAttachmentIndex = (const uint32_t*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pStencilInputAttachmentIndex)
    {
        if (!(check_pStencilInputAttachmentIndex))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pStencilInputAttachmentIndex inconsistent between guest and host\n");
        }
        vkStream->read((uint32_t*)forUnmarshaling->pStencilInputAttachmentIndex, sizeof(const uint32_t));
    }
}

void marshal_VkPhysicalDeviceMaintenance6Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Features* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->maintenance6, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceMaintenance6Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance6Features* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->maintenance6, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceMaintenance6Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Properties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->blockTexelViewCompatibleMultipleLayers, sizeof(VkBool32));
    vkStream->write((uint32_t*)&forMarshaling->maxCombinedImageSamplerDescriptorCount, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->fragmentShadingRateClampCombinerInputs, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceMaintenance6Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance6Properties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->blockTexelViewCompatibleMultipleLayers, sizeof(VkBool32));
    vkStream->read((uint32_t*)&forUnmarshaling->maxCombinedImageSamplerDescriptorCount, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->fragmentShadingRateClampCombinerInputs, sizeof(VkBool32));
}

void marshal_VkBindMemoryStatus(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindMemoryStatus* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkResult*)forMarshaling->pResult, sizeof(VkResult));
}

void unmarshal_VkBindMemoryStatus(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindMemoryStatus* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkResult*)forUnmarshaling->pResult, sizeof(VkResult));
}

void marshal_VkBindDescriptorSetsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindDescriptorSetsInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkShaderStageFlags*)&forMarshaling->stageFlags, sizeof(VkShaderStageFlags));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkPipelineLayout_u64(&forMarshaling->layout, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->firstSet, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->descriptorSetCount, sizeof(uint32_t));
    if (forMarshaling->descriptorSetCount)
    {
        uint64_t* cgen_var_1;
        vkStream->alloc((void**)&cgen_var_1, forMarshaling->descriptorSetCount * 8);
        vkStream->handleMapping()->mapHandles_VkDescriptorSet_u64(forMarshaling->pDescriptorSets, cgen_var_1, forMarshaling->descriptorSetCount);
        vkStream->write((uint64_t*)cgen_var_1, forMarshaling->descriptorSetCount * 8);
    }
    vkStream->write((uint32_t*)&forMarshaling->dynamicOffsetCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_2 = (uint64_t)(uintptr_t)forMarshaling->pDynamicOffsets;
    vkStream->putBe64(cgen_var_2);
    if (forMarshaling->pDynamicOffsets)
    {
        vkStream->write((const uint32_t*)forMarshaling->pDynamicOffsets, forMarshaling->dynamicOffsetCount * sizeof(const uint32_t));
    }
}

void unmarshal_VkBindDescriptorSetsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindDescriptorSetsInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkShaderStageFlags*)&forUnmarshaling->stageFlags, sizeof(VkShaderStageFlags));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkPipelineLayout(&cgen_var_0, (VkPipelineLayout*)&forUnmarshaling->layout, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->firstSet, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->descriptorSetCount, sizeof(uint32_t));
    if (forUnmarshaling->descriptorSetCount)
    {
        uint64_t* cgen_var_1;
        vkStream->alloc((void**)&cgen_var_1, forUnmarshaling->descriptorSetCount * 8);
        vkStream->read((uint64_t*)cgen_var_1, forUnmarshaling->descriptorSetCount * 8);
        vkStream->handleMapping()->mapHandles_u64_VkDescriptorSet(cgen_var_1, (VkDescriptorSet*)forUnmarshaling->pDescriptorSets, forUnmarshaling->descriptorSetCount);
    }
    vkStream->read((uint32_t*)&forUnmarshaling->dynamicOffsetCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const uint32_t* check_pDynamicOffsets;
    (void)check_pDynamicOffsets;
    check_pDynamicOffsets = (const uint32_t*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pDynamicOffsets)
    {
        if (!(check_pDynamicOffsets))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pDynamicOffsets inconsistent between guest and host\n");
        }
        vkStream->read((uint32_t*)forUnmarshaling->pDynamicOffsets, forUnmarshaling->dynamicOffsetCount * sizeof(const uint32_t));
    }
}

void marshal_VkPushConstantsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushConstantsInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkPipelineLayout_u64(&forMarshaling->layout, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkShaderStageFlags*)&forMarshaling->stageFlags, sizeof(VkShaderStageFlags));
    vkStream->write((uint32_t*)&forMarshaling->offset, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->size, sizeof(uint32_t));
    vkStream->write((const void*)forMarshaling->pValues, forMarshaling->size * sizeof(const uint8_t));
}

void unmarshal_VkPushConstantsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPushConstantsInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkPipelineLayout(&cgen_var_0, (VkPipelineLayout*)&forUnmarshaling->layout, 1);
    vkStream->read((VkShaderStageFlags*)&forUnmarshaling->stageFlags, sizeof(VkShaderStageFlags));
    vkStream->read((uint32_t*)&forUnmarshaling->offset, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->size, sizeof(uint32_t));
    vkStream->read((void*)forUnmarshaling->pValues, forUnmarshaling->size * sizeof(const uint8_t));
}

void marshal_VkPushDescriptorSetInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushDescriptorSetInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkShaderStageFlags*)&forMarshaling->stageFlags, sizeof(VkShaderStageFlags));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkPipelineLayout_u64(&forMarshaling->layout, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->set, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->descriptorWriteCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->descriptorWriteCount; ++i)
        {
            marshal_VkWriteDescriptorSet(vkStream, rootType, (const VkWriteDescriptorSet*)(forMarshaling->pDescriptorWrites + i));
        }
    }
}

void unmarshal_VkPushDescriptorSetInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPushDescriptorSetInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkShaderStageFlags*)&forUnmarshaling->stageFlags, sizeof(VkShaderStageFlags));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkPipelineLayout(&cgen_var_0, (VkPipelineLayout*)&forUnmarshaling->layout, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->set, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->descriptorWriteCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->descriptorWriteCount; ++i)
        {
            unmarshal_VkWriteDescriptorSet(vkStream, rootType, (VkWriteDescriptorSet*)(forUnmarshaling->pDescriptorWrites + i));
        }
    }
}

void marshal_VkPushDescriptorSetWithTemplateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushDescriptorSetWithTemplateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkDescriptorUpdateTemplate_u64(&forMarshaling->descriptorUpdateTemplate, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkPipelineLayout_u64(&forMarshaling->layout, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->set, sizeof(uint32_t));
    vkStream->write((const void*)forMarshaling->pData, sizeof(const uint8_t));
}

void unmarshal_VkPushDescriptorSetWithTemplateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPushDescriptorSetWithTemplateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkDescriptorUpdateTemplate(&cgen_var_0, (VkDescriptorUpdateTemplate*)&forUnmarshaling->descriptorUpdateTemplate, 1);
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkPipelineLayout(&cgen_var_1, (VkPipelineLayout*)&forUnmarshaling->layout, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->set, sizeof(uint32_t));
    vkStream->read((void*)forUnmarshaling->pData, sizeof(const uint8_t));
}

void marshal_VkPhysicalDevicePipelineProtectedAccessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineProtectedAccessFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->pipelineProtectedAccess, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDevicePipelineProtectedAccessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePipelineProtectedAccessFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->pipelineProtectedAccess, sizeof(VkBool32));
}

void marshal_VkPhysicalDevicePipelineRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->pipelineRobustness, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDevicePipelineRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePipelineRobustnessFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->pipelineRobustness, sizeof(VkBool32));
}

void marshal_VkPhysicalDevicePipelineRobustnessProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessStorageBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->write((VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessUniformBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->write((VkPipelineRobustnessBufferBehavior*)&forMarshaling->defaultRobustnessVertexInputs, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->write((VkPipelineRobustnessImageBehavior*)&forMarshaling->defaultRobustnessImages, sizeof(VkPipelineRobustnessImageBehavior));
}

void unmarshal_VkPhysicalDevicePipelineRobustnessProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePipelineRobustnessProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineRobustnessBufferBehavior*)&forUnmarshaling->defaultRobustnessStorageBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->read((VkPipelineRobustnessBufferBehavior*)&forUnmarshaling->defaultRobustnessUniformBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->read((VkPipelineRobustnessBufferBehavior*)&forUnmarshaling->defaultRobustnessVertexInputs, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->read((VkPipelineRobustnessImageBehavior*)&forUnmarshaling->defaultRobustnessImages, sizeof(VkPipelineRobustnessImageBehavior));
}

void marshal_VkPipelineRobustnessCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRobustnessCreateInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineRobustnessBufferBehavior*)&forMarshaling->storageBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->write((VkPipelineRobustnessBufferBehavior*)&forMarshaling->uniformBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->write((VkPipelineRobustnessBufferBehavior*)&forMarshaling->vertexInputs, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->write((VkPipelineRobustnessImageBehavior*)&forMarshaling->images, sizeof(VkPipelineRobustnessImageBehavior));
}

void unmarshal_VkPipelineRobustnessCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRobustnessCreateInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineRobustnessBufferBehavior*)&forUnmarshaling->storageBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->read((VkPipelineRobustnessBufferBehavior*)&forUnmarshaling->uniformBuffers, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->read((VkPipelineRobustnessBufferBehavior*)&forUnmarshaling->vertexInputs, sizeof(VkPipelineRobustnessBufferBehavior));
    vkStream->read((VkPipelineRobustnessImageBehavior*)&forUnmarshaling->images, sizeof(VkPipelineRobustnessImageBehavior));
}

void marshal_VkPhysicalDeviceHostImageCopyFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyFeatures* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->hostImageCopy, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceHostImageCopyFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceHostImageCopyFeatures* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->hostImageCopy, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceHostImageCopyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyProperties* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->copySrcLayoutCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pCopySrcLayouts;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pCopySrcLayouts)
    {
        vkStream->write((VkImageLayout*)forMarshaling->pCopySrcLayouts, forMarshaling->copySrcLayoutCount * sizeof(VkImageLayout));
    }
    vkStream->write((uint32_t*)&forMarshaling->copyDstLayoutCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pCopyDstLayouts;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pCopyDstLayouts)
    {
        vkStream->write((VkImageLayout*)forMarshaling->pCopyDstLayouts, forMarshaling->copyDstLayoutCount * sizeof(VkImageLayout));
    }
    vkStream->write((uint8_t*)forMarshaling->optimalTilingLayoutUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->write((VkBool32*)&forMarshaling->identicalMemoryTypeRequirements, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceHostImageCopyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceHostImageCopyProperties* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->copySrcLayoutCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    VkImageLayout* check_pCopySrcLayouts;
    (void)check_pCopySrcLayouts;
    check_pCopySrcLayouts = (VkImageLayout*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pCopySrcLayouts)
    {
        if (!(check_pCopySrcLayouts))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pCopySrcLayouts inconsistent between guest and host\n");
        }
        vkStream->read((VkImageLayout*)forUnmarshaling->pCopySrcLayouts, forUnmarshaling->copySrcLayoutCount * sizeof(VkImageLayout));
    }
    vkStream->read((uint32_t*)&forUnmarshaling->copyDstLayoutCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    VkImageLayout* check_pCopyDstLayouts;
    (void)check_pCopyDstLayouts;
    check_pCopyDstLayouts = (VkImageLayout*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pCopyDstLayouts)
    {
        if (!(check_pCopyDstLayouts))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pCopyDstLayouts inconsistent between guest and host\n");
        }
        vkStream->read((VkImageLayout*)forUnmarshaling->pCopyDstLayouts, forUnmarshaling->copyDstLayoutCount * sizeof(VkImageLayout));
    }
    vkStream->read((uint8_t*)forUnmarshaling->optimalTilingLayoutUUID, VK_UUID_SIZE * sizeof(uint8_t));
    vkStream->read((VkBool32*)&forUnmarshaling->identicalMemoryTypeRequirements, sizeof(VkBool32));
}

void marshal_VkMemoryToImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryToImageCopy* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((const void*)forMarshaling->pHostPointer, sizeof(const uint8_t));
    vkStream->write((uint32_t*)&forMarshaling->memoryRowLength, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->memoryImageHeight, sizeof(uint32_t));
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->imageSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->imageOffset));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->imageExtent));
}

void unmarshal_VkMemoryToImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryToImageCopy* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((void*)forUnmarshaling->pHostPointer, sizeof(const uint8_t));
    vkStream->read((uint32_t*)&forUnmarshaling->memoryRowLength, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->memoryImageHeight, sizeof(uint32_t));
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->imageSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->imageOffset));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->imageExtent));
}

void marshal_VkImageToMemoryCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageToMemoryCopy* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((void*)forMarshaling->pHostPointer, sizeof(uint8_t));
    vkStream->write((uint32_t*)&forMarshaling->memoryRowLength, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->memoryImageHeight, sizeof(uint32_t));
    marshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forMarshaling->imageSubresource));
    marshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forMarshaling->imageOffset));
    marshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forMarshaling->imageExtent));
}

void unmarshal_VkImageToMemoryCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageToMemoryCopy* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((void*)forUnmarshaling->pHostPointer, sizeof(uint8_t));
    vkStream->read((uint32_t*)&forUnmarshaling->memoryRowLength, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->memoryImageHeight, sizeof(uint32_t));
    unmarshal_VkImageSubresourceLayers(vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->imageSubresource));
    unmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->imageOffset));
    unmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->imageExtent));
}

void marshal_VkCopyMemoryToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyMemoryToImageInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkHostImageCopyFlags*)&forMarshaling->flags, sizeof(VkHostImageCopyFlags));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->dstImage, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->write((uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
        {
            marshal_VkMemoryToImageCopy(vkStream, rootType, (const VkMemoryToImageCopy*)(forMarshaling->pRegions + i));
        }
    }
}

void unmarshal_VkCopyMemoryToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyMemoryToImageInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkHostImageCopyFlags*)&forUnmarshaling->flags, sizeof(VkHostImageCopyFlags));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->dstImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->read((uint32_t*)&forUnmarshaling->regionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i)
        {
            unmarshal_VkMemoryToImageCopy(vkStream, rootType, (VkMemoryToImageCopy*)(forUnmarshaling->pRegions + i));
        }
    }
}

void marshal_VkCopyImageToMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToMemoryInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkHostImageCopyFlags*)&forMarshaling->flags, sizeof(VkHostImageCopyFlags));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->srcImage, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    vkStream->write((uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
        {
            marshal_VkImageToMemoryCopy(vkStream, rootType, (const VkImageToMemoryCopy*)(forMarshaling->pRegions + i));
        }
    }
}

void unmarshal_VkCopyImageToMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyImageToMemoryInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkHostImageCopyFlags*)&forUnmarshaling->flags, sizeof(VkHostImageCopyFlags));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->srcImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->srcImageLayout, sizeof(VkImageLayout));
    vkStream->read((uint32_t*)&forUnmarshaling->regionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i)
        {
            unmarshal_VkImageToMemoryCopy(vkStream, rootType, (VkImageToMemoryCopy*)(forUnmarshaling->pRegions + i));
        }
    }
}

void marshal_VkCopyImageToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToImageInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkHostImageCopyFlags*)&forMarshaling->flags, sizeof(VkHostImageCopyFlags));
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->srcImage, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->srcImageLayout, sizeof(VkImageLayout));
    uint64_t cgen_var_1;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->dstImage, &cgen_var_1, 1);
    vkStream->write((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->write((uint32_t*)&forMarshaling->regionCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->regionCount; ++i)
        {
            marshal_VkImageCopy2(vkStream, rootType, (const VkImageCopy2*)(forMarshaling->pRegions + i));
        }
    }
}

void unmarshal_VkCopyImageToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyImageToImageInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkHostImageCopyFlags*)&forUnmarshaling->flags, sizeof(VkHostImageCopyFlags));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->srcImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->srcImageLayout, sizeof(VkImageLayout));
    uint64_t cgen_var_1;
    vkStream->read((uint64_t*)&cgen_var_1, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_1, (VkImage*)&forUnmarshaling->dstImage, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->dstImageLayout, sizeof(VkImageLayout));
    vkStream->read((uint32_t*)&forUnmarshaling->regionCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i)
        {
            unmarshal_VkImageCopy2(vkStream, rootType, (VkImageCopy2*)(forUnmarshaling->pRegions + i));
        }
    }
}

void marshal_VkHostImageLayoutTransitionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkHostImageLayoutTransitionInfo* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImage_u64(&forMarshaling->image, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->oldLayout, sizeof(VkImageLayout));
    vkStream->write((VkImageLayout*)&forMarshaling->newLayout, sizeof(VkImageLayout));
    marshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forMarshaling->subresourceRange));
}

void unmarshal_VkHostImageLayoutTransitionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkHostImageLayoutTransitionInfo* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImage(&cgen_var_0, (VkImage*)&forUnmarshaling->image, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->oldLayout, sizeof(VkImageLayout));
    vkStream->read((VkImageLayout*)&forUnmarshaling->newLayout, sizeof(VkImageLayout));
    unmarshal_VkImageSubresourceRange(vkStream, rootType, (VkImageSubresourceRange*)(&forUnmarshaling->subresourceRange));
}

void marshal_VkSubresourceHostMemcpySize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceHostMemcpySize* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
}

void unmarshal_VkSubresourceHostMemcpySize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubresourceHostMemcpySize* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
}

void marshal_VkHostImageCopyDevicePerformanceQuery(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkHostImageCopyDevicePerformanceQuery* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->optimalDeviceAccess, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->identicalMemoryLayout, sizeof(VkBool32));
}

void unmarshal_VkHostImageCopyDevicePerformanceQuery(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkHostImageCopyDevicePerformanceQuery* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->optimalDeviceAccess, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->identicalMemoryLayout, sizeof(VkBool32));
}

#endif
#ifdef VK_KHR_external_semaphore_fd
void marshal_VkImportSemaphoreFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportSemaphoreFdInfoKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkSemaphore_u64(&forMarshaling->semaphore, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkSemaphoreImportFlags*)&forMarshaling->flags, sizeof(VkSemaphoreImportFlags));
    vkStream->write((VkExternalSemaphoreHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalSemaphoreHandleTypeFlagBits));
    vkStream->write((int*)&forMarshaling->fd, sizeof(int));
}

void unmarshal_VkImportSemaphoreFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImportSemaphoreFdInfoKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkSemaphore(&cgen_var_0, (VkSemaphore*)&forUnmarshaling->semaphore, 1);
    vkStream->read((VkSemaphoreImportFlags*)&forUnmarshaling->flags, sizeof(VkSemaphoreImportFlags));
    vkStream->read((VkExternalSemaphoreHandleTypeFlagBits*)&forUnmarshaling->handleType, sizeof(VkExternalSemaphoreHandleTypeFlagBits));
    vkStream->read((int*)&forUnmarshaling->fd, sizeof(int));
}

void marshal_VkSemaphoreGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreGetFdInfoKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkSemaphore_u64(&forMarshaling->semaphore, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkExternalSemaphoreHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalSemaphoreHandleTypeFlagBits));
}

void unmarshal_VkSemaphoreGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreGetFdInfoKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkSemaphore(&cgen_var_0, (VkSemaphore*)&forUnmarshaling->semaphore, 1);
    vkStream->read((VkExternalSemaphoreHandleTypeFlagBits*)&forUnmarshaling->handleType, sizeof(VkExternalSemaphoreHandleTypeFlagBits));
}

#endif
#ifdef VK_KHR_incremental_present
void marshal_VkRectLayerKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRectLayerKHR* forMarshaling)
{
    (void)rootType;
    marshal_VkOffset2D(vkStream, rootType, (VkOffset2D*)(&forMarshaling->offset));
    marshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forMarshaling->extent));
    vkStream->write((uint32_t*)&forMarshaling->layer, sizeof(uint32_t));
}

void unmarshal_VkRectLayerKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRectLayerKHR* forUnmarshaling)
{
    (void)rootType;
    unmarshal_VkOffset2D(vkStream, rootType, (VkOffset2D*)(&forUnmarshaling->offset));
    unmarshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forUnmarshaling->extent));
    vkStream->read((uint32_t*)&forUnmarshaling->layer, sizeof(uint32_t));
}

void marshal_VkPresentRegionKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPresentRegionKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint32_t*)&forMarshaling->rectangleCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pRectangles;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pRectangles)
    {
        if (forMarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forMarshaling->rectangleCount; ++i)
            {
                marshal_VkRectLayerKHR(vkStream, rootType, (const VkRectLayerKHR*)(forMarshaling->pRectangles + i));
            }
        }
    }
}

void unmarshal_VkPresentRegionKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPresentRegionKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint32_t*)&forUnmarshaling->rectangleCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const VkRectLayerKHR* check_pRectangles;
    (void)check_pRectangles;
    check_pRectangles = (const VkRectLayerKHR*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pRectangles)
    {
        if (!(check_pRectangles))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pRectangles inconsistent between guest and host\n");
        }
        if (forUnmarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->rectangleCount; ++i)
            {
                unmarshal_VkRectLayerKHR(vkStream, rootType, (VkRectLayerKHR*)(forUnmarshaling->pRectangles + i));
            }
        }
    }
}

void marshal_VkPresentRegionsKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPresentRegionsKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->swapchainCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pRegions;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pRegions)
    {
        if (forMarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forMarshaling->swapchainCount; ++i)
            {
                marshal_VkPresentRegionKHR(vkStream, rootType, (const VkPresentRegionKHR*)(forMarshaling->pRegions + i));
            }
        }
    }
}

void unmarshal_VkPresentRegionsKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPresentRegionsKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->swapchainCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const VkPresentRegionKHR* check_pRegions;
    (void)check_pRegions;
    check_pRegions = (const VkPresentRegionKHR*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pRegions)
    {
        if (!(check_pRegions))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pRegions inconsistent between guest and host\n");
        }
        if (forUnmarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->swapchainCount; ++i)
            {
                unmarshal_VkPresentRegionKHR(vkStream, rootType, (VkPresentRegionKHR*)(forUnmarshaling->pRegions + i));
            }
        }
    }
}

#endif
#ifdef VK_KHR_external_fence_fd
void marshal_VkImportFenceFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportFenceFdInfoKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkFence_u64(&forMarshaling->fence, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkFenceImportFlags*)&forMarshaling->flags, sizeof(VkFenceImportFlags));
    vkStream->write((VkExternalFenceHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalFenceHandleTypeFlagBits));
    vkStream->write((int*)&forMarshaling->fd, sizeof(int));
}

void unmarshal_VkImportFenceFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImportFenceFdInfoKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkFence(&cgen_var_0, (VkFence*)&forUnmarshaling->fence, 1);
    vkStream->read((VkFenceImportFlags*)&forUnmarshaling->flags, sizeof(VkFenceImportFlags));
    vkStream->read((VkExternalFenceHandleTypeFlagBits*)&forUnmarshaling->handleType, sizeof(VkExternalFenceHandleTypeFlagBits));
    vkStream->read((int*)&forUnmarshaling->fd, sizeof(int));
}

void marshal_VkFenceGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFenceGetFdInfoKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkFence_u64(&forMarshaling->fence, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkExternalFenceHandleTypeFlagBits*)&forMarshaling->handleType, sizeof(VkExternalFenceHandleTypeFlagBits));
}

void unmarshal_VkFenceGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFenceGetFdInfoKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkFence(&cgen_var_0, (VkFence*)&forUnmarshaling->fence, 1);
    vkStream->read((VkExternalFenceHandleTypeFlagBits*)&forUnmarshaling->handleType, sizeof(VkExternalFenceHandleTypeFlagBits));
}

#endif
#ifdef VK_KHR_pipeline_executable_properties
void marshal_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->pipelineExecutableInfo, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->pipelineExecutableInfo, sizeof(VkBool32));
}

void marshal_VkPipelineInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineInfoKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkPipeline_u64(&forMarshaling->pipeline, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
}

void unmarshal_VkPipelineInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineInfoKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkPipeline(&cgen_var_0, (VkPipeline*)&forUnmarshaling->pipeline, 1);
}

void marshal_VkPipelineExecutablePropertiesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutablePropertiesKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkShaderStageFlags*)&forMarshaling->stages, sizeof(VkShaderStageFlags));
    vkStream->write((char*)forMarshaling->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->write((char*)forMarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->write((uint32_t*)&forMarshaling->subgroupSize, sizeof(uint32_t));
}

void unmarshal_VkPipelineExecutablePropertiesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineExecutablePropertiesKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkShaderStageFlags*)&forUnmarshaling->stages, sizeof(VkShaderStageFlags));
    vkStream->read((char*)forUnmarshaling->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->read((char*)forUnmarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->read((uint32_t*)&forUnmarshaling->subgroupSize, sizeof(uint32_t));
}

void marshal_VkPipelineExecutableInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableInfoKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkPipeline_u64(&forMarshaling->pipeline, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((uint32_t*)&forMarshaling->executableIndex, sizeof(uint32_t));
}

void unmarshal_VkPipelineExecutableInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineExecutableInfoKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkPipeline(&cgen_var_0, (VkPipeline*)&forUnmarshaling->pipeline, 1);
    vkStream->read((uint32_t*)&forUnmarshaling->executableIndex, sizeof(uint32_t));
}

void marshal_VkPipelineExecutableStatisticValueKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticValueKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkBool32*)&forMarshaling->b32, sizeof(VkBool32));
}

void unmarshal_VkPipelineExecutableStatisticValueKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineExecutableStatisticValueKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkBool32*)&forUnmarshaling->b32, sizeof(VkBool32));
}

void marshal_VkPipelineExecutableStatisticKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((char*)forMarshaling->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->write((char*)forMarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->write((VkPipelineExecutableStatisticFormatKHR*)&forMarshaling->format, sizeof(VkPipelineExecutableStatisticFormatKHR));
    marshal_VkPipelineExecutableStatisticValueKHR(vkStream, rootType, (VkPipelineExecutableStatisticValueKHR*)(&forMarshaling->value));
}

void unmarshal_VkPipelineExecutableStatisticKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineExecutableStatisticKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((char*)forUnmarshaling->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->read((char*)forUnmarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->read((VkPipelineExecutableStatisticFormatKHR*)&forUnmarshaling->format, sizeof(VkPipelineExecutableStatisticFormatKHR));
    unmarshal_VkPipelineExecutableStatisticValueKHR(vkStream, rootType, (VkPipelineExecutableStatisticValueKHR*)(&forUnmarshaling->value));
}

void marshal_VkPipelineExecutableInternalRepresentationKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableInternalRepresentationKHR* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((char*)forMarshaling->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->write((char*)forMarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->write((VkBool32*)&forMarshaling->isText, sizeof(VkBool32));
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->dataSize;
    vkStream->putBe64(cgen_var_0);
    // WARNING PTR CHECK
    uint64_t cgen_var_1 = (uint64_t)(uintptr_t)forMarshaling->pData;
    vkStream->putBe64(cgen_var_1);
    if (forMarshaling->pData)
    {
        vkStream->write((void*)forMarshaling->pData, forMarshaling->dataSize * sizeof(uint8_t));
    }
}

void unmarshal_VkPipelineExecutableInternalRepresentationKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineExecutableInternalRepresentationKHR* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((char*)forUnmarshaling->name, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->read((char*)forUnmarshaling->description, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    vkStream->read((VkBool32*)&forUnmarshaling->isText, sizeof(VkBool32));
    forUnmarshaling->dataSize = (size_t)vkStream->getBe64();
    // WARNING PTR CHECK
    void* check_pData;
    (void)check_pData;
    check_pData = (void*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pData)
    {
        if (!(check_pData))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pData inconsistent between guest and host\n");
        }
        vkStream->read((void*)forUnmarshaling->pData, forUnmarshaling->dataSize * sizeof(uint8_t));
    }
}

#endif
#ifdef VK_ANDROID_native_buffer
void marshal_VkNativeBufferUsage2ANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkNativeBufferUsage2ANDROID* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint64_t*)&forMarshaling->consumer, sizeof(uint64_t));
    vkStream->write((uint64_t*)&forMarshaling->producer, sizeof(uint64_t));
}

void unmarshal_VkNativeBufferUsage2ANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkNativeBufferUsage2ANDROID* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint64_t*)&forUnmarshaling->consumer, sizeof(uint64_t));
    vkStream->read((uint64_t*)&forUnmarshaling->producer, sizeof(uint64_t));
}

void marshal_VkNativeBufferANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkNativeBufferANDROID* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->handle;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->handle)
    {
        vkStream->write((const uint32_t*)forMarshaling->handle, sizeof(const uint32_t));
    }
    vkStream->write((int*)&forMarshaling->stride, sizeof(int));
    vkStream->write((int*)&forMarshaling->format, sizeof(int));
    vkStream->write((int*)&forMarshaling->usage, sizeof(int));
    marshal_VkNativeBufferUsage2ANDROID(vkStream, rootType, (VkNativeBufferUsage2ANDROID*)(&forMarshaling->usage2));
}

void unmarshal_VkNativeBufferANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkNativeBufferANDROID* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    // WARNING PTR CHECK
    const uint32_t* check_handle;
    (void)check_handle;
    check_handle = (const uint32_t*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->handle)
    {
        if (!(check_handle))
        {
            fprintf(stderr, "fatal: forUnmarshaling->handle inconsistent between guest and host\n");
        }
        vkStream->read((uint32_t*)forUnmarshaling->handle, sizeof(const uint32_t));
    }
    vkStream->read((int*)&forUnmarshaling->stride, sizeof(int));
    vkStream->read((int*)&forUnmarshaling->format, sizeof(int));
    vkStream->read((int*)&forUnmarshaling->usage, sizeof(int));
    unmarshal_VkNativeBufferUsage2ANDROID(vkStream, rootType, (VkNativeBufferUsage2ANDROID*)(&forUnmarshaling->usage2));
}

void marshal_VkSwapchainImageCreateInfoANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSwapchainImageCreateInfoANDROID* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkSwapchainImageUsageFlagsANDROID*)&forMarshaling->usage, sizeof(VkSwapchainImageUsageFlagsANDROID));
}

void unmarshal_VkSwapchainImageCreateInfoANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSwapchainImageCreateInfoANDROID* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkSwapchainImageUsageFlagsANDROID*)&forUnmarshaling->usage, sizeof(VkSwapchainImageUsageFlagsANDROID));
}

void marshal_VkPhysicalDevicePresentationPropertiesANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePresentationPropertiesANDROID* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->sharedImage, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDevicePresentationPropertiesANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePresentationPropertiesANDROID* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->sharedImage, sizeof(VkBool32));
}

#endif
#ifdef VK_EXT_transform_feedback
void marshal_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->transformFeedback, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->geometryStreams, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->transformFeedback, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->geometryStreams, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackPropertiesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->maxTransformFeedbackStreams, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTransformFeedbackBuffers, sizeof(uint32_t));
    vkStream->write((VkDeviceSize*)&forMarshaling->maxTransformFeedbackBufferSize, sizeof(VkDeviceSize));
    vkStream->write((uint32_t*)&forMarshaling->maxTransformFeedbackStreamDataSize, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTransformFeedbackBufferDataSize, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->maxTransformFeedbackBufferDataStride, sizeof(uint32_t));
    vkStream->write((VkBool32*)&forMarshaling->transformFeedbackQueries, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->transformFeedbackStreamsLinesTriangles, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->transformFeedbackRasterizationStreamSelect, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->transformFeedbackDraw, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTransformFeedbackStreams, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTransformFeedbackBuffers, sizeof(uint32_t));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->maxTransformFeedbackBufferSize, sizeof(VkDeviceSize));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTransformFeedbackStreamDataSize, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTransformFeedbackBufferDataSize, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->maxTransformFeedbackBufferDataStride, sizeof(uint32_t));
    vkStream->read((VkBool32*)&forUnmarshaling->transformFeedbackQueries, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->transformFeedbackStreamsLinesTriangles, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->transformFeedbackRasterizationStreamSelect, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->transformFeedbackDraw, sizeof(VkBool32));
}

void marshal_VkPipelineRasterizationStateStreamCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationStateStreamCreateInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineRasterizationStateStreamCreateFlagsEXT*)&forMarshaling->flags, sizeof(VkPipelineRasterizationStateStreamCreateFlagsEXT));
    vkStream->write((uint32_t*)&forMarshaling->rasterizationStream, sizeof(uint32_t));
}

void unmarshal_VkPipelineRasterizationStateStreamCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRasterizationStateStreamCreateInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineRasterizationStateStreamCreateFlagsEXT*)&forUnmarshaling->flags, sizeof(VkPipelineRasterizationStateStreamCreateFlagsEXT));
    vkStream->read((uint32_t*)&forUnmarshaling->rasterizationStream, sizeof(uint32_t));
}

#endif
#ifdef VK_EXT_depth_clip_enable
void marshal_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthClipEnableFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->depthClipEnable, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDepthClipEnableFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->depthClipEnable, sizeof(VkBool32));
}

void marshal_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationDepthClipStateCreateInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkPipelineRasterizationDepthClipStateCreateFlagsEXT*)&forMarshaling->flags, sizeof(VkPipelineRasterizationDepthClipStateCreateFlagsEXT));
    vkStream->write((VkBool32*)&forMarshaling->depthClipEnable, sizeof(VkBool32));
}

void unmarshal_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRasterizationDepthClipStateCreateInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkPipelineRasterizationDepthClipStateCreateFlagsEXT*)&forUnmarshaling->flags, sizeof(VkPipelineRasterizationDepthClipStateCreateFlagsEXT));
    vkStream->read((VkBool32*)&forUnmarshaling->depthClipEnable, sizeof(VkBool32));
}

#endif
#ifdef VK_EXT_image_drm_format_modifier
void marshal_VkDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint64_t*)&forMarshaling->drmFormatModifier, sizeof(uint64_t));
    vkStream->write((uint32_t*)&forMarshaling->drmFormatModifierPlaneCount, sizeof(uint32_t));
    vkStream->write((VkFormatFeatureFlags*)&forMarshaling->drmFormatModifierTilingFeatures, sizeof(VkFormatFeatureFlags));
}

void unmarshal_VkDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrmFormatModifierPropertiesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint64_t*)&forUnmarshaling->drmFormatModifier, sizeof(uint64_t));
    vkStream->read((uint32_t*)&forUnmarshaling->drmFormatModifierPlaneCount, sizeof(uint32_t));
    vkStream->read((VkFormatFeatureFlags*)&forUnmarshaling->drmFormatModifierTilingFeatures, sizeof(VkFormatFeatureFlags));
}

void marshal_VkDrmFormatModifierPropertiesListEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesListEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->drmFormatModifierCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pDrmFormatModifierProperties;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pDrmFormatModifierProperties)
    {
        if (forMarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forMarshaling->drmFormatModifierCount; ++i)
            {
                marshal_VkDrmFormatModifierPropertiesEXT(vkStream, rootType, (VkDrmFormatModifierPropertiesEXT*)(forMarshaling->pDrmFormatModifierProperties + i));
            }
        }
    }
}

void unmarshal_VkDrmFormatModifierPropertiesListEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrmFormatModifierPropertiesListEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->drmFormatModifierCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    VkDrmFormatModifierPropertiesEXT* check_pDrmFormatModifierProperties;
    (void)check_pDrmFormatModifierProperties;
    check_pDrmFormatModifierProperties = (VkDrmFormatModifierPropertiesEXT*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pDrmFormatModifierProperties)
    {
        if (!(check_pDrmFormatModifierProperties))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pDrmFormatModifierProperties inconsistent between guest and host\n");
        }
        if (forUnmarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->drmFormatModifierCount; ++i)
            {
                unmarshal_VkDrmFormatModifierPropertiesEXT(vkStream, rootType, (VkDrmFormatModifierPropertiesEXT*)(forUnmarshaling->pDrmFormatModifierProperties + i));
            }
        }
    }
}

void marshal_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageDrmFormatModifierInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint64_t*)&forMarshaling->drmFormatModifier, sizeof(uint64_t));
    vkStream->write((VkSharingMode*)&forMarshaling->sharingMode, sizeof(VkSharingMode));
    vkStream->write((uint32_t*)&forMarshaling->queueFamilyIndexCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pQueueFamilyIndices;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pQueueFamilyIndices)
    {
        vkStream->write((const uint32_t*)forMarshaling->pQueueFamilyIndices, forMarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
    }
}

void unmarshal_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImageDrmFormatModifierInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint64_t*)&forUnmarshaling->drmFormatModifier, sizeof(uint64_t));
    vkStream->read((VkSharingMode*)&forUnmarshaling->sharingMode, sizeof(VkSharingMode));
    vkStream->read((uint32_t*)&forUnmarshaling->queueFamilyIndexCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    const uint32_t* check_pQueueFamilyIndices;
    (void)check_pQueueFamilyIndices;
    check_pQueueFamilyIndices = (const uint32_t*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pQueueFamilyIndices)
    {
        if (!(check_pQueueFamilyIndices))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pQueueFamilyIndices inconsistent between guest and host\n");
        }
        vkStream->read((uint32_t*)forUnmarshaling->pQueueFamilyIndices, forUnmarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
    }
}

void marshal_VkImageDrmFormatModifierListCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierListCreateInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->drmFormatModifierCount, sizeof(uint32_t));
    vkStream->write((const uint64_t*)forMarshaling->pDrmFormatModifiers, forMarshaling->drmFormatModifierCount * sizeof(const uint64_t));
}

void unmarshal_VkImageDrmFormatModifierListCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageDrmFormatModifierListCreateInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->drmFormatModifierCount, sizeof(uint32_t));
    vkStream->read((uint64_t*)forUnmarshaling->pDrmFormatModifiers, forUnmarshaling->drmFormatModifierCount * sizeof(const uint64_t));
}

void marshal_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierExplicitCreateInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint64_t*)&forMarshaling->drmFormatModifier, sizeof(uint64_t));
    vkStream->write((uint32_t*)&forMarshaling->drmFormatModifierPlaneCount, sizeof(uint32_t));
    if (forMarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forMarshaling->drmFormatModifierPlaneCount; ++i)
        {
            marshal_VkSubresourceLayout(vkStream, rootType, (const VkSubresourceLayout*)(forMarshaling->pPlaneLayouts + i));
        }
    }
}

void unmarshal_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageDrmFormatModifierExplicitCreateInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint64_t*)&forUnmarshaling->drmFormatModifier, sizeof(uint64_t));
    vkStream->read((uint32_t*)&forUnmarshaling->drmFormatModifierPlaneCount, sizeof(uint32_t));
    if (forUnmarshaling)
    {
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->drmFormatModifierPlaneCount; ++i)
        {
            unmarshal_VkSubresourceLayout(vkStream, rootType, (VkSubresourceLayout*)(forUnmarshaling->pPlaneLayouts + i));
        }
    }
}

void marshal_VkImageDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierPropertiesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint64_t*)&forMarshaling->drmFormatModifier, sizeof(uint64_t));
}

void unmarshal_VkImageDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageDrmFormatModifierPropertiesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint64_t*)&forUnmarshaling->drmFormatModifier, sizeof(uint64_t));
}

void marshal_VkDrmFormatModifierProperties2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierProperties2EXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((uint64_t*)&forMarshaling->drmFormatModifier, sizeof(uint64_t));
    vkStream->write((uint32_t*)&forMarshaling->drmFormatModifierPlaneCount, sizeof(uint32_t));
    vkStream->write((VkFormatFeatureFlags2*)&forMarshaling->drmFormatModifierTilingFeatures, sizeof(VkFormatFeatureFlags2));
}

void unmarshal_VkDrmFormatModifierProperties2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrmFormatModifierProperties2EXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((uint64_t*)&forUnmarshaling->drmFormatModifier, sizeof(uint64_t));
    vkStream->read((uint32_t*)&forUnmarshaling->drmFormatModifierPlaneCount, sizeof(uint32_t));
    vkStream->read((VkFormatFeatureFlags2*)&forUnmarshaling->drmFormatModifierTilingFeatures, sizeof(VkFormatFeatureFlags2));
}

void marshal_VkDrmFormatModifierPropertiesList2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesList2EXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->drmFormatModifierCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pDrmFormatModifierProperties;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pDrmFormatModifierProperties)
    {
        if (forMarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forMarshaling->drmFormatModifierCount; ++i)
            {
                marshal_VkDrmFormatModifierProperties2EXT(vkStream, rootType, (VkDrmFormatModifierProperties2EXT*)(forMarshaling->pDrmFormatModifierProperties + i));
            }
        }
    }
}

void unmarshal_VkDrmFormatModifierPropertiesList2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrmFormatModifierPropertiesList2EXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->drmFormatModifierCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    VkDrmFormatModifierProperties2EXT* check_pDrmFormatModifierProperties;
    (void)check_pDrmFormatModifierProperties;
    check_pDrmFormatModifierProperties = (VkDrmFormatModifierProperties2EXT*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pDrmFormatModifierProperties)
    {
        if (!(check_pDrmFormatModifierProperties))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pDrmFormatModifierProperties inconsistent between guest and host\n");
        }
        if (forUnmarshaling)
        {
            for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->drmFormatModifierCount; ++i)
            {
                unmarshal_VkDrmFormatModifierProperties2EXT(vkStream, rootType, (VkDrmFormatModifierProperties2EXT*)(forUnmarshaling->pDrmFormatModifierProperties + i));
            }
        }
    }
}

#endif
#ifdef VK_EXT_vertex_attribute_divisor
void marshal_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->maxVertexAttribDivisor, sizeof(uint32_t));
}

void unmarshal_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->maxVertexAttribDivisor, sizeof(uint32_t));
}

#endif
#ifdef VK_EXT_fragment_density_map
void marshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->fragmentDensityMap, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->fragmentDensityMapDynamic, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->fragmentDensityMapNonSubsampledImages, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceFragmentDensityMapFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    forUnmarshaling->sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->fragmentDensityMap, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->fragmentDensityMapDynamic, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->fragmentDensityMapNonSubsampledImages, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapPropertiesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forMarshaling->minFragmentDensityTexelSize));
    marshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forMarshaling->maxFragmentDensityTexelSize));
    vkStream->write((VkBool32*)&forMarshaling->fragmentDensityInvocations, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceFragmentDensityMapPropertiesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    forUnmarshaling->sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forUnmarshaling->minFragmentDensityTexelSize));
    unmarshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forUnmarshaling->maxFragmentDensityTexelSize));
    vkStream->read((VkBool32*)&forUnmarshaling->fragmentDensityInvocations, sizeof(VkBool32));
}

void marshal_VkRenderPassFragmentDensityMapCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassFragmentDensityMapCreateInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkAttachmentReference(vkStream, rootType, (VkAttachmentReference*)(&forMarshaling->fragmentDensityMapAttachment));
}

void unmarshal_VkRenderPassFragmentDensityMapCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassFragmentDensityMapCreateInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    forUnmarshaling->sType = VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkAttachmentReference(vkStream, rootType, (VkAttachmentReference*)(&forUnmarshaling->fragmentDensityMapAttachment));
}

void marshal_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingFragmentDensityMapAttachmentInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    uint64_t cgen_var_0;
    vkStream->handleMapping()->mapHandles_VkImageView_u64(&forMarshaling->imageView, &cgen_var_0, 1);
    vkStream->write((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->write((VkImageLayout*)&forMarshaling->imageLayout, sizeof(VkImageLayout));
}

void unmarshal_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingFragmentDensityMapAttachmentInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    uint64_t cgen_var_0;
    vkStream->read((uint64_t*)&cgen_var_0, 1 * 8);
    vkStream->handleMapping()->mapHandles_u64_VkImageView(&cgen_var_0, (VkImageView*)&forUnmarshaling->imageView, 1);
    vkStream->read((VkImageLayout*)&forUnmarshaling->imageLayout, sizeof(VkImageLayout));
}

#endif
#ifdef VK_EXT_memory_budget
void marshal_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryBudgetPropertiesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceSize*)forMarshaling->heapBudget, VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize));
    vkStream->write((VkDeviceSize*)forMarshaling->heapUsage, VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize));
}

void unmarshal_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMemoryBudgetPropertiesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceSize*)forUnmarshaling->heapBudget, VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize));
    vkStream->read((VkDeviceSize*)forUnmarshaling->heapUsage, VK_MAX_MEMORY_HEAPS * sizeof(VkDeviceSize));
}

#endif
#ifdef VK_EXT_provoking_vertex
void marshal_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->provokingVertexLast, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->transformFeedbackPreservesProvokingVertex, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProvokingVertexFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->provokingVertexLast, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->transformFeedbackPreservesProvokingVertex, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexPropertiesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->provokingVertexModePerPipeline, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->transformFeedbackPreservesTriangleFanProvokingVertex, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProvokingVertexPropertiesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->provokingVertexModePerPipeline, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->transformFeedbackPreservesTriangleFanProvokingVertex, sizeof(VkBool32));
}

void marshal_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkProvokingVertexModeEXT*)&forMarshaling->provokingVertexMode, sizeof(VkProvokingVertexModeEXT));
}

void unmarshal_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkProvokingVertexModeEXT*)&forUnmarshaling->provokingVertexMode, sizeof(VkProvokingVertexModeEXT));
}

#endif
#ifdef VK_EXT_extended_dynamic_state
void marshal_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->extendedDynamicState, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->extendedDynamicState, sizeof(VkBool32));
}

#endif
#ifdef VK_EXT_texel_buffer_alignment
void marshal_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->texelBufferAlignment, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->texelBufferAlignment, sizeof(VkBool32));
}

#endif
#ifdef VK_EXT_device_memory_report
void marshal_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->deviceMemoryReport, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->deviceMemoryReport, sizeof(VkBool32));
}

void marshal_VkDeviceMemoryReportCallbackDataEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceMemoryReportCallbackDataEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceMemoryReportFlagsEXT*)&forMarshaling->flags, sizeof(VkDeviceMemoryReportFlagsEXT));
    vkStream->write((VkDeviceMemoryReportEventTypeEXT*)&forMarshaling->type, sizeof(VkDeviceMemoryReportEventTypeEXT));
    vkStream->write((uint64_t*)&forMarshaling->memoryObjectId, sizeof(uint64_t));
    vkStream->write((VkDeviceSize*)&forMarshaling->size, sizeof(VkDeviceSize));
    vkStream->write((VkObjectType*)&forMarshaling->objectType, sizeof(VkObjectType));
    vkStream->write((uint64_t*)&forMarshaling->objectHandle, sizeof(uint64_t));
    vkStream->write((uint32_t*)&forMarshaling->heapIndex, sizeof(uint32_t));
}

void unmarshal_VkDeviceMemoryReportCallbackDataEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceMemoryReportCallbackDataEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceMemoryReportFlagsEXT*)&forUnmarshaling->flags, sizeof(VkDeviceMemoryReportFlagsEXT));
    vkStream->read((VkDeviceMemoryReportEventTypeEXT*)&forUnmarshaling->type, sizeof(VkDeviceMemoryReportEventTypeEXT));
    vkStream->read((uint64_t*)&forUnmarshaling->memoryObjectId, sizeof(uint64_t));
    vkStream->read((VkDeviceSize*)&forUnmarshaling->size, sizeof(VkDeviceSize));
    vkStream->read((VkObjectType*)&forUnmarshaling->objectType, sizeof(VkObjectType));
    vkStream->read((uint64_t*)&forUnmarshaling->objectHandle, sizeof(uint64_t));
    vkStream->read((uint32_t*)&forUnmarshaling->heapIndex, sizeof(uint32_t));
}

void marshal_VkDeviceDeviceMemoryReportCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceDeviceMemoryReportCreateInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkDeviceMemoryReportFlagsEXT*)&forMarshaling->flags, sizeof(VkDeviceMemoryReportFlagsEXT));
    uint64_t cgen_var_0 = (uint64_t)forMarshaling->pfnUserCallback;
    vkStream->putBe64(cgen_var_0);
    vkStream->write((void*)forMarshaling->pUserData, sizeof(uint8_t));
}

void unmarshal_VkDeviceDeviceMemoryReportCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceDeviceMemoryReportCreateInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkDeviceMemoryReportFlagsEXT*)&forUnmarshaling->flags, sizeof(VkDeviceMemoryReportFlagsEXT));
    forUnmarshaling->pfnUserCallback = (PFN_vkDeviceMemoryReportCallbackEXT)vkStream->getBe64();
    vkStream->read((void*)forUnmarshaling->pUserData, sizeof(uint8_t));
}

#endif
#ifdef VK_EXT_custom_border_color
void marshal_VkSamplerCustomBorderColorCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerCustomBorderColorCreateInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    marshal_VkClearColorValue(vkStream, rootType, (VkClearColorValue*)(&forMarshaling->customBorderColor));
    vkStream->write((VkFormat*)&forMarshaling->format, sizeof(VkFormat));
}

void unmarshal_VkSamplerCustomBorderColorCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerCustomBorderColorCreateInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    unmarshal_VkClearColorValue(vkStream, rootType, (VkClearColorValue*)(&forUnmarshaling->customBorderColor));
    vkStream->read((VkFormat*)&forUnmarshaling->format, sizeof(VkFormat));
}

void marshal_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorPropertiesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->maxCustomBorderColorSamplers, sizeof(uint32_t));
}

void unmarshal_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->maxCustomBorderColorSamplers, sizeof(uint32_t));
}

void marshal_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->customBorderColors, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->customBorderColorWithoutFormat, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->customBorderColors, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->customBorderColorWithoutFormat, sizeof(VkBool32));
}

#endif
#ifdef VK_EXT_graphics_pipeline_library
void marshal_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->graphicsPipelineLibrary, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->graphicsPipelineLibrary, sizeof(VkBool32));
}

void marshal_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->graphicsPipelineLibraryFastLinking, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->graphicsPipelineLibraryIndependentInterpolationDecoration, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->graphicsPipelineLibraryFastLinking, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->graphicsPipelineLibraryIndependentInterpolationDecoration, sizeof(VkBool32));
}

void marshal_VkGraphicsPipelineLibraryCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkGraphicsPipelineLibraryCreateInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkGraphicsPipelineLibraryFlagsEXT*)&forMarshaling->flags, sizeof(VkGraphicsPipelineLibraryFlagsEXT));
}

void unmarshal_VkGraphicsPipelineLibraryCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkGraphicsPipelineLibraryCreateInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkGraphicsPipelineLibraryFlagsEXT*)&forUnmarshaling->flags, sizeof(VkGraphicsPipelineLibraryFlagsEXT));
}

#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void marshal_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->ycbcr2plane444Formats, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->ycbcr2plane444Formats, sizeof(VkBool32));
}

#endif
#ifdef VK_EXT_image_compression_control
void marshal_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->imageCompressionControl, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->imageCompressionControl, sizeof(VkBool32));
}

void marshal_VkImageCompressionControlEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCompressionControlEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkImageCompressionFlagsEXT*)&forMarshaling->flags, sizeof(VkImageCompressionFlagsEXT));
    vkStream->write((uint32_t*)&forMarshaling->compressionControlPlaneCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    uint64_t cgen_var_0 = (uint64_t)(uintptr_t)forMarshaling->pFixedRateFlags;
    vkStream->putBe64(cgen_var_0);
    if (forMarshaling->pFixedRateFlags)
    {
        vkStream->write((VkImageCompressionFixedRateFlagsEXT*)forMarshaling->pFixedRateFlags, forMarshaling->compressionControlPlaneCount * sizeof(VkImageCompressionFixedRateFlagsEXT));
    }
}

void unmarshal_VkImageCompressionControlEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageCompressionControlEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkImageCompressionFlagsEXT*)&forUnmarshaling->flags, sizeof(VkImageCompressionFlagsEXT));
    vkStream->read((uint32_t*)&forUnmarshaling->compressionControlPlaneCount, sizeof(uint32_t));
    // WARNING PTR CHECK
    VkImageCompressionFixedRateFlagsEXT* check_pFixedRateFlags;
    (void)check_pFixedRateFlags;
    check_pFixedRateFlags = (VkImageCompressionFixedRateFlagsEXT*)(uintptr_t)vkStream->getBe64();
    if (forUnmarshaling->pFixedRateFlags)
    {
        if (!(check_pFixedRateFlags))
        {
            fprintf(stderr, "fatal: forUnmarshaling->pFixedRateFlags inconsistent between guest and host\n");
        }
        vkStream->read((VkImageCompressionFixedRateFlagsEXT*)forUnmarshaling->pFixedRateFlags, forUnmarshaling->compressionControlPlaneCount * sizeof(VkImageCompressionFixedRateFlagsEXT));
    }
}

void marshal_VkImageCompressionPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCompressionPropertiesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkImageCompressionFlagsEXT*)&forMarshaling->imageCompressionFlags, sizeof(VkImageCompressionFlagsEXT));
    vkStream->write((VkImageCompressionFixedRateFlagsEXT*)&forMarshaling->imageCompressionFixedRateFlags, sizeof(VkImageCompressionFixedRateFlagsEXT));
}

void unmarshal_VkImageCompressionPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageCompressionPropertiesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkImageCompressionFlagsEXT*)&forUnmarshaling->imageCompressionFlags, sizeof(VkImageCompressionFlagsEXT));
    vkStream->read((VkImageCompressionFixedRateFlagsEXT*)&forUnmarshaling->imageCompressionFixedRateFlags, sizeof(VkImageCompressionFixedRateFlagsEXT));
}

#endif
#ifdef VK_EXT_4444_formats
void marshal_VkPhysicalDevice4444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice4444FormatsFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->formatA4R4G4B4, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->formatA4B4G4R4, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDevice4444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevice4444FormatsFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->formatA4R4G4B4, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->formatA4B4G4R4, sizeof(VkBool32));
}

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void marshal_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->primitiveTopologyListRestart, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->primitiveTopologyPatchListRestart, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->primitiveTopologyListRestart, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->primitiveTopologyPatchListRestart, sizeof(VkBool32));
}

#endif
#ifdef VK_EXT_extended_dynamic_state2
void marshal_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->extendedDynamicState2, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->extendedDynamicState2LogicOp, sizeof(VkBool32));
    vkStream->write((VkBool32*)&forMarshaling->extendedDynamicState2PatchControlPoints, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->extendedDynamicState2, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->extendedDynamicState2LogicOp, sizeof(VkBool32));
    vkStream->read((VkBool32*)&forUnmarshaling->extendedDynamicState2PatchControlPoints, sizeof(VkBool32));
}

#endif
#ifdef VK_EXT_color_write_enable
void marshal_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceColorWriteEnableFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->colorWriteEnable, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceColorWriteEnableFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->colorWriteEnable, sizeof(VkBool32));
}

void marshal_VkPipelineColorWriteCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorWriteCreateInfoEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->attachmentCount, sizeof(uint32_t));
    vkStream->write((const VkBool32*)forMarshaling->pColorWriteEnables, forMarshaling->attachmentCount * sizeof(const VkBool32));
}

void unmarshal_VkPipelineColorWriteCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineColorWriteCreateInfoEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->attachmentCount, sizeof(uint32_t));
    vkStream->read((VkBool32*)forUnmarshaling->pColorWriteEnables, forUnmarshaling->attachmentCount * sizeof(const VkBool32));
}

#endif
#ifdef VK_GOOGLE_gfxstream
void marshal_VkImportColorBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportColorBufferGOOGLE* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->colorBuffer, sizeof(uint32_t));
}

void unmarshal_VkImportColorBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImportColorBufferGOOGLE* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    forUnmarshaling->sType = VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->colorBuffer, sizeof(uint32_t));
}

void marshal_VkImportBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportBufferGOOGLE* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->buffer, sizeof(uint32_t));
}

void unmarshal_VkImportBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImportBufferGOOGLE* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    forUnmarshaling->sType = VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->buffer, sizeof(uint32_t));
}

void marshal_VkCreateBlobGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCreateBlobGOOGLE* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((uint32_t*)&forMarshaling->blobMem, sizeof(uint32_t));
    vkStream->write((uint32_t*)&forMarshaling->blobFlags, sizeof(uint32_t));
    vkStream->write((uint64_t*)&forMarshaling->blobId, sizeof(uint64_t));
}

void unmarshal_VkCreateBlobGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCreateBlobGOOGLE* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    forUnmarshaling->sType = VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((uint32_t*)&forUnmarshaling->blobMem, sizeof(uint32_t));
    vkStream->read((uint32_t*)&forUnmarshaling->blobFlags, sizeof(uint32_t));
    vkStream->read((uint64_t*)&forUnmarshaling->blobId, sizeof(uint64_t));
}

#endif
#ifdef VK_EXT_image_compression_control_swapchain
void marshal_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* forMarshaling)
{
    (void)rootType;
    vkStream->write((VkStructureType*)&forMarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forMarshaling->sType;
    }
    marshal_extension_struct(vkStream, rootType, forMarshaling->pNext);
    vkStream->write((VkBool32*)&forMarshaling->imageCompressionControlSwapchain, sizeof(VkBool32));
}

void unmarshal_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* forUnmarshaling)
{
    (void)rootType;
    vkStream->read((VkStructureType*)&forUnmarshaling->sType, sizeof(VkStructureType));
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM)
    {
        rootType = forUnmarshaling->sType;
    }
    unmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext));
    vkStream->read((VkBool32*)&forUnmarshaling->imageCompressionControlSwapchain, sizeof(VkBool32));
}

#endif
void marshal_extension_struct(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const void* structExtension)
{
    VkInstanceCreateInfo* structAccess = (VkInstanceCreateInfo*)(structExtension);
    size_t currExtSize = goldfish_vk_extension_struct_size_with_stream_features(vkStream->getFeatureBits(), rootType, structExtension);
    if (!currExtSize && structExtension)
    {
        // unknown struct extension; skip and call on its pNext field
        marshal_extension_struct(vkStream, rootType, (void*)structAccess->pNext);
        return;
    }
    else
    {
        // known or null extension struct
        vkStream->putBe32(currExtSize);
        if (!currExtSize)
        {
            // exit if this was a null extension struct (size == 0 in this branch)
            return;
        }
    }
    vkStream->write(structExtension, sizeof(VkStructureType));
    if (!structExtension)
    {
        return;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension);
    switch(structType)
    {
#ifdef VK_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO:
        {
            marshal_VkShaderModuleCreateInfo(vkStream, rootType, reinterpret_cast<const VkShaderModuleCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
        {
            marshal_VkPipelineLayoutCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineLayoutCreateInfo*>(structExtension));
            break;
        }
#endif
#ifdef VK_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        {
            marshal_VkPhysicalDeviceSubgroupProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        {
            marshal_VkPhysicalDevice16BitStorageFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevice16BitStorageFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
        {
            marshal_VkMemoryDedicatedRequirements(vkStream, rootType, reinterpret_cast<const VkMemoryDedicatedRequirements*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO:
        {
            marshal_VkMemoryDedicatedAllocateInfo(vkStream, rootType, reinterpret_cast<const VkMemoryDedicatedAllocateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO:
        {
            marshal_VkMemoryAllocateFlagsInfo(vkStream, rootType, reinterpret_cast<const VkMemoryAllocateFlagsInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
        {
            marshal_VkDeviceGroupRenderPassBeginInfo(vkStream, rootType, reinterpret_cast<const VkDeviceGroupRenderPassBeginInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
        {
            marshal_VkDeviceGroupCommandBufferBeginInfo(vkStream, rootType, reinterpret_cast<const VkDeviceGroupCommandBufferBeginInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO:
        {
            marshal_VkDeviceGroupSubmitInfo(vkStream, rootType, reinterpret_cast<const VkDeviceGroupSubmitInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO:
        {
            marshal_VkDeviceGroupBindSparseInfo(vkStream, rootType, reinterpret_cast<const VkDeviceGroupBindSparseInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO:
        {
            marshal_VkBindBufferMemoryDeviceGroupInfo(vkStream, rootType, reinterpret_cast<const VkBindBufferMemoryDeviceGroupInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
        {
            marshal_VkBindImageMemoryDeviceGroupInfo(vkStream, rootType, reinterpret_cast<const VkBindImageMemoryDeviceGroupInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
        {
            marshal_VkDeviceGroupDeviceCreateInfo(vkStream, rootType, reinterpret_cast<const VkDeviceGroupDeviceCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
        {
            marshal_VkPhysicalDeviceFeatures2(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFeatures2*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        {
            marshal_VkPhysicalDevicePointClippingProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePointClippingProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
        {
            marshal_VkRenderPassInputAttachmentAspectCreateInfo(vkStream, rootType, reinterpret_cast<const VkRenderPassInputAttachmentAspectCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO:
        {
            marshal_VkImageViewUsageCreateInfo(vkStream, rootType, reinterpret_cast<const VkImageViewUsageCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
        {
            marshal_VkPipelineTessellationDomainOriginStateCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineTessellationDomainOriginStateCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
        {
            marshal_VkRenderPassMultiviewCreateInfo(vkStream, rootType, reinterpret_cast<const VkRenderPassMultiviewCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        {
            marshal_VkPhysicalDeviceMultiviewFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMultiviewFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        {
            marshal_VkPhysicalDeviceMultiviewProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMultiviewProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        {
            marshal_VkPhysicalDeviceVariablePointersFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVariablePointersFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        {
            marshal_VkPhysicalDeviceProtectedMemoryFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceProtectedMemoryFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        {
            marshal_VkPhysicalDeviceProtectedMemoryProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceProtectedMemoryProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO:
        {
            marshal_VkProtectedSubmitInfo(vkStream, rootType, reinterpret_cast<const VkProtectedSubmitInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO:
        {
            marshal_VkSamplerYcbcrConversionInfo(vkStream, rootType, reinterpret_cast<const VkSamplerYcbcrConversionInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
        {
            marshal_VkBindImagePlaneMemoryInfo(vkStream, rootType, reinterpret_cast<const VkBindImagePlaneMemoryInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
        {
            marshal_VkImagePlaneMemoryRequirementsInfo(vkStream, rootType, reinterpret_cast<const VkImagePlaneMemoryRequirementsInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        {
            marshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSamplerYcbcrConversionFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
        {
            marshal_VkSamplerYcbcrConversionImageFormatProperties(vkStream, rootType, reinterpret_cast<const VkSamplerYcbcrConversionImageFormatProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
        {
            marshal_VkPhysicalDeviceExternalImageFormatInfo(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceExternalImageFormatInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
        {
            marshal_VkExternalImageFormatProperties(vkStream, rootType, reinterpret_cast<const VkExternalImageFormatProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        {
            marshal_VkPhysicalDeviceIDProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceIDProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
        {
            marshal_VkExternalMemoryImageCreateInfo(vkStream, rootType, reinterpret_cast<const VkExternalMemoryImageCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO:
        {
            marshal_VkExternalMemoryBufferCreateInfo(vkStream, rootType, reinterpret_cast<const VkExternalMemoryBufferCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO:
        {
            marshal_VkExportMemoryAllocateInfo(vkStream, rootType, reinterpret_cast<const VkExportMemoryAllocateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
        {
            marshal_VkExportFenceCreateInfo(vkStream, rootType, reinterpret_cast<const VkExportFenceCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO:
        {
            marshal_VkExportSemaphoreCreateInfo(vkStream, rootType, reinterpret_cast<const VkExportSemaphoreCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        {
            marshal_VkPhysicalDeviceMaintenance3Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance3Properties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        {
            marshal_VkPhysicalDeviceShaderDrawParametersFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderDrawParametersFeatures*>(structExtension));
            break;
        }
#endif
#ifdef VK_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        {
            marshal_VkPhysicalDeviceVulkan11Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan11Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        {
            marshal_VkPhysicalDeviceVulkan11Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan11Properties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        {
            marshal_VkPhysicalDeviceVulkan12Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan12Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        {
            marshal_VkPhysicalDeviceVulkan12Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan12Properties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
        {
            marshal_VkImageFormatListCreateInfo(vkStream, rootType, reinterpret_cast<const VkImageFormatListCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        {
            marshal_VkPhysicalDevice8BitStorageFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevice8BitStorageFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        {
            marshal_VkPhysicalDeviceDriverProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDriverProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        {
            marshal_VkPhysicalDeviceShaderAtomicInt64Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderAtomicInt64Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        {
            marshal_VkPhysicalDeviceShaderFloat16Int8Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderFloat16Int8Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        {
            marshal_VkPhysicalDeviceFloatControlsProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFloatControlsProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO:
        {
            marshal_VkDescriptorSetLayoutBindingFlagsCreateInfo(vkStream, rootType, reinterpret_cast<const VkDescriptorSetLayoutBindingFlagsCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        {
            marshal_VkPhysicalDeviceDescriptorIndexingFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDescriptorIndexingFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        {
            marshal_VkPhysicalDeviceDescriptorIndexingProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDescriptorIndexingProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO:
        {
            marshal_VkDescriptorSetVariableDescriptorCountAllocateInfo(vkStream, rootType, reinterpret_cast<const VkDescriptorSetVariableDescriptorCountAllocateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT:
        {
            marshal_VkDescriptorSetVariableDescriptorCountLayoutSupport(vkStream, rootType, reinterpret_cast<const VkDescriptorSetVariableDescriptorCountLayoutSupport*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
        {
            marshal_VkSubpassDescriptionDepthStencilResolve(vkStream, rootType, reinterpret_cast<const VkSubpassDescriptionDepthStencilResolve*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        {
            marshal_VkPhysicalDeviceDepthStencilResolveProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDepthStencilResolveProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        {
            marshal_VkPhysicalDeviceScalarBlockLayoutFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceScalarBlockLayoutFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
        {
            marshal_VkImageStencilUsageCreateInfo(vkStream, rootType, reinterpret_cast<const VkImageStencilUsageCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO:
        {
            marshal_VkSamplerReductionModeCreateInfo(vkStream, rootType, reinterpret_cast<const VkSamplerReductionModeCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        {
            marshal_VkPhysicalDeviceSamplerFilterMinmaxProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSamplerFilterMinmaxProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        {
            marshal_VkPhysicalDeviceVulkanMemoryModelFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkanMemoryModelFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        {
            marshal_VkPhysicalDeviceImagelessFramebufferFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceImagelessFramebufferFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
        {
            marshal_VkFramebufferAttachmentsCreateInfo(vkStream, rootType, reinterpret_cast<const VkFramebufferAttachmentsCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
        {
            marshal_VkRenderPassAttachmentBeginInfo(vkStream, rootType, reinterpret_cast<const VkRenderPassAttachmentBeginInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        {
            marshal_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceUniformBufferStandardLayoutFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        {
            marshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        {
            marshal_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
        {
            marshal_VkAttachmentReferenceStencilLayout(vkStream, rootType, reinterpret_cast<const VkAttachmentReferenceStencilLayout*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
        {
            marshal_VkAttachmentDescriptionStencilLayout(vkStream, rootType, reinterpret_cast<const VkAttachmentDescriptionStencilLayout*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        {
            marshal_VkPhysicalDeviceHostQueryResetFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceHostQueryResetFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        {
            marshal_VkPhysicalDeviceTimelineSemaphoreFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTimelineSemaphoreFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        {
            marshal_VkPhysicalDeviceTimelineSemaphoreProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTimelineSemaphoreProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
        {
            marshal_VkSemaphoreTypeCreateInfo(vkStream, rootType, reinterpret_cast<const VkSemaphoreTypeCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
        {
            marshal_VkTimelineSemaphoreSubmitInfo(vkStream, rootType, reinterpret_cast<const VkTimelineSemaphoreSubmitInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        {
            marshal_VkPhysicalDeviceBufferDeviceAddressFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceBufferDeviceAddressFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
        {
            marshal_VkBufferOpaqueCaptureAddressCreateInfo(vkStream, rootType, reinterpret_cast<const VkBufferOpaqueCaptureAddressCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
        {
            marshal_VkMemoryOpaqueCaptureAddressAllocateInfo(vkStream, rootType, reinterpret_cast<const VkMemoryOpaqueCaptureAddressAllocateInfo*>(structExtension));
            break;
        }
#endif
#ifdef VK_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        {
            marshal_VkPhysicalDeviceVulkan13Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan13Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
        {
            marshal_VkPhysicalDeviceVulkan13Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan13Properties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
        {
            marshal_VkPipelineCreationFeedbackCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineCreationFeedbackCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        {
            marshal_VkPhysicalDeviceShaderTerminateInvocationFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderTerminateInvocationFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        {
            marshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        {
            marshal_VkPhysicalDevicePrivateDataFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePrivateDataFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
        {
            marshal_VkDevicePrivateDataCreateInfo(vkStream, rootType, reinterpret_cast<const VkDevicePrivateDataCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        {
            marshal_VkPhysicalDevicePipelineCreationCacheControlFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePipelineCreationCacheControlFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
        {
            marshal_VkMemoryBarrier2(vkStream, rootType, reinterpret_cast<const VkMemoryBarrier2*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        {
            marshal_VkPhysicalDeviceSynchronization2Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSynchronization2Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        {
            marshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        {
            marshal_VkPhysicalDeviceImageRobustnessFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceImageRobustnessFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        {
            marshal_VkPhysicalDeviceSubgroupSizeControlFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupSizeControlFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
        {
            marshal_VkPhysicalDeviceSubgroupSizeControlProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceSubgroupSizeControlProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO:
        {
            marshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        {
            marshal_VkPhysicalDeviceInlineUniformBlockFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceInlineUniformBlockFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
        {
            marshal_VkPhysicalDeviceInlineUniformBlockProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceInlineUniformBlockProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK:
        {
            marshal_VkWriteDescriptorSetInlineUniformBlock(vkStream, rootType, reinterpret_cast<const VkWriteDescriptorSetInlineUniformBlock*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO:
        {
            marshal_VkDescriptorPoolInlineUniformBlockCreateInfo(vkStream, rootType, reinterpret_cast<const VkDescriptorPoolInlineUniformBlockCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        {
            marshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTextureCompressionASTCHDRFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO:
        {
            marshal_VkPipelineRenderingCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineRenderingCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        {
            marshal_VkPhysicalDeviceDynamicRenderingFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDynamicRenderingFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
        {
            marshal_VkCommandBufferInheritanceRenderingInfo(vkStream, rootType, reinterpret_cast<const VkCommandBufferInheritanceRenderingInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        {
            marshal_VkPhysicalDeviceShaderIntegerDotProductFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderIntegerDotProductFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
        {
            marshal_VkPhysicalDeviceShaderIntegerDotProductProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderIntegerDotProductProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
        {
            marshal_VkPhysicalDeviceTexelBufferAlignmentProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTexelBufferAlignmentProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
        {
            marshal_VkFormatProperties3(vkStream, rootType, reinterpret_cast<const VkFormatProperties3*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        {
            marshal_VkPhysicalDeviceMaintenance4Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance4Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
        {
            marshal_VkPhysicalDeviceMaintenance4Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance4Properties*>(structExtension));
            break;
        }
#endif
#ifdef VK_VERSION_1_4
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
        {
            marshal_VkPhysicalDeviceVulkan14Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan14Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES:
        {
            marshal_VkPhysicalDeviceVulkan14Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVulkan14Properties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO:
        {
            marshal_VkDeviceQueueGlobalPriorityCreateInfo(vkStream, rootType, reinterpret_cast<const VkDeviceQueueGlobalPriorityCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
        {
            marshal_VkPhysicalDeviceGlobalPriorityQueryFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceGlobalPriorityQueryFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES:
        {
            marshal_VkQueueFamilyGlobalPriorityProperties(vkStream, rootType, reinterpret_cast<const VkQueueFamilyGlobalPriorityProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
        {
            marshal_VkPhysicalDeviceShaderSubgroupRotateFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderSubgroupRotateFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
        {
            marshal_VkPhysicalDeviceShaderFloatControls2Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderFloatControls2Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
        {
            marshal_VkPhysicalDeviceShaderExpectAssumeFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceShaderExpectAssumeFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
        {
            marshal_VkPhysicalDeviceLineRasterizationFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceLineRasterizationFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES:
        {
            marshal_VkPhysicalDeviceLineRasterizationProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceLineRasterizationProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO:
        {
            marshal_VkPipelineRasterizationLineStateCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineRasterizationLineStateCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES:
        {
            marshal_VkPhysicalDeviceVertexAttributeDivisorProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO:
        {
            marshal_VkPipelineVertexInputDivisorStateCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineVertexInputDivisorStateCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
        {
            marshal_VkPhysicalDeviceVertexAttributeDivisorFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
        {
            marshal_VkPhysicalDeviceIndexTypeUint8Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceIndexTypeUint8Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
        {
            marshal_VkPhysicalDeviceMaintenance5Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance5Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES:
        {
            marshal_VkPhysicalDeviceMaintenance5Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance5Properties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO:
        {
            marshal_VkPipelineCreateFlags2CreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineCreateFlags2CreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO:
        {
            marshal_VkBufferUsageFlags2CreateInfo(vkStream, rootType, reinterpret_cast<const VkBufferUsageFlags2CreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES:
        {
            marshal_VkPhysicalDevicePushDescriptorProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePushDescriptorProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
        {
            marshal_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDynamicRenderingLocalReadFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO:
        {
            marshal_VkRenderingAttachmentLocationInfo(vkStream, rootType, reinterpret_cast<const VkRenderingAttachmentLocationInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO:
        {
            marshal_VkRenderingInputAttachmentIndexInfo(vkStream, rootType, reinterpret_cast<const VkRenderingInputAttachmentIndexInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
        {
            marshal_VkPhysicalDeviceMaintenance6Features(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance6Features*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES:
        {
            marshal_VkPhysicalDeviceMaintenance6Properties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMaintenance6Properties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS:
        {
            marshal_VkBindMemoryStatus(vkStream, rootType, reinterpret_cast<const VkBindMemoryStatus*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
        {
            marshal_VkPhysicalDevicePipelineProtectedAccessFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePipelineProtectedAccessFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
        {
            marshal_VkPhysicalDevicePipelineRobustnessFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePipelineRobustnessFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES:
        {
            marshal_VkPhysicalDevicePipelineRobustnessProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePipelineRobustnessProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO:
        {
            marshal_VkPipelineRobustnessCreateInfo(vkStream, rootType, reinterpret_cast<const VkPipelineRobustnessCreateInfo*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
        {
            marshal_VkPhysicalDeviceHostImageCopyFeatures(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceHostImageCopyFeatures*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES:
        {
            marshal_VkPhysicalDeviceHostImageCopyProperties(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceHostImageCopyProperties*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
        {
            marshal_VkSubresourceHostMemcpySize(vkStream, rootType, reinterpret_cast<const VkSubresourceHostMemcpySize*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY:
        {
            marshal_VkHostImageCopyDevicePerformanceQuery(vkStream, rootType, reinterpret_cast<const VkHostImageCopyDevicePerformanceQuery*>(structExtension));
            break;
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR:
        {
            marshal_VkPresentRegionsKHR(vkStream, rootType, reinterpret_cast<const VkPresentRegionsKHR*>(structExtension));
            break;
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR:
        {
            marshal_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*>(structExtension));
            break;
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID:
        {
            marshal_VkNativeBufferANDROID(vkStream, rootType, reinterpret_cast<const VkNativeBufferANDROID*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_IMAGE_CREATE_INFO_ANDROID:
        {
            marshal_VkSwapchainImageCreateInfoANDROID(vkStream, rootType, reinterpret_cast<const VkSwapchainImageCreateInfoANDROID*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENTATION_PROPERTIES_ANDROID:
        {
            marshal_VkPhysicalDevicePresentationPropertiesANDROID(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePresentationPropertiesANDROID*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceTransformFeedbackFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTransformFeedbackFeaturesEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        {
            marshal_VkPhysicalDeviceTransformFeedbackPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTransformFeedbackPropertiesEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
        {
            marshal_VkPipelineRasterizationStateStreamCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkPipelineRasterizationStateStreamCreateInfoEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_depth_clip_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceDepthClipEnableFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDepthClipEnableFeaturesEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT:
        {
            marshal_VkPipelineRasterizationDepthClipStateCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkPipelineRasterizationDepthClipStateCreateInfoEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_image_drm_format_modifier
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
        {
            marshal_VkDrmFormatModifierPropertiesListEXT(vkStream, rootType, reinterpret_cast<const VkDrmFormatModifierPropertiesListEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
        {
            marshal_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceImageDrmFormatModifierInfoEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
        {
            marshal_VkImageDrmFormatModifierListCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkImageDrmFormatModifierListCreateInfoEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
        {
            marshal_VkImageDrmFormatModifierExplicitCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkImageDrmFormatModifierExplicitCreateInfoEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
        {
            marshal_VkDrmFormatModifierPropertiesList2EXT(vkStream, rootType, reinterpret_cast<const VkDrmFormatModifierPropertiesList2EXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_vertex_attribute_divisor
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
        {
            marshal_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_fragment_density_map
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
                {
                    marshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension));
                    break;
                }
                case VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO:
                {
                    marshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension));
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    marshal_VkImportColorBufferGOOGLE(vkStream, rootType, reinterpret_cast<const VkImportColorBufferGOOGLE*>(structExtension));
                    break;
                }
                default:
                {
                    marshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension));
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2:
                {
                    marshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension));
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    marshal_VkCreateBlobGOOGLE(vkStream, rootType, reinterpret_cast<const VkCreateBlobGOOGLE*>(structExtension));
                    break;
                }
                default:
                {
                    marshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension));
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO:
                {
                    marshal_VkRenderPassFragmentDensityMapCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension));
                    break;
                }
                case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2:
                {
                    marshal_VkRenderPassFragmentDensityMapCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension));
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    marshal_VkImportBufferGOOGLE(vkStream, rootType, reinterpret_cast<const VkImportBufferGOOGLE*>(structExtension));
                    break;
                }
                default:
                {
                    marshal_VkRenderPassFragmentDensityMapCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension));
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT:
        {
            marshal_VkRenderingFragmentDensityMapAttachmentInfoEXT(vkStream, rootType, reinterpret_cast<const VkRenderingFragmentDensityMapAttachmentInfoEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_memory_budget
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
        {
            marshal_VkPhysicalDeviceMemoryBudgetPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceMemoryBudgetPropertiesEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceProvokingVertexFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceProvokingVertexFeaturesEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
        {
            marshal_VkPhysicalDeviceProvokingVertexPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceProvokingVertexPropertiesEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT:
        {
            marshal_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT:
        {
            marshal_VkDeviceDeviceMemoryReportCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkDeviceDeviceMemoryReportCreateInfoEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT:
        {
            marshal_VkSamplerCustomBorderColorCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkSamplerCustomBorderColorCreateInfoEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
        {
            marshal_VkPhysicalDeviceCustomBorderColorPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceCustomBorderColorPropertiesEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceCustomBorderColorFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceCustomBorderColorFeaturesEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_graphics_pipeline_library
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
        {
            marshal_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
        {
            marshal_VkGraphicsPipelineLibraryCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkGraphicsPipelineLibraryCreateInfoEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceImageCompressionControlFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceImageCompressionControlFeaturesEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT:
        {
            marshal_VkImageCompressionControlEXT(vkStream, rootType, reinterpret_cast<const VkImageCompressionControlEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT:
        {
            marshal_VkImageCompressionPropertiesEXT(vkStream, rootType, reinterpret_cast<const VkImageCompressionPropertiesEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        {
            marshal_VkPhysicalDevice4444FormatsFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDevice4444FormatsFeaturesEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        {
            marshal_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_color_write_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceColorWriteEnableFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceColorWriteEnableFeaturesEXT*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT:
        {
            marshal_VkPipelineColorWriteCreateInfoEXT(vkStream, rootType, reinterpret_cast<const VkPipelineColorWriteCreateInfoEXT*>(structExtension));
            break;
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE:
        {
            marshal_VkImportColorBufferGOOGLE(vkStream, rootType, reinterpret_cast<const VkImportColorBufferGOOGLE*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE:
        {
            marshal_VkImportBufferGOOGLE(vkStream, rootType, reinterpret_cast<const VkImportBufferGOOGLE*>(structExtension));
            break;
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE:
        {
            marshal_VkCreateBlobGOOGLE(vkStream, rootType, reinterpret_cast<const VkCreateBlobGOOGLE*>(structExtension));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT:
        {
            marshal_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(vkStream, rootType, reinterpret_cast<const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*>(structExtension));
            break;
        }
#endif
        default:
        {
            // fatal; the switch is only taken if the extension struct is known
            abort();
        }
    }
}

void unmarshal_extension_struct(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    void* structExtension_out)
{
    VkInstanceCreateInfo* structAccess = (VkInstanceCreateInfo*)(structExtension_out);
    size_t currExtSize = goldfish_vk_extension_struct_size_with_stream_features(vkStream->getFeatureBits(), rootType, structExtension_out);
    if (!currExtSize && structExtension_out)
    {
        // unknown struct extension; skip and call on its pNext field
        unmarshal_extension_struct(vkStream, rootType, (void*)structAccess->pNext);
        return;
    }
    else
    {
        // known or null extension struct
        vkStream->getBe32();
        if (!currExtSize)
        {
            // exit if this was a null extension struct (size == 0 in this branch)
            return;
        }
    }
    uint64_t pNext_placeholder;
    vkStream->read((void*)(&pNext_placeholder), sizeof(VkStructureType));
    (void)pNext_placeholder;
    if (!structExtension_out)
    {
        return;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension_out);
    switch(structType)
    {
#ifdef VK_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO:
        {
            unmarshal_VkShaderModuleCreateInfo(vkStream, rootType, reinterpret_cast<VkShaderModuleCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
        {
            unmarshal_VkPipelineLayoutCreateInfo(vkStream, rootType, reinterpret_cast<VkPipelineLayoutCreateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceSubgroupProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceSubgroupProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        {
            unmarshal_VkPhysicalDevice16BitStorageFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDevice16BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
        {
            unmarshal_VkMemoryDedicatedRequirements(vkStream, rootType, reinterpret_cast<VkMemoryDedicatedRequirements*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO:
        {
            unmarshal_VkMemoryDedicatedAllocateInfo(vkStream, rootType, reinterpret_cast<VkMemoryDedicatedAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO:
        {
            unmarshal_VkMemoryAllocateFlagsInfo(vkStream, rootType, reinterpret_cast<VkMemoryAllocateFlagsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
        {
            unmarshal_VkDeviceGroupRenderPassBeginInfo(vkStream, rootType, reinterpret_cast<VkDeviceGroupRenderPassBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
        {
            unmarshal_VkDeviceGroupCommandBufferBeginInfo(vkStream, rootType, reinterpret_cast<VkDeviceGroupCommandBufferBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO:
        {
            unmarshal_VkDeviceGroupSubmitInfo(vkStream, rootType, reinterpret_cast<VkDeviceGroupSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO:
        {
            unmarshal_VkDeviceGroupBindSparseInfo(vkStream, rootType, reinterpret_cast<VkDeviceGroupBindSparseInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO:
        {
            unmarshal_VkBindBufferMemoryDeviceGroupInfo(vkStream, rootType, reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
        {
            unmarshal_VkBindImageMemoryDeviceGroupInfo(vkStream, rootType, reinterpret_cast<VkBindImageMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
        {
            unmarshal_VkDeviceGroupDeviceCreateInfo(vkStream, rootType, reinterpret_cast<VkDeviceGroupDeviceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
        {
            unmarshal_VkPhysicalDeviceFeatures2(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceFeatures2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        {
            unmarshal_VkPhysicalDevicePointClippingProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDevicePointClippingProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
        {
            unmarshal_VkRenderPassInputAttachmentAspectCreateInfo(vkStream, rootType, reinterpret_cast<VkRenderPassInputAttachmentAspectCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO:
        {
            unmarshal_VkImageViewUsageCreateInfo(vkStream, rootType, reinterpret_cast<VkImageViewUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
        {
            unmarshal_VkPipelineTessellationDomainOriginStateCreateInfo(vkStream, rootType, reinterpret_cast<VkPipelineTessellationDomainOriginStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
        {
            unmarshal_VkRenderPassMultiviewCreateInfo(vkStream, rootType, reinterpret_cast<VkRenderPassMultiviewCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        {
            unmarshal_VkPhysicalDeviceMultiviewFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceMultiviewFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceMultiviewProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceMultiviewProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        {
            unmarshal_VkPhysicalDeviceVariablePointersFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVariablePointersFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        {
            unmarshal_VkPhysicalDeviceProtectedMemoryFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceProtectedMemoryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceProtectedMemoryProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceProtectedMemoryProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO:
        {
            unmarshal_VkProtectedSubmitInfo(vkStream, rootType, reinterpret_cast<VkProtectedSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO:
        {
            unmarshal_VkSamplerYcbcrConversionInfo(vkStream, rootType, reinterpret_cast<VkSamplerYcbcrConversionInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
        {
            unmarshal_VkBindImagePlaneMemoryInfo(vkStream, rootType, reinterpret_cast<VkBindImagePlaneMemoryInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
        {
            unmarshal_VkImagePlaneMemoryRequirementsInfo(vkStream, rootType, reinterpret_cast<VkImagePlaneMemoryRequirementsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        {
            unmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceSamplerYcbcrConversionFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
        {
            unmarshal_VkSamplerYcbcrConversionImageFormatProperties(vkStream, rootType, reinterpret_cast<VkSamplerYcbcrConversionImageFormatProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
        {
            unmarshal_VkPhysicalDeviceExternalImageFormatInfo(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceExternalImageFormatInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
        {
            unmarshal_VkExternalImageFormatProperties(vkStream, rootType, reinterpret_cast<VkExternalImageFormatProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceIDProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceIDProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
        {
            unmarshal_VkExternalMemoryImageCreateInfo(vkStream, rootType, reinterpret_cast<VkExternalMemoryImageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO:
        {
            unmarshal_VkExternalMemoryBufferCreateInfo(vkStream, rootType, reinterpret_cast<VkExternalMemoryBufferCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO:
        {
            unmarshal_VkExportMemoryAllocateInfo(vkStream, rootType, reinterpret_cast<VkExportMemoryAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
        {
            unmarshal_VkExportFenceCreateInfo(vkStream, rootType, reinterpret_cast<VkExportFenceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO:
        {
            unmarshal_VkExportSemaphoreCreateInfo(vkStream, rootType, reinterpret_cast<VkExportSemaphoreCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceMaintenance3Properties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceMaintenance3Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        {
            unmarshal_VkPhysicalDeviceShaderDrawParametersFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceShaderDrawParametersFeatures*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        {
            unmarshal_VkPhysicalDeviceVulkan11Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVulkan11Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceVulkan11Properties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVulkan11Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        {
            unmarshal_VkPhysicalDeviceVulkan12Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVulkan12Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceVulkan12Properties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVulkan12Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
        {
            unmarshal_VkImageFormatListCreateInfo(vkStream, rootType, reinterpret_cast<VkImageFormatListCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        {
            unmarshal_VkPhysicalDevice8BitStorageFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDevice8BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceDriverProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceDriverProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        {
            unmarshal_VkPhysicalDeviceShaderAtomicInt64Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceShaderAtomicInt64Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        {
            unmarshal_VkPhysicalDeviceShaderFloat16Int8Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceShaderFloat16Int8Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceFloatControlsProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceFloatControlsProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO:
        {
            unmarshal_VkDescriptorSetLayoutBindingFlagsCreateInfo(vkStream, rootType, reinterpret_cast<VkDescriptorSetLayoutBindingFlagsCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        {
            unmarshal_VkPhysicalDeviceDescriptorIndexingFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceDescriptorIndexingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceDescriptorIndexingProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceDescriptorIndexingProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO:
        {
            unmarshal_VkDescriptorSetVariableDescriptorCountAllocateInfo(vkStream, rootType, reinterpret_cast<VkDescriptorSetVariableDescriptorCountAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT:
        {
            unmarshal_VkDescriptorSetVariableDescriptorCountLayoutSupport(vkStream, rootType, reinterpret_cast<VkDescriptorSetVariableDescriptorCountLayoutSupport*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
        {
            unmarshal_VkSubpassDescriptionDepthStencilResolve(vkStream, rootType, reinterpret_cast<VkSubpassDescriptionDepthStencilResolve*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceDepthStencilResolveProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceDepthStencilResolveProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        {
            unmarshal_VkPhysicalDeviceScalarBlockLayoutFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceScalarBlockLayoutFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
        {
            unmarshal_VkImageStencilUsageCreateInfo(vkStream, rootType, reinterpret_cast<VkImageStencilUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO:
        {
            unmarshal_VkSamplerReductionModeCreateInfo(vkStream, rootType, reinterpret_cast<VkSamplerReductionModeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceSamplerFilterMinmaxProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceSamplerFilterMinmaxProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        {
            unmarshal_VkPhysicalDeviceVulkanMemoryModelFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVulkanMemoryModelFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        {
            unmarshal_VkPhysicalDeviceImagelessFramebufferFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceImagelessFramebufferFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
        {
            unmarshal_VkFramebufferAttachmentsCreateInfo(vkStream, rootType, reinterpret_cast<VkFramebufferAttachmentsCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
        {
            unmarshal_VkRenderPassAttachmentBeginInfo(vkStream, rootType, reinterpret_cast<VkRenderPassAttachmentBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        {
            unmarshal_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceUniformBufferStandardLayoutFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        {
            unmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        {
            unmarshal_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
        {
            unmarshal_VkAttachmentReferenceStencilLayout(vkStream, rootType, reinterpret_cast<VkAttachmentReferenceStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
        {
            unmarshal_VkAttachmentDescriptionStencilLayout(vkStream, rootType, reinterpret_cast<VkAttachmentDescriptionStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        {
            unmarshal_VkPhysicalDeviceHostQueryResetFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceHostQueryResetFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        {
            unmarshal_VkPhysicalDeviceTimelineSemaphoreFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceTimelineSemaphoreProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
        {
            unmarshal_VkSemaphoreTypeCreateInfo(vkStream, rootType, reinterpret_cast<VkSemaphoreTypeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
        {
            unmarshal_VkTimelineSemaphoreSubmitInfo(vkStream, rootType, reinterpret_cast<VkTimelineSemaphoreSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        {
            unmarshal_VkPhysicalDeviceBufferDeviceAddressFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceBufferDeviceAddressFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
        {
            unmarshal_VkBufferOpaqueCaptureAddressCreateInfo(vkStream, rootType, reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
        {
            unmarshal_VkMemoryOpaqueCaptureAddressAllocateInfo(vkStream, rootType, reinterpret_cast<VkMemoryOpaqueCaptureAddressAllocateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        {
            unmarshal_VkPhysicalDeviceVulkan13Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVulkan13Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceVulkan13Properties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVulkan13Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
        {
            unmarshal_VkPipelineCreationFeedbackCreateInfo(vkStream, rootType, reinterpret_cast<VkPipelineCreationFeedbackCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        {
            unmarshal_VkPhysicalDeviceShaderTerminateInvocationFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceShaderTerminateInvocationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        {
            unmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        {
            unmarshal_VkPhysicalDevicePrivateDataFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDevicePrivateDataFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
        {
            unmarshal_VkDevicePrivateDataCreateInfo(vkStream, rootType, reinterpret_cast<VkDevicePrivateDataCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        {
            unmarshal_VkPhysicalDevicePipelineCreationCacheControlFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDevicePipelineCreationCacheControlFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
        {
            unmarshal_VkMemoryBarrier2(vkStream, rootType, reinterpret_cast<VkMemoryBarrier2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        {
            unmarshal_VkPhysicalDeviceSynchronization2Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceSynchronization2Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        {
            unmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        {
            unmarshal_VkPhysicalDeviceImageRobustnessFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceImageRobustnessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        {
            unmarshal_VkPhysicalDeviceSubgroupSizeControlFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceSubgroupSizeControlProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO:
        {
            unmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(vkStream, rootType, reinterpret_cast<VkPipelineShaderStageRequiredSubgroupSizeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        {
            unmarshal_VkPhysicalDeviceInlineUniformBlockFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceInlineUniformBlockFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceInlineUniformBlockProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceInlineUniformBlockProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK:
        {
            unmarshal_VkWriteDescriptorSetInlineUniformBlock(vkStream, rootType, reinterpret_cast<VkWriteDescriptorSetInlineUniformBlock*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO:
        {
            unmarshal_VkDescriptorPoolInlineUniformBlockCreateInfo(vkStream, rootType, reinterpret_cast<VkDescriptorPoolInlineUniformBlockCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        {
            unmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceTextureCompressionASTCHDRFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO:
        {
            unmarshal_VkPipelineRenderingCreateInfo(vkStream, rootType, reinterpret_cast<VkPipelineRenderingCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        {
            unmarshal_VkPhysicalDeviceDynamicRenderingFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceDynamicRenderingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
        {
            unmarshal_VkCommandBufferInheritanceRenderingInfo(vkStream, rootType, reinterpret_cast<VkCommandBufferInheritanceRenderingInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        {
            unmarshal_VkPhysicalDeviceShaderIntegerDotProductFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceShaderIntegerDotProductProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceTexelBufferAlignmentProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
        {
            unmarshal_VkFormatProperties3(vkStream, rootType, reinterpret_cast<VkFormatProperties3*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        {
            unmarshal_VkPhysicalDeviceMaintenance4Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceMaintenance4Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceMaintenance4Properties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceMaintenance4Properties*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_4
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
        {
            unmarshal_VkPhysicalDeviceVulkan14Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVulkan14Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceVulkan14Properties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVulkan14Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO:
        {
            unmarshal_VkDeviceQueueGlobalPriorityCreateInfo(vkStream, rootType, reinterpret_cast<VkDeviceQueueGlobalPriorityCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
        {
            unmarshal_VkPhysicalDeviceGlobalPriorityQueryFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceGlobalPriorityQueryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES:
        {
            unmarshal_VkQueueFamilyGlobalPriorityProperties(vkStream, rootType, reinterpret_cast<VkQueueFamilyGlobalPriorityProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
        {
            unmarshal_VkPhysicalDeviceShaderSubgroupRotateFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceShaderSubgroupRotateFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
        {
            unmarshal_VkPhysicalDeviceShaderFloatControls2Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceShaderFloatControls2Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
        {
            unmarshal_VkPhysicalDeviceShaderExpectAssumeFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceShaderExpectAssumeFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
        {
            unmarshal_VkPhysicalDeviceLineRasterizationFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceLineRasterizationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceLineRasterizationProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceLineRasterizationProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO:
        {
            unmarshal_VkPipelineRasterizationLineStateCreateInfo(vkStream, rootType, reinterpret_cast<VkPipelineRasterizationLineStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceVertexAttributeDivisorProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO:
        {
            unmarshal_VkPipelineVertexInputDivisorStateCreateInfo(vkStream, rootType, reinterpret_cast<VkPipelineVertexInputDivisorStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
        {
            unmarshal_VkPhysicalDeviceVertexAttributeDivisorFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
        {
            unmarshal_VkPhysicalDeviceIndexTypeUint8Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceIndexTypeUint8Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
        {
            unmarshal_VkPhysicalDeviceMaintenance5Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceMaintenance5Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceMaintenance5Properties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceMaintenance5Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO:
        {
            unmarshal_VkPipelineCreateFlags2CreateInfo(vkStream, rootType, reinterpret_cast<VkPipelineCreateFlags2CreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO:
        {
            unmarshal_VkBufferUsageFlags2CreateInfo(vkStream, rootType, reinterpret_cast<VkBufferUsageFlags2CreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES:
        {
            unmarshal_VkPhysicalDevicePushDescriptorProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDevicePushDescriptorProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
        {
            unmarshal_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceDynamicRenderingLocalReadFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO:
        {
            unmarshal_VkRenderingAttachmentLocationInfo(vkStream, rootType, reinterpret_cast<VkRenderingAttachmentLocationInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO:
        {
            unmarshal_VkRenderingInputAttachmentIndexInfo(vkStream, rootType, reinterpret_cast<VkRenderingInputAttachmentIndexInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
        {
            unmarshal_VkPhysicalDeviceMaintenance6Features(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceMaintenance6Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceMaintenance6Properties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceMaintenance6Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS:
        {
            unmarshal_VkBindMemoryStatus(vkStream, rootType, reinterpret_cast<VkBindMemoryStatus*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
        {
            unmarshal_VkPhysicalDevicePipelineProtectedAccessFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDevicePipelineProtectedAccessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
        {
            unmarshal_VkPhysicalDevicePipelineRobustnessFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDevicePipelineRobustnessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES:
        {
            unmarshal_VkPhysicalDevicePipelineRobustnessProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDevicePipelineRobustnessProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO:
        {
            unmarshal_VkPipelineRobustnessCreateInfo(vkStream, rootType, reinterpret_cast<VkPipelineRobustnessCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
        {
            unmarshal_VkPhysicalDeviceHostImageCopyFeatures(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceHostImageCopyFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES:
        {
            unmarshal_VkPhysicalDeviceHostImageCopyProperties(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceHostImageCopyProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
        {
            unmarshal_VkSubresourceHostMemcpySize(vkStream, rootType, reinterpret_cast<VkSubresourceHostMemcpySize*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY:
        {
            unmarshal_VkHostImageCopyDevicePerformanceQuery(vkStream, rootType, reinterpret_cast<VkHostImageCopyDevicePerformanceQuery*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR:
        {
            unmarshal_VkPresentRegionsKHR(vkStream, rootType, reinterpret_cast<VkPresentRegionsKHR*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR:
        {
            unmarshal_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(vkStream, rootType, reinterpret_cast<VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID:
        {
            unmarshal_VkNativeBufferANDROID(vkStream, rootType, reinterpret_cast<VkNativeBufferANDROID*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_IMAGE_CREATE_INFO_ANDROID:
        {
            unmarshal_VkSwapchainImageCreateInfoANDROID(vkStream, rootType, reinterpret_cast<VkSwapchainImageCreateInfoANDROID*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENTATION_PROPERTIES_ANDROID:
        {
            unmarshal_VkPhysicalDevicePresentationPropertiesANDROID(vkStream, rootType, reinterpret_cast<VkPhysicalDevicePresentationPropertiesANDROID*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceTransformFeedbackFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceTransformFeedbackFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        {
            unmarshal_VkPhysicalDeviceTransformFeedbackPropertiesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceTransformFeedbackPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
        {
            unmarshal_VkPipelineRasterizationStateStreamCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkPipelineRasterizationStateStreamCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_depth_clip_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceDepthClipEnableFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceDepthClipEnableFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT:
        {
            unmarshal_VkPipelineRasterizationDepthClipStateCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkPipelineRasterizationDepthClipStateCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_drm_format_modifier
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
        {
            unmarshal_VkDrmFormatModifierPropertiesListEXT(vkStream, rootType, reinterpret_cast<VkDrmFormatModifierPropertiesListEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
        {
            unmarshal_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceImageDrmFormatModifierInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
        {
            unmarshal_VkImageDrmFormatModifierListCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkImageDrmFormatModifierListCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
        {
            unmarshal_VkImageDrmFormatModifierExplicitCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkImageDrmFormatModifierExplicitCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
        {
            unmarshal_VkDrmFormatModifierPropertiesList2EXT(vkStream, rootType, reinterpret_cast<VkDrmFormatModifierPropertiesList2EXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_vertex_attribute_divisor
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
        {
            unmarshal_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_fragment_density_map
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
                {
                    unmarshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension_out));
                    break;
                }
                case VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO:
                {
                    unmarshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension_out));
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    unmarshal_VkImportColorBufferGOOGLE(vkStream, rootType, reinterpret_cast<VkImportColorBufferGOOGLE*>(structExtension_out));
                    break;
                }
                default:
                {
                    unmarshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension_out));
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2:
                {
                    unmarshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension_out));
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    unmarshal_VkCreateBlobGOOGLE(vkStream, rootType, reinterpret_cast<VkCreateBlobGOOGLE*>(structExtension_out));
                    break;
                }
                default:
                {
                    unmarshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension_out));
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT:
        {
            switch(rootType)
            {
                case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO:
                {
                    unmarshal_VkRenderPassFragmentDensityMapCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension_out));
                    break;
                }
                case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2:
                {
                    unmarshal_VkRenderPassFragmentDensityMapCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension_out));
                    break;
                }
                case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
                {
                    unmarshal_VkImportBufferGOOGLE(vkStream, rootType, reinterpret_cast<VkImportBufferGOOGLE*>(structExtension_out));
                    break;
                }
                default:
                {
                    unmarshal_VkRenderPassFragmentDensityMapCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension_out));
                    break;
                }
            }
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT:
        {
            unmarshal_VkRenderingFragmentDensityMapAttachmentInfoEXT(vkStream, rootType, reinterpret_cast<VkRenderingFragmentDensityMapAttachmentInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_memory_budget
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
        {
            unmarshal_VkPhysicalDeviceMemoryBudgetPropertiesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceMemoryBudgetPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceProvokingVertexFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceProvokingVertexFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
        {
            unmarshal_VkPhysicalDeviceProvokingVertexPropertiesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceProvokingVertexPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT:
        {
            unmarshal_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT:
        {
            unmarshal_VkDeviceDeviceMemoryReportCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkDeviceDeviceMemoryReportCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT:
        {
            unmarshal_VkSamplerCustomBorderColorCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkSamplerCustomBorderColorCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
        {
            unmarshal_VkPhysicalDeviceCustomBorderColorPropertiesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceCustomBorderColorPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceCustomBorderColorFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceCustomBorderColorFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_graphics_pipeline_library
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
        {
            unmarshal_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
        {
            unmarshal_VkGraphicsPipelineLibraryCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkGraphicsPipelineLibraryCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceImageCompressionControlFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceImageCompressionControlFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT:
        {
            unmarshal_VkImageCompressionControlEXT(vkStream, rootType, reinterpret_cast<VkImageCompressionControlEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT:
        {
            unmarshal_VkImageCompressionPropertiesEXT(vkStream, rootType, reinterpret_cast<VkImageCompressionPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDevice4444FormatsFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDevice4444FormatsFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_color_write_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceColorWriteEnableFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceColorWriteEnableFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT:
        {
            unmarshal_VkPipelineColorWriteCreateInfoEXT(vkStream, rootType, reinterpret_cast<VkPipelineColorWriteCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE:
        {
            unmarshal_VkImportColorBufferGOOGLE(vkStream, rootType, reinterpret_cast<VkImportColorBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE:
        {
            unmarshal_VkImportBufferGOOGLE(vkStream, rootType, reinterpret_cast<VkImportBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE:
        {
            unmarshal_VkCreateBlobGOOGLE(vkStream, rootType, reinterpret_cast<VkCreateBlobGOOGLE*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT:
        {
            unmarshal_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(vkStream, rootType, reinterpret_cast<VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
        default:
        {
            // fatal; the switch is only taken if the extension struct is known
            abort();
        }
    }
}

const char* api_opcode_to_string(
    const uint32_t opcode)
{
    switch(opcode)
    {
#ifdef VK_VERSION_1_0
        case OP_vkCreateInstance:
        {
            return "OP_vkCreateInstance";
        }
        case OP_vkDestroyInstance:
        {
            return "OP_vkDestroyInstance";
        }
        case OP_vkEnumeratePhysicalDevices:
        {
            return "OP_vkEnumeratePhysicalDevices";
        }
        case OP_vkGetPhysicalDeviceFeatures:
        {
            return "OP_vkGetPhysicalDeviceFeatures";
        }
        case OP_vkGetPhysicalDeviceFormatProperties:
        {
            return "OP_vkGetPhysicalDeviceFormatProperties";
        }
        case OP_vkGetPhysicalDeviceImageFormatProperties:
        {
            return "OP_vkGetPhysicalDeviceImageFormatProperties";
        }
        case OP_vkGetPhysicalDeviceProperties:
        {
            return "OP_vkGetPhysicalDeviceProperties";
        }
        case OP_vkGetPhysicalDeviceQueueFamilyProperties:
        {
            return "OP_vkGetPhysicalDeviceQueueFamilyProperties";
        }
        case OP_vkGetPhysicalDeviceMemoryProperties:
        {
            return "OP_vkGetPhysicalDeviceMemoryProperties";
        }
        case OP_vkGetInstanceProcAddr:
        {
            return "OP_vkGetInstanceProcAddr";
        }
        case OP_vkGetDeviceProcAddr:
        {
            return "OP_vkGetDeviceProcAddr";
        }
        case OP_vkCreateDevice:
        {
            return "OP_vkCreateDevice";
        }
        case OP_vkDestroyDevice:
        {
            return "OP_vkDestroyDevice";
        }
        case OP_vkEnumerateInstanceExtensionProperties:
        {
            return "OP_vkEnumerateInstanceExtensionProperties";
        }
        case OP_vkEnumerateDeviceExtensionProperties:
        {
            return "OP_vkEnumerateDeviceExtensionProperties";
        }
        case OP_vkEnumerateInstanceLayerProperties:
        {
            return "OP_vkEnumerateInstanceLayerProperties";
        }
        case OP_vkEnumerateDeviceLayerProperties:
        {
            return "OP_vkEnumerateDeviceLayerProperties";
        }
        case OP_vkGetDeviceQueue:
        {
            return "OP_vkGetDeviceQueue";
        }
        case OP_vkQueueSubmit:
        {
            return "OP_vkQueueSubmit";
        }
        case OP_vkQueueWaitIdle:
        {
            return "OP_vkQueueWaitIdle";
        }
        case OP_vkDeviceWaitIdle:
        {
            return "OP_vkDeviceWaitIdle";
        }
        case OP_vkAllocateMemory:
        {
            return "OP_vkAllocateMemory";
        }
        case OP_vkFreeMemory:
        {
            return "OP_vkFreeMemory";
        }
        case OP_vkMapMemory:
        {
            return "OP_vkMapMemory";
        }
        case OP_vkUnmapMemory:
        {
            return "OP_vkUnmapMemory";
        }
        case OP_vkFlushMappedMemoryRanges:
        {
            return "OP_vkFlushMappedMemoryRanges";
        }
        case OP_vkInvalidateMappedMemoryRanges:
        {
            return "OP_vkInvalidateMappedMemoryRanges";
        }
        case OP_vkGetDeviceMemoryCommitment:
        {
            return "OP_vkGetDeviceMemoryCommitment";
        }
        case OP_vkBindBufferMemory:
        {
            return "OP_vkBindBufferMemory";
        }
        case OP_vkBindImageMemory:
        {
            return "OP_vkBindImageMemory";
        }
        case OP_vkGetBufferMemoryRequirements:
        {
            return "OP_vkGetBufferMemoryRequirements";
        }
        case OP_vkGetImageMemoryRequirements:
        {
            return "OP_vkGetImageMemoryRequirements";
        }
        case OP_vkGetImageSparseMemoryRequirements:
        {
            return "OP_vkGetImageSparseMemoryRequirements";
        }
        case OP_vkGetPhysicalDeviceSparseImageFormatProperties:
        {
            return "OP_vkGetPhysicalDeviceSparseImageFormatProperties";
        }
        case OP_vkQueueBindSparse:
        {
            return "OP_vkQueueBindSparse";
        }
        case OP_vkCreateFence:
        {
            return "OP_vkCreateFence";
        }
        case OP_vkDestroyFence:
        {
            return "OP_vkDestroyFence";
        }
        case OP_vkResetFences:
        {
            return "OP_vkResetFences";
        }
        case OP_vkGetFenceStatus:
        {
            return "OP_vkGetFenceStatus";
        }
        case OP_vkWaitForFences:
        {
            return "OP_vkWaitForFences";
        }
        case OP_vkCreateSemaphore:
        {
            return "OP_vkCreateSemaphore";
        }
        case OP_vkDestroySemaphore:
        {
            return "OP_vkDestroySemaphore";
        }
        case OP_vkCreateEvent:
        {
            return "OP_vkCreateEvent";
        }
        case OP_vkDestroyEvent:
        {
            return "OP_vkDestroyEvent";
        }
        case OP_vkGetEventStatus:
        {
            return "OP_vkGetEventStatus";
        }
        case OP_vkSetEvent:
        {
            return "OP_vkSetEvent";
        }
        case OP_vkResetEvent:
        {
            return "OP_vkResetEvent";
        }
        case OP_vkCreateQueryPool:
        {
            return "OP_vkCreateQueryPool";
        }
        case OP_vkDestroyQueryPool:
        {
            return "OP_vkDestroyQueryPool";
        }
        case OP_vkGetQueryPoolResults:
        {
            return "OP_vkGetQueryPoolResults";
        }
        case OP_vkCreateBuffer:
        {
            return "OP_vkCreateBuffer";
        }
        case OP_vkDestroyBuffer:
        {
            return "OP_vkDestroyBuffer";
        }
        case OP_vkCreateBufferView:
        {
            return "OP_vkCreateBufferView";
        }
        case OP_vkDestroyBufferView:
        {
            return "OP_vkDestroyBufferView";
        }
        case OP_vkCreateImage:
        {
            return "OP_vkCreateImage";
        }
        case OP_vkDestroyImage:
        {
            return "OP_vkDestroyImage";
        }
        case OP_vkGetImageSubresourceLayout:
        {
            return "OP_vkGetImageSubresourceLayout";
        }
        case OP_vkCreateImageView:
        {
            return "OP_vkCreateImageView";
        }
        case OP_vkDestroyImageView:
        {
            return "OP_vkDestroyImageView";
        }
        case OP_vkCreateShaderModule:
        {
            return "OP_vkCreateShaderModule";
        }
        case OP_vkDestroyShaderModule:
        {
            return "OP_vkDestroyShaderModule";
        }
        case OP_vkCreatePipelineCache:
        {
            return "OP_vkCreatePipelineCache";
        }
        case OP_vkDestroyPipelineCache:
        {
            return "OP_vkDestroyPipelineCache";
        }
        case OP_vkGetPipelineCacheData:
        {
            return "OP_vkGetPipelineCacheData";
        }
        case OP_vkMergePipelineCaches:
        {
            return "OP_vkMergePipelineCaches";
        }
        case OP_vkCreateGraphicsPipelines:
        {
            return "OP_vkCreateGraphicsPipelines";
        }
        case OP_vkCreateComputePipelines:
        {
            return "OP_vkCreateComputePipelines";
        }
        case OP_vkDestroyPipeline:
        {
            return "OP_vkDestroyPipeline";
        }
        case OP_vkCreatePipelineLayout:
        {
            return "OP_vkCreatePipelineLayout";
        }
        case OP_vkDestroyPipelineLayout:
        {
            return "OP_vkDestroyPipelineLayout";
        }
        case OP_vkCreateSampler:
        {
            return "OP_vkCreateSampler";
        }
        case OP_vkDestroySampler:
        {
            return "OP_vkDestroySampler";
        }
        case OP_vkCreateDescriptorSetLayout:
        {
            return "OP_vkCreateDescriptorSetLayout";
        }
        case OP_vkDestroyDescriptorSetLayout:
        {
            return "OP_vkDestroyDescriptorSetLayout";
        }
        case OP_vkCreateDescriptorPool:
        {
            return "OP_vkCreateDescriptorPool";
        }
        case OP_vkDestroyDescriptorPool:
        {
            return "OP_vkDestroyDescriptorPool";
        }
        case OP_vkResetDescriptorPool:
        {
            return "OP_vkResetDescriptorPool";
        }
        case OP_vkAllocateDescriptorSets:
        {
            return "OP_vkAllocateDescriptorSets";
        }
        case OP_vkFreeDescriptorSets:
        {
            return "OP_vkFreeDescriptorSets";
        }
        case OP_vkUpdateDescriptorSets:
        {
            return "OP_vkUpdateDescriptorSets";
        }
        case OP_vkCreateFramebuffer:
        {
            return "OP_vkCreateFramebuffer";
        }
        case OP_vkDestroyFramebuffer:
        {
            return "OP_vkDestroyFramebuffer";
        }
        case OP_vkCreateRenderPass:
        {
            return "OP_vkCreateRenderPass";
        }
        case OP_vkDestroyRenderPass:
        {
            return "OP_vkDestroyRenderPass";
        }
        case OP_vkGetRenderAreaGranularity:
        {
            return "OP_vkGetRenderAreaGranularity";
        }
        case OP_vkCreateCommandPool:
        {
            return "OP_vkCreateCommandPool";
        }
        case OP_vkDestroyCommandPool:
        {
            return "OP_vkDestroyCommandPool";
        }
        case OP_vkResetCommandPool:
        {
            return "OP_vkResetCommandPool";
        }
        case OP_vkAllocateCommandBuffers:
        {
            return "OP_vkAllocateCommandBuffers";
        }
        case OP_vkFreeCommandBuffers:
        {
            return "OP_vkFreeCommandBuffers";
        }
        case OP_vkBeginCommandBuffer:
        {
            return "OP_vkBeginCommandBuffer";
        }
        case OP_vkEndCommandBuffer:
        {
            return "OP_vkEndCommandBuffer";
        }
        case OP_vkResetCommandBuffer:
        {
            return "OP_vkResetCommandBuffer";
        }
        case OP_vkCmdBindPipeline:
        {
            return "OP_vkCmdBindPipeline";
        }
        case OP_vkCmdSetViewport:
        {
            return "OP_vkCmdSetViewport";
        }
        case OP_vkCmdSetScissor:
        {
            return "OP_vkCmdSetScissor";
        }
        case OP_vkCmdSetLineWidth:
        {
            return "OP_vkCmdSetLineWidth";
        }
        case OP_vkCmdSetDepthBias:
        {
            return "OP_vkCmdSetDepthBias";
        }
        case OP_vkCmdSetBlendConstants:
        {
            return "OP_vkCmdSetBlendConstants";
        }
        case OP_vkCmdSetDepthBounds:
        {
            return "OP_vkCmdSetDepthBounds";
        }
        case OP_vkCmdSetStencilCompareMask:
        {
            return "OP_vkCmdSetStencilCompareMask";
        }
        case OP_vkCmdSetStencilWriteMask:
        {
            return "OP_vkCmdSetStencilWriteMask";
        }
        case OP_vkCmdSetStencilReference:
        {
            return "OP_vkCmdSetStencilReference";
        }
        case OP_vkCmdBindDescriptorSets:
        {
            return "OP_vkCmdBindDescriptorSets";
        }
        case OP_vkCmdBindIndexBuffer:
        {
            return "OP_vkCmdBindIndexBuffer";
        }
        case OP_vkCmdBindVertexBuffers:
        {
            return "OP_vkCmdBindVertexBuffers";
        }
        case OP_vkCmdDraw:
        {
            return "OP_vkCmdDraw";
        }
        case OP_vkCmdDrawIndexed:
        {
            return "OP_vkCmdDrawIndexed";
        }
        case OP_vkCmdDrawIndirect:
        {
            return "OP_vkCmdDrawIndirect";
        }
        case OP_vkCmdDrawIndexedIndirect:
        {
            return "OP_vkCmdDrawIndexedIndirect";
        }
        case OP_vkCmdDispatch:
        {
            return "OP_vkCmdDispatch";
        }
        case OP_vkCmdDispatchIndirect:
        {
            return "OP_vkCmdDispatchIndirect";
        }
        case OP_vkCmdCopyBuffer:
        {
            return "OP_vkCmdCopyBuffer";
        }
        case OP_vkCmdCopyImage:
        {
            return "OP_vkCmdCopyImage";
        }
        case OP_vkCmdBlitImage:
        {
            return "OP_vkCmdBlitImage";
        }
        case OP_vkCmdCopyBufferToImage:
        {
            return "OP_vkCmdCopyBufferToImage";
        }
        case OP_vkCmdCopyImageToBuffer:
        {
            return "OP_vkCmdCopyImageToBuffer";
        }
        case OP_vkCmdUpdateBuffer:
        {
            return "OP_vkCmdUpdateBuffer";
        }
        case OP_vkCmdFillBuffer:
        {
            return "OP_vkCmdFillBuffer";
        }
        case OP_vkCmdClearColorImage:
        {
            return "OP_vkCmdClearColorImage";
        }
        case OP_vkCmdClearDepthStencilImage:
        {
            return "OP_vkCmdClearDepthStencilImage";
        }
        case OP_vkCmdClearAttachments:
        {
            return "OP_vkCmdClearAttachments";
        }
        case OP_vkCmdResolveImage:
        {
            return "OP_vkCmdResolveImage";
        }
        case OP_vkCmdSetEvent:
        {
            return "OP_vkCmdSetEvent";
        }
        case OP_vkCmdResetEvent:
        {
            return "OP_vkCmdResetEvent";
        }
        case OP_vkCmdWaitEvents:
        {
            return "OP_vkCmdWaitEvents";
        }
        case OP_vkCmdPipelineBarrier:
        {
            return "OP_vkCmdPipelineBarrier";
        }
        case OP_vkCmdBeginQuery:
        {
            return "OP_vkCmdBeginQuery";
        }
        case OP_vkCmdEndQuery:
        {
            return "OP_vkCmdEndQuery";
        }
        case OP_vkCmdResetQueryPool:
        {
            return "OP_vkCmdResetQueryPool";
        }
        case OP_vkCmdWriteTimestamp:
        {
            return "OP_vkCmdWriteTimestamp";
        }
        case OP_vkCmdCopyQueryPoolResults:
        {
            return "OP_vkCmdCopyQueryPoolResults";
        }
        case OP_vkCmdPushConstants:
        {
            return "OP_vkCmdPushConstants";
        }
        case OP_vkCmdBeginRenderPass:
        {
            return "OP_vkCmdBeginRenderPass";
        }
        case OP_vkCmdNextSubpass:
        {
            return "OP_vkCmdNextSubpass";
        }
        case OP_vkCmdEndRenderPass:
        {
            return "OP_vkCmdEndRenderPass";
        }
        case OP_vkCmdExecuteCommands:
        {
            return "OP_vkCmdExecuteCommands";
        }
#endif
#ifdef VK_VERSION_1_1
        case OP_vkEnumerateInstanceVersion:
        {
            return "OP_vkEnumerateInstanceVersion";
        }
        case OP_vkBindBufferMemory2:
        {
            return "OP_vkBindBufferMemory2";
        }
        case OP_vkBindImageMemory2:
        {
            return "OP_vkBindImageMemory2";
        }
        case OP_vkGetDeviceGroupPeerMemoryFeatures:
        {
            return "OP_vkGetDeviceGroupPeerMemoryFeatures";
        }
        case OP_vkCmdSetDeviceMask:
        {
            return "OP_vkCmdSetDeviceMask";
        }
        case OP_vkCmdDispatchBase:
        {
            return "OP_vkCmdDispatchBase";
        }
        case OP_vkEnumeratePhysicalDeviceGroups:
        {
            return "OP_vkEnumeratePhysicalDeviceGroups";
        }
        case OP_vkGetImageMemoryRequirements2:
        {
            return "OP_vkGetImageMemoryRequirements2";
        }
        case OP_vkGetBufferMemoryRequirements2:
        {
            return "OP_vkGetBufferMemoryRequirements2";
        }
        case OP_vkGetImageSparseMemoryRequirements2:
        {
            return "OP_vkGetImageSparseMemoryRequirements2";
        }
        case OP_vkGetPhysicalDeviceFeatures2:
        {
            return "OP_vkGetPhysicalDeviceFeatures2";
        }
        case OP_vkGetPhysicalDeviceProperties2:
        {
            return "OP_vkGetPhysicalDeviceProperties2";
        }
        case OP_vkGetPhysicalDeviceFormatProperties2:
        {
            return "OP_vkGetPhysicalDeviceFormatProperties2";
        }
        case OP_vkGetPhysicalDeviceImageFormatProperties2:
        {
            return "OP_vkGetPhysicalDeviceImageFormatProperties2";
        }
        case OP_vkGetPhysicalDeviceQueueFamilyProperties2:
        {
            return "OP_vkGetPhysicalDeviceQueueFamilyProperties2";
        }
        case OP_vkGetPhysicalDeviceMemoryProperties2:
        {
            return "OP_vkGetPhysicalDeviceMemoryProperties2";
        }
        case OP_vkGetPhysicalDeviceSparseImageFormatProperties2:
        {
            return "OP_vkGetPhysicalDeviceSparseImageFormatProperties2";
        }
        case OP_vkTrimCommandPool:
        {
            return "OP_vkTrimCommandPool";
        }
        case OP_vkGetDeviceQueue2:
        {
            return "OP_vkGetDeviceQueue2";
        }
        case OP_vkCreateSamplerYcbcrConversion:
        {
            return "OP_vkCreateSamplerYcbcrConversion";
        }
        case OP_vkDestroySamplerYcbcrConversion:
        {
            return "OP_vkDestroySamplerYcbcrConversion";
        }
        case OP_vkCreateDescriptorUpdateTemplate:
        {
            return "OP_vkCreateDescriptorUpdateTemplate";
        }
        case OP_vkDestroyDescriptorUpdateTemplate:
        {
            return "OP_vkDestroyDescriptorUpdateTemplate";
        }
        case OP_vkUpdateDescriptorSetWithTemplate:
        {
            return "OP_vkUpdateDescriptorSetWithTemplate";
        }
        case OP_vkGetPhysicalDeviceExternalBufferProperties:
        {
            return "OP_vkGetPhysicalDeviceExternalBufferProperties";
        }
        case OP_vkGetPhysicalDeviceExternalFenceProperties:
        {
            return "OP_vkGetPhysicalDeviceExternalFenceProperties";
        }
        case OP_vkGetPhysicalDeviceExternalSemaphoreProperties:
        {
            return "OP_vkGetPhysicalDeviceExternalSemaphoreProperties";
        }
        case OP_vkGetDescriptorSetLayoutSupport:
        {
            return "OP_vkGetDescriptorSetLayoutSupport";
        }
#endif
#ifdef VK_KHR_get_physical_device_properties2
        case OP_vkGetPhysicalDeviceFeatures2KHR:
        {
            return "OP_vkGetPhysicalDeviceFeatures2KHR";
        }
        case OP_vkGetPhysicalDeviceProperties2KHR:
        {
            return "OP_vkGetPhysicalDeviceProperties2KHR";
        }
        case OP_vkGetPhysicalDeviceFormatProperties2KHR:
        {
            return "OP_vkGetPhysicalDeviceFormatProperties2KHR";
        }
        case OP_vkGetPhysicalDeviceImageFormatProperties2KHR:
        {
            return "OP_vkGetPhysicalDeviceImageFormatProperties2KHR";
        }
        case OP_vkGetPhysicalDeviceQueueFamilyProperties2KHR:
        {
            return "OP_vkGetPhysicalDeviceQueueFamilyProperties2KHR";
        }
        case OP_vkGetPhysicalDeviceMemoryProperties2KHR:
        {
            return "OP_vkGetPhysicalDeviceMemoryProperties2KHR";
        }
        case OP_vkGetPhysicalDeviceSparseImageFormatProperties2KHR:
        {
            return "OP_vkGetPhysicalDeviceSparseImageFormatProperties2KHR";
        }
#endif
#ifdef VK_KHR_maintenance1
        case OP_vkTrimCommandPoolKHR:
        {
            return "OP_vkTrimCommandPoolKHR";
        }
#endif
#ifdef VK_KHR_external_memory_capabilities
        case OP_vkGetPhysicalDeviceExternalBufferPropertiesKHR:
        {
            return "OP_vkGetPhysicalDeviceExternalBufferPropertiesKHR";
        }
#endif
#ifdef VK_KHR_external_semaphore_capabilities
        case OP_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR:
        {
            return "OP_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR";
        }
#endif
#ifdef VK_KHR_external_semaphore_fd
        case OP_vkImportSemaphoreFdKHR:
        {
            return "OP_vkImportSemaphoreFdKHR";
        }
        case OP_vkGetSemaphoreFdKHR:
        {
            return "OP_vkGetSemaphoreFdKHR";
        }
#endif
#ifdef VK_KHR_descriptor_update_template
        case OP_vkCreateDescriptorUpdateTemplateKHR:
        {
            return "OP_vkCreateDescriptorUpdateTemplateKHR";
        }
        case OP_vkDestroyDescriptorUpdateTemplateKHR:
        {
            return "OP_vkDestroyDescriptorUpdateTemplateKHR";
        }
        case OP_vkUpdateDescriptorSetWithTemplateKHR:
        {
            return "OP_vkUpdateDescriptorSetWithTemplateKHR";
        }
#endif
#ifdef VK_KHR_create_renderpass2
        case OP_vkCreateRenderPass2KHR:
        {
            return "OP_vkCreateRenderPass2KHR";
        }
        case OP_vkCmdBeginRenderPass2KHR:
        {
            return "OP_vkCmdBeginRenderPass2KHR";
        }
        case OP_vkCmdNextSubpass2KHR:
        {
            return "OP_vkCmdNextSubpass2KHR";
        }
        case OP_vkCmdEndRenderPass2KHR:
        {
            return "OP_vkCmdEndRenderPass2KHR";
        }
#endif
#ifdef VK_KHR_external_fence_capabilities
        case OP_vkGetPhysicalDeviceExternalFencePropertiesKHR:
        {
            return "OP_vkGetPhysicalDeviceExternalFencePropertiesKHR";
        }
#endif
#ifdef VK_KHR_external_fence_fd
        case OP_vkImportFenceFdKHR:
        {
            return "OP_vkImportFenceFdKHR";
        }
        case OP_vkGetFenceFdKHR:
        {
            return "OP_vkGetFenceFdKHR";
        }
#endif
#ifdef VK_KHR_get_memory_requirements2
        case OP_vkGetImageMemoryRequirements2KHR:
        {
            return "OP_vkGetImageMemoryRequirements2KHR";
        }
        case OP_vkGetBufferMemoryRequirements2KHR:
        {
            return "OP_vkGetBufferMemoryRequirements2KHR";
        }
        case OP_vkGetImageSparseMemoryRequirements2KHR:
        {
            return "OP_vkGetImageSparseMemoryRequirements2KHR";
        }
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
        case OP_vkCreateSamplerYcbcrConversionKHR:
        {
            return "OP_vkCreateSamplerYcbcrConversionKHR";
        }
        case OP_vkDestroySamplerYcbcrConversionKHR:
        {
            return "OP_vkDestroySamplerYcbcrConversionKHR";
        }
#endif
#ifdef VK_KHR_bind_memory2
        case OP_vkBindBufferMemory2KHR:
        {
            return "OP_vkBindBufferMemory2KHR";
        }
        case OP_vkBindImageMemory2KHR:
        {
            return "OP_vkBindImageMemory2KHR";
        }
#endif
#ifdef VK_KHR_maintenance3
        case OP_vkGetDescriptorSetLayoutSupportKHR:
        {
            return "OP_vkGetDescriptorSetLayoutSupportKHR";
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case OP_vkGetSwapchainGrallocUsageANDROID:
        {
            return "OP_vkGetSwapchainGrallocUsageANDROID";
        }
        case OP_vkAcquireImageANDROID:
        {
            return "OP_vkAcquireImageANDROID";
        }
        case OP_vkQueueSignalReleaseImageANDROID:
        {
            return "OP_vkQueueSignalReleaseImageANDROID";
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case OP_vkMapMemoryIntoAddressSpaceGOOGLE:
        {
            return "OP_vkMapMemoryIntoAddressSpaceGOOGLE";
        }
        case OP_vkUpdateDescriptorSetWithTemplateSizedGOOGLE:
        {
            return "OP_vkUpdateDescriptorSetWithTemplateSizedGOOGLE";
        }
        case OP_vkBeginCommandBufferAsyncGOOGLE:
        {
            return "OP_vkBeginCommandBufferAsyncGOOGLE";
        }
        case OP_vkEndCommandBufferAsyncGOOGLE:
        {
            return "OP_vkEndCommandBufferAsyncGOOGLE";
        }
        case OP_vkResetCommandBufferAsyncGOOGLE:
        {
            return "OP_vkResetCommandBufferAsyncGOOGLE";
        }
        case OP_vkCommandBufferHostSyncGOOGLE:
        {
            return "OP_vkCommandBufferHostSyncGOOGLE";
        }
        case OP_vkCreateImageWithRequirementsGOOGLE:
        {
            return "OP_vkCreateImageWithRequirementsGOOGLE";
        }
        case OP_vkCreateBufferWithRequirementsGOOGLE:
        {
            return "OP_vkCreateBufferWithRequirementsGOOGLE";
        }
        case OP_vkGetMemoryHostAddressInfoGOOGLE:
        {
            return "OP_vkGetMemoryHostAddressInfoGOOGLE";
        }
        case OP_vkFreeMemorySyncGOOGLE:
        {
            return "OP_vkFreeMemorySyncGOOGLE";
        }
        case OP_vkQueueHostSyncGOOGLE:
        {
            return "OP_vkQueueHostSyncGOOGLE";
        }
        case OP_vkQueueSubmitAsyncGOOGLE:
        {
            return "OP_vkQueueSubmitAsyncGOOGLE";
        }
        case OP_vkQueueWaitIdleAsyncGOOGLE:
        {
            return "OP_vkQueueWaitIdleAsyncGOOGLE";
        }
        case OP_vkQueueBindSparseAsyncGOOGLE:
        {
            return "OP_vkQueueBindSparseAsyncGOOGLE";
        }
        case OP_vkGetLinearImageLayoutGOOGLE:
        {
            return "OP_vkGetLinearImageLayoutGOOGLE";
        }
        case OP_vkQueueFlushCommandsGOOGLE:
        {
            return "OP_vkQueueFlushCommandsGOOGLE";
        }
        case OP_vkGetBlobGOOGLE:
        {
            return "OP_vkGetBlobGOOGLE";
        }
        case OP_vkGetSemaphoreGOOGLE:
        {
            return "OP_vkGetSemaphoreGOOGLE";
        }
#endif
#ifdef VK_KHR_dynamic_rendering
        case OP_vkCmdEndRenderingKHR:
        {
            return "OP_vkCmdEndRenderingKHR";
        }
#endif
#ifdef VK_KHR_synchronization2
        case OP_vkCmdPipelineBarrier2KHR:
        {
            return "OP_vkCmdPipelineBarrier2KHR";
        }
#endif
#ifdef VK_KHR_maintenance4
        case OP_vkGetDeviceBufferMemoryRequirementsKHR:
        {
            return "OP_vkGetDeviceBufferMemoryRequirementsKHR";
        }
#endif
#ifdef VK_EXT_color_write_enable
        case OP_vkCmdSetColorWriteEnableEXT:
        {
            return "OP_vkCmdSetColorWriteEnableEXT";
        }
#endif
#ifdef VK_KHR_maintenance5
        case OP_vkCmdBindIndexBuffer2KHR:
        {
            return "OP_vkCmdBindIndexBuffer2KHR";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdSetScissorWithCountEXT:
        {
            return "OP_vkCmdSetScissorWithCountEXT";
        }
#endif
#ifdef VK_EXT_host_image_copy
        case OP_vkCopyImageToMemoryEXT:
        {
            return "OP_vkCopyImageToMemoryEXT";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkCmdSetRenderingAttachmentLocations:
        {
            return "OP_vkCmdSetRenderingAttachmentLocations";
        }
        case OP_vkCopyImageToMemory:
        {
            return "OP_vkCopyImageToMemory";
        }
        case OP_vkCmdBindIndexBuffer2:
        {
            return "OP_vkCmdBindIndexBuffer2";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case OP_vkCmdSetPatchControlPointsEXT:
        {
            return "OP_vkCmdSetPatchControlPointsEXT";
        }
#endif
#ifdef VK_EXT_private_data
        case OP_vkDestroyPrivateDataSlotEXT:
        {
            return "OP_vkDestroyPrivateDataSlotEXT";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetDepthTestEnable:
        {
            return "OP_vkCmdSetDepthTestEnable";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdSetFrontFaceEXT:
        {
            return "OP_vkCmdSetFrontFaceEXT";
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case OP_vkCollectDescriptorPoolIdsGOOGLE:
        {
            return "OP_vkCollectDescriptorPoolIdsGOOGLE";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkGetRenderingAreaGranularity:
        {
            return "OP_vkGetRenderingAreaGranularity";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdCopyImageToBuffer2:
        {
            return "OP_vkCmdCopyImageToBuffer2";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkGetDeviceImageSubresourceLayout:
        {
            return "OP_vkGetDeviceImageSubresourceLayout";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdSetDepthWriteEnableEXT:
        {
            return "OP_vkCmdSetDepthWriteEnableEXT";
        }
#endif
#ifdef VK_EXT_host_image_copy
        case OP_vkCopyMemoryToImageEXT:
        {
            return "OP_vkCopyMemoryToImageEXT";
        }
#endif
#ifdef VK_KHR_buffer_device_address
        case OP_vkGetBufferDeviceAddressKHR:
        {
            return "OP_vkGetBufferDeviceAddressKHR";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetDepthBoundsTestEnable:
        {
            return "OP_vkCmdSetDepthBoundsTestEnable";
        }
#endif
#ifdef VK_KHR_line_rasterization
        case OP_vkCmdSetLineStippleKHR:
        {
            return "OP_vkCmdSetLineStippleKHR";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetScissorWithCount:
        {
            return "OP_vkCmdSetScissorWithCount";
        }
        case OP_vkCmdEndRendering:
        {
            return "OP_vkCmdEndRendering";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkCmdEndRenderPass2:
        {
            return "OP_vkCmdEndRenderPass2";
        }
        case OP_vkGetBufferDeviceAddress:
        {
            return "OP_vkGetBufferDeviceAddress";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetFrontFace:
        {
            return "OP_vkCmdSetFrontFace";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdSetDepthBoundsTestEnableEXT:
        {
            return "OP_vkCmdSetDepthBoundsTestEnableEXT";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkCopyImageToImage:
        {
            return "OP_vkCopyImageToImage";
        }
#endif
#ifdef VK_EXT_host_image_copy
        case OP_vkCopyImageToImageEXT:
        {
            return "OP_vkCopyImageToImageEXT";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkDestroyPrivateDataSlot:
        {
            return "OP_vkDestroyPrivateDataSlot";
        }
        case OP_vkCmdSetCullMode:
        {
            return "OP_vkCmdSetCullMode";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkWaitSemaphores:
        {
            return "OP_vkWaitSemaphores";
        }
#endif
#ifdef VK_EXT_private_data
        case OP_vkSetPrivateDataEXT:
        {
            return "OP_vkSetPrivateDataEXT";
        }
#endif
#ifdef VK_KHR_copy_commands2
        case OP_vkCmdCopyImage2KHR:
        {
            return "OP_vkCmdCopyImage2KHR";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkUnmapMemory2:
        {
            return "OP_vkUnmapMemory2";
        }
        case OP_vkCmdPushDescriptorSetWithTemplate:
        {
            return "OP_vkCmdPushDescriptorSetWithTemplate";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkGetBufferOpaqueCaptureAddress:
        {
            return "OP_vkGetBufferOpaqueCaptureAddress";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetPrimitiveRestartEnable:
        {
            return "OP_vkCmdSetPrimitiveRestartEnable";
        }
        case OP_vkCmdSetEvent2:
        {
            return "OP_vkCmdSetEvent2";
        }
        case OP_vkGetDeviceImageSparseMemoryRequirements:
        {
            return "OP_vkGetDeviceImageSparseMemoryRequirements";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdSetDepthTestEnableEXT:
        {
            return "OP_vkCmdSetDepthTestEnableEXT";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkCmdBeginRenderPass2:
        {
            return "OP_vkCmdBeginRenderPass2";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkCmdSetLineStipple:
        {
            return "OP_vkCmdSetLineStipple";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetStencilOp:
        {
            return "OP_vkCmdSetStencilOp";
        }
#endif
#ifdef VK_EXT_private_data
        case OP_vkCreatePrivateDataSlotEXT:
        {
            return "OP_vkCreatePrivateDataSlotEXT";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdCopyBuffer2:
        {
            return "OP_vkCmdCopyBuffer2";
        }
        case OP_vkGetPrivateData:
        {
            return "OP_vkGetPrivateData";
        }
#endif
#ifdef VK_KHR_maintenance5
        case OP_vkGetRenderingAreaGranularityKHR:
        {
            return "OP_vkGetRenderingAreaGranularityKHR";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetDepthWriteEnable:
        {
            return "OP_vkCmdSetDepthWriteEnable";
        }
        case OP_vkSetPrivateData:
        {
            return "OP_vkSetPrivateData";
        }
#endif
#ifdef VK_EXT_host_image_copy
        case OP_vkTransitionImageLayoutEXT:
        {
            return "OP_vkTransitionImageLayoutEXT";
        }
#endif
#ifdef VK_KHR_maintenance4
        case OP_vkGetDeviceImageMemoryRequirementsKHR:
        {
            return "OP_vkGetDeviceImageMemoryRequirementsKHR";
        }
#endif
#ifdef VK_KHR_maintenance5
        case OP_vkGetImageSubresourceLayout2KHR:
        {
            return "OP_vkGetImageSubresourceLayout2KHR";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdBindVertexBuffers2EXT:
        {
            return "OP_vkCmdBindVertexBuffers2EXT";
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case OP_vkQueueSignalReleaseImageANDROIDAsyncGOOGLE:
        {
            return "OP_vkQueueSignalReleaseImageANDROIDAsyncGOOGLE";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdWaitEvents2:
        {
            return "OP_vkCmdWaitEvents2";
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case OP_vkUpdateDescriptorSetWithTemplateSized2GOOGLE:
        {
            return "OP_vkUpdateDescriptorSetWithTemplateSized2GOOGLE";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkCmdNextSubpass2:
        {
            return "OP_vkCmdNextSubpass2";
        }
#endif
#ifdef VK_KHR_synchronization2
        case OP_vkCmdWaitEvents2KHR:
        {
            return "OP_vkCmdWaitEvents2KHR";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkCmdDrawIndexedIndirectCount:
        {
            return "OP_vkCmdDrawIndexedIndirectCount";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case OP_vkCmdSetRasterizerDiscardEnableEXT:
        {
            return "OP_vkCmdSetRasterizerDiscardEnableEXT";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetDepthCompareOp:
        {
            return "OP_vkCmdSetDepthCompareOp";
        }
        case OP_vkCmdWriteTimestamp2:
        {
            return "OP_vkCmdWriteTimestamp2";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkCmdPushDescriptorSet:
        {
            return "OP_vkCmdPushDescriptorSet";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdCopyImage2:
        {
            return "OP_vkCmdCopyImage2";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdSetDepthCompareOpEXT:
        {
            return "OP_vkCmdSetDepthCompareOpEXT";
        }
#endif
#ifdef VK_KHR_copy_commands2
        case OP_vkCmdCopyBuffer2KHR:
        {
            return "OP_vkCmdCopyBuffer2KHR";
        }
        case OP_vkCmdCopyBufferToImage2KHR:
        {
            return "OP_vkCmdCopyBufferToImage2KHR";
        }
#endif
#ifdef VK_EXT_image_drm_format_modifier
        case OP_vkGetImageDrmFormatModifierPropertiesEXT:
        {
            return "OP_vkGetImageDrmFormatModifierPropertiesEXT";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkResetQueryPool:
        {
            return "OP_vkResetQueryPool";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkTransitionImageLayout:
        {
            return "OP_vkTransitionImageLayout";
        }
#endif
#ifdef VK_KHR_copy_commands2
        case OP_vkCmdCopyImageToBuffer2KHR:
        {
            return "OP_vkCmdCopyImageToBuffer2KHR";
        }
#endif
#ifdef VK_KHR_synchronization2
        case OP_vkCmdWriteTimestamp2KHR:
        {
            return "OP_vkCmdWriteTimestamp2KHR";
        }
#endif
#ifdef VK_KHR_maintenance5
        case OP_vkGetDeviceImageSubresourceLayoutKHR:
        {
            return "OP_vkGetDeviceImageSubresourceLayoutKHR";
        }
#endif
#ifdef VK_KHR_copy_commands2
        case OP_vkCmdResolveImage2KHR:
        {
            return "OP_vkCmdResolveImage2KHR";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdSetViewportWithCountEXT:
        {
            return "OP_vkCmdSetViewportWithCountEXT";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdBindVertexBuffers2:
        {
            return "OP_vkCmdBindVertexBuffers2";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case OP_vkCmdSetDepthBiasEnableEXT:
        {
            return "OP_vkCmdSetDepthBiasEnableEXT";
        }
#endif
#ifdef VK_KHR_copy_commands2
        case OP_vkCmdBlitImage2KHR:
        {
            return "OP_vkCmdBlitImage2KHR";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkGetDeviceMemoryOpaqueCaptureAddress:
        {
            return "OP_vkGetDeviceMemoryOpaqueCaptureAddress";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdSetPrimitiveTopologyEXT:
        {
            return "OP_vkCmdSetPrimitiveTopologyEXT";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCreatePrivateDataSlot:
        {
            return "OP_vkCreatePrivateDataSlot";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkCopyMemoryToImage:
        {
            return "OP_vkCopyMemoryToImage";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetPrimitiveTopology:
        {
            return "OP_vkCmdSetPrimitiveTopology";
        }
#endif
#ifdef VK_EXT_line_rasterization
        case OP_vkCmdSetLineStippleEXT:
        {
            return "OP_vkCmdSetLineStippleEXT";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdSetCullModeEXT:
        {
            return "OP_vkCmdSetCullModeEXT";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkGetSemaphoreCounterValue:
        {
            return "OP_vkGetSemaphoreCounterValue";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetDepthBiasEnable:
        {
            return "OP_vkCmdSetDepthBiasEnable";
        }
        case OP_vkCmdSetViewportWithCount:
        {
            return "OP_vkCmdSetViewportWithCount";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case OP_vkCmdSetLogicOpEXT:
        {
            return "OP_vkCmdSetLogicOpEXT";
        }
#endif
#ifdef VK_EXT_transform_feedback
        case OP_vkCmdBindTransformFeedbackBuffersEXT:
        {
            return "OP_vkCmdBindTransformFeedbackBuffersEXT";
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case OP_vkQueueCommitDescriptorSetUpdatesGOOGLE:
        {
            return "OP_vkQueueCommitDescriptorSetUpdatesGOOGLE";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdCopyBufferToImage2:
        {
            return "OP_vkCmdCopyBufferToImage2";
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case OP_vkGetPipelineExecutablePropertiesKHR:
        {
            return "OP_vkGetPipelineExecutablePropertiesKHR";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkGetImageSubresourceLayout2:
        {
            return "OP_vkGetImageSubresourceLayout2";
        }
        case OP_vkCmdPushDescriptorSet2:
        {
            return "OP_vkCmdPushDescriptorSet2";
        }
        case OP_vkMapMemory2:
        {
            return "OP_vkMapMemory2";
        }
#endif
#ifdef VK_KHR_synchronization2
        case OP_vkCmdSetEvent2KHR:
        {
            return "OP_vkCmdSetEvent2KHR";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkSignalSemaphore:
        {
            return "OP_vkSignalSemaphore";
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case OP_vkGetPipelineExecutableStatisticsKHR:
        {
            return "OP_vkGetPipelineExecutableStatisticsKHR";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdResetEvent2:
        {
            return "OP_vkCmdResetEvent2";
        }
#endif
#ifdef VK_EXT_transform_feedback
        case OP_vkCmdEndTransformFeedbackEXT:
        {
            return "OP_vkCmdEndTransformFeedbackEXT";
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case OP_vkGetPipelineExecutableInternalRepresentationsKHR:
        {
            return "OP_vkGetPipelineExecutableInternalRepresentationsKHR";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdBlitImage2:
        {
            return "OP_vkCmdBlitImage2";
        }
        case OP_vkQueueSubmit2:
        {
            return "OP_vkQueueSubmit2";
        }
#endif
#ifdef VK_KHR_maintenance4
        case OP_vkGetDeviceImageSparseMemoryRequirementsKHR:
        {
            return "OP_vkGetDeviceImageSparseMemoryRequirementsKHR";
        }
#endif
#ifdef VK_EXT_transform_feedback
        case OP_vkCmdBeginQueryIndexedEXT:
        {
            return "OP_vkCmdBeginQueryIndexedEXT";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkCmdPushConstants2:
        {
            return "OP_vkCmdPushConstants2";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetRasterizerDiscardEnable:
        {
            return "OP_vkCmdSetRasterizerDiscardEnable";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdSetStencilOpEXT:
        {
            return "OP_vkCmdSetStencilOpEXT";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkCreateRenderPass2:
        {
            return "OP_vkCreateRenderPass2";
        }
#endif
#ifdef VK_EXT_transform_feedback
        case OP_vkCmdEndQueryIndexedEXT:
        {
            return "OP_vkCmdEndQueryIndexedEXT";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkCmdBindDescriptorSets2:
        {
            return "OP_vkCmdBindDescriptorSets2";
        }
#endif
#ifdef VK_EXT_tooling_info
        case OP_vkGetPhysicalDeviceToolPropertiesEXT:
        {
            return "OP_vkGetPhysicalDeviceToolPropertiesEXT";
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case OP_vkGetLinearImageLayout2GOOGLE:
        {
            return "OP_vkGetLinearImageLayout2GOOGLE";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdResolveImage2:
        {
            return "OP_vkCmdResolveImage2";
        }
        case OP_vkGetDeviceImageMemoryRequirements:
        {
            return "OP_vkGetDeviceImageMemoryRequirements";
        }
#endif
#ifdef VK_VERSION_1_2
        case OP_vkCmdDrawIndirectCount:
        {
            return "OP_vkCmdDrawIndirectCount";
        }
#endif
#ifdef VK_KHR_synchronization2
        case OP_vkCmdResetEvent2KHR:
        {
            return "OP_vkCmdResetEvent2KHR";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkCmdPushDescriptorSetWithTemplate2:
        {
            return "OP_vkCmdPushDescriptorSetWithTemplate2";
        }
#endif
#ifdef VK_EXT_transform_feedback
        case OP_vkCmdDrawIndirectByteCountEXT:
        {
            return "OP_vkCmdDrawIndirectByteCountEXT";
        }
#endif
#ifdef VK_VERSION_1_4
        case OP_vkCmdSetRenderingInputAttachmentIndices:
        {
            return "OP_vkCmdSetRenderingInputAttachmentIndices";
        }
#endif
#ifdef VK_KHR_buffer_device_address
        case OP_vkGetBufferOpaqueCaptureAddressKHR:
        {
            return "OP_vkGetBufferOpaqueCaptureAddressKHR";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case OP_vkCmdSetStencilTestEnableEXT:
        {
            return "OP_vkCmdSetStencilTestEnableEXT";
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case OP_vkTraceAsyncGOOGLE:
        {
            return "OP_vkTraceAsyncGOOGLE";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdSetStencilTestEnable:
        {
            return "OP_vkCmdSetStencilTestEnable";
        }
        case OP_vkGetPhysicalDeviceToolProperties:
        {
            return "OP_vkGetPhysicalDeviceToolProperties";
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case OP_vkGetSwapchainGrallocUsage2ANDROID:
        {
            return "OP_vkGetSwapchainGrallocUsage2ANDROID";
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case OP_vkQueueFlushCommandsFromAuxMemoryGOOGLE:
        {
            return "OP_vkQueueFlushCommandsFromAuxMemoryGOOGLE";
        }
#endif
#ifdef VK_EXT_private_data
        case OP_vkGetPrivateDataEXT:
        {
            return "OP_vkGetPrivateDataEXT";
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case OP_vkQueueSubmitAsync2GOOGLE:
        {
            return "OP_vkQueueSubmitAsync2GOOGLE";
        }
#endif
#ifdef VK_KHR_synchronization2
        case OP_vkQueueSubmit2KHR:
        {
            return "OP_vkQueueSubmit2KHR";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkGetDeviceBufferMemoryRequirements:
        {
            return "OP_vkGetDeviceBufferMemoryRequirements";
        }
#endif
#ifdef VK_EXT_transform_feedback
        case OP_vkCmdBeginTransformFeedbackEXT:
        {
            return "OP_vkCmdBeginTransformFeedbackEXT";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdBeginRendering:
        {
            return "OP_vkCmdBeginRendering";
        }
#endif
#ifdef VK_KHR_buffer_device_address
        case OP_vkGetDeviceMemoryOpaqueCaptureAddressKHR:
        {
            return "OP_vkGetDeviceMemoryOpaqueCaptureAddressKHR";
        }
#endif
#ifdef VK_EXT_host_image_copy
        case OP_vkGetImageSubresourceLayout2EXT:
        {
            return "OP_vkGetImageSubresourceLayout2EXT";
        }
#endif
#ifdef VK_VERSION_1_3
        case OP_vkCmdPipelineBarrier2:
        {
            return "OP_vkCmdPipelineBarrier2";
        }
#endif
#ifdef VK_KHR_dynamic_rendering
        case OP_vkCmdBeginRenderingKHR:
        {
            return "OP_vkCmdBeginRenderingKHR";
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case OP_vkCmdSetPrimitiveRestartEnableEXT:
        {
            return "OP_vkCmdSetPrimitiveRestartEnableEXT";
        }
#endif
        default:
        {
            return "OP_UNKNOWN_API_CALL";
        }
    }
}


}  // namespace vk
}  // namespace gfxstream
