/*
 * Copyright 2020 Intel Corporation
 * Copyright 2025 LunarG, Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/* This file generated from kk_dispatch_trampolines_gen.py, don't edit directly. */

#include "kk_device.h"
#include "kk_dispatch_trampolines.h"
#include "vk_object.h"
#include "vk_physical_device.h"

                    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceProperties(physicalDevice, pProperties);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceQueueFamilyProperties(physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceFeatures(physicalDevice, pFeatures);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateDevice(VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.CreateDevice(physicalDevice, pCreateInfo, pAllocator, pDevice);
}
                static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_EnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.EnumerateDeviceLayerProperties(physicalDevice, pPropertyCount, pProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_EnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.EnumerateDeviceExtensionProperties(physicalDevice, pLayerName, pPropertyCount, pProperties);
}
                                                                static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPropertiesKHR* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, pPropertyCount, pProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlanePropertiesKHR* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, pPropertyCount, pProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, uint32_t planeIndex, uint32_t* pDisplayCount, VkDisplayKHR* pDisplays)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, pDisplayCount, pDisplays);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModePropertiesKHR* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetDisplayModePropertiesKHR(physicalDevice, display, pPropertyCount, pProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateDisplayModeKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, const VkDisplayModeCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDisplayModeKHR* pMode)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.CreateDisplayModeKHR(physicalDevice, display, pCreateInfo, pAllocator, pMode);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkDisplayModeKHR mode, uint32_t planeIndex, VkDisplayPlaneCapabilitiesKHR* pCapabilities)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities);
}
            static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, VkSurfaceKHR surface, VkBool32* pSupported)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, pSupported);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilitiesKHR* pSurfaceCapabilities)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pSurfaceFormatCount, VkSurfaceFormatKHR* pSurfaceFormats)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, pPresentModeCount, pPresentModes);
}
                            #ifdef VK_USE_PLATFORM_WAYLAND_KHR
static VKAPI_ATTR VkBool32 VKAPI_CALL
kk_tramp_GetPhysicalDeviceWaylandPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct wl_display* display)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceWaylandPresentationSupportKHR(physicalDevice, queueFamilyIndex, display);
}
#endif
    #ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkBool32 VKAPI_CALL
kk_tramp_GetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceWin32PresentationSupportKHR(physicalDevice, queueFamilyIndex);
}
#endif
    #ifdef VK_USE_PLATFORM_XLIB_KHR
static VKAPI_ATTR VkBool32 VKAPI_CALL
kk_tramp_GetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, Display* dpy, VisualID visualID)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceXlibPresentationSupportKHR(physicalDevice, queueFamilyIndex, dpy, visualID);
}
#endif
    #ifdef VK_USE_PLATFORM_XCB_KHR
static VKAPI_ATTR VkBool32 VKAPI_CALL
kk_tramp_GetPhysicalDeviceXcbPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, xcb_connection_t* connection, xcb_visualid_t visual_id)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceXcbPresentationSupportKHR(physicalDevice, queueFamilyIndex, connection, visual_id);
}
#endif
    #ifdef VK_USE_PLATFORM_DIRECTFB_EXT
static VKAPI_ATTR VkBool32 VKAPI_CALL
kk_tramp_GetPhysicalDeviceDirectFBPresentationSupportEXT(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, IDirectFB* dfb)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceDirectFBPresentationSupportEXT(physicalDevice, queueFamilyIndex, dfb);
}
#endif
            #ifdef VK_USE_PLATFORM_SCREEN_QNX
static VKAPI_ATTR VkBool32 VKAPI_CALL
kk_tramp_GetPhysicalDeviceScreenPresentationSupportQNX(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct _screen_window* window)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceScreenPresentationSupportQNX(physicalDevice, queueFamilyIndex, window);
}
#endif
                                static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceExternalImageFormatPropertiesNV(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkExternalMemoryHandleTypeFlagsNV externalHandleType, VkExternalImageFormatPropertiesNV* pExternalImageFormatProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceExternalImageFormatPropertiesNV(physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties);
}
                                                                static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceFeatures2(physicalDevice, pFeatures);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceProperties2(physicalDevice, pProperties);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceFormatProperties2(physicalDevice, format, pFormatProperties);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo, pImageFormatProperties);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceQueueFamilyProperties2(physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceMemoryProperties2(physicalDevice, pMemoryProperties);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceSparseImageFormatProperties2(physicalDevice, pFormatInfo, pPropertyCount, pProperties);
}
                    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceExternalBufferProperties(physicalDevice, pExternalBufferInfo, pExternalBufferProperties);
}
                                static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceExternalSemaphoreProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceExternalSemaphoreProperties(physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties);
}
                            static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceExternalFenceProperties(physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
}
                    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ReleaseDisplayEXT(VkPhysicalDevice physicalDevice, VkDisplayKHR display)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.ReleaseDisplayEXT(physicalDevice, display);
}
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AcquireXlibDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, VkDisplayKHR display)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.AcquireXlibDisplayEXT(physicalDevice, dpy, display);
}
#endif
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, RROutput rrOutput, VkDisplayKHR* pDisplay)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetRandROutputDisplayEXT(physicalDevice, dpy, rrOutput, pDisplay);
}
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AcquireWinrtDisplayNV(VkPhysicalDevice physicalDevice, VkDisplayKHR display)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.AcquireWinrtDisplayNV(physicalDevice, display);
}
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetWinrtDisplayNV(VkPhysicalDevice physicalDevice, uint32_t deviceRelativeId, VkDisplayKHR* pDisplay)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetWinrtDisplayNV(physicalDevice, deviceRelativeId, pDisplay);
}
#endif
                static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceSurfaceCapabilities2EXT(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilities2EXT* pSurfaceCapabilities)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceSurfaceCapabilities2EXT(physicalDevice, surface, pSurfaceCapabilities);
}
                                                            static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pRectCount, VkRect2D* pRects)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDevicePresentRectanglesKHR(physicalDevice, surface, pRectCount, pRects);
}
                                                                                static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceMultisamplePropertiesEXT(VkPhysicalDevice physicalDevice, VkSampleCountFlagBits samples, VkMultisamplePropertiesEXT* pMultisampleProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceMultisamplePropertiesEXT(physicalDevice, samples, pMultisampleProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceSurfaceCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkSurfaceCapabilities2KHR* pSurfaceCapabilities)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceSurfaceCapabilities2KHR(physicalDevice, pSurfaceInfo, pSurfaceCapabilities);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceSurfaceFormats2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pSurfaceFormatCount, VkSurfaceFormat2KHR* pSurfaceFormats)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceSurfaceFormats2KHR(physicalDevice, pSurfaceInfo, pSurfaceFormatCount, pSurfaceFormats);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayProperties2KHR* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceDisplayProperties2KHR(physicalDevice, pPropertyCount, pProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlaneProperties2KHR* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceDisplayPlaneProperties2KHR(physicalDevice, pPropertyCount, pProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModeProperties2KHR* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetDisplayModeProperties2KHR(physicalDevice, display, pPropertyCount, pProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkDisplayPlaneInfo2KHR* pDisplayPlaneInfo, VkDisplayPlaneCapabilities2KHR* pCapabilities)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetDisplayPlaneCapabilities2KHR(physicalDevice, pDisplayPlaneInfo, pCapabilities);
}
                                                                                                                    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceCalibrateableTimeDomainsKHR(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainKHR* pTimeDomains)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceCalibrateableTimeDomainsKHR(physicalDevice, pTimeDomainCount, pTimeDomains);
}
                                                                                                                                                                                                                                                                                                                                            static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceCooperativeMatrixPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesNV* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceCooperativeMatrixPropertiesNV(physicalDevice, pPropertyCount, pProperties);
}
                                        #ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceSurfacePresentModes2EXT(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceSurfacePresentModes2EXT(physicalDevice, pSurfaceInfo, pPresentModeCount, pPresentModes);
}
#endif
            static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterKHR* pCounters, VkPerformanceCounterDescriptionKHR* pCounterDescriptions)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(VkPhysicalDevice physicalDevice, const VkQueryPoolPerformanceCreateInfoKHR* pPerformanceQueryCreateInfo, uint32_t* pNumPasses)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(physicalDevice, pPerformanceQueryCreateInfo, pNumPasses);
}
                                    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(VkPhysicalDevice physicalDevice, uint32_t* pCombinationCount, VkFramebufferMixedSamplesCombinationNV* pCombinations)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(physicalDevice, pCombinationCount, pCombinations);
}
                                                                    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceToolProperties(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceToolProperties(physicalDevice, pToolCount, pToolProperties);
}
                                                                                                                                                                                                                                                                                                                                                                                                                static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceFragmentShadingRatesKHR(VkPhysicalDevice physicalDevice, uint32_t* pFragmentShadingRateCount, VkPhysicalDeviceFragmentShadingRateKHR* pFragmentShadingRates)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceFragmentShadingRatesKHR(physicalDevice, pFragmentShadingRateCount, pFragmentShadingRates);
}
                                                                                                        static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceVideoCapabilitiesKHR(VkPhysicalDevice physicalDevice, const VkVideoProfileInfoKHR* pVideoProfile, VkVideoCapabilitiesKHR* pCapabilities)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceVideoCapabilitiesKHR(physicalDevice, pVideoProfile, pCapabilities);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceVideoFormatPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoFormatInfoKHR* pVideoFormatInfo, uint32_t* pVideoFormatPropertyCount, VkVideoFormatPropertiesKHR* pVideoFormatProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceVideoFormatPropertiesKHR(physicalDevice, pVideoFormatInfo, pVideoFormatPropertyCount, pVideoFormatProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR* pQualityLevelInfo, VkVideoEncodeQualityLevelPropertiesKHR* pQualityLevelProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(physicalDevice, pQualityLevelInfo, pQualityLevelProperties);
}
                                                                                                                                                static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AcquireDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, VkDisplayKHR display)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.AcquireDrmDisplayEXT(physicalDevice, drmFd, display);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, uint32_t connectorId, VkDisplayKHR* display)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetDrmDisplayEXT(physicalDevice, drmFd, connectorId, display);
}
                                                                                                                                                            static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceOpticalFlowImageFormatsNV(VkPhysicalDevice physicalDevice, const VkOpticalFlowImageFormatInfoNV* pOpticalFlowImageFormatInfo, uint32_t* pFormatCount, VkOpticalFlowImageFormatPropertiesNV* pImageFormatProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceOpticalFlowImageFormatsNV(physicalDevice, pOpticalFlowImageFormatInfo, pFormatCount, pImageFormatProperties);
}
                                                                                            static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceCooperativeMatrixPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesKHR* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceCooperativeMatrixPropertiesKHR(physicalDevice, pPropertyCount, pProperties);
}
                                                                                static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixFlexibleDimensionsPropertiesNV* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV(physicalDevice, pPropertyCount, pProperties);
}
        static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceCooperativeVectorPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeVectorPropertiesNV* pProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceCooperativeVectorPropertiesNV(physicalDevice, pPropertyCount, pProperties);
}
                                                                        static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceExternalTensorPropertiesARM(VkPhysicalDevice                             physicalDevice, const VkPhysicalDeviceExternalTensorInfoARM* pExternalTensorInfo, VkExternalTensorPropertiesARM*               pExternalTensorProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceExternalTensorPropertiesARM(physicalDevice, pExternalTensorInfo, pExternalTensorProperties);
}
                                    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPhysicalDeviceQueueFamilyDataGraphPropertiesARM(VkPhysicalDevice                     physicalDevice, uint32_t                             queueFamilyIndex, uint32_t*                            pQueueFamilyDataGraphPropertyCount, VkQueueFamilyDataGraphPropertiesARM* pQueueFamilyDataGraphProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.GetPhysicalDeviceQueueFamilyDataGraphPropertiesARM(physicalDevice, queueFamilyIndex, pQueueFamilyDataGraphPropertyCount, pQueueFamilyDataGraphProperties);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM(VkPhysicalDevice                                 physicalDevice, const VkPhysicalDeviceQueueFamilyDataGraphProcessingEngineInfoARM* pQueueFamilyDataGraphProcessingEngineInfo, VkQueueFamilyDataGraphProcessingEnginePropertiesARM*               pQueueFamilyDataGraphProcessingEngineProperties)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    vk_physical_device->dispatch_table.GetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM(physicalDevice, pQueueFamilyDataGraphProcessingEngineInfo, pQueueFamilyDataGraphProcessingEngineProperties);
}
                    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_EnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterARM* pCounters, VkPerformanceCounterDescriptionARM* pCounterDescriptions)
{
    
    VK_FROM_HANDLE(vk_physical_device, vk_physical_device, physicalDevice);
    return vk_physical_device->dispatch_table.EnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM(physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions);
}

struct vk_physical_device_dispatch_table kk_physical_device_trampolines = {
                        .GetPhysicalDeviceProperties = kk_tramp_GetPhysicalDeviceProperties,
    .GetPhysicalDeviceQueueFamilyProperties = kk_tramp_GetPhysicalDeviceQueueFamilyProperties,
    .GetPhysicalDeviceMemoryProperties = kk_tramp_GetPhysicalDeviceMemoryProperties,
    .GetPhysicalDeviceFeatures = kk_tramp_GetPhysicalDeviceFeatures,
    .GetPhysicalDeviceFormatProperties = kk_tramp_GetPhysicalDeviceFormatProperties,
    .GetPhysicalDeviceImageFormatProperties = kk_tramp_GetPhysicalDeviceImageFormatProperties,
    .CreateDevice = kk_tramp_CreateDevice,
                    .EnumerateDeviceLayerProperties = kk_tramp_EnumerateDeviceLayerProperties,
    .EnumerateDeviceExtensionProperties = kk_tramp_EnumerateDeviceExtensionProperties,
                                                                    .GetPhysicalDeviceSparseImageFormatProperties = kk_tramp_GetPhysicalDeviceSparseImageFormatProperties,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        .GetPhysicalDeviceDisplayPropertiesKHR = kk_tramp_GetPhysicalDeviceDisplayPropertiesKHR,
    .GetPhysicalDeviceDisplayPlanePropertiesKHR = kk_tramp_GetPhysicalDeviceDisplayPlanePropertiesKHR,
    .GetDisplayPlaneSupportedDisplaysKHR = kk_tramp_GetDisplayPlaneSupportedDisplaysKHR,
    .GetDisplayModePropertiesKHR = kk_tramp_GetDisplayModePropertiesKHR,
    .CreateDisplayModeKHR = kk_tramp_CreateDisplayModeKHR,
    .GetDisplayPlaneCapabilitiesKHR = kk_tramp_GetDisplayPlaneCapabilitiesKHR,
                .GetPhysicalDeviceSurfaceSupportKHR = kk_tramp_GetPhysicalDeviceSurfaceSupportKHR,
    .GetPhysicalDeviceSurfaceCapabilitiesKHR = kk_tramp_GetPhysicalDeviceSurfaceCapabilitiesKHR,
    .GetPhysicalDeviceSurfaceFormatsKHR = kk_tramp_GetPhysicalDeviceSurfaceFormatsKHR,
    .GetPhysicalDeviceSurfacePresentModesKHR = kk_tramp_GetPhysicalDeviceSurfacePresentModesKHR,
                            #ifdef VK_USE_PLATFORM_WAYLAND_KHR
    .GetPhysicalDeviceWaylandPresentationSupportKHR = kk_tramp_GetPhysicalDeviceWaylandPresentationSupportKHR,
#endif
    #ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceWin32PresentationSupportKHR = kk_tramp_GetPhysicalDeviceWin32PresentationSupportKHR,
#endif
    #ifdef VK_USE_PLATFORM_XLIB_KHR
    .GetPhysicalDeviceXlibPresentationSupportKHR = kk_tramp_GetPhysicalDeviceXlibPresentationSupportKHR,
#endif
    #ifdef VK_USE_PLATFORM_XCB_KHR
    .GetPhysicalDeviceXcbPresentationSupportKHR = kk_tramp_GetPhysicalDeviceXcbPresentationSupportKHR,
#endif
    #ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    .GetPhysicalDeviceDirectFBPresentationSupportEXT = kk_tramp_GetPhysicalDeviceDirectFBPresentationSupportEXT,
#endif
            #ifdef VK_USE_PLATFORM_SCREEN_QNX
    .GetPhysicalDeviceScreenPresentationSupportQNX = kk_tramp_GetPhysicalDeviceScreenPresentationSupportQNX,
#endif
                                    .GetPhysicalDeviceExternalImageFormatPropertiesNV = kk_tramp_GetPhysicalDeviceExternalImageFormatPropertiesNV,
                                                                    .GetPhysicalDeviceFeatures2 = kk_tramp_GetPhysicalDeviceFeatures2,
        .GetPhysicalDeviceProperties2 = kk_tramp_GetPhysicalDeviceProperties2,
        .GetPhysicalDeviceFormatProperties2 = kk_tramp_GetPhysicalDeviceFormatProperties2,
        .GetPhysicalDeviceImageFormatProperties2 = kk_tramp_GetPhysicalDeviceImageFormatProperties2,
        .GetPhysicalDeviceQueueFamilyProperties2 = kk_tramp_GetPhysicalDeviceQueueFamilyProperties2,
        .GetPhysicalDeviceMemoryProperties2 = kk_tramp_GetPhysicalDeviceMemoryProperties2,
        .GetPhysicalDeviceSparseImageFormatProperties2 = kk_tramp_GetPhysicalDeviceSparseImageFormatProperties2,
                        .GetPhysicalDeviceExternalBufferProperties = kk_tramp_GetPhysicalDeviceExternalBufferProperties,
                                    .GetPhysicalDeviceExternalSemaphoreProperties = kk_tramp_GetPhysicalDeviceExternalSemaphoreProperties,
                                .GetPhysicalDeviceExternalFenceProperties = kk_tramp_GetPhysicalDeviceExternalFenceProperties,
                        .ReleaseDisplayEXT = kk_tramp_ReleaseDisplayEXT,
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .AcquireXlibDisplayEXT = kk_tramp_AcquireXlibDisplayEXT,
#endif
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .GetRandROutputDisplayEXT = kk_tramp_GetRandROutputDisplayEXT,
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .AcquireWinrtDisplayNV = kk_tramp_AcquireWinrtDisplayNV,
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetWinrtDisplayNV = kk_tramp_GetWinrtDisplayNV,
#endif
                    .GetPhysicalDeviceSurfaceCapabilities2EXT = kk_tramp_GetPhysicalDeviceSurfaceCapabilities2EXT,
                                                                .GetPhysicalDevicePresentRectanglesKHR = kk_tramp_GetPhysicalDevicePresentRectanglesKHR,
                                                                                    .GetPhysicalDeviceMultisamplePropertiesEXT = kk_tramp_GetPhysicalDeviceMultisamplePropertiesEXT,
    .GetPhysicalDeviceSurfaceCapabilities2KHR = kk_tramp_GetPhysicalDeviceSurfaceCapabilities2KHR,
    .GetPhysicalDeviceSurfaceFormats2KHR = kk_tramp_GetPhysicalDeviceSurfaceFormats2KHR,
    .GetPhysicalDeviceDisplayProperties2KHR = kk_tramp_GetPhysicalDeviceDisplayProperties2KHR,
    .GetPhysicalDeviceDisplayPlaneProperties2KHR = kk_tramp_GetPhysicalDeviceDisplayPlaneProperties2KHR,
    .GetDisplayModeProperties2KHR = kk_tramp_GetDisplayModeProperties2KHR,
    .GetDisplayPlaneCapabilities2KHR = kk_tramp_GetDisplayPlaneCapabilities2KHR,
                                                                                                                        .GetPhysicalDeviceCalibrateableTimeDomainsKHR = kk_tramp_GetPhysicalDeviceCalibrateableTimeDomainsKHR,
                                                                                                                                                                                                                                                                                                                                                .GetPhysicalDeviceCooperativeMatrixPropertiesNV = kk_tramp_GetPhysicalDeviceCooperativeMatrixPropertiesNV,
                                        #ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceSurfacePresentModes2EXT = kk_tramp_GetPhysicalDeviceSurfacePresentModes2EXT,
#endif
                .EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = kk_tramp_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR,
    .GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = kk_tramp_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR,
                                        .GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = kk_tramp_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV,
                                                                        .GetPhysicalDeviceToolProperties = kk_tramp_GetPhysicalDeviceToolProperties,
                                                                                                                                                                                                                                                                                                                                                                                                                    .GetPhysicalDeviceFragmentShadingRatesKHR = kk_tramp_GetPhysicalDeviceFragmentShadingRatesKHR,
                                                                                                            .GetPhysicalDeviceVideoCapabilitiesKHR = kk_tramp_GetPhysicalDeviceVideoCapabilitiesKHR,
    .GetPhysicalDeviceVideoFormatPropertiesKHR = kk_tramp_GetPhysicalDeviceVideoFormatPropertiesKHR,
    .GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR = kk_tramp_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR,
                                                                                                                                                    .AcquireDrmDisplayEXT = kk_tramp_AcquireDrmDisplayEXT,
    .GetDrmDisplayEXT = kk_tramp_GetDrmDisplayEXT,
                                                                                                                                                                .GetPhysicalDeviceOpticalFlowImageFormatsNV = kk_tramp_GetPhysicalDeviceOpticalFlowImageFormatsNV,
                                                                                                .GetPhysicalDeviceCooperativeMatrixPropertiesKHR = kk_tramp_GetPhysicalDeviceCooperativeMatrixPropertiesKHR,
                                                                                    .GetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV = kk_tramp_GetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV,
            .GetPhysicalDeviceCooperativeVectorPropertiesNV = kk_tramp_GetPhysicalDeviceCooperativeVectorPropertiesNV,
                                                                            .GetPhysicalDeviceExternalTensorPropertiesARM = kk_tramp_GetPhysicalDeviceExternalTensorPropertiesARM,
                                        .GetPhysicalDeviceQueueFamilyDataGraphPropertiesARM = kk_tramp_GetPhysicalDeviceQueueFamilyDataGraphPropertiesARM,
    .GetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM = kk_tramp_GetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM,
                        .EnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM = kk_tramp_EnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM,
};

            static VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL
kk_tramp_GetDeviceProcAddr(VkDevice device, const char* pName)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDeviceProcAddr(device, pName);
}
                                static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyDevice(device, pAllocator);
}
                    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDeviceQueue(device, queueFamilyIndex, queueIndex, pQueue);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.QueueSubmit(queue, submitCount, pSubmits, fence);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_QueueWaitIdle(VkQueue queue)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.QueueWaitIdle(queue);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_DeviceWaitIdle(VkDevice device)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.DeviceWaitIdle(device);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.AllocateMemory(device, pAllocateInfo, pAllocator, pMemory);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.FreeMemory(device, memory, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.MapMemory(device, memory, offset, size, flags, ppData);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_UnmapMemory(VkDevice device, VkDeviceMemory memory)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.UnmapMemory(device, memory);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.FlushMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.InvalidateMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDeviceMemoryCommitment(device, memory, pCommittedMemoryInBytes);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetBufferMemoryRequirements(device, buffer, pMemoryRequirements);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.BindBufferMemory(device, buffer, memory, memoryOffset);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetImageMemoryRequirements(device, image, pMemoryRequirements);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.BindImageMemory(device, image, memory, memoryOffset);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetImageSparseMemoryRequirements(device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.QueueBindSparse(queue, bindInfoCount, pBindInfo, fence);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateFence(device, pCreateInfo, pAllocator, pFence);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyFence(device, fence, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ResetFences(device, fenceCount, pFences);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetFenceStatus(VkDevice device, VkFence fence)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetFenceStatus(device, fence);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.WaitForFences(device, fenceCount, pFences, waitAll, timeout);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroySemaphore(device, semaphore, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateEvent(device, pCreateInfo, pAllocator, pEvent);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyEvent(device, event, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetEventStatus(VkDevice device, VkEvent event)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetEventStatus(device, event);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_SetEvent(VkDevice device, VkEvent event)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.SetEvent(device, event);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ResetEvent(VkDevice device, VkEvent event)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ResetEvent(device, event);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyQueryPool(device, queryPool, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.ResetQueryPool(device, queryPool, firstQuery, queryCount);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateBuffer(device, pCreateInfo, pAllocator, pBuffer);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyBuffer(device, buffer, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateBufferView(device, pCreateInfo, pAllocator, pView);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyBufferView(device, bufferView, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateImage(device, pCreateInfo, pAllocator, pImage);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyImage(device, image, pAllocator);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetImageSubresourceLayout(device, image, pSubresource, pLayout);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateImageView(device, pCreateInfo, pAllocator, pView);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyImageView(device, imageView, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateShaderModule(device, pCreateInfo, pAllocator, pShaderModule);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyShaderModule(device, shaderModule, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreatePipelineCache(device, pCreateInfo, pAllocator, pPipelineCache);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyPipelineCache(device, pipelineCache, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetPipelineCacheData(device, pipelineCache, pDataSize, pData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.MergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreatePipelineBinariesKHR(VkDevice device, const VkPipelineBinaryCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineBinaryHandlesInfoKHR* pBinaries)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreatePipelineBinariesKHR(device, pCreateInfo, pAllocator, pBinaries);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyPipelineBinaryKHR(VkDevice device, VkPipelineBinaryKHR pipelineBinary, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyPipelineBinaryKHR(device, pipelineBinary, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPipelineKeyKHR(VkDevice device, const VkPipelineCreateInfoKHR* pPipelineCreateInfo, VkPipelineBinaryKeyKHR* pPipelineKey)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetPipelineKeyKHR(device, pPipelineCreateInfo, pPipelineKey);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPipelineBinaryDataKHR(VkDevice device, const VkPipelineBinaryDataInfoKHR* pInfo, VkPipelineBinaryKeyKHR* pPipelineBinaryKey, size_t* pPipelineBinaryDataSize, void* pPipelineBinaryData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetPipelineBinaryDataKHR(device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize, pPipelineBinaryData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ReleaseCapturedPipelineDataKHR(VkDevice device, const VkReleaseCapturedPipelineDataInfoKHR* pInfo, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ReleaseCapturedPipelineDataKHR(device, pInfo, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateGraphicsPipelines(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateComputePipelines(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(device, renderpass, pMaxWorkgroupSize);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyPipeline(device, pipeline, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreatePipelineLayout(device, pCreateInfo, pAllocator, pPipelineLayout);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyPipelineLayout(device, pipelineLayout, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateSampler(device, pCreateInfo, pAllocator, pSampler);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroySampler(device, sampler, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyDescriptorSetLayout(device, descriptorSetLayout, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyDescriptorPool(device, descriptorPool, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ResetDescriptorPool(device, descriptorPool, flags);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.AllocateDescriptorSets(device, pAllocateInfo, pDescriptorSets);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.FreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.UpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount, pDescriptorCopies);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyFramebuffer(device, framebuffer, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyRenderPass(device, renderPass, pAllocator);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetRenderAreaGranularity(device, renderPass, pGranularity);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetRenderingAreaGranularity(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo, VkExtent2D* pGranularity)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetRenderingAreaGranularity(device, pRenderingAreaInfo, pGranularity);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateCommandPool(device, pCreateInfo, pAllocator, pCommandPool);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyCommandPool(device, commandPool, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ResetCommandPool(device, commandPool, flags);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.AllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.FreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.BeginCommandBuffer(commandBuffer, pBeginInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_EndCommandBuffer(VkCommandBuffer commandBuffer)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.EndCommandBuffer(commandBuffer);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.ResetCommandBuffer(commandBuffer, flags);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetAttachmentFeedbackLoopEnableEXT(VkCommandBuffer commandBuffer, VkImageAspectFlags aspectMask)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetAttachmentFeedbackLoopEnableEXT(commandBuffer, aspectMask);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetLineWidth(commandBuffer, lineWidth);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetBlendConstants(commandBuffer, blendConstants);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetStencilCompareMask(commandBuffer, faceMask, compareMask);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetStencilWriteMask(commandBuffer, faceMask, writeMask);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetStencilReference(commandBuffer, faceMask, reference);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindIndexBuffer(commandBuffer, buffer, offset, indexType);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawMultiEXT(commandBuffer, drawCount, pVertexInfo, instanceCount, firstInstance, stride);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawMultiIndexedEXT(commandBuffer, drawCount, pIndexInfo, instanceCount, firstInstance, stride, pVertexOffset);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDispatchIndirect(commandBuffer, buffer, offset);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSubpassShadingHUAWEI(commandBuffer);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawClusterHUAWEI(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawClusterHUAWEI(commandBuffer, groupCountX, groupCountY, groupCountZ);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawClusterIndirectHUAWEI(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawClusterIndirectHUAWEI(commandBuffer, buffer, offset);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdUpdatePipelineIndirectBufferNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint           pipelineBindPoint, VkPipeline                    pipeline)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdUpdatePipelineIndirectBufferNV(commandBuffer, pipelineBindPoint, pipeline);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyMemoryIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyMemoryIndirectNV(commandBuffer, copyBufferAddress, copyCount, stride);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyMemoryIndirectKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryIndirectInfoKHR* pCopyMemoryIndirectInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyMemoryIndirectKHR(commandBuffer, pCopyMemoryIndirectInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyMemoryToImageIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride, VkImage dstImage, VkImageLayout dstImageLayout, const VkImageSubresourceLayers* pImageSubresources)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyMemoryToImageIndirectNV(commandBuffer, copyBufferAddress, copyCount, stride, dstImage, dstImageLayout, pImageSubresources);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyMemoryToImageIndirectKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToImageIndirectInfoKHR* pCopyMemoryToImageIndirectInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyMemoryToImageIndirectKHR(commandBuffer, pCopyMemoryToImageIndirectInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetEvent(commandBuffer, event, stageMask);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdResetEvent(commandBuffer, event, stageMask);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdWaitEvents(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdPipelineBarrier(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBeginQuery(commandBuffer, queryPool, query, flags);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEndQuery(commandBuffer, queryPool, query);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEndConditionalRenderingEXT(commandBuffer);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBeginCustomResolveEXT(VkCommandBuffer commandBuffer, const VkBeginCustomResolveInfoEXT* pBeginCustomResolveInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBeginCustomResolveEXT(commandBuffer, pBeginCustomResolveInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdNextSubpass(commandBuffer, contents);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEndRenderPass(VkCommandBuffer commandBuffer)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEndRenderPass(commandBuffer);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers);
}
                                    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateSharedSwapchainsKHR(device, swapchainCount, pCreateInfos, pAllocator, pSwapchains);
}
                    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateSwapchainKHR(device, pCreateInfo, pAllocator, pSwapchain);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroySwapchainKHR(device, swapchain, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSwapchainImagesKHR(device, swapchain, pSwapchainImageCount, pSwapchainImages);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.AcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, pImageIndex);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.QueuePresentKHR(queue, pPresentInfo);
}
                                                                        static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.DebugMarkerSetObjectNameEXT(device, pNameInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.DebugMarkerSetObjectTagEXT(device, pTagInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDebugMarkerBeginEXT(commandBuffer, pMarkerInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDebugMarkerEndEXT(commandBuffer);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDebugMarkerInsertEXT(commandBuffer, pMarkerInfo);
}
    #ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory, VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryWin32HandleNV(device, memory, handleType, pHandle);
}
#endif
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdExecuteGeneratedCommandsNV(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdExecuteGeneratedCommandsNV(commandBuffer, isPreprocessed, pGeneratedCommandsInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdPreprocessGeneratedCommandsNV(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdPreprocessGeneratedCommandsNV(commandBuffer, pGeneratedCommandsInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindPipelineShaderGroupNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, uint32_t groupIndex)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindPipelineShaderGroupNV(commandBuffer, pipelineBindPoint, pipeline, groupIndex);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetGeneratedCommandsMemoryRequirementsNV(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetGeneratedCommandsMemoryRequirementsNV(device, pInfo, pMemoryRequirements);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateIndirectCommandsLayoutNV(VkDevice device, const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutNV* pIndirectCommandsLayout)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateIndirectCommandsLayoutNV(device, pCreateInfo, pAllocator, pIndirectCommandsLayout);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyIndirectCommandsLayoutNV(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyIndirectCommandsLayoutNV(device, indirectCommandsLayout, pAllocator);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdExecuteGeneratedCommandsEXT(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoEXT* pGeneratedCommandsInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdExecuteGeneratedCommandsEXT(commandBuffer, isPreprocessed, pGeneratedCommandsInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdPreprocessGeneratedCommandsEXT(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoEXT* pGeneratedCommandsInfo, VkCommandBuffer stateCommandBuffer)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdPreprocessGeneratedCommandsEXT(commandBuffer, pGeneratedCommandsInfo, stateCommandBuffer);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetGeneratedCommandsMemoryRequirementsEXT(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoEXT* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetGeneratedCommandsMemoryRequirementsEXT(device, pInfo, pMemoryRequirements);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateIndirectCommandsLayoutEXT(VkDevice device, const VkIndirectCommandsLayoutCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutEXT* pIndirectCommandsLayout)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateIndirectCommandsLayoutEXT(device, pCreateInfo, pAllocator, pIndirectCommandsLayout);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyIndirectCommandsLayoutEXT(VkDevice device, VkIndirectCommandsLayoutEXT indirectCommandsLayout, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyIndirectCommandsLayoutEXT(device, indirectCommandsLayout, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateIndirectExecutionSetEXT(VkDevice device, const VkIndirectExecutionSetCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectExecutionSetEXT* pIndirectExecutionSet)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateIndirectExecutionSetEXT(device, pCreateInfo, pAllocator, pIndirectExecutionSet);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyIndirectExecutionSetEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyIndirectExecutionSetEXT(device, indirectExecutionSet, pAllocator);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_UpdateIndirectExecutionSetPipelineEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, uint32_t executionSetWriteCount, const VkWriteIndirectExecutionSetPipelineEXT* pExecutionSetWrites)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.UpdateIndirectExecutionSetPipelineEXT(device, indirectExecutionSet, executionSetWriteCount, pExecutionSetWrites);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_UpdateIndirectExecutionSetShaderEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, uint32_t executionSetWriteCount, const VkWriteIndirectExecutionSetShaderEXT* pExecutionSetWrites)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.UpdateIndirectExecutionSetShaderEXT(device, indirectExecutionSet, executionSetWriteCount, pExecutionSetWrites);
}
                                                        static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdPushDescriptorSet(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdPushDescriptorSet(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_TrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.TrimCommandPool(device, commandPool, flags);
}
            #ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
}
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryWin32HandlePropertiesKHR(device, handleType, handle, pMemoryWin32HandleProperties);
}
#endif
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryFdKHR(device, pGetFdInfo, pFd);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd, VkMemoryFdPropertiesKHR* pMemoryFdProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryFdPropertiesKHR(device, handleType, fd, pMemoryFdProperties);
}
#ifdef VK_USE_PLATFORM_FUCHSIA
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryZirconHandleFUCHSIA(VkDevice device, const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle);
}
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryZirconHandlePropertiesFUCHSIA(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle, VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryZirconHandlePropertiesFUCHSIA(device, handleType, zirconHandle, pMemoryZirconHandleProperties);
}
#endif
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryRemoteAddressNV(VkDevice device, const VkMemoryGetRemoteAddressInfoNV* pMemoryGetRemoteAddressInfo, VkRemoteAddressNV* pAddress)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryRemoteAddressNV(device, pMemoryGetRemoteAddressInfo, pAddress);
}
        #ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSemaphoreWin32HandleKHR(VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSemaphoreWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
}
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ImportSemaphoreWin32HandleKHR(device, pImportSemaphoreWin32HandleInfo);
}
#endif
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSemaphoreFdKHR(device, pGetFdInfo, pFd);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ImportSemaphoreFdKHR(device, pImportSemaphoreFdInfo);
}
#ifdef VK_USE_PLATFORM_FUCHSIA
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSemaphoreZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle);
}
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ImportSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ImportSemaphoreZirconHandleFUCHSIA(device, pImportSemaphoreZirconHandleInfo);
}
#endif
        #ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetFenceWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
}
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ImportFenceWin32HandleKHR(VkDevice device, const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ImportFenceWin32HandleKHR(device, pImportFenceWin32HandleInfo);
}
#endif
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetFenceFdKHR(device, pGetFdInfo, pFd);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ImportFenceFdKHR(device, pImportFenceFdInfo);
}
                    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_DisplayPowerControlEXT(VkDevice device, VkDisplayKHR display, const VkDisplayPowerInfoEXT* pDisplayPowerInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.DisplayPowerControlEXT(device, display, pDisplayPowerInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_RegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.RegisterDeviceEventEXT(device, pDeviceEventInfo, pAllocator, pFence);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_RegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display, const VkDisplayEventInfoEXT* pDisplayEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.RegisterDisplayEventEXT(device, display, pDisplayEventInfo, pAllocator, pFence);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain, VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSwapchainCounterEXT(device, swapchain, counter, pCounterValue);
}
            static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDeviceGroupPeerMemoryFeatures(device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.BindBufferMemory2(device, bindInfoCount, pBindInfos);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.BindImageMemory2(device, bindInfoCount, pBindInfos);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDeviceMask(commandBuffer, deviceMask);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDeviceGroupPresentCapabilitiesKHR(device, pDeviceGroupPresentCapabilities);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface, VkDeviceGroupPresentModeFlagsKHR* pModes)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDeviceGroupSurfacePresentModesKHR(device, surface, pModes);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo, uint32_t* pImageIndex)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.AcquireNextImage2KHR(device, pAcquireInfo, pImageIndex);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
}
        static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateDescriptorUpdateTemplate(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateDescriptorUpdateTemplate(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyDescriptorUpdateTemplate(device, descriptorUpdateTemplate, pAllocator);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_UpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.UpdateDescriptorSetWithTemplate(device, descriptorSet, descriptorUpdateTemplate, pData);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdPushDescriptorSetWithTemplate(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdPushDescriptorSetWithTemplate(commandBuffer, descriptorUpdateTemplate, layout, set, pData);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_SetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains, const VkHdrMetadataEXT* pMetadata)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.SetHdrMetadataEXT(device, swapchainCount, pSwapchains, pMetadata);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSwapchainStatusKHR(device, swapchain);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain, VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pPresentationTimingCount, VkPastPresentationTimingGOOGLE* pPresentationTimings)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetPastPresentationTimingGOOGLE(device, swapchain, pPresentationTimingCount, pPresentationTimings);
}
            static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportWScalingNV* pViewportWScalings)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetViewportWScalingNV(commandBuffer, firstViewport, viewportCount, pViewportWScalings);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle, uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDiscardRectangleEXT(commandBuffer, firstDiscardRectangle, discardRectangleCount, pDiscardRectangles);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDiscardRectangleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 discardRectangleEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDiscardRectangleEnableEXT(commandBuffer, discardRectangleEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDiscardRectangleModeEXT(VkCommandBuffer commandBuffer, VkDiscardRectangleModeEXT discardRectangleMode)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDiscardRectangleModeEXT(commandBuffer, discardRectangleMode);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetSampleLocationsEXT(commandBuffer, pSampleLocationsInfo);
}
                            static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetBufferMemoryRequirements2(device, pInfo, pMemoryRequirements);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetImageMemoryRequirements2(device, pInfo, pMemoryRequirements);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetImageSparseMemoryRequirements2(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDeviceBufferMemoryRequirements(device, pInfo, pMemoryRequirements);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDeviceImageMemoryRequirements(device, pInfo, pMemoryRequirements);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDeviceImageSparseMemoryRequirements(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroySamplerYcbcrConversion(device, ycbcrConversion, pAllocator);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDeviceQueue2(device, pQueueInfo, pQueue);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateValidationCacheEXT(VkDevice device, const VkValidationCacheCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkValidationCacheEXT* pValidationCache)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateValidationCacheEXT(device, pCreateInfo, pAllocator, pValidationCache);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyValidationCacheEXT(VkDevice device, VkValidationCacheEXT validationCache, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyValidationCacheEXT(device, validationCache, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetValidationCacheDataEXT(VkDevice device, VkValidationCacheEXT validationCache, size_t* pDataSize, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetValidationCacheDataEXT(device, validationCache, pDataSize, pData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_MergeValidationCachesEXT(VkDevice device, VkValidationCacheEXT dstCache, uint32_t srcCacheCount, const VkValidationCacheEXT* pSrcCaches)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.MergeValidationCachesEXT(device, dstCache, srcCacheCount, pSrcCaches);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDescriptorSetLayoutSupport(device, pCreateInfo, pSupport);
}
    #ifdef VK_USE_PLATFORM_ANDROID_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSwapchainGrallocUsageANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, int* grallocUsage)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSwapchainGrallocUsageANDROID(device, format, imageUsage, grallocUsage);
}
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSwapchainGrallocUsage2ANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage, uint64_t* grallocProducerUsage)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSwapchainGrallocUsage2ANDROID(device, format, imageUsage, swapchainImageUsage, grallocConsumerUsage, grallocProducerUsage);
}
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AcquireImageANDROID(VkDevice device, VkImage image, int nativeFenceFd, VkSemaphore semaphore, VkFence fence)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.AcquireImageANDROID(device, image, nativeFenceFd, semaphore, fence);
}
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_QueueSignalReleaseImageANDROID(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int* pNativeFenceFd)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.QueueSignalReleaseImageANDROID(queue, waitSemaphoreCount, pWaitSemaphores, image, pNativeFenceFd);
}
#endif
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetShaderInfoAMD(VkDevice device, VkPipeline pipeline, VkShaderStageFlagBits shaderStage, VkShaderInfoTypeAMD infoType, size_t* pInfoSize, void* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetShaderInfoAMD(device, pipeline, shaderStage, infoType, pInfoSize, pInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_SetLocalDimmingAMD(VkDevice device, VkSwapchainKHR swapChain, VkBool32 localDimmingEnable)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.SetLocalDimmingAMD(device, swapChain, localDimmingEnable);
}
        static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetCalibratedTimestampsKHR(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetCalibratedTimestampsKHR(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_SetDebugUtilsObjectNameEXT(VkDevice device, const VkDebugUtilsObjectNameInfoEXT* pNameInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.SetDebugUtilsObjectNameEXT(device, pNameInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_SetDebugUtilsObjectTagEXT(VkDevice device, const VkDebugUtilsObjectTagInfoEXT* pTagInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.SetDebugUtilsObjectTagEXT(device, pTagInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_QueueBeginDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.QueueBeginDebugUtilsLabelEXT(queue, pLabelInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_QueueEndDebugUtilsLabelEXT(VkQueue queue)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.QueueEndDebugUtilsLabelEXT(queue);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_QueueInsertDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.QueueInsertDebugUtilsLabelEXT(queue, pLabelInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBeginDebugUtilsLabelEXT(commandBuffer, pLabelInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEndDebugUtilsLabelEXT(VkCommandBuffer commandBuffer)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEndDebugUtilsLabelEXT(commandBuffer);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdInsertDebugUtilsLabelEXT(commandBuffer, pLabelInfo);
}
            static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryHostPointerPropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHostPointer, VkMemoryHostPointerPropertiesEXT* pMemoryHostPointerProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryHostPointerPropertiesEXT(device, handleType, pHostPointer, pMemoryHostPointerProperties);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdWriteBufferMarkerAMD(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdWriteBufferMarkerAMD(commandBuffer, pipelineStage, dstBuffer, dstOffset, marker);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEndRenderPass2(commandBuffer, pSubpassEndInfo);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t* pValue)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSemaphoreCounterValue(device, semaphore, pValue);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_WaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.WaitSemaphores(device, pWaitInfo, timeout);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_SignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.SignalSemaphore(device, pSignalInfo);
}
    #ifdef VK_USE_PLATFORM_ANDROID_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetAndroidHardwareBufferPropertiesANDROID(VkDevice device, const struct AHardwareBuffer* buffer, VkAndroidHardwareBufferPropertiesANDROID* pProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetAndroidHardwareBufferPropertiesANDROID(device, buffer, pProperties);
}
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryAndroidHardwareBufferANDROID(VkDevice device, const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo, struct AHardwareBuffer** pBuffer)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryAndroidHardwareBufferANDROID(device, pInfo, pBuffer);
}
#endif
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
}
        static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
}
        static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetCheckpointNV(VkCommandBuffer commandBuffer, const void* pCheckpointMarker)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetCheckpointNV(commandBuffer, pCheckpointMarker);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetQueueCheckpointDataNV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointDataNV* pCheckpointData)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.GetQueueCheckpointDataNV(queue, pCheckpointDataCount, pCheckpointData);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetExclusiveScissorNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkRect2D* pExclusiveScissors)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetExclusiveScissorNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissors);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetExclusiveScissorEnableNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkBool32* pExclusiveScissorEnables)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetExclusiveScissorEnableNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissorEnables);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindShadingRateImageNV(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindShadingRateImageNV(commandBuffer, imageView, imageLayout);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetViewportShadingRatePaletteNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkShadingRatePaletteNV* pShadingRatePalettes)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetViewportShadingRatePaletteNV(commandBuffer, firstViewport, viewportCount, pShadingRatePalettes);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetCoarseSampleOrderNV(VkCommandBuffer commandBuffer, VkCoarseSampleOrderTypeNV sampleOrderType, uint32_t customSampleOrderCount, const VkCoarseSampleOrderCustomNV* pCustomSampleOrders)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetCoarseSampleOrderNV(commandBuffer, sampleOrderType, customSampleOrderCount, pCustomSampleOrders);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawMeshTasksNV(VkCommandBuffer commandBuffer, uint32_t taskCount, uint32_t firstTask)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawMeshTasksNV(commandBuffer, taskCount, firstTask);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawMeshTasksIndirectNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawMeshTasksIndirectNV(commandBuffer, buffer, offset, drawCount, stride);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawMeshTasksIndirectCountNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawMeshTasksIndirectCountNV(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawMeshTasksEXT(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawMeshTasksEXT(commandBuffer, groupCountX, groupCountY, groupCountZ);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawMeshTasksIndirectEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawMeshTasksIndirectEXT(commandBuffer, buffer, offset, drawCount, stride);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDrawMeshTasksIndirectCountEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDrawMeshTasksIndirectCountEXT(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CompileDeferredNV(VkDevice device, VkPipeline pipeline, uint32_t shader)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CompileDeferredNV(device, pipeline, shader);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateAccelerationStructureNV(VkDevice device, const VkAccelerationStructureCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureNV* pAccelerationStructure)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateAccelerationStructureNV(device, pCreateInfo, pAllocator, pAccelerationStructure);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindInvocationMaskHUAWEI(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindInvocationMaskHUAWEI(commandBuffer, imageView, imageLayout);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyAccelerationStructureKHR(VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyAccelerationStructureKHR(device, accelerationStructure, pAllocator);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyAccelerationStructureNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyAccelerationStructureNV(device, accelerationStructure, pAllocator);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetAccelerationStructureMemoryRequirementsNV(VkDevice device, const VkAccelerationStructureMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2KHR* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetAccelerationStructureMemoryRequirementsNV(device, pInfo, pMemoryRequirements);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BindAccelerationStructureMemoryNV(VkDevice device, uint32_t bindInfoCount, const VkBindAccelerationStructureMemoryInfoNV* pBindInfos)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.BindAccelerationStructureMemoryNV(device, bindInfoCount, pBindInfos);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyAccelerationStructureNV(VkCommandBuffer commandBuffer, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkCopyAccelerationStructureModeKHR mode)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyAccelerationStructureNV(commandBuffer, dst, src, mode);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureInfoKHR* pInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyAccelerationStructureKHR(commandBuffer, pInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CopyAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CopyAccelerationStructureKHR(device, deferredOperation, pInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyAccelerationStructureToMemoryKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyAccelerationStructureToMemoryKHR(commandBuffer, pInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CopyAccelerationStructureToMemoryKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CopyAccelerationStructureToMemoryKHR(device, deferredOperation, pInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyMemoryToAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyMemoryToAccelerationStructureKHR(commandBuffer, pInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CopyMemoryToAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CopyMemoryToAccelerationStructureKHR(device, deferredOperation, pInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdWriteAccelerationStructuresPropertiesKHR(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdWriteAccelerationStructuresPropertiesKHR(commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureNV* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdWriteAccelerationStructuresPropertiesNV(commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer, const VkAccelerationStructureInfoNV* pInfo, VkBuffer instanceData, VkDeviceSize instanceOffset, VkBool32 update, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkBuffer scratch, VkDeviceSize scratchOffset)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBuildAccelerationStructureNV(commandBuffer, pInfo, instanceData, instanceOffset, update, dst, src, scratch, scratchOffset);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_WriteAccelerationStructuresPropertiesKHR(VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.WriteAccelerationStructuresPropertiesKHR(device, accelerationStructureCount, pAccelerationStructures, queryType, dataSize, pData, stride);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdTraceRaysKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, uint32_t width, uint32_t height, uint32_t depth)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdTraceRaysKHR(commandBuffer, pRaygenShaderBindingTable, pMissShaderBindingTable, pHitShaderBindingTable, pCallableShaderBindingTable, width, height, depth);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdTraceRaysNV(VkCommandBuffer commandBuffer, VkBuffer raygenShaderBindingTableBuffer, VkDeviceSize raygenShaderBindingOffset, VkBuffer missShaderBindingTableBuffer, VkDeviceSize missShaderBindingOffset, VkDeviceSize missShaderBindingStride, VkBuffer hitShaderBindingTableBuffer, VkDeviceSize hitShaderBindingOffset, VkDeviceSize hitShaderBindingStride, VkBuffer callableShaderBindingTableBuffer, VkDeviceSize callableShaderBindingOffset, VkDeviceSize callableShaderBindingStride, uint32_t width, uint32_t height, uint32_t depth)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdTraceRaysNV(commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset, missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride, hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride, callableShaderBindingTableBuffer, callableShaderBindingOffset, callableShaderBindingStride, width, height, depth);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetRayTracingShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetRayTracingShaderGroupHandlesKHR(device, pipeline, firstGroup, groupCount, dataSize, pData);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetRayTracingCaptureReplayShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetRayTracingCaptureReplayShaderGroupHandlesKHR(device, pipeline, firstGroup, groupCount, dataSize, pData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetAccelerationStructureHandleNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, size_t dataSize, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetAccelerationStructureHandleNV(device, accelerationStructure, dataSize, pData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateRayTracingPipelinesNV(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoNV* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateRayTracingPipelinesNV(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateRayTracingPipelinesKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateRayTracingPipelinesKHR(device, deferredOperation, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdTraceRaysIndirectKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, VkDeviceAddress indirectDeviceAddress)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdTraceRaysIndirectKHR(commandBuffer, pRaygenShaderBindingTable, pMissShaderBindingTable, pHitShaderBindingTable, pCallableShaderBindingTable, indirectDeviceAddress);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdTraceRaysIndirect2KHR(VkCommandBuffer commandBuffer, VkDeviceAddress indirectDeviceAddress)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdTraceRaysIndirect2KHR(commandBuffer, indirectDeviceAddress);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetClusterAccelerationStructureBuildSizesNV(VkDevice device, const VkClusterAccelerationStructureInputInfoNV* pInfo, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetClusterAccelerationStructureBuildSizesNV(device, pInfo, pSizeInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBuildClusterAccelerationStructureIndirectNV(VkCommandBuffer                     commandBuffer, const VkClusterAccelerationStructureCommandsInfoNV*  pCommandInfos)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBuildClusterAccelerationStructureIndirectNV(commandBuffer, pCommandInfos);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDeviceAccelerationStructureCompatibilityKHR(VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDeviceAccelerationStructureCompatibilityKHR(device, pVersionInfo, pCompatibility);
}
static VKAPI_ATTR VkDeviceSize VKAPI_CALL
kk_tramp_GetRayTracingShaderGroupStackSizeKHR(VkDevice device, VkPipeline pipeline, uint32_t group, VkShaderGroupShaderKHR groupShader)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetRayTracingShaderGroupStackSizeKHR(device, pipeline, group, groupShader);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetRayTracingPipelineStackSizeKHR(VkCommandBuffer commandBuffer, uint32_t pipelineStackSize)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetRayTracingPipelineStackSizeKHR(commandBuffer, pipelineStackSize);
}
static VKAPI_ATTR uint32_t VKAPI_CALL
kk_tramp_GetImageViewHandleNVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetImageViewHandleNVX(device, pInfo);
}
static VKAPI_ATTR uint64_t VKAPI_CALL
kk_tramp_GetImageViewHandle64NVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetImageViewHandle64NVX(device, pInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetImageViewAddressNVX(VkDevice device, VkImageView imageView, VkImageViewAddressPropertiesNVX* pProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetImageViewAddressNVX(device, imageView, pProperties);
}
    #ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDeviceGroupSurfacePresentModes2EXT(VkDevice device, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkDeviceGroupPresentModeFlagsKHR* pModes)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDeviceGroupSurfacePresentModes2EXT(device, pSurfaceInfo, pModes);
}
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AcquireFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.AcquireFullScreenExclusiveModeEXT(device, swapchain);
}
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ReleaseFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ReleaseFullScreenExclusiveModeEXT(device, swapchain);
}
#endif
        static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AcquireProfilingLockKHR(VkDevice device, const VkAcquireProfilingLockInfoKHR* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.AcquireProfilingLockKHR(device, pInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_ReleaseProfilingLockKHR(VkDevice device)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.ReleaseProfilingLockKHR(device);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetImageDrmFormatModifierPropertiesEXT(VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetImageDrmFormatModifierPropertiesEXT(device, image, pProperties);
}
static VKAPI_ATTR uint64_t VKAPI_CALL
kk_tramp_GetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetBufferOpaqueCaptureAddress(device, pInfo);
}
    static VKAPI_ATTR VkDeviceAddress VKAPI_CALL
kk_tramp_GetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetBufferDeviceAddress(device, pInfo);
}
                static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_InitializePerformanceApiINTEL(VkDevice device, const VkInitializePerformanceApiInfoINTEL* pInitializeInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.InitializePerformanceApiINTEL(device, pInitializeInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_UninitializePerformanceApiINTEL(VkDevice device)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.UninitializePerformanceApiINTEL(device);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CmdSetPerformanceMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceMarkerInfoINTEL* pMarkerInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.CmdSetPerformanceMarkerINTEL(commandBuffer, pMarkerInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CmdSetPerformanceStreamMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceStreamMarkerInfoINTEL* pMarkerInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.CmdSetPerformanceStreamMarkerINTEL(commandBuffer, pMarkerInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CmdSetPerformanceOverrideINTEL(VkCommandBuffer commandBuffer, const VkPerformanceOverrideInfoINTEL* pOverrideInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.CmdSetPerformanceOverrideINTEL(commandBuffer, pOverrideInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AcquirePerformanceConfigurationINTEL(VkDevice device, const VkPerformanceConfigurationAcquireInfoINTEL* pAcquireInfo, VkPerformanceConfigurationINTEL* pConfiguration)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.AcquirePerformanceConfigurationINTEL(device, pAcquireInfo, pConfiguration);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ReleasePerformanceConfigurationINTEL(VkDevice device, VkPerformanceConfigurationINTEL configuration)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ReleasePerformanceConfigurationINTEL(device, configuration);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_QueueSetPerformanceConfigurationINTEL(VkQueue queue, VkPerformanceConfigurationINTEL configuration)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.QueueSetPerformanceConfigurationINTEL(queue, configuration);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPerformanceParameterINTEL(VkDevice device, VkPerformanceParameterTypeINTEL parameter, VkPerformanceValueINTEL* pValue)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetPerformanceParameterINTEL(device, parameter, pValue);
}
static VKAPI_ATTR uint64_t VKAPI_CALL
kk_tramp_GetDeviceMemoryOpaqueCaptureAddress(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDeviceMemoryOpaqueCaptureAddress(device, pInfo);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPipelineExecutablePropertiesKHR(VkDevice                        device, const VkPipelineInfoKHR*        pPipelineInfo, uint32_t* pExecutableCount, VkPipelineExecutablePropertiesKHR* pProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetPipelineExecutablePropertiesKHR(device, pPipelineInfo, pExecutableCount, pProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPipelineExecutableStatisticsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pStatisticCount, VkPipelineExecutableStatisticKHR* pStatistics)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetPipelineExecutableStatisticsKHR(device, pExecutableInfo, pStatisticCount, pStatistics);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPipelineExecutableInternalRepresentationsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pInternalRepresentationCount, VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetPipelineExecutableInternalRepresentationsKHR(device, pExecutableInfo, pInternalRepresentationCount, pInternalRepresentations);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetLineStipple(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetLineStipple(commandBuffer, lineStippleFactor, lineStipplePattern);
}
                static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateAccelerationStructureKHR(VkDevice                                           device, const VkAccelerationStructureCreateInfoKHR*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkAccelerationStructureKHR*                        pAccelerationStructure)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateAccelerationStructureKHR(device, pCreateInfo, pAllocator, pAccelerationStructure);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBuildAccelerationStructuresKHR(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBuildAccelerationStructuresKHR(commandBuffer, infoCount, pInfos, ppBuildRangeInfos);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBuildAccelerationStructuresIndirectKHR(VkCommandBuffer                  commandBuffer, uint32_t                                           infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkDeviceAddress*             pIndirectDeviceAddresses, const uint32_t*                    pIndirectStrides, const uint32_t* const*             ppMaxPrimitiveCounts)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBuildAccelerationStructuresIndirectKHR(commandBuffer, infoCount, pInfos, pIndirectDeviceAddresses, pIndirectStrides, ppMaxPrimitiveCounts);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BuildAccelerationStructuresKHR(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.BuildAccelerationStructuresKHR(device, deferredOperation, infoCount, pInfos, ppBuildRangeInfos);
}
static VKAPI_ATTR VkDeviceAddress VKAPI_CALL
kk_tramp_GetAccelerationStructureDeviceAddressKHR(VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetAccelerationStructureDeviceAddressKHR(device, pInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateDeferredOperationKHR(VkDevice device, const VkAllocationCallbacks* pAllocator, VkDeferredOperationKHR* pDeferredOperation)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateDeferredOperationKHR(device, pAllocator, pDeferredOperation);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyDeferredOperationKHR(VkDevice device, VkDeferredOperationKHR operation, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyDeferredOperationKHR(device, operation, pAllocator);
}
static VKAPI_ATTR uint32_t VKAPI_CALL
kk_tramp_GetDeferredOperationMaxConcurrencyKHR(VkDevice device, VkDeferredOperationKHR operation)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDeferredOperationMaxConcurrencyKHR(device, operation);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDeferredOperationResultKHR(VkDevice device, VkDeferredOperationKHR operation)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDeferredOperationResultKHR(device, operation);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_DeferredOperationJoinKHR(VkDevice device, VkDeferredOperationKHR operation)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.DeferredOperationJoinKHR(device, operation);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPipelineIndirectMemoryRequirementsNV(VkDevice device, const VkComputePipelineCreateInfo* pCreateInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetPipelineIndirectMemoryRequirementsNV(device, pCreateInfo, pMemoryRequirements);
}
static VKAPI_ATTR VkDeviceAddress VKAPI_CALL
kk_tramp_GetPipelineIndirectDeviceAddressNV(VkDevice device, const VkPipelineIndirectDeviceAddressInfoNV* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetPipelineIndirectDeviceAddressNV(device, pInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_AntiLagUpdateAMD(VkDevice device, const VkAntiLagDataAMD* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.AntiLagUpdateAMD(device, pData);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetCullMode(commandBuffer, cullMode);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetFrontFace(commandBuffer, frontFace);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetPrimitiveTopology(commandBuffer, primitiveTopology);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetViewportWithCount(commandBuffer, viewportCount, pViewports);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetScissorWithCount(commandBuffer, scissorCount, pScissors);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindIndexBuffer2(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindIndexBuffer2(commandBuffer, buffer, offset, size, indexType);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthTestEnable(commandBuffer, depthTestEnable);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthWriteEnable(commandBuffer, depthWriteEnable);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthCompareOp(commandBuffer, depthCompareOp);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthBoundsTestEnable(commandBuffer, depthBoundsTestEnable);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetStencilTestEnable(commandBuffer, stencilTestEnable);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetStencilOp(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetPatchControlPointsEXT(VkCommandBuffer commandBuffer, uint32_t patchControlPoints)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetPatchControlPointsEXT(commandBuffer, patchControlPoints);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetRasterizerDiscardEnable(commandBuffer, rasterizerDiscardEnable);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthBiasEnable(commandBuffer, depthBiasEnable);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetLogicOpEXT(VkCommandBuffer commandBuffer, VkLogicOp logicOp)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetLogicOpEXT(commandBuffer, logicOp);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetPrimitiveRestartEnable(commandBuffer, primitiveRestartEnable);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetTessellationDomainOriginEXT(VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetTessellationDomainOriginEXT(commandBuffer, domainOrigin);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthClampEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClampEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthClampEnableEXT(commandBuffer, depthClampEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetPolygonModeEXT(VkCommandBuffer commandBuffer, VkPolygonMode polygonMode)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetPolygonModeEXT(commandBuffer, polygonMode);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetRasterizationSamplesEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  rasterizationSamples)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetRasterizationSamplesEXT(commandBuffer, rasterizationSamples);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetSampleMaskEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  samples, const VkSampleMask*    pSampleMask)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetSampleMaskEXT(commandBuffer, samples, pSampleMask);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetAlphaToCoverageEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetAlphaToCoverageEnableEXT(commandBuffer, alphaToCoverageEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetAlphaToOneEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetAlphaToOneEnableEXT(commandBuffer, alphaToOneEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetLogicOpEnableEXT(VkCommandBuffer commandBuffer, VkBool32 logicOpEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetLogicOpEnableEXT(commandBuffer, logicOpEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetColorBlendEnableEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetColorBlendEnableEXT(commandBuffer, firstAttachment, attachmentCount, pColorBlendEnables);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetColorBlendEquationEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetColorBlendEquationEXT(commandBuffer, firstAttachment, attachmentCount, pColorBlendEquations);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetColorWriteMaskEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetColorWriteMaskEXT(commandBuffer, firstAttachment, attachmentCount, pColorWriteMasks);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetRasterizationStreamEXT(VkCommandBuffer commandBuffer, uint32_t rasterizationStream)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetRasterizationStreamEXT(commandBuffer, rasterizationStream);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetConservativeRasterizationModeEXT(VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetConservativeRasterizationModeEXT(commandBuffer, conservativeRasterizationMode);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetExtraPrimitiveOverestimationSizeEXT(VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetExtraPrimitiveOverestimationSizeEXT(commandBuffer, extraPrimitiveOverestimationSize);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthClipEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClipEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthClipEnableEXT(commandBuffer, depthClipEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetSampleLocationsEnableEXT(VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetSampleLocationsEnableEXT(commandBuffer, sampleLocationsEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetColorBlendAdvancedEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetColorBlendAdvancedEXT(commandBuffer, firstAttachment, attachmentCount, pColorBlendAdvanced);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetProvokingVertexModeEXT(VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetProvokingVertexModeEXT(commandBuffer, provokingVertexMode);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetLineRasterizationModeEXT(VkCommandBuffer commandBuffer, VkLineRasterizationModeEXT lineRasterizationMode)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetLineRasterizationModeEXT(commandBuffer, lineRasterizationMode);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetLineStippleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetLineStippleEnableEXT(commandBuffer, stippledLineEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthClipNegativeOneToOneEXT(VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthClipNegativeOneToOneEXT(commandBuffer, negativeOneToOne);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetViewportWScalingEnableNV(VkCommandBuffer commandBuffer, VkBool32 viewportWScalingEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetViewportWScalingEnableNV(commandBuffer, viewportWScalingEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetViewportSwizzleNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportSwizzleNV* pViewportSwizzles)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetViewportSwizzleNV(commandBuffer, firstViewport, viewportCount, pViewportSwizzles);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetCoverageToColorEnableNV(VkCommandBuffer commandBuffer, VkBool32 coverageToColorEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetCoverageToColorEnableNV(commandBuffer, coverageToColorEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetCoverageToColorLocationNV(VkCommandBuffer commandBuffer, uint32_t coverageToColorLocation)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetCoverageToColorLocationNV(commandBuffer, coverageToColorLocation);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetCoverageModulationModeNV(VkCommandBuffer commandBuffer, VkCoverageModulationModeNV coverageModulationMode)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetCoverageModulationModeNV(commandBuffer, coverageModulationMode);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetCoverageModulationTableEnableNV(VkCommandBuffer commandBuffer, VkBool32 coverageModulationTableEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetCoverageModulationTableEnableNV(commandBuffer, coverageModulationTableEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetCoverageModulationTableNV(VkCommandBuffer commandBuffer, uint32_t coverageModulationTableCount, const float* pCoverageModulationTable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetCoverageModulationTableNV(commandBuffer, coverageModulationTableCount, pCoverageModulationTable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetShadingRateImageEnableNV(VkCommandBuffer commandBuffer, VkBool32 shadingRateImageEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetShadingRateImageEnableNV(commandBuffer, shadingRateImageEnable);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetCoverageReductionModeNV(VkCommandBuffer commandBuffer, VkCoverageReductionModeNV coverageReductionMode)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetCoverageReductionModeNV(commandBuffer, coverageReductionMode);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetRepresentativeFragmentTestEnableNV(VkCommandBuffer commandBuffer, VkBool32 representativeFragmentTestEnable)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetRepresentativeFragmentTestEnableNV(commandBuffer, representativeFragmentTestEnable);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreatePrivateDataSlot(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreatePrivateDataSlot(device, pCreateInfo, pAllocator, pPrivateDataSlot);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyPrivateDataSlot(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyPrivateDataSlot(device, privateDataSlot, pAllocator);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_SetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.SetPrivateData(device, objectType, objectHandle, privateDataSlot, data);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetPrivateData(device, objectType, objectHandle, privateDataSlot, pData);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyBuffer2(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyBuffer2(commandBuffer, pCopyBufferInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyImage2(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyImage2(commandBuffer, pCopyImageInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBlitImage2(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBlitImage2(commandBuffer, pBlitImageInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyBufferToImage2(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyBufferToImage2(commandBuffer, pCopyBufferToImageInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyImageToBuffer2(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyImageToBuffer2(commandBuffer, pCopyImageToBufferInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdResolveImage2(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdResolveImage2(commandBuffer, pResolveImageInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetFragmentShadingRateKHR(VkCommandBuffer           commandBuffer, const VkExtent2D*                           pFragmentSize, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2])
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetFragmentShadingRateKHR(commandBuffer, pFragmentSize, combinerOps);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetFragmentShadingRateEnumNV(VkCommandBuffer           commandBuffer, VkFragmentShadingRateNV                     shadingRate, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2])
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetFragmentShadingRateEnumNV(commandBuffer, shadingRate, combinerOps);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetAccelerationStructureBuildSizesKHR(VkDevice                                            device, VkAccelerationStructureBuildTypeKHR                 buildType, const VkAccelerationStructureBuildGeometryInfoKHR*  pBuildInfo, const uint32_t*  pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR*           pSizeInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetAccelerationStructureBuildSizesKHR(device, buildType, pBuildInfo, pMaxPrimitiveCounts, pSizeInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetVertexInputEXT(VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetVertexInputEXT(commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetColorWriteEnableEXT(VkCommandBuffer       commandBuffer, uint32_t                                attachmentCount, const VkBool32*   pColorWriteEnables)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetColorWriteEnableEXT(commandBuffer, attachmentCount, pColorWriteEnables);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetEvent2(VkCommandBuffer                   commandBuffer, VkEvent                                             event, const VkDependencyInfo*                             pDependencyInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetEvent2(commandBuffer, event, pDependencyInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdResetEvent2(VkCommandBuffer                   commandBuffer, VkEvent                                             event, VkPipelineStageFlags2               stageMask)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdResetEvent2(commandBuffer, event, stageMask);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdWaitEvents2(VkCommandBuffer                   commandBuffer, uint32_t                                            eventCount, const VkEvent*                     pEvents, const VkDependencyInfo*            pDependencyInfos)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdWaitEvents2(commandBuffer, eventCount, pEvents, pDependencyInfos);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdPipelineBarrier2(VkCommandBuffer                   commandBuffer, const VkDependencyInfo*                             pDependencyInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdPipelineBarrier2(commandBuffer, pDependencyInfo);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_QueueSubmit2(VkQueue                           queue, uint32_t                            submitCount, const VkSubmitInfo2*              pSubmits, VkFence           fence)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.QueueSubmit2(queue, submitCount, pSubmits, fence);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdWriteTimestamp2(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkQueryPool                                         queryPool, uint32_t                                            query)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdWriteTimestamp2(commandBuffer, stage, queryPool, query);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdWriteBufferMarker2AMD(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkBuffer                                            dstBuffer, VkDeviceSize                                        dstOffset, uint32_t                                            marker)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdWriteBufferMarker2AMD(commandBuffer, stage, dstBuffer, dstOffset, marker);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetQueueCheckpointData2NV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointData2NV* pCheckpointData)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.GetQueueCheckpointData2NV(queue, pCheckpointDataCount, pCheckpointData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CopyMemoryToImage(VkDevice device, const VkCopyMemoryToImageInfo*    pCopyMemoryToImageInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CopyMemoryToImage(device, pCopyMemoryToImageInfo);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CopyImageToMemory(VkDevice device, const VkCopyImageToMemoryInfo*    pCopyImageToMemoryInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CopyImageToMemory(device, pCopyImageToMemoryInfo);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CopyImageToImage(VkDevice device, const VkCopyImageToImageInfo*    pCopyImageToImageInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CopyImageToImage(device, pCopyImageToImageInfo);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_TransitionImageLayout(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo*    pTransitions)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.TransitionImageLayout(device, transitionCount, pTransitions);
}
                static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateVideoSessionKHR(VkDevice device, const VkVideoSessionCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionKHR* pVideoSession)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateVideoSessionKHR(device, pCreateInfo, pAllocator, pVideoSession);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyVideoSessionKHR(VkDevice device, VkVideoSessionKHR videoSession, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyVideoSessionKHR(device, videoSession, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateVideoSessionParametersKHR(VkDevice device, const VkVideoSessionParametersCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionParametersKHR* pVideoSessionParameters)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateVideoSessionParametersKHR(device, pCreateInfo, pAllocator, pVideoSessionParameters);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_UpdateVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkVideoSessionParametersUpdateInfoKHR* pUpdateInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.UpdateVideoSessionParametersKHR(device, videoSessionParameters, pUpdateInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetEncodedVideoSessionParametersKHR(VkDevice device, const VkVideoEncodeSessionParametersGetInfoKHR* pVideoSessionParametersInfo, VkVideoEncodeSessionParametersFeedbackInfoKHR* pFeedbackInfo, size_t* pDataSize, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetEncodedVideoSessionParametersKHR(device, pVideoSessionParametersInfo, pFeedbackInfo, pDataSize, pData);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyVideoSessionParametersKHR(device, videoSessionParameters, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetVideoSessionMemoryRequirementsKHR(VkDevice device, VkVideoSessionKHR videoSession, uint32_t* pMemoryRequirementsCount, VkVideoSessionMemoryRequirementsKHR* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetVideoSessionMemoryRequirementsKHR(device, videoSession, pMemoryRequirementsCount, pMemoryRequirements);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BindVideoSessionMemoryKHR(VkDevice device, VkVideoSessionKHR videoSession, uint32_t bindSessionMemoryInfoCount, const VkBindVideoSessionMemoryInfoKHR* pBindSessionMemoryInfos)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.BindVideoSessionMemoryKHR(device, videoSession, bindSessionMemoryInfoCount, pBindSessionMemoryInfos);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDecodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoDecodeInfoKHR* pDecodeInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDecodeVideoKHR(commandBuffer, pDecodeInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBeginVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoBeginCodingInfoKHR* pBeginInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBeginVideoCodingKHR(commandBuffer, pBeginInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdControlVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoCodingControlInfoKHR* pCodingControlInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdControlVideoCodingKHR(commandBuffer, pCodingControlInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEndVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoEndCodingInfoKHR* pEndCodingInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEndVideoCodingKHR(commandBuffer, pEndCodingInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEncodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoEncodeInfoKHR* pEncodeInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEncodeVideoKHR(commandBuffer, pEncodeInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDecompressMemoryNV(VkCommandBuffer commandBuffer, uint32_t decompressRegionCount, const VkDecompressMemoryRegionNV* pDecompressMemoryRegions)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDecompressMemoryNV(commandBuffer, decompressRegionCount, pDecompressMemoryRegions);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDecompressMemoryIndirectCountNV(VkCommandBuffer commandBuffer, VkDeviceAddress indirectCommandsAddress, VkDeviceAddress indirectCommandsCountAddress, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDecompressMemoryIndirectCountNV(commandBuffer, indirectCommandsAddress, indirectCommandsCountAddress, stride);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetPartitionedAccelerationStructuresBuildSizesNV(VkDevice device, const VkPartitionedAccelerationStructureInstancesInputNV* pInfo, VkAccelerationStructureBuildSizesInfoKHR*                  pSizeInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetPartitionedAccelerationStructuresBuildSizesNV(device, pInfo, pSizeInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBuildPartitionedAccelerationStructuresNV(VkCommandBuffer                     commandBuffer, const VkBuildPartitionedAccelerationStructureInfoNV*  pBuildInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBuildPartitionedAccelerationStructuresNV(commandBuffer, pBuildInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDecompressMemoryEXT(VkCommandBuffer commandBuffer, const VkDecompressMemoryInfoEXT* pDecompressMemoryInfoEXT)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDecompressMemoryEXT(commandBuffer, pDecompressMemoryInfoEXT);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDecompressMemoryIndirectCountEXT(VkCommandBuffer commandBuffer, VkMemoryDecompressionMethodFlagsEXT decompressionMethod, VkDeviceAddress indirectCommandsAddress, VkDeviceAddress indirectCommandsCountAddress, uint32_t maxDecompressionCount, uint32_t stride)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDecompressMemoryIndirectCountEXT(commandBuffer, decompressionMethod, indirectCommandsAddress, indirectCommandsCountAddress, maxDecompressionCount, stride);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateCuModuleNVX(VkDevice device, const VkCuModuleCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuModuleNVX* pModule)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateCuModuleNVX(device, pCreateInfo, pAllocator, pModule);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateCuFunctionNVX(VkDevice device, const VkCuFunctionCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuFunctionNVX* pFunction)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateCuFunctionNVX(device, pCreateInfo, pAllocator, pFunction);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyCuModuleNVX(VkDevice device, VkCuModuleNVX module, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyCuModuleNVX(device, module, pAllocator);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyCuFunctionNVX(VkDevice device, VkCuFunctionNVX function, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyCuFunctionNVX(device, function, pAllocator);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCuLaunchKernelNVX(VkCommandBuffer commandBuffer, const VkCuLaunchInfoNVX* pLaunchInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCuLaunchKernelNVX(commandBuffer, pLaunchInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDescriptorSetLayoutSizeEXT(VkDevice device, VkDescriptorSetLayout layout, VkDeviceSize* pLayoutSizeInBytes)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDescriptorSetLayoutSizeEXT(device, layout, pLayoutSizeInBytes);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDescriptorSetLayoutBindingOffsetEXT(VkDevice device, VkDescriptorSetLayout layout, uint32_t binding, VkDeviceSize* pOffset)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDescriptorSetLayoutBindingOffsetEXT(device, layout, binding, pOffset);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDescriptorEXT(VkDevice device, const VkDescriptorGetInfoEXT* pDescriptorInfo, size_t dataSize, void* pDescriptor)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDescriptorEXT(device, pDescriptorInfo, dataSize, pDescriptor);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindDescriptorBuffersEXT(VkCommandBuffer commandBuffer, uint32_t bufferCount, const VkDescriptorBufferBindingInfoEXT* pBindingInfos)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindDescriptorBuffersEXT(commandBuffer, bufferCount, pBindingInfos);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDescriptorBufferOffsetsEXT(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t setCount, const uint32_t* pBufferIndices, const VkDeviceSize* pOffsets)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDescriptorBufferOffsetsEXT(commandBuffer, pipelineBindPoint, layout, firstSet, setCount, pBufferIndices, pOffsets);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindDescriptorBufferEmbeddedSamplersEXT(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindDescriptorBufferEmbeddedSamplersEXT(commandBuffer, pipelineBindPoint, layout, set);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetBufferOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkBufferCaptureDescriptorDataInfoEXT* pInfo, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetBufferOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetImageOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkImageCaptureDescriptorDataInfoEXT* pInfo, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetImageOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetImageViewOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkImageViewCaptureDescriptorDataInfoEXT* pInfo, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetImageViewOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSamplerOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkSamplerCaptureDescriptorDataInfoEXT* pInfo, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSamplerOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetAccelerationStructureOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkAccelerationStructureCaptureDescriptorDataInfoEXT* pInfo, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetAccelerationStructureOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_SetDeviceMemoryPriorityEXT(VkDevice       device, VkDeviceMemory memory, float          priority)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.SetDeviceMemoryPriorityEXT(device, memory, priority);
}
        static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_WaitForPresent2KHR(VkDevice device, VkSwapchainKHR swapchain, const VkPresentWait2InfoKHR* pPresentWait2Info)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.WaitForPresent2KHR(device, swapchain, pPresentWait2Info);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_WaitForPresentKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t presentId, uint64_t timeout)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.WaitForPresentKHR(device, swapchain, presentId, timeout);
}
#ifdef VK_USE_PLATFORM_FUCHSIA
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateBufferCollectionFUCHSIA(VkDevice device, const VkBufferCollectionCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferCollectionFUCHSIA* pCollection)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateBufferCollectionFUCHSIA(device, pCreateInfo, pAllocator, pCollection);
}
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_SetBufferCollectionBufferConstraintsFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkBufferConstraintsInfoFUCHSIA* pBufferConstraintsInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.SetBufferCollectionBufferConstraintsFUCHSIA(device, collection, pBufferConstraintsInfo);
}
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_SetBufferCollectionImageConstraintsFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkImageConstraintsInfoFUCHSIA* pImageConstraintsInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.SetBufferCollectionImageConstraintsFUCHSIA(device, collection, pImageConstraintsInfo);
}
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyBufferCollectionFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyBufferCollectionFUCHSIA(device, collection, pAllocator);
}
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetBufferCollectionPropertiesFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, VkBufferCollectionPropertiesFUCHSIA* pProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetBufferCollectionPropertiesFUCHSIA(device, collection, pProperties);
}
#endif
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBeginRendering(VkCommandBuffer                   commandBuffer, const VkRenderingInfo*                              pRenderingInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBeginRendering(commandBuffer, pRenderingInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEndRendering(VkCommandBuffer                   commandBuffer)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEndRendering(commandBuffer);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEndRendering2KHR(VkCommandBuffer                   commandBuffer, const VkRenderingEndInfoKHR*        pRenderingEndInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEndRendering2KHR(commandBuffer, pRenderingEndInfo);
}
        static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDescriptorSetLayoutHostMappingInfoVALVE(VkDevice device, const VkDescriptorSetBindingReferenceVALVE* pBindingReference, VkDescriptorSetLayoutHostMappingInfoVALVE* pHostMapping)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDescriptorSetLayoutHostMappingInfoVALVE(device, pBindingReference, pHostMapping);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDescriptorSetHostMappingVALVE(VkDevice device, VkDescriptorSet descriptorSet, void** ppData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDescriptorSetHostMappingVALVE(device, descriptorSet, ppData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateMicromapEXT(VkDevice                                           device, const VkMicromapCreateInfoEXT*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkMicromapEXT*                        pMicromap)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateMicromapEXT(device, pCreateInfo, pAllocator, pMicromap);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBuildMicromapsEXT(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBuildMicromapsEXT(commandBuffer, infoCount, pInfos);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BuildMicromapsEXT(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.BuildMicromapsEXT(device, deferredOperation, infoCount, pInfos);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyMicromapEXT(VkDevice device, VkMicromapEXT micromap, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyMicromapEXT(device, micromap, pAllocator);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyMicromapEXT(VkCommandBuffer commandBuffer, const VkCopyMicromapInfoEXT* pInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyMicromapEXT(commandBuffer, pInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CopyMicromapEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapInfoEXT* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CopyMicromapEXT(device, deferredOperation, pInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyMicromapToMemoryEXT(VkCommandBuffer commandBuffer, const VkCopyMicromapToMemoryInfoEXT* pInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyMicromapToMemoryEXT(commandBuffer, pInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CopyMicromapToMemoryEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapToMemoryInfoEXT* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CopyMicromapToMemoryEXT(device, deferredOperation, pInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyMemoryToMicromapEXT(VkCommandBuffer commandBuffer, const VkCopyMemoryToMicromapInfoEXT* pInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyMemoryToMicromapEXT(commandBuffer, pInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CopyMemoryToMicromapEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToMicromapInfoEXT* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CopyMemoryToMicromapEXT(device, deferredOperation, pInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdWriteMicromapsPropertiesEXT(VkCommandBuffer commandBuffer, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdWriteMicromapsPropertiesEXT(commandBuffer, micromapCount, pMicromaps, queryType, queryPool, firstQuery);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_WriteMicromapsPropertiesEXT(VkDevice device, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.WriteMicromapsPropertiesEXT(device, micromapCount, pMicromaps, queryType, dataSize, pData, stride);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDeviceMicromapCompatibilityEXT(VkDevice device, const VkMicromapVersionInfoEXT* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDeviceMicromapCompatibilityEXT(device, pVersionInfo, pCompatibility);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetMicromapBuildSizesEXT(VkDevice                                            device, VkAccelerationStructureBuildTypeKHR                 buildType, const VkMicromapBuildInfoEXT*  pBuildInfo, VkMicromapBuildSizesInfoEXT*           pSizeInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetMicromapBuildSizesEXT(device, buildType, pBuildInfo, pSizeInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetShaderModuleIdentifierEXT(VkDevice device, VkShaderModule shaderModule, VkShaderModuleIdentifierEXT* pIdentifier)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetShaderModuleIdentifierEXT(device, shaderModule, pIdentifier);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetShaderModuleCreateInfoIdentifierEXT(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, VkShaderModuleIdentifierEXT* pIdentifier)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetShaderModuleCreateInfoIdentifierEXT(device, pCreateInfo, pIdentifier);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetImageSubresourceLayout2(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetImageSubresourceLayout2(device, image, pSubresource, pLayout);
}
        static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPipelinePropertiesEXT(VkDevice device, const VkPipelineInfoEXT* pPipelineInfo, VkBaseOutStructure* pPipelineProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetPipelinePropertiesEXT(device, pPipelineInfo, pPipelineProperties);
}
#ifdef VK_USE_PLATFORM_METAL_EXT
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_ExportMetalObjectsEXT(VkDevice device, VkExportMetalObjectsInfoEXT* pMetalObjectsInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.ExportMetalObjectsEXT(device, pMetalObjectsInfo);
}
#endif
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindTileMemoryQCOM(VkCommandBuffer commandBuffer, const VkTileMemoryBindInfoQCOM* pTileMemoryBindInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindTileMemoryQCOM(commandBuffer, pTileMemoryBindInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetFramebufferTilePropertiesQCOM(VkDevice device, VkFramebuffer framebuffer, uint32_t* pPropertiesCount, VkTilePropertiesQCOM* pProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetFramebufferTilePropertiesQCOM(device, framebuffer, pPropertiesCount, pProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDynamicRenderingTilePropertiesQCOM(VkDevice device, const VkRenderingInfo* pRenderingInfo, VkTilePropertiesQCOM* pProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDynamicRenderingTilePropertiesQCOM(device, pRenderingInfo, pProperties);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateOpticalFlowSessionNV(VkDevice device, const VkOpticalFlowSessionCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkOpticalFlowSessionNV* pSession)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateOpticalFlowSessionNV(device, pCreateInfo, pAllocator, pSession);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyOpticalFlowSessionNV(VkDevice device, VkOpticalFlowSessionNV session, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyOpticalFlowSessionNV(device, session, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BindOpticalFlowSessionImageNV(VkDevice device, VkOpticalFlowSessionNV session, VkOpticalFlowSessionBindingPointNV bindingPoint, VkImageView view, VkImageLayout layout)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.BindOpticalFlowSessionImageNV(device, session, bindingPoint, view, layout);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdOpticalFlowExecuteNV(VkCommandBuffer commandBuffer, VkOpticalFlowSessionNV session, const VkOpticalFlowExecuteInfoNV* pExecuteInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdOpticalFlowExecuteNV(commandBuffer, session, pExecuteInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDeviceFaultInfoEXT(VkDevice device, VkDeviceFaultCountsEXT* pFaultCounts, VkDeviceFaultInfoEXT* pFaultInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDeviceFaultInfoEXT(device, pFaultCounts, pFaultInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthBias2EXT(VkCommandBuffer commandBuffer, const VkDepthBiasInfoEXT*         pDepthBiasInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthBias2EXT(commandBuffer, pDepthBiasInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ReleaseSwapchainImagesKHR(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ReleaseSwapchainImagesKHR(device, pReleaseInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDeviceImageSubresourceLayout(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDeviceImageSubresourceLayout(device, pInfo, pLayout);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_MapMemory2(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.MapMemory2(device, pMemoryMapInfo, ppData);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_UnmapMemory2(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.UnmapMemory2(device, pMemoryUnmapInfo);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateShadersEXT(VkDevice device, uint32_t createInfoCount, const VkShaderCreateInfoEXT* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkShaderEXT* pShaders)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateShadersEXT(device, createInfoCount, pCreateInfos, pAllocator, pShaders);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyShaderEXT(VkDevice device, VkShaderEXT shader, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyShaderEXT(device, shader, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetShaderBinaryDataEXT(VkDevice device, VkShaderEXT shader, size_t* pDataSize, void* pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetShaderBinaryDataEXT(device, shader, pDataSize, pData);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindShadersEXT(VkCommandBuffer commandBuffer, uint32_t stageCount, const VkShaderStageFlagBits* pStages, const VkShaderEXT* pShaders)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindShadersEXT(commandBuffer, stageCount, pStages, pShaders);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_SetSwapchainPresentTimingQueueSizeEXT(VkDevice device, VkSwapchainKHR swapchain, uint32_t size)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.SetSwapchainPresentTimingQueueSizeEXT(device, swapchain, size);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSwapchainTimingPropertiesEXT(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimingPropertiesEXT* pSwapchainTimingProperties, uint64_t* pSwapchainTimingPropertiesCounter)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSwapchainTimingPropertiesEXT(device, swapchain, pSwapchainTimingProperties, pSwapchainTimingPropertiesCounter);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSwapchainTimeDomainPropertiesEXT(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimeDomainPropertiesEXT* pSwapchainTimeDomainProperties, uint64_t* pTimeDomainsCounter)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSwapchainTimeDomainPropertiesEXT(device, swapchain, pSwapchainTimeDomainProperties, pTimeDomainsCounter);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetPastPresentationTimingEXT(VkDevice device, const VkPastPresentationTimingInfoEXT* pPastPresentationTimingInfo, VkPastPresentationTimingPropertiesEXT* pPastPresentationTimingProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetPastPresentationTimingEXT(device, pPastPresentationTimingInfo, pPastPresentationTimingProperties);
}
#ifdef VK_USE_PLATFORM_SCREEN_QNX
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetScreenBufferPropertiesQNX(VkDevice device, const struct _screen_buffer* buffer, VkScreenBufferPropertiesQNX* pProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetScreenBufferPropertiesQNX(device, buffer, pProperties);
}
#endif
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindDescriptorSets2(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo*   pBindDescriptorSetsInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindDescriptorSets2(commandBuffer, pBindDescriptorSetsInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdPushConstants2(VkCommandBuffer commandBuffer, const VkPushConstantsInfo*        pPushConstantsInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdPushConstants2(commandBuffer, pPushConstantsInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdPushDescriptorSet2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo*    pPushDescriptorSetInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdPushDescriptorSet2(commandBuffer, pPushDescriptorSetInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdPushDescriptorSetWithTemplate2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdPushDescriptorSetWithTemplate2(commandBuffer, pPushDescriptorSetWithTemplateInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDescriptorBufferOffsets2EXT(VkCommandBuffer commandBuffer, const VkSetDescriptorBufferOffsetsInfoEXT* pSetDescriptorBufferOffsetsInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDescriptorBufferOffsets2EXT(commandBuffer, pSetDescriptorBufferOffsetsInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBindDescriptorBufferEmbeddedSamplers2EXT(VkCommandBuffer commandBuffer, const VkBindDescriptorBufferEmbeddedSamplersInfoEXT* pBindDescriptorBufferEmbeddedSamplersInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBindDescriptorBufferEmbeddedSamplers2EXT(commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_SetLatencySleepModeNV(VkDevice device, VkSwapchainKHR swapchain, const VkLatencySleepModeInfoNV* pSleepModeInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.SetLatencySleepModeNV(device, swapchain, pSleepModeInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_LatencySleepNV(VkDevice device, VkSwapchainKHR swapchain, const VkLatencySleepInfoNV* pSleepInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.LatencySleepNV(device, swapchain, pSleepInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_SetLatencyMarkerNV(VkDevice device, VkSwapchainKHR swapchain, const VkSetLatencyMarkerInfoNV* pLatencyMarkerInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.SetLatencyMarkerNV(device, swapchain, pLatencyMarkerInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetLatencyTimingsNV(VkDevice device, VkSwapchainKHR swapchain, VkGetLatencyMarkerInfoNV* pLatencyMarkerInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetLatencyTimingsNV(device, swapchain, pLatencyMarkerInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_QueueNotifyOutOfBandNV(VkQueue queue, const VkOutOfBandQueueTypeInfoNV* pQueueTypeInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.QueueNotifyOutOfBandNV(queue, pQueueTypeInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetRenderingAttachmentLocations(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetRenderingAttachmentLocations(commandBuffer, pLocationInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetRenderingInputAttachmentIndices(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetRenderingInputAttachmentIndices(commandBuffer, pInputAttachmentIndexInfo);
}
    static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdSetDepthClampRangeEXT(VkCommandBuffer commandBuffer, VkDepthClampModeEXT depthClampMode, const VkDepthClampRangeEXT* pDepthClampRange)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdSetDepthClampRangeEXT(commandBuffer, depthClampMode, pDepthClampRange);
}
    #ifdef VK_USE_PLATFORM_METAL_EXT
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryMetalHandleEXT(VkDevice device, const VkMemoryGetMetalHandleInfoEXT* pGetMetalHandleInfo, void** pHandle)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryMetalHandleEXT(device, pGetMetalHandleInfo, pHandle);
}
#endif
#ifdef VK_USE_PLATFORM_METAL_EXT
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryMetalHandlePropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHandle, VkMemoryMetalHandlePropertiesEXT* pMemoryMetalHandleProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryMetalHandlePropertiesEXT(device, handleType, pHandle, pMemoryMetalHandleProperties);
}
#endif
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_ConvertCooperativeVectorMatrixNV(VkDevice device, const VkConvertCooperativeVectorMatrixInfoNV* pInfo)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.ConvertCooperativeVectorMatrixNV(device, pInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdConvertCooperativeVectorMatrixNV(VkCommandBuffer commandBuffer, uint32_t infoCount, const VkConvertCooperativeVectorMatrixInfoNV* pInfos)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdConvertCooperativeVectorMatrixNV(commandBuffer, infoCount, pInfos);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDispatchTileQCOM(VkCommandBuffer commandBuffer, const VkDispatchTileInfoQCOM* pDispatchTileInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDispatchTileQCOM(commandBuffer, pDispatchTileInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdBeginPerTileExecutionQCOM(VkCommandBuffer commandBuffer, const VkPerTileBeginInfoQCOM* pPerTileBeginInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdBeginPerTileExecutionQCOM(commandBuffer, pPerTileBeginInfo);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdEndPerTileExecutionQCOM(VkCommandBuffer commandBuffer, const VkPerTileEndInfoQCOM* pPerTileEndInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdEndPerTileExecutionQCOM(commandBuffer, pPerTileEndInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateExternalComputeQueueNV(VkDevice device, const VkExternalComputeQueueCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkExternalComputeQueueNV* pExternalQueue)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateExternalComputeQueueNV(device, pCreateInfo, pAllocator, pExternalQueue);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyExternalComputeQueueNV(VkDevice device, VkExternalComputeQueueNV externalQueue, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyExternalComputeQueueNV(device, externalQueue, pAllocator);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateTensorARM(VkDevice device, const VkTensorCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorARM* pTensor)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateTensorARM(device, pCreateInfo, pAllocator, pTensor);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyTensorARM(VkDevice device, VkTensorARM tensor, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyTensorARM(device, tensor, pAllocator);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateTensorViewARM(VkDevice device, const VkTensorViewCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorViewARM* pView)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateTensorViewARM(device, pCreateInfo, pAllocator, pView);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyTensorViewARM(VkDevice device, VkTensorViewARM tensorView, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyTensorViewARM(device, tensorView, pAllocator);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetTensorMemoryRequirementsARM(VkDevice device, const VkTensorMemoryRequirementsInfoARM* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetTensorMemoryRequirementsARM(device, pInfo, pMemoryRequirements);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BindTensorMemoryARM(VkDevice device, uint32_t bindInfoCount, const VkBindTensorMemoryInfoARM* pBindInfos)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.BindTensorMemoryARM(device, bindInfoCount, pBindInfos);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDeviceTensorMemoryRequirementsARM(VkDevice device, const VkDeviceTensorMemoryRequirementsARM* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDeviceTensorMemoryRequirementsARM(device, pInfo, pMemoryRequirements);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdCopyTensorARM(VkCommandBuffer commandBuffer, const VkCopyTensorInfoARM* pCopyTensorInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdCopyTensorARM(commandBuffer, pCopyTensorInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetTensorOpaqueCaptureDescriptorDataARM(VkDevice                                    device, const VkTensorCaptureDescriptorDataInfoARM* pInfo, void*                                       pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetTensorOpaqueCaptureDescriptorDataARM(device, pInfo, pData);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetTensorViewOpaqueCaptureDescriptorDataARM(VkDevice                                        device, const VkTensorViewCaptureDescriptorDataInfoARM* pInfo, void*                                           pData)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetTensorViewOpaqueCaptureDescriptorDataARM(device, pInfo, pData);
}
    static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateDataGraphPipelinesARM(VkDevice               device, VkDeferredOperationKHR deferredOperation, VkPipelineCache        pipelineCache, uint32_t               createInfoCount, const VkDataGraphPipelineCreateInfoARM* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline*     pPipelines)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateDataGraphPipelinesARM(device, deferredOperation, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_CreateDataGraphPipelineSessionARM(VkDevice                                     device, const VkDataGraphPipelineSessionCreateInfoARM*   pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDataGraphPipelineSessionARM*                   pSession)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.CreateDataGraphPipelineSessionARM(device, pCreateInfo, pAllocator, pSession);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDataGraphPipelineSessionBindPointRequirementsARM(VkDevice device, const VkDataGraphPipelineSessionBindPointRequirementsInfoARM* pInfo, uint32_t* pBindPointRequirementCount, VkDataGraphPipelineSessionBindPointRequirementARM* pBindPointRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDataGraphPipelineSessionBindPointRequirementsARM(device, pInfo, pBindPointRequirementCount, pBindPointRequirements);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_GetDataGraphPipelineSessionMemoryRequirementsARM(VkDevice device, const VkDataGraphPipelineSessionMemoryRequirementsInfoARM* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.GetDataGraphPipelineSessionMemoryRequirementsARM(device, pInfo, pMemoryRequirements);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_BindDataGraphPipelineSessionMemoryARM(VkDevice device, uint32_t bindInfoCount, const VkBindDataGraphPipelineSessionMemoryInfoARM* pBindInfos)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.BindDataGraphPipelineSessionMemoryARM(device, bindInfoCount, pBindInfos);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_DestroyDataGraphPipelineSessionARM(VkDevice device, VkDataGraphPipelineSessionARM session, const VkAllocationCallbacks* pAllocator)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    kk_device->exposed_dispatch_table.DestroyDataGraphPipelineSessionARM(device, session, pAllocator);
}
static VKAPI_ATTR void VKAPI_CALL
kk_tramp_CmdDispatchDataGraphARM(VkCommandBuffer commandBuffer, VkDataGraphPipelineSessionARM session, const VkDataGraphPipelineDispatchInfoARM* pInfo)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)commandBuffer;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    kk_device->exposed_dispatch_table.CmdDispatchDataGraphARM(commandBuffer, session, pInfo);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDataGraphPipelineAvailablePropertiesARM(VkDevice device, const VkDataGraphPipelineInfoARM* pPipelineInfo, uint32_t* pPropertiesCount, VkDataGraphPipelinePropertyARM* pProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDataGraphPipelineAvailablePropertiesARM(device, pPipelineInfo, pPropertiesCount, pProperties);
}
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetDataGraphPipelinePropertiesARM(VkDevice                          device, const VkDataGraphPipelineInfoARM* pPipelineInfo, uint32_t                          propertiesCount, VkDataGraphPipelinePropertyQueryResultARM* pProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetDataGraphPipelinePropertiesARM(device, pPipelineInfo, propertiesCount, pProperties);
}
        #ifdef VK_USE_PLATFORM_OHOS
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetNativeBufferPropertiesOHOS(VkDevice device, const struct OH_NativeBuffer* buffer, VkNativeBufferPropertiesOHOS* pProperties)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetNativeBufferPropertiesOHOS(device, buffer, pProperties);
}
#endif
#ifdef VK_USE_PLATFORM_OHOS
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetMemoryNativeBufferOHOS(VkDevice device, const VkMemoryGetNativeBufferInfoOHOS* pInfo, struct OH_NativeBuffer** pBuffer)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetMemoryNativeBufferOHOS(device, pInfo, pBuffer);
}
#endif
#ifdef VK_USE_PLATFORM_OHOS
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_GetSwapchainGrallocUsageOHOS(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, uint64_t* grallocUsage)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.GetSwapchainGrallocUsageOHOS(device, format, imageUsage, grallocUsage);
}
#endif
#ifdef VK_USE_PLATFORM_OHOS
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_AcquireImageOHOS(VkDevice device, VkImage image, int32_t nativeFenceFd, VkSemaphore semaphore, VkFence fence)
{
    VK_FROM_HANDLE(kk_device, kk_device, device);
    return kk_device->exposed_dispatch_table.AcquireImageOHOS(device, image, nativeFenceFd, semaphore, fence);
}
#endif
#ifdef VK_USE_PLATFORM_OHOS
static VKAPI_ATTR VkResult VKAPI_CALL
kk_tramp_QueueSignalReleaseImageOHOS(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int32_t* pNativeFenceFd)
{
    struct vk_object_base *vk_object = (struct vk_object_base *)queue;
    struct kk_device *kk_device = container_of(vk_object->device, struct kk_device, vk);
    return kk_device->exposed_dispatch_table.QueueSignalReleaseImageOHOS(queue, waitSemaphoreCount, pWaitSemaphores, image, pNativeFenceFd);
}
#endif
    
struct vk_device_dispatch_table kk_device_trampolines = {
                .GetDeviceProcAddr = kk_tramp_GetDeviceProcAddr,
                                    .DestroyDevice = kk_tramp_DestroyDevice,
                        .GetDeviceQueue = kk_tramp_GetDeviceQueue,
    .QueueSubmit = kk_tramp_QueueSubmit,
    .QueueWaitIdle = kk_tramp_QueueWaitIdle,
    .DeviceWaitIdle = kk_tramp_DeviceWaitIdle,
    .AllocateMemory = kk_tramp_AllocateMemory,
    .FreeMemory = kk_tramp_FreeMemory,
    .MapMemory = kk_tramp_MapMemory,
    .UnmapMemory = kk_tramp_UnmapMemory,
    .FlushMappedMemoryRanges = kk_tramp_FlushMappedMemoryRanges,
    .InvalidateMappedMemoryRanges = kk_tramp_InvalidateMappedMemoryRanges,
    .GetDeviceMemoryCommitment = kk_tramp_GetDeviceMemoryCommitment,
    .GetBufferMemoryRequirements = kk_tramp_GetBufferMemoryRequirements,
    .BindBufferMemory = kk_tramp_BindBufferMemory,
    .GetImageMemoryRequirements = kk_tramp_GetImageMemoryRequirements,
    .BindImageMemory = kk_tramp_BindImageMemory,
    .GetImageSparseMemoryRequirements = kk_tramp_GetImageSparseMemoryRequirements,
        .QueueBindSparse = kk_tramp_QueueBindSparse,
    .CreateFence = kk_tramp_CreateFence,
    .DestroyFence = kk_tramp_DestroyFence,
    .ResetFences = kk_tramp_ResetFences,
    .GetFenceStatus = kk_tramp_GetFenceStatus,
    .WaitForFences = kk_tramp_WaitForFences,
    .CreateSemaphore = kk_tramp_CreateSemaphore,
    .DestroySemaphore = kk_tramp_DestroySemaphore,
    .CreateEvent = kk_tramp_CreateEvent,
    .DestroyEvent = kk_tramp_DestroyEvent,
    .GetEventStatus = kk_tramp_GetEventStatus,
    .SetEvent = kk_tramp_SetEvent,
    .ResetEvent = kk_tramp_ResetEvent,
    .CreateQueryPool = kk_tramp_CreateQueryPool,
    .DestroyQueryPool = kk_tramp_DestroyQueryPool,
    .GetQueryPoolResults = kk_tramp_GetQueryPoolResults,
    .ResetQueryPool = kk_tramp_ResetQueryPool,
        .CreateBuffer = kk_tramp_CreateBuffer,
    .DestroyBuffer = kk_tramp_DestroyBuffer,
    .CreateBufferView = kk_tramp_CreateBufferView,
    .DestroyBufferView = kk_tramp_DestroyBufferView,
    .CreateImage = kk_tramp_CreateImage,
    .DestroyImage = kk_tramp_DestroyImage,
    .GetImageSubresourceLayout = kk_tramp_GetImageSubresourceLayout,
    .CreateImageView = kk_tramp_CreateImageView,
    .DestroyImageView = kk_tramp_DestroyImageView,
    .CreateShaderModule = kk_tramp_CreateShaderModule,
    .DestroyShaderModule = kk_tramp_DestroyShaderModule,
    .CreatePipelineCache = kk_tramp_CreatePipelineCache,
    .DestroyPipelineCache = kk_tramp_DestroyPipelineCache,
    .GetPipelineCacheData = kk_tramp_GetPipelineCacheData,
    .MergePipelineCaches = kk_tramp_MergePipelineCaches,
    .CreatePipelineBinariesKHR = kk_tramp_CreatePipelineBinariesKHR,
    .DestroyPipelineBinaryKHR = kk_tramp_DestroyPipelineBinaryKHR,
    .GetPipelineKeyKHR = kk_tramp_GetPipelineKeyKHR,
    .GetPipelineBinaryDataKHR = kk_tramp_GetPipelineBinaryDataKHR,
    .ReleaseCapturedPipelineDataKHR = kk_tramp_ReleaseCapturedPipelineDataKHR,
    .CreateGraphicsPipelines = kk_tramp_CreateGraphicsPipelines,
    .CreateComputePipelines = kk_tramp_CreateComputePipelines,
    .GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI = kk_tramp_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI,
    .DestroyPipeline = kk_tramp_DestroyPipeline,
    .CreatePipelineLayout = kk_tramp_CreatePipelineLayout,
    .DestroyPipelineLayout = kk_tramp_DestroyPipelineLayout,
    .CreateSampler = kk_tramp_CreateSampler,
    .DestroySampler = kk_tramp_DestroySampler,
    .CreateDescriptorSetLayout = kk_tramp_CreateDescriptorSetLayout,
    .DestroyDescriptorSetLayout = kk_tramp_DestroyDescriptorSetLayout,
    .CreateDescriptorPool = kk_tramp_CreateDescriptorPool,
    .DestroyDescriptorPool = kk_tramp_DestroyDescriptorPool,
    .ResetDescriptorPool = kk_tramp_ResetDescriptorPool,
    .AllocateDescriptorSets = kk_tramp_AllocateDescriptorSets,
    .FreeDescriptorSets = kk_tramp_FreeDescriptorSets,
    .UpdateDescriptorSets = kk_tramp_UpdateDescriptorSets,
    .CreateFramebuffer = kk_tramp_CreateFramebuffer,
    .DestroyFramebuffer = kk_tramp_DestroyFramebuffer,
    .CreateRenderPass = kk_tramp_CreateRenderPass,
    .DestroyRenderPass = kk_tramp_DestroyRenderPass,
    .GetRenderAreaGranularity = kk_tramp_GetRenderAreaGranularity,
    .GetRenderingAreaGranularity = kk_tramp_GetRenderingAreaGranularity,
        .CreateCommandPool = kk_tramp_CreateCommandPool,
    .DestroyCommandPool = kk_tramp_DestroyCommandPool,
    .ResetCommandPool = kk_tramp_ResetCommandPool,
    .AllocateCommandBuffers = kk_tramp_AllocateCommandBuffers,
    .FreeCommandBuffers = kk_tramp_FreeCommandBuffers,
    .BeginCommandBuffer = kk_tramp_BeginCommandBuffer,
    .EndCommandBuffer = kk_tramp_EndCommandBuffer,
    .ResetCommandBuffer = kk_tramp_ResetCommandBuffer,
    .CmdBindPipeline = kk_tramp_CmdBindPipeline,
    .CmdSetAttachmentFeedbackLoopEnableEXT = kk_tramp_CmdSetAttachmentFeedbackLoopEnableEXT,
    .CmdSetViewport = kk_tramp_CmdSetViewport,
    .CmdSetScissor = kk_tramp_CmdSetScissor,
    .CmdSetLineWidth = kk_tramp_CmdSetLineWidth,
    .CmdSetDepthBias = kk_tramp_CmdSetDepthBias,
    .CmdSetBlendConstants = kk_tramp_CmdSetBlendConstants,
    .CmdSetDepthBounds = kk_tramp_CmdSetDepthBounds,
    .CmdSetStencilCompareMask = kk_tramp_CmdSetStencilCompareMask,
    .CmdSetStencilWriteMask = kk_tramp_CmdSetStencilWriteMask,
    .CmdSetStencilReference = kk_tramp_CmdSetStencilReference,
    .CmdBindDescriptorSets = kk_tramp_CmdBindDescriptorSets,
    .CmdBindIndexBuffer = kk_tramp_CmdBindIndexBuffer,
    .CmdBindVertexBuffers = kk_tramp_CmdBindVertexBuffers,
    .CmdDraw = kk_tramp_CmdDraw,
    .CmdDrawIndexed = kk_tramp_CmdDrawIndexed,
    .CmdDrawMultiEXT = kk_tramp_CmdDrawMultiEXT,
    .CmdDrawMultiIndexedEXT = kk_tramp_CmdDrawMultiIndexedEXT,
    .CmdDrawIndirect = kk_tramp_CmdDrawIndirect,
    .CmdDrawIndexedIndirect = kk_tramp_CmdDrawIndexedIndirect,
    .CmdDispatch = kk_tramp_CmdDispatch,
    .CmdDispatchIndirect = kk_tramp_CmdDispatchIndirect,
    .CmdSubpassShadingHUAWEI = kk_tramp_CmdSubpassShadingHUAWEI,
    .CmdDrawClusterHUAWEI = kk_tramp_CmdDrawClusterHUAWEI,
    .CmdDrawClusterIndirectHUAWEI = kk_tramp_CmdDrawClusterIndirectHUAWEI,
    .CmdUpdatePipelineIndirectBufferNV = kk_tramp_CmdUpdatePipelineIndirectBufferNV,
    .CmdCopyBuffer = kk_tramp_CmdCopyBuffer,
    .CmdCopyImage = kk_tramp_CmdCopyImage,
    .CmdBlitImage = kk_tramp_CmdBlitImage,
    .CmdCopyBufferToImage = kk_tramp_CmdCopyBufferToImage,
    .CmdCopyImageToBuffer = kk_tramp_CmdCopyImageToBuffer,
    .CmdCopyMemoryIndirectNV = kk_tramp_CmdCopyMemoryIndirectNV,
    .CmdCopyMemoryIndirectKHR = kk_tramp_CmdCopyMemoryIndirectKHR,
    .CmdCopyMemoryToImageIndirectNV = kk_tramp_CmdCopyMemoryToImageIndirectNV,
    .CmdCopyMemoryToImageIndirectKHR = kk_tramp_CmdCopyMemoryToImageIndirectKHR,
    .CmdUpdateBuffer = kk_tramp_CmdUpdateBuffer,
    .CmdFillBuffer = kk_tramp_CmdFillBuffer,
    .CmdClearColorImage = kk_tramp_CmdClearColorImage,
    .CmdClearDepthStencilImage = kk_tramp_CmdClearDepthStencilImage,
    .CmdClearAttachments = kk_tramp_CmdClearAttachments,
    .CmdResolveImage = kk_tramp_CmdResolveImage,
    .CmdSetEvent = kk_tramp_CmdSetEvent,
    .CmdResetEvent = kk_tramp_CmdResetEvent,
    .CmdWaitEvents = kk_tramp_CmdWaitEvents,
    .CmdPipelineBarrier = kk_tramp_CmdPipelineBarrier,
    .CmdBeginQuery = kk_tramp_CmdBeginQuery,
    .CmdEndQuery = kk_tramp_CmdEndQuery,
    .CmdBeginConditionalRenderingEXT = kk_tramp_CmdBeginConditionalRenderingEXT,
    .CmdEndConditionalRenderingEXT = kk_tramp_CmdEndConditionalRenderingEXT,
    .CmdBeginCustomResolveEXT = kk_tramp_CmdBeginCustomResolveEXT,
    .CmdResetQueryPool = kk_tramp_CmdResetQueryPool,
    .CmdWriteTimestamp = kk_tramp_CmdWriteTimestamp,
    .CmdCopyQueryPoolResults = kk_tramp_CmdCopyQueryPoolResults,
    .CmdPushConstants = kk_tramp_CmdPushConstants,
    .CmdBeginRenderPass = kk_tramp_CmdBeginRenderPass,
    .CmdNextSubpass = kk_tramp_CmdNextSubpass,
    .CmdEndRenderPass = kk_tramp_CmdEndRenderPass,
    .CmdExecuteCommands = kk_tramp_CmdExecuteCommands,
                                        .CreateSharedSwapchainsKHR = kk_tramp_CreateSharedSwapchainsKHR,
                        .CreateSwapchainKHR = kk_tramp_CreateSwapchainKHR,
    .DestroySwapchainKHR = kk_tramp_DestroySwapchainKHR,
    .GetSwapchainImagesKHR = kk_tramp_GetSwapchainImagesKHR,
    .AcquireNextImageKHR = kk_tramp_AcquireNextImageKHR,
    .QueuePresentKHR = kk_tramp_QueuePresentKHR,
                                                                            .DebugMarkerSetObjectNameEXT = kk_tramp_DebugMarkerSetObjectNameEXT,
    .DebugMarkerSetObjectTagEXT = kk_tramp_DebugMarkerSetObjectTagEXT,
    .CmdDebugMarkerBeginEXT = kk_tramp_CmdDebugMarkerBeginEXT,
    .CmdDebugMarkerEndEXT = kk_tramp_CmdDebugMarkerEndEXT,
    .CmdDebugMarkerInsertEXT = kk_tramp_CmdDebugMarkerInsertEXT,
    #ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetMemoryWin32HandleNV = kk_tramp_GetMemoryWin32HandleNV,
#endif
    .CmdExecuteGeneratedCommandsNV = kk_tramp_CmdExecuteGeneratedCommandsNV,
    .CmdPreprocessGeneratedCommandsNV = kk_tramp_CmdPreprocessGeneratedCommandsNV,
    .CmdBindPipelineShaderGroupNV = kk_tramp_CmdBindPipelineShaderGroupNV,
    .GetGeneratedCommandsMemoryRequirementsNV = kk_tramp_GetGeneratedCommandsMemoryRequirementsNV,
    .CreateIndirectCommandsLayoutNV = kk_tramp_CreateIndirectCommandsLayoutNV,
    .DestroyIndirectCommandsLayoutNV = kk_tramp_DestroyIndirectCommandsLayoutNV,
    .CmdExecuteGeneratedCommandsEXT = kk_tramp_CmdExecuteGeneratedCommandsEXT,
    .CmdPreprocessGeneratedCommandsEXT = kk_tramp_CmdPreprocessGeneratedCommandsEXT,
    .GetGeneratedCommandsMemoryRequirementsEXT = kk_tramp_GetGeneratedCommandsMemoryRequirementsEXT,
    .CreateIndirectCommandsLayoutEXT = kk_tramp_CreateIndirectCommandsLayoutEXT,
    .DestroyIndirectCommandsLayoutEXT = kk_tramp_DestroyIndirectCommandsLayoutEXT,
    .CreateIndirectExecutionSetEXT = kk_tramp_CreateIndirectExecutionSetEXT,
    .DestroyIndirectExecutionSetEXT = kk_tramp_DestroyIndirectExecutionSetEXT,
    .UpdateIndirectExecutionSetPipelineEXT = kk_tramp_UpdateIndirectExecutionSetPipelineEXT,
    .UpdateIndirectExecutionSetShaderEXT = kk_tramp_UpdateIndirectExecutionSetShaderEXT,
                                                            .CmdPushDescriptorSet = kk_tramp_CmdPushDescriptorSet,
        .TrimCommandPool = kk_tramp_TrimCommandPool,
            #ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetMemoryWin32HandleKHR = kk_tramp_GetMemoryWin32HandleKHR,
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetMemoryWin32HandlePropertiesKHR = kk_tramp_GetMemoryWin32HandlePropertiesKHR,
#endif
    .GetMemoryFdKHR = kk_tramp_GetMemoryFdKHR,
    .GetMemoryFdPropertiesKHR = kk_tramp_GetMemoryFdPropertiesKHR,
#ifdef VK_USE_PLATFORM_FUCHSIA
    .GetMemoryZirconHandleFUCHSIA = kk_tramp_GetMemoryZirconHandleFUCHSIA,
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
    .GetMemoryZirconHandlePropertiesFUCHSIA = kk_tramp_GetMemoryZirconHandlePropertiesFUCHSIA,
#endif
    .GetMemoryRemoteAddressNV = kk_tramp_GetMemoryRemoteAddressNV,
        #ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetSemaphoreWin32HandleKHR = kk_tramp_GetSemaphoreWin32HandleKHR,
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .ImportSemaphoreWin32HandleKHR = kk_tramp_ImportSemaphoreWin32HandleKHR,
#endif
    .GetSemaphoreFdKHR = kk_tramp_GetSemaphoreFdKHR,
    .ImportSemaphoreFdKHR = kk_tramp_ImportSemaphoreFdKHR,
#ifdef VK_USE_PLATFORM_FUCHSIA
    .GetSemaphoreZirconHandleFUCHSIA = kk_tramp_GetSemaphoreZirconHandleFUCHSIA,
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
    .ImportSemaphoreZirconHandleFUCHSIA = kk_tramp_ImportSemaphoreZirconHandleFUCHSIA,
#endif
        #ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetFenceWin32HandleKHR = kk_tramp_GetFenceWin32HandleKHR,
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .ImportFenceWin32HandleKHR = kk_tramp_ImportFenceWin32HandleKHR,
#endif
    .GetFenceFdKHR = kk_tramp_GetFenceFdKHR,
    .ImportFenceFdKHR = kk_tramp_ImportFenceFdKHR,
                        .DisplayPowerControlEXT = kk_tramp_DisplayPowerControlEXT,
    .RegisterDeviceEventEXT = kk_tramp_RegisterDeviceEventEXT,
    .RegisterDisplayEventEXT = kk_tramp_RegisterDisplayEventEXT,
    .GetSwapchainCounterEXT = kk_tramp_GetSwapchainCounterEXT,
                .GetDeviceGroupPeerMemoryFeatures = kk_tramp_GetDeviceGroupPeerMemoryFeatures,
        .BindBufferMemory2 = kk_tramp_BindBufferMemory2,
        .BindImageMemory2 = kk_tramp_BindImageMemory2,
        .CmdSetDeviceMask = kk_tramp_CmdSetDeviceMask,
        .GetDeviceGroupPresentCapabilitiesKHR = kk_tramp_GetDeviceGroupPresentCapabilitiesKHR,
    .GetDeviceGroupSurfacePresentModesKHR = kk_tramp_GetDeviceGroupSurfacePresentModesKHR,
    .AcquireNextImage2KHR = kk_tramp_AcquireNextImage2KHR,
    .CmdDispatchBase = kk_tramp_CmdDispatchBase,
            .CreateDescriptorUpdateTemplate = kk_tramp_CreateDescriptorUpdateTemplate,
        .DestroyDescriptorUpdateTemplate = kk_tramp_DestroyDescriptorUpdateTemplate,
        .UpdateDescriptorSetWithTemplate = kk_tramp_UpdateDescriptorSetWithTemplate,
        .CmdPushDescriptorSetWithTemplate = kk_tramp_CmdPushDescriptorSetWithTemplate,
        .SetHdrMetadataEXT = kk_tramp_SetHdrMetadataEXT,
    .GetSwapchainStatusKHR = kk_tramp_GetSwapchainStatusKHR,
    .GetRefreshCycleDurationGOOGLE = kk_tramp_GetRefreshCycleDurationGOOGLE,
    .GetPastPresentationTimingGOOGLE = kk_tramp_GetPastPresentationTimingGOOGLE,
                .CmdSetViewportWScalingNV = kk_tramp_CmdSetViewportWScalingNV,
    .CmdSetDiscardRectangleEXT = kk_tramp_CmdSetDiscardRectangleEXT,
    .CmdSetDiscardRectangleEnableEXT = kk_tramp_CmdSetDiscardRectangleEnableEXT,
    .CmdSetDiscardRectangleModeEXT = kk_tramp_CmdSetDiscardRectangleModeEXT,
    .CmdSetSampleLocationsEXT = kk_tramp_CmdSetSampleLocationsEXT,
                                .GetBufferMemoryRequirements2 = kk_tramp_GetBufferMemoryRequirements2,
        .GetImageMemoryRequirements2 = kk_tramp_GetImageMemoryRequirements2,
        .GetImageSparseMemoryRequirements2 = kk_tramp_GetImageSparseMemoryRequirements2,
        .GetDeviceBufferMemoryRequirements = kk_tramp_GetDeviceBufferMemoryRequirements,
        .GetDeviceImageMemoryRequirements = kk_tramp_GetDeviceImageMemoryRequirements,
        .GetDeviceImageSparseMemoryRequirements = kk_tramp_GetDeviceImageSparseMemoryRequirements,
        .CreateSamplerYcbcrConversion = kk_tramp_CreateSamplerYcbcrConversion,
        .DestroySamplerYcbcrConversion = kk_tramp_DestroySamplerYcbcrConversion,
        .GetDeviceQueue2 = kk_tramp_GetDeviceQueue2,
    .CreateValidationCacheEXT = kk_tramp_CreateValidationCacheEXT,
    .DestroyValidationCacheEXT = kk_tramp_DestroyValidationCacheEXT,
    .GetValidationCacheDataEXT = kk_tramp_GetValidationCacheDataEXT,
    .MergeValidationCachesEXT = kk_tramp_MergeValidationCachesEXT,
    .GetDescriptorSetLayoutSupport = kk_tramp_GetDescriptorSetLayoutSupport,
    #ifdef VK_USE_PLATFORM_ANDROID_KHR
    .GetSwapchainGrallocUsageANDROID = kk_tramp_GetSwapchainGrallocUsageANDROID,
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    .GetSwapchainGrallocUsage2ANDROID = kk_tramp_GetSwapchainGrallocUsage2ANDROID,
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    .AcquireImageANDROID = kk_tramp_AcquireImageANDROID,
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    .QueueSignalReleaseImageANDROID = kk_tramp_QueueSignalReleaseImageANDROID,
#endif
    .GetShaderInfoAMD = kk_tramp_GetShaderInfoAMD,
    .SetLocalDimmingAMD = kk_tramp_SetLocalDimmingAMD,
            .GetCalibratedTimestampsKHR = kk_tramp_GetCalibratedTimestampsKHR,
        .SetDebugUtilsObjectNameEXT = kk_tramp_SetDebugUtilsObjectNameEXT,
    .SetDebugUtilsObjectTagEXT = kk_tramp_SetDebugUtilsObjectTagEXT,
    .QueueBeginDebugUtilsLabelEXT = kk_tramp_QueueBeginDebugUtilsLabelEXT,
    .QueueEndDebugUtilsLabelEXT = kk_tramp_QueueEndDebugUtilsLabelEXT,
    .QueueInsertDebugUtilsLabelEXT = kk_tramp_QueueInsertDebugUtilsLabelEXT,
    .CmdBeginDebugUtilsLabelEXT = kk_tramp_CmdBeginDebugUtilsLabelEXT,
    .CmdEndDebugUtilsLabelEXT = kk_tramp_CmdEndDebugUtilsLabelEXT,
    .CmdInsertDebugUtilsLabelEXT = kk_tramp_CmdInsertDebugUtilsLabelEXT,
                .GetMemoryHostPointerPropertiesEXT = kk_tramp_GetMemoryHostPointerPropertiesEXT,
    .CmdWriteBufferMarkerAMD = kk_tramp_CmdWriteBufferMarkerAMD,
    .CreateRenderPass2 = kk_tramp_CreateRenderPass2,
        .CmdBeginRenderPass2 = kk_tramp_CmdBeginRenderPass2,
        .CmdNextSubpass2 = kk_tramp_CmdNextSubpass2,
        .CmdEndRenderPass2 = kk_tramp_CmdEndRenderPass2,
        .GetSemaphoreCounterValue = kk_tramp_GetSemaphoreCounterValue,
        .WaitSemaphores = kk_tramp_WaitSemaphores,
        .SignalSemaphore = kk_tramp_SignalSemaphore,
    #ifdef VK_USE_PLATFORM_ANDROID_KHR
    .GetAndroidHardwareBufferPropertiesANDROID = kk_tramp_GetAndroidHardwareBufferPropertiesANDROID,
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    .GetMemoryAndroidHardwareBufferANDROID = kk_tramp_GetMemoryAndroidHardwareBufferANDROID,
#endif
    .CmdDrawIndirectCount = kk_tramp_CmdDrawIndirectCount,
            .CmdDrawIndexedIndirectCount = kk_tramp_CmdDrawIndexedIndirectCount,
            .CmdSetCheckpointNV = kk_tramp_CmdSetCheckpointNV,
    .GetQueueCheckpointDataNV = kk_tramp_GetQueueCheckpointDataNV,
    .CmdBindTransformFeedbackBuffersEXT = kk_tramp_CmdBindTransformFeedbackBuffersEXT,
    .CmdBeginTransformFeedbackEXT = kk_tramp_CmdBeginTransformFeedbackEXT,
    .CmdEndTransformFeedbackEXT = kk_tramp_CmdEndTransformFeedbackEXT,
    .CmdBeginQueryIndexedEXT = kk_tramp_CmdBeginQueryIndexedEXT,
    .CmdEndQueryIndexedEXT = kk_tramp_CmdEndQueryIndexedEXT,
    .CmdDrawIndirectByteCountEXT = kk_tramp_CmdDrawIndirectByteCountEXT,
    .CmdSetExclusiveScissorNV = kk_tramp_CmdSetExclusiveScissorNV,
    .CmdSetExclusiveScissorEnableNV = kk_tramp_CmdSetExclusiveScissorEnableNV,
    .CmdBindShadingRateImageNV = kk_tramp_CmdBindShadingRateImageNV,
    .CmdSetViewportShadingRatePaletteNV = kk_tramp_CmdSetViewportShadingRatePaletteNV,
    .CmdSetCoarseSampleOrderNV = kk_tramp_CmdSetCoarseSampleOrderNV,
    .CmdDrawMeshTasksNV = kk_tramp_CmdDrawMeshTasksNV,
    .CmdDrawMeshTasksIndirectNV = kk_tramp_CmdDrawMeshTasksIndirectNV,
    .CmdDrawMeshTasksIndirectCountNV = kk_tramp_CmdDrawMeshTasksIndirectCountNV,
    .CmdDrawMeshTasksEXT = kk_tramp_CmdDrawMeshTasksEXT,
    .CmdDrawMeshTasksIndirectEXT = kk_tramp_CmdDrawMeshTasksIndirectEXT,
    .CmdDrawMeshTasksIndirectCountEXT = kk_tramp_CmdDrawMeshTasksIndirectCountEXT,
    .CompileDeferredNV = kk_tramp_CompileDeferredNV,
    .CreateAccelerationStructureNV = kk_tramp_CreateAccelerationStructureNV,
    .CmdBindInvocationMaskHUAWEI = kk_tramp_CmdBindInvocationMaskHUAWEI,
    .DestroyAccelerationStructureKHR = kk_tramp_DestroyAccelerationStructureKHR,
    .DestroyAccelerationStructureNV = kk_tramp_DestroyAccelerationStructureNV,
    .GetAccelerationStructureMemoryRequirementsNV = kk_tramp_GetAccelerationStructureMemoryRequirementsNV,
    .BindAccelerationStructureMemoryNV = kk_tramp_BindAccelerationStructureMemoryNV,
    .CmdCopyAccelerationStructureNV = kk_tramp_CmdCopyAccelerationStructureNV,
    .CmdCopyAccelerationStructureKHR = kk_tramp_CmdCopyAccelerationStructureKHR,
    .CopyAccelerationStructureKHR = kk_tramp_CopyAccelerationStructureKHR,
    .CmdCopyAccelerationStructureToMemoryKHR = kk_tramp_CmdCopyAccelerationStructureToMemoryKHR,
    .CopyAccelerationStructureToMemoryKHR = kk_tramp_CopyAccelerationStructureToMemoryKHR,
    .CmdCopyMemoryToAccelerationStructureKHR = kk_tramp_CmdCopyMemoryToAccelerationStructureKHR,
    .CopyMemoryToAccelerationStructureKHR = kk_tramp_CopyMemoryToAccelerationStructureKHR,
    .CmdWriteAccelerationStructuresPropertiesKHR = kk_tramp_CmdWriteAccelerationStructuresPropertiesKHR,
    .CmdWriteAccelerationStructuresPropertiesNV = kk_tramp_CmdWriteAccelerationStructuresPropertiesNV,
    .CmdBuildAccelerationStructureNV = kk_tramp_CmdBuildAccelerationStructureNV,
    .WriteAccelerationStructuresPropertiesKHR = kk_tramp_WriteAccelerationStructuresPropertiesKHR,
    .CmdTraceRaysKHR = kk_tramp_CmdTraceRaysKHR,
    .CmdTraceRaysNV = kk_tramp_CmdTraceRaysNV,
    .GetRayTracingShaderGroupHandlesKHR = kk_tramp_GetRayTracingShaderGroupHandlesKHR,
        .GetRayTracingCaptureReplayShaderGroupHandlesKHR = kk_tramp_GetRayTracingCaptureReplayShaderGroupHandlesKHR,
    .GetAccelerationStructureHandleNV = kk_tramp_GetAccelerationStructureHandleNV,
    .CreateRayTracingPipelinesNV = kk_tramp_CreateRayTracingPipelinesNV,
    .CreateRayTracingPipelinesKHR = kk_tramp_CreateRayTracingPipelinesKHR,
        .CmdTraceRaysIndirectKHR = kk_tramp_CmdTraceRaysIndirectKHR,
    .CmdTraceRaysIndirect2KHR = kk_tramp_CmdTraceRaysIndirect2KHR,
    .GetClusterAccelerationStructureBuildSizesNV = kk_tramp_GetClusterAccelerationStructureBuildSizesNV,
    .CmdBuildClusterAccelerationStructureIndirectNV = kk_tramp_CmdBuildClusterAccelerationStructureIndirectNV,
    .GetDeviceAccelerationStructureCompatibilityKHR = kk_tramp_GetDeviceAccelerationStructureCompatibilityKHR,
    .GetRayTracingShaderGroupStackSizeKHR = kk_tramp_GetRayTracingShaderGroupStackSizeKHR,
    .CmdSetRayTracingPipelineStackSizeKHR = kk_tramp_CmdSetRayTracingPipelineStackSizeKHR,
    .GetImageViewHandleNVX = kk_tramp_GetImageViewHandleNVX,
    .GetImageViewHandle64NVX = kk_tramp_GetImageViewHandle64NVX,
    .GetImageViewAddressNVX = kk_tramp_GetImageViewAddressNVX,
    #ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetDeviceGroupSurfacePresentModes2EXT = kk_tramp_GetDeviceGroupSurfacePresentModes2EXT,
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .AcquireFullScreenExclusiveModeEXT = kk_tramp_AcquireFullScreenExclusiveModeEXT,
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .ReleaseFullScreenExclusiveModeEXT = kk_tramp_ReleaseFullScreenExclusiveModeEXT,
#endif
            .AcquireProfilingLockKHR = kk_tramp_AcquireProfilingLockKHR,
    .ReleaseProfilingLockKHR = kk_tramp_ReleaseProfilingLockKHR,
    .GetImageDrmFormatModifierPropertiesEXT = kk_tramp_GetImageDrmFormatModifierPropertiesEXT,
    .GetBufferOpaqueCaptureAddress = kk_tramp_GetBufferOpaqueCaptureAddress,
        .GetBufferDeviceAddress = kk_tramp_GetBufferDeviceAddress,
                    .InitializePerformanceApiINTEL = kk_tramp_InitializePerformanceApiINTEL,
    .UninitializePerformanceApiINTEL = kk_tramp_UninitializePerformanceApiINTEL,
    .CmdSetPerformanceMarkerINTEL = kk_tramp_CmdSetPerformanceMarkerINTEL,
    .CmdSetPerformanceStreamMarkerINTEL = kk_tramp_CmdSetPerformanceStreamMarkerINTEL,
    .CmdSetPerformanceOverrideINTEL = kk_tramp_CmdSetPerformanceOverrideINTEL,
    .AcquirePerformanceConfigurationINTEL = kk_tramp_AcquirePerformanceConfigurationINTEL,
    .ReleasePerformanceConfigurationINTEL = kk_tramp_ReleasePerformanceConfigurationINTEL,
    .QueueSetPerformanceConfigurationINTEL = kk_tramp_QueueSetPerformanceConfigurationINTEL,
    .GetPerformanceParameterINTEL = kk_tramp_GetPerformanceParameterINTEL,
    .GetDeviceMemoryOpaqueCaptureAddress = kk_tramp_GetDeviceMemoryOpaqueCaptureAddress,
        .GetPipelineExecutablePropertiesKHR = kk_tramp_GetPipelineExecutablePropertiesKHR,
    .GetPipelineExecutableStatisticsKHR = kk_tramp_GetPipelineExecutableStatisticsKHR,
    .GetPipelineExecutableInternalRepresentationsKHR = kk_tramp_GetPipelineExecutableInternalRepresentationsKHR,
    .CmdSetLineStipple = kk_tramp_CmdSetLineStipple,
                    .CreateAccelerationStructureKHR = kk_tramp_CreateAccelerationStructureKHR,
    .CmdBuildAccelerationStructuresKHR = kk_tramp_CmdBuildAccelerationStructuresKHR,
    .CmdBuildAccelerationStructuresIndirectKHR = kk_tramp_CmdBuildAccelerationStructuresIndirectKHR,
    .BuildAccelerationStructuresKHR = kk_tramp_BuildAccelerationStructuresKHR,
    .GetAccelerationStructureDeviceAddressKHR = kk_tramp_GetAccelerationStructureDeviceAddressKHR,
    .CreateDeferredOperationKHR = kk_tramp_CreateDeferredOperationKHR,
    .DestroyDeferredOperationKHR = kk_tramp_DestroyDeferredOperationKHR,
    .GetDeferredOperationMaxConcurrencyKHR = kk_tramp_GetDeferredOperationMaxConcurrencyKHR,
    .GetDeferredOperationResultKHR = kk_tramp_GetDeferredOperationResultKHR,
    .DeferredOperationJoinKHR = kk_tramp_DeferredOperationJoinKHR,
    .GetPipelineIndirectMemoryRequirementsNV = kk_tramp_GetPipelineIndirectMemoryRequirementsNV,
    .GetPipelineIndirectDeviceAddressNV = kk_tramp_GetPipelineIndirectDeviceAddressNV,
    .AntiLagUpdateAMD = kk_tramp_AntiLagUpdateAMD,
    .CmdSetCullMode = kk_tramp_CmdSetCullMode,
        .CmdSetFrontFace = kk_tramp_CmdSetFrontFace,
        .CmdSetPrimitiveTopology = kk_tramp_CmdSetPrimitiveTopology,
        .CmdSetViewportWithCount = kk_tramp_CmdSetViewportWithCount,
        .CmdSetScissorWithCount = kk_tramp_CmdSetScissorWithCount,
        .CmdBindIndexBuffer2 = kk_tramp_CmdBindIndexBuffer2,
        .CmdBindVertexBuffers2 = kk_tramp_CmdBindVertexBuffers2,
        .CmdSetDepthTestEnable = kk_tramp_CmdSetDepthTestEnable,
        .CmdSetDepthWriteEnable = kk_tramp_CmdSetDepthWriteEnable,
        .CmdSetDepthCompareOp = kk_tramp_CmdSetDepthCompareOp,
        .CmdSetDepthBoundsTestEnable = kk_tramp_CmdSetDepthBoundsTestEnable,
        .CmdSetStencilTestEnable = kk_tramp_CmdSetStencilTestEnable,
        .CmdSetStencilOp = kk_tramp_CmdSetStencilOp,
        .CmdSetPatchControlPointsEXT = kk_tramp_CmdSetPatchControlPointsEXT,
    .CmdSetRasterizerDiscardEnable = kk_tramp_CmdSetRasterizerDiscardEnable,
        .CmdSetDepthBiasEnable = kk_tramp_CmdSetDepthBiasEnable,
        .CmdSetLogicOpEXT = kk_tramp_CmdSetLogicOpEXT,
    .CmdSetPrimitiveRestartEnable = kk_tramp_CmdSetPrimitiveRestartEnable,
        .CmdSetTessellationDomainOriginEXT = kk_tramp_CmdSetTessellationDomainOriginEXT,
    .CmdSetDepthClampEnableEXT = kk_tramp_CmdSetDepthClampEnableEXT,
    .CmdSetPolygonModeEXT = kk_tramp_CmdSetPolygonModeEXT,
    .CmdSetRasterizationSamplesEXT = kk_tramp_CmdSetRasterizationSamplesEXT,
    .CmdSetSampleMaskEXT = kk_tramp_CmdSetSampleMaskEXT,
    .CmdSetAlphaToCoverageEnableEXT = kk_tramp_CmdSetAlphaToCoverageEnableEXT,
    .CmdSetAlphaToOneEnableEXT = kk_tramp_CmdSetAlphaToOneEnableEXT,
    .CmdSetLogicOpEnableEXT = kk_tramp_CmdSetLogicOpEnableEXT,
    .CmdSetColorBlendEnableEXT = kk_tramp_CmdSetColorBlendEnableEXT,
    .CmdSetColorBlendEquationEXT = kk_tramp_CmdSetColorBlendEquationEXT,
    .CmdSetColorWriteMaskEXT = kk_tramp_CmdSetColorWriteMaskEXT,
    .CmdSetRasterizationStreamEXT = kk_tramp_CmdSetRasterizationStreamEXT,
    .CmdSetConservativeRasterizationModeEXT = kk_tramp_CmdSetConservativeRasterizationModeEXT,
    .CmdSetExtraPrimitiveOverestimationSizeEXT = kk_tramp_CmdSetExtraPrimitiveOverestimationSizeEXT,
    .CmdSetDepthClipEnableEXT = kk_tramp_CmdSetDepthClipEnableEXT,
    .CmdSetSampleLocationsEnableEXT = kk_tramp_CmdSetSampleLocationsEnableEXT,
    .CmdSetColorBlendAdvancedEXT = kk_tramp_CmdSetColorBlendAdvancedEXT,
    .CmdSetProvokingVertexModeEXT = kk_tramp_CmdSetProvokingVertexModeEXT,
    .CmdSetLineRasterizationModeEXT = kk_tramp_CmdSetLineRasterizationModeEXT,
    .CmdSetLineStippleEnableEXT = kk_tramp_CmdSetLineStippleEnableEXT,
    .CmdSetDepthClipNegativeOneToOneEXT = kk_tramp_CmdSetDepthClipNegativeOneToOneEXT,
    .CmdSetViewportWScalingEnableNV = kk_tramp_CmdSetViewportWScalingEnableNV,
    .CmdSetViewportSwizzleNV = kk_tramp_CmdSetViewportSwizzleNV,
    .CmdSetCoverageToColorEnableNV = kk_tramp_CmdSetCoverageToColorEnableNV,
    .CmdSetCoverageToColorLocationNV = kk_tramp_CmdSetCoverageToColorLocationNV,
    .CmdSetCoverageModulationModeNV = kk_tramp_CmdSetCoverageModulationModeNV,
    .CmdSetCoverageModulationTableEnableNV = kk_tramp_CmdSetCoverageModulationTableEnableNV,
    .CmdSetCoverageModulationTableNV = kk_tramp_CmdSetCoverageModulationTableNV,
    .CmdSetShadingRateImageEnableNV = kk_tramp_CmdSetShadingRateImageEnableNV,
    .CmdSetCoverageReductionModeNV = kk_tramp_CmdSetCoverageReductionModeNV,
    .CmdSetRepresentativeFragmentTestEnableNV = kk_tramp_CmdSetRepresentativeFragmentTestEnableNV,
    .CreatePrivateDataSlot = kk_tramp_CreatePrivateDataSlot,
        .DestroyPrivateDataSlot = kk_tramp_DestroyPrivateDataSlot,
        .SetPrivateData = kk_tramp_SetPrivateData,
        .GetPrivateData = kk_tramp_GetPrivateData,
        .CmdCopyBuffer2 = kk_tramp_CmdCopyBuffer2,
        .CmdCopyImage2 = kk_tramp_CmdCopyImage2,
        .CmdBlitImage2 = kk_tramp_CmdBlitImage2,
        .CmdCopyBufferToImage2 = kk_tramp_CmdCopyBufferToImage2,
        .CmdCopyImageToBuffer2 = kk_tramp_CmdCopyImageToBuffer2,
        .CmdResolveImage2 = kk_tramp_CmdResolveImage2,
        .CmdSetFragmentShadingRateKHR = kk_tramp_CmdSetFragmentShadingRateKHR,
        .CmdSetFragmentShadingRateEnumNV = kk_tramp_CmdSetFragmentShadingRateEnumNV,
    .GetAccelerationStructureBuildSizesKHR = kk_tramp_GetAccelerationStructureBuildSizesKHR,
    .CmdSetVertexInputEXT = kk_tramp_CmdSetVertexInputEXT,
    .CmdSetColorWriteEnableEXT = kk_tramp_CmdSetColorWriteEnableEXT,
    .CmdSetEvent2 = kk_tramp_CmdSetEvent2,
        .CmdResetEvent2 = kk_tramp_CmdResetEvent2,
        .CmdWaitEvents2 = kk_tramp_CmdWaitEvents2,
        .CmdPipelineBarrier2 = kk_tramp_CmdPipelineBarrier2,
        .QueueSubmit2 = kk_tramp_QueueSubmit2,
        .CmdWriteTimestamp2 = kk_tramp_CmdWriteTimestamp2,
        .CmdWriteBufferMarker2AMD = kk_tramp_CmdWriteBufferMarker2AMD,
    .GetQueueCheckpointData2NV = kk_tramp_GetQueueCheckpointData2NV,
    .CopyMemoryToImage = kk_tramp_CopyMemoryToImage,
        .CopyImageToMemory = kk_tramp_CopyImageToMemory,
        .CopyImageToImage = kk_tramp_CopyImageToImage,
        .TransitionImageLayout = kk_tramp_TransitionImageLayout,
                    .CreateVideoSessionKHR = kk_tramp_CreateVideoSessionKHR,
    .DestroyVideoSessionKHR = kk_tramp_DestroyVideoSessionKHR,
    .CreateVideoSessionParametersKHR = kk_tramp_CreateVideoSessionParametersKHR,
    .UpdateVideoSessionParametersKHR = kk_tramp_UpdateVideoSessionParametersKHR,
    .GetEncodedVideoSessionParametersKHR = kk_tramp_GetEncodedVideoSessionParametersKHR,
    .DestroyVideoSessionParametersKHR = kk_tramp_DestroyVideoSessionParametersKHR,
    .GetVideoSessionMemoryRequirementsKHR = kk_tramp_GetVideoSessionMemoryRequirementsKHR,
    .BindVideoSessionMemoryKHR = kk_tramp_BindVideoSessionMemoryKHR,
    .CmdDecodeVideoKHR = kk_tramp_CmdDecodeVideoKHR,
    .CmdBeginVideoCodingKHR = kk_tramp_CmdBeginVideoCodingKHR,
    .CmdControlVideoCodingKHR = kk_tramp_CmdControlVideoCodingKHR,
    .CmdEndVideoCodingKHR = kk_tramp_CmdEndVideoCodingKHR,
    .CmdEncodeVideoKHR = kk_tramp_CmdEncodeVideoKHR,
    .CmdDecompressMemoryNV = kk_tramp_CmdDecompressMemoryNV,
    .CmdDecompressMemoryIndirectCountNV = kk_tramp_CmdDecompressMemoryIndirectCountNV,
    .GetPartitionedAccelerationStructuresBuildSizesNV = kk_tramp_GetPartitionedAccelerationStructuresBuildSizesNV,
    .CmdBuildPartitionedAccelerationStructuresNV = kk_tramp_CmdBuildPartitionedAccelerationStructuresNV,
    .CmdDecompressMemoryEXT = kk_tramp_CmdDecompressMemoryEXT,
    .CmdDecompressMemoryIndirectCountEXT = kk_tramp_CmdDecompressMemoryIndirectCountEXT,
    .CreateCuModuleNVX = kk_tramp_CreateCuModuleNVX,
    .CreateCuFunctionNVX = kk_tramp_CreateCuFunctionNVX,
    .DestroyCuModuleNVX = kk_tramp_DestroyCuModuleNVX,
    .DestroyCuFunctionNVX = kk_tramp_DestroyCuFunctionNVX,
    .CmdCuLaunchKernelNVX = kk_tramp_CmdCuLaunchKernelNVX,
    .GetDescriptorSetLayoutSizeEXT = kk_tramp_GetDescriptorSetLayoutSizeEXT,
    .GetDescriptorSetLayoutBindingOffsetEXT = kk_tramp_GetDescriptorSetLayoutBindingOffsetEXT,
    .GetDescriptorEXT = kk_tramp_GetDescriptorEXT,
    .CmdBindDescriptorBuffersEXT = kk_tramp_CmdBindDescriptorBuffersEXT,
    .CmdSetDescriptorBufferOffsetsEXT = kk_tramp_CmdSetDescriptorBufferOffsetsEXT,
    .CmdBindDescriptorBufferEmbeddedSamplersEXT = kk_tramp_CmdBindDescriptorBufferEmbeddedSamplersEXT,
    .GetBufferOpaqueCaptureDescriptorDataEXT = kk_tramp_GetBufferOpaqueCaptureDescriptorDataEXT,
    .GetImageOpaqueCaptureDescriptorDataEXT = kk_tramp_GetImageOpaqueCaptureDescriptorDataEXT,
    .GetImageViewOpaqueCaptureDescriptorDataEXT = kk_tramp_GetImageViewOpaqueCaptureDescriptorDataEXT,
    .GetSamplerOpaqueCaptureDescriptorDataEXT = kk_tramp_GetSamplerOpaqueCaptureDescriptorDataEXT,
    .GetAccelerationStructureOpaqueCaptureDescriptorDataEXT = kk_tramp_GetAccelerationStructureOpaqueCaptureDescriptorDataEXT,
    .SetDeviceMemoryPriorityEXT = kk_tramp_SetDeviceMemoryPriorityEXT,
            .WaitForPresent2KHR = kk_tramp_WaitForPresent2KHR,
    .WaitForPresentKHR = kk_tramp_WaitForPresentKHR,
#ifdef VK_USE_PLATFORM_FUCHSIA
    .CreateBufferCollectionFUCHSIA = kk_tramp_CreateBufferCollectionFUCHSIA,
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
    .SetBufferCollectionBufferConstraintsFUCHSIA = kk_tramp_SetBufferCollectionBufferConstraintsFUCHSIA,
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
    .SetBufferCollectionImageConstraintsFUCHSIA = kk_tramp_SetBufferCollectionImageConstraintsFUCHSIA,
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
    .DestroyBufferCollectionFUCHSIA = kk_tramp_DestroyBufferCollectionFUCHSIA,
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
    .GetBufferCollectionPropertiesFUCHSIA = kk_tramp_GetBufferCollectionPropertiesFUCHSIA,
#endif
    .CmdBeginRendering = kk_tramp_CmdBeginRendering,
        .CmdEndRendering = kk_tramp_CmdEndRendering,
    .CmdEndRendering2KHR = kk_tramp_CmdEndRendering2KHR,
            .GetDescriptorSetLayoutHostMappingInfoVALVE = kk_tramp_GetDescriptorSetLayoutHostMappingInfoVALVE,
    .GetDescriptorSetHostMappingVALVE = kk_tramp_GetDescriptorSetHostMappingVALVE,
    .CreateMicromapEXT = kk_tramp_CreateMicromapEXT,
    .CmdBuildMicromapsEXT = kk_tramp_CmdBuildMicromapsEXT,
    .BuildMicromapsEXT = kk_tramp_BuildMicromapsEXT,
    .DestroyMicromapEXT = kk_tramp_DestroyMicromapEXT,
    .CmdCopyMicromapEXT = kk_tramp_CmdCopyMicromapEXT,
    .CopyMicromapEXT = kk_tramp_CopyMicromapEXT,
    .CmdCopyMicromapToMemoryEXT = kk_tramp_CmdCopyMicromapToMemoryEXT,
    .CopyMicromapToMemoryEXT = kk_tramp_CopyMicromapToMemoryEXT,
    .CmdCopyMemoryToMicromapEXT = kk_tramp_CmdCopyMemoryToMicromapEXT,
    .CopyMemoryToMicromapEXT = kk_tramp_CopyMemoryToMicromapEXT,
    .CmdWriteMicromapsPropertiesEXT = kk_tramp_CmdWriteMicromapsPropertiesEXT,
    .WriteMicromapsPropertiesEXT = kk_tramp_WriteMicromapsPropertiesEXT,
    .GetDeviceMicromapCompatibilityEXT = kk_tramp_GetDeviceMicromapCompatibilityEXT,
    .GetMicromapBuildSizesEXT = kk_tramp_GetMicromapBuildSizesEXT,
    .GetShaderModuleIdentifierEXT = kk_tramp_GetShaderModuleIdentifierEXT,
    .GetShaderModuleCreateInfoIdentifierEXT = kk_tramp_GetShaderModuleCreateInfoIdentifierEXT,
    .GetImageSubresourceLayout2 = kk_tramp_GetImageSubresourceLayout2,
            .GetPipelinePropertiesEXT = kk_tramp_GetPipelinePropertiesEXT,
#ifdef VK_USE_PLATFORM_METAL_EXT
    .ExportMetalObjectsEXT = kk_tramp_ExportMetalObjectsEXT,
#endif
    .CmdBindTileMemoryQCOM = kk_tramp_CmdBindTileMemoryQCOM,
    .GetFramebufferTilePropertiesQCOM = kk_tramp_GetFramebufferTilePropertiesQCOM,
    .GetDynamicRenderingTilePropertiesQCOM = kk_tramp_GetDynamicRenderingTilePropertiesQCOM,
        .CreateOpticalFlowSessionNV = kk_tramp_CreateOpticalFlowSessionNV,
    .DestroyOpticalFlowSessionNV = kk_tramp_DestroyOpticalFlowSessionNV,
    .BindOpticalFlowSessionImageNV = kk_tramp_BindOpticalFlowSessionImageNV,
    .CmdOpticalFlowExecuteNV = kk_tramp_CmdOpticalFlowExecuteNV,
    .GetDeviceFaultInfoEXT = kk_tramp_GetDeviceFaultInfoEXT,
    .CmdSetDepthBias2EXT = kk_tramp_CmdSetDepthBias2EXT,
    .ReleaseSwapchainImagesKHR = kk_tramp_ReleaseSwapchainImagesKHR,
        .GetDeviceImageSubresourceLayout = kk_tramp_GetDeviceImageSubresourceLayout,
        .MapMemory2 = kk_tramp_MapMemory2,
        .UnmapMemory2 = kk_tramp_UnmapMemory2,
        .CreateShadersEXT = kk_tramp_CreateShadersEXT,
    .DestroyShaderEXT = kk_tramp_DestroyShaderEXT,
    .GetShaderBinaryDataEXT = kk_tramp_GetShaderBinaryDataEXT,
    .CmdBindShadersEXT = kk_tramp_CmdBindShadersEXT,
    .SetSwapchainPresentTimingQueueSizeEXT = kk_tramp_SetSwapchainPresentTimingQueueSizeEXT,
    .GetSwapchainTimingPropertiesEXT = kk_tramp_GetSwapchainTimingPropertiesEXT,
    .GetSwapchainTimeDomainPropertiesEXT = kk_tramp_GetSwapchainTimeDomainPropertiesEXT,
    .GetPastPresentationTimingEXT = kk_tramp_GetPastPresentationTimingEXT,
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    .GetScreenBufferPropertiesQNX = kk_tramp_GetScreenBufferPropertiesQNX,
#endif
        .CmdBindDescriptorSets2 = kk_tramp_CmdBindDescriptorSets2,
        .CmdPushConstants2 = kk_tramp_CmdPushConstants2,
        .CmdPushDescriptorSet2 = kk_tramp_CmdPushDescriptorSet2,
        .CmdPushDescriptorSetWithTemplate2 = kk_tramp_CmdPushDescriptorSetWithTemplate2,
        .CmdSetDescriptorBufferOffsets2EXT = kk_tramp_CmdSetDescriptorBufferOffsets2EXT,
    .CmdBindDescriptorBufferEmbeddedSamplers2EXT = kk_tramp_CmdBindDescriptorBufferEmbeddedSamplers2EXT,
    .SetLatencySleepModeNV = kk_tramp_SetLatencySleepModeNV,
    .LatencySleepNV = kk_tramp_LatencySleepNV,
    .SetLatencyMarkerNV = kk_tramp_SetLatencyMarkerNV,
    .GetLatencyTimingsNV = kk_tramp_GetLatencyTimingsNV,
    .QueueNotifyOutOfBandNV = kk_tramp_QueueNotifyOutOfBandNV,
    .CmdSetRenderingAttachmentLocations = kk_tramp_CmdSetRenderingAttachmentLocations,
        .CmdSetRenderingInputAttachmentIndices = kk_tramp_CmdSetRenderingInputAttachmentIndices,
        .CmdSetDepthClampRangeEXT = kk_tramp_CmdSetDepthClampRangeEXT,
    #ifdef VK_USE_PLATFORM_METAL_EXT
    .GetMemoryMetalHandleEXT = kk_tramp_GetMemoryMetalHandleEXT,
#endif
#ifdef VK_USE_PLATFORM_METAL_EXT
    .GetMemoryMetalHandlePropertiesEXT = kk_tramp_GetMemoryMetalHandlePropertiesEXT,
#endif
        .ConvertCooperativeVectorMatrixNV = kk_tramp_ConvertCooperativeVectorMatrixNV,
    .CmdConvertCooperativeVectorMatrixNV = kk_tramp_CmdConvertCooperativeVectorMatrixNV,
    .CmdDispatchTileQCOM = kk_tramp_CmdDispatchTileQCOM,
    .CmdBeginPerTileExecutionQCOM = kk_tramp_CmdBeginPerTileExecutionQCOM,
    .CmdEndPerTileExecutionQCOM = kk_tramp_CmdEndPerTileExecutionQCOM,
    .CreateExternalComputeQueueNV = kk_tramp_CreateExternalComputeQueueNV,
    .DestroyExternalComputeQueueNV = kk_tramp_DestroyExternalComputeQueueNV,
        .CreateTensorARM = kk_tramp_CreateTensorARM,
    .DestroyTensorARM = kk_tramp_DestroyTensorARM,
    .CreateTensorViewARM = kk_tramp_CreateTensorViewARM,
    .DestroyTensorViewARM = kk_tramp_DestroyTensorViewARM,
    .GetTensorMemoryRequirementsARM = kk_tramp_GetTensorMemoryRequirementsARM,
    .BindTensorMemoryARM = kk_tramp_BindTensorMemoryARM,
    .GetDeviceTensorMemoryRequirementsARM = kk_tramp_GetDeviceTensorMemoryRequirementsARM,
    .CmdCopyTensorARM = kk_tramp_CmdCopyTensorARM,
    .GetTensorOpaqueCaptureDescriptorDataARM = kk_tramp_GetTensorOpaqueCaptureDescriptorDataARM,
    .GetTensorViewOpaqueCaptureDescriptorDataARM = kk_tramp_GetTensorViewOpaqueCaptureDescriptorDataARM,
        .CreateDataGraphPipelinesARM = kk_tramp_CreateDataGraphPipelinesARM,
    .CreateDataGraphPipelineSessionARM = kk_tramp_CreateDataGraphPipelineSessionARM,
    .GetDataGraphPipelineSessionBindPointRequirementsARM = kk_tramp_GetDataGraphPipelineSessionBindPointRequirementsARM,
    .GetDataGraphPipelineSessionMemoryRequirementsARM = kk_tramp_GetDataGraphPipelineSessionMemoryRequirementsARM,
    .BindDataGraphPipelineSessionMemoryARM = kk_tramp_BindDataGraphPipelineSessionMemoryARM,
    .DestroyDataGraphPipelineSessionARM = kk_tramp_DestroyDataGraphPipelineSessionARM,
    .CmdDispatchDataGraphARM = kk_tramp_CmdDispatchDataGraphARM,
    .GetDataGraphPipelineAvailablePropertiesARM = kk_tramp_GetDataGraphPipelineAvailablePropertiesARM,
    .GetDataGraphPipelinePropertiesARM = kk_tramp_GetDataGraphPipelinePropertiesARM,
        #ifdef VK_USE_PLATFORM_OHOS
    .GetNativeBufferPropertiesOHOS = kk_tramp_GetNativeBufferPropertiesOHOS,
#endif
#ifdef VK_USE_PLATFORM_OHOS
    .GetMemoryNativeBufferOHOS = kk_tramp_GetMemoryNativeBufferOHOS,
#endif
#ifdef VK_USE_PLATFORM_OHOS
    .GetSwapchainGrallocUsageOHOS = kk_tramp_GetSwapchainGrallocUsageOHOS,
#endif
#ifdef VK_USE_PLATFORM_OHOS
    .AcquireImageOHOS = kk_tramp_AcquireImageOHOS,
#endif
#ifdef VK_USE_PLATFORM_OHOS
    .QueueSignalReleaseImageOHOS = kk_tramp_QueueSignalReleaseImageOHOS,
#endif
    };
