/*******************************************************************************
 *
 * MIT License
 *
 * Copyright (c) 2021 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/
#include <algorithm>
#include <unordered_map>
#include <string_view>
#include <miopen/filesystem.hpp>
#include <miopen/kernel.hpp>

#ifndef MIOPEN_USE_CLANG_TIDY // Huge generated source
// clang-format off
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCDHW_KCZYX_NKDHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCDHW_KCZYX_NKDHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCHW_KCYX_NKHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_NCHW_KCYX_NKHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_XDLOPS_NCHW_KCYX_NKHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V1R1_XDLOPS_NCHW_KCYX_NKHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCDHW_KCZYX_NKDHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCDHW_KCZYX_NKDHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_XDLOPS_NCHW_KCYX_NKHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_DATA_IMPLICIT_GEMM_V4R1_XDLOPS_NCHW_KCYX_NKHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_BACKWARD_WEIGHTS_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R4_XDLOPS_NCHW_KCYX_NKHW_PADDED_GEMM[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R5_XDLOPS_NCHW_KCYX_NKHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V4R5_XDLOPS_NCHW_KCYX_NKHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_GNCHW_GKCYX_GNKHW_LDS_DOUBLE_BUFFER_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_GNCHW_GKCYX_GNKHW_LDS_DOUBLE_BUFFER[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW_LDS_DOUBLE_BUFFER_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R1_NCHW_KCYX_NKHW_LDS_DOUBLE_BUFFER[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCDHW_KCZYX_NKDHW[];
extern const size_t MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW_SIZE;
extern const char MIOPEN_KERNEL_STATIC_KERNEL_GRIDWISE_CONVOLUTION_IMPLICIT_GEMM_V4R4_NCHW_KCYX_NKHW[];
extern const size_t MIOPEN_KERNEL_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V6R1_DLOPS_NCHW_KCYX_NKHW_SIZE;
extern const char MIOPEN_KERNEL_CONVOLUTION_FORWARD_IMPLICIT_GEMM_V6R1_DLOPS_NCHW_KCYX_NKHW[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_BLOCKWISE_REDUCE_ALL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_BLOCKWISE_REDUCE_ALL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_BLOCKWISE_REDUCE_PARTIAL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_BLOCKWISE_REDUCE_PARTIAL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_MULTIBLOCK_REDUCE_ALL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_MULTIBLOCK_REDUCE_ALL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_MULTIBLOCK_REDUCE_PARTIAL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_MULTIBLOCK_REDUCE_PARTIAL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_THREADWISE_REDUCE_ALL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_THREADWISE_REDUCE_ALL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_THREADWISE_REDUCE_PARTIAL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_THREADWISE_REDUCE_PARTIAL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_WARPWISE_REDUCE_ALL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_WARPWISE_REDUCE_ALL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_WARPWISE_REDUCE_PARTIAL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_FIRST_CALL_WARPWISE_REDUCE_PARTIAL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_BLOCKWISE_REDUCE_ALL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_BLOCKWISE_REDUCE_ALL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_BLOCKWISE_REDUCE_PARTIAL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_BLOCKWISE_REDUCE_PARTIAL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_THREADWISE_REDUCE_ALL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_THREADWISE_REDUCE_ALL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_THREADWISE_REDUCE_PARTIAL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_THREADWISE_REDUCE_PARTIAL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_WARPWISE_REDUCE_ALL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_WARPWISE_REDUCE_ALL_DIMS[];
extern const size_t MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_WARPWISE_REDUCE_PARTIAL_DIMS_SIZE;
extern const char MIOPEN_KERNEL_GRIDWISE_GENERIC_REDUCTION_SECOND_CALL_WARPWISE_REDUCE_PARTIAL_DIMS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTC_DYNAMIC_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTC_DYNAMIC[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X1X4_1X8X1X32_TB2X1X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X1X4_1X8X1X32_TB2X1X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X1X2X4_1X16X1X16_TB1X1X4X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X1X2X4_1X16X1X16_TB1X1X4X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X1X4X4_1X16X1X16_TB1X1X2X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X1X4X4_1X16X1X16_TB1X1X2X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X1X2X4_1X8X1X32_TB1X1X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X1X2X4_1X8X1X32_TB1X1X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX1_BT16X32X4_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX1_BT16X32X4_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX1_BT32X16X4_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X4X1X16_TB1X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX16_EX1_BT32X16X4_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X4X1X16_TB1X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X1X4_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X1X4_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X16X8_WT64X16X1_WS1X1_WR1X1_TA1X1X8X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X16X8_WT64X16X1_WS1X1_WR1X1_TA1X1X8X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA2X1X1X4_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA2X1X1X4_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT16X128X8_WT16X64X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT16X128X8_WT16X64X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT16X256X16_WT4X64X1_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT16X256X16_WT4X64X1_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X1X4X4_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X1X4X4_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X1X2X4_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X1X2X4_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT256X16X16_WT64X4X1_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT256X16X16_WT64X4X1_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X8_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X8_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT32X32X8_WT16X16X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT32X32X8_WT16X16X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX0_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X16X8_WT64X16X1_WS1X1_WR1X1_TA1X1X8X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X16X8_WT64X16X1_WS1X1_WR1X1_TA1X1X8X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT16X128X8_WT16X64X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT16X128X8_WT16X64X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT16X256X16_WT4X64X1_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT16X256X16_WT4X64X1_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X4_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X4_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X16X16_WT64X4X1_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X16X16_WT64X4X1_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X8_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X8_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X4_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X4X1X16_TB1X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X4_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X4X1X16_TB1X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X32X8_WT16X16X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X32X8_WT16X16X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA2X1X1X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA2X1X1X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX1_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X1X4_1X8X1X32_TB2X1X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X1X4_1X8X1X32_TB2X1X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X1X2X4_1X16X1X16_TB1X1X4X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X1X2X4_1X16X1X16_TB1X1X4X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X1X1X4_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X1X4X4_1X16X1X16_TB1X1X2X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X1X4X4_1X16X1X16_TB1X1X2X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X1X2X4_1X8X1X32_TB1X1X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X1X2X4_1X8X1X32_TB1X1X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X4X4_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX0_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X4X4_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT128X16X8_WT64X16X1_WS1X1_WR1X1_TA1X1X8X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT128X16X8_WT64X16X1_WS1X1_WR1X1_TA1X1X8X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT16X128X8_WT16X64X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT16X128X8_WT16X64X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT16X256X16_WT4X64X1_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT16X256X16_WT4X64X1_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X4_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X4_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT256X16X16_WT64X4X1_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT256X16X16_WT64X4X1_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X8_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X8_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X4_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X4X1X16_TB1X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X4_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X4X1X16_TB1X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X32X8_WT16X16X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X32X8_WT16X16X1_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX4_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX8_EX1_BT16X32X4_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX8_EX1_BT16X32X4_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX8_EX1_BT32X16X4_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X4X1X16_TB1X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP32_BX8_EX1_BT32X16X4_WT32X8X1_WS1X2_WR1X1_TA1X1X2X1_1X4X1X16_TB1X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X8_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X8_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X2_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X2_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X2_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X2_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X2_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X2_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X2_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X2_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X2X1X8_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X2X1X8_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X1X2_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X1X2_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X4X1X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X4X1X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X2X1X2_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X2X1X2_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X1X4_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X1X4_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X4X1X1_1X4X1X16_TB1X4X1X2_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X4X1X1_1X4X1X16_TB1X4X1X2_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X4X1X16_TB1X2X1X2_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X4X1X16_TB1X2X1X2_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X16X1X2_1X2X1X128_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X16X1X2_1X2X1X128_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X1X4_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X1X4_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X1X2_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X1X2_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X4_1X8X1X8_TB1X2X1X2_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X4_1X8X1X8_TB1X2X1X2_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X1X2_1X16X1X16_TB1X2X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X1X2_1X16X1X16_TB1X2X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X2X1X4_1X32X1X8_TB1X2X1X4_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X2X1X4_1X32X1X8_TB1X2X1X4_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X1X2_1X16X1X16_TB1X4X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X1X2_1X16X1X16_TB1X4X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X8X1X1_1X8X1X32_TB1X8X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X8X1X1_1X8X1X32_TB1X8X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X1X16X1_1X16X1X8_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X1X16X1_1X16X1X8_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X8_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X8_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA2X1X8X1_1X8X1X16_TB2X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA2X1X8X1_1X8X1X16_TB2X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X16_TB2X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X16_TB2X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X4_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X4_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA2X1X2X1_1X8X1X8_TB2X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA2X1X2X1_1X8X1X8_TB2X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA4X1X1X1_1X4X1X16_TB4X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA4X1X1X1_1X4X1X16_TB4X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA2X1X1X1_1X4X1X16_TB2X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA2X1X1X1_1X4X1X16_TB2X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X16_TB2X1X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X16_TB2X1X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X1X4X1_1X16X1X4_TB1X1X8X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X1X4X1_1X16X1X4_TB1X1X8X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA2X1X2X1_1X8X1X8_TB2X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA2X1X2X1_1X8X1X8_TB2X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA4X1X1X1_1X4X1X16_TB4X1X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA4X1X1X1_1X4X1X16_TB4X1X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA2X1X1X1_1X4X1X16_TB2X1X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA2X1X1X1_1X4X1X16_TB2X1X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X16X1X2_1X2X1X128_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X16X1X2_1X2X1X128_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X1X4_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X1X4_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X1X2_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X1X2_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA2X1X4X1_1X4X1X64_TB2X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA2X1X4X1_1X4X1X64_TB2X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA2X1X4X1_1X4X1X64_TB2X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA2X1X4X1_1X4X1X64_TB2X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X8_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X8_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA2X1X2X1_1X8X1X16_TB2X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA2X1X2X1_1X8X1X16_TB2X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X1X8X1_1X16X1X4_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X1X8X1_1X16X1X4_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X4_1X8X1X8_TB1X2X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X4_1X8X1X8_TB1X2X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA2X1X4X1_1X8X1X8_TB2X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA2X1X4X1_1X8X1X8_TB2X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA4X1X2X1_1X4X1X16_TB4X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA4X1X2X1_1X4X1X16_TB4X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X1X4X1_1X8X1X8_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X1X4X1_1X8X1X8_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA2X1X2X1_1X4X1X16_TB2X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA2X1X2X1_1X4X1X16_TB2X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X1X4X1_1X32X1X8_TB1X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X1X4X1_1X32X1X8_TB1X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X1X2_1X16X1X16_TB1X2X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X1X2_1X16X1X16_TB1X2X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA2X1X2X1_1X16X1X16_TB2X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA2X1X2X1_1X16X1X16_TB2X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA4X1X1X1_1X8X1X32_TB4X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA4X1X1X1_1X8X1X32_TB4X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X1X8X1_1X64X1X4_TB1X1X8X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X1X8X1_1X64X1X4_TB1X1X8X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X2X1X4_1X32X1X8_TB1X2X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X2X1X4_1X32X1X8_TB1X2X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X1X2_1X16X1X16_TB1X4X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X1X2_1X16X1X16_TB1X4X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA2X1X4X1_1X32X1X8_TB2X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA2X1X4X1_1X32X1X8_TB2X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA4X1X2X1_1X16X1X16_TB4X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA4X1X2X1_1X16X1X16_TB4X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA8X1X1X1_1X8X1X32_TB8X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA8X1X1X1_1X8X1X32_TB8X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA2X1X1X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA2X1X1X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA4X1X1X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA4X1X1X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X1X8X1_1X32X1X8_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X1X8X1_1X32X1X8_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA2X1X4X1_1X16X1X16_TB2X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA2X1X4X1_1X16X1X16_TB2X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA4X1X2X1_1X8X1X32_TB4X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA4X1X2X1_1X8X1X32_TB4X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA8X1X1X1_1X4X1X64_TB8X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA8X1X1X1_1X4X1X64_TB8X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X16X1X16_TB1X2X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X16X1X16_TB1X2X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX1_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X8_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X8_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X2_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X2_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X2_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X8X1X1_1X2X1X128_TB1X8X1X2_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X2_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X16X1X1_1X2X1X128_TB1X16X1X2_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X2_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X2_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X2X1X8_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X2X1X8_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X1X2_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X1X2_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X4X1X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X4X1X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X2X1X2_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X2X1X2_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X1X4_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X1X4_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X4X1X1_1X4X1X16_TB1X4X1X2_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X4X1X1_1X4X1X16_TB1X4X1X2_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X4X1X16_TB1X2X1X2_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X4X1X16_TB1X2X1X2_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X16X1X2_1X2X1X128_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X16X1X2_1X2X1X128_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X1X4_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X1X4_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X1X2_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X1X2_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X4_1X8X1X8_TB1X2X1X2_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X4_1X8X1X8_TB1X2X1X2_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X1X2_1X16X1X16_TB1X2X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X1X2_1X16X1X16_TB1X2X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X2X1X4_1X32X1X8_TB1X2X1X4_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X2X1X4_1X32X1X8_TB1X2X1X4_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X1X2_1X16X1X16_TB1X4X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X1X2_1X16X1X16_TB1X4X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X8X1X1_1X8X1X32_TB1X8X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X8X1X1_1X8X1X32_TB1X8X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X1X16X1_1X16X1X8_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X1X16X1_1X16X1X8_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X8_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X8_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA2X1X8X1_1X8X1X16_TB2X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA2X1X8X1_1X8X1X16_TB2X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X2X1X4_1X8X1X32_TB1X2X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA2X1X4X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA4X1X2X1_1X4X1X64_TB4X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X1X16X1_1X32X1X8_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X2X1X8_1X16X1X16_TB1X2X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X1X2_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA2X1X8X1_1X16X1X16_TB2X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA4X1X4X1_1X8X1X32_TB4X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA8X1X2X1_1X4X1X64_TB8X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X16X1X2_1X4X1X64_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X4X1X8_1X16X1X16_TB1X4X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X1X4_1X8X1X32_TB1X8X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X1X2_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA2X1X2X1_1X4X1X64_TB2X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X16_TB2X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X16_TB2X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X4_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X4_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA2X1X2X1_1X8X1X8_TB2X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA2X1X2X1_1X8X1X8_TB2X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA4X1X1X1_1X4X1X16_TB4X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA4X1X1X1_1X4X1X16_TB4X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA2X1X1X1_1X4X1X16_TB2X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA2X1X1X1_1X4X1X16_TB2X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X16_TB2X1X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X16_TB2X1X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X1X4X1_1X16X1X4_TB1X1X8X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X1X4X1_1X16X1X4_TB1X1X8X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X2_1X8X1X8_TB1X2X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA2X1X2X1_1X8X1X8_TB2X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA2X1X2X1_1X8X1X8_TB2X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA4X1X1X1_1X4X1X16_TB4X1X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA4X1X1X1_1X4X1X16_TB4X1X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA2X1X1X1_1X4X1X16_TB2X1X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA2X1X1X1_1X4X1X16_TB2X1X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X1X2_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X16X1X2_1X2X1X128_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X16X1X2_1X2X1X128_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X1X4_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X1X4_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X1X2_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X1X2_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA2X1X4X1_1X4X1X64_TB2X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA2X1X4X1_1X4X1X64_TB2X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X1X16X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA2X1X8X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA4X1X4X1_1X4X1X64_TB4X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X2X1X4_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA2X1X4X1_1X4X1X64_TB2X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA2X1X4X1_1X4X1X64_TB2X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X8_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X8_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X1X2_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA2X1X2X1_1X8X1X16_TB2X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA2X1X2X1_1X8X1X16_TB2X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X1X8X1_1X16X1X4_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X1X8X1_1X16X1X4_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X4_1X8X1X8_TB1X2X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X4_1X8X1X8_TB1X2X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA2X1X4X1_1X8X1X8_TB2X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA2X1X4X1_1X8X1X8_TB2X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA4X1X2X1_1X4X1X16_TB4X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA4X1X2X1_1X4X1X16_TB4X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X1X4X1_1X8X1X8_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X1X4X1_1X8X1X8_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA2X1X2X1_1X4X1X16_TB2X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA2X1X2X1_1X4X1X16_TB2X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA2X1X1X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA2X1X1X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X1X4X1_1X32X1X8_TB1X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X1X4X1_1X32X1X8_TB1X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X1X2_1X16X1X16_TB1X2X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X1X2_1X16X1X16_TB1X2X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA2X1X2X1_1X16X1X16_TB2X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA2X1X2X1_1X16X1X16_TB2X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA4X1X1X1_1X8X1X32_TB4X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA4X1X1X1_1X8X1X32_TB4X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X1X8X1_1X64X1X4_TB1X1X8X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X1X8X1_1X64X1X4_TB1X1X8X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X2X1X4_1X32X1X8_TB1X2X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X2X1X4_1X32X1X8_TB1X2X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X1X2_1X16X1X16_TB1X4X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X1X2_1X16X1X16_TB1X4X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA2X1X4X1_1X32X1X8_TB2X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA2X1X4X1_1X32X1X8_TB2X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA4X1X2X1_1X16X1X16_TB4X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA4X1X2X1_1X16X1X16_TB4X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA8X1X1X1_1X8X1X32_TB8X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA8X1X1X1_1X8X1X32_TB8X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA2X1X1X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA2X1X1X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA4X1X1X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA4X1X1X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X1X8X1_1X32X1X8_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X1X8X1_1X32X1X8_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA2X1X4X1_1X16X1X16_TB2X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA2X1X4X1_1X16X1X16_TB2X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA4X1X2X1_1X8X1X32_TB4X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA4X1X2X1_1X8X1X32_TB4X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA8X1X1X1_1X4X1X64_TB8X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA8X1X1X1_1X4X1X64_TB8X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X16X1X16_TB1X2X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X2X1X4_1X16X1X16_TB1X2X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X4X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA2X1X2X1_1X8X1X32_TB2X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X1X2_1X8X1X32_TB1X2X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA2X1X2X1_1X8X1X32_TB2X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA4X1X1X1_1X4X1X64_TB4X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA2X1X1X1_1X4X1X64_TB2X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NCHW_FP16_BX4_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX16_EX0_BT16X16X4_WT16X16X1_WS1X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX16_EX0_BT16X16X4_WT16X16X1_WS1X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX16_EX1_BT16X16X4_WT16X16X1_WS1X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX16_EX1_BT16X16X4_WT16X16X1_WS1X1_WR1X1_TA1X1X1X1_1X4X1X16_TB1X1X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X32_WT32X8X1_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X32_WT32X8X1_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X4_WT32X8X1_WS1X2_WR2X2_TA1X2X1X1_1X2X1X128_TB1X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X4_WT32X8X1_WS1X2_WR2X2_TA1X2X1X1_1X2X1X128_TB1X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X4X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X4X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X2X2X1_1X2X1X128_TB1X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X2X2X1_1X2X1X128_TB1X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X32_WT8X32X1_WS1X1_WR2X2_TA1X4X1X1_1X8X1X32_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X32_WT8X32X1_WS1X1_WR2X2_TA1X4X1X1_1X8X1X32_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X4X4X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X4X4X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X32_WT8X32X1_WS2X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X32_WT8X32X1_WS2X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X2X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X2X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X16X8_WT64X4X1_WS1X2_WR1X1_TA1X4X1X1_1X2X1X64_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X16X8_WT64X4X1_WS1X2_WR1X1_TA1X4X1X1_1X2X1X64_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X4X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X4X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X2X1X1_1X4X1X64_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X2X1X1_1X4X1X64_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X64_WT16X16X1_WS1X1_WR2X2_TA1X4X1X4_1X16X1X16_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X64_WT16X16X1_WS1X1_WR2X2_TA1X4X1X4_1X16X1X16_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X4X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX0_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X4X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X32_WT32X8X1_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X32_WT32X8X1_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X4_WT32X8X1_WS1X2_WR2X2_TA1X2X1X1_1X2X1X128_TB1X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X4_WT32X8X1_WS1X2_WR2X2_TA1X2X1X1_1X2X1X128_TB1X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X4X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X4X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X2X2X1_1X2X1X128_TB1X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X2X2X1_1X2X1X128_TB1X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X4X4X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X4X4X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X2X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X2X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X16X8_WT64X4X1_WS1X2_WR1X1_TA1X4X1X1_1X2X1X64_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X16X8_WT64X4X1_WS1X2_WR1X1_TA1X4X1X1_1X2X1X64_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X4X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X4X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X2X1X1_1X4X1X64_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X2X1X1_1X4X1X64_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X4X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX1_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X4X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX32_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X8X2X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX32_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X8X2X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X64X4_WT32X8X1_WS1X2_WR2X2_TA1X2X1X1_1X2X1X128_TB1X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X64X4_WT32X8X1_WS1X2_WR2X2_TA1X2X1X1_1X2X1X128_TB1X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X4X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X4X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X2X2X1_1X2X1X128_TB1X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X2X2X1_1X2X1X128_TB1X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X4X4X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X4X4X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X2X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X2X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X16X8_WT64X4X1_WS1X2_WR1X1_TA1X4X1X1_1X2X1X64_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X16X8_WT64X4X1_WS1X2_WR1X1_TA1X4X1X1_1X2X1X64_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X4X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X4X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X2X1X1_1X4X1X64_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X2X1X1_1X4X1X64_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X4X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX0_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X4X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X128X16_WT32X32X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X128X8_WT32X32X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X256X16_WT32X64X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X256X8_WT32X64X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X32X16_WT32X8X1_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X32X8_WT32X8X1_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X16_WT32X8X1_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X4_WT32X8X1_WS1X2_WR2X2_TA1X2X1X1_1X2X1X128_TB1X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X4_WT32X8X1_WS1X2_WR2X2_TA1X2X1X1_1X2X1X128_TB1X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT128X64X8_WT32X8X1_WS1X2_WR2X2_TA1X4X1X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X16_WT8X32X1_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X2X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X16_WT8X32X1_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X2X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X32X8_WT8X32X1_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X4X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X16_WT4X64X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X16_TB1X4X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT16X64X8_WT4X64X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X128X16_WT64X32X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X128X8_WT64X32X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X32X16_WT64X4X1_WS1X2_WR2X2_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X32X8_WT64X4X1_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X16_WT64X16X1_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X2X2X1_1X2X1X128_TB1X1X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X2X2X1_1X2X1X128_TB1X1X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT256X64X8_WT64X16X1_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X128X16_WT8X32X1_WS1X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X128X8_WT8X32X1_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X16_WT32X8X1_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X16_WT32X8X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X16X8_WT32X8X1_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X256X16_WT4X64X1_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X256X8_WT4X64X1_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X32X16_WT16X16X1_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X64X16_WT8X32X1_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT32X64X8_WT8X32X1_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X4X4X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X4X4X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X16_WT8X32X1_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X2X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X4_WT8X32X1_WS2X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X2X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X128X8_WT8X32X1_WS2X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X16X16_WT64X4X1_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X16X16_WT64X4X1_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X16X8_WT64X4X1_WS1X2_WR1X1_TA1X4X1X1_1X2X1X64_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X16X8_WT64X4X1_WS1X2_WR1X1_TA1X4X1X1_1X2X1X64_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X16_WT16X64X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X4X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X4_WT16X64X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X4X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X2X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X256X8_WT16X64X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X4X2X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X32X16_WT32X8X1_WS1X2_WR1X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X2X1X1_1X4X1X64_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X32X8_WT32X8X1_WS1X2_WR1X1_TA1X2X1X1_1X4X1X64_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X4X16_WT64X4X1_WS1X1_WR1X1_TA1X1X16X1_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X64X16_WT16X16X1_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X2X1X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X4X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX4_EX1_BT8X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X4X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX64_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX64_EX0_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX64_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX64_EX1_BT4X64X16_WT4X64X1_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX8_EX1_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP32_BX8_EX1_BT64X8X16_WT64X4X1_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX0_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX16_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X32X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X32X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X32X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X32X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X1X8X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X1X8X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X32X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X32X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X32_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X32_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX0_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X32X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X32X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X32X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X32X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X1X8X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X1X8X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X32X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X32X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X32_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X32_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX1_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X32X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X32X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X32X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X32X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X1X8X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X1X8X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X32X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X32X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X32_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X32_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX0_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X64X4_WS2X1_WR1X1_TA1X4X2X1_1X4X1X64_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT16X16X16_WS2X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X32X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X32X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X64_WT16X16X16_WS2X2_WR2X2_TA1X8X4X1_1X8X1X32_TB1X32X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X128X8_WT32X64X4_WS2X1_WR1X1_TA1X2X2X1_1X4X1X64_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X64_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X16X8_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X2X1X64_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X64X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X32X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X32X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X256X8_WT32X64X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT32X8X4_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X32X8_WT32X8X4_WS1X1_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X64_WT16X16X16_WS2X1_WR2X2_TA1X8X4X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT128X64X8_WT32X8X4_WS1X2_WR2X2_TA1X2X2X1_1X4X1X64_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X16X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X16X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X8X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X8X1X1_1X1X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X16_WT16X16X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X16X8_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X4X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X1X8X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X16_WT8X32X4_WS2X1_WR1X1_TA1X2X2X1_1X8X1X8_TB1X8X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X2X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X1X4X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X32X8_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X8X1X8_TB1X4X1X1_1X2X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X1X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT16X64X8_WT4X64X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X16_TB1X4X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X32X8_WT64X4X4_WS1X2_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT64X16X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X4X2X1_1X2X1X128_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT8X32X4_WS1X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X8_WT16X64X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X128X8_WT8X32X4_WS1X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X16_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X1X4X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X16_WT32X8X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X16_TB1X4X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X16_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X1X2X1_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X16X8_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X16_TB1X2X1X1_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X2X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X256X8_WT4X64X4_WS2X1_WR2X2_TA1X1X1X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X2X2X1_1X16X1X16_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X1X8X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X1X8X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X64_WT16X16X16_WS1X1_WR1X1_TA1X4X2X1_1X16X1X16_TB1X8X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X2X1_1X16X1X16_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X16X1X1_1X1X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X32X8_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT32X64X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT64X32X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X16X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT32X32X8_WS1X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT32X64X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT64X32X4_WS1X1_WR1X1_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X128X8_WT8X32X4_WS2X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X2X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X2_WR1X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X16X8_WT64X4X4_WS1X2_WR1X1_TA1X2X2X1_1X4X1X32_TB1X1X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT16X64X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X16X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X64X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X32X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X32X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X32X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT16X64X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X256X8_WT32X64X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X8X1X1_1X1X1X256[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X2X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X2X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X32_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X8X2X1_1X2X1X32_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X2X2X1_1X8X1X32_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS2X2_WR1X1_TA1X4X2X1_1X8X1X32_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X16X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X64_WT16X16X16_WS2X2_WR1X1_TA1X8X2X1_1X8X1X32_TB1X1X16X1_1X64X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X2X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X1X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT64X8X16_WT64X4X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X1X1X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X1X8X1_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NCHW_FP16_BX4_EX1_BT8X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X8_TB1X8X1X1_1X2X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X160X32_LT8X8_LW4X2_LR2X5_TA1X1X1X16_1X8X1X32_TB1X1X5X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X160X32_LT8X8_LW4X2_LR2X5_TA1X1X1X16_1X8X1X32_TB1X1X5X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X8X1X32_TB1X1X6X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X8X1X32_TB1X1X6X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X224X32_LT8X8_LW4X2_LR2X7_TA1X1X1X16_1X8X1X32_TB1X1X7X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X224X32_LT8X8_LW4X2_LR2X7_TA1X1X1X16_1X8X1X32_TB1X1X7X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X8X1X32_TB1X1X8X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X8X1X32_TB1X1X8X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X2X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X2X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X96X32_LT8X8_LW4X2_LR2X3_TA1X1X1X16_1X8X1X32_TB1X1X3X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT128X96X32_LT8X8_LW4X2_LR2X3_TA1X1X1X16_1X8X1X32_TB1X1X3X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT160X128X32_LT8X8_LW2X4_LR5X2_TA1X1X1X20_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT160X128X32_LT8X8_LW2X4_LR5X2_TA1X1X1X20_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT160X64X32_LT8X8_LW2X4_LR5X1_TA1X1X1X20_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT160X64X32_LT8X8_LW2X4_LR5X1_TA1X1X1X20_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT224X128X32_LT8X8_LW2X4_LR7X2_TA1X1X1X28_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT224X128X32_LT8X8_LW2X4_LR7X2_TA1X1X1X28_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X8X1X16_TB1X1X8X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X8X1X16_TB1X1X8X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X4_TB1X1X8X4_1X8X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X4_TB1X1X8X4_1X8X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X8X1X8_TB1X1X8X4_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X8X1X8_TB1X1X8X4_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X160X32_LT8X8_LW4X2_LR1X5_TA1X1X1X8_1X8X1X32_TB1X1X5X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X160X32_LT8X8_LW4X2_LR1X5_TA1X1X1X8_1X8X1X32_TB1X1X5X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X8X1X32_TB1X1X6X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X8X1X32_TB1X1X6X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X8X1X8_TB1X1X4X4_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X8X1X8_TB1X1X4X4_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X8X1X16_TB1X1X4X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X8X1X16_TB1X1X4X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X16X1X8_TB1X1X8X4_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X16X1X8_TB1X1X8X4_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT96X128X32_LT8X8_LW4X2_LR3X2_TA1X1X1X12_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT96X128X32_LT8X8_LW4X2_LR3X2_TA1X1X1X12_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X8X1X16_TB1X1X6X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX0_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X8X1X16_TB1X1X6X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X160X32_LT8X8_LW4X2_LR2X5_TA1X1X1X16_1X8X1X32_TB1X1X5X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X160X32_LT8X8_LW4X2_LR2X5_TA1X1X1X16_1X8X1X32_TB1X1X5X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X8X1X32_TB1X1X6X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X8X1X32_TB1X1X6X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X224X32_LT8X8_LW4X2_LR2X7_TA1X1X1X16_1X8X1X32_TB1X1X7X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X224X32_LT8X8_LW4X2_LR2X7_TA1X1X1X16_1X8X1X32_TB1X1X7X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X8X1X32_TB1X1X8X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X8X1X32_TB1X1X8X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X2X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X2X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X96X32_LT8X8_LW4X2_LR2X3_TA1X1X1X16_1X8X1X32_TB1X1X3X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT128X96X32_LT8X8_LW4X2_LR2X3_TA1X1X1X16_1X8X1X32_TB1X1X3X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT160X128X32_LT8X8_LW2X4_LR5X2_TA1X1X1X20_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT160X128X32_LT8X8_LW2X4_LR5X2_TA1X1X1X20_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT160X64X32_LT8X8_LW2X4_LR5X1_TA1X1X1X20_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT160X64X32_LT8X8_LW2X4_LR5X1_TA1X1X1X20_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT224X128X32_LT8X8_LW2X4_LR7X2_TA1X1X1X28_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT224X128X32_LT8X8_LW2X4_LR7X2_TA1X1X1X28_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X8X1X16_TB1X1X8X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X8X1X16_TB1X1X8X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X4_TB1X1X8X4_1X8X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X4_TB1X1X8X4_1X8X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X8X1X8_TB1X1X8X4_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X8X1X8_TB1X1X8X4_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X160X32_LT8X8_LW4X2_LR1X5_TA1X1X1X8_1X8X1X32_TB1X1X5X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X160X32_LT8X8_LW4X2_LR1X5_TA1X1X1X8_1X8X1X32_TB1X1X5X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X8X1X32_TB1X1X6X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X8X1X32_TB1X1X6X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X8X1X8_TB1X1X4X4_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X8X1X8_TB1X1X4X4_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X8X1X16_TB1X1X4X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X8X1X16_TB1X1X4X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X16X1X8_TB1X1X8X4_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X16X1X8_TB1X1X8X4_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT96X128X32_LT8X8_LW4X2_LR3X2_TA1X1X1X12_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT96X128X32_LT8X8_LW4X2_LR3X2_TA1X1X1X12_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X8X1X16_TB1X1X6X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X4_BX0_EX1_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X8X1X16_TB1X1X6X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X160X32_LT8X8_LW4X2_LR2X5_TA1X1X1X16_1X8X1X32_TB1X1X5X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X160X32_LT8X8_LW4X2_LR2X5_TA1X1X1X16_1X8X1X32_TB1X1X5X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X8X1X32_TB1X1X6X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X8X1X32_TB1X1X6X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X224X32_LT8X8_LW4X2_LR2X7_TA1X1X1X16_1X8X1X32_TB1X1X7X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X224X32_LT8X8_LW4X2_LR2X7_TA1X1X1X16_1X8X1X32_TB1X1X7X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X8X1X32_TB1X1X8X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X8X1X32_TB1X1X8X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X2X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X2X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X96X32_LT8X8_LW4X2_LR2X3_TA1X1X1X16_1X8X1X32_TB1X1X3X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT128X96X32_LT8X8_LW4X2_LR2X3_TA1X1X1X16_1X8X1X32_TB1X1X3X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT160X128X32_LT8X8_LW2X4_LR5X2_TA1X1X1X20_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT160X128X32_LT8X8_LW2X4_LR5X2_TA1X1X1X20_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT160X64X32_LT8X8_LW2X4_LR5X1_TA1X1X1X20_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT160X64X32_LT8X8_LW2X4_LR5X1_TA1X1X1X20_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT224X128X32_LT8X8_LW2X4_LR7X2_TA1X1X1X28_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT224X128X32_LT8X8_LW2X4_LR7X2_TA1X1X1X28_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X8X1X16_TB1X1X8X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X8X1X16_TB1X1X8X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X4_TB1X1X8X4_1X8X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X4_TB1X1X8X4_1X8X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X8X1X8_TB1X1X8X4_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X8X1X8_TB1X1X8X4_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X160X32_LT8X8_LW4X2_LR1X5_TA1X1X1X8_1X8X1X32_TB1X1X5X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X160X32_LT8X8_LW4X2_LR1X5_TA1X1X1X8_1X8X1X32_TB1X1X5X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X8X1X32_TB1X1X6X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X8X1X32_TB1X1X6X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X8X1X8_TB1X1X4X4_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X8X1X8_TB1X1X4X4_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X8X1X16_TB1X1X4X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X8X1X16_TB1X1X4X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X16X1X8_TB1X1X8X4_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X16X1X8_TB1X1X8X4_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT96X128X32_LT8X8_LW4X2_LR3X2_TA1X1X1X12_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT96X128X32_LT8X8_LW4X2_LR3X2_TA1X1X1X12_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X8X1X16_TB1X1X6X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX0_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X8X1X16_TB1X1X6X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X160X32_LT8X8_LW4X2_LR2X5_TA1X1X1X16_1X8X1X32_TB1X1X5X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X160X32_LT8X8_LW4X2_LR2X5_TA1X1X1X16_1X8X1X32_TB1X1X5X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X8X1X32_TB1X1X6X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X8X1X32_TB1X1X6X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X224X32_LT8X8_LW4X2_LR2X7_TA1X1X1X16_1X8X1X32_TB1X1X7X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X224X32_LT8X8_LW4X2_LR2X7_TA1X1X1X16_1X8X1X32_TB1X1X7X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X8X1X32_TB1X1X8X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X8X1X32_TB1X1X8X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X2X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X2X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X96X32_LT8X8_LW4X2_LR2X3_TA1X1X1X16_1X8X1X32_TB1X1X3X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT128X96X32_LT8X8_LW4X2_LR2X3_TA1X1X1X16_1X8X1X32_TB1X1X3X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT160X128X32_LT8X8_LW2X4_LR5X2_TA1X1X1X20_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT160X128X32_LT8X8_LW2X4_LR5X2_TA1X1X1X20_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT160X64X32_LT8X8_LW2X4_LR5X1_TA1X1X1X20_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT160X64X32_LT8X8_LW2X4_LR5X1_TA1X1X1X20_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X2X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X2X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT224X128X32_LT8X8_LW2X4_LR7X2_TA1X1X1X28_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT224X128X32_LT8X8_LW2X4_LR7X2_TA1X1X1X28_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X8X1X16_TB1X1X8X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X8X1X16_TB1X1X8X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X4_TB1X1X8X4_1X8X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X4_TB1X1X8X4_1X8X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X8X1X8_TB1X1X8X4_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X8X1X8_TB1X1X8X4_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X160X32_LT8X8_LW4X2_LR1X5_TA1X1X1X8_1X8X1X32_TB1X1X5X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X160X32_LT8X8_LW4X2_LR1X5_TA1X1X1X8_1X8X1X32_TB1X1X5X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X8X1X32_TB1X1X6X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X8X1X32_TB1X1X6X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X8X1X8_TB1X1X4X4_1X8X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X8X1X8_TB1X1X4X4_1X8X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X8X1X16_TB1X1X4X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X8X1X16_TB1X1X4X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X16X1X8_TB1X1X8X4_1X16X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X16X1X8_TB1X1X8X4_1X16X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT96X128X32_LT8X8_LW4X2_LR3X2_TA1X1X1X12_1X8X1X32_TB1X1X4X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT96X128X32_LT8X8_LW4X2_LR3X2_TA1X1X1X12_1X8X1X32_TB1X1X4X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X8X1X16_TB1X1X6X4_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X4_BX0_EX1_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X8X1X16_TB1X1X6X4_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X160X64_LT8X8_LW4X2_LR2X5_TA1X1X1X32_1X8X1X32_TB1X1X5X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X160X64_LT8X8_LW4X2_LR2X5_TA1X1X1X32_1X8X1X32_TB1X1X5X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X4X1X64_TB1X1X3X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X4X1X64_TB1X1X3X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X224X64_LT8X8_LW4X2_LR2X7_TA1X1X1X32_1X8X1X32_TB1X1X7X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X224X64_LT8X8_LW4X2_LR2X7_TA1X1X1X32_1X8X1X32_TB1X1X7X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X4X1X64_TB1X1X4X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X4X1X64_TB1X1X4X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X4X1X32_TB1X1X1X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X4X1X32_TB1X1X1X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X4X1X64_TB1X1X1X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X4X1X64_TB1X1X1X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X96X64_LT8X8_LW4X2_LR2X3_TA1X1X1X32_1X8X1X32_TB1X1X3X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT128X96X64_LT8X8_LW4X2_LR2X3_TA1X1X1X32_1X8X1X32_TB1X1X3X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT160X128X64_LT8X8_LW2X4_LR5X2_TA1X1X1X40_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT160X128X64_LT8X8_LW2X4_LR5X2_TA1X1X1X40_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT160X64X64_LT8X8_LW2X4_LR5X1_TA1X1X1X40_1X8X1X32_TB1X1X2X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT160X64X64_LT8X8_LW2X4_LR5X1_TA1X1X1X40_1X8X1X32_TB1X1X2X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X4X1X64_TB1X1X1X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X4X1X64_TB1X1X1X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT224X128X64_LT8X8_LW2X4_LR7X2_TA1X1X1X56_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT224X128X64_LT8X8_LW2X4_LR7X2_TA1X1X1X56_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X4X1X32_TB1X1X4X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X4X1X32_TB1X1X4X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X4X1X8_TB1X1X4X8_1X4X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X4X1X8_TB1X1X4X8_1X4X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X4X1X16_TB1X1X4X8_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X4X1X16_TB1X1X4X8_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X160X64_LT8X8_LW4X2_LR1X5_TA1X1X1X16_1X8X1X32_TB1X1X5X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X160X64_LT8X8_LW4X2_LR1X5_TA1X1X1X16_1X8X1X32_TB1X1X5X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X4X1X64_TB1X1X3X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X4X1X64_TB1X1X3X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X4X1X16_TB1X1X2X8_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X4X1X16_TB1X1X2X8_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X4X1X32_TB1X1X2X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X4X1X32_TB1X1X2X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X4X8_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X4X8_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT96X128X64_LT8X8_LW4X2_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT96X128X64_LT8X8_LW4X2_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X4X1X32_TB1X1X3X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX0_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X4X1X32_TB1X1X3X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X160X64_LT8X8_LW4X2_LR2X5_TA1X1X1X32_1X8X1X32_TB1X1X5X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X160X64_LT8X8_LW4X2_LR2X5_TA1X1X1X32_1X8X1X32_TB1X1X5X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X4X1X64_TB1X1X3X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X4X1X64_TB1X1X3X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X224X64_LT8X8_LW4X2_LR2X7_TA1X1X1X32_1X8X1X32_TB1X1X7X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X224X64_LT8X8_LW4X2_LR2X7_TA1X1X1X32_1X8X1X32_TB1X1X7X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X4X1X64_TB1X1X4X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X4X1X64_TB1X1X4X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X4X1X32_TB1X1X1X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X4X1X32_TB1X1X1X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X4X1X64_TB1X1X1X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X4X1X64_TB1X1X1X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X96X64_LT8X8_LW4X2_LR2X3_TA1X1X1X32_1X8X1X32_TB1X1X3X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT128X96X64_LT8X8_LW4X2_LR2X3_TA1X1X1X32_1X8X1X32_TB1X1X3X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT160X128X64_LT8X8_LW2X4_LR5X2_TA1X1X1X40_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT160X128X64_LT8X8_LW2X4_LR5X2_TA1X1X1X40_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT160X64X64_LT8X8_LW2X4_LR5X1_TA1X1X1X40_1X8X1X32_TB1X1X2X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT160X64X64_LT8X8_LW2X4_LR5X1_TA1X1X1X40_1X8X1X32_TB1X1X2X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X4X1X64_TB1X1X1X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X4X1X64_TB1X1X1X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT224X128X64_LT8X8_LW2X4_LR7X2_TA1X1X1X56_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT224X128X64_LT8X8_LW2X4_LR7X2_TA1X1X1X56_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X4X1X32_TB1X1X4X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X4X1X32_TB1X1X4X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X4X1X8_TB1X1X4X8_1X4X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X4X1X8_TB1X1X4X8_1X4X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X4X1X16_TB1X1X4X8_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X4X1X16_TB1X1X4X8_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X160X64_LT8X8_LW4X2_LR1X5_TA1X1X1X16_1X8X1X32_TB1X1X5X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X160X64_LT8X8_LW4X2_LR1X5_TA1X1X1X16_1X8X1X32_TB1X1X5X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X4X1X64_TB1X1X3X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X4X1X64_TB1X1X3X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X4X1X16_TB1X1X2X8_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X4X1X16_TB1X1X2X8_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X4X1X32_TB1X1X2X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X4X1X32_TB1X1X2X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X4X8_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X4X8_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT96X128X64_LT8X8_LW4X2_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT96X128X64_LT8X8_LW4X2_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X4X1X32_TB1X1X3X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_CYXKC_FP16X8_BX0_EX1_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X4X1X32_TB1X1X3X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X160X64_LT8X8_LW4X2_LR2X5_TA1X1X1X32_1X8X1X32_TB1X1X5X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X160X64_LT8X8_LW4X2_LR2X5_TA1X1X1X32_1X8X1X32_TB1X1X5X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X4X1X64_TB1X1X3X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X4X1X64_TB1X1X3X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X224X64_LT8X8_LW4X2_LR2X7_TA1X1X1X32_1X8X1X32_TB1X1X7X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X224X64_LT8X8_LW4X2_LR2X7_TA1X1X1X32_1X8X1X32_TB1X1X7X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X4X1X64_TB1X1X4X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X4X1X64_TB1X1X4X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X4X1X32_TB1X1X1X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X4X1X32_TB1X1X1X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X4X1X64_TB1X1X1X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X4X1X64_TB1X1X1X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X96X64_LT8X8_LW4X2_LR2X3_TA1X1X1X32_1X8X1X32_TB1X1X3X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT128X96X64_LT8X8_LW4X2_LR2X3_TA1X1X1X32_1X8X1X32_TB1X1X3X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT160X128X64_LT8X8_LW2X4_LR5X2_TA1X1X1X40_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT160X128X64_LT8X8_LW2X4_LR5X2_TA1X1X1X40_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT160X64X64_LT8X8_LW2X4_LR5X1_TA1X1X1X40_1X8X1X32_TB1X1X2X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT160X64X64_LT8X8_LW2X4_LR5X1_TA1X1X1X40_1X8X1X32_TB1X1X2X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X4X1X64_TB1X1X1X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X4X1X64_TB1X1X1X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT224X128X64_LT8X8_LW2X4_LR7X2_TA1X1X1X56_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT224X128X64_LT8X8_LW2X4_LR7X2_TA1X1X1X56_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X4X1X32_TB1X1X4X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X4X1X32_TB1X1X4X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X4X1X8_TB1X1X4X8_1X4X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X4X1X8_TB1X1X4X8_1X4X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X4X1X16_TB1X1X4X8_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X4X1X16_TB1X1X4X8_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X160X64_LT8X8_LW4X2_LR1X5_TA1X1X1X16_1X8X1X32_TB1X1X5X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X160X64_LT8X8_LW4X2_LR1X5_TA1X1X1X16_1X8X1X32_TB1X1X5X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X4X1X64_TB1X1X3X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X4X1X64_TB1X1X3X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X4X1X16_TB1X1X2X8_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X4X1X16_TB1X1X2X8_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X4X1X32_TB1X1X2X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X4X1X32_TB1X1X2X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X4X8_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X4X8_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT96X128X64_LT8X8_LW4X2_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT96X128X64_LT8X8_LW4X2_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X4X1X32_TB1X1X3X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX0_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X4X1X32_TB1X1X3X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X128X32_LT8X8_LW2X4_LR2X4_TA1X1X1X16_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X160X64_LT8X8_LW4X2_LR2X5_TA1X1X1X32_1X8X1X32_TB1X1X5X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X160X64_LT8X8_LW4X2_LR2X5_TA1X1X1X32_1X8X1X32_TB1X1X5X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X4X1X64_TB1X1X3X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X192X32_LT8X8_LW2X4_LR2X6_TA1X1X1X16_1X4X1X64_TB1X1X3X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X224X64_LT8X8_LW4X2_LR2X7_TA1X1X1X32_1X8X1X32_TB1X1X7X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X224X64_LT8X8_LW4X2_LR2X7_TA1X1X1X32_1X8X1X32_TB1X1X7X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X4X1X64_TB1X1X4X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X256X32_LT8X8_LW2X4_LR2X8_TA1X1X1X16_1X4X1X64_TB1X1X4X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X4X1X32_TB1X1X1X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X32X32_LT8X8_LW4X1_LR2X2_TA1X1X1X32_1X4X1X32_TB1X1X1X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X4X1X64_TB1X1X1X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X64X32_LT8X8_LW4X2_LR2X2_TA1X1X1X16_1X4X1X64_TB1X1X1X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X96X64_LT8X8_LW4X2_LR2X3_TA1X1X1X32_1X8X1X32_TB1X1X3X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT128X96X64_LT8X8_LW4X2_LR2X3_TA1X1X1X32_1X8X1X32_TB1X1X3X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT160X128X64_LT8X8_LW2X4_LR5X2_TA1X1X1X40_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT160X128X64_LT8X8_LW2X4_LR5X2_TA1X1X1X40_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT160X64X64_LT8X8_LW2X4_LR5X1_TA1X1X1X40_1X8X1X32_TB1X1X2X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT160X64X64_LT8X8_LW2X4_LR5X1_TA1X1X1X40_1X8X1X32_TB1X1X2X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT192X128X32_LT8X8_LW2X4_LR3X4_TA1X1X1X24_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X4X1X64_TB1X1X1X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT192X64X32_LT8X8_LW2X4_LR3X2_TA1X1X1X24_1X4X1X64_TB1X1X1X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT224X128X64_LT8X8_LW2X4_LR7X2_TA1X1X1X56_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT224X128X64_LT8X8_LW2X4_LR7X2_TA1X1X1X56_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT256X128X32_LT8X8_LW4X2_LR2X8_TA1X1X1X32_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X4X1X32_TB1X1X4X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT32X128X32_LT8X8_LW1X4_LR2X2_TA1X1X1X8_1X4X1X32_TB1X1X4X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X4X1X8_TB1X1X4X8_1X4X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT32X32X32_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X4X1X8_TB1X1X4X8_1X4X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X4X1X16_TB1X1X4X8_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT32X64X32_LT8X8_LW2X4_LR2X2_TA1X1X1X16_1X4X1X16_TB1X1X4X8_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X4X1X64_TB1X1X2X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X128X32_LT8X8_LW2X4_LR2X2_TA1X1X1X8_1X4X1X64_TB1X1X2X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X160X64_LT8X8_LW4X2_LR1X5_TA1X1X1X16_1X8X1X32_TB1X1X5X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X160X64_LT8X8_LW4X2_LR1X5_TA1X1X1X16_1X8X1X32_TB1X1X5X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X4X1X64_TB1X1X3X8_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X192X32_LT8X8_LW2X4_LR1X6_TA1X1X1X8_1X4X1X64_TB1X1X3X8_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X4X1X16_TB1X1X2X8_1X4X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X32X32_LT8X8_LW4X2_LR2X2_TA1X1X1X32_1X4X1X16_TB1X1X2X8_1X4X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X4X1X32_TB1X1X2X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X64X32_LT8X8_LW2X2_LR2X2_TA1X1X1X16_1X4X1X32_TB1X1X2X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X4X8_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT64X64X64_LT8X8_LW2X2_LR2X2_TA1X1X1X32_1X8X1X16_TB1X1X4X8_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT96X128X64_LT8X8_LW4X2_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X4X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT96X128X64_LT8X8_LW4X2_LR3X2_TA1X1X1X24_1X8X1X32_TB1X1X4X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X4X1X32_TB1X1X3X8_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCN2_NCHWC_KCYXC_FP16X8_BX0_EX1_BT96X96X32_LT8X8_LW2X2_LR3X3_TA1X1X1X24_1X4X1X32_TB1X1X3X8_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X16X16_WT32X8X4_WS2X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X16X16_WT32X8X4_WS2X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X16X16_WT32X8X4_WS2X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X16X16_WT32X8X4_WS2X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X128X16_WT8X32X4_WS1X2_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X128X16_WT8X32X4_WS1X2_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X128X16_WT8X32X4_WS1X2_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X128X16_WT8X32X4_WS1X2_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X1X2_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X1X2_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X1X2_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X1X2_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X16_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X16_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X16_1X16X1X4_TB1X1X1X1_1X16X1X4_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X16_1X16X1X4_TB1X1X1X1_1X16X1X4_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX16_EX1_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X1X16_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX1_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X1X16_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX1_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X16X32_WT32X8X4_WS2X1_WR1X1_TA1X2X1X8_1X16X1X16_TB1X2X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X16X32_WT32X8X4_WS2X1_WR1X1_TA1X2X1X8_1X16X1X16_TB1X2X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X16X32_WT32X8X4_WS2X1_WR1X1_TA1X2X1X8_1X16X1X16_TB1X2X1X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X16X32_WT32X8X4_WS2X1_WR1X1_TA1X2X1X8_1X16X1X16_TB1X2X1X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X2X1X4_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X32X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X32X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X32X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X32X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X128X32_WT8X32X4_WS1X2_WR1X1_TA1X2X1X1_1X16X1X16_TB1X2X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X128X32_WT8X32X4_WS1X2_WR1X1_TA1X2X1X1_1X16X1X16_TB1X2X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X128X32_WT8X32X4_WS1X2_WR1X1_TA1X2X1X1_1X16X1X16_TB1X2X8X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X128X32_WT8X32X4_WS1X2_WR1X1_TA1X2X1X1_1X16X1X16_TB1X2X8X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X256X32_WT4X64X4_WS1X1_WR2X2_TA1X2X1X1_1X16X1X16_TB1X2X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X256X32_WT4X64X4_WS1X1_WR2X2_TA1X2X1X1_1X16X1X16_TB1X2X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X256X32_WT4X64X4_WS1X1_WR2X2_TA1X2X1X1_1X16X1X16_TB1X2X16X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X256X32_WT4X64X4_WS1X1_WR2X2_TA1X2X1X1_1X16X1X16_TB1X2X16X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X64X32_WT4X64X4_WS1X1_WR1X1_TA1X2X1X1_1X16X1X16_TB1X2X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X64X32_WT4X64X4_WS1X1_WR1X1_TA1X2X1X1_1X16X1X16_TB1X2X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X64X32_WT4X64X4_WS1X1_WR1X1_TA1X2X1X1_1X16X1X16_TB1X2X4X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT16X64X32_WT4X64X4_WS1X1_WR1X1_TA1X2X1X1_1X16X1X16_TB1X2X4X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X16X32_WT64X4X4_WS1X1_WR2X2_TA1X2X1X16_1X16X1X16_TB1X2X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X16X32_WT64X4X4_WS1X1_WR2X2_TA1X2X1X16_1X16X1X16_TB1X2X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X16X32_WT64X4X4_WS1X1_WR2X2_TA1X2X1X16_1X16X1X16_TB1X2X1X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X16X32_WT64X4X4_WS1X1_WR2X2_TA1X2X1X16_1X16X1X16_TB1X2X1X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X2X1X8_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X32X32_WT64X4X4_WS1X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X32X32_WT64X4X4_WS1X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X32X32_WT64X4X4_WS1X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X32X32_WT64X4X4_WS1X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X4X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X4X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X128X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X128X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X128X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X128X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X8X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X2X1X1_1X8X1X32_TB1X2X8X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X256X32_WT4X64X4_WS2X1_WR2X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X256X32_WT4X64X4_WS2X1_WR2X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X256X32_WT4X64X4_WS2X1_WR2X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X256X32_WT4X64X4_WS2X1_WR2X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X2X1X1_1X8X1X32_TB1X2X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X64X32_WT8X32X4_WS2X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X64X32_WT8X32X4_WS2X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X64X32_WT8X32X4_WS2X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT32X64X32_WT8X32X4_WS2X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT4X64X32_WT4X64X4_WS1X1_WR1X1_TA1X2X1X1_1X16X1X4_TB1X2X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT4X64X32_WT4X64X4_WS1X1_WR1X1_TA1X2X1X1_1X16X1X4_TB1X2X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT4X64X32_WT4X64X4_WS1X1_WR1X1_TA1X2X1X1_1X16X1X4_TB1X2X16X1_1X16X1X4_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT4X64X32_WT4X64X4_WS1X1_WR1X1_TA1X2X1X1_1X16X1X4_TB1X2X16X1_1X16X1X4_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT16X16X16_WS1X2_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT16X16X16_WS1X2_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT16X16X16_WS1X2_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X128X32_WT16X16X16_WS1X2_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X16X32_WT64X4X4_WS1X1_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X16X32_WT64X4X4_WS1X1_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X16X32_WT64X4X4_WS1X1_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X1X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X16X32_WT64X4X4_WS1X1_WR1X1_TA1X2X1X4_1X16X1X16_TB1X2X1X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X2X1X2_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X32X32_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X32X32_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X32X32_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X32X32_WT32X8X4_WS1X2_WR1X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X4X32_WT64X4X4_WS1X1_WR1X1_TA1X2X1X16_1X16X1X4_TB1X2X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X4X32_WT64X4X4_WS1X1_WR1X1_TA1X2X1X16_1X16X1X4_TB1X2X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X4X32_WT64X4X4_WS1X1_WR1X1_TA1X2X1X16_1X16X1X4_TB1X2X1X1_1X16X1X4_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X4X32_WT64X4X4_WS1X1_WR1X1_TA1X2X1X16_1X16X1X4_TB1X2X1X1_1X16X1X4_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX0_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT32X8X4_WS2X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT32X8X4_WS2X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT32X8X4_WS2X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X16X16_WT32X8X4_WS2X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X16X32_WT32X8X4_WS2X1_WR1X1_TA1X1X1X16_1X32X1X8_TB1X1X2X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X16X32_WT32X8X4_WS2X1_WR1X1_TA1X1X1X16_1X32X1X8_TB1X1X2X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X16X32_WT32X8X4_WS2X1_WR1X1_TA1X1X1X16_1X32X1X8_TB1X1X2X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X16X32_WT32X8X4_WS2X1_WR1X1_TA1X1X1X16_1X32X1X8_TB1X1X2X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X32X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X16_1X32X1X8_TB1X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X32X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X16_1X32X1X8_TB1X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X32X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X16_1X32X1X8_TB1X1X4X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X32X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X16_1X32X1X8_TB1X1X4X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X64X16_WT32X8X4_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X1X1X16_1X32X1X8_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X1X1X16_1X32X1X8_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X1X1X16_1X32X1X8_TB1X1X8X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT128X64X32_WT16X16X16_WS2X1_WR2X2_TA1X1X1X16_1X32X1X8_TB1X1X8X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT8X32X4_WS1X2_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT8X32X4_WS1X2_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT8X32X4_WS1X2_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X128X16_WT8X32X4_WS1X2_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X128X32_WT8X32X4_WS1X2_WR1X1_TA1X1X1X2_1X32X1X8_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X128X32_WT8X32X4_WS1X2_WR1X1_TA1X1X1X2_1X32X1X8_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X128X32_WT8X32X4_WS1X2_WR1X1_TA1X1X1X2_1X32X1X8_TB1X1X16X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X128X32_WT8X32X4_WS1X2_WR1X1_TA1X1X1X2_1X32X1X8_TB1X1X16X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X256X16_WT4X64X4_WS1X1_WR2X2_TA1X1X1X1_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X256X32_WT4X64X4_WS1X1_WR2X2_TA1X1X1X2_1X32X1X8_TB1X1X32X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X256X32_WT4X64X4_WS1X1_WR2X2_TA1X1X1X2_1X32X1X8_TB1X1X32X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X256X32_WT4X64X4_WS1X1_WR2X2_TA1X1X1X2_1X32X1X8_TB1X1X32X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X256X32_WT4X64X4_WS1X1_WR2X2_TA1X1X1X2_1X32X1X8_TB1X1X32X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X64X32_WT4X64X4_WS1X1_WR1X1_TA1X1X1X2_1X32X1X8_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X64X32_WT4X64X4_WS1X1_WR1X1_TA1X1X1X2_1X32X1X8_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X64X32_WT4X64X4_WS1X1_WR1X1_TA1X1X1X2_1X32X1X8_TB1X1X8X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT16X64X32_WT4X64X4_WS1X1_WR1X1_TA1X1X1X2_1X32X1X8_TB1X1X8X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X16X16_WT64X4X4_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X16X32_WT64X4X4_WS1X1_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X2X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X16X32_WT64X4X4_WS1X1_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X2X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X16X32_WT64X4X4_WS1X1_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X2X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X16X32_WT64X4X4_WS1X1_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X2X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X32X16_WT64X4X4_WS1X2_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X32X32_WT64X4X4_WS1X2_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X32X32_WT64X4X4_WS1X2_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X32X32_WT64X4X4_WS1X2_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X4X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X32X32_WT64X4X4_WS1X2_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X4X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X8X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X1X1X32_1X32X1X8_TB1X1X8X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X128X16_WT16X64X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X128X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X4_1X32X1X8_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X128X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X4_1X32X1X8_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X128X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X4_1X32X1X8_TB1X1X16X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X128X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X4_1X32X1X8_TB1X1X16X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X1X2_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X1X2_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X1X2_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X256X16_WT4X64X4_WS2X1_WR2X2_TA1X1X1X2_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X256X32_WT4X64X4_WS2X1_WR2X2_TA1X1X1X4_1X32X1X8_TB1X1X32X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X256X32_WT4X64X4_WS2X1_WR2X2_TA1X1X1X4_1X32X1X8_TB1X1X32X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X256X32_WT4X64X4_WS2X1_WR2X2_TA1X1X1X4_1X32X1X8_TB1X1X32X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X256X32_WT4X64X4_WS2X1_WR2X2_TA1X1X1X4_1X32X1X8_TB1X1X32X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X32X16_WT16X16X4_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X4X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X32X32_WT16X16X16_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X4X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X64X16_WT8X32X4_WS2X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X64X32_WT8X32X4_WS2X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X64X32_WT8X32X4_WS2X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X64X32_WT8X32X4_WS2X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X8X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT32X64X32_WT8X32X4_WS2X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X8X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT4X64X16_WT4X64X4_WS1X1_WR1X1_TA1X1X1X1_1X16X1X4_TB1X1X16X1_1X16X1X4_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT4X64X32_WT4X64X4_WS1X1_WR1X1_TA1X1X1X2_1X32X1X2_TB1X1X32X1_1X32X1X2_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT4X64X32_WT4X64X4_WS1X1_WR1X1_TA1X1X1X2_1X32X1X2_TB1X1X32X1_1X32X1X2[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT4X64X32_WT4X64X4_WS1X1_WR1X1_TA1X1X1X2_1X32X1X2_TB1X1X32X1_1X32X1X2_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT4X64X32_WT4X64X4_WS1X1_WR1X1_TA1X1X1X2_1X32X1X2_TB1X1X32X1_1X32X1X2_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X8X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X8X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X128X16_WT8X32X4_WS2X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X8X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT16X16X16_WS1X2_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X16X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT16X16X16_WS1X2_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X16X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT16X16X16_WS1X2_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X16X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X128X32_WT16X16X16_WS1X2_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X16X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X16X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X16X32_WT64X4X4_WS1X1_WR1X1_TA1X1X1X8_1X32X1X8_TB1X1X2X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X16X32_WT64X4X4_WS1X1_WR1X1_TA1X1X1X8_1X32X1X8_TB1X1X2X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X16X32_WT64X4X4_WS1X1_WR1X1_TA1X1X1X8_1X32X1X8_TB1X1X2X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X16X32_WT64X4X4_WS1X1_WR1X1_TA1X1X1X8_1X32X1X8_TB1X1X2X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X16X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X16X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X16X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X32X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X32X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X32X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X32X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X2X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X2X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X32X16_WT32X8X4_WS1X2_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X2X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X32X32_WT32X8X4_WS1X2_WR1X1_TA1X1X1X8_1X32X1X8_TB1X1X4X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X32X32_WT32X8X4_WS1X2_WR1X1_TA1X1X1X8_1X32X1X8_TB1X1X4X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X32X32_WT32X8X4_WS1X2_WR1X1_TA1X1X1X8_1X32X1X8_TB1X1X4X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X32X32_WT32X8X4_WS1X2_WR1X1_TA1X1X1X8_1X32X1X8_TB1X1X4X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X16_1X16X1X4_TB1X1X1X1_1X16X1X4_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X16_1X16X1X4_TB1X1X1X1_1X16X1X4[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X16_1X16X1X4_TB1X1X1X1_1X16X1X4_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X4X16_WT64X4X4_WS1X1_WR1X1_TA1X1X1X16_1X16X1X4_TB1X1X1X1_1X16X1X4_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X4X32_WT64X4X4_WS1X1_WR1X1_TA1X1X1X32_1X32X1X2_TB1X1X2X1_1X32X1X2_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X4X32_WT64X4X4_WS1X1_WR1X1_TA1X1X1X32_1X32X1X2_TB1X1X2X1_1X32X1X2[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X4X32_WT64X4X4_WS1X1_WR1X1_TA1X1X1X32_1X32X1X2_TB1X1X2X1_1X32X1X2_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X4X32_WT64X4X4_WS1X1_WR1X1_TA1X1X1X32_1X32X1X2_TB1X1X2X1_1X32X1X2_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X4X1_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X4X1_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X4X1_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X8X1_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X8X1_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X8X1_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX4_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X1X1X8_1X32X1X8_TB1X1X8X1_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX8_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX8_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX8_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX8_EX1_BT32X32X8_WT16X16X4_WS1X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX8_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX8_EX1_BT32X64X8_WT8X32X4_WS2X1_WR1X1_TA1X1X1X1_1X8X1X32_TB1X1X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX8_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X1X2_1X8X1X32_TB1X1X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX8_EX1_BT64X32X8_WT32X8X4_WS1X2_WR1X1_TA1X1X1X2_1X8X1X32_TB1X1X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX8_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NCHW_FP16_BX8_EX1_BT64X64X32_WT16X16X16_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X4_WT32X32X2_WS1X1_WR2X2_TA1X1X2X1_1X4X1X64_TB1X1X2X1_1X4X1X64_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X4_WT32X32X2_WS1X1_WR2X2_TA1X1X2X1_1X4X1X64_TB1X1X2X1_1X4X1X64_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X4_WT32X32X2_WS1X1_WR2X2_TA1X1X2X1_1X4X1X64_TB1X1X2X1_1X4X1X64_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X4_WT32X32X2_WS1X1_WR2X2_TA1X1X2X1_1X4X1X64_TB1X1X2X1_1X4X1X64_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X4_WT64X32X1_WS1X1_WR1X1_TA1X1X4X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X4_WT64X32X1_WS1X1_WR1X1_TA1X1X4X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X4_WT64X32X1_WS1X1_WR1X1_TA1X1X4X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X4_WT64X32X1_WS1X1_WR1X1_TA1X1X4X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X8_WT32X32X2_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X8_WT32X32X2_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X8_WT32X32X2_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X8_WT32X32X2_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X4_WT64X32X1_WS1X1_WR1X1_TA1X1X2X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X4_WT64X32X1_WS1X1_WR1X1_TA1X1X2X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X4_WT64X32X1_WS1X1_WR1X1_TA1X1X2X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X4_WT64X32X1_WS1X1_WR1X1_TA1X1X2X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X4_WT64X32X1_WS1X1_WR2X1_TA1X1X8X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X4_WT64X32X1_WS1X1_WR2X1_TA1X1X8X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X4_WT64X32X1_WS1X1_WR2X1_TA1X1X8X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X4_WT64X32X1_WS1X1_WR2X1_TA1X1X8X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X8_WT32X32X2_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X8_WT32X32X2_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X8_WT32X32X2_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X8_WT32X32X2_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X4_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X4_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X4_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X4_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X4_WT16X16X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X4_WT16X16X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X4_WT16X16X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X4_WT16X16X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X4X1_1X16X1X8_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X4X1_1X16X1X8_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X8_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X2X4X32_TB1X2X1X1_1X4X1X64_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X8_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X2X4X32_TB1X2X1X1_1X4X1X64_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X8_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X2X4X32_TB1X2X1X1_1X4X1X64_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT128X64X8_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X2X4X32_TB1X2X1X1_1X4X1X64_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X2X8X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X2X8X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X2X8X1_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X2X8X1_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X4_WT32X32X1_WS1X1_WR2X2_TA1X1X2X1_1X4X1X64_TB1X1X2X1_1X4X1X64_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X4_WT32X32X1_WS1X1_WR2X2_TA1X1X2X1_1X4X1X64_TB1X1X2X1_1X4X1X64_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X2X1X128_TB1X4X1X1_1X2X1X128_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X4_WT64X32X1_WS1X1_WR1X1_TA1X1X4X1_1X4X1X32_TB1X1X1X1_1X4X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X4_WT64X32X1_WS1X1_WR1X1_TA1X1X4X1_1X4X1X32_TB1X1X1X1_1X4X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X8_WT32X32X2_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X32X8_WT32X32X2_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X4_WT64X32X1_WS1X1_WR1X1_TA1X1X2X1_1X4X1X64_TB1X1X1X1_1X4X1X64_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X4_WT64X32X1_WS1X1_WR1X1_TA1X1X2X1_1X4X1X64_TB1X1X1X1_1X4X1X64_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR1X2_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR1X2_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X2X4X32_TB1X2X1X1_1X4X1X64_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X2X4X32_TB1X2X1X1_1X4X1X64_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X2X4X32_TB1X2X1X1_1X4X1X64_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X2X4X32_TB1X2X1X1_1X4X1X64_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X2X8X1_1X8X1X32_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X2X8X1_1X8X1X32_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X2X8X1_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X2X8X1_1X8X1X32_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X4_WT64X32X1_WS1X1_WR2X1_TA1X1X8X1_1X4X1X32_TB1X1X1X1_1X4X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X4_WT64X32X1_WS1X1_WR2X1_TA1X1X8X1_1X4X1X32_TB1X1X1X1_1X4X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X8_WT32X32X2_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X32X8_WT32X32X2_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT256X64X4_WT64X16X1_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X128X16_WT32X32X8_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X128X16_WT32X32X8_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X128X16_WT32X32X8_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X128X16_WT32X32X8_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT16X16X16_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT16X16X16_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT16X16X16_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X32X32_WT16X16X16_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX0_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X256X16_WT32X32X8_WS1X2_WR2X2_TA1X4X1X2_1X4X1X64_TB1X4X1X4_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X4X1X4_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X4X1X4_1X8X1X32_TB1X4X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X128X16_WT32X32X8_WS2X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X1X8_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X64X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X4_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X8_1X8X1X32_TB1X4X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X128X16_WT32X32X8_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X128X16_WT32X32X8_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X128X16_WT32X32X8_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X128X16_WT32X32X8_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X4X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X256X16_WT32X32X8_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X4_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X4X1X2_1X8X1X32_TB1X4X1X8_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT16X16X16_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT16X16X16_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT16X16X16_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X32X32_WT16X16X16_WS1X1_WR2X1_TA1X4X1X2_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X64X16_WT32X32X8_WS1X1_WR1X1_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X64X32_WT32X32X8_WS1X1_WR1X1_TA1X8X1X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X64X32_WT32X32X8_WS1X1_WR1X1_TA1X8X1X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP16_BX0_EX1_BT64X64X64_WT32X32X8_WS1X1_WR1X1_TA1X4X1X4_1X16X1X16_TB1X4X1X4_1X16X1X16_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X2_WR1X2_TA1X1X1X8_1X16X1X16_TB1X1X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X2_WR1X2_TA1X1X1X8_1X16X1X16_TB1X1X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X2_WR1X2_TA1X1X1X8_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X2_WR1X2_TA1X1X1X8_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X256X16_WT32X32X2_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X1X16_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X256X16_WT32X32X2_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X1X16_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X256X16_WT32X32X2_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X256X16_WT32X32X2_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X8_1X16X1X16_TB1X1X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X8_1X16X1X16_TB1X1X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X8_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X8_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X128X16_WT32X32X2_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X128X16_WT32X32X2_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X128X16_WT32X32X2_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X128X16_WT32X32X2_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X16_1X16X1X16_TB1X1X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X16_1X16X1X16_TB1X1X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X16_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X16_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X128X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X128X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X128X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X128X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X256X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X16_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X256X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X16_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X256X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X256X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X32X32_WT16X16X4_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X1X4_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X32X32_WT16X16X4_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X1X4_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X32X32_WT16X16X4_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X1X4_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X32X32_WT16X16X4_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X1X4_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X64X16_WT16X16X4_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X64X16_WT16X16X4_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X64X16_WT16X16X4_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT32X64X16_WT16X16X4_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X4_1X16X1X16_TB1X1X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X4_1X16X1X16_TB1X1X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X4_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X4_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X1X16_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X1X16_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X1X1X4_1X16X1X16_TB1X1X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X1X1X4_1X16X1X16_TB1X1X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X1X1X4_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X1X1X4_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X64X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X64X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X64X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX0_BT64X64X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X2_WR1X2_TA1X1X1X8_1X16X1X16_TB1X1X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X2_WR1X2_TA1X1X1X8_1X16X1X16_TB1X1X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X2_WR1X2_TA1X1X1X8_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X2_WR1X2_TA1X1X1X8_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X256X16_WT32X32X2_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X1X16_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X256X16_WT32X32X2_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X1X16_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X256X16_WT32X32X2_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X256X16_WT32X32X2_WS1X2_WR2X2_TA1X1X1X8_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X8_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X8_1X16X1X16_TB1X1X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X8_1X16X1X16_TB1X1X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X8_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X8_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X128X16_WT32X32X2_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X128X16_WT32X32X2_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X128X16_WT32X32X2_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X128X16_WT32X32X2_WS2X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X16_1X16X1X16_TB1X1X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X16_1X16X1X16_TB1X1X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X16_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X1X1X16_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X16_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X128X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X128X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X128X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X128X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X2_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X256X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X16_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X256X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X16_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X256X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X256X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X32X32_WT16X16X4_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X1X4_1X32X1X8_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X32X32_WT16X16X4_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X1X4_1X32X1X8[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X32X32_WT16X16X4_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X1X4_1X32X1X8_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X32X32_WT16X16X4_WS1X1_WR1X1_TA1X1X1X4_1X32X1X8_TB1X1X1X4_1X32X1X8_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X64X16_WT16X16X4_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X64X16_WT16X16X4_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X64X16_WT16X16X4_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT32X64X16_WT16X16X4_WS1X1_WR1X2_TA1X1X1X2_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X4_1X16X1X16_TB1X1X1X8_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X4_1X16X1X16_TB1X1X1X8_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X4_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X1X1X4_1X16X1X16_TB1X1X1X8_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X1X16_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X1X16_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X1X1X4_1X16X1X16_TB1X1X1X16_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X1X1X4_1X16X1X16_TB1X1X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X1X1X4_1X16X1X16_TB1X1X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X1X1X4_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X1X1X4_1X16X1X16_TB1X1X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X64X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X4_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X64X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X4_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X64X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_WRW_GTCX_NHWC_FP32_BX0_EX1_BT64X64X16_WT32X32X2_WS1X1_WR1X1_TA1X1X1X4_1X16X1X16_TB1X1X1X4_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X32X8_WT64X16X4_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT128X64X8_WT32X32X4_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X128X8_WT64X32X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X256X32_WT32X32X8_WS2X2_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X16_WT64X16X4_WS1X1_WR2X1_TA1X8X2X1_1X2X1X128_TB1X2X1X1_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X8X4X1_1X4X1X64_TB1X2X1X2_1X16X1X16_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X2X1X2_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X4X1X2_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X1X4_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X1X2_1X4X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X1X2_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X1X4_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X4X2X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X4X1X2_1X8X1X16_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X1X2_1X8X1X32_MH_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP16_BX0_EX1_BT64X64X8_WT16X16X4_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX0_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X16_WT32X32X2_WS1X1_WR2X2_TA1X4X2X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X4_WT32X32X2_WS1X1_WR2X2_TA1X1X2X1_1X4X1X64_TB1X1X2X1_1X4X1X64_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X4_WT32X32X2_WS1X1_WR2X2_TA1X1X2X1_1X4X1X64_TB1X1X2X1_1X4X1X64_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X4_WT32X32X2_WS1X1_WR2X2_TA1X1X2X1_1X4X1X64_TB1X1X2X1_1X4X1X64_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X4_WT32X32X2_WS1X1_WR2X2_TA1X1X2X1_1X4X1X64_TB1X1X2X1_1X4X1X64_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X128X8_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X32_TB1X4X1X1_1X4X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X32_WT32X32X2_WS1X1_WR2X1_TA1X4X8X1_1X8X1X16_TB1X4X2X1_1X8X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X4_WT64X32X1_WS1X1_WR1X1_TA1X1X4X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X4_WT64X32X1_WS1X1_WR1X1_TA1X1X4X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X4_WT64X32X1_WS1X1_WR1X1_TA1X1X4X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X4_WT64X32X1_WS1X1_WR1X1_TA1X1X4X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X8_WT32X32X2_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X8_WT32X32X2_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X8_WT32X32X2_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X32X8_WT32X32X2_WS1X1_WR1X1_TA1X1X4X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR1X2_TA1X8X1X1_1X2X4X32_TB1X4X1X1_1X4X1X64_PTA_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X16_WT32X32X2_WS1X1_WR2X1_TA1X4X2X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X32_WT32X32X2_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X4X2X1_1X8X1X32_PTA_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X4_WT64X32X1_WS1X1_WR1X1_TA1X1X2X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X4_WT64X32X1_WS1X1_WR1X1_TA1X1X2X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X4_WT64X32X1_WS1X1_WR1X1_TA1X1X2X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X4_WT64X32X1_WS1X1_WR1X1_TA1X1X2X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT128X64X8_WT32X32X2_WS1X1_WR2X1_TA1X1X4X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT16X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X16_TB1X4X4X1_1X8X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X16_WT32X32X2_WS1X1_WR2X1_TA1X4X4X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X4_WT64X32X1_WS1X1_WR2X1_TA1X1X8X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X4_WT64X32X1_WS1X1_WR2X1_TA1X1X8X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X4_WT64X32X1_WS1X1_WR2X1_TA1X1X8X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X4_WT64X32X1_WS1X1_WR2X1_TA1X1X8X1_1X4X1X32_TB1X1X1X1_1X4X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X8_WT32X32X2_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X8_WT32X32X2_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X8_WT32X32X2_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X32X8_WT32X32X2_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X64X16_WT32X32X2_WS1X1_WR2X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X64X4_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X64X4_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X64X4_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT256X64X4_WT32X32X2_WS1X1_WR2X2_TA1X1X4X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT32X64X32_WT16X16X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X128X16_WT32X32X2_WS1X1_WR1X2_TA1X4X1X1_1X4X1X64_TB1X4X2X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X16X16_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X4X1X32_TB1X2X1X1_1X8X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X16X32_WT16X16X4_WS1X1_WR2X1_TA1X4X4X1_1X8X1X16_TB1X4X1X1_1X8X1X16_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X256X16_WT32X32X2_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X4X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X32X16_WT16X16X4_WS1X1_WR2X1_TA1X4X1X1_1X4X1X64_TB1X2X1X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X32X32_WT16X16X4_WS1X1_WR2X1_TA1X4X2X1_1X8X1X32_TB1X4X1X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X4X1X1_1X4X1X64_TB1X4X1X1_1X4X1X64_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X32_WT16X16X4_WS1X1_WR2X2_TA1X4X2X1_1X8X1X32_TB1X4X2X1_1X8X1X32_MH_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X4_WT16X16X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X4_WT16X16X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X4_WT16X16X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X4_WT16X16X1_WS1X1_WR2X2_TA1X1X1X1_1X4X1X64_TB1X1X1X1_1X4X1X64_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_BWD_GTCX2_NHWC_FP32_BX0_EX1_BT64X64X8_WT16X16X1_WS1X1_WR2X2_TA1X1X2X1_1X8X1X32_TB1X1X2X1_1X8X1X32_MH_ME_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X16_WT32X32X4_WS1X1_WR2X2_TA1X1X8X1_1X16X1X16_TB1X1X8X1_1X16X1X16_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X128X8_WT32X32X4_WS1X1_WR2X2_TA1X1X4X1_1X8X1X32_TB1X1X4X1_1X8X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X16_TB1X1X2X1_1X16X1X16_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X16_WT32X32X4_WS1X1_WR2X1_TA1X1X8X1_1X16X1X16_TB1X1X4X1_1X16X1X16_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X32X8_WT64X16X4_WS1X1_WR2X1_TA1X1X8X1_1X8X1X32_TB1X1X1X1_1X8X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT256X64X8_WT64X16X4_WS1X1_WR2X2_TA1X1X8X1_1X8X1X32_TB1X1X2X1_1X8X1X32_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X4X1_1X16X1X8_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X16_WT64X16X4_WS1X1_WR1X1_TA1X1X8X1_1X16X1X8_TB1X1X4X1_1X16X1X8_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_ME_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X16_WT16X16X4_WS1X1_WR2X2_TA1X1X4X1_1X16X1X16_TB1X1X4X1_1X16X1X16_ME[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_BF16_BX0_EX1_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X128X32_WT32X32X8_WS1X1_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X256X32_WT32X32X8_WS1X2_WR2X2_TA1X8X2X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X32X32_WT64X16X4_WS1X1_WR1X1_TA1X4X4X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X16X1X1_1X2X4X32_TB1X8X1X1_1X4X1X64_PTA_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT128X64X32_WT32X32X8_WS1X1_WR1X2_TA1X8X2X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X16_WT64X32X4_WS1X1_WR2X2_TA1X8X2X1_1X2X1X128_TB1X8X1X1_1X2X1X128_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X128X32_WT32X32X8_WS2X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X32X32_WT64X16X4_WS1X1_WR2X1_TA1X4X8X1_1X8X1X32_TB1X4X1X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X16_WT64X32X4_WS1X1_WR1X2_TA1X4X4X1_1X4X1X64_TB1X4X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT256X64X32_WT32X32X8_WS1X1_WR2X2_TA1X8X4X1_1X4X1X64_TB1X8X1X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X128X32_WT16X64X4_WS1X1_WR1X1_TA1X4X1X1_1X8X1X32_TB1X4X4X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X256X32_WT16X64X4_WS1X1_WR1X2_TA1X4X1X1_1X8X1X32_TB1X4X8X1_1X8X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT32X64X32_WT16X64X4_WS1X1_WR1X1_TA1X8X1X1_1X4X1X32_TB1X8X2X1_1X4X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X128X32_WT32X32X8_WS1X1_WR2X1_TA1X8X1X1_1X4X1X64_TB1X8X2X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X256X32_WT32X32X8_WS1X1_WR2X2_TA1X8X1X1_1X4X1X64_TB1X8X4X1_1X4X1X64_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X32X32_WT64X16X4_WS1X1_WR1X1_TA1X8X2X1_1X4X1X32_TB1X8X1X1_1X4X1X32_VS1_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_GKGS[];
extern const size_t MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT64X64X64_WT16X16X16_WS1X1_WR2X2_TA1X8X2X1_1X8X1X32_TB1X8X2X1_1X8X1X32_VS1_GKGS_SIZE;
extern const char MIOPEN_KERNEL_IGEMM_FWD_GTCX2_NHWC_FP16_BX0_EX0_BT