// python wrapper for vtkPResourceFileLocator
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPResourceFileLocator.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPResourceFileLocator(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPResourceFileLocator_ClassNew(); }


static PyObject *
PyvtkPResourceFileLocator_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPResourceFileLocator::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResourceFileLocator_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResourceFileLocator *op = static_cast<vtkPResourceFileLocator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPResourceFileLocator::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResourceFileLocator_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPResourceFileLocator *tempr = vtkPResourceFileLocator::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResourceFileLocator_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResourceFileLocator *op = static_cast<vtkPResourceFileLocator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPResourceFileLocator *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPResourceFileLocator::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResourceFileLocator_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPResourceFileLocator::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResourceFileLocator_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResourceFileLocator *op = static_cast<vtkPResourceFileLocator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPResourceFileLocator::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPResourceFileLocator_Locate_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Locate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResourceFileLocator *op = static_cast<vtkPResourceFileLocator *>(vp);

  std::string temp0;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  std::string temp2;
  std::string temp3 = std::string();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    std::string tempr = (ap.IsBound() ?
      op->Locate(temp0, temp1, temp2, temp3) :
      op->vtkPResourceFileLocator::Locate(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPResourceFileLocator_Locate_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Locate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPResourceFileLocator *op = static_cast<vtkPResourceFileLocator *>(vp);

  std::string temp0;
  std::string temp1;
  std::string temp2 = std::string();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    std::string tempr = (ap.IsBound() ?
      op->Locate(temp0, temp1, temp2) :
      op->vtkPResourceFileLocator::Locate(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPResourceFileLocator_Locate_Methods[] = {
  {"Locate", PyvtkPResourceFileLocator_Locate_s1, METH_VARARGS,
   "@sTs|s s"},
  {"Locate", PyvtkPResourceFileLocator_Locate_s2, METH_VARARGS,
   "@ss|s"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPResourceFileLocator_Locate(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPResourceFileLocator_Locate_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkPResourceFileLocator_Locate_s1(self, args);
    case 2:
      return PyvtkPResourceFileLocator_Locate_s2(self, args);
    case 3:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "Locate");
  return nullptr;
}

static PyMethodDef PyvtkPResourceFileLocator_Methods[] = {
  {"IsTypeOf", PyvtkPResourceFileLocator_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPResourceFileLocator_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPResourceFileLocator_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPResourceFileLocator\nC++: static vtkPResourceFileLocator *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPResourceFileLocator_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPResourceFileLocator\nC++: vtkPResourceFileLocator *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPResourceFileLocator_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPResourceFileLocator_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Locate", PyvtkPResourceFileLocator_Locate, METH_VARARGS,
   "Locate(self, anchor:str, landmark_prefixes:(str, ...),\n    landmark:str, defaultDir:str=...) -> str\nC++: std::string Locate(const std::string &anchor,\n    const std::vector<std::string> &landmark_prefixes,\n    const std::string &landmark,\n    const std::string &defaultDir=std::string()) override;\nLocate(self, anchor:str, landmark:str, defaultDir:str=...) -> str\nC++: virtual std::string Locate(const std::string &anchor,\n    const std::string &landmark,\n    const std::string &defaultDir=std::string())\n\nThis variant is used to look for landmark relative to the anchor\nusing additional prefixes for the landmark file. For example, if\nyou're looking for `vtk/__init__.py`, but it can be placed\nrelative to your anchor location (let's say the executable\ndirectory), under \"lib\" or \"lib/python\", then use this variant\nwith \"lib\", and \"lib/python\" passed in as the landmark prefixes.\nOn success, the returned value will be anchor + matching prefix.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPResourceFileLocator_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPResourceFileLocator_Doc =
  "vtkPResourceFileLocator - parallel aware vtkResourceFileLocator\n\n"
  "Superclass: vtkResourceFileLocator\n\n"
  "vtkPResourceFileLocator extends vtkResourceFileLocator to support\n"
  "distributed use-cases.\n\n"
  "vtkResourceFileLocator supports API to locate files on disk. When\n"
  "running in parallel, we don't want to the lookup to happen on all\n"
  "ranks, only the root node and the result to be shared with all ranks.\n"
  "vtkPResourceFileLocator overrides superclass API to handle that.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPResourceFileLocator_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPResourceFileLocator", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPResourceFileLocator_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPResourceFileLocator_StaticNew()
{
  return vtkPResourceFileLocator::New();
}

PyObject *PyvtkPResourceFileLocator_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPResourceFileLocator_Type, PyvtkPResourceFileLocator_Methods,
    "vtkPResourceFileLocator",
 &PyvtkPResourceFileLocator_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkResourceFileLocator");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPResourceFileLocator_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPResourceFileLocator(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPResourceFileLocator_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPResourceFileLocator", o) != 0)
  {
    Py_DECREF(o);
  }

}

