/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 170 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQRectF.cpp"

#line 110 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQRectF.cpp"
#line 114 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qsize.sip"
#include <qsize.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQRectF.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQRectF.cpp"
#line 90 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qmargins.sip"
#include <qmargins.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQRectF.cpp"


PyDoc_STRVAR(doc_QRectF_normalized, "normalized(self) -> QRectF");

extern "C" {static PyObject *meth_QRectF_normalized(PyObject *, PyObject *);}
static PyObject *meth_QRectF_normalized(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF(sipCpp->normalized());

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_normalized, doc_QRectF_normalized);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_left, "left(self) -> float");

extern "C" {static PyObject *meth_QRectF_left(PyObject *, PyObject *);}
static PyObject *meth_QRectF_left(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->left();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_left, doc_QRectF_left);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_top, "top(self) -> float");

extern "C" {static PyObject *meth_QRectF_top(PyObject *, PyObject *);}
static PyObject *meth_QRectF_top(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->top();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_top, doc_QRectF_top);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_right, "right(self) -> float");

extern "C" {static PyObject *meth_QRectF_right(PyObject *, PyObject *);}
static PyObject *meth_QRectF_right(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->right();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_right, doc_QRectF_right);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_bottom, "bottom(self) -> float");

extern "C" {static PyObject *meth_QRectF_bottom(PyObject *, PyObject *);}
static PyObject *meth_QRectF_bottom(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->bottom();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_bottom, doc_QRectF_bottom);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setX, "setX(self, pos: float)");

extern "C" {static PyObject *meth_QRectF_setX(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->setX(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setX, doc_QRectF_setX);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setY, "setY(self, pos: float)");

extern "C" {static PyObject *meth_QRectF_setY(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->setY(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setY, doc_QRectF_setY);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_topLeft, "topLeft(self) -> QPointF");

extern "C" {static PyObject *meth_QRectF_topLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_topLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->topLeft());

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_topLeft, doc_QRectF_topLeft);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_bottomRight, "bottomRight(self) -> QPointF");

extern "C" {static PyObject *meth_QRectF_bottomRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_bottomRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->bottomRight());

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_bottomRight, doc_QRectF_bottomRight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_topRight, "topRight(self) -> QPointF");

extern "C" {static PyObject *meth_QRectF_topRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_topRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->topRight());

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_topRight, doc_QRectF_topRight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_bottomLeft, "bottomLeft(self) -> QPointF");

extern "C" {static PyObject *meth_QRectF_bottomLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_bottomLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->bottomLeft());

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_bottomLeft, doc_QRectF_bottomLeft);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_contains, "contains(self, p: QPointF) -> bool\n"
"contains(self, r: QRectF) -> bool\n"
"contains(self, ax: float, ay: float) -> bool");

extern "C" {static PyObject *meth_QRectF_contains(PyObject *, PyObject *);}
static PyObject *meth_QRectF_contains(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->contains(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QRectF* a0;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QRectF, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->contains(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        ::qreal a0;
        ::qreal a1;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdd", &sipSelf, sipType_QRectF, &sipCpp, &a0, &a1))
        {
            bool sipRes;

            sipRes = sipCpp->contains(a0, a1);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_contains, doc_QRectF_contains);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_intersects, "intersects(self, r: QRectF) -> bool");

extern "C" {static PyObject *meth_QRectF_intersects(PyObject *, PyObject *);}
static PyObject *meth_QRectF_intersects(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF* a0;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QRectF, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->intersects(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_intersects, doc_QRectF_intersects);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QRectF_isNull(PyObject *, PyObject *);}
static PyObject *meth_QRectF_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_isNull, doc_QRectF_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_isEmpty, "isEmpty(self) -> bool");

extern "C" {static PyObject *meth_QRectF_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QRectF_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isEmpty();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_isEmpty, doc_QRectF_isEmpty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QRectF_isValid(PyObject *, PyObject *);}
static PyObject *meth_QRectF_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_isValid, doc_QRectF_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_x, "x(self) -> float");

extern "C" {static PyObject *meth_QRectF_x(PyObject *, PyObject *);}
static PyObject *meth_QRectF_x(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->x();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_x, doc_QRectF_x);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_y, "y(self) -> float");

extern "C" {static PyObject *meth_QRectF_y(PyObject *, PyObject *);}
static PyObject *meth_QRectF_y(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->y();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_y, doc_QRectF_y);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setLeft, "setLeft(self, pos: float)");

extern "C" {static PyObject *meth_QRectF_setLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->setLeft(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setLeft, doc_QRectF_setLeft);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setRight, "setRight(self, pos: float)");

extern "C" {static PyObject *meth_QRectF_setRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->setRight(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setRight, doc_QRectF_setRight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setTop, "setTop(self, pos: float)");

extern "C" {static PyObject *meth_QRectF_setTop(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setTop(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->setTop(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setTop, doc_QRectF_setTop);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setBottom, "setBottom(self, pos: float)");

extern "C" {static PyObject *meth_QRectF_setBottom(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setBottom(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->setBottom(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setBottom, doc_QRectF_setBottom);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setTopLeft, "setTopLeft(self, p: QPointF)");

extern "C" {static PyObject *meth_QRectF_setTopLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setTopLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->setTopLeft(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setTopLeft, doc_QRectF_setTopLeft);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setTopRight, "setTopRight(self, p: QPointF)");

extern "C" {static PyObject *meth_QRectF_setTopRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setTopRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->setTopRight(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setTopRight, doc_QRectF_setTopRight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setBottomLeft, "setBottomLeft(self, p: QPointF)");

extern "C" {static PyObject *meth_QRectF_setBottomLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setBottomLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->setBottomLeft(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setBottomLeft, doc_QRectF_setBottomLeft);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setBottomRight, "setBottomRight(self, p: QPointF)");

extern "C" {static PyObject *meth_QRectF_setBottomRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setBottomRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->setBottomRight(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setBottomRight, doc_QRectF_setBottomRight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_center, "center(self) -> QPointF");

extern "C" {static PyObject *meth_QRectF_center(PyObject *, PyObject *);}
static PyObject *meth_QRectF_center(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->center());

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_center, doc_QRectF_center);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_moveLeft, "moveLeft(self, pos: float)");

extern "C" {static PyObject *meth_QRectF_moveLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->moveLeft(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_moveLeft, doc_QRectF_moveLeft);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_moveTop, "moveTop(self, pos: float)");

extern "C" {static PyObject *meth_QRectF_moveTop(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveTop(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->moveTop(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_moveTop, doc_QRectF_moveTop);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_moveRight, "moveRight(self, pos: float)");

extern "C" {static PyObject *meth_QRectF_moveRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->moveRight(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_moveRight, doc_QRectF_moveRight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_moveBottom, "moveBottom(self, pos: float)");

extern "C" {static PyObject *meth_QRectF_moveBottom(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveBottom(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->moveBottom(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_moveBottom, doc_QRectF_moveBottom);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_moveTopLeft, "moveTopLeft(self, p: QPointF)");

extern "C" {static PyObject *meth_QRectF_moveTopLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveTopLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->moveTopLeft(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_moveTopLeft, doc_QRectF_moveTopLeft);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_moveTopRight, "moveTopRight(self, p: QPointF)");

extern "C" {static PyObject *meth_QRectF_moveTopRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveTopRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->moveTopRight(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_moveTopRight, doc_QRectF_moveTopRight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_moveBottomLeft, "moveBottomLeft(self, p: QPointF)");

extern "C" {static PyObject *meth_QRectF_moveBottomLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveBottomLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->moveBottomLeft(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_moveBottomLeft, doc_QRectF_moveBottomLeft);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_moveBottomRight, "moveBottomRight(self, p: QPointF)");

extern "C" {static PyObject *meth_QRectF_moveBottomRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveBottomRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->moveBottomRight(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_moveBottomRight, doc_QRectF_moveBottomRight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_moveCenter, "moveCenter(self, p: QPointF)");

extern "C" {static PyObject *meth_QRectF_moveCenter(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveCenter(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->moveCenter(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_moveCenter, doc_QRectF_moveCenter);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_width, "width(self) -> float");

extern "C" {static PyObject *meth_QRectF_width(PyObject *, PyObject *);}
static PyObject *meth_QRectF_width(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->width();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_width, doc_QRectF_width);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_height, "height(self) -> float");

extern "C" {static PyObject *meth_QRectF_height(PyObject *, PyObject *);}
static PyObject *meth_QRectF_height(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->height();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_height, doc_QRectF_height);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_size, "size(self) -> QSizeF");

extern "C" {static PyObject *meth_QRectF_size(PyObject *, PyObject *);}
static PyObject *meth_QRectF_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::QSizeF*sipRes;

            sipRes = new ::QSizeF(sipCpp->size());

            return sipConvertFromNewType(sipRes, sipType_QSizeF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_size, doc_QRectF_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_translate, "translate(self, dx: float, dy: float)\n"
"translate(self, p: QPointF)");

extern "C" {static PyObject *meth_QRectF_translate(PyObject *, PyObject *);}
static PyObject *meth_QRectF_translate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdd", &sipSelf, sipType_QRectF, &sipCpp, &a0, &a1))
        {
            sipCpp->translate(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::QPointF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->translate(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_translate, doc_QRectF_translate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_moveTo, "moveTo(self, ax: float, ay: float)\n"
"moveTo(self, p: QPointF)");

extern "C" {static PyObject *meth_QRectF_moveTo(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdd", &sipSelf, sipType_QRectF, &sipCpp, &a0, &a1))
        {
            sipCpp->moveTo(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::QPointF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->moveTo(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_moveTo, doc_QRectF_moveTo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_translated, "translated(self, dx: float, dy: float) -> QRectF\n"
"translated(self, p: QPointF) -> QRectF");

extern "C" {static PyObject *meth_QRectF_translated(PyObject *, PyObject *);}
static PyObject *meth_QRectF_translated(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdd", &sipSelf, sipType_QRectF, &sipCpp, &a0, &a1))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF(sipCpp->translated(a0, a1));

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    {
        const ::QPointF* a0;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QPointF, &a0))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF(sipCpp->translated(*a0));

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_translated, doc_QRectF_translated);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_getRect, "getRect(self) -> (float, float, float, float)");

extern "C" {static PyObject *meth_QRectF_getRect(PyObject *, PyObject *);}
static PyObject *meth_QRectF_getRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        ::qreal a2;
        ::qreal a3;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            sipCpp->getRect(&a0, &a1, &a2, &a3);

            return sipBuildResult(0, "(dddd)", a0, a1, a2, a3);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_getRect, doc_QRectF_getRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setRect, "setRect(self, ax: float, ay: float, aaw: float, aah: float)");

extern "C" {static PyObject *meth_QRectF_setRect(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        ::qreal a2;
        ::qreal a3;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdddd", &sipSelf, sipType_QRectF, &sipCpp, &a0, &a1, &a2, &a3))
        {
            sipCpp->setRect(a0, a1, a2, a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setRect, doc_QRectF_setRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_getCoords, "getCoords(self) -> (float, float, float, float)");

extern "C" {static PyObject *meth_QRectF_getCoords(PyObject *, PyObject *);}
static PyObject *meth_QRectF_getCoords(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        ::qreal a2;
        ::qreal a3;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            sipCpp->getCoords(&a0, &a1, &a2, &a3);

            return sipBuildResult(0, "(dddd)", a0, a1, a2, a3);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_getCoords, doc_QRectF_getCoords);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setCoords, "setCoords(self, xp1: float, yp1: float, xp2: float, yp2: float)");

extern "C" {static PyObject *meth_QRectF_setCoords(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setCoords(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        ::qreal a2;
        ::qreal a3;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdddd", &sipSelf, sipType_QRectF, &sipCpp, &a0, &a1, &a2, &a3))
        {
            sipCpp->setCoords(a0, a1, a2, a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setCoords, doc_QRectF_setCoords);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_adjust, "adjust(self, xp1: float, yp1: float, xp2: float, yp2: float)");

extern "C" {static PyObject *meth_QRectF_adjust(PyObject *, PyObject *);}
static PyObject *meth_QRectF_adjust(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        ::qreal a2;
        ::qreal a3;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdddd", &sipSelf, sipType_QRectF, &sipCpp, &a0, &a1, &a2, &a3))
        {
            sipCpp->adjust(a0, a1, a2, a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_adjust, doc_QRectF_adjust);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_adjusted, "adjusted(self, xp1: float, yp1: float, xp2: float, yp2: float) -> QRectF");

extern "C" {static PyObject *meth_QRectF_adjusted(PyObject *, PyObject *);}
static PyObject *meth_QRectF_adjusted(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::qreal a1;
        ::qreal a2;
        ::qreal a3;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdddd", &sipSelf, sipType_QRectF, &sipCpp, &a0, &a1, &a2, &a3))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF(sipCpp->adjusted(a0, a1, a2, a3));

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_adjusted, doc_QRectF_adjusted);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setWidth, "setWidth(self, aw: float)");

extern "C" {static PyObject *meth_QRectF_setWidth(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->setWidth(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setWidth, doc_QRectF_setWidth);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setHeight, "setHeight(self, ah: float)");

extern "C" {static PyObject *meth_QRectF_setHeight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QRectF, &sipCpp, &a0))
        {
            sipCpp->setHeight(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setHeight, doc_QRectF_setHeight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_setSize, "setSize(self, s: QSizeF)");

extern "C" {static PyObject *meth_QRectF_setSize(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSizeF* a0;
        ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QSizeF, &a0))
        {
            sipCpp->setSize(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_setSize, doc_QRectF_setSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_intersected, "intersected(self, r: QRectF) -> QRectF");

extern "C" {static PyObject *meth_QRectF_intersected(PyObject *, PyObject *);}
static PyObject *meth_QRectF_intersected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF* a0;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QRectF, &a0))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF(sipCpp->intersected(*a0));

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_intersected, doc_QRectF_intersected);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_united, "united(self, r: QRectF) -> QRectF");

extern "C" {static PyObject *meth_QRectF_united(PyObject *, PyObject *);}
static PyObject *meth_QRectF_united(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF* a0;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QRectF, &a0))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF(sipCpp->united(*a0));

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_united, doc_QRectF_united);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_toAlignedRect, "toAlignedRect(self) -> QRect");

extern "C" {static PyObject *meth_QRectF_toAlignedRect(PyObject *, PyObject *);}
static PyObject *meth_QRectF_toAlignedRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::QRect*sipRes;

            sipRes = new ::QRect(sipCpp->toAlignedRect());

            return sipConvertFromNewType(sipRes, sipType_QRect, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_toAlignedRect, doc_QRectF_toAlignedRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_toRect, "toRect(self) -> QRect");

extern "C" {static PyObject *meth_QRectF_toRect(PyObject *, PyObject *);}
static PyObject *meth_QRectF_toRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::QRect*sipRes;

            sipRes = new ::QRect(sipCpp->toRect());

            return sipConvertFromNewType(sipRes, sipType_QRect, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_toRect, doc_QRectF_toRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_marginsAdded, "marginsAdded(self, margins: QMarginsF) -> QRectF");

extern "C" {static PyObject *meth_QRectF_marginsAdded(PyObject *, PyObject *);}
static PyObject *meth_QRectF_marginsAdded(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMarginsF* a0;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QMarginsF, &a0))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF(sipCpp->marginsAdded(*a0));

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_marginsAdded, doc_QRectF_marginsAdded);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_marginsRemoved, "marginsRemoved(self, margins: QMarginsF) -> QRectF");

extern "C" {static PyObject *meth_QRectF_marginsRemoved(PyObject *, PyObject *);}
static PyObject *meth_QRectF_marginsRemoved(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMarginsF* a0;
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QRectF, &sipCpp, sipType_QMarginsF, &a0))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF(sipCpp->marginsRemoved(*a0));

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_marginsRemoved, doc_QRectF_marginsRemoved);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QRectF_transposed, "transposed(self) -> QRectF");

extern "C" {static PyObject *meth_QRectF_transposed(PyObject *, PyObject *);}
static PyObject *meth_QRectF_transposed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QRectF, &sipCpp))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF(sipCpp->transposed());

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName_transposed, doc_QRectF_transposed);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QRectF___eq__(PyObject *, PyObject *);}
static PyObject *slot_QRectF___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QRectF *sipCpp = reinterpret_cast< ::QRectF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QRectF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRect* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QRect, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QRectF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QRectF, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, eq_slot, sipType_QRectF, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QRectF___ne__(PyObject *, PyObject *);}
static PyObject *slot_QRectF___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QRectF *sipCpp = reinterpret_cast< ::QRectF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QRectF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRect* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QRect, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QRectF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QRectF, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, ne_slot, sipType_QRectF, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QRectF___add__(PyObject *, PyObject *);}
static PyObject *slot_QRectF___add__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF* a0;
        const ::QMarginsF* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QRectF, &a0, sipType_QMarginsF, &a1))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF((*a0 + *a1));

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QRectF___sub__(PyObject *, PyObject *);}
static PyObject *slot_QRectF___sub__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF* a0;
        const ::QMarginsF* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QRectF, &a0, sipType_QMarginsF, &a1))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF((*a0 - *a1));

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QRectF___isub__(PyObject *, PyObject *);}
static PyObject *slot_QRectF___isub__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QRectF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QRectF *sipCpp = reinterpret_cast< ::QRectF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QRectF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMarginsF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QMarginsF, &a0))
        {
            sipCpp->::QRectF::operator-=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QRectF___iadd__(PyObject *, PyObject *);}
static PyObject *slot_QRectF___iadd__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QRectF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QRectF *sipCpp = reinterpret_cast< ::QRectF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QRectF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMarginsF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QMarginsF, &a0))
        {
            sipCpp->::QRectF::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QRectF___iand__(PyObject *, PyObject *);}
static PyObject *slot_QRectF___iand__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QRectF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QRectF *sipCpp = reinterpret_cast< ::QRectF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QRectF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QRectF, &a0))
        {
            sipCpp->::QRectF::operator&=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QRectF___ior__(PyObject *, PyObject *);}
static PyObject *slot_QRectF___ior__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QRectF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QRectF *sipCpp = reinterpret_cast< ::QRectF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QRectF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QRectF, &a0))
        {
            sipCpp->::QRectF::operator|=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static int slot_QRectF___bool__(PyObject *);}
static int slot_QRectF___bool__(PyObject *sipSelf)
{
    ::QRectF *sipCpp = reinterpret_cast< ::QRectF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QRectF));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 238 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qrect.sip"
        sipRes = sipCpp->isValid();
#line 1969 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQRectF.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static int slot_QRectF___contains__(PyObject *, PyObject *);}
static int slot_QRectF___contains__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QRectF *sipCpp = reinterpret_cast< ::QRectF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QRectF));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPointF, &a0))
        {
            int sipRes = 0;

#line 223 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qrect.sip"
        sipRes = sipCpp->contains(*a0);
#line 1998 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQRectF.cpp"

            return sipRes;
        }
    }

    {
        const ::QRectF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QRectF, &a0))
        {
            int sipRes = 0;

#line 229 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qrect.sip"
        sipRes = sipCpp->contains(*a0);
#line 2013 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQRectF.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QRectF, sipName___contains__, SIP_NULLPTR);

    return -1;
}


extern "C" {static PyObject *slot_QRectF___and__(PyObject *, PyObject *);}
static PyObject *slot_QRectF___and__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QRectF* a0;
        const ::QRectF* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QRectF, &a0, sipType_QRectF, &a1))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF((*a0 & *a1));

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, and_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QRectF___or__(PyObject *, PyObject *);}
static PyObject *slot_QRectF___or__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QRectF* a0;
        const ::QRectF* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QRectF, &a0, sipType_QRectF, &a1))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF((*a0 | *a1));

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, or_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QRectF___repr__(PyObject *);}
static PyObject *slot_QRectF___repr__(PyObject *sipSelf)
{
    ::QRectF *sipCpp = reinterpret_cast< ::QRectF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QRectF));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 185 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qrect.sip"
        if (sipCpp->isNull())
        {
            sipRes = PyUnicode_FromString("PyQt6.QtCore.QRectF()");
        }
        else
        {
            PyObject *l = PyFloat_FromDouble(sipCpp->left());
            PyObject *t = PyFloat_FromDouble(sipCpp->top());
            PyObject *w = PyFloat_FromDouble(sipCpp->width());
            PyObject *h = PyFloat_FromDouble(sipCpp->height());
        
            if (l && t && w && h)
                sipRes = PyUnicode_FromFormat(
                        "PyQt6.QtCore.QRectF(%R, %R, %R, %R)", l, t, w, h);
        
            Py_XDECREF(l);
            Py_XDECREF(t);
            Py_XDECREF(w);
            Py_XDECREF(h);
        }
#line 2115 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQRectF.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QRectF(void *, int);}
static void release_QRectF(void *sipCppV, int)
{
    delete reinterpret_cast< ::QRectF *>(sipCppV);
}


extern "C" {static PyObject *pickle_QRectF(void *);}
static PyObject *pickle_QRectF(void *sipCppV)
{
    ::QRectF *sipCpp = reinterpret_cast< ::QRectF *>(sipCppV);
    PyObject *sipRes;

#line 174 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qrect.sip"
    sipRes = Py_BuildValue("dddd", sipCpp->x(), sipCpp->y(), sipCpp->width(), sipCpp->height());
#line 2141 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQRectF.cpp"

    return sipRes;
}


extern "C" {static void *array_QRectF(Py_ssize_t);}
static void *array_QRectF(Py_ssize_t sipNrElem)
{
    return new ::QRectF[sipNrElem];
}


extern "C" {static void array_delete_QRectF(void *);}
static void array_delete_QRectF(void *sipCpp)
{
    delete[] reinterpret_cast< ::QRectF *>(sipCpp);
}


extern "C" {static void assign_QRectF(void *, Py_ssize_t, void *);}
static void assign_QRectF(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QRectF *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QRectF *>(sipSrc);
}


extern "C" {static void *copy_QRectF(const void *, Py_ssize_t);}
static void *copy_QRectF(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QRectF(reinterpret_cast<const ::QRectF *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QRectF(sipSimpleWrapper *);}
static void dealloc_QRectF(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QRectF(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QRectF(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QRectF(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QRectF *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QRectF();

            return sipCpp;
        }
    }

    {
        const ::QPointF* a0;
        const ::QSizeF* a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J9", sipType_QPointF, &a0, sipType_QSizeF, &a1))
        {
            sipCpp = new ::QRectF(*a0, *a1);

            return sipCpp;
        }
    }

    {
        const ::QPointF* a0;
        const ::QPointF* a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J9", sipType_QPointF, &a0, sipType_QPointF, &a1))
        {
            sipCpp = new ::QRectF(*a0, *a1);

            return sipCpp;
        }
    }

    {
        ::qreal a0;
        ::qreal a1;
        ::qreal a2;
        ::qreal a3;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "dddd", &a0, &a1, &a2, &a3))
        {
            sipCpp = new ::QRectF(a0, a1, a2, a3);

            return sipCpp;
        }
    }

    {
        const ::QRect* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QRect, &a0))
        {
            sipCpp = new ::QRectF(*a0);

            return sipCpp;
        }
    }

    {
        const ::QRectF* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QRectF, &a0))
        {
            sipCpp = new ::QRectF(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QRectF[] = {
    {(void *)slot_QRectF___eq__, eq_slot},
    {(void *)slot_QRectF___ne__, ne_slot},
    {(void *)slot_QRectF___add__, add_slot},
    {(void *)slot_QRectF___sub__, sub_slot},
    {(void *)slot_QRectF___isub__, isub_slot},
    {(void *)slot_QRectF___iadd__, iadd_slot},
    {(void *)slot_QRectF___iand__, iand_slot},
    {(void *)slot_QRectF___ior__, ior_slot},
    {(void *)slot_QRectF___bool__, bool_slot},
    {(void *)slot_QRectF___contains__, contains_slot},
    {(void *)slot_QRectF___and__, and_slot},
    {(void *)slot_QRectF___or__, or_slot},
    {(void *)slot_QRectF___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QRectF[] = {
    {sipName_adjust, meth_QRectF_adjust, METH_VARARGS, doc_QRectF_adjust},
    {sipName_adjusted, meth_QRectF_adjusted, METH_VARARGS, doc_QRectF_adjusted},
    {sipName_bottom, meth_QRectF_bottom, METH_VARARGS, doc_QRectF_bottom},
    {sipName_bottomLeft, meth_QRectF_bottomLeft, METH_VARARGS, doc_QRectF_bottomLeft},
    {sipName_bottomRight, meth_QRectF_bottomRight, METH_VARARGS, doc_QRectF_bottomRight},
    {sipName_center, meth_QRectF_center, METH_VARARGS, doc_QRectF_center},
    {sipName_contains, meth_QRectF_contains, METH_VARARGS, doc_QRectF_contains},
    {sipName_getCoords, meth_QRectF_getCoords, METH_VARARGS, doc_QRectF_getCoords},
    {sipName_getRect, meth_QRectF_getRect, METH_VARARGS, doc_QRectF_getRect},
    {sipName_height, meth_QRectF_height, METH_VARARGS, doc_QRectF_height},
    {sipName_intersected, meth_QRectF_intersected, METH_VARARGS, doc_QRectF_intersected},
    {sipName_intersects, meth_QRectF_intersects, METH_VARARGS, doc_QRectF_intersects},
    {sipName_isEmpty, meth_QRectF_isEmpty, METH_VARARGS, doc_QRectF_isEmpty},
    {sipName_isNull, meth_QRectF_isNull, METH_VARARGS, doc_QRectF_isNull},
    {sipName_isValid, meth_QRectF_isValid, METH_VARARGS, doc_QRectF_isValid},
    {sipName_left, meth_QRectF_left, METH_VARARGS, doc_QRectF_left},
    {sipName_marginsAdded, meth_QRectF_marginsAdded, METH_VARARGS, doc_QRectF_marginsAdded},
    {sipName_marginsRemoved, meth_QRectF_marginsRemoved, METH_VARARGS, doc_QRectF_marginsRemoved},
    {sipName_moveBottom, meth_QRectF_moveBottom, METH_VARARGS, doc_QRectF_moveBottom},
    {sipName_moveBottomLeft, meth_QRectF_moveBottomLeft, METH_VARARGS, doc_QRectF_moveBottomLeft},
    {sipName_moveBottomRight, meth_QRectF_moveBottomRight, METH_VARARGS, doc_QRectF_moveBottomRight},
    {sipName_moveCenter, meth_QRectF_moveCenter, METH_VARARGS, doc_QRectF_moveCenter},
    {sipName_moveLeft, meth_QRectF_moveLeft, METH_VARARGS, doc_QRectF_moveLeft},
    {sipName_moveRight, meth_QRectF_moveRight, METH_VARARGS, doc_QRectF_moveRight},
    {sipName_moveTo, meth_QRectF_moveTo, METH_VARARGS, doc_QRectF_moveTo},
    {sipName_moveTop, meth_QRectF_moveTop, METH_VARARGS, doc_QRectF_moveTop},
    {sipName_moveTopLeft, meth_QRectF_moveTopLeft, METH_VARARGS, doc_QRectF_moveTopLeft},
    {sipName_moveTopRight, meth_QRectF_moveTopRight, METH_VARARGS, doc_QRectF_moveTopRight},
    {sipName_normalized, meth_QRectF_normalized, METH_VARARGS, doc_QRectF_normalized},
    {sipName_right, meth_QRectF_right, METH_VARARGS, doc_QRectF_right},
    {sipName_setBottom, meth_QRectF_setBottom, METH_VARARGS, doc_QRectF_setBottom},
    {sipName_setBottomLeft, meth_QRectF_setBottomLeft, METH_VARARGS, doc_QRectF_setBottomLeft},
    {sipName_setBottomRight, meth_QRectF_setBottomRight, METH_VARARGS, doc_QRectF_setBottomRight},
    {sipName_setCoords, meth_QRectF_setCoords, METH_VARARGS, doc_QRectF_setCoords},
    {sipName_setHeight, meth_QRectF_setHeight, METH_VARARGS, doc_QRectF_setHeight},
    {sipName_setLeft, meth_QRectF_setLeft, METH_VARARGS, doc_QRectF_setLeft},
    {sipName_setRect, meth_QRectF_setRect, METH_VARARGS, doc_QRectF_setRect},
    {sipName_setRight, meth_QRectF_setRight, METH_VARARGS, doc_QRectF_setRight},
    {sipName_setSize, meth_QRectF_setSize, METH_VARARGS, doc_QRectF_setSize},
    {sipName_setTop, meth_QRectF_setTop, METH_VARARGS, doc_QRectF_setTop},
    {sipName_setTopLeft, meth_QRectF_setTopLeft, METH_VARARGS, doc_QRectF_setTopLeft},
    {sipName_setTopRight, meth_QRectF_setTopRight, METH_VARARGS, doc_QRectF_setTopRight},
    {sipName_setWidth, meth_QRectF_setWidth, METH_VARARGS, doc_QRectF_setWidth},
    {sipName_setX, meth_QRectF_setX, METH_VARARGS, doc_QRectF_setX},
    {sipName_setY, meth_QRectF_setY, METH_VARARGS, doc_QRectF_setY},
    {sipName_size, meth_QRectF_size, METH_VARARGS, doc_QRectF_size},
    {sipName_toAlignedRect, meth_QRectF_toAlignedRect, METH_VARARGS, doc_QRectF_toAlignedRect},
    {sipName_toRect, meth_QRectF_toRect, METH_VARARGS, doc_QRectF_toRect},
    {sipName_top, meth_QRectF_top, METH_VARARGS, doc_QRectF_top},
    {sipName_topLeft, meth_QRectF_topLeft, METH_VARARGS, doc_QRectF_topLeft},
    {sipName_topRight, meth_QRectF_topRight, METH_VARARGS, doc_QRectF_topRight},
    {sipName_translate, meth_QRectF_translate, METH_VARARGS, doc_QRectF_translate},
    {sipName_translated, meth_QRectF_translated, METH_VARARGS, doc_QRectF_translated},
    {sipName_transposed, meth_QRectF_transposed, METH_VARARGS, doc_QRectF_transposed},
    {sipName_united, meth_QRectF_united, METH_VARARGS, doc_QRectF_united},
    {sipName_width, meth_QRectF_width, METH_VARARGS, doc_QRectF_width},
    {sipName_x, meth_QRectF_x, METH_VARARGS, doc_QRectF_x},
    {sipName_y, meth_QRectF_y, METH_VARARGS, doc_QRectF_y}
};

PyDoc_STRVAR(doc_QRectF, "\1QRectF()\n"
"QRectF(atopLeft: QPointF, asize: QSizeF)\n"
"QRectF(atopLeft: QPointF, abottomRight: QPointF)\n"
"QRectF(aleft: float, atop: float, awidth: float, aheight: float)\n"
"QRectF(r: QRect)\n"
"QRectF(a0: QRectF)");


sipClassTypeDef sipTypeDef_QtCore_QRectF = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QRectF,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QRectF,
        {0, 0, 1},
        58, methods_QRectF,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QRectF,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QRectF,
    init_type_QRectF,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QRectF,
    assign_QRectF,
    array_QRectF,
    copy_QRectF,
    release_QRectF,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QRectF,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QRectF,
    sizeof (::QRectF),
};
